/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/fms/FMSClient.h>
#include <aws/fms/FMSEndpointProvider.h>
#include <aws/fms/FMSEndpointRules.h>
#include <aws/fms/FMSErrorMarshaller.h>
#include <aws/fms/FMSErrors.h>
#include <aws/fms/FMSRequest.h>
#include <aws/fms/FMSServiceClientModel.h>
#include <aws/fms/FMS_EXPORTS.h>
#include <aws/fms/model/AccountRoleStatus.h>
#include <aws/fms/model/AccountScope.h>
#include <aws/fms/model/ActionTarget.h>
#include <aws/fms/model/AdminAccountSummary.h>
#include <aws/fms/model/AdminScope.h>
#include <aws/fms/model/App.h>
#include <aws/fms/model/AppsListData.h>
#include <aws/fms/model/AppsListDataSummary.h>
#include <aws/fms/model/AssociateAdminAccountRequest.h>
#include <aws/fms/model/AssociateThirdPartyFirewallRequest.h>
#include <aws/fms/model/AssociateThirdPartyFirewallResult.h>
#include <aws/fms/model/AwsEc2InstanceViolation.h>
#include <aws/fms/model/AwsEc2NetworkInterfaceViolation.h>
#include <aws/fms/model/AwsVPCSecurityGroupViolation.h>
#include <aws/fms/model/BatchAssociateResourceRequest.h>
#include <aws/fms/model/BatchAssociateResourceResult.h>
#include <aws/fms/model/BatchDisassociateResourceRequest.h>
#include <aws/fms/model/BatchDisassociateResourceResult.h>
#include <aws/fms/model/ComplianceViolator.h>
#include <aws/fms/model/CreateNetworkAclAction.h>
#include <aws/fms/model/CreateNetworkAclEntriesAction.h>
#include <aws/fms/model/CustomerPolicyScopeIdType.h>
#include <aws/fms/model/CustomerPolicyStatus.h>
#include <aws/fms/model/DeleteAppsListRequest.h>
#include <aws/fms/model/DeleteNetworkAclEntriesAction.h>
#include <aws/fms/model/DeleteNotificationChannelRequest.h>
#include <aws/fms/model/DeletePolicyRequest.h>
#include <aws/fms/model/DeleteProtocolsListRequest.h>
#include <aws/fms/model/DeleteResourceSetRequest.h>
#include <aws/fms/model/DependentServiceName.h>
#include <aws/fms/model/DestinationType.h>
#include <aws/fms/model/DisassociateAdminAccountRequest.h>
#include <aws/fms/model/DisassociateThirdPartyFirewallRequest.h>
#include <aws/fms/model/DisassociateThirdPartyFirewallResult.h>
#include <aws/fms/model/DiscoveredResource.h>
#include <aws/fms/model/DnsDuplicateRuleGroupViolation.h>
#include <aws/fms/model/DnsRuleGroupLimitExceededViolation.h>
#include <aws/fms/model/DnsRuleGroupPriorityConflictViolation.h>
#include <aws/fms/model/EC2AssociateRouteTableAction.h>
#include <aws/fms/model/EC2CopyRouteTableAction.h>
#include <aws/fms/model/EC2CreateRouteAction.h>
#include <aws/fms/model/EC2CreateRouteTableAction.h>
#include <aws/fms/model/EC2DeleteRouteAction.h>
#include <aws/fms/model/EC2ReplaceRouteAction.h>
#include <aws/fms/model/EC2ReplaceRouteTableAssociationAction.h>
#include <aws/fms/model/EntryDescription.h>
#include <aws/fms/model/EntryType.h>
#include <aws/fms/model/EntryViolation.h>
#include <aws/fms/model/EntryViolationReason.h>
#include <aws/fms/model/EvaluationResult.h>
#include <aws/fms/model/ExpectedRoute.h>
#include <aws/fms/model/FMSPolicyUpdateFirewallCreationConfigAction.h>
#include <aws/fms/model/FailedItem.h>
#include <aws/fms/model/FailedItemReason.h>
#include <aws/fms/model/FirewallDeploymentModel.h>
#include <aws/fms/model/FirewallSubnetIsOutOfScopeViolation.h>
#include <aws/fms/model/FirewallSubnetMissingVPCEndpointViolation.h>
#include <aws/fms/model/GetAdminAccountRequest.h>
#include <aws/fms/model/GetAdminAccountResult.h>
#include <aws/fms/model/GetAdminScopeRequest.h>
#include <aws/fms/model/GetAdminScopeResult.h>
#include <aws/fms/model/GetAppsListRequest.h>
#include <aws/fms/model/GetAppsListResult.h>
#include <aws/fms/model/GetComplianceDetailRequest.h>
#include <aws/fms/model/GetComplianceDetailResult.h>
#include <aws/fms/model/GetNotificationChannelRequest.h>
#include <aws/fms/model/GetNotificationChannelResult.h>
#include <aws/fms/model/GetPolicyRequest.h>
#include <aws/fms/model/GetPolicyResult.h>
#include <aws/fms/model/GetProtectionStatusRequest.h>
#include <aws/fms/model/GetProtectionStatusResult.h>
#include <aws/fms/model/GetProtocolsListRequest.h>
#include <aws/fms/model/GetProtocolsListResult.h>
#include <aws/fms/model/GetResourceSetRequest.h>
#include <aws/fms/model/GetResourceSetResult.h>
#include <aws/fms/model/GetThirdPartyFirewallAssociationStatusRequest.h>
#include <aws/fms/model/GetThirdPartyFirewallAssociationStatusResult.h>
#include <aws/fms/model/GetViolationDetailsRequest.h>
#include <aws/fms/model/GetViolationDetailsResult.h>
#include <aws/fms/model/InvalidNetworkAclEntriesViolation.h>
#include <aws/fms/model/ListAdminAccountsForOrganizationRequest.h>
#include <aws/fms/model/ListAdminAccountsForOrganizationResult.h>
#include <aws/fms/model/ListAdminsManagingAccountRequest.h>
#include <aws/fms/model/ListAdminsManagingAccountResult.h>
#include <aws/fms/model/ListAppsListsRequest.h>
#include <aws/fms/model/ListAppsListsResult.h>
#include <aws/fms/model/ListComplianceStatusRequest.h>
#include <aws/fms/model/ListComplianceStatusResult.h>
#include <aws/fms/model/ListDiscoveredResourcesRequest.h>
#include <aws/fms/model/ListDiscoveredResourcesResult.h>
#include <aws/fms/model/ListMemberAccountsRequest.h>
#include <aws/fms/model/ListMemberAccountsResult.h>
#include <aws/fms/model/ListPoliciesRequest.h>
#include <aws/fms/model/ListPoliciesResult.h>
#include <aws/fms/model/ListProtocolsListsRequest.h>
#include <aws/fms/model/ListProtocolsListsResult.h>
#include <aws/fms/model/ListResourceSetResourcesRequest.h>
#include <aws/fms/model/ListResourceSetResourcesResult.h>
#include <aws/fms/model/ListResourceSetsRequest.h>
#include <aws/fms/model/ListResourceSetsResult.h>
#include <aws/fms/model/ListTagsForResourceRequest.h>
#include <aws/fms/model/ListTagsForResourceResult.h>
#include <aws/fms/model/ListThirdPartyFirewallFirewallPoliciesRequest.h>
#include <aws/fms/model/ListThirdPartyFirewallFirewallPoliciesResult.h>
#include <aws/fms/model/MarketplaceSubscriptionOnboardingStatus.h>
#include <aws/fms/model/NetworkAclCommonPolicy.h>
#include <aws/fms/model/NetworkAclEntry.h>
#include <aws/fms/model/NetworkAclEntrySet.h>
#include <aws/fms/model/NetworkAclIcmpTypeCode.h>
#include <aws/fms/model/NetworkAclPortRange.h>
#include <aws/fms/model/NetworkAclRuleAction.h>
#include <aws/fms/model/NetworkFirewallBlackHoleRouteDetectedViolation.h>
#include <aws/fms/model/NetworkFirewallInternetTrafficNotInspectedViolation.h>
#include <aws/fms/model/NetworkFirewallInvalidRouteConfigurationViolation.h>
#include <aws/fms/model/NetworkFirewallMissingExpectedRTViolation.h>
#include <aws/fms/model/NetworkFirewallMissingExpectedRoutesViolation.h>
#include <aws/fms/model/NetworkFirewallMissingFirewallViolation.h>
#include <aws/fms/model/NetworkFirewallMissingSubnetViolation.h>
#include <aws/fms/model/NetworkFirewallOverrideAction.h>
#include <aws/fms/model/NetworkFirewallPolicy.h>
#include <aws/fms/model/NetworkFirewallPolicyDescription.h>
#include <aws/fms/model/NetworkFirewallPolicyModifiedViolation.h>
#include <aws/fms/model/NetworkFirewallStatefulRuleGroupOverride.h>
#include <aws/fms/model/NetworkFirewallUnexpectedFirewallRoutesViolation.h>
#include <aws/fms/model/NetworkFirewallUnexpectedGatewayRoutesViolation.h>
#include <aws/fms/model/OrganizationStatus.h>
#include <aws/fms/model/OrganizationalUnitScope.h>
#include <aws/fms/model/PartialMatch.h>
#include <aws/fms/model/Policy.h>
#include <aws/fms/model/PolicyComplianceDetail.h>
#include <aws/fms/model/PolicyComplianceStatus.h>
#include <aws/fms/model/PolicyComplianceStatusType.h>
#include <aws/fms/model/PolicyOption.h>
#include <aws/fms/model/PolicySummary.h>
#include <aws/fms/model/PolicyTypeScope.h>
#include <aws/fms/model/PossibleRemediationAction.h>
#include <aws/fms/model/PossibleRemediationActions.h>
#include <aws/fms/model/ProtocolsListData.h>
#include <aws/fms/model/ProtocolsListDataSummary.h>
#include <aws/fms/model/PutAdminAccountRequest.h>
#include <aws/fms/model/PutAppsListRequest.h>
#include <aws/fms/model/PutAppsListResult.h>
#include <aws/fms/model/PutNotificationChannelRequest.h>
#include <aws/fms/model/PutPolicyRequest.h>
#include <aws/fms/model/PutPolicyResult.h>
#include <aws/fms/model/PutProtocolsListRequest.h>
#include <aws/fms/model/PutProtocolsListResult.h>
#include <aws/fms/model/PutResourceSetRequest.h>
#include <aws/fms/model/PutResourceSetResult.h>
#include <aws/fms/model/RegionScope.h>
#include <aws/fms/model/RemediationAction.h>
#include <aws/fms/model/RemediationActionType.h>
#include <aws/fms/model/RemediationActionWithOrder.h>
#include <aws/fms/model/ReplaceNetworkAclAssociationAction.h>
#include <aws/fms/model/Resource.h>
#include <aws/fms/model/ResourceSet.h>
#include <aws/fms/model/ResourceSetStatus.h>
#include <aws/fms/model/ResourceSetSummary.h>
#include <aws/fms/model/ResourceTag.h>
#include <aws/fms/model/ResourceTagLogicalOperator.h>
#include <aws/fms/model/ResourceViolation.h>
#include <aws/fms/model/Route.h>
#include <aws/fms/model/RouteHasOutOfScopeEndpointViolation.h>
#include <aws/fms/model/RuleOrder.h>
#include <aws/fms/model/SecurityGroupRemediationAction.h>
#include <aws/fms/model/SecurityGroupRuleDescription.h>
#include <aws/fms/model/SecurityServicePolicyData.h>
#include <aws/fms/model/SecurityServiceType.h>
#include <aws/fms/model/StatefulEngineOptions.h>
#include <aws/fms/model/StatefulRuleGroup.h>
#include <aws/fms/model/StatelessRuleGroup.h>
#include <aws/fms/model/StreamExceptionPolicy.h>
#include <aws/fms/model/Tag.h>
#include <aws/fms/model/TagResourceRequest.h>
#include <aws/fms/model/TagResourceResult.h>
#include <aws/fms/model/TargetType.h>
#include <aws/fms/model/ThirdPartyFirewall.h>
#include <aws/fms/model/ThirdPartyFirewallAssociationStatus.h>
#include <aws/fms/model/ThirdPartyFirewallFirewallPolicy.h>
#include <aws/fms/model/ThirdPartyFirewallMissingExpectedRouteTableViolation.h>
#include <aws/fms/model/ThirdPartyFirewallMissingFirewallViolation.h>
#include <aws/fms/model/ThirdPartyFirewallMissingSubnetViolation.h>
#include <aws/fms/model/ThirdPartyFirewallPolicy.h>
#include <aws/fms/model/UntagResourceRequest.h>
#include <aws/fms/model/UntagResourceResult.h>
#include <aws/fms/model/ViolationDetail.h>
#include <aws/fms/model/ViolationReason.h>
#include <aws/fms/model/WebACLHasIncompatibleConfigurationViolation.h>
#include <aws/fms/model/WebACLHasOutOfScopeResourcesViolation.h>

using FMSIncludeTest = ::testing::Test;

TEST_F(FMSIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::FMS::FMSClient>("FMSIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
