/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/forecast/ForecastServiceClient.h>
#include <aws/forecast/ForecastServiceEndpointProvider.h>
#include <aws/forecast/ForecastServiceEndpointRules.h>
#include <aws/forecast/ForecastServiceErrorMarshaller.h>
#include <aws/forecast/ForecastServiceErrors.h>
#include <aws/forecast/ForecastServiceRequest.h>
#include <aws/forecast/ForecastServiceServiceClientModel.h>
#include <aws/forecast/ForecastService_EXPORTS.h>
#include <aws/forecast/model/Action.h>
#include <aws/forecast/model/AdditionalDataset.h>
#include <aws/forecast/model/AttributeConfig.h>
#include <aws/forecast/model/AttributeType.h>
#include <aws/forecast/model/AutoMLOverrideStrategy.h>
#include <aws/forecast/model/Baseline.h>
#include <aws/forecast/model/BaselineMetric.h>
#include <aws/forecast/model/CategoricalParameterRange.h>
#include <aws/forecast/model/Condition.h>
#include <aws/forecast/model/ContinuousParameterRange.h>
#include <aws/forecast/model/CreateAutoPredictorRequest.h>
#include <aws/forecast/model/CreateAutoPredictorResult.h>
#include <aws/forecast/model/CreateDatasetGroupRequest.h>
#include <aws/forecast/model/CreateDatasetGroupResult.h>
#include <aws/forecast/model/CreateDatasetImportJobRequest.h>
#include <aws/forecast/model/CreateDatasetImportJobResult.h>
#include <aws/forecast/model/CreateDatasetRequest.h>
#include <aws/forecast/model/CreateDatasetResult.h>
#include <aws/forecast/model/CreateExplainabilityExportRequest.h>
#include <aws/forecast/model/CreateExplainabilityExportResult.h>
#include <aws/forecast/model/CreateExplainabilityRequest.h>
#include <aws/forecast/model/CreateExplainabilityResult.h>
#include <aws/forecast/model/CreateForecastExportJobRequest.h>
#include <aws/forecast/model/CreateForecastExportJobResult.h>
#include <aws/forecast/model/CreateForecastRequest.h>
#include <aws/forecast/model/CreateForecastResult.h>
#include <aws/forecast/model/CreateMonitorRequest.h>
#include <aws/forecast/model/CreateMonitorResult.h>
#include <aws/forecast/model/CreatePredictorBacktestExportJobRequest.h>
#include <aws/forecast/model/CreatePredictorBacktestExportJobResult.h>
#include <aws/forecast/model/CreatePredictorRequest.h>
#include <aws/forecast/model/CreatePredictorResult.h>
#include <aws/forecast/model/CreateWhatIfAnalysisRequest.h>
#include <aws/forecast/model/CreateWhatIfAnalysisResult.h>
#include <aws/forecast/model/CreateWhatIfForecastExportRequest.h>
#include <aws/forecast/model/CreateWhatIfForecastExportResult.h>
#include <aws/forecast/model/CreateWhatIfForecastRequest.h>
#include <aws/forecast/model/CreateWhatIfForecastResult.h>
#include <aws/forecast/model/DataConfig.h>
#include <aws/forecast/model/DataDestination.h>
#include <aws/forecast/model/DataSource.h>
#include <aws/forecast/model/DatasetGroupSummary.h>
#include <aws/forecast/model/DatasetImportJobSummary.h>
#include <aws/forecast/model/DatasetSummary.h>
#include <aws/forecast/model/DatasetType.h>
#include <aws/forecast/model/DayOfWeek.h>
#include <aws/forecast/model/DeleteDatasetGroupRequest.h>
#include <aws/forecast/model/DeleteDatasetImportJobRequest.h>
#include <aws/forecast/model/DeleteDatasetRequest.h>
#include <aws/forecast/model/DeleteExplainabilityExportRequest.h>
#include <aws/forecast/model/DeleteExplainabilityRequest.h>
#include <aws/forecast/model/DeleteForecastExportJobRequest.h>
#include <aws/forecast/model/DeleteForecastRequest.h>
#include <aws/forecast/model/DeleteMonitorRequest.h>
#include <aws/forecast/model/DeletePredictorBacktestExportJobRequest.h>
#include <aws/forecast/model/DeletePredictorRequest.h>
#include <aws/forecast/model/DeleteResourceTreeRequest.h>
#include <aws/forecast/model/DeleteWhatIfAnalysisRequest.h>
#include <aws/forecast/model/DeleteWhatIfForecastExportRequest.h>
#include <aws/forecast/model/DeleteWhatIfForecastRequest.h>
#include <aws/forecast/model/DescribeAutoPredictorRequest.h>
#include <aws/forecast/model/DescribeAutoPredictorResult.h>
#include <aws/forecast/model/DescribeDatasetGroupRequest.h>
#include <aws/forecast/model/DescribeDatasetGroupResult.h>
#include <aws/forecast/model/DescribeDatasetImportJobRequest.h>
#include <aws/forecast/model/DescribeDatasetImportJobResult.h>
#include <aws/forecast/model/DescribeDatasetRequest.h>
#include <aws/forecast/model/DescribeDatasetResult.h>
#include <aws/forecast/model/DescribeExplainabilityExportRequest.h>
#include <aws/forecast/model/DescribeExplainabilityExportResult.h>
#include <aws/forecast/model/DescribeExplainabilityRequest.h>
#include <aws/forecast/model/DescribeExplainabilityResult.h>
#include <aws/forecast/model/DescribeForecastExportJobRequest.h>
#include <aws/forecast/model/DescribeForecastExportJobResult.h>
#include <aws/forecast/model/DescribeForecastRequest.h>
#include <aws/forecast/model/DescribeForecastResult.h>
#include <aws/forecast/model/DescribeMonitorRequest.h>
#include <aws/forecast/model/DescribeMonitorResult.h>
#include <aws/forecast/model/DescribePredictorBacktestExportJobRequest.h>
#include <aws/forecast/model/DescribePredictorBacktestExportJobResult.h>
#include <aws/forecast/model/DescribePredictorRequest.h>
#include <aws/forecast/model/DescribePredictorResult.h>
#include <aws/forecast/model/DescribeWhatIfAnalysisRequest.h>
#include <aws/forecast/model/DescribeWhatIfAnalysisResult.h>
#include <aws/forecast/model/DescribeWhatIfForecastExportRequest.h>
#include <aws/forecast/model/DescribeWhatIfForecastExportResult.h>
#include <aws/forecast/model/DescribeWhatIfForecastRequest.h>
#include <aws/forecast/model/DescribeWhatIfForecastResult.h>
#include <aws/forecast/model/Domain.h>
#include <aws/forecast/model/EncryptionConfig.h>
#include <aws/forecast/model/ErrorMetric.h>
#include <aws/forecast/model/EvaluationParameters.h>
#include <aws/forecast/model/EvaluationResult.h>
#include <aws/forecast/model/EvaluationType.h>
#include <aws/forecast/model/ExplainabilityConfig.h>
#include <aws/forecast/model/ExplainabilityExportSummary.h>
#include <aws/forecast/model/ExplainabilityInfo.h>
#include <aws/forecast/model/ExplainabilitySummary.h>
#include <aws/forecast/model/Featurization.h>
#include <aws/forecast/model/FeaturizationConfig.h>
#include <aws/forecast/model/FeaturizationMethod.h>
#include <aws/forecast/model/FeaturizationMethodName.h>
#include <aws/forecast/model/Filter.h>
#include <aws/forecast/model/FilterConditionString.h>
#include <aws/forecast/model/ForecastExportJobSummary.h>
#include <aws/forecast/model/ForecastSummary.h>
#include <aws/forecast/model/GetAccuracyMetricsRequest.h>
#include <aws/forecast/model/GetAccuracyMetricsResult.h>
#include <aws/forecast/model/HyperParameterTuningJobConfig.h>
#include <aws/forecast/model/ImportMode.h>
#include <aws/forecast/model/InputDataConfig.h>
#include <aws/forecast/model/IntegerParameterRange.h>
#include <aws/forecast/model/ListDatasetGroupsRequest.h>
#include <aws/forecast/model/ListDatasetGroupsResult.h>
#include <aws/forecast/model/ListDatasetImportJobsRequest.h>
#include <aws/forecast/model/ListDatasetImportJobsResult.h>
#include <aws/forecast/model/ListDatasetsRequest.h>
#include <aws/forecast/model/ListDatasetsResult.h>
#include <aws/forecast/model/ListExplainabilitiesRequest.h>
#include <aws/forecast/model/ListExplainabilitiesResult.h>
#include <aws/forecast/model/ListExplainabilityExportsRequest.h>
#include <aws/forecast/model/ListExplainabilityExportsResult.h>
#include <aws/forecast/model/ListForecastExportJobsRequest.h>
#include <aws/forecast/model/ListForecastExportJobsResult.h>
#include <aws/forecast/model/ListForecastsRequest.h>
#include <aws/forecast/model/ListForecastsResult.h>
#include <aws/forecast/model/ListMonitorEvaluationsRequest.h>
#include <aws/forecast/model/ListMonitorEvaluationsResult.h>
#include <aws/forecast/model/ListMonitorsRequest.h>
#include <aws/forecast/model/ListMonitorsResult.h>
#include <aws/forecast/model/ListPredictorBacktestExportJobsRequest.h>
#include <aws/forecast/model/ListPredictorBacktestExportJobsResult.h>
#include <aws/forecast/model/ListPredictorsRequest.h>
#include <aws/forecast/model/ListPredictorsResult.h>
#include <aws/forecast/model/ListTagsForResourceRequest.h>
#include <aws/forecast/model/ListTagsForResourceResult.h>
#include <aws/forecast/model/ListWhatIfAnalysesRequest.h>
#include <aws/forecast/model/ListWhatIfAnalysesResult.h>
#include <aws/forecast/model/ListWhatIfForecastExportsRequest.h>
#include <aws/forecast/model/ListWhatIfForecastExportsResult.h>
#include <aws/forecast/model/ListWhatIfForecastsRequest.h>
#include <aws/forecast/model/ListWhatIfForecastsResult.h>
#include <aws/forecast/model/MetricResult.h>
#include <aws/forecast/model/Metrics.h>
#include <aws/forecast/model/MonitorConfig.h>
#include <aws/forecast/model/MonitorDataSource.h>
#include <aws/forecast/model/MonitorInfo.h>
#include <aws/forecast/model/MonitorSummary.h>
#include <aws/forecast/model/Month.h>
#include <aws/forecast/model/Operation.h>
#include <aws/forecast/model/OptimizationMetric.h>
#include <aws/forecast/model/ParameterRanges.h>
#include <aws/forecast/model/PredictorBacktestExportJobSummary.h>
#include <aws/forecast/model/PredictorBaseline.h>
#include <aws/forecast/model/PredictorEvent.h>
#include <aws/forecast/model/PredictorExecution.h>
#include <aws/forecast/model/PredictorExecutionDetails.h>
#include <aws/forecast/model/PredictorMonitorEvaluation.h>
#include <aws/forecast/model/PredictorSummary.h>
#include <aws/forecast/model/ReferencePredictorSummary.h>
#include <aws/forecast/model/ResumeResourceRequest.h>
#include <aws/forecast/model/S3Config.h>
#include <aws/forecast/model/ScalingType.h>
#include <aws/forecast/model/Schema.h>
#include <aws/forecast/model/SchemaAttribute.h>
#include <aws/forecast/model/State.h>
#include <aws/forecast/model/Statistics.h>
#include <aws/forecast/model/StopResourceRequest.h>
#include <aws/forecast/model/SupplementaryFeature.h>
#include <aws/forecast/model/Tag.h>
#include <aws/forecast/model/TagResourceRequest.h>
#include <aws/forecast/model/TagResourceResult.h>
#include <aws/forecast/model/TestWindowSummary.h>
#include <aws/forecast/model/TimeAlignmentBoundary.h>
#include <aws/forecast/model/TimePointGranularity.h>
#include <aws/forecast/model/TimeSeriesCondition.h>
#include <aws/forecast/model/TimeSeriesGranularity.h>
#include <aws/forecast/model/TimeSeriesIdentifiers.h>
#include <aws/forecast/model/TimeSeriesReplacementsDataSource.h>
#include <aws/forecast/model/TimeSeriesSelector.h>
#include <aws/forecast/model/TimeSeriesTransformation.h>
#include <aws/forecast/model/UntagResourceRequest.h>
#include <aws/forecast/model/UntagResourceResult.h>
#include <aws/forecast/model/UpdateDatasetGroupRequest.h>
#include <aws/forecast/model/UpdateDatasetGroupResult.h>
#include <aws/forecast/model/WeightedQuantileLoss.h>
#include <aws/forecast/model/WhatIfAnalysisSummary.h>
#include <aws/forecast/model/WhatIfForecastExportSummary.h>
#include <aws/forecast/model/WhatIfForecastSummary.h>
#include <aws/forecast/model/WindowSummary.h>

using ForecastServiceIncludeTest = ::testing::Test;

TEST_F(ForecastServiceIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::ForecastService::ForecastServiceClient>("ForecastServiceIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
