/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/frauddetector/FraudDetectorClient.h>
#include <aws/frauddetector/FraudDetectorEndpointProvider.h>
#include <aws/frauddetector/FraudDetectorEndpointRules.h>
#include <aws/frauddetector/FraudDetectorErrorMarshaller.h>
#include <aws/frauddetector/FraudDetectorErrors.h>
#include <aws/frauddetector/FraudDetectorRequest.h>
#include <aws/frauddetector/FraudDetectorServiceClientModel.h>
#include <aws/frauddetector/FraudDetector_EXPORTS.h>
#include <aws/frauddetector/model/ATIMetricDataPoint.h>
#include <aws/frauddetector/model/ATIModelPerformance.h>
#include <aws/frauddetector/model/ATITrainingMetricsValue.h>
#include <aws/frauddetector/model/AggregatedLogOddsMetric.h>
#include <aws/frauddetector/model/AggregatedVariablesImpactExplanation.h>
#include <aws/frauddetector/model/AggregatedVariablesImportanceMetrics.h>
#include <aws/frauddetector/model/AllowDenyList.h>
#include <aws/frauddetector/model/AsyncJobStatus.h>
#include <aws/frauddetector/model/BatchCreateVariableError.h>
#include <aws/frauddetector/model/BatchCreateVariableRequest.h>
#include <aws/frauddetector/model/BatchCreateVariableResult.h>
#include <aws/frauddetector/model/BatchGetVariableError.h>
#include <aws/frauddetector/model/BatchGetVariableRequest.h>
#include <aws/frauddetector/model/BatchGetVariableResult.h>
#include <aws/frauddetector/model/BatchImport.h>
#include <aws/frauddetector/model/BatchPrediction.h>
#include <aws/frauddetector/model/CancelBatchImportJobRequest.h>
#include <aws/frauddetector/model/CancelBatchImportJobResult.h>
#include <aws/frauddetector/model/CancelBatchPredictionJobRequest.h>
#include <aws/frauddetector/model/CancelBatchPredictionJobResult.h>
#include <aws/frauddetector/model/CreateBatchImportJobRequest.h>
#include <aws/frauddetector/model/CreateBatchImportJobResult.h>
#include <aws/frauddetector/model/CreateBatchPredictionJobRequest.h>
#include <aws/frauddetector/model/CreateBatchPredictionJobResult.h>
#include <aws/frauddetector/model/CreateDetectorVersionRequest.h>
#include <aws/frauddetector/model/CreateDetectorVersionResult.h>
#include <aws/frauddetector/model/CreateListRequest.h>
#include <aws/frauddetector/model/CreateListResult.h>
#include <aws/frauddetector/model/CreateModelRequest.h>
#include <aws/frauddetector/model/CreateModelResult.h>
#include <aws/frauddetector/model/CreateModelVersionRequest.h>
#include <aws/frauddetector/model/CreateModelVersionResult.h>
#include <aws/frauddetector/model/CreateRuleRequest.h>
#include <aws/frauddetector/model/CreateRuleResult.h>
#include <aws/frauddetector/model/CreateVariableRequest.h>
#include <aws/frauddetector/model/CreateVariableResult.h>
#include <aws/frauddetector/model/DataSource.h>
#include <aws/frauddetector/model/DataType.h>
#include <aws/frauddetector/model/DataValidationMetrics.h>
#include <aws/frauddetector/model/DeleteBatchImportJobRequest.h>
#include <aws/frauddetector/model/DeleteBatchImportJobResult.h>
#include <aws/frauddetector/model/DeleteBatchPredictionJobRequest.h>
#include <aws/frauddetector/model/DeleteBatchPredictionJobResult.h>
#include <aws/frauddetector/model/DeleteDetectorRequest.h>
#include <aws/frauddetector/model/DeleteDetectorResult.h>
#include <aws/frauddetector/model/DeleteDetectorVersionRequest.h>
#include <aws/frauddetector/model/DeleteDetectorVersionResult.h>
#include <aws/frauddetector/model/DeleteEntityTypeRequest.h>
#include <aws/frauddetector/model/DeleteEntityTypeResult.h>
#include <aws/frauddetector/model/DeleteEventRequest.h>
#include <aws/frauddetector/model/DeleteEventResult.h>
#include <aws/frauddetector/model/DeleteEventTypeRequest.h>
#include <aws/frauddetector/model/DeleteEventTypeResult.h>
#include <aws/frauddetector/model/DeleteEventsByEventTypeRequest.h>
#include <aws/frauddetector/model/DeleteEventsByEventTypeResult.h>
#include <aws/frauddetector/model/DeleteExternalModelRequest.h>
#include <aws/frauddetector/model/DeleteExternalModelResult.h>
#include <aws/frauddetector/model/DeleteLabelRequest.h>
#include <aws/frauddetector/model/DeleteLabelResult.h>
#include <aws/frauddetector/model/DeleteListRequest.h>
#include <aws/frauddetector/model/DeleteListResult.h>
#include <aws/frauddetector/model/DeleteModelRequest.h>
#include <aws/frauddetector/model/DeleteModelResult.h>
#include <aws/frauddetector/model/DeleteModelVersionRequest.h>
#include <aws/frauddetector/model/DeleteModelVersionResult.h>
#include <aws/frauddetector/model/DeleteOutcomeRequest.h>
#include <aws/frauddetector/model/DeleteOutcomeResult.h>
#include <aws/frauddetector/model/DeleteRuleRequest.h>
#include <aws/frauddetector/model/DeleteRuleResult.h>
#include <aws/frauddetector/model/DeleteVariableRequest.h>
#include <aws/frauddetector/model/DeleteVariableResult.h>
#include <aws/frauddetector/model/DescribeDetectorRequest.h>
#include <aws/frauddetector/model/DescribeDetectorResult.h>
#include <aws/frauddetector/model/DescribeModelVersionsRequest.h>
#include <aws/frauddetector/model/DescribeModelVersionsResult.h>
#include <aws/frauddetector/model/Detector.h>
#include <aws/frauddetector/model/DetectorVersionStatus.h>
#include <aws/frauddetector/model/DetectorVersionSummary.h>
#include <aws/frauddetector/model/Entity.h>
#include <aws/frauddetector/model/EntityType.h>
#include <aws/frauddetector/model/EvaluatedExternalModel.h>
#include <aws/frauddetector/model/EvaluatedModelVersion.h>
#include <aws/frauddetector/model/EvaluatedRule.h>
#include <aws/frauddetector/model/Event.h>
#include <aws/frauddetector/model/EventIngestion.h>
#include <aws/frauddetector/model/EventOrchestration.h>
#include <aws/frauddetector/model/EventPredictionSummary.h>
#include <aws/frauddetector/model/EventType.h>
#include <aws/frauddetector/model/EventVariableSummary.h>
#include <aws/frauddetector/model/ExternalEventsDetail.h>
#include <aws/frauddetector/model/ExternalModel.h>
#include <aws/frauddetector/model/ExternalModelOutputs.h>
#include <aws/frauddetector/model/ExternalModelSummary.h>
#include <aws/frauddetector/model/FieldValidationMessage.h>
#include <aws/frauddetector/model/FileValidationMessage.h>
#include <aws/frauddetector/model/FilterCondition.h>
#include <aws/frauddetector/model/GetBatchImportJobsRequest.h>
#include <aws/frauddetector/model/GetBatchImportJobsResult.h>
#include <aws/frauddetector/model/GetBatchPredictionJobsRequest.h>
#include <aws/frauddetector/model/GetBatchPredictionJobsResult.h>
#include <aws/frauddetector/model/GetDeleteEventsByEventTypeStatusRequest.h>
#include <aws/frauddetector/model/GetDeleteEventsByEventTypeStatusResult.h>
#include <aws/frauddetector/model/GetDetectorVersionRequest.h>
#include <aws/frauddetector/model/GetDetectorVersionResult.h>
#include <aws/frauddetector/model/GetDetectorsRequest.h>
#include <aws/frauddetector/model/GetDetectorsResult.h>
#include <aws/frauddetector/model/GetEntityTypesRequest.h>
#include <aws/frauddetector/model/GetEntityTypesResult.h>
#include <aws/frauddetector/model/GetEventPredictionMetadataRequest.h>
#include <aws/frauddetector/model/GetEventPredictionMetadataResult.h>
#include <aws/frauddetector/model/GetEventPredictionRequest.h>
#include <aws/frauddetector/model/GetEventPredictionResult.h>
#include <aws/frauddetector/model/GetEventRequest.h>
#include <aws/frauddetector/model/GetEventResult.h>
#include <aws/frauddetector/model/GetEventTypesRequest.h>
#include <aws/frauddetector/model/GetEventTypesResult.h>
#include <aws/frauddetector/model/GetExternalModelsRequest.h>
#include <aws/frauddetector/model/GetExternalModelsResult.h>
#include <aws/frauddetector/model/GetKMSEncryptionKeyRequest.h>
#include <aws/frauddetector/model/GetKMSEncryptionKeyResult.h>
#include <aws/frauddetector/model/GetLabelsRequest.h>
#include <aws/frauddetector/model/GetLabelsResult.h>
#include <aws/frauddetector/model/GetListElementsRequest.h>
#include <aws/frauddetector/model/GetListElementsResult.h>
#include <aws/frauddetector/model/GetListsMetadataRequest.h>
#include <aws/frauddetector/model/GetListsMetadataResult.h>
#include <aws/frauddetector/model/GetModelVersionRequest.h>
#include <aws/frauddetector/model/GetModelVersionResult.h>
#include <aws/frauddetector/model/GetModelsRequest.h>
#include <aws/frauddetector/model/GetModelsResult.h>
#include <aws/frauddetector/model/GetOutcomesRequest.h>
#include <aws/frauddetector/model/GetOutcomesResult.h>
#include <aws/frauddetector/model/GetRulesRequest.h>
#include <aws/frauddetector/model/GetRulesResult.h>
#include <aws/frauddetector/model/GetVariablesRequest.h>
#include <aws/frauddetector/model/GetVariablesResult.h>
#include <aws/frauddetector/model/IngestedEventStatistics.h>
#include <aws/frauddetector/model/IngestedEventsDetail.h>
#include <aws/frauddetector/model/IngestedEventsTimeWindow.h>
#include <aws/frauddetector/model/KMSKey.h>
#include <aws/frauddetector/model/Label.h>
#include <aws/frauddetector/model/LabelSchema.h>
#include <aws/frauddetector/model/Language.h>
#include <aws/frauddetector/model/ListEventPredictionsRequest.h>
#include <aws/frauddetector/model/ListEventPredictionsResult.h>
#include <aws/frauddetector/model/ListTagsForResourceRequest.h>
#include <aws/frauddetector/model/ListTagsForResourceResult.h>
#include <aws/frauddetector/model/ListUpdateMode.h>
#include <aws/frauddetector/model/LogOddsMetric.h>
#include <aws/frauddetector/model/MetricDataPoint.h>
#include <aws/frauddetector/model/Model.h>
#include <aws/frauddetector/model/ModelEndpointDataBlob.h>
#include <aws/frauddetector/model/ModelEndpointStatus.h>
#include <aws/frauddetector/model/ModelInputConfiguration.h>
#include <aws/frauddetector/model/ModelInputDataFormat.h>
#include <aws/frauddetector/model/ModelOutputConfiguration.h>
#include <aws/frauddetector/model/ModelOutputDataFormat.h>
#include <aws/frauddetector/model/ModelScores.h>
#include <aws/frauddetector/model/ModelSource.h>
#include <aws/frauddetector/model/ModelTypeEnum.h>
#include <aws/frauddetector/model/ModelVersion.h>
#include <aws/frauddetector/model/ModelVersionDetail.h>
#include <aws/frauddetector/model/ModelVersionEvaluation.h>
#include <aws/frauddetector/model/ModelVersionStatus.h>
#include <aws/frauddetector/model/OFIMetricDataPoint.h>
#include <aws/frauddetector/model/OFIModelPerformance.h>
#include <aws/frauddetector/model/OFITrainingMetricsValue.h>
#include <aws/frauddetector/model/Outcome.h>
#include <aws/frauddetector/model/PredictionExplanations.h>
#include <aws/frauddetector/model/PredictionTimeRange.h>
#include <aws/frauddetector/model/PutDetectorRequest.h>
#include <aws/frauddetector/model/PutDetectorResult.h>
#include <aws/frauddetector/model/PutEntityTypeRequest.h>
#include <aws/frauddetector/model/PutEntityTypeResult.h>
#include <aws/frauddetector/model/PutEventTypeRequest.h>
#include <aws/frauddetector/model/PutEventTypeResult.h>
#include <aws/frauddetector/model/PutExternalModelRequest.h>
#include <aws/frauddetector/model/PutExternalModelResult.h>
#include <aws/frauddetector/model/PutKMSEncryptionKeyRequest.h>
#include <aws/frauddetector/model/PutKMSEncryptionKeyResult.h>
#include <aws/frauddetector/model/PutLabelRequest.h>
#include <aws/frauddetector/model/PutLabelResult.h>
#include <aws/frauddetector/model/PutOutcomeRequest.h>
#include <aws/frauddetector/model/PutOutcomeResult.h>
#include <aws/frauddetector/model/Rule.h>
#include <aws/frauddetector/model/RuleDetail.h>
#include <aws/frauddetector/model/RuleExecutionMode.h>
#include <aws/frauddetector/model/RuleResult.h>
#include <aws/frauddetector/model/SendEventRequest.h>
#include <aws/frauddetector/model/SendEventResult.h>
#include <aws/frauddetector/model/TFIMetricDataPoint.h>
#include <aws/frauddetector/model/TFIModelPerformance.h>
#include <aws/frauddetector/model/TFITrainingMetricsValue.h>
#include <aws/frauddetector/model/Tag.h>
#include <aws/frauddetector/model/TagResourceRequest.h>
#include <aws/frauddetector/model/TagResourceResult.h>
#include <aws/frauddetector/model/TrainingDataSchema.h>
#include <aws/frauddetector/model/TrainingDataSourceEnum.h>
#include <aws/frauddetector/model/TrainingMetrics.h>
#include <aws/frauddetector/model/TrainingMetricsV2.h>
#include <aws/frauddetector/model/TrainingResult.h>
#include <aws/frauddetector/model/TrainingResultV2.h>
#include <aws/frauddetector/model/UncertaintyRange.h>
#include <aws/frauddetector/model/UnlabeledEventsTreatment.h>
#include <aws/frauddetector/model/UntagResourceRequest.h>
#include <aws/frauddetector/model/UntagResourceResult.h>
#include <aws/frauddetector/model/UpdateDetectorVersionMetadataRequest.h>
#include <aws/frauddetector/model/UpdateDetectorVersionMetadataResult.h>
#include <aws/frauddetector/model/UpdateDetectorVersionRequest.h>
#include <aws/frauddetector/model/UpdateDetectorVersionResult.h>
#include <aws/frauddetector/model/UpdateDetectorVersionStatusRequest.h>
#include <aws/frauddetector/model/UpdateDetectorVersionStatusResult.h>
#include <aws/frauddetector/model/UpdateEventLabelRequest.h>
#include <aws/frauddetector/model/UpdateEventLabelResult.h>
#include <aws/frauddetector/model/UpdateListRequest.h>
#include <aws/frauddetector/model/UpdateListResult.h>
#include <aws/frauddetector/model/UpdateModelRequest.h>
#include <aws/frauddetector/model/UpdateModelResult.h>
#include <aws/frauddetector/model/UpdateModelVersionRequest.h>
#include <aws/frauddetector/model/UpdateModelVersionResult.h>
#include <aws/frauddetector/model/UpdateModelVersionStatusRequest.h>
#include <aws/frauddetector/model/UpdateModelVersionStatusResult.h>
#include <aws/frauddetector/model/UpdateRuleMetadataRequest.h>
#include <aws/frauddetector/model/UpdateRuleMetadataResult.h>
#include <aws/frauddetector/model/UpdateRuleVersionRequest.h>
#include <aws/frauddetector/model/UpdateRuleVersionResult.h>
#include <aws/frauddetector/model/UpdateVariableRequest.h>
#include <aws/frauddetector/model/UpdateVariableResult.h>
#include <aws/frauddetector/model/Variable.h>
#include <aws/frauddetector/model/VariableEntry.h>
#include <aws/frauddetector/model/VariableImpactExplanation.h>
#include <aws/frauddetector/model/VariableImportanceMetrics.h>

using FraudDetectorIncludeTest = ::testing::Test;

TEST_F(FraudDetectorIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::FraudDetector::FraudDetectorClient>("FraudDetectorIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
