/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/fsx/FSxClient.h>
#include <aws/fsx/FSxEndpointProvider.h>
#include <aws/fsx/FSxEndpointRules.h>
#include <aws/fsx/FSxErrorMarshaller.h>
#include <aws/fsx/FSxErrors.h>
#include <aws/fsx/FSxRequest.h>
#include <aws/fsx/FSxServiceClientModel.h>
#include <aws/fsx/FSx_EXPORTS.h>
#include <aws/fsx/model/AccessPointAlreadyOwnedByYou.h>
#include <aws/fsx/model/ActiveDirectoryBackupAttributes.h>
#include <aws/fsx/model/ActiveDirectoryError.h>
#include <aws/fsx/model/ActiveDirectoryErrorType.h>
#include <aws/fsx/model/AdministrativeAction.h>
#include <aws/fsx/model/AdministrativeActionFailureDetails.h>
#include <aws/fsx/model/AdministrativeActionType.h>
#include <aws/fsx/model/AggregateConfiguration.h>
#include <aws/fsx/model/Alias.h>
#include <aws/fsx/model/AliasLifecycle.h>
#include <aws/fsx/model/AssociateFileSystemAliasesRequest.h>
#include <aws/fsx/model/AssociateFileSystemAliasesResult.h>
#include <aws/fsx/model/AutoExportPolicy.h>
#include <aws/fsx/model/AutoImportPolicy.h>
#include <aws/fsx/model/AutoImportPolicyType.h>
#include <aws/fsx/model/AutocommitPeriod.h>
#include <aws/fsx/model/AutocommitPeriodType.h>
#include <aws/fsx/model/Backup.h>
#include <aws/fsx/model/BackupBeingCopied.h>
#include <aws/fsx/model/BackupFailureDetails.h>
#include <aws/fsx/model/BackupLifecycle.h>
#include <aws/fsx/model/BackupRestoring.h>
#include <aws/fsx/model/BackupType.h>
#include <aws/fsx/model/CancelDataRepositoryTaskRequest.h>
#include <aws/fsx/model/CancelDataRepositoryTaskResult.h>
#include <aws/fsx/model/CompletionReport.h>
#include <aws/fsx/model/CopyBackupRequest.h>
#include <aws/fsx/model/CopyBackupResult.h>
#include <aws/fsx/model/CopySnapshotAndUpdateVolumeRequest.h>
#include <aws/fsx/model/CopySnapshotAndUpdateVolumeResult.h>
#include <aws/fsx/model/CreateAggregateConfiguration.h>
#include <aws/fsx/model/CreateAndAttachS3AccessPointOpenZFSConfiguration.h>
#include <aws/fsx/model/CreateAndAttachS3AccessPointRequest.h>
#include <aws/fsx/model/CreateAndAttachS3AccessPointResult.h>
#include <aws/fsx/model/CreateAndAttachS3AccessPointS3Configuration.h>
#include <aws/fsx/model/CreateBackupRequest.h>
#include <aws/fsx/model/CreateBackupResult.h>
#include <aws/fsx/model/CreateDataRepositoryAssociationRequest.h>
#include <aws/fsx/model/CreateDataRepositoryAssociationResult.h>
#include <aws/fsx/model/CreateDataRepositoryTaskRequest.h>
#include <aws/fsx/model/CreateDataRepositoryTaskResult.h>
#include <aws/fsx/model/CreateFileCacheLustreConfiguration.h>
#include <aws/fsx/model/CreateFileCacheRequest.h>
#include <aws/fsx/model/CreateFileCacheResult.h>
#include <aws/fsx/model/CreateFileSystemFromBackupRequest.h>
#include <aws/fsx/model/CreateFileSystemFromBackupResult.h>
#include <aws/fsx/model/CreateFileSystemLustreConfiguration.h>
#include <aws/fsx/model/CreateFileSystemLustreMetadataConfiguration.h>
#include <aws/fsx/model/CreateFileSystemOntapConfiguration.h>
#include <aws/fsx/model/CreateFileSystemOpenZFSConfiguration.h>
#include <aws/fsx/model/CreateFileSystemRequest.h>
#include <aws/fsx/model/CreateFileSystemResult.h>
#include <aws/fsx/model/CreateFileSystemWindowsConfiguration.h>
#include <aws/fsx/model/CreateOntapVolumeConfiguration.h>
#include <aws/fsx/model/CreateOpenZFSOriginSnapshotConfiguration.h>
#include <aws/fsx/model/CreateOpenZFSVolumeConfiguration.h>
#include <aws/fsx/model/CreateSnaplockConfiguration.h>
#include <aws/fsx/model/CreateSnapshotRequest.h>
#include <aws/fsx/model/CreateSnapshotResult.h>
#include <aws/fsx/model/CreateStorageVirtualMachineRequest.h>
#include <aws/fsx/model/CreateStorageVirtualMachineResult.h>
#include <aws/fsx/model/CreateSvmActiveDirectoryConfiguration.h>
#include <aws/fsx/model/CreateVolumeFromBackupRequest.h>
#include <aws/fsx/model/CreateVolumeFromBackupResult.h>
#include <aws/fsx/model/CreateVolumeRequest.h>
#include <aws/fsx/model/CreateVolumeResult.h>
#include <aws/fsx/model/DataCompressionType.h>
#include <aws/fsx/model/DataRepositoryAssociation.h>
#include <aws/fsx/model/DataRepositoryConfiguration.h>
#include <aws/fsx/model/DataRepositoryFailureDetails.h>
#include <aws/fsx/model/DataRepositoryLifecycle.h>
#include <aws/fsx/model/DataRepositoryTask.h>
#include <aws/fsx/model/DataRepositoryTaskFailureDetails.h>
#include <aws/fsx/model/DataRepositoryTaskFilter.h>
#include <aws/fsx/model/DataRepositoryTaskFilterName.h>
#include <aws/fsx/model/DataRepositoryTaskLifecycle.h>
#include <aws/fsx/model/DataRepositoryTaskStatus.h>
#include <aws/fsx/model/DataRepositoryTaskType.h>
#include <aws/fsx/model/DeleteBackupRequest.h>
#include <aws/fsx/model/DeleteBackupResult.h>
#include <aws/fsx/model/DeleteDataRepositoryAssociationRequest.h>
#include <aws/fsx/model/DeleteDataRepositoryAssociationResult.h>
#include <aws/fsx/model/DeleteFileCacheRequest.h>
#include <aws/fsx/model/DeleteFileCacheResult.h>
#include <aws/fsx/model/DeleteFileSystemLustreConfiguration.h>
#include <aws/fsx/model/DeleteFileSystemLustreResponse.h>
#include <aws/fsx/model/DeleteFileSystemOpenZFSConfiguration.h>
#include <aws/fsx/model/DeleteFileSystemOpenZFSOption.h>
#include <aws/fsx/model/DeleteFileSystemOpenZFSResponse.h>
#include <aws/fsx/model/DeleteFileSystemRequest.h>
#include <aws/fsx/model/DeleteFileSystemResult.h>
#include <aws/fsx/model/DeleteFileSystemWindowsConfiguration.h>
#include <aws/fsx/model/DeleteFileSystemWindowsResponse.h>
#include <aws/fsx/model/DeleteOpenZFSVolumeOption.h>
#include <aws/fsx/model/DeleteSnapshotRequest.h>
#include <aws/fsx/model/DeleteSnapshotResult.h>
#include <aws/fsx/model/DeleteStorageVirtualMachineRequest.h>
#include <aws/fsx/model/DeleteStorageVirtualMachineResult.h>
#include <aws/fsx/model/DeleteVolumeOntapConfiguration.h>
#include <aws/fsx/model/DeleteVolumeOntapResponse.h>
#include <aws/fsx/model/DeleteVolumeOpenZFSConfiguration.h>
#include <aws/fsx/model/DeleteVolumeRequest.h>
#include <aws/fsx/model/DeleteVolumeResult.h>
#include <aws/fsx/model/DescribeBackupsRequest.h>
#include <aws/fsx/model/DescribeBackupsResult.h>
#include <aws/fsx/model/DescribeDataRepositoryAssociationsRequest.h>
#include <aws/fsx/model/DescribeDataRepositoryAssociationsResult.h>
#include <aws/fsx/model/DescribeDataRepositoryTasksRequest.h>
#include <aws/fsx/model/DescribeDataRepositoryTasksResult.h>
#include <aws/fsx/model/DescribeFileCachesRequest.h>
#include <aws/fsx/model/DescribeFileCachesResult.h>
#include <aws/fsx/model/DescribeFileSystemAliasesRequest.h>
#include <aws/fsx/model/DescribeFileSystemAliasesResult.h>
#include <aws/fsx/model/DescribeFileSystemsRequest.h>
#include <aws/fsx/model/DescribeFileSystemsResult.h>
#include <aws/fsx/model/DescribeS3AccessPointAttachmentsRequest.h>
#include <aws/fsx/model/DescribeS3AccessPointAttachmentsResult.h>
#include <aws/fsx/model/DescribeSharedVpcConfigurationRequest.h>
#include <aws/fsx/model/DescribeSharedVpcConfigurationResult.h>
#include <aws/fsx/model/DescribeSnapshotsRequest.h>
#include <aws/fsx/model/DescribeSnapshotsResult.h>
#include <aws/fsx/model/DescribeStorageVirtualMachinesRequest.h>
#include <aws/fsx/model/DescribeStorageVirtualMachinesResult.h>
#include <aws/fsx/model/DescribeVolumesRequest.h>
#include <aws/fsx/model/DescribeVolumesResult.h>
#include <aws/fsx/model/DetachAndDeleteS3AccessPointRequest.h>
#include <aws/fsx/model/DetachAndDeleteS3AccessPointResult.h>
#include <aws/fsx/model/DisassociateFileSystemAliasesRequest.h>
#include <aws/fsx/model/DisassociateFileSystemAliasesResult.h>
#include <aws/fsx/model/DiskIopsConfiguration.h>
#include <aws/fsx/model/DiskIopsConfigurationMode.h>
#include <aws/fsx/model/DriveCacheType.h>
#include <aws/fsx/model/DurationSinceLastAccess.h>
#include <aws/fsx/model/EventType.h>
#include <aws/fsx/model/FileCache.h>
#include <aws/fsx/model/FileCacheCreating.h>
#include <aws/fsx/model/FileCacheDataRepositoryAssociation.h>
#include <aws/fsx/model/FileCacheFailureDetails.h>
#include <aws/fsx/model/FileCacheLifecycle.h>
#include <aws/fsx/model/FileCacheLustreConfiguration.h>
#include <aws/fsx/model/FileCacheLustreDeploymentType.h>
#include <aws/fsx/model/FileCacheLustreMetadataConfiguration.h>
#include <aws/fsx/model/FileCacheNFSConfiguration.h>
#include <aws/fsx/model/FileCacheType.h>
#include <aws/fsx/model/FileSystem.h>
#include <aws/fsx/model/FileSystemEndpoint.h>
#include <aws/fsx/model/FileSystemEndpoints.h>
#include <aws/fsx/model/FileSystemFailureDetails.h>
#include <aws/fsx/model/FileSystemLifecycle.h>
#include <aws/fsx/model/FileSystemLustreMetadataConfiguration.h>
#include <aws/fsx/model/FileSystemMaintenanceOperation.h>
#include <aws/fsx/model/FileSystemType.h>
#include <aws/fsx/model/Filter.h>
#include <aws/fsx/model/FilterName.h>
#include <aws/fsx/model/FlexCacheEndpointType.h>
#include <aws/fsx/model/IncompatibleParameterError.h>
#include <aws/fsx/model/InputOntapVolumeType.h>
#include <aws/fsx/model/InvalidAccessPoint.h>
#include <aws/fsx/model/InvalidNetworkSettings.h>
#include <aws/fsx/model/InvalidRequest.h>
#include <aws/fsx/model/LifecycleTransitionReason.h>
#include <aws/fsx/model/ListTagsForResourceRequest.h>
#include <aws/fsx/model/ListTagsForResourceResult.h>
#include <aws/fsx/model/LustreAccessAuditLogLevel.h>
#include <aws/fsx/model/LustreDeploymentType.h>
#include <aws/fsx/model/LustreFileSystemConfiguration.h>
#include <aws/fsx/model/LustreLogConfiguration.h>
#include <aws/fsx/model/LustreLogCreateConfiguration.h>
#include <aws/fsx/model/LustreReadCacheConfiguration.h>
#include <aws/fsx/model/LustreReadCacheSizingMode.h>
#include <aws/fsx/model/LustreRootSquashConfiguration.h>
#include <aws/fsx/model/MetadataConfigurationMode.h>
#include <aws/fsx/model/NFSDataRepositoryConfiguration.h>
#include <aws/fsx/model/NfsVersion.h>
#include <aws/fsx/model/NotServiceResourceError.h>
#include <aws/fsx/model/OntapDeploymentType.h>
#include <aws/fsx/model/OntapFileSystemConfiguration.h>
#include <aws/fsx/model/OntapVolumeConfiguration.h>
#include <aws/fsx/model/OntapVolumeType.h>
#include <aws/fsx/model/OpenZFSClientConfiguration.h>
#include <aws/fsx/model/OpenZFSCopyStrategy.h>
#include <aws/fsx/model/OpenZFSCreateRootVolumeConfiguration.h>
#include <aws/fsx/model/OpenZFSDataCompressionType.h>
#include <aws/fsx/model/OpenZFSDeploymentType.h>
#include <aws/fsx/model/OpenZFSFileSystemConfiguration.h>
#include <aws/fsx/model/OpenZFSFileSystemIdentity.h>
#include <aws/fsx/model/OpenZFSFileSystemUserType.h>
#include <aws/fsx/model/OpenZFSNfsExport.h>
#include <aws/fsx/model/OpenZFSOriginSnapshotConfiguration.h>
#include <aws/fsx/model/OpenZFSPosixFileSystemUser.h>
#include <aws/fsx/model/OpenZFSQuotaType.h>
#include <aws/fsx/model/OpenZFSReadCacheConfiguration.h>
#include <aws/fsx/model/OpenZFSReadCacheSizingMode.h>
#include <aws/fsx/model/OpenZFSUserOrGroupQuota.h>
#include <aws/fsx/model/OpenZFSVolumeConfiguration.h>
#include <aws/fsx/model/PrivilegedDelete.h>
#include <aws/fsx/model/ReleaseConfiguration.h>
#include <aws/fsx/model/ReleaseFileSystemNfsV3LocksRequest.h>
#include <aws/fsx/model/ReleaseFileSystemNfsV3LocksResult.h>
#include <aws/fsx/model/ReportFormat.h>
#include <aws/fsx/model/ReportScope.h>
#include <aws/fsx/model/ResourceDoesNotSupportTagging.h>
#include <aws/fsx/model/ResourceNotFound.h>
#include <aws/fsx/model/ResourceType.h>
#include <aws/fsx/model/RestoreOpenZFSVolumeOption.h>
#include <aws/fsx/model/RestoreVolumeFromSnapshotRequest.h>
#include <aws/fsx/model/RestoreVolumeFromSnapshotResult.h>
#include <aws/fsx/model/RetentionPeriod.h>
#include <aws/fsx/model/RetentionPeriodType.h>
#include <aws/fsx/model/S3AccessPoint.h>
#include <aws/fsx/model/S3AccessPointAttachment.h>
#include <aws/fsx/model/S3AccessPointAttachmentLifecycle.h>
#include <aws/fsx/model/S3AccessPointAttachmentType.h>
#include <aws/fsx/model/S3AccessPointAttachmentsFilter.h>
#include <aws/fsx/model/S3AccessPointAttachmentsFilterName.h>
#include <aws/fsx/model/S3AccessPointOpenZFSConfiguration.h>
#include <aws/fsx/model/S3AccessPointVpcConfiguration.h>
#include <aws/fsx/model/S3DataRepositoryConfiguration.h>
#include <aws/fsx/model/SecurityStyle.h>
#include <aws/fsx/model/SelfManagedActiveDirectoryAttributes.h>
#include <aws/fsx/model/SelfManagedActiveDirectoryConfiguration.h>
#include <aws/fsx/model/SelfManagedActiveDirectoryConfigurationUpdates.h>
#include <aws/fsx/model/ServiceLimit.h>
#include <aws/fsx/model/ServiceLimitExceeded.h>
#include <aws/fsx/model/SnaplockConfiguration.h>
#include <aws/fsx/model/SnaplockRetentionPeriod.h>
#include <aws/fsx/model/SnaplockType.h>
#include <aws/fsx/model/Snapshot.h>
#include <aws/fsx/model/SnapshotFilter.h>
#include <aws/fsx/model/SnapshotFilterName.h>
#include <aws/fsx/model/SnapshotLifecycle.h>
#include <aws/fsx/model/SourceBackupUnavailable.h>
#include <aws/fsx/model/StartMisconfiguredStateRecoveryRequest.h>
#include <aws/fsx/model/StartMisconfiguredStateRecoveryResult.h>
#include <aws/fsx/model/Status.h>
#include <aws/fsx/model/StorageType.h>
#include <aws/fsx/model/StorageVirtualMachine.h>
#include <aws/fsx/model/StorageVirtualMachineFilter.h>
#include <aws/fsx/model/StorageVirtualMachineFilterName.h>
#include <aws/fsx/model/StorageVirtualMachineLifecycle.h>
#include <aws/fsx/model/StorageVirtualMachineRootVolumeSecurityStyle.h>
#include <aws/fsx/model/StorageVirtualMachineSubtype.h>
#include <aws/fsx/model/SvmActiveDirectoryConfiguration.h>
#include <aws/fsx/model/SvmEndpoint.h>
#include <aws/fsx/model/SvmEndpoints.h>
#include <aws/fsx/model/Tag.h>
#include <aws/fsx/model/TagResourceRequest.h>
#include <aws/fsx/model/TagResourceResult.h>
#include <aws/fsx/model/TieringPolicy.h>
#include <aws/fsx/model/TieringPolicyName.h>
#include <aws/fsx/model/TooManyAccessPoints.h>
#include <aws/fsx/model/Unit.h>
#include <aws/fsx/model/UntagResourceRequest.h>
#include <aws/fsx/model/UntagResourceResult.h>
#include <aws/fsx/model/UpdateDataRepositoryAssociationRequest.h>
#include <aws/fsx/model/UpdateDataRepositoryAssociationResult.h>
#include <aws/fsx/model/UpdateFileCacheLustreConfiguration.h>
#include <aws/fsx/model/UpdateFileCacheRequest.h>
#include <aws/fsx/model/UpdateFileCacheResult.h>
#include <aws/fsx/model/UpdateFileSystemLustreConfiguration.h>
#include <aws/fsx/model/UpdateFileSystemLustreMetadataConfiguration.h>
#include <aws/fsx/model/UpdateFileSystemOntapConfiguration.h>
#include <aws/fsx/model/UpdateFileSystemOpenZFSConfiguration.h>
#include <aws/fsx/model/UpdateFileSystemRequest.h>
#include <aws/fsx/model/UpdateFileSystemResult.h>
#include <aws/fsx/model/UpdateFileSystemWindowsConfiguration.h>
#include <aws/fsx/model/UpdateOntapVolumeConfiguration.h>
#include <aws/fsx/model/UpdateOpenZFSVolumeConfiguration.h>
#include <aws/fsx/model/UpdateOpenZFSVolumeOption.h>
#include <aws/fsx/model/UpdateSharedVpcConfigurationRequest.h>
#include <aws/fsx/model/UpdateSharedVpcConfigurationResult.h>
#include <aws/fsx/model/UpdateSnaplockConfiguration.h>
#include <aws/fsx/model/UpdateSnapshotRequest.h>
#include <aws/fsx/model/UpdateSnapshotResult.h>
#include <aws/fsx/model/UpdateStorageVirtualMachineRequest.h>
#include <aws/fsx/model/UpdateStorageVirtualMachineResult.h>
#include <aws/fsx/model/UpdateSvmActiveDirectoryConfiguration.h>
#include <aws/fsx/model/UpdateVolumeRequest.h>
#include <aws/fsx/model/UpdateVolumeResult.h>
#include <aws/fsx/model/Volume.h>
#include <aws/fsx/model/VolumeFilter.h>
#include <aws/fsx/model/VolumeFilterName.h>
#include <aws/fsx/model/VolumeLifecycle.h>
#include <aws/fsx/model/VolumeStyle.h>
#include <aws/fsx/model/VolumeType.h>
#include <aws/fsx/model/WindowsAccessAuditLogLevel.h>
#include <aws/fsx/model/WindowsAuditLogConfiguration.h>
#include <aws/fsx/model/WindowsAuditLogCreateConfiguration.h>
#include <aws/fsx/model/WindowsDeploymentType.h>
#include <aws/fsx/model/WindowsFileSystemConfiguration.h>

using FSxIncludeTest = ::testing::Test;

TEST_F(FSxIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::FSx::FSxClient>("FSxIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
