/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/gamelift/GameLiftClient.h>
#include <aws/gamelift/GameLiftEndpointProvider.h>
#include <aws/gamelift/GameLiftEndpointRules.h>
#include <aws/gamelift/GameLiftErrorMarshaller.h>
#include <aws/gamelift/GameLiftErrors.h>
#include <aws/gamelift/GameLiftRequest.h>
#include <aws/gamelift/GameLiftServiceClientModel.h>
#include <aws/gamelift/GameLift_EXPORTS.h>
#include <aws/gamelift/model/AcceptMatchRequest.h>
#include <aws/gamelift/model/AcceptMatchResult.h>
#include <aws/gamelift/model/AcceptanceType.h>
#include <aws/gamelift/model/Alias.h>
#include <aws/gamelift/model/AnywhereConfiguration.h>
#include <aws/gamelift/model/AttributeValue.h>
#include <aws/gamelift/model/AwsCredentials.h>
#include <aws/gamelift/model/BackfillMode.h>
#include <aws/gamelift/model/BalancingStrategy.h>
#include <aws/gamelift/model/Build.h>
#include <aws/gamelift/model/BuildStatus.h>
#include <aws/gamelift/model/CertificateConfiguration.h>
#include <aws/gamelift/model/CertificateType.h>
#include <aws/gamelift/model/ClaimFilterOption.h>
#include <aws/gamelift/model/ClaimGameServerRequest.h>
#include <aws/gamelift/model/ClaimGameServerResult.h>
#include <aws/gamelift/model/ComparisonOperatorType.h>
#include <aws/gamelift/model/Compute.h>
#include <aws/gamelift/model/ComputeStatus.h>
#include <aws/gamelift/model/ComputeType.h>
#include <aws/gamelift/model/ConnectionPortRange.h>
#include <aws/gamelift/model/ContainerAttribute.h>
#include <aws/gamelift/model/ContainerDependency.h>
#include <aws/gamelift/model/ContainerDependencyCondition.h>
#include <aws/gamelift/model/ContainerEnvironment.h>
#include <aws/gamelift/model/ContainerFleet.h>
#include <aws/gamelift/model/ContainerFleetBillingType.h>
#include <aws/gamelift/model/ContainerFleetLocationAttributes.h>
#include <aws/gamelift/model/ContainerFleetLocationStatus.h>
#include <aws/gamelift/model/ContainerFleetRemoveAttribute.h>
#include <aws/gamelift/model/ContainerFleetStatus.h>
#include <aws/gamelift/model/ContainerGroupDefinition.h>
#include <aws/gamelift/model/ContainerGroupDefinitionStatus.h>
#include <aws/gamelift/model/ContainerGroupType.h>
#include <aws/gamelift/model/ContainerHealthCheck.h>
#include <aws/gamelift/model/ContainerIdentifier.h>
#include <aws/gamelift/model/ContainerMountPoint.h>
#include <aws/gamelift/model/ContainerMountPointAccessLevel.h>
#include <aws/gamelift/model/ContainerOperatingSystem.h>
#include <aws/gamelift/model/ContainerPortConfiguration.h>
#include <aws/gamelift/model/ContainerPortRange.h>
#include <aws/gamelift/model/CreateAliasRequest.h>
#include <aws/gamelift/model/CreateAliasResult.h>
#include <aws/gamelift/model/CreateBuildRequest.h>
#include <aws/gamelift/model/CreateBuildResult.h>
#include <aws/gamelift/model/CreateContainerFleetRequest.h>
#include <aws/gamelift/model/CreateContainerFleetResult.h>
#include <aws/gamelift/model/CreateContainerGroupDefinitionRequest.h>
#include <aws/gamelift/model/CreateContainerGroupDefinitionResult.h>
#include <aws/gamelift/model/CreateFleetLocationsRequest.h>
#include <aws/gamelift/model/CreateFleetLocationsResult.h>
#include <aws/gamelift/model/CreateFleetRequest.h>
#include <aws/gamelift/model/CreateFleetResult.h>
#include <aws/gamelift/model/CreateGameServerGroupRequest.h>
#include <aws/gamelift/model/CreateGameServerGroupResult.h>
#include <aws/gamelift/model/CreateGameSessionQueueRequest.h>
#include <aws/gamelift/model/CreateGameSessionQueueResult.h>
#include <aws/gamelift/model/CreateGameSessionRequest.h>
#include <aws/gamelift/model/CreateGameSessionResult.h>
#include <aws/gamelift/model/CreateLocationRequest.h>
#include <aws/gamelift/model/CreateLocationResult.h>
#include <aws/gamelift/model/CreateMatchmakingConfigurationRequest.h>
#include <aws/gamelift/model/CreateMatchmakingConfigurationResult.h>
#include <aws/gamelift/model/CreateMatchmakingRuleSetRequest.h>
#include <aws/gamelift/model/CreateMatchmakingRuleSetResult.h>
#include <aws/gamelift/model/CreatePlayerSessionRequest.h>
#include <aws/gamelift/model/CreatePlayerSessionResult.h>
#include <aws/gamelift/model/CreatePlayerSessionsRequest.h>
#include <aws/gamelift/model/CreatePlayerSessionsResult.h>
#include <aws/gamelift/model/CreateScriptRequest.h>
#include <aws/gamelift/model/CreateScriptResult.h>
#include <aws/gamelift/model/CreateVpcPeeringAuthorizationRequest.h>
#include <aws/gamelift/model/CreateVpcPeeringAuthorizationResult.h>
#include <aws/gamelift/model/CreateVpcPeeringConnectionRequest.h>
#include <aws/gamelift/model/CreateVpcPeeringConnectionResult.h>
#include <aws/gamelift/model/DeleteAliasRequest.h>
#include <aws/gamelift/model/DeleteBuildRequest.h>
#include <aws/gamelift/model/DeleteContainerFleetRequest.h>
#include <aws/gamelift/model/DeleteContainerFleetResult.h>
#include <aws/gamelift/model/DeleteContainerGroupDefinitionRequest.h>
#include <aws/gamelift/model/DeleteContainerGroupDefinitionResult.h>
#include <aws/gamelift/model/DeleteFleetLocationsRequest.h>
#include <aws/gamelift/model/DeleteFleetLocationsResult.h>
#include <aws/gamelift/model/DeleteFleetRequest.h>
#include <aws/gamelift/model/DeleteGameServerGroupRequest.h>
#include <aws/gamelift/model/DeleteGameServerGroupResult.h>
#include <aws/gamelift/model/DeleteGameSessionQueueRequest.h>
#include <aws/gamelift/model/DeleteGameSessionQueueResult.h>
#include <aws/gamelift/model/DeleteLocationRequest.h>
#include <aws/gamelift/model/DeleteLocationResult.h>
#include <aws/gamelift/model/DeleteMatchmakingConfigurationRequest.h>
#include <aws/gamelift/model/DeleteMatchmakingConfigurationResult.h>
#include <aws/gamelift/model/DeleteMatchmakingRuleSetRequest.h>
#include <aws/gamelift/model/DeleteMatchmakingRuleSetResult.h>
#include <aws/gamelift/model/DeleteScalingPolicyRequest.h>
#include <aws/gamelift/model/DeleteScriptRequest.h>
#include <aws/gamelift/model/DeleteVpcPeeringAuthorizationRequest.h>
#include <aws/gamelift/model/DeleteVpcPeeringAuthorizationResult.h>
#include <aws/gamelift/model/DeleteVpcPeeringConnectionRequest.h>
#include <aws/gamelift/model/DeleteVpcPeeringConnectionResult.h>
#include <aws/gamelift/model/DeploymentConfiguration.h>
#include <aws/gamelift/model/DeploymentDetails.h>
#include <aws/gamelift/model/DeploymentImpairmentStrategy.h>
#include <aws/gamelift/model/DeploymentProtectionStrategy.h>
#include <aws/gamelift/model/DeploymentStatus.h>
#include <aws/gamelift/model/DeregisterComputeRequest.h>
#include <aws/gamelift/model/DeregisterComputeResult.h>
#include <aws/gamelift/model/DeregisterGameServerRequest.h>
#include <aws/gamelift/model/DescribeAliasRequest.h>
#include <aws/gamelift/model/DescribeAliasResult.h>
#include <aws/gamelift/model/DescribeBuildRequest.h>
#include <aws/gamelift/model/DescribeBuildResult.h>
#include <aws/gamelift/model/DescribeComputeRequest.h>
#include <aws/gamelift/model/DescribeComputeResult.h>
#include <aws/gamelift/model/DescribeContainerFleetRequest.h>
#include <aws/gamelift/model/DescribeContainerFleetResult.h>
#include <aws/gamelift/model/DescribeContainerGroupDefinitionRequest.h>
#include <aws/gamelift/model/DescribeContainerGroupDefinitionResult.h>
#include <aws/gamelift/model/DescribeEC2InstanceLimitsRequest.h>
#include <aws/gamelift/model/DescribeEC2InstanceLimitsResult.h>
#include <aws/gamelift/model/DescribeFleetAttributesRequest.h>
#include <aws/gamelift/model/DescribeFleetAttributesResult.h>
#include <aws/gamelift/model/DescribeFleetCapacityRequest.h>
#include <aws/gamelift/model/DescribeFleetCapacityResult.h>
#include <aws/gamelift/model/DescribeFleetDeploymentRequest.h>
#include <aws/gamelift/model/DescribeFleetDeploymentResult.h>
#include <aws/gamelift/model/DescribeFleetEventsRequest.h>
#include <aws/gamelift/model/DescribeFleetEventsResult.h>
#include <aws/gamelift/model/DescribeFleetLocationAttributesRequest.h>
#include <aws/gamelift/model/DescribeFleetLocationAttributesResult.h>
#include <aws/gamelift/model/DescribeFleetLocationCapacityRequest.h>
#include <aws/gamelift/model/DescribeFleetLocationCapacityResult.h>
#include <aws/gamelift/model/DescribeFleetLocationUtilizationRequest.h>
#include <aws/gamelift/model/DescribeFleetLocationUtilizationResult.h>
#include <aws/gamelift/model/DescribeFleetPortSettingsRequest.h>
#include <aws/gamelift/model/DescribeFleetPortSettingsResult.h>
#include <aws/gamelift/model/DescribeFleetUtilizationRequest.h>
#include <aws/gamelift/model/DescribeFleetUtilizationResult.h>
#include <aws/gamelift/model/DescribeGameServerGroupRequest.h>
#include <aws/gamelift/model/DescribeGameServerGroupResult.h>
#include <aws/gamelift/model/DescribeGameServerInstancesRequest.h>
#include <aws/gamelift/model/DescribeGameServerInstancesResult.h>
#include <aws/gamelift/model/DescribeGameServerRequest.h>
#include <aws/gamelift/model/DescribeGameServerResult.h>
#include <aws/gamelift/model/DescribeGameSessionDetailsRequest.h>
#include <aws/gamelift/model/DescribeGameSessionDetailsResult.h>
#include <aws/gamelift/model/DescribeGameSessionPlacementRequest.h>
#include <aws/gamelift/model/DescribeGameSessionPlacementResult.h>
#include <aws/gamelift/model/DescribeGameSessionQueuesRequest.h>
#include <aws/gamelift/model/DescribeGameSessionQueuesResult.h>
#include <aws/gamelift/model/DescribeGameSessionsRequest.h>
#include <aws/gamelift/model/DescribeGameSessionsResult.h>
#include <aws/gamelift/model/DescribeInstancesRequest.h>
#include <aws/gamelift/model/DescribeInstancesResult.h>
#include <aws/gamelift/model/DescribeMatchmakingConfigurationsRequest.h>
#include <aws/gamelift/model/DescribeMatchmakingConfigurationsResult.h>
#include <aws/gamelift/model/DescribeMatchmakingRequest.h>
#include <aws/gamelift/model/DescribeMatchmakingResult.h>
#include <aws/gamelift/model/DescribeMatchmakingRuleSetsRequest.h>
#include <aws/gamelift/model/DescribeMatchmakingRuleSetsResult.h>
#include <aws/gamelift/model/DescribePlayerSessionsRequest.h>
#include <aws/gamelift/model/DescribePlayerSessionsResult.h>
#include <aws/gamelift/model/DescribeRuntimeConfigurationRequest.h>
#include <aws/gamelift/model/DescribeRuntimeConfigurationResult.h>
#include <aws/gamelift/model/DescribeScalingPoliciesRequest.h>
#include <aws/gamelift/model/DescribeScalingPoliciesResult.h>
#include <aws/gamelift/model/DescribeScriptRequest.h>
#include <aws/gamelift/model/DescribeScriptResult.h>
#include <aws/gamelift/model/DescribeVpcPeeringAuthorizationsRequest.h>
#include <aws/gamelift/model/DescribeVpcPeeringAuthorizationsResult.h>
#include <aws/gamelift/model/DescribeVpcPeeringConnectionsRequest.h>
#include <aws/gamelift/model/DescribeVpcPeeringConnectionsResult.h>
#include <aws/gamelift/model/DesiredPlayerSession.h>
#include <aws/gamelift/model/EC2InstanceCounts.h>
#include <aws/gamelift/model/EC2InstanceLimit.h>
#include <aws/gamelift/model/EC2InstanceType.h>
#include <aws/gamelift/model/Event.h>
#include <aws/gamelift/model/EventCode.h>
#include <aws/gamelift/model/FilterConfiguration.h>
#include <aws/gamelift/model/FilterInstanceStatus.h>
#include <aws/gamelift/model/FleetAction.h>
#include <aws/gamelift/model/FleetAttributes.h>
#include <aws/gamelift/model/FleetCapacity.h>
#include <aws/gamelift/model/FleetDeployment.h>
#include <aws/gamelift/model/FleetStatus.h>
#include <aws/gamelift/model/FleetType.h>
#include <aws/gamelift/model/FleetUtilization.h>
#include <aws/gamelift/model/FlexMatchMode.h>
#include <aws/gamelift/model/GameProperty.h>
#include <aws/gamelift/model/GameServer.h>
#include <aws/gamelift/model/GameServerClaimStatus.h>
#include <aws/gamelift/model/GameServerContainerDefinition.h>
#include <aws/gamelift/model/GameServerContainerDefinitionInput.h>
#include <aws/gamelift/model/GameServerContainerGroupCounts.h>
#include <aws/gamelift/model/GameServerGroup.h>
#include <aws/gamelift/model/GameServerGroupAction.h>
#include <aws/gamelift/model/GameServerGroupAutoScalingPolicy.h>
#include <aws/gamelift/model/GameServerGroupDeleteOption.h>
#include <aws/gamelift/model/GameServerGroupInstanceType.h>
#include <aws/gamelift/model/GameServerGroupStatus.h>
#include <aws/gamelift/model/GameServerHealthCheck.h>
#include <aws/gamelift/model/GameServerInstance.h>
#include <aws/gamelift/model/GameServerInstanceStatus.h>
#include <aws/gamelift/model/GameServerProtectionPolicy.h>
#include <aws/gamelift/model/GameServerUtilizationStatus.h>
#include <aws/gamelift/model/GameSession.h>
#include <aws/gamelift/model/GameSessionConnectionInfo.h>
#include <aws/gamelift/model/GameSessionCreationLimitPolicy.h>
#include <aws/gamelift/model/GameSessionDetail.h>
#include <aws/gamelift/model/GameSessionPlacement.h>
#include <aws/gamelift/model/GameSessionPlacementState.h>
#include <aws/gamelift/model/GameSessionQueue.h>
#include <aws/gamelift/model/GameSessionQueueDestination.h>
#include <aws/gamelift/model/GameSessionStatus.h>
#include <aws/gamelift/model/GameSessionStatusReason.h>
#include <aws/gamelift/model/GetComputeAccessRequest.h>
#include <aws/gamelift/model/GetComputeAccessResult.h>
#include <aws/gamelift/model/GetComputeAuthTokenRequest.h>
#include <aws/gamelift/model/GetComputeAuthTokenResult.h>
#include <aws/gamelift/model/GetGameSessionLogUrlRequest.h>
#include <aws/gamelift/model/GetGameSessionLogUrlResult.h>
#include <aws/gamelift/model/GetInstanceAccessRequest.h>
#include <aws/gamelift/model/GetInstanceAccessResult.h>
#include <aws/gamelift/model/Instance.h>
#include <aws/gamelift/model/InstanceAccess.h>
#include <aws/gamelift/model/InstanceCredentials.h>
#include <aws/gamelift/model/InstanceDefinition.h>
#include <aws/gamelift/model/InstanceRoleCredentialsProvider.h>
#include <aws/gamelift/model/InstanceStatus.h>
#include <aws/gamelift/model/IpPermission.h>
#include <aws/gamelift/model/IpProtocol.h>
#include <aws/gamelift/model/LaunchTemplateSpecification.h>
#include <aws/gamelift/model/ListAliasesRequest.h>
#include <aws/gamelift/model/ListAliasesResult.h>
#include <aws/gamelift/model/ListBuildsRequest.h>
#include <aws/gamelift/model/ListBuildsResult.h>
#include <aws/gamelift/model/ListComputeInputStatus.h>
#include <aws/gamelift/model/ListComputeRequest.h>
#include <aws/gamelift/model/ListComputeResult.h>
#include <aws/gamelift/model/ListContainerFleetsRequest.h>
#include <aws/gamelift/model/ListContainerFleetsResult.h>
#include <aws/gamelift/model/ListContainerGroupDefinitionVersionsRequest.h>
#include <aws/gamelift/model/ListContainerGroupDefinitionVersionsResult.h>
#include <aws/gamelift/model/ListContainerGroupDefinitionsRequest.h>
#include <aws/gamelift/model/ListContainerGroupDefinitionsResult.h>
#include <aws/gamelift/model/ListFleetDeploymentsRequest.h>
#include <aws/gamelift/model/ListFleetDeploymentsResult.h>
#include <aws/gamelift/model/ListFleetsRequest.h>
#include <aws/gamelift/model/ListFleetsResult.h>
#include <aws/gamelift/model/ListGameServerGroupsRequest.h>
#include <aws/gamelift/model/ListGameServerGroupsResult.h>
#include <aws/gamelift/model/ListGameServersRequest.h>
#include <aws/gamelift/model/ListGameServersResult.h>
#include <aws/gamelift/model/ListLocationsRequest.h>
#include <aws/gamelift/model/ListLocationsResult.h>
#include <aws/gamelift/model/ListScriptsRequest.h>
#include <aws/gamelift/model/ListScriptsResult.h>
#include <aws/gamelift/model/ListTagsForResourceRequest.h>
#include <aws/gamelift/model/ListTagsForResourceResult.h>
#include <aws/gamelift/model/LocationAttributes.h>
#include <aws/gamelift/model/LocationConfiguration.h>
#include <aws/gamelift/model/LocationFilter.h>
#include <aws/gamelift/model/LocationModel.h>
#include <aws/gamelift/model/LocationState.h>
#include <aws/gamelift/model/LocationUpdateStatus.h>
#include <aws/gamelift/model/LocationalDeployment.h>
#include <aws/gamelift/model/LogConfiguration.h>
#include <aws/gamelift/model/LogDestination.h>
#include <aws/gamelift/model/MatchedPlayerSession.h>
#include <aws/gamelift/model/MatchmakingConfiguration.h>
#include <aws/gamelift/model/MatchmakingConfigurationStatus.h>
#include <aws/gamelift/model/MatchmakingRuleSet.h>
#include <aws/gamelift/model/MatchmakingTicket.h>
#include <aws/gamelift/model/MetricName.h>
#include <aws/gamelift/model/OperatingSystem.h>
#include <aws/gamelift/model/PingBeacon.h>
#include <aws/gamelift/model/PlacedPlayerSession.h>
#include <aws/gamelift/model/PlacementFallbackStrategy.h>
#include <aws/gamelift/model/Player.h>
#include <aws/gamelift/model/PlayerLatency.h>
#include <aws/gamelift/model/PlayerLatencyPolicy.h>
#include <aws/gamelift/model/PlayerSession.h>
#include <aws/gamelift/model/PlayerSessionCreationPolicy.h>
#include <aws/gamelift/model/PlayerSessionStatus.h>
#include <aws/gamelift/model/PolicyType.h>
#include <aws/gamelift/model/PriorityConfiguration.h>
#include <aws/gamelift/model/PriorityConfigurationOverride.h>
#include <aws/gamelift/model/PriorityType.h>
#include <aws/gamelift/model/ProtectionPolicy.h>
#include <aws/gamelift/model/PutScalingPolicyRequest.h>
#include <aws/gamelift/model/PutScalingPolicyResult.h>
#include <aws/gamelift/model/RegisterComputeRequest.h>
#include <aws/gamelift/model/RegisterComputeResult.h>
#include <aws/gamelift/model/RegisterGameServerRequest.h>
#include <aws/gamelift/model/RegisterGameServerResult.h>
#include <aws/gamelift/model/RequestUploadCredentialsRequest.h>
#include <aws/gamelift/model/RequestUploadCredentialsResult.h>
#include <aws/gamelift/model/ResolveAliasRequest.h>
#include <aws/gamelift/model/ResolveAliasResult.h>
#include <aws/gamelift/model/ResourceCreationLimitPolicy.h>
#include <aws/gamelift/model/ResumeGameServerGroupRequest.h>
#include <aws/gamelift/model/ResumeGameServerGroupResult.h>
#include <aws/gamelift/model/RoutingStrategy.h>
#include <aws/gamelift/model/RoutingStrategyType.h>
#include <aws/gamelift/model/RuntimeConfiguration.h>
#include <aws/gamelift/model/S3Location.h>
#include <aws/gamelift/model/ScalingAdjustmentType.h>
#include <aws/gamelift/model/ScalingPolicy.h>
#include <aws/gamelift/model/ScalingStatusType.h>
#include <aws/gamelift/model/Script.h>
#include <aws/gamelift/model/SearchGameSessionsRequest.h>
#include <aws/gamelift/model/SearchGameSessionsResult.h>
#include <aws/gamelift/model/ServerProcess.h>
#include <aws/gamelift/model/SortOrder.h>
#include <aws/gamelift/model/StartFleetActionsRequest.h>
#include <aws/gamelift/model/StartFleetActionsResult.h>
#include <aws/gamelift/model/StartGameSessionPlacementRequest.h>
#include <aws/gamelift/model/StartGameSessionPlacementResult.h>
#include <aws/gamelift/model/StartMatchBackfillRequest.h>
#include <aws/gamelift/model/StartMatchBackfillResult.h>
#include <aws/gamelift/model/StartMatchmakingRequest.h>
#include <aws/gamelift/model/StartMatchmakingResult.h>
#include <aws/gamelift/model/StopFleetActionsRequest.h>
#include <aws/gamelift/model/StopFleetActionsResult.h>
#include <aws/gamelift/model/StopGameSessionPlacementRequest.h>
#include <aws/gamelift/model/StopGameSessionPlacementResult.h>
#include <aws/gamelift/model/StopMatchmakingRequest.h>
#include <aws/gamelift/model/StopMatchmakingResult.h>
#include <aws/gamelift/model/SupportContainerDefinition.h>
#include <aws/gamelift/model/SupportContainerDefinitionInput.h>
#include <aws/gamelift/model/SuspendGameServerGroupRequest.h>
#include <aws/gamelift/model/SuspendGameServerGroupResult.h>
#include <aws/gamelift/model/Tag.h>
#include <aws/gamelift/model/TagResourceRequest.h>
#include <aws/gamelift/model/TagResourceResult.h>
#include <aws/gamelift/model/TargetConfiguration.h>
#include <aws/gamelift/model/TargetTrackingConfiguration.h>
#include <aws/gamelift/model/TerminateGameSessionRequest.h>
#include <aws/gamelift/model/TerminateGameSessionResult.h>
#include <aws/gamelift/model/TerminationMode.h>
#include <aws/gamelift/model/UDPEndpoint.h>
#include <aws/gamelift/model/UntagResourceRequest.h>
#include <aws/gamelift/model/UntagResourceResult.h>
#include <aws/gamelift/model/UpdateAliasRequest.h>
#include <aws/gamelift/model/UpdateAliasResult.h>
#include <aws/gamelift/model/UpdateBuildRequest.h>
#include <aws/gamelift/model/UpdateBuildResult.h>
#include <aws/gamelift/model/UpdateContainerFleetRequest.h>
#include <aws/gamelift/model/UpdateContainerFleetResult.h>
#include <aws/gamelift/model/UpdateContainerGroupDefinitionRequest.h>
#include <aws/gamelift/model/UpdateContainerGroupDefinitionResult.h>
#include <aws/gamelift/model/UpdateFleetAttributesRequest.h>
#include <aws/gamelift/model/UpdateFleetAttributesResult.h>
#include <aws/gamelift/model/UpdateFleetCapacityRequest.h>
#include <aws/gamelift/model/UpdateFleetCapacityResult.h>
#include <aws/gamelift/model/UpdateFleetPortSettingsRequest.h>
#include <aws/gamelift/model/UpdateFleetPortSettingsResult.h>
#include <aws/gamelift/model/UpdateGameServerGroupRequest.h>
#include <aws/gamelift/model/UpdateGameServerGroupResult.h>
#include <aws/gamelift/model/UpdateGameServerRequest.h>
#include <aws/gamelift/model/UpdateGameServerResult.h>
#include <aws/gamelift/model/UpdateGameSessionQueueRequest.h>
#include <aws/gamelift/model/UpdateGameSessionQueueResult.h>
#include <aws/gamelift/model/UpdateGameSessionRequest.h>
#include <aws/gamelift/model/UpdateGameSessionResult.h>
#include <aws/gamelift/model/UpdateMatchmakingConfigurationRequest.h>
#include <aws/gamelift/model/UpdateMatchmakingConfigurationResult.h>
#include <aws/gamelift/model/UpdateRuntimeConfigurationRequest.h>
#include <aws/gamelift/model/UpdateRuntimeConfigurationResult.h>
#include <aws/gamelift/model/UpdateScriptRequest.h>
#include <aws/gamelift/model/UpdateScriptResult.h>
#include <aws/gamelift/model/ValidateMatchmakingRuleSetRequest.h>
#include <aws/gamelift/model/ValidateMatchmakingRuleSetResult.h>
#include <aws/gamelift/model/VpcPeeringAuthorization.h>
#include <aws/gamelift/model/VpcPeeringConnection.h>
#include <aws/gamelift/model/VpcPeeringConnectionStatus.h>

using GameLiftIncludeTest = ::testing::Test;

TEST_F(GameLiftIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::GameLift::GameLiftClient>("GameLiftIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
