/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/glue/GlueClient.h>
#include <aws/glue/GlueEndpointProvider.h>
#include <aws/glue/GlueEndpointRules.h>
#include <aws/glue/GlueErrorMarshaller.h>
#include <aws/glue/GlueErrors.h>
#include <aws/glue/GlueRequest.h>
#include <aws/glue/GlueServiceClientModel.h>
#include <aws/glue/Glue_EXPORTS.h>
#include <aws/glue/model/Action.h>
#include <aws/glue/model/AdditionalOptionKeys.h>
#include <aws/glue/model/AggFunction.h>
#include <aws/glue/model/Aggregate.h>
#include <aws/glue/model/AggregateOperation.h>
#include <aws/glue/model/AllowFullTableExternalDataAccessEnum.h>
#include <aws/glue/model/AllowedValue.h>
#include <aws/glue/model/AmazonRedshiftAdvancedOption.h>
#include <aws/glue/model/AmazonRedshiftNodeData.h>
#include <aws/glue/model/AmazonRedshiftSource.h>
#include <aws/glue/model/AmazonRedshiftTarget.h>
#include <aws/glue/model/AnnotationError.h>
#include <aws/glue/model/ApplyMapping.h>
#include <aws/glue/model/AthenaConnectorSource.h>
#include <aws/glue/model/AuditContext.h>
#include <aws/glue/model/AuthConfiguration.h>
#include <aws/glue/model/AuthenticationConfiguration.h>
#include <aws/glue/model/AuthenticationConfigurationInput.h>
#include <aws/glue/model/AuthenticationType.h>
#include <aws/glue/model/AuthorizationCodeProperties.h>
#include <aws/glue/model/BackfillError.h>
#include <aws/glue/model/BackfillErrorCode.h>
#include <aws/glue/model/BasicAuthenticationCredentials.h>
#include <aws/glue/model/BasicCatalogTarget.h>
#include <aws/glue/model/BatchCreatePartitionRequest.h>
#include <aws/glue/model/BatchCreatePartitionResult.h>
#include <aws/glue/model/BatchDeleteConnectionRequest.h>
#include <aws/glue/model/BatchDeleteConnectionResult.h>
#include <aws/glue/model/BatchDeletePartitionRequest.h>
#include <aws/glue/model/BatchDeletePartitionResult.h>
#include <aws/glue/model/BatchDeleteTableRequest.h>
#include <aws/glue/model/BatchDeleteTableResult.h>
#include <aws/glue/model/BatchDeleteTableVersionRequest.h>
#include <aws/glue/model/BatchDeleteTableVersionResult.h>
#include <aws/glue/model/BatchGetBlueprintsRequest.h>
#include <aws/glue/model/BatchGetBlueprintsResult.h>
#include <aws/glue/model/BatchGetCrawlersRequest.h>
#include <aws/glue/model/BatchGetCrawlersResult.h>
#include <aws/glue/model/BatchGetCustomEntityTypesRequest.h>
#include <aws/glue/model/BatchGetCustomEntityTypesResult.h>
#include <aws/glue/model/BatchGetDataQualityResultRequest.h>
#include <aws/glue/model/BatchGetDataQualityResultResult.h>
#include <aws/glue/model/BatchGetDevEndpointsRequest.h>
#include <aws/glue/model/BatchGetDevEndpointsResult.h>
#include <aws/glue/model/BatchGetJobsRequest.h>
#include <aws/glue/model/BatchGetJobsResult.h>
#include <aws/glue/model/BatchGetPartitionRequest.h>
#include <aws/glue/model/BatchGetPartitionResult.h>
#include <aws/glue/model/BatchGetTableOptimizerEntry.h>
#include <aws/glue/model/BatchGetTableOptimizerError.h>
#include <aws/glue/model/BatchGetTableOptimizerRequest.h>
#include <aws/glue/model/BatchGetTableOptimizerResult.h>
#include <aws/glue/model/BatchGetTriggersRequest.h>
#include <aws/glue/model/BatchGetTriggersResult.h>
#include <aws/glue/model/BatchGetWorkflowsRequest.h>
#include <aws/glue/model/BatchGetWorkflowsResult.h>
#include <aws/glue/model/BatchPutDataQualityStatisticAnnotationRequest.h>
#include <aws/glue/model/BatchPutDataQualityStatisticAnnotationResult.h>
#include <aws/glue/model/BatchStopJobRunError.h>
#include <aws/glue/model/BatchStopJobRunRequest.h>
#include <aws/glue/model/BatchStopJobRunResult.h>
#include <aws/glue/model/BatchStopJobRunSuccessfulSubmission.h>
#include <aws/glue/model/BatchTableOptimizer.h>
#include <aws/glue/model/BatchUpdatePartitionFailureEntry.h>
#include <aws/glue/model/BatchUpdatePartitionRequest.h>
#include <aws/glue/model/BatchUpdatePartitionRequestEntry.h>
#include <aws/glue/model/BatchUpdatePartitionResult.h>
#include <aws/glue/model/BinaryColumnStatisticsData.h>
#include <aws/glue/model/Blueprint.h>
#include <aws/glue/model/BlueprintDetails.h>
#include <aws/glue/model/BlueprintRun.h>
#include <aws/glue/model/BlueprintRunState.h>
#include <aws/glue/model/BlueprintStatus.h>
#include <aws/glue/model/BooleanColumnStatisticsData.h>
#include <aws/glue/model/CancelDataQualityRuleRecommendationRunRequest.h>
#include <aws/glue/model/CancelDataQualityRuleRecommendationRunResult.h>
#include <aws/glue/model/CancelDataQualityRulesetEvaluationRunRequest.h>
#include <aws/glue/model/CancelDataQualityRulesetEvaluationRunResult.h>
#include <aws/glue/model/CancelMLTaskRunRequest.h>
#include <aws/glue/model/CancelMLTaskRunResult.h>
#include <aws/glue/model/CancelStatementRequest.h>
#include <aws/glue/model/CancelStatementResult.h>
#include <aws/glue/model/Capabilities.h>
#include <aws/glue/model/Catalog.h>
#include <aws/glue/model/CatalogDeltaSource.h>
#include <aws/glue/model/CatalogEncryptionMode.h>
#include <aws/glue/model/CatalogEntry.h>
#include <aws/glue/model/CatalogHudiSource.h>
#include <aws/glue/model/CatalogImportStatus.h>
#include <aws/glue/model/CatalogInput.h>
#include <aws/glue/model/CatalogKafkaSource.h>
#include <aws/glue/model/CatalogKinesisSource.h>
#include <aws/glue/model/CatalogProperties.h>
#include <aws/glue/model/CatalogPropertiesOutput.h>
#include <aws/glue/model/CatalogSchemaChangePolicy.h>
#include <aws/glue/model/CatalogSource.h>
#include <aws/glue/model/CatalogTarget.h>
#include <aws/glue/model/CheckSchemaVersionValidityRequest.h>
#include <aws/glue/model/CheckSchemaVersionValidityResult.h>
#include <aws/glue/model/Classifier.h>
#include <aws/glue/model/CloudWatchEncryption.h>
#include <aws/glue/model/CloudWatchEncryptionMode.h>
#include <aws/glue/model/CodeGenConfigurationNode.h>
#include <aws/glue/model/CodeGenEdge.h>
#include <aws/glue/model/CodeGenNode.h>
#include <aws/glue/model/CodeGenNodeArg.h>
#include <aws/glue/model/Column.h>
#include <aws/glue/model/ColumnError.h>
#include <aws/glue/model/ColumnImportance.h>
#include <aws/glue/model/ColumnRowFilter.h>
#include <aws/glue/model/ColumnStatistics.h>
#include <aws/glue/model/ColumnStatisticsData.h>
#include <aws/glue/model/ColumnStatisticsError.h>
#include <aws/glue/model/ColumnStatisticsState.h>
#include <aws/glue/model/ColumnStatisticsTaskRun.h>
#include <aws/glue/model/ColumnStatisticsTaskSettings.h>
#include <aws/glue/model/ColumnStatisticsType.h>
#include <aws/glue/model/CompactionConfiguration.h>
#include <aws/glue/model/CompactionMetrics.h>
#include <aws/glue/model/CompactionStrategy.h>
#include <aws/glue/model/Comparator.h>
#include <aws/glue/model/Compatibility.h>
#include <aws/glue/model/CompressionType.h>
#include <aws/glue/model/ComputationType.h>
#include <aws/glue/model/ComputeEnvironment.h>
#include <aws/glue/model/ComputeEnvironmentConfiguration.h>
#include <aws/glue/model/Condition.h>
#include <aws/glue/model/ConditionExpression.h>
#include <aws/glue/model/ConfigurationObject.h>
#include <aws/glue/model/ConfusionMatrix.h>
#include <aws/glue/model/Connection.h>
#include <aws/glue/model/ConnectionInput.h>
#include <aws/glue/model/ConnectionPasswordEncryption.h>
#include <aws/glue/model/ConnectionPropertyKey.h>
#include <aws/glue/model/ConnectionStatus.h>
#include <aws/glue/model/ConnectionType.h>
#include <aws/glue/model/ConnectionTypeBrief.h>
#include <aws/glue/model/ConnectionTypeVariant.h>
#include <aws/glue/model/ConnectionsList.h>
#include <aws/glue/model/ConnectorDataSource.h>
#include <aws/glue/model/ConnectorDataTarget.h>
#include <aws/glue/model/Crawl.h>
#include <aws/glue/model/CrawlState.h>
#include <aws/glue/model/Crawler.h>
#include <aws/glue/model/CrawlerHistory.h>
#include <aws/glue/model/CrawlerHistoryState.h>
#include <aws/glue/model/CrawlerLineageSettings.h>
#include <aws/glue/model/CrawlerMetrics.h>
#include <aws/glue/model/CrawlerNodeDetails.h>
#include <aws/glue/model/CrawlerState.h>
#include <aws/glue/model/CrawlerTargets.h>
#include <aws/glue/model/CrawlsFilter.h>
#include <aws/glue/model/CreateBlueprintRequest.h>
#include <aws/glue/model/CreateBlueprintResult.h>
#include <aws/glue/model/CreateCatalogRequest.h>
#include <aws/glue/model/CreateCatalogResult.h>
#include <aws/glue/model/CreateClassifierRequest.h>
#include <aws/glue/model/CreateClassifierResult.h>
#include <aws/glue/model/CreateColumnStatisticsTaskSettingsRequest.h>
#include <aws/glue/model/CreateColumnStatisticsTaskSettingsResult.h>
#include <aws/glue/model/CreateConnectionRequest.h>
#include <aws/glue/model/CreateConnectionResult.h>
#include <aws/glue/model/CreateCrawlerRequest.h>
#include <aws/glue/model/CreateCrawlerResult.h>
#include <aws/glue/model/CreateCsvClassifierRequest.h>
#include <aws/glue/model/CreateCustomEntityTypeRequest.h>
#include <aws/glue/model/CreateCustomEntityTypeResult.h>
#include <aws/glue/model/CreateDataQualityRulesetRequest.h>
#include <aws/glue/model/CreateDataQualityRulesetResult.h>
#include <aws/glue/model/CreateDatabaseRequest.h>
#include <aws/glue/model/CreateDatabaseResult.h>
#include <aws/glue/model/CreateDevEndpointRequest.h>
#include <aws/glue/model/CreateDevEndpointResult.h>
#include <aws/glue/model/CreateGrokClassifierRequest.h>
#include <aws/glue/model/CreateIcebergTableInput.h>
#include <aws/glue/model/CreateIntegrationRequest.h>
#include <aws/glue/model/CreateIntegrationResourcePropertyRequest.h>
#include <aws/glue/model/CreateIntegrationResourcePropertyResult.h>
#include <aws/glue/model/CreateIntegrationResult.h>
#include <aws/glue/model/CreateIntegrationTablePropertiesRequest.h>
#include <aws/glue/model/CreateIntegrationTablePropertiesResult.h>
#include <aws/glue/model/CreateJobRequest.h>
#include <aws/glue/model/CreateJobResult.h>
#include <aws/glue/model/CreateJsonClassifierRequest.h>
#include <aws/glue/model/CreateMLTransformRequest.h>
#include <aws/glue/model/CreateMLTransformResult.h>
#include <aws/glue/model/CreatePartitionIndexRequest.h>
#include <aws/glue/model/CreatePartitionIndexResult.h>
#include <aws/glue/model/CreatePartitionRequest.h>
#include <aws/glue/model/CreatePartitionResult.h>
#include <aws/glue/model/CreateRegistryRequest.h>
#include <aws/glue/model/CreateRegistryResult.h>
#include <aws/glue/model/CreateSchemaRequest.h>
#include <aws/glue/model/CreateSchemaResult.h>
#include <aws/glue/model/CreateScriptRequest.h>
#include <aws/glue/model/CreateScriptResult.h>
#include <aws/glue/model/CreateSecurityConfigurationRequest.h>
#include <aws/glue/model/CreateSecurityConfigurationResult.h>
#include <aws/glue/model/CreateSessionRequest.h>
#include <aws/glue/model/CreateSessionResult.h>
#include <aws/glue/model/CreateTableOptimizerRequest.h>
#include <aws/glue/model/CreateTableOptimizerResult.h>
#include <aws/glue/model/CreateTableRequest.h>
#include <aws/glue/model/CreateTableResult.h>
#include <aws/glue/model/CreateTriggerRequest.h>
#include <aws/glue/model/CreateTriggerResult.h>
#include <aws/glue/model/CreateUsageProfileRequest.h>
#include <aws/glue/model/CreateUsageProfileResult.h>
#include <aws/glue/model/CreateUserDefinedFunctionRequest.h>
#include <aws/glue/model/CreateUserDefinedFunctionResult.h>
#include <aws/glue/model/CreateWorkflowRequest.h>
#include <aws/glue/model/CreateWorkflowResult.h>
#include <aws/glue/model/CreateXMLClassifierRequest.h>
#include <aws/glue/model/CsvClassifier.h>
#include <aws/glue/model/CsvHeaderOption.h>
#include <aws/glue/model/CsvSerdeOption.h>
#include <aws/glue/model/CustomCode.h>
#include <aws/glue/model/CustomEntityType.h>
#include <aws/glue/model/DQCompositeRuleEvaluationMethod.h>
#include <aws/glue/model/DQResultsPublishingOptions.h>
#include <aws/glue/model/DQStopJobOnFailureOptions.h>
#include <aws/glue/model/DQStopJobOnFailureTiming.h>
#include <aws/glue/model/DQTransformOutput.h>
#include <aws/glue/model/DataCatalogEncryptionSettings.h>
#include <aws/glue/model/DataFormat.h>
#include <aws/glue/model/DataLakeAccessProperties.h>
#include <aws/glue/model/DataLakeAccessPropertiesOutput.h>
#include <aws/glue/model/DataLakePrincipal.h>
#include <aws/glue/model/DataOperation.h>
#include <aws/glue/model/DataQualityAggregatedMetrics.h>
#include <aws/glue/model/DataQualityAnalyzerResult.h>
#include <aws/glue/model/DataQualityEncryption.h>
#include <aws/glue/model/DataQualityEncryptionMode.h>
#include <aws/glue/model/DataQualityEvaluationRunAdditionalRunOptions.h>
#include <aws/glue/model/DataQualityMetricValues.h>
#include <aws/glue/model/DataQualityModelStatus.h>
#include <aws/glue/model/DataQualityObservation.h>
#include <aws/glue/model/DataQualityResult.h>
#include <aws/glue/model/DataQualityResultDescription.h>
#include <aws/glue/model/DataQualityResultFilterCriteria.h>
#include <aws/glue/model/DataQualityRuleRecommendationRunDescription.h>
#include <aws/glue/model/DataQualityRuleRecommendationRunFilter.h>
#include <aws/glue/model/DataQualityRuleResult.h>
#include <aws/glue/model/DataQualityRuleResultStatus.h>
#include <aws/glue/model/DataQualityRulesetEvaluationRunDescription.h>
#include <aws/glue/model/DataQualityRulesetEvaluationRunFilter.h>
#include <aws/glue/model/DataQualityRulesetFilterCriteria.h>
#include <aws/glue/model/DataQualityRulesetListDetails.h>
#include <aws/glue/model/DataQualityTargetTable.h>
#include <aws/glue/model/DataSource.h>
#include <aws/glue/model/Database.h>
#include <aws/glue/model/DatabaseAttributes.h>
#include <aws/glue/model/DatabaseIdentifier.h>
#include <aws/glue/model/DatabaseInput.h>
#include <aws/glue/model/DatapointInclusionAnnotation.h>
#include <aws/glue/model/Datatype.h>
#include <aws/glue/model/DateColumnStatisticsData.h>
#include <aws/glue/model/DecimalColumnStatisticsData.h>
#include <aws/glue/model/DecimalNumber.h>
#include <aws/glue/model/DeleteBehavior.h>
#include <aws/glue/model/DeleteBlueprintRequest.h>
#include <aws/glue/model/DeleteBlueprintResult.h>
#include <aws/glue/model/DeleteCatalogRequest.h>
#include <aws/glue/model/DeleteCatalogResult.h>
#include <aws/glue/model/DeleteClassifierRequest.h>
#include <aws/glue/model/DeleteClassifierResult.h>
#include <aws/glue/model/DeleteColumnStatisticsForPartitionRequest.h>
#include <aws/glue/model/DeleteColumnStatisticsForPartitionResult.h>
#include <aws/glue/model/DeleteColumnStatisticsForTableRequest.h>
#include <aws/glue/model/DeleteColumnStatisticsForTableResult.h>
#include <aws/glue/model/DeleteColumnStatisticsTaskSettingsRequest.h>
#include <aws/glue/model/DeleteColumnStatisticsTaskSettingsResult.h>
#include <aws/glue/model/DeleteConnectionRequest.h>
#include <aws/glue/model/DeleteConnectionResult.h>
#include <aws/glue/model/DeleteCrawlerRequest.h>
#include <aws/glue/model/DeleteCrawlerResult.h>
#include <aws/glue/model/DeleteCustomEntityTypeRequest.h>
#include <aws/glue/model/DeleteCustomEntityTypeResult.h>
#include <aws/glue/model/DeleteDataQualityRulesetRequest.h>
#include <aws/glue/model/DeleteDataQualityRulesetResult.h>
#include <aws/glue/model/DeleteDatabaseRequest.h>
#include <aws/glue/model/DeleteDatabaseResult.h>
#include <aws/glue/model/DeleteDevEndpointRequest.h>
#include <aws/glue/model/DeleteDevEndpointResult.h>
#include <aws/glue/model/DeleteIntegrationRequest.h>
#include <aws/glue/model/DeleteIntegrationResult.h>
#include <aws/glue/model/DeleteIntegrationTablePropertiesRequest.h>
#include <aws/glue/model/DeleteIntegrationTablePropertiesResult.h>
#include <aws/glue/model/DeleteJobRequest.h>
#include <aws/glue/model/DeleteJobResult.h>
#include <aws/glue/model/DeleteMLTransformRequest.h>
#include <aws/glue/model/DeleteMLTransformResult.h>
#include <aws/glue/model/DeletePartitionIndexRequest.h>
#include <aws/glue/model/DeletePartitionIndexResult.h>
#include <aws/glue/model/DeletePartitionRequest.h>
#include <aws/glue/model/DeletePartitionResult.h>
#include <aws/glue/model/DeleteRegistryRequest.h>
#include <aws/glue/model/DeleteRegistryResult.h>
#include <aws/glue/model/DeleteResourcePolicyRequest.h>
#include <aws/glue/model/DeleteResourcePolicyResult.h>
#include <aws/glue/model/DeleteSchemaRequest.h>
#include <aws/glue/model/DeleteSchemaResult.h>
#include <aws/glue/model/DeleteSchemaVersionsRequest.h>
#include <aws/glue/model/DeleteSchemaVersionsResult.h>
#include <aws/glue/model/DeleteSecurityConfigurationRequest.h>
#include <aws/glue/model/DeleteSecurityConfigurationResult.h>
#include <aws/glue/model/DeleteSessionRequest.h>
#include <aws/glue/model/DeleteSessionResult.h>
#include <aws/glue/model/DeleteTableOptimizerRequest.h>
#include <aws/glue/model/DeleteTableOptimizerResult.h>
#include <aws/glue/model/DeleteTableRequest.h>
#include <aws/glue/model/DeleteTableResult.h>
#include <aws/glue/model/DeleteTableVersionRequest.h>
#include <aws/glue/model/DeleteTableVersionResult.h>
#include <aws/glue/model/DeleteTriggerRequest.h>
#include <aws/glue/model/DeleteTriggerResult.h>
#include <aws/glue/model/DeleteUsageProfileRequest.h>
#include <aws/glue/model/DeleteUsageProfileResult.h>
#include <aws/glue/model/DeleteUserDefinedFunctionRequest.h>
#include <aws/glue/model/DeleteUserDefinedFunctionResult.h>
#include <aws/glue/model/DeleteWorkflowRequest.h>
#include <aws/glue/model/DeleteWorkflowResult.h>
#include <aws/glue/model/DeltaTarget.h>
#include <aws/glue/model/DeltaTargetCompressionType.h>
#include <aws/glue/model/DescribeConnectionTypeRequest.h>
#include <aws/glue/model/DescribeConnectionTypeResult.h>
#include <aws/glue/model/DescribeEntityRequest.h>
#include <aws/glue/model/DescribeEntityResult.h>
#include <aws/glue/model/DescribeInboundIntegrationsRequest.h>
#include <aws/glue/model/DescribeInboundIntegrationsResult.h>
#include <aws/glue/model/DescribeIntegrationsRequest.h>
#include <aws/glue/model/DescribeIntegrationsResult.h>
#include <aws/glue/model/DevEndpoint.h>
#include <aws/glue/model/DevEndpointCustomLibraries.h>
#include <aws/glue/model/DirectJDBCSource.h>
#include <aws/glue/model/DirectKafkaSource.h>
#include <aws/glue/model/DirectKinesisSource.h>
#include <aws/glue/model/DirectSchemaChangePolicy.h>
#include <aws/glue/model/DoubleColumnStatisticsData.h>
#include <aws/glue/model/DropDuplicates.h>
#include <aws/glue/model/DropFields.h>
#include <aws/glue/model/DropNullFields.h>
#include <aws/glue/model/DynamicTransform.h>
#include <aws/glue/model/DynamoDBCatalogSource.h>
#include <aws/glue/model/DynamoDBTarget.h>
#include <aws/glue/model/Edge.h>
#include <aws/glue/model/EnableHybridValues.h>
#include <aws/glue/model/EncryptionAtRest.h>
#include <aws/glue/model/EncryptionConfiguration.h>
#include <aws/glue/model/Entity.h>
#include <aws/glue/model/EntityNotFoundException.h>
#include <aws/glue/model/ErrorDetail.h>
#include <aws/glue/model/ErrorDetails.h>
#include <aws/glue/model/EvaluateDataQuality.h>
#include <aws/glue/model/EvaluateDataQualityMultiFrame.h>
#include <aws/glue/model/EvaluationMetrics.h>
#include <aws/glue/model/EventBatchingCondition.h>
#include <aws/glue/model/ExecutionAttempt.h>
#include <aws/glue/model/ExecutionClass.h>
#include <aws/glue/model/ExecutionProperty.h>
#include <aws/glue/model/ExecutionStatus.h>
#include <aws/glue/model/ExistCondition.h>
#include <aws/glue/model/ExportLabelsTaskRunProperties.h>
#include <aws/glue/model/FederatedCatalog.h>
#include <aws/glue/model/FederatedDatabase.h>
#include <aws/glue/model/FederatedResourceAlreadyExistsException.h>
#include <aws/glue/model/FederatedTable.h>
#include <aws/glue/model/FederationSourceErrorCode.h>
#include <aws/glue/model/FederationSourceException.h>
#include <aws/glue/model/Field.h>
#include <aws/glue/model/FieldDataType.h>
#include <aws/glue/model/FieldFilterOperator.h>
#include <aws/glue/model/FieldName.h>
#include <aws/glue/model/FillMissingValues.h>
#include <aws/glue/model/Filter.h>
#include <aws/glue/model/FilterExpression.h>
#include <aws/glue/model/FilterLogicalOperator.h>
#include <aws/glue/model/FilterOperation.h>
#include <aws/glue/model/FilterOperator.h>
#include <aws/glue/model/FilterValue.h>
#include <aws/glue/model/FilterValueType.h>
#include <aws/glue/model/FindMatchesMetrics.h>
#include <aws/glue/model/FindMatchesParameters.h>
#include <aws/glue/model/FindMatchesTaskRunProperties.h>
#include <aws/glue/model/GetBlueprintRequest.h>
#include <aws/glue/model/GetBlueprintResult.h>
#include <aws/glue/model/GetBlueprintRunRequest.h>
#include <aws/glue/model/GetBlueprintRunResult.h>
#include <aws/glue/model/GetBlueprintRunsRequest.h>
#include <aws/glue/model/GetBlueprintRunsResult.h>
#include <aws/glue/model/GetCatalogImportStatusRequest.h>
#include <aws/glue/model/GetCatalogImportStatusResult.h>
#include <aws/glue/model/GetCatalogRequest.h>
#include <aws/glue/model/GetCatalogResult.h>
#include <aws/glue/model/GetCatalogsRequest.h>
#include <aws/glue/model/GetCatalogsResult.h>
#include <aws/glue/model/GetClassifierRequest.h>
#include <aws/glue/model/GetClassifierResult.h>
#include <aws/glue/model/GetClassifiersRequest.h>
#include <aws/glue/model/GetClassifiersResult.h>
#include <aws/glue/model/GetColumnStatisticsForPartitionRequest.h>
#include <aws/glue/model/GetColumnStatisticsForPartitionResult.h>
#include <aws/glue/model/GetColumnStatisticsForTableRequest.h>
#include <aws/glue/model/GetColumnStatisticsForTableResult.h>
#include <aws/glue/model/GetColumnStatisticsTaskRunRequest.h>
#include <aws/glue/model/GetColumnStatisticsTaskRunResult.h>
#include <aws/glue/model/GetColumnStatisticsTaskRunsRequest.h>
#include <aws/glue/model/GetColumnStatisticsTaskRunsResult.h>
#include <aws/glue/model/GetColumnStatisticsTaskSettingsRequest.h>
#include <aws/glue/model/GetColumnStatisticsTaskSettingsResult.h>
#include <aws/glue/model/GetConnectionRequest.h>
#include <aws/glue/model/GetConnectionResult.h>
#include <aws/glue/model/GetConnectionsFilter.h>
#include <aws/glue/model/GetConnectionsRequest.h>
#include <aws/glue/model/GetConnectionsResult.h>
#include <aws/glue/model/GetCrawlerMetricsRequest.h>
#include <aws/glue/model/GetCrawlerMetricsResult.h>
#include <aws/glue/model/GetCrawlerRequest.h>
#include <aws/glue/model/GetCrawlerResult.h>
#include <aws/glue/model/GetCrawlersRequest.h>
#include <aws/glue/model/GetCrawlersResult.h>
#include <aws/glue/model/GetCustomEntityTypeRequest.h>
#include <aws/glue/model/GetCustomEntityTypeResult.h>
#include <aws/glue/model/GetDataCatalogEncryptionSettingsRequest.h>
#include <aws/glue/model/GetDataCatalogEncryptionSettingsResult.h>
#include <aws/glue/model/GetDataQualityModelRequest.h>
#include <aws/glue/model/GetDataQualityModelResult.h>
#include <aws/glue/model/GetDataQualityModelResultRequest.h>
#include <aws/glue/model/GetDataQualityModelResultResult.h>
#include <aws/glue/model/GetDataQualityResultRequest.h>
#include <aws/glue/model/GetDataQualityResultResult.h>
#include <aws/glue/model/GetDataQualityRuleRecommendationRunRequest.h>
#include <aws/glue/model/GetDataQualityRuleRecommendationRunResult.h>
#include <aws/glue/model/GetDataQualityRulesetEvaluationRunRequest.h>
#include <aws/glue/model/GetDataQualityRulesetEvaluationRunResult.h>
#include <aws/glue/model/GetDataQualityRulesetRequest.h>
#include <aws/glue/model/GetDataQualityRulesetResult.h>
#include <aws/glue/model/GetDatabaseRequest.h>
#include <aws/glue/model/GetDatabaseResult.h>
#include <aws/glue/model/GetDatabasesRequest.h>
#include <aws/glue/model/GetDatabasesResult.h>
#include <aws/glue/model/GetDataflowGraphRequest.h>
#include <aws/glue/model/GetDataflowGraphResult.h>
#include <aws/glue/model/GetDevEndpointRequest.h>
#include <aws/glue/model/GetDevEndpointResult.h>
#include <aws/glue/model/GetDevEndpointsRequest.h>
#include <aws/glue/model/GetDevEndpointsResult.h>
#include <aws/glue/model/GetEntityRecordsRequest.h>
#include <aws/glue/model/GetEntityRecordsResult.h>
#include <aws/glue/model/GetIntegrationResourcePropertyRequest.h>
#include <aws/glue/model/GetIntegrationResourcePropertyResult.h>
#include <aws/glue/model/GetIntegrationTablePropertiesRequest.h>
#include <aws/glue/model/GetIntegrationTablePropertiesResult.h>
#include <aws/glue/model/GetJobBookmarkRequest.h>
#include <aws/glue/model/GetJobBookmarkResult.h>
#include <aws/glue/model/GetJobRequest.h>
#include <aws/glue/model/GetJobResult.h>
#include <aws/glue/model/GetJobRunRequest.h>
#include <aws/glue/model/GetJobRunResult.h>
#include <aws/glue/model/GetJobRunsRequest.h>
#include <aws/glue/model/GetJobRunsResult.h>
#include <aws/glue/model/GetJobsRequest.h>
#include <aws/glue/model/GetJobsResult.h>
#include <aws/glue/model/GetMLTaskRunRequest.h>
#include <aws/glue/model/GetMLTaskRunResult.h>
#include <aws/glue/model/GetMLTaskRunsRequest.h>
#include <aws/glue/model/GetMLTaskRunsResult.h>
#include <aws/glue/model/GetMLTransformRequest.h>
#include <aws/glue/model/GetMLTransformResult.h>
#include <aws/glue/model/GetMLTransformsRequest.h>
#include <aws/glue/model/GetMLTransformsResult.h>
#include <aws/glue/model/GetMappingRequest.h>
#include <aws/glue/model/GetMappingResult.h>
#include <aws/glue/model/GetPartitionIndexesRequest.h>
#include <aws/glue/model/GetPartitionIndexesResult.h>
#include <aws/glue/model/GetPartitionRequest.h>
#include <aws/glue/model/GetPartitionResult.h>
#include <aws/glue/model/GetPartitionsRequest.h>
#include <aws/glue/model/GetPartitionsResult.h>
#include <aws/glue/model/GetPlanRequest.h>
#include <aws/glue/model/GetPlanResult.h>
#include <aws/glue/model/GetRegistryRequest.h>
#include <aws/glue/model/GetRegistryResult.h>
#include <aws/glue/model/GetResourcePoliciesRequest.h>
#include <aws/glue/model/GetResourcePoliciesResult.h>
#include <aws/glue/model/GetResourcePolicyRequest.h>
#include <aws/glue/model/GetResourcePolicyResult.h>
#include <aws/glue/model/GetSchemaByDefinitionRequest.h>
#include <aws/glue/model/GetSchemaByDefinitionResult.h>
#include <aws/glue/model/GetSchemaRequest.h>
#include <aws/glue/model/GetSchemaResult.h>
#include <aws/glue/model/GetSchemaVersionRequest.h>
#include <aws/glue/model/GetSchemaVersionResult.h>
#include <aws/glue/model/GetSchemaVersionsDiffRequest.h>
#include <aws/glue/model/GetSchemaVersionsDiffResult.h>
#include <aws/glue/model/GetSecurityConfigurationRequest.h>
#include <aws/glue/model/GetSecurityConfigurationResult.h>
#include <aws/glue/model/GetSecurityConfigurationsRequest.h>
#include <aws/glue/model/GetSecurityConfigurationsResult.h>
#include <aws/glue/model/GetSessionRequest.h>
#include <aws/glue/model/GetSessionResult.h>
#include <aws/glue/model/GetStatementRequest.h>
#include <aws/glue/model/GetStatementResult.h>
#include <aws/glue/model/GetTableOptimizerRequest.h>
#include <aws/glue/model/GetTableOptimizerResult.h>
#include <aws/glue/model/GetTableRequest.h>
#include <aws/glue/model/GetTableResult.h>
#include <aws/glue/model/GetTableVersionRequest.h>
#include <aws/glue/model/GetTableVersionResult.h>
#include <aws/glue/model/GetTableVersionsRequest.h>
#include <aws/glue/model/GetTableVersionsResult.h>
#include <aws/glue/model/GetTablesRequest.h>
#include <aws/glue/model/GetTablesResult.h>
#include <aws/glue/model/GetTagsRequest.h>
#include <aws/glue/model/GetTagsResult.h>
#include <aws/glue/model/GetTriggerRequest.h>
#include <aws/glue/model/GetTriggerResult.h>
#include <aws/glue/model/GetTriggersRequest.h>
#include <aws/glue/model/GetTriggersResult.h>
#include <aws/glue/model/GetUnfilteredPartitionMetadataRequest.h>
#include <aws/glue/model/GetUnfilteredPartitionMetadataResult.h>
#include <aws/glue/model/GetUnfilteredPartitionsMetadataRequest.h>
#include <aws/glue/model/GetUnfilteredPartitionsMetadataResult.h>
#include <aws/glue/model/GetUnfilteredTableMetadataRequest.h>
#include <aws/glue/model/GetUnfilteredTableMetadataResult.h>
#include <aws/glue/model/GetUsageProfileRequest.h>
#include <aws/glue/model/GetUsageProfileResult.h>
#include <aws/glue/model/GetUserDefinedFunctionRequest.h>
#include <aws/glue/model/GetUserDefinedFunctionResult.h>
#include <aws/glue/model/GetUserDefinedFunctionsRequest.h>
#include <aws/glue/model/GetUserDefinedFunctionsResult.h>
#include <aws/glue/model/GetWorkflowRequest.h>
#include <aws/glue/model/GetWorkflowResult.h>
#include <aws/glue/model/GetWorkflowRunPropertiesRequest.h>
#include <aws/glue/model/GetWorkflowRunPropertiesResult.h>
#include <aws/glue/model/GetWorkflowRunRequest.h>
#include <aws/glue/model/GetWorkflowRunResult.h>
#include <aws/glue/model/GetWorkflowRunsRequest.h>
#include <aws/glue/model/GetWorkflowRunsResult.h>
#include <aws/glue/model/GluePolicy.h>
#include <aws/glue/model/GlueRecordType.h>
#include <aws/glue/model/GlueSchema.h>
#include <aws/glue/model/GlueStudioSchemaColumn.h>
#include <aws/glue/model/GlueTable.h>
#include <aws/glue/model/GovernedCatalogSource.h>
#include <aws/glue/model/GovernedCatalogTarget.h>
#include <aws/glue/model/GrokClassifier.h>
#include <aws/glue/model/HudiTarget.h>
#include <aws/glue/model/HudiTargetCompressionType.h>
#include <aws/glue/model/HyperTargetCompressionType.h>
#include <aws/glue/model/IcebergCompactionConfiguration.h>
#include <aws/glue/model/IcebergCompactionMetrics.h>
#include <aws/glue/model/IcebergInput.h>
#include <aws/glue/model/IcebergNullOrder.h>
#include <aws/glue/model/IcebergOrphanFileDeletionConfiguration.h>
#include <aws/glue/model/IcebergOrphanFileDeletionMetrics.h>
#include <aws/glue/model/IcebergPartitionField.h>
#include <aws/glue/model/IcebergPartitionSpec.h>
#include <aws/glue/model/IcebergRetentionConfiguration.h>
#include <aws/glue/model/IcebergRetentionMetrics.h>
#include <aws/glue/model/IcebergSchema.h>
#include <aws/glue/model/IcebergSortDirection.h>
#include <aws/glue/model/IcebergSortField.h>
#include <aws/glue/model/IcebergSortOrder.h>
#include <aws/glue/model/IcebergStructField.h>
#include <aws/glue/model/IcebergStructTypeEnum.h>
#include <aws/glue/model/IcebergTableUpdate.h>
#include <aws/glue/model/IcebergTarget.h>
#include <aws/glue/model/IcebergTargetCompressionType.h>
#include <aws/glue/model/ImportCatalogToGlueRequest.h>
#include <aws/glue/model/ImportCatalogToGlueResult.h>
#include <aws/glue/model/ImportLabelsTaskRunProperties.h>
#include <aws/glue/model/InboundIntegration.h>
#include <aws/glue/model/InclusionAnnotationValue.h>
#include <aws/glue/model/Integration.h>
#include <aws/glue/model/IntegrationConfig.h>
#include <aws/glue/model/IntegrationError.h>
#include <aws/glue/model/IntegrationFilter.h>
#include <aws/glue/model/IntegrationPartition.h>
#include <aws/glue/model/IntegrationStatus.h>
#include <aws/glue/model/InvalidInputException.h>
#include <aws/glue/model/JDBCConnectionType.h>
#include <aws/glue/model/JDBCConnectorOptions.h>
#include <aws/glue/model/JDBCConnectorSource.h>
#include <aws/glue/model/JDBCConnectorTarget.h>
#include <aws/glue/model/JDBCDataType.h>
#include <aws/glue/model/JdbcMetadataEntry.h>
#include <aws/glue/model/JdbcTarget.h>
#include <aws/glue/model/Job.h>
#include <aws/glue/model/JobBookmarkEntry.h>
#include <aws/glue/model/JobBookmarksEncryption.h>
#include <aws/glue/model/JobBookmarksEncryptionMode.h>
#include <aws/glue/model/JobCommand.h>
#include <aws/glue/model/JobMode.h>
#include <aws/glue/model/JobNodeDetails.h>
#include <aws/glue/model/JobRun.h>
#include <aws/glue/model/JobRunState.h>
#include <aws/glue/model/JobUpdate.h>
#include <aws/glue/model/Join.h>
#include <aws/glue/model/JoinColumn.h>
#include <aws/glue/model/JoinType.h>
#include <aws/glue/model/JsonClassifier.h>
#include <aws/glue/model/KafkaStreamingSourceOptions.h>
#include <aws/glue/model/KeySchemaElement.h>
#include <aws/glue/model/KinesisStreamingSourceOptions.h>
#include <aws/glue/model/LabelingSetGenerationTaskRunProperties.h>
#include <aws/glue/model/LakeFormationConfiguration.h>
#include <aws/glue/model/Language.h>
#include <aws/glue/model/LastActiveDefinition.h>
#include <aws/glue/model/LastCrawlInfo.h>
#include <aws/glue/model/LastCrawlStatus.h>
#include <aws/glue/model/LineageConfiguration.h>
#include <aws/glue/model/ListBlueprintsRequest.h>
#include <aws/glue/model/ListBlueprintsResult.h>
#include <aws/glue/model/ListColumnStatisticsTaskRunsRequest.h>
#include <aws/glue/model/ListColumnStatisticsTaskRunsResult.h>
#include <aws/glue/model/ListConnectionTypesRequest.h>
#include <aws/glue/model/ListConnectionTypesResult.h>
#include <aws/glue/model/ListCrawlersRequest.h>
#include <aws/glue/model/ListCrawlersResult.h>
#include <aws/glue/model/ListCrawlsRequest.h>
#include <aws/glue/model/ListCrawlsResult.h>
#include <aws/glue/model/ListCustomEntityTypesRequest.h>
#include <aws/glue/model/ListCustomEntityTypesResult.h>
#include <aws/glue/model/ListDataQualityResultsRequest.h>
#include <aws/glue/model/ListDataQualityResultsResult.h>
#include <aws/glue/model/ListDataQualityRuleRecommendationRunsRequest.h>
#include <aws/glue/model/ListDataQualityRuleRecommendationRunsResult.h>
#include <aws/glue/model/ListDataQualityRulesetEvaluationRunsRequest.h>
#include <aws/glue/model/ListDataQualityRulesetEvaluationRunsResult.h>
#include <aws/glue/model/ListDataQualityRulesetsRequest.h>
#include <aws/glue/model/ListDataQualityRulesetsResult.h>
#include <aws/glue/model/ListDataQualityStatisticAnnotationsRequest.h>
#include <aws/glue/model/ListDataQualityStatisticAnnotationsResult.h>
#include <aws/glue/model/ListDataQualityStatisticsRequest.h>
#include <aws/glue/model/ListDataQualityStatisticsResult.h>
#include <aws/glue/model/ListDevEndpointsRequest.h>
#include <aws/glue/model/ListDevEndpointsResult.h>
#include <aws/glue/model/ListEntitiesRequest.h>
#include <aws/glue/model/ListEntitiesResult.h>
#include <aws/glue/model/ListJobsRequest.h>
#include <aws/glue/model/ListJobsResult.h>
#include <aws/glue/model/ListMLTransformsRequest.h>
#include <aws/glue/model/ListMLTransformsResult.h>
#include <aws/glue/model/ListRegistriesRequest.h>
#include <aws/glue/model/ListRegistriesResult.h>
#include <aws/glue/model/ListSchemaVersionsRequest.h>
#include <aws/glue/model/ListSchemaVersionsResult.h>
#include <aws/glue/model/ListSchemasRequest.h>
#include <aws/glue/model/ListSchemasResult.h>
#include <aws/glue/model/ListSessionsRequest.h>
#include <aws/glue/model/ListSessionsResult.h>
#include <aws/glue/model/ListStatementsRequest.h>
#include <aws/glue/model/ListStatementsResult.h>
#include <aws/glue/model/ListTableOptimizerRunsRequest.h>
#include <aws/glue/model/ListTableOptimizerRunsResult.h>
#include <aws/glue/model/ListTriggersRequest.h>
#include <aws/glue/model/ListTriggersResult.h>
#include <aws/glue/model/ListUsageProfilesRequest.h>
#include <aws/glue/model/ListUsageProfilesResult.h>
#include <aws/glue/model/ListWorkflowsRequest.h>
#include <aws/glue/model/ListWorkflowsResult.h>
#include <aws/glue/model/Location.h>
#include <aws/glue/model/Logical.h>
#include <aws/glue/model/LogicalOperator.h>
#include <aws/glue/model/LongColumnStatisticsData.h>
#include <aws/glue/model/MLTransform.h>
#include <aws/glue/model/MLUserDataEncryption.h>
#include <aws/glue/model/MLUserDataEncryptionModeString.h>
#include <aws/glue/model/Mapping.h>
#include <aws/glue/model/MappingEntry.h>
#include <aws/glue/model/Merge.h>
#include <aws/glue/model/MetadataInfo.h>
#include <aws/glue/model/MetadataKeyValuePair.h>
#include <aws/glue/model/MetadataOperation.h>
#include <aws/glue/model/MetricBasedObservation.h>
#include <aws/glue/model/MicrosoftSQLServerCatalogSource.h>
#include <aws/glue/model/MicrosoftSQLServerCatalogTarget.h>
#include <aws/glue/model/ModifyIntegrationRequest.h>
#include <aws/glue/model/ModifyIntegrationResult.h>
#include <aws/glue/model/MongoDBTarget.h>
#include <aws/glue/model/MySQLCatalogSource.h>
#include <aws/glue/model/MySQLCatalogTarget.h>
#include <aws/glue/model/Node.h>
#include <aws/glue/model/NodeType.h>
#include <aws/glue/model/NotificationProperty.h>
#include <aws/glue/model/NullCheckBoxList.h>
#include <aws/glue/model/NullValueField.h>
#include <aws/glue/model/OAuth2ClientApplication.h>
#include <aws/glue/model/OAuth2Credentials.h>
#include <aws/glue/model/OAuth2GrantType.h>
#include <aws/glue/model/OAuth2Properties.h>
#include <aws/glue/model/OAuth2PropertiesInput.h>
#include <aws/glue/model/OpenTableFormatInput.h>
#include <aws/glue/model/Option.h>
#include <aws/glue/model/OracleSQLCatalogSource.h>
#include <aws/glue/model/OracleSQLCatalogTarget.h>
#include <aws/glue/model/Order.h>
#include <aws/glue/model/OrphanFileDeletionConfiguration.h>
#include <aws/glue/model/OrphanFileDeletionMetrics.h>
#include <aws/glue/model/OtherMetadataValueListItem.h>
#include <aws/glue/model/PIIDetection.h>
#include <aws/glue/model/ParamType.h>
#include <aws/glue/model/ParquetCompressionType.h>
#include <aws/glue/model/Partition.h>
#include <aws/glue/model/PartitionError.h>
#include <aws/glue/model/PartitionIndex.h>
#include <aws/glue/model/PartitionIndexDescriptor.h>
#include <aws/glue/model/PartitionIndexStatus.h>
#include <aws/glue/model/PartitionInput.h>
#include <aws/glue/model/PartitionValueList.h>
#include <aws/glue/model/Permission.h>
#include <aws/glue/model/PermissionType.h>
#include <aws/glue/model/PhysicalConnectionRequirements.h>
#include <aws/glue/model/PiiType.h>
#include <aws/glue/model/PostgreSQLCatalogSource.h>
#include <aws/glue/model/PostgreSQLCatalogTarget.h>
#include <aws/glue/model/Predecessor.h>
#include <aws/glue/model/Predicate.h>
#include <aws/glue/model/PrincipalPermissions.h>
#include <aws/glue/model/PrincipalType.h>
#include <aws/glue/model/ProfileConfiguration.h>
#include <aws/glue/model/Property.h>
#include <aws/glue/model/PropertyPredicate.h>
#include <aws/glue/model/PropertyType.h>
#include <aws/glue/model/PutDataCatalogEncryptionSettingsRequest.h>
#include <aws/glue/model/PutDataCatalogEncryptionSettingsResult.h>
#include <aws/glue/model/PutDataQualityProfileAnnotationRequest.h>
#include <aws/glue/model/PutDataQualityProfileAnnotationResult.h>
#include <aws/glue/model/PutResourcePolicyRequest.h>
#include <aws/glue/model/PutResourcePolicyResult.h>
#include <aws/glue/model/PutSchemaVersionMetadataRequest.h>
#include <aws/glue/model/PutSchemaVersionMetadataResult.h>
#include <aws/glue/model/PutWorkflowRunPropertiesRequest.h>
#include <aws/glue/model/PutWorkflowRunPropertiesResult.h>
#include <aws/glue/model/QuerySchemaVersionMetadataRequest.h>
#include <aws/glue/model/QuerySchemaVersionMetadataResult.h>
#include <aws/glue/model/QuerySessionContext.h>
#include <aws/glue/model/QuoteChar.h>
#include <aws/glue/model/Recipe.h>
#include <aws/glue/model/RecipeAction.h>
#include <aws/glue/model/RecipeReference.h>
#include <aws/glue/model/RecipeStep.h>
#include <aws/glue/model/RecrawlBehavior.h>
#include <aws/glue/model/RecrawlPolicy.h>
#include <aws/glue/model/RedshiftSource.h>
#include <aws/glue/model/RedshiftTarget.h>
#include <aws/glue/model/RegisterSchemaVersionRequest.h>
#include <aws/glue/model/RegisterSchemaVersionResult.h>
#include <aws/glue/model/RegistryId.h>
#include <aws/glue/model/RegistryListItem.h>
#include <aws/glue/model/RegistryStatus.h>
#include <aws/glue/model/RelationalCatalogSource.h>
#include <aws/glue/model/RemoveSchemaVersionMetadataRequest.h>
#include <aws/glue/model/RemoveSchemaVersionMetadataResult.h>
#include <aws/glue/model/RenameField.h>
#include <aws/glue/model/ResetJobBookmarkRequest.h>
#include <aws/glue/model/ResetJobBookmarkResult.h>
#include <aws/glue/model/ResourceAction.h>
#include <aws/glue/model/ResourceShareType.h>
#include <aws/glue/model/ResourceState.h>
#include <aws/glue/model/ResourceType.h>
#include <aws/glue/model/ResourceUri.h>
#include <aws/glue/model/ResumeWorkflowRunRequest.h>
#include <aws/glue/model/ResumeWorkflowRunResult.h>
#include <aws/glue/model/RetentionConfiguration.h>
#include <aws/glue/model/RetentionMetrics.h>
#include <aws/glue/model/RunIdentifier.h>
#include <aws/glue/model/RunStatementRequest.h>
#include <aws/glue/model/RunStatementResult.h>
#include <aws/glue/model/S3CatalogDeltaSource.h>
#include <aws/glue/model/S3CatalogHudiSource.h>
#include <aws/glue/model/S3CatalogSource.h>
#include <aws/glue/model/S3CatalogTarget.h>
#include <aws/glue/model/S3CsvSource.h>
#include <aws/glue/model/S3DeltaCatalogTarget.h>
#include <aws/glue/model/S3DeltaDirectTarget.h>
#include <aws/glue/model/S3DeltaSource.h>
#include <aws/glue/model/S3DirectSourceAdditionalOptions.h>
#include <aws/glue/model/S3DirectTarget.h>
#include <aws/glue/model/S3Encryption.h>
#include <aws/glue/model/S3EncryptionMode.h>
#include <aws/glue/model/S3ExcelSource.h>
#include <aws/glue/model/S3GlueParquetTarget.h>
#include <aws/glue/model/S3HudiCatalogTarget.h>
#include <aws/glue/model/S3HudiDirectTarget.h>
#include <aws/glue/model/S3HudiSource.h>
#include <aws/glue/model/S3HyperDirectTarget.h>
#include <aws/glue/model/S3IcebergDirectTarget.h>
#include <aws/glue/model/S3JsonSource.h>
#include <aws/glue/model/S3ParquetSource.h>
#include <aws/glue/model/S3SourceAdditionalOptions.h>
#include <aws/glue/model/S3Target.h>
#include <aws/glue/model/Schedule.h>
#include <aws/glue/model/ScheduleState.h>
#include <aws/glue/model/ScheduleType.h>
#include <aws/glue/model/SchemaChangePolicy.h>
#include <aws/glue/model/SchemaColumn.h>
#include <aws/glue/model/SchemaDiffType.h>
#include <aws/glue/model/SchemaId.h>
#include <aws/glue/model/SchemaListItem.h>
#include <aws/glue/model/SchemaReference.h>
#include <aws/glue/model/SchemaStatus.h>
#include <aws/glue/model/SchemaVersionErrorItem.h>
#include <aws/glue/model/SchemaVersionListItem.h>
#include <aws/glue/model/SchemaVersionNumber.h>
#include <aws/glue/model/SchemaVersionStatus.h>
#include <aws/glue/model/SearchTablesRequest.h>
#include <aws/glue/model/SearchTablesResult.h>
#include <aws/glue/model/SecurityConfiguration.h>
#include <aws/glue/model/Segment.h>
#include <aws/glue/model/SelectFields.h>
#include <aws/glue/model/SelectFromCollection.h>
#include <aws/glue/model/Separator.h>
#include <aws/glue/model/SerDeInfo.h>
#include <aws/glue/model/Session.h>
#include <aws/glue/model/SessionCommand.h>
#include <aws/glue/model/SessionStatus.h>
#include <aws/glue/model/SettingSource.h>
#include <aws/glue/model/SkewedInfo.h>
#include <aws/glue/model/SnowflakeNodeData.h>
#include <aws/glue/model/SnowflakeSource.h>
#include <aws/glue/model/SnowflakeTarget.h>
#include <aws/glue/model/Sort.h>
#include <aws/glue/model/SortCriterion.h>
#include <aws/glue/model/SortDirectionType.h>
#include <aws/glue/model/SourceControlAuthStrategy.h>
#include <aws/glue/model/SourceControlDetails.h>
#include <aws/glue/model/SourceControlProvider.h>
#include <aws/glue/model/SourceProcessingProperties.h>
#include <aws/glue/model/SourceTableConfig.h>
#include <aws/glue/model/SparkConnectorSource.h>
#include <aws/glue/model/SparkConnectorTarget.h>
#include <aws/glue/model/SparkSQL.h>
#include <aws/glue/model/Spigot.h>
#include <aws/glue/model/SplitFields.h>
#include <aws/glue/model/SqlAlias.h>
#include <aws/glue/model/StartBlueprintRunRequest.h>
#include <aws/glue/model/StartBlueprintRunResult.h>
#include <aws/glue/model/StartColumnStatisticsTaskRunRequest.h>
#include <aws/glue/model/StartColumnStatisticsTaskRunResult.h>
#include <aws/glue/model/StartColumnStatisticsTaskRunScheduleRequest.h>
#include <aws/glue/model/StartColumnStatisticsTaskRunScheduleResult.h>
#include <aws/glue/model/StartCrawlerRequest.h>
#include <aws/glue/model/StartCrawlerResult.h>
#include <aws/glue/model/StartCrawlerScheduleRequest.h>
#include <aws/glue/model/StartCrawlerScheduleResult.h>
#include <aws/glue/model/StartDataQualityRuleRecommendationRunRequest.h>
#include <aws/glue/model/StartDataQualityRuleRecommendationRunResult.h>
#include <aws/glue/model/StartDataQualityRulesetEvaluationRunRequest.h>
#include <aws/glue/model/StartDataQualityRulesetEvaluationRunResult.h>
#include <aws/glue/model/StartExportLabelsTaskRunRequest.h>
#include <aws/glue/model/StartExportLabelsTaskRunResult.h>
#include <aws/glue/model/StartImportLabelsTaskRunRequest.h>
#include <aws/glue/model/StartImportLabelsTaskRunResult.h>
#include <aws/glue/model/StartJobRunRequest.h>
#include <aws/glue/model/StartJobRunResult.h>
#include <aws/glue/model/StartMLEvaluationTaskRunRequest.h>
#include <aws/glue/model/StartMLEvaluationTaskRunResult.h>
#include <aws/glue/model/StartMLLabelingSetGenerationTaskRunRequest.h>
#include <aws/glue/model/StartMLLabelingSetGenerationTaskRunResult.h>
#include <aws/glue/model/StartTriggerRequest.h>
#include <aws/glue/model/StartTriggerResult.h>
#include <aws/glue/model/StartWorkflowRunRequest.h>
#include <aws/glue/model/StartWorkflowRunResult.h>
#include <aws/glue/model/StartingEventBatchCondition.h>
#include <aws/glue/model/StartingPosition.h>
#include <aws/glue/model/Statement.h>
#include <aws/glue/model/StatementOutput.h>
#include <aws/glue/model/StatementOutputData.h>
#include <aws/glue/model/StatementState.h>
#include <aws/glue/model/StatisticAnnotation.h>
#include <aws/glue/model/StatisticEvaluationLevel.h>
#include <aws/glue/model/StatisticModelResult.h>
#include <aws/glue/model/StatisticSummary.h>
#include <aws/glue/model/StatusDetails.h>
#include <aws/glue/model/StopColumnStatisticsTaskRunRequest.h>
#include <aws/glue/model/StopColumnStatisticsTaskRunResult.h>
#include <aws/glue/model/StopColumnStatisticsTaskRunScheduleRequest.h>
#include <aws/glue/model/StopColumnStatisticsTaskRunScheduleResult.h>
#include <aws/glue/model/StopCrawlerRequest.h>
#include <aws/glue/model/StopCrawlerResult.h>
#include <aws/glue/model/StopCrawlerScheduleRequest.h>
#include <aws/glue/model/StopCrawlerScheduleResult.h>
#include <aws/glue/model/StopSessionRequest.h>
#include <aws/glue/model/StopSessionResult.h>
#include <aws/glue/model/StopTriggerRequest.h>
#include <aws/glue/model/StopTriggerResult.h>
#include <aws/glue/model/StopWorkflowRunRequest.h>
#include <aws/glue/model/StopWorkflowRunResult.h>
#include <aws/glue/model/StorageDescriptor.h>
#include <aws/glue/model/StreamingDataPreviewOptions.h>
#include <aws/glue/model/StringColumnStatisticsData.h>
#include <aws/glue/model/SupportedDialect.h>
#include <aws/glue/model/Table.h>
#include <aws/glue/model/TableAttributes.h>
#include <aws/glue/model/TableError.h>
#include <aws/glue/model/TableIdentifier.h>
#include <aws/glue/model/TableInput.h>
#include <aws/glue/model/TableOptimizer.h>
#include <aws/glue/model/TableOptimizerConfiguration.h>
#include <aws/glue/model/TableOptimizerEventType.h>
#include <aws/glue/model/TableOptimizerRun.h>
#include <aws/glue/model/TableOptimizerType.h>
#include <aws/glue/model/TableOptimizerVpcConfiguration.h>
#include <aws/glue/model/TableStatus.h>
#include <aws/glue/model/TableVersion.h>
#include <aws/glue/model/TableVersionError.h>
#include <aws/glue/model/Tag.h>
#include <aws/glue/model/TagResourceRequest.h>
#include <aws/glue/model/TagResourceResult.h>
#include <aws/glue/model/TargetFormat.h>
#include <aws/glue/model/TargetProcessingProperties.h>
#include <aws/glue/model/TargetRedshiftCatalog.h>
#include <aws/glue/model/TargetTableConfig.h>
#include <aws/glue/model/TaskRun.h>
#include <aws/glue/model/TaskRunFilterCriteria.h>
#include <aws/glue/model/TaskRunProperties.h>
#include <aws/glue/model/TaskRunSortColumnType.h>
#include <aws/glue/model/TaskRunSortCriteria.h>
#include <aws/glue/model/TaskStatusType.h>
#include <aws/glue/model/TaskType.h>
#include <aws/glue/model/TestConnectionInput.h>
#include <aws/glue/model/TestConnectionRequest.h>
#include <aws/glue/model/TestConnectionResult.h>
#include <aws/glue/model/TimestampFilter.h>
#include <aws/glue/model/TimestampedInclusionAnnotation.h>
#include <aws/glue/model/TransformConfigParameter.h>
#include <aws/glue/model/TransformEncryption.h>
#include <aws/glue/model/TransformFilterCriteria.h>
#include <aws/glue/model/TransformParameters.h>
#include <aws/glue/model/TransformSortColumnType.h>
#include <aws/glue/model/TransformSortCriteria.h>
#include <aws/glue/model/TransformStatusType.h>
#include <aws/glue/model/TransformType.h>
#include <aws/glue/model/Trigger.h>
#include <aws/glue/model/TriggerNodeDetails.h>
#include <aws/glue/model/TriggerState.h>
#include <aws/glue/model/TriggerType.h>
#include <aws/glue/model/TriggerUpdate.h>
#include <aws/glue/model/UnfilteredPartition.h>
#include <aws/glue/model/Union.h>
#include <aws/glue/model/UnionType.h>
#include <aws/glue/model/UnnestSpec.h>
#include <aws/glue/model/UntagResourceRequest.h>
#include <aws/glue/model/UntagResourceResult.h>
#include <aws/glue/model/UpdateBehavior.h>
#include <aws/glue/model/UpdateBlueprintRequest.h>
#include <aws/glue/model/UpdateBlueprintResult.h>
#include <aws/glue/model/UpdateCatalogBehavior.h>
#include <aws/glue/model/UpdateCatalogRequest.h>
#include <aws/glue/model/UpdateCatalogResult.h>
#include <aws/glue/model/UpdateClassifierRequest.h>
#include <aws/glue/model/UpdateClassifierResult.h>
#include <aws/glue/model/UpdateColumnStatisticsForPartitionRequest.h>
#include <aws/glue/model/UpdateColumnStatisticsForPartitionResult.h>
#include <aws/glue/model/UpdateColumnStatisticsForTableRequest.h>
#include <aws/glue/model/UpdateColumnStatisticsForTableResult.h>
#include <aws/glue/model/UpdateColumnStatisticsTaskSettingsRequest.h>
#include <aws/glue/model/UpdateColumnStatisticsTaskSettingsResult.h>
#include <aws/glue/model/UpdateConnectionRequest.h>
#include <aws/glue/model/UpdateConnectionResult.h>
#include <aws/glue/model/UpdateCrawlerRequest.h>
#include <aws/glue/model/UpdateCrawlerResult.h>
#include <aws/glue/model/UpdateCrawlerScheduleRequest.h>
#include <aws/glue/model/UpdateCrawlerScheduleResult.h>
#include <aws/glue/model/UpdateCsvClassifierRequest.h>
#include <aws/glue/model/UpdateDataQualityRulesetRequest.h>
#include <aws/glue/model/UpdateDataQualityRulesetResult.h>
#include <aws/glue/model/UpdateDatabaseRequest.h>
#include <aws/glue/model/UpdateDatabaseResult.h>
#include <aws/glue/model/UpdateDevEndpointRequest.h>
#include <aws/glue/model/UpdateDevEndpointResult.h>
#include <aws/glue/model/UpdateGrokClassifierRequest.h>
#include <aws/glue/model/UpdateIcebergInput.h>
#include <aws/glue/model/UpdateIcebergTableInput.h>
#include <aws/glue/model/UpdateIntegrationResourcePropertyRequest.h>
#include <aws/glue/model/UpdateIntegrationResourcePropertyResult.h>
#include <aws/glue/model/UpdateIntegrationTablePropertiesRequest.h>
#include <aws/glue/model/UpdateIntegrationTablePropertiesResult.h>
#include <aws/glue/model/UpdateJobFromSourceControlRequest.h>
#include <aws/glue/model/UpdateJobFromSourceControlResult.h>
#include <aws/glue/model/UpdateJobRequest.h>
#include <aws/glue/model/UpdateJobResult.h>
#include <aws/glue/model/UpdateJsonClassifierRequest.h>
#include <aws/glue/model/UpdateMLTransformRequest.h>
#include <aws/glue/model/UpdateMLTransformResult.h>
#include <aws/glue/model/UpdateOpenTableFormatInput.h>
#include <aws/glue/model/UpdatePartitionRequest.h>
#include <aws/glue/model/UpdatePartitionResult.h>
#include <aws/glue/model/UpdateRegistryRequest.h>
#include <aws/glue/model/UpdateRegistryResult.h>
#include <aws/glue/model/UpdateSchemaRequest.h>
#include <aws/glue/model/UpdateSchemaResult.h>
#include <aws/glue/model/UpdateSourceControlFromJobRequest.h>
#include <aws/glue/model/UpdateSourceControlFromJobResult.h>
#include <aws/glue/model/UpdateTableOptimizerRequest.h>
#include <aws/glue/model/UpdateTableOptimizerResult.h>
#include <aws/glue/model/UpdateTableRequest.h>
#include <aws/glue/model/UpdateTableResult.h>
#include <aws/glue/model/UpdateTriggerRequest.h>
#include <aws/glue/model/UpdateTriggerResult.h>
#include <aws/glue/model/UpdateUsageProfileRequest.h>
#include <aws/glue/model/UpdateUsageProfileResult.h>
#include <aws/glue/model/UpdateUserDefinedFunctionRequest.h>
#include <aws/glue/model/UpdateUserDefinedFunctionResult.h>
#include <aws/glue/model/UpdateWorkflowRequest.h>
#include <aws/glue/model/UpdateWorkflowResult.h>
#include <aws/glue/model/UpdateXMLClassifierRequest.h>
#include <aws/glue/model/UpsertRedshiftTargetOptions.h>
#include <aws/glue/model/UsageProfileDefinition.h>
#include <aws/glue/model/UserDefinedFunction.h>
#include <aws/glue/model/UserDefinedFunctionInput.h>
#include <aws/glue/model/ViewDefinition.h>
#include <aws/glue/model/ViewDefinitionInput.h>
#include <aws/glue/model/ViewDialect.h>
#include <aws/glue/model/ViewRepresentation.h>
#include <aws/glue/model/ViewRepresentationInput.h>
#include <aws/glue/model/ViewUpdateAction.h>
#include <aws/glue/model/ViewValidation.h>
#include <aws/glue/model/WorkerType.h>
#include <aws/glue/model/Workflow.h>
#include <aws/glue/model/WorkflowGraph.h>
#include <aws/glue/model/WorkflowRun.h>
#include <aws/glue/model/WorkflowRunStatistics.h>
#include <aws/glue/model/WorkflowRunStatus.h>
#include <aws/glue/model/XMLClassifier.h>

using GlueIncludeTest = ::testing::Test;

TEST_F(GlueIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::Glue::GlueClient>("GlueIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
