/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/greengrass/GreengrassClient.h>
#include <aws/greengrass/GreengrassEndpointProvider.h>
#include <aws/greengrass/GreengrassEndpointRules.h>
#include <aws/greengrass/GreengrassErrorMarshaller.h>
#include <aws/greengrass/GreengrassErrors.h>
#include <aws/greengrass/GreengrassRequest.h>
#include <aws/greengrass/GreengrassServiceClientModel.h>
#include <aws/greengrass/Greengrass_EXPORTS.h>
#include <aws/greengrass/model/AssociateRoleToGroupRequest.h>
#include <aws/greengrass/model/AssociateRoleToGroupResult.h>
#include <aws/greengrass/model/AssociateServiceRoleToAccountRequest.h>
#include <aws/greengrass/model/AssociateServiceRoleToAccountResult.h>
#include <aws/greengrass/model/BadRequestException.h>
#include <aws/greengrass/model/BulkDeployment.h>
#include <aws/greengrass/model/BulkDeploymentMetrics.h>
#include <aws/greengrass/model/BulkDeploymentResult.h>
#include <aws/greengrass/model/BulkDeploymentStatus.h>
#include <aws/greengrass/model/ConfigurationSyncStatus.h>
#include <aws/greengrass/model/ConnectivityInfo.h>
#include <aws/greengrass/model/Connector.h>
#include <aws/greengrass/model/ConnectorDefinitionVersion.h>
#include <aws/greengrass/model/Core.h>
#include <aws/greengrass/model/CoreDefinitionVersion.h>
#include <aws/greengrass/model/CreateConnectorDefinitionRequest.h>
#include <aws/greengrass/model/CreateConnectorDefinitionResult.h>
#include <aws/greengrass/model/CreateConnectorDefinitionVersionRequest.h>
#include <aws/greengrass/model/CreateConnectorDefinitionVersionResult.h>
#include <aws/greengrass/model/CreateCoreDefinitionRequest.h>
#include <aws/greengrass/model/CreateCoreDefinitionResult.h>
#include <aws/greengrass/model/CreateCoreDefinitionVersionRequest.h>
#include <aws/greengrass/model/CreateCoreDefinitionVersionResult.h>
#include <aws/greengrass/model/CreateDeploymentRequest.h>
#include <aws/greengrass/model/CreateDeploymentResult.h>
#include <aws/greengrass/model/CreateDeviceDefinitionRequest.h>
#include <aws/greengrass/model/CreateDeviceDefinitionResult.h>
#include <aws/greengrass/model/CreateDeviceDefinitionVersionRequest.h>
#include <aws/greengrass/model/CreateDeviceDefinitionVersionResult.h>
#include <aws/greengrass/model/CreateFunctionDefinitionRequest.h>
#include <aws/greengrass/model/CreateFunctionDefinitionResult.h>
#include <aws/greengrass/model/CreateFunctionDefinitionVersionRequest.h>
#include <aws/greengrass/model/CreateFunctionDefinitionVersionResult.h>
#include <aws/greengrass/model/CreateGroupCertificateAuthorityRequest.h>
#include <aws/greengrass/model/CreateGroupCertificateAuthorityResult.h>
#include <aws/greengrass/model/CreateGroupRequest.h>
#include <aws/greengrass/model/CreateGroupResult.h>
#include <aws/greengrass/model/CreateGroupVersionRequest.h>
#include <aws/greengrass/model/CreateGroupVersionResult.h>
#include <aws/greengrass/model/CreateLoggerDefinitionRequest.h>
#include <aws/greengrass/model/CreateLoggerDefinitionResult.h>
#include <aws/greengrass/model/CreateLoggerDefinitionVersionRequest.h>
#include <aws/greengrass/model/CreateLoggerDefinitionVersionResult.h>
#include <aws/greengrass/model/CreateResourceDefinitionRequest.h>
#include <aws/greengrass/model/CreateResourceDefinitionResult.h>
#include <aws/greengrass/model/CreateResourceDefinitionVersionRequest.h>
#include <aws/greengrass/model/CreateResourceDefinitionVersionResult.h>
#include <aws/greengrass/model/CreateSoftwareUpdateJobRequest.h>
#include <aws/greengrass/model/CreateSoftwareUpdateJobResult.h>
#include <aws/greengrass/model/CreateSubscriptionDefinitionRequest.h>
#include <aws/greengrass/model/CreateSubscriptionDefinitionResult.h>
#include <aws/greengrass/model/CreateSubscriptionDefinitionVersionRequest.h>
#include <aws/greengrass/model/CreateSubscriptionDefinitionVersionResult.h>
#include <aws/greengrass/model/DefinitionInformation.h>
#include <aws/greengrass/model/DeleteConnectorDefinitionRequest.h>
#include <aws/greengrass/model/DeleteConnectorDefinitionResult.h>
#include <aws/greengrass/model/DeleteCoreDefinitionRequest.h>
#include <aws/greengrass/model/DeleteCoreDefinitionResult.h>
#include <aws/greengrass/model/DeleteDeviceDefinitionRequest.h>
#include <aws/greengrass/model/DeleteDeviceDefinitionResult.h>
#include <aws/greengrass/model/DeleteFunctionDefinitionRequest.h>
#include <aws/greengrass/model/DeleteFunctionDefinitionResult.h>
#include <aws/greengrass/model/DeleteGroupRequest.h>
#include <aws/greengrass/model/DeleteGroupResult.h>
#include <aws/greengrass/model/DeleteLoggerDefinitionRequest.h>
#include <aws/greengrass/model/DeleteLoggerDefinitionResult.h>
#include <aws/greengrass/model/DeleteResourceDefinitionRequest.h>
#include <aws/greengrass/model/DeleteResourceDefinitionResult.h>
#include <aws/greengrass/model/DeleteSubscriptionDefinitionRequest.h>
#include <aws/greengrass/model/DeleteSubscriptionDefinitionResult.h>
#include <aws/greengrass/model/Deployment.h>
#include <aws/greengrass/model/DeploymentType.h>
#include <aws/greengrass/model/Device.h>
#include <aws/greengrass/model/DeviceDefinitionVersion.h>
#include <aws/greengrass/model/DisassociateRoleFromGroupRequest.h>
#include <aws/greengrass/model/DisassociateRoleFromGroupResult.h>
#include <aws/greengrass/model/DisassociateServiceRoleFromAccountRequest.h>
#include <aws/greengrass/model/DisassociateServiceRoleFromAccountResult.h>
#include <aws/greengrass/model/EncodingType.h>
#include <aws/greengrass/model/ErrorDetail.h>
#include <aws/greengrass/model/Function.h>
#include <aws/greengrass/model/FunctionConfiguration.h>
#include <aws/greengrass/model/FunctionConfigurationEnvironment.h>
#include <aws/greengrass/model/FunctionDefaultConfig.h>
#include <aws/greengrass/model/FunctionDefaultExecutionConfig.h>
#include <aws/greengrass/model/FunctionDefinitionVersion.h>
#include <aws/greengrass/model/FunctionExecutionConfig.h>
#include <aws/greengrass/model/FunctionIsolationMode.h>
#include <aws/greengrass/model/FunctionRunAsConfig.h>
#include <aws/greengrass/model/GetAssociatedRoleRequest.h>
#include <aws/greengrass/model/GetAssociatedRoleResult.h>
#include <aws/greengrass/model/GetBulkDeploymentStatusRequest.h>
#include <aws/greengrass/model/GetBulkDeploymentStatusResult.h>
#include <aws/greengrass/model/GetConnectivityInfoRequest.h>
#include <aws/greengrass/model/GetConnectivityInfoResult.h>
#include <aws/greengrass/model/GetConnectorDefinitionRequest.h>
#include <aws/greengrass/model/GetConnectorDefinitionResult.h>
#include <aws/greengrass/model/GetConnectorDefinitionVersionRequest.h>
#include <aws/greengrass/model/GetConnectorDefinitionVersionResult.h>
#include <aws/greengrass/model/GetCoreDefinitionRequest.h>
#include <aws/greengrass/model/GetCoreDefinitionResult.h>
#include <aws/greengrass/model/GetCoreDefinitionVersionRequest.h>
#include <aws/greengrass/model/GetCoreDefinitionVersionResult.h>
#include <aws/greengrass/model/GetDeploymentStatusRequest.h>
#include <aws/greengrass/model/GetDeploymentStatusResult.h>
#include <aws/greengrass/model/GetDeviceDefinitionRequest.h>
#include <aws/greengrass/model/GetDeviceDefinitionResult.h>
#include <aws/greengrass/model/GetDeviceDefinitionVersionRequest.h>
#include <aws/greengrass/model/GetDeviceDefinitionVersionResult.h>
#include <aws/greengrass/model/GetFunctionDefinitionRequest.h>
#include <aws/greengrass/model/GetFunctionDefinitionResult.h>
#include <aws/greengrass/model/GetFunctionDefinitionVersionRequest.h>
#include <aws/greengrass/model/GetFunctionDefinitionVersionResult.h>
#include <aws/greengrass/model/GetGroupCertificateAuthorityRequest.h>
#include <aws/greengrass/model/GetGroupCertificateAuthorityResult.h>
#include <aws/greengrass/model/GetGroupCertificateConfigurationRequest.h>
#include <aws/greengrass/model/GetGroupCertificateConfigurationResult.h>
#include <aws/greengrass/model/GetGroupRequest.h>
#include <aws/greengrass/model/GetGroupResult.h>
#include <aws/greengrass/model/GetGroupVersionRequest.h>
#include <aws/greengrass/model/GetGroupVersionResult.h>
#include <aws/greengrass/model/GetLoggerDefinitionRequest.h>
#include <aws/greengrass/model/GetLoggerDefinitionResult.h>
#include <aws/greengrass/model/GetLoggerDefinitionVersionRequest.h>
#include <aws/greengrass/model/GetLoggerDefinitionVersionResult.h>
#include <aws/greengrass/model/GetResourceDefinitionRequest.h>
#include <aws/greengrass/model/GetResourceDefinitionResult.h>
#include <aws/greengrass/model/GetResourceDefinitionVersionRequest.h>
#include <aws/greengrass/model/GetResourceDefinitionVersionResult.h>
#include <aws/greengrass/model/GetServiceRoleForAccountRequest.h>
#include <aws/greengrass/model/GetServiceRoleForAccountResult.h>
#include <aws/greengrass/model/GetSubscriptionDefinitionRequest.h>
#include <aws/greengrass/model/GetSubscriptionDefinitionResult.h>
#include <aws/greengrass/model/GetSubscriptionDefinitionVersionRequest.h>
#include <aws/greengrass/model/GetSubscriptionDefinitionVersionResult.h>
#include <aws/greengrass/model/GetThingRuntimeConfigurationRequest.h>
#include <aws/greengrass/model/GetThingRuntimeConfigurationResult.h>
#include <aws/greengrass/model/GroupCertificateAuthorityProperties.h>
#include <aws/greengrass/model/GroupInformation.h>
#include <aws/greengrass/model/GroupOwnerSetting.h>
#include <aws/greengrass/model/GroupVersion.h>
#include <aws/greengrass/model/InternalServerErrorException.h>
#include <aws/greengrass/model/ListBulkDeploymentDetailedReportsRequest.h>
#include <aws/greengrass/model/ListBulkDeploymentDetailedReportsResult.h>
#include <aws/greengrass/model/ListBulkDeploymentsRequest.h>
#include <aws/greengrass/model/ListBulkDeploymentsResult.h>
#include <aws/greengrass/model/ListConnectorDefinitionVersionsRequest.h>
#include <aws/greengrass/model/ListConnectorDefinitionVersionsResult.h>
#include <aws/greengrass/model/ListConnectorDefinitionsRequest.h>
#include <aws/greengrass/model/ListConnectorDefinitionsResult.h>
#include <aws/greengrass/model/ListCoreDefinitionVersionsRequest.h>
#include <aws/greengrass/model/ListCoreDefinitionVersionsResult.h>
#include <aws/greengrass/model/ListCoreDefinitionsRequest.h>
#include <aws/greengrass/model/ListCoreDefinitionsResult.h>
#include <aws/greengrass/model/ListDeploymentsRequest.h>
#include <aws/greengrass/model/ListDeploymentsResult.h>
#include <aws/greengrass/model/ListDeviceDefinitionVersionsRequest.h>
#include <aws/greengrass/model/ListDeviceDefinitionVersionsResult.h>
#include <aws/greengrass/model/ListDeviceDefinitionsRequest.h>
#include <aws/greengrass/model/ListDeviceDefinitionsResult.h>
#include <aws/greengrass/model/ListFunctionDefinitionVersionsRequest.h>
#include <aws/greengrass/model/ListFunctionDefinitionVersionsResult.h>
#include <aws/greengrass/model/ListFunctionDefinitionsRequest.h>
#include <aws/greengrass/model/ListFunctionDefinitionsResult.h>
#include <aws/greengrass/model/ListGroupCertificateAuthoritiesRequest.h>
#include <aws/greengrass/model/ListGroupCertificateAuthoritiesResult.h>
#include <aws/greengrass/model/ListGroupVersionsRequest.h>
#include <aws/greengrass/model/ListGroupVersionsResult.h>
#include <aws/greengrass/model/ListGroupsRequest.h>
#include <aws/greengrass/model/ListGroupsResult.h>
#include <aws/greengrass/model/ListLoggerDefinitionVersionsRequest.h>
#include <aws/greengrass/model/ListLoggerDefinitionVersionsResult.h>
#include <aws/greengrass/model/ListLoggerDefinitionsRequest.h>
#include <aws/greengrass/model/ListLoggerDefinitionsResult.h>
#include <aws/greengrass/model/ListResourceDefinitionVersionsRequest.h>
#include <aws/greengrass/model/ListResourceDefinitionVersionsResult.h>
#include <aws/greengrass/model/ListResourceDefinitionsRequest.h>
#include <aws/greengrass/model/ListResourceDefinitionsResult.h>
#include <aws/greengrass/model/ListSubscriptionDefinitionVersionsRequest.h>
#include <aws/greengrass/model/ListSubscriptionDefinitionVersionsResult.h>
#include <aws/greengrass/model/ListSubscriptionDefinitionsRequest.h>
#include <aws/greengrass/model/ListSubscriptionDefinitionsResult.h>
#include <aws/greengrass/model/ListTagsForResourceRequest.h>
#include <aws/greengrass/model/ListTagsForResourceResult.h>
#include <aws/greengrass/model/LocalDeviceResourceData.h>
#include <aws/greengrass/model/LocalVolumeResourceData.h>
#include <aws/greengrass/model/Logger.h>
#include <aws/greengrass/model/LoggerComponent.h>
#include <aws/greengrass/model/LoggerDefinitionVersion.h>
#include <aws/greengrass/model/LoggerLevel.h>
#include <aws/greengrass/model/LoggerType.h>
#include <aws/greengrass/model/Permission.h>
#include <aws/greengrass/model/ResetDeploymentsRequest.h>
#include <aws/greengrass/model/ResetDeploymentsResult.h>
#include <aws/greengrass/model/Resource.h>
#include <aws/greengrass/model/ResourceAccessPolicy.h>
#include <aws/greengrass/model/ResourceDataContainer.h>
#include <aws/greengrass/model/ResourceDefinitionVersion.h>
#include <aws/greengrass/model/ResourceDownloadOwnerSetting.h>
#include <aws/greengrass/model/RuntimeConfiguration.h>
#include <aws/greengrass/model/S3MachineLearningModelResourceData.h>
#include <aws/greengrass/model/SageMakerMachineLearningModelResourceData.h>
#include <aws/greengrass/model/SecretsManagerSecretResourceData.h>
#include <aws/greengrass/model/SoftwareToUpdate.h>
#include <aws/greengrass/model/StartBulkDeploymentRequest.h>
#include <aws/greengrass/model/StartBulkDeploymentResult.h>
#include <aws/greengrass/model/StopBulkDeploymentRequest.h>
#include <aws/greengrass/model/StopBulkDeploymentResult.h>
#include <aws/greengrass/model/Subscription.h>
#include <aws/greengrass/model/SubscriptionDefinitionVersion.h>
#include <aws/greengrass/model/TagResourceRequest.h>
#include <aws/greengrass/model/Telemetry.h>
#include <aws/greengrass/model/TelemetryConfiguration.h>
#include <aws/greengrass/model/TelemetryConfigurationUpdate.h>
#include <aws/greengrass/model/UntagResourceRequest.h>
#include <aws/greengrass/model/UpdateAgentLogLevel.h>
#include <aws/greengrass/model/UpdateConnectivityInfoRequest.h>
#include <aws/greengrass/model/UpdateConnectivityInfoResult.h>
#include <aws/greengrass/model/UpdateConnectorDefinitionRequest.h>
#include <aws/greengrass/model/UpdateConnectorDefinitionResult.h>
#include <aws/greengrass/model/UpdateCoreDefinitionRequest.h>
#include <aws/greengrass/model/UpdateCoreDefinitionResult.h>
#include <aws/greengrass/model/UpdateDeviceDefinitionRequest.h>
#include <aws/greengrass/model/UpdateDeviceDefinitionResult.h>
#include <aws/greengrass/model/UpdateFunctionDefinitionRequest.h>
#include <aws/greengrass/model/UpdateFunctionDefinitionResult.h>
#include <aws/greengrass/model/UpdateGroupCertificateConfigurationRequest.h>
#include <aws/greengrass/model/UpdateGroupCertificateConfigurationResult.h>
#include <aws/greengrass/model/UpdateGroupRequest.h>
#include <aws/greengrass/model/UpdateGroupResult.h>
#include <aws/greengrass/model/UpdateLoggerDefinitionRequest.h>
#include <aws/greengrass/model/UpdateLoggerDefinitionResult.h>
#include <aws/greengrass/model/UpdateResourceDefinitionRequest.h>
#include <aws/greengrass/model/UpdateResourceDefinitionResult.h>
#include <aws/greengrass/model/UpdateSubscriptionDefinitionRequest.h>
#include <aws/greengrass/model/UpdateSubscriptionDefinitionResult.h>
#include <aws/greengrass/model/UpdateTargetsArchitecture.h>
#include <aws/greengrass/model/UpdateTargetsOperatingSystem.h>
#include <aws/greengrass/model/UpdateThingRuntimeConfigurationRequest.h>
#include <aws/greengrass/model/UpdateThingRuntimeConfigurationResult.h>
#include <aws/greengrass/model/VersionInformation.h>

using GreengrassIncludeTest = ::testing::Test;

TEST_F(GreengrassIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::Greengrass::GreengrassClient>("GreengrassIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
