/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/guardduty/GuardDutyClient.h>
#include <aws/guardduty/GuardDutyEndpointProvider.h>
#include <aws/guardduty/GuardDutyEndpointRules.h>
#include <aws/guardduty/GuardDutyErrorMarshaller.h>
#include <aws/guardduty/GuardDutyErrors.h>
#include <aws/guardduty/GuardDutyRequest.h>
#include <aws/guardduty/GuardDutyServiceClientModel.h>
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/guardduty/model/AcceptAdministratorInvitationRequest.h>
#include <aws/guardduty/model/AcceptAdministratorInvitationResult.h>
#include <aws/guardduty/model/AccessControlList.h>
#include <aws/guardduty/model/AccessDeniedException.h>
#include <aws/guardduty/model/AccessKey.h>
#include <aws/guardduty/model/AccessKeyDetails.h>
#include <aws/guardduty/model/Account.h>
#include <aws/guardduty/model/AccountDetail.h>
#include <aws/guardduty/model/AccountFreeTrialInfo.h>
#include <aws/guardduty/model/AccountLevelPermissions.h>
#include <aws/guardduty/model/AccountStatistics.h>
#include <aws/guardduty/model/Action.h>
#include <aws/guardduty/model/Actor.h>
#include <aws/guardduty/model/ActorProcess.h>
#include <aws/guardduty/model/AddonDetails.h>
#include <aws/guardduty/model/AdminAccount.h>
#include <aws/guardduty/model/AdminStatus.h>
#include <aws/guardduty/model/Administrator.h>
#include <aws/guardduty/model/AgentDetails.h>
#include <aws/guardduty/model/Anomaly.h>
#include <aws/guardduty/model/AnomalyObject.h>
#include <aws/guardduty/model/AnomalyUnusual.h>
#include <aws/guardduty/model/ArchiveFindingsRequest.h>
#include <aws/guardduty/model/ArchiveFindingsResult.h>
#include <aws/guardduty/model/AutoEnableMembers.h>
#include <aws/guardduty/model/AutonomousSystem.h>
#include <aws/guardduty/model/AwsApiCallAction.h>
#include <aws/guardduty/model/BadRequestException.h>
#include <aws/guardduty/model/BlockPublicAccess.h>
#include <aws/guardduty/model/BucketLevelPermissions.h>
#include <aws/guardduty/model/BucketPolicy.h>
#include <aws/guardduty/model/City.h>
#include <aws/guardduty/model/CloudTrailConfigurationResult.h>
#include <aws/guardduty/model/ClusterStatus.h>
#include <aws/guardduty/model/Condition.h>
#include <aws/guardduty/model/ConflictException.h>
#include <aws/guardduty/model/Container.h>
#include <aws/guardduty/model/ContainerFindingResource.h>
#include <aws/guardduty/model/ContainerInstanceDetails.h>
#include <aws/guardduty/model/Country.h>
#include <aws/guardduty/model/CoverageEc2InstanceDetails.h>
#include <aws/guardduty/model/CoverageEcsClusterDetails.h>
#include <aws/guardduty/model/CoverageEksClusterDetails.h>
#include <aws/guardduty/model/CoverageFilterCondition.h>
#include <aws/guardduty/model/CoverageFilterCriteria.h>
#include <aws/guardduty/model/CoverageFilterCriterion.h>
#include <aws/guardduty/model/CoverageFilterCriterionKey.h>
#include <aws/guardduty/model/CoverageResource.h>
#include <aws/guardduty/model/CoverageResourceDetails.h>
#include <aws/guardduty/model/CoverageSortCriteria.h>
#include <aws/guardduty/model/CoverageSortKey.h>
#include <aws/guardduty/model/CoverageStatistics.h>
#include <aws/guardduty/model/CoverageStatisticsType.h>
#include <aws/guardduty/model/CoverageStatus.h>
#include <aws/guardduty/model/CreateDetectorRequest.h>
#include <aws/guardduty/model/CreateDetectorResult.h>
#include <aws/guardduty/model/CreateFilterRequest.h>
#include <aws/guardduty/model/CreateFilterResult.h>
#include <aws/guardduty/model/CreateIPSetRequest.h>
#include <aws/guardduty/model/CreateIPSetResult.h>
#include <aws/guardduty/model/CreateMalwareProtectionPlanRequest.h>
#include <aws/guardduty/model/CreateMalwareProtectionPlanResult.h>
#include <aws/guardduty/model/CreateMembersRequest.h>
#include <aws/guardduty/model/CreateMembersResult.h>
#include <aws/guardduty/model/CreateProtectedResource.h>
#include <aws/guardduty/model/CreatePublishingDestinationRequest.h>
#include <aws/guardduty/model/CreatePublishingDestinationResult.h>
#include <aws/guardduty/model/CreateS3BucketResource.h>
#include <aws/guardduty/model/CreateSampleFindingsRequest.h>
#include <aws/guardduty/model/CreateSampleFindingsResult.h>
#include <aws/guardduty/model/CreateThreatIntelSetRequest.h>
#include <aws/guardduty/model/CreateThreatIntelSetResult.h>
#include <aws/guardduty/model/CriterionKey.h>
#include <aws/guardduty/model/DNSLogsConfigurationResult.h>
#include <aws/guardduty/model/DataSource.h>
#include <aws/guardduty/model/DataSourceFreeTrial.h>
#include <aws/guardduty/model/DataSourceStatus.h>
#include <aws/guardduty/model/DateStatistics.h>
#include <aws/guardduty/model/DeclineInvitationsRequest.h>
#include <aws/guardduty/model/DeclineInvitationsResult.h>
#include <aws/guardduty/model/DefaultServerSideEncryption.h>
#include <aws/guardduty/model/DeleteDetectorRequest.h>
#include <aws/guardduty/model/DeleteDetectorResult.h>
#include <aws/guardduty/model/DeleteFilterRequest.h>
#include <aws/guardduty/model/DeleteFilterResult.h>
#include <aws/guardduty/model/DeleteIPSetRequest.h>
#include <aws/guardduty/model/DeleteIPSetResult.h>
#include <aws/guardduty/model/DeleteInvitationsRequest.h>
#include <aws/guardduty/model/DeleteInvitationsResult.h>
#include <aws/guardduty/model/DeleteMalwareProtectionPlanRequest.h>
#include <aws/guardduty/model/DeleteMembersRequest.h>
#include <aws/guardduty/model/DeleteMembersResult.h>
#include <aws/guardduty/model/DeletePublishingDestinationRequest.h>
#include <aws/guardduty/model/DeletePublishingDestinationResult.h>
#include <aws/guardduty/model/DeleteThreatIntelSetRequest.h>
#include <aws/guardduty/model/DeleteThreatIntelSetResult.h>
#include <aws/guardduty/model/DescribeMalwareScansRequest.h>
#include <aws/guardduty/model/DescribeMalwareScansResult.h>
#include <aws/guardduty/model/DescribeOrganizationConfigurationRequest.h>
#include <aws/guardduty/model/DescribeOrganizationConfigurationResult.h>
#include <aws/guardduty/model/DescribePublishingDestinationRequest.h>
#include <aws/guardduty/model/DescribePublishingDestinationResult.h>
#include <aws/guardduty/model/Destination.h>
#include <aws/guardduty/model/DestinationProperties.h>
#include <aws/guardduty/model/DestinationType.h>
#include <aws/guardduty/model/Detection.h>
#include <aws/guardduty/model/DetectorAdditionalConfiguration.h>
#include <aws/guardduty/model/DetectorAdditionalConfigurationResult.h>
#include <aws/guardduty/model/DetectorFeature.h>
#include <aws/guardduty/model/DetectorFeatureConfiguration.h>
#include <aws/guardduty/model/DetectorFeatureConfigurationResult.h>
#include <aws/guardduty/model/DetectorFeatureResult.h>
#include <aws/guardduty/model/DetectorStatus.h>
#include <aws/guardduty/model/DisableOrganizationAdminAccountRequest.h>
#include <aws/guardduty/model/DisableOrganizationAdminAccountResult.h>
#include <aws/guardduty/model/DisassociateFromAdministratorAccountRequest.h>
#include <aws/guardduty/model/DisassociateFromAdministratorAccountResult.h>
#include <aws/guardduty/model/DisassociateMembersRequest.h>
#include <aws/guardduty/model/DisassociateMembersResult.h>
#include <aws/guardduty/model/DnsRequestAction.h>
#include <aws/guardduty/model/DomainDetails.h>
#include <aws/guardduty/model/EbsSnapshotPreservation.h>
#include <aws/guardduty/model/EbsVolumeDetails.h>
#include <aws/guardduty/model/EbsVolumeScanDetails.h>
#include <aws/guardduty/model/EbsVolumesResult.h>
#include <aws/guardduty/model/Ec2Instance.h>
#include <aws/guardduty/model/Ec2NetworkInterface.h>
#include <aws/guardduty/model/EcsClusterDetails.h>
#include <aws/guardduty/model/EcsTaskDetails.h>
#include <aws/guardduty/model/EksCluster.h>
#include <aws/guardduty/model/EksClusterDetails.h>
#include <aws/guardduty/model/EnableOrganizationAdminAccountRequest.h>
#include <aws/guardduty/model/EnableOrganizationAdminAccountResult.h>
#include <aws/guardduty/model/Evidence.h>
#include <aws/guardduty/model/FargateDetails.h>
#include <aws/guardduty/model/FeatureAdditionalConfiguration.h>
#include <aws/guardduty/model/FeatureStatus.h>
#include <aws/guardduty/model/Feedback.h>
#include <aws/guardduty/model/FilterAction.h>
#include <aws/guardduty/model/FilterCondition.h>
#include <aws/guardduty/model/FilterCriteria.h>
#include <aws/guardduty/model/FilterCriterion.h>
#include <aws/guardduty/model/Finding.h>
#include <aws/guardduty/model/FindingCriteria.h>
#include <aws/guardduty/model/FindingPublishingFrequency.h>
#include <aws/guardduty/model/FindingResourceType.h>
#include <aws/guardduty/model/FindingStatisticType.h>
#include <aws/guardduty/model/FindingStatistics.h>
#include <aws/guardduty/model/FindingTypeStatistics.h>
#include <aws/guardduty/model/FlowLogsConfigurationResult.h>
#include <aws/guardduty/model/FreeTrialFeatureConfigurationResult.h>
#include <aws/guardduty/model/FreeTrialFeatureResult.h>
#include <aws/guardduty/model/GeoLocation.h>
#include <aws/guardduty/model/GetAdministratorAccountRequest.h>
#include <aws/guardduty/model/GetAdministratorAccountResult.h>
#include <aws/guardduty/model/GetCoverageStatisticsRequest.h>
#include <aws/guardduty/model/GetCoverageStatisticsResult.h>
#include <aws/guardduty/model/GetDetectorRequest.h>
#include <aws/guardduty/model/GetDetectorResult.h>
#include <aws/guardduty/model/GetFilterRequest.h>
#include <aws/guardduty/model/GetFilterResult.h>
#include <aws/guardduty/model/GetFindingsRequest.h>
#include <aws/guardduty/model/GetFindingsResult.h>
#include <aws/guardduty/model/GetFindingsStatisticsRequest.h>
#include <aws/guardduty/model/GetFindingsStatisticsResult.h>
#include <aws/guardduty/model/GetIPSetRequest.h>
#include <aws/guardduty/model/GetIPSetResult.h>
#include <aws/guardduty/model/GetInvitationsCountRequest.h>
#include <aws/guardduty/model/GetInvitationsCountResult.h>
#include <aws/guardduty/model/GetMalwareProtectionPlanRequest.h>
#include <aws/guardduty/model/GetMalwareProtectionPlanResult.h>
#include <aws/guardduty/model/GetMalwareScanSettingsRequest.h>
#include <aws/guardduty/model/GetMalwareScanSettingsResult.h>
#include <aws/guardduty/model/GetMemberDetectorsRequest.h>
#include <aws/guardduty/model/GetMemberDetectorsResult.h>
#include <aws/guardduty/model/GetMembersRequest.h>
#include <aws/guardduty/model/GetMembersResult.h>
#include <aws/guardduty/model/GetOrganizationStatisticsRequest.h>
#include <aws/guardduty/model/GetOrganizationStatisticsResult.h>
#include <aws/guardduty/model/GetRemainingFreeTrialDaysRequest.h>
#include <aws/guardduty/model/GetRemainingFreeTrialDaysResult.h>
#include <aws/guardduty/model/GetThreatIntelSetRequest.h>
#include <aws/guardduty/model/GetThreatIntelSetResult.h>
#include <aws/guardduty/model/GetUsageStatisticsRequest.h>
#include <aws/guardduty/model/GetUsageStatisticsResult.h>
#include <aws/guardduty/model/GroupByType.h>
#include <aws/guardduty/model/HighestSeverityThreatDetails.h>
#include <aws/guardduty/model/HostPath.h>
#include <aws/guardduty/model/IamInstanceProfile.h>
#include <aws/guardduty/model/ImpersonatedUser.h>
#include <aws/guardduty/model/Indicator.h>
#include <aws/guardduty/model/IndicatorType.h>
#include <aws/guardduty/model/InstanceDetails.h>
#include <aws/guardduty/model/InternalServerErrorException.h>
#include <aws/guardduty/model/Invitation.h>
#include <aws/guardduty/model/InviteMembersRequest.h>
#include <aws/guardduty/model/InviteMembersResult.h>
#include <aws/guardduty/model/IpSetFormat.h>
#include <aws/guardduty/model/IpSetStatus.h>
#include <aws/guardduty/model/ItemPath.h>
#include <aws/guardduty/model/KubernetesApiCallAction.h>
#include <aws/guardduty/model/KubernetesAuditLogsConfiguration.h>
#include <aws/guardduty/model/KubernetesAuditLogsConfigurationResult.h>
#include <aws/guardduty/model/KubernetesConfiguration.h>
#include <aws/guardduty/model/KubernetesConfigurationResult.h>
#include <aws/guardduty/model/KubernetesDataSourceFreeTrial.h>
#include <aws/guardduty/model/KubernetesDetails.h>
#include <aws/guardduty/model/KubernetesPermissionCheckedDetails.h>
#include <aws/guardduty/model/KubernetesResourcesTypes.h>
#include <aws/guardduty/model/KubernetesRoleBindingDetails.h>
#include <aws/guardduty/model/KubernetesRoleDetails.h>
#include <aws/guardduty/model/KubernetesUserDetails.h>
#include <aws/guardduty/model/KubernetesWorkload.h>
#include <aws/guardduty/model/KubernetesWorkloadDetails.h>
#include <aws/guardduty/model/LambdaDetails.h>
#include <aws/guardduty/model/LineageObject.h>
#include <aws/guardduty/model/ListCoverageRequest.h>
#include <aws/guardduty/model/ListCoverageResult.h>
#include <aws/guardduty/model/ListDetectorsRequest.h>
#include <aws/guardduty/model/ListDetectorsResult.h>
#include <aws/guardduty/model/ListFiltersRequest.h>
#include <aws/guardduty/model/ListFiltersResult.h>
#include <aws/guardduty/model/ListFindingsRequest.h>
#include <aws/guardduty/model/ListFindingsResult.h>
#include <aws/guardduty/model/ListIPSetsRequest.h>
#include <aws/guardduty/model/ListIPSetsResult.h>
#include <aws/guardduty/model/ListInvitationsRequest.h>
#include <aws/guardduty/model/ListInvitationsResult.h>
#include <aws/guardduty/model/ListMalwareProtectionPlansRequest.h>
#include <aws/guardduty/model/ListMalwareProtectionPlansResult.h>
#include <aws/guardduty/model/ListMembersRequest.h>
#include <aws/guardduty/model/ListMembersResult.h>
#include <aws/guardduty/model/ListOrganizationAdminAccountsRequest.h>
#include <aws/guardduty/model/ListOrganizationAdminAccountsResult.h>
#include <aws/guardduty/model/ListPublishingDestinationsRequest.h>
#include <aws/guardduty/model/ListPublishingDestinationsResult.h>
#include <aws/guardduty/model/ListTagsForResourceRequest.h>
#include <aws/guardduty/model/ListTagsForResourceResult.h>
#include <aws/guardduty/model/ListThreatIntelSetsRequest.h>
#include <aws/guardduty/model/ListThreatIntelSetsResult.h>
#include <aws/guardduty/model/LocalIpDetails.h>
#include <aws/guardduty/model/LocalPortDetails.h>
#include <aws/guardduty/model/LoginAttribute.h>
#include <aws/guardduty/model/MalwareProtectionConfiguration.h>
#include <aws/guardduty/model/MalwareProtectionConfigurationResult.h>
#include <aws/guardduty/model/MalwareProtectionDataSourceFreeTrial.h>
#include <aws/guardduty/model/MalwareProtectionPlanActions.h>
#include <aws/guardduty/model/MalwareProtectionPlanStatus.h>
#include <aws/guardduty/model/MalwareProtectionPlanStatusReason.h>
#include <aws/guardduty/model/MalwareProtectionPlanSummary.h>
#include <aws/guardduty/model/MalwareProtectionPlanTaggingAction.h>
#include <aws/guardduty/model/MalwareProtectionPlanTaggingActionStatus.h>
#include <aws/guardduty/model/MalwareScanDetails.h>
#include <aws/guardduty/model/ManagementType.h>
#include <aws/guardduty/model/Master.h>
#include <aws/guardduty/model/Member.h>
#include <aws/guardduty/model/MemberAdditionalConfiguration.h>
#include <aws/guardduty/model/MemberAdditionalConfigurationResult.h>
#include <aws/guardduty/model/MemberDataSourceConfiguration.h>
#include <aws/guardduty/model/MemberFeaturesConfiguration.h>
#include <aws/guardduty/model/MemberFeaturesConfigurationResult.h>
#include <aws/guardduty/model/MfaStatus.h>
#include <aws/guardduty/model/NetworkConnection.h>
#include <aws/guardduty/model/NetworkConnectionAction.h>
#include <aws/guardduty/model/NetworkDirection.h>
#include <aws/guardduty/model/NetworkEndpoint.h>
#include <aws/guardduty/model/NetworkGeoLocation.h>
#include <aws/guardduty/model/NetworkInterface.h>
#include <aws/guardduty/model/Observations.h>
#include <aws/guardduty/model/OrderBy.h>
#include <aws/guardduty/model/OrgFeature.h>
#include <aws/guardduty/model/OrgFeatureAdditionalConfiguration.h>
#include <aws/guardduty/model/OrgFeatureStatus.h>
#include <aws/guardduty/model/Organization.h>
#include <aws/guardduty/model/OrganizationAdditionalConfiguration.h>
#include <aws/guardduty/model/OrganizationAdditionalConfigurationResult.h>
#include <aws/guardduty/model/OrganizationDetails.h>
#include <aws/guardduty/model/OrganizationEbsVolumes.h>
#include <aws/guardduty/model/OrganizationEbsVolumesResult.h>
#include <aws/guardduty/model/OrganizationFeatureConfiguration.h>
#include <aws/guardduty/model/OrganizationFeatureConfigurationResult.h>
#include <aws/guardduty/model/OrganizationFeatureStatistics.h>
#include <aws/guardduty/model/OrganizationFeatureStatisticsAdditionalConfiguration.h>
#include <aws/guardduty/model/OrganizationKubernetesAuditLogsConfiguration.h>
#include <aws/guardduty/model/OrganizationKubernetesAuditLogsConfigurationResult.h>
#include <aws/guardduty/model/OrganizationKubernetesConfiguration.h>
#include <aws/guardduty/model/OrganizationKubernetesConfigurationResult.h>
#include <aws/guardduty/model/OrganizationMalwareProtectionConfiguration.h>
#include <aws/guardduty/model/OrganizationMalwareProtectionConfigurationResult.h>
#include <aws/guardduty/model/OrganizationS3LogsConfiguration.h>
#include <aws/guardduty/model/OrganizationS3LogsConfigurationResult.h>
#include <aws/guardduty/model/OrganizationScanEc2InstanceWithFindings.h>
#include <aws/guardduty/model/OrganizationScanEc2InstanceWithFindingsResult.h>
#include <aws/guardduty/model/OrganizationStatistics.h>
#include <aws/guardduty/model/Owner.h>
#include <aws/guardduty/model/PermissionConfiguration.h>
#include <aws/guardduty/model/PortProbeAction.h>
#include <aws/guardduty/model/PortProbeDetail.h>
#include <aws/guardduty/model/PrivateIpAddressDetails.h>
#include <aws/guardduty/model/ProcessDetails.h>
#include <aws/guardduty/model/ProductCode.h>
#include <aws/guardduty/model/ProfileSubtype.h>
#include <aws/guardduty/model/ProfileType.h>
#include <aws/guardduty/model/PublicAccess.h>
#include <aws/guardduty/model/PublicAccessConfiguration.h>
#include <aws/guardduty/model/PublicAccessStatus.h>
#include <aws/guardduty/model/PublicAclIgnoreBehavior.h>
#include <aws/guardduty/model/PublicBucketRestrictBehavior.h>
#include <aws/guardduty/model/PublishingStatus.h>
#include <aws/guardduty/model/RdsDbInstanceDetails.h>
#include <aws/guardduty/model/RdsDbUserDetails.h>
#include <aws/guardduty/model/RdsLimitlessDbDetails.h>
#include <aws/guardduty/model/RdsLoginAttemptAction.h>
#include <aws/guardduty/model/RemoteAccountDetails.h>
#include <aws/guardduty/model/RemoteIpDetails.h>
#include <aws/guardduty/model/RemotePortDetails.h>
#include <aws/guardduty/model/Resource.h>
#include <aws/guardduty/model/ResourceData.h>
#include <aws/guardduty/model/ResourceDetails.h>
#include <aws/guardduty/model/ResourceNotFoundException.h>
#include <aws/guardduty/model/ResourceStatistics.h>
#include <aws/guardduty/model/ResourceType.h>
#include <aws/guardduty/model/ResourceV2.h>
#include <aws/guardduty/model/RuntimeContext.h>
#include <aws/guardduty/model/RuntimeDetails.h>
#include <aws/guardduty/model/S3Bucket.h>
#include <aws/guardduty/model/S3BucketDetail.h>
#include <aws/guardduty/model/S3LogsConfiguration.h>
#include <aws/guardduty/model/S3LogsConfigurationResult.h>
#include <aws/guardduty/model/S3Object.h>
#include <aws/guardduty/model/S3ObjectDetail.h>
#include <aws/guardduty/model/Scan.h>
#include <aws/guardduty/model/ScanCondition.h>
#include <aws/guardduty/model/ScanConditionPair.h>
#include <aws/guardduty/model/ScanCriterionKey.h>
#include <aws/guardduty/model/ScanDetections.h>
#include <aws/guardduty/model/ScanEc2InstanceWithFindings.h>
#include <aws/guardduty/model/ScanEc2InstanceWithFindingsResult.h>
#include <aws/guardduty/model/ScanFilePath.h>
#include <aws/guardduty/model/ScanResourceCriteria.h>
#include <aws/guardduty/model/ScanResult.h>
#include <aws/guardduty/model/ScanResultDetails.h>
#include <aws/guardduty/model/ScanStatus.h>
#include <aws/guardduty/model/ScanThreatName.h>
#include <aws/guardduty/model/ScanType.h>
#include <aws/guardduty/model/ScannedItemCount.h>
#include <aws/guardduty/model/SecurityContext.h>
#include <aws/guardduty/model/SecurityGroup.h>
#include <aws/guardduty/model/Sequence.h>
#include <aws/guardduty/model/Service.h>
#include <aws/guardduty/model/ServiceAdditionalInfo.h>
#include <aws/guardduty/model/Session.h>
#include <aws/guardduty/model/SeverityStatistics.h>
#include <aws/guardduty/model/Signal.h>
#include <aws/guardduty/model/SignalType.h>
#include <aws/guardduty/model/SortCriteria.h>
#include <aws/guardduty/model/StartMalwareScanRequest.h>
#include <aws/guardduty/model/StartMalwareScanResult.h>
#include <aws/guardduty/model/StartMonitoringMembersRequest.h>
#include <aws/guardduty/model/StartMonitoringMembersResult.h>
#include <aws/guardduty/model/StopMonitoringMembersRequest.h>
#include <aws/guardduty/model/StopMonitoringMembersResult.h>
#include <aws/guardduty/model/Tag.h>
#include <aws/guardduty/model/TagResourceRequest.h>
#include <aws/guardduty/model/TagResourceResult.h>
#include <aws/guardduty/model/Threat.h>
#include <aws/guardduty/model/ThreatDetectedByName.h>
#include <aws/guardduty/model/ThreatIntelSetFormat.h>
#include <aws/guardduty/model/ThreatIntelSetStatus.h>
#include <aws/guardduty/model/ThreatIntelligenceDetail.h>
#include <aws/guardduty/model/ThreatsDetectedItemCount.h>
#include <aws/guardduty/model/Total.h>
#include <aws/guardduty/model/TriggerDetails.h>
#include <aws/guardduty/model/UnarchiveFindingsRequest.h>
#include <aws/guardduty/model/UnarchiveFindingsResult.h>
#include <aws/guardduty/model/UnprocessedAccount.h>
#include <aws/guardduty/model/UnprocessedDataSourcesResult.h>
#include <aws/guardduty/model/UntagResourceRequest.h>
#include <aws/guardduty/model/UntagResourceResult.h>
#include <aws/guardduty/model/UpdateDetectorRequest.h>
#include <aws/guardduty/model/UpdateDetectorResult.h>
#include <aws/guardduty/model/UpdateFilterRequest.h>
#include <aws/guardduty/model/UpdateFilterResult.h>
#include <aws/guardduty/model/UpdateFindingsFeedbackRequest.h>
#include <aws/guardduty/model/UpdateFindingsFeedbackResult.h>
#include <aws/guardduty/model/UpdateIPSetRequest.h>
#include <aws/guardduty/model/UpdateIPSetResult.h>
#include <aws/guardduty/model/UpdateMalwareProtectionPlanRequest.h>
#include <aws/guardduty/model/UpdateMalwareScanSettingsRequest.h>
#include <aws/guardduty/model/UpdateMalwareScanSettingsResult.h>
#include <aws/guardduty/model/UpdateMemberDetectorsRequest.h>
#include <aws/guardduty/model/UpdateMemberDetectorsResult.h>
#include <aws/guardduty/model/UpdateOrganizationConfigurationRequest.h>
#include <aws/guardduty/model/UpdateOrganizationConfigurationResult.h>
#include <aws/guardduty/model/UpdateProtectedResource.h>
#include <aws/guardduty/model/UpdatePublishingDestinationRequest.h>
#include <aws/guardduty/model/UpdatePublishingDestinationResult.h>
#include <aws/guardduty/model/UpdateS3BucketResource.h>
#include <aws/guardduty/model/UpdateThreatIntelSetRequest.h>
#include <aws/guardduty/model/UpdateThreatIntelSetResult.h>
#include <aws/guardduty/model/UsageAccountResult.h>
#include <aws/guardduty/model/UsageCriteria.h>
#include <aws/guardduty/model/UsageDataSourceResult.h>
#include <aws/guardduty/model/UsageFeature.h>
#include <aws/guardduty/model/UsageFeatureResult.h>
#include <aws/guardduty/model/UsageResourceResult.h>
#include <aws/guardduty/model/UsageStatisticType.h>
#include <aws/guardduty/model/UsageStatistics.h>
#include <aws/guardduty/model/UsageTopAccountResult.h>
#include <aws/guardduty/model/UsageTopAccountsResult.h>
#include <aws/guardduty/model/User.h>
#include <aws/guardduty/model/Volume.h>
#include <aws/guardduty/model/VolumeDetail.h>
#include <aws/guardduty/model/VolumeMount.h>
#include <aws/guardduty/model/VpcConfig.h>

using GuardDutyIncludeTest = ::testing::Test;

TEST_F(GuardDutyIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::GuardDuty::GuardDutyClient>("GuardDutyIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
