/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/iam/IAMClient.h>
#include <aws/iam/IAMEndpointProvider.h>
#include <aws/iam/IAMEndpointRules.h>
#include <aws/iam/IAMErrorMarshaller.h>
#include <aws/iam/IAMErrors.h>
#include <aws/iam/IAMRequest.h>
#include <aws/iam/IAMServiceClientModel.h>
#include <aws/iam/IAM_EXPORTS.h>
#include <aws/iam/model/AccessAdvisorUsageGranularityType.h>
#include <aws/iam/model/AccessDetail.h>
#include <aws/iam/model/AccessKey.h>
#include <aws/iam/model/AccessKeyLastUsed.h>
#include <aws/iam/model/AccessKeyMetadata.h>
#include <aws/iam/model/AddClientIDToOpenIDConnectProviderRequest.h>
#include <aws/iam/model/AddRoleToInstanceProfileRequest.h>
#include <aws/iam/model/AddUserToGroupRequest.h>
#include <aws/iam/model/AssertionEncryptionModeType.h>
#include <aws/iam/model/AssignmentStatusType.h>
#include <aws/iam/model/AttachGroupPolicyRequest.h>
#include <aws/iam/model/AttachRolePolicyRequest.h>
#include <aws/iam/model/AttachUserPolicyRequest.h>
#include <aws/iam/model/AttachedPermissionsBoundary.h>
#include <aws/iam/model/AttachedPolicy.h>
#include <aws/iam/model/ChangePasswordRequest.h>
#include <aws/iam/model/ContextEntry.h>
#include <aws/iam/model/ContextKeyTypeEnum.h>
#include <aws/iam/model/CreateAccessKeyRequest.h>
#include <aws/iam/model/CreateAccessKeyResult.h>
#include <aws/iam/model/CreateAccountAliasRequest.h>
#include <aws/iam/model/CreateGroupRequest.h>
#include <aws/iam/model/CreateGroupResult.h>
#include <aws/iam/model/CreateInstanceProfileRequest.h>
#include <aws/iam/model/CreateInstanceProfileResult.h>
#include <aws/iam/model/CreateLoginProfileRequest.h>
#include <aws/iam/model/CreateLoginProfileResult.h>
#include <aws/iam/model/CreateOpenIDConnectProviderRequest.h>
#include <aws/iam/model/CreateOpenIDConnectProviderResult.h>
#include <aws/iam/model/CreatePolicyRequest.h>
#include <aws/iam/model/CreatePolicyResult.h>
#include <aws/iam/model/CreatePolicyVersionRequest.h>
#include <aws/iam/model/CreatePolicyVersionResult.h>
#include <aws/iam/model/CreateRoleRequest.h>
#include <aws/iam/model/CreateRoleResult.h>
#include <aws/iam/model/CreateSAMLProviderRequest.h>
#include <aws/iam/model/CreateSAMLProviderResult.h>
#include <aws/iam/model/CreateServiceLinkedRoleRequest.h>
#include <aws/iam/model/CreateServiceLinkedRoleResult.h>
#include <aws/iam/model/CreateServiceSpecificCredentialRequest.h>
#include <aws/iam/model/CreateServiceSpecificCredentialResult.h>
#include <aws/iam/model/CreateUserRequest.h>
#include <aws/iam/model/CreateUserResult.h>
#include <aws/iam/model/CreateVirtualMFADeviceRequest.h>
#include <aws/iam/model/CreateVirtualMFADeviceResult.h>
#include <aws/iam/model/DeactivateMFADeviceRequest.h>
#include <aws/iam/model/DeleteAccessKeyRequest.h>
#include <aws/iam/model/DeleteAccountAliasRequest.h>
#include <aws/iam/model/DeleteAccountPasswordPolicyRequest.h>
#include <aws/iam/model/DeleteGroupPolicyRequest.h>
#include <aws/iam/model/DeleteGroupRequest.h>
#include <aws/iam/model/DeleteInstanceProfileRequest.h>
#include <aws/iam/model/DeleteLoginProfileRequest.h>
#include <aws/iam/model/DeleteOpenIDConnectProviderRequest.h>
#include <aws/iam/model/DeletePolicyRequest.h>
#include <aws/iam/model/DeletePolicyVersionRequest.h>
#include <aws/iam/model/DeleteRolePermissionsBoundaryRequest.h>
#include <aws/iam/model/DeleteRolePolicyRequest.h>
#include <aws/iam/model/DeleteRoleRequest.h>
#include <aws/iam/model/DeleteSAMLProviderRequest.h>
#include <aws/iam/model/DeleteSSHPublicKeyRequest.h>
#include <aws/iam/model/DeleteServerCertificateRequest.h>
#include <aws/iam/model/DeleteServiceLinkedRoleRequest.h>
#include <aws/iam/model/DeleteServiceLinkedRoleResult.h>
#include <aws/iam/model/DeleteServiceSpecificCredentialRequest.h>
#include <aws/iam/model/DeleteSigningCertificateRequest.h>
#include <aws/iam/model/DeleteUserPermissionsBoundaryRequest.h>
#include <aws/iam/model/DeleteUserPolicyRequest.h>
#include <aws/iam/model/DeleteUserRequest.h>
#include <aws/iam/model/DeleteVirtualMFADeviceRequest.h>
#include <aws/iam/model/DeletionTaskFailureReasonType.h>
#include <aws/iam/model/DeletionTaskStatusType.h>
#include <aws/iam/model/DetachGroupPolicyRequest.h>
#include <aws/iam/model/DetachRolePolicyRequest.h>
#include <aws/iam/model/DetachUserPolicyRequest.h>
#include <aws/iam/model/DisableOrganizationsRootCredentialsManagementRequest.h>
#include <aws/iam/model/DisableOrganizationsRootCredentialsManagementResult.h>
#include <aws/iam/model/DisableOrganizationsRootSessionsRequest.h>
#include <aws/iam/model/DisableOrganizationsRootSessionsResult.h>
#include <aws/iam/model/EnableMFADeviceRequest.h>
#include <aws/iam/model/EnableOrganizationsRootCredentialsManagementRequest.h>
#include <aws/iam/model/EnableOrganizationsRootCredentialsManagementResult.h>
#include <aws/iam/model/EnableOrganizationsRootSessionsRequest.h>
#include <aws/iam/model/EnableOrganizationsRootSessionsResult.h>
#include <aws/iam/model/EncodingType.h>
#include <aws/iam/model/EntityDetails.h>
#include <aws/iam/model/EntityInfo.h>
#include <aws/iam/model/EntityType.h>
#include <aws/iam/model/ErrorDetails.h>
#include <aws/iam/model/EvaluationResult.h>
#include <aws/iam/model/FeatureType.h>
#include <aws/iam/model/GenerateCredentialReportRequest.h>
#include <aws/iam/model/GenerateCredentialReportResult.h>
#include <aws/iam/model/GenerateOrganizationsAccessReportRequest.h>
#include <aws/iam/model/GenerateOrganizationsAccessReportResult.h>
#include <aws/iam/model/GenerateServiceLastAccessedDetailsRequest.h>
#include <aws/iam/model/GenerateServiceLastAccessedDetailsResult.h>
#include <aws/iam/model/GetAccessKeyLastUsedRequest.h>
#include <aws/iam/model/GetAccessKeyLastUsedResult.h>
#include <aws/iam/model/GetAccountAuthorizationDetailsRequest.h>
#include <aws/iam/model/GetAccountAuthorizationDetailsResult.h>
#include <aws/iam/model/GetAccountPasswordPolicyRequest.h>
#include <aws/iam/model/GetAccountPasswordPolicyResult.h>
#include <aws/iam/model/GetAccountSummaryRequest.h>
#include <aws/iam/model/GetAccountSummaryResult.h>
#include <aws/iam/model/GetContextKeysForCustomPolicyRequest.h>
#include <aws/iam/model/GetContextKeysForCustomPolicyResult.h>
#include <aws/iam/model/GetContextKeysForPrincipalPolicyRequest.h>
#include <aws/iam/model/GetContextKeysForPrincipalPolicyResult.h>
#include <aws/iam/model/GetCredentialReportRequest.h>
#include <aws/iam/model/GetCredentialReportResult.h>
#include <aws/iam/model/GetGroupPolicyRequest.h>
#include <aws/iam/model/GetGroupPolicyResult.h>
#include <aws/iam/model/GetGroupRequest.h>
#include <aws/iam/model/GetGroupResult.h>
#include <aws/iam/model/GetInstanceProfileRequest.h>
#include <aws/iam/model/GetInstanceProfileResult.h>
#include <aws/iam/model/GetLoginProfileRequest.h>
#include <aws/iam/model/GetLoginProfileResult.h>
#include <aws/iam/model/GetMFADeviceRequest.h>
#include <aws/iam/model/GetMFADeviceResult.h>
#include <aws/iam/model/GetOpenIDConnectProviderRequest.h>
#include <aws/iam/model/GetOpenIDConnectProviderResult.h>
#include <aws/iam/model/GetOrganizationsAccessReportRequest.h>
#include <aws/iam/model/GetOrganizationsAccessReportResult.h>
#include <aws/iam/model/GetPolicyRequest.h>
#include <aws/iam/model/GetPolicyResult.h>
#include <aws/iam/model/GetPolicyVersionRequest.h>
#include <aws/iam/model/GetPolicyVersionResult.h>
#include <aws/iam/model/GetRolePolicyRequest.h>
#include <aws/iam/model/GetRolePolicyResult.h>
#include <aws/iam/model/GetRoleRequest.h>
#include <aws/iam/model/GetRoleResult.h>
#include <aws/iam/model/GetSAMLProviderRequest.h>
#include <aws/iam/model/GetSAMLProviderResult.h>
#include <aws/iam/model/GetSSHPublicKeyRequest.h>
#include <aws/iam/model/GetSSHPublicKeyResult.h>
#include <aws/iam/model/GetServerCertificateRequest.h>
#include <aws/iam/model/GetServerCertificateResult.h>
#include <aws/iam/model/GetServiceLastAccessedDetailsRequest.h>
#include <aws/iam/model/GetServiceLastAccessedDetailsResult.h>
#include <aws/iam/model/GetServiceLastAccessedDetailsWithEntitiesRequest.h>
#include <aws/iam/model/GetServiceLastAccessedDetailsWithEntitiesResult.h>
#include <aws/iam/model/GetServiceLinkedRoleDeletionStatusRequest.h>
#include <aws/iam/model/GetServiceLinkedRoleDeletionStatusResult.h>
#include <aws/iam/model/GetUserPolicyRequest.h>
#include <aws/iam/model/GetUserPolicyResult.h>
#include <aws/iam/model/GetUserRequest.h>
#include <aws/iam/model/GetUserResult.h>
#include <aws/iam/model/GlobalEndpointTokenVersion.h>
#include <aws/iam/model/Group.h>
#include <aws/iam/model/GroupDetail.h>
#include <aws/iam/model/InstanceProfile.h>
#include <aws/iam/model/JobStatusType.h>
#include <aws/iam/model/ListAccessKeysRequest.h>
#include <aws/iam/model/ListAccessKeysResult.h>
#include <aws/iam/model/ListAccountAliasesRequest.h>
#include <aws/iam/model/ListAccountAliasesResult.h>
#include <aws/iam/model/ListAttachedGroupPoliciesRequest.h>
#include <aws/iam/model/ListAttachedGroupPoliciesResult.h>
#include <aws/iam/model/ListAttachedRolePoliciesRequest.h>
#include <aws/iam/model/ListAttachedRolePoliciesResult.h>
#include <aws/iam/model/ListAttachedUserPoliciesRequest.h>
#include <aws/iam/model/ListAttachedUserPoliciesResult.h>
#include <aws/iam/model/ListEntitiesForPolicyRequest.h>
#include <aws/iam/model/ListEntitiesForPolicyResult.h>
#include <aws/iam/model/ListGroupPoliciesRequest.h>
#include <aws/iam/model/ListGroupPoliciesResult.h>
#include <aws/iam/model/ListGroupsForUserRequest.h>
#include <aws/iam/model/ListGroupsForUserResult.h>
#include <aws/iam/model/ListGroupsRequest.h>
#include <aws/iam/model/ListGroupsResult.h>
#include <aws/iam/model/ListInstanceProfileTagsRequest.h>
#include <aws/iam/model/ListInstanceProfileTagsResult.h>
#include <aws/iam/model/ListInstanceProfilesForRoleRequest.h>
#include <aws/iam/model/ListInstanceProfilesForRoleResult.h>
#include <aws/iam/model/ListInstanceProfilesRequest.h>
#include <aws/iam/model/ListInstanceProfilesResult.h>
#include <aws/iam/model/ListMFADeviceTagsRequest.h>
#include <aws/iam/model/ListMFADeviceTagsResult.h>
#include <aws/iam/model/ListMFADevicesRequest.h>
#include <aws/iam/model/ListMFADevicesResult.h>
#include <aws/iam/model/ListOpenIDConnectProviderTagsRequest.h>
#include <aws/iam/model/ListOpenIDConnectProviderTagsResult.h>
#include <aws/iam/model/ListOpenIDConnectProvidersRequest.h>
#include <aws/iam/model/ListOpenIDConnectProvidersResult.h>
#include <aws/iam/model/ListOrganizationsFeaturesRequest.h>
#include <aws/iam/model/ListOrganizationsFeaturesResult.h>
#include <aws/iam/model/ListPoliciesGrantingServiceAccessEntry.h>
#include <aws/iam/model/ListPoliciesGrantingServiceAccessRequest.h>
#include <aws/iam/model/ListPoliciesGrantingServiceAccessResult.h>
#include <aws/iam/model/ListPoliciesRequest.h>
#include <aws/iam/model/ListPoliciesResult.h>
#include <aws/iam/model/ListPolicyTagsRequest.h>
#include <aws/iam/model/ListPolicyTagsResult.h>
#include <aws/iam/model/ListPolicyVersionsRequest.h>
#include <aws/iam/model/ListPolicyVersionsResult.h>
#include <aws/iam/model/ListRolePoliciesRequest.h>
#include <aws/iam/model/ListRolePoliciesResult.h>
#include <aws/iam/model/ListRoleTagsRequest.h>
#include <aws/iam/model/ListRoleTagsResult.h>
#include <aws/iam/model/ListRolesRequest.h>
#include <aws/iam/model/ListRolesResult.h>
#include <aws/iam/model/ListSAMLProviderTagsRequest.h>
#include <aws/iam/model/ListSAMLProviderTagsResult.h>
#include <aws/iam/model/ListSAMLProvidersRequest.h>
#include <aws/iam/model/ListSAMLProvidersResult.h>
#include <aws/iam/model/ListSSHPublicKeysRequest.h>
#include <aws/iam/model/ListSSHPublicKeysResult.h>
#include <aws/iam/model/ListServerCertificateTagsRequest.h>
#include <aws/iam/model/ListServerCertificateTagsResult.h>
#include <aws/iam/model/ListServerCertificatesRequest.h>
#include <aws/iam/model/ListServerCertificatesResult.h>
#include <aws/iam/model/ListServiceSpecificCredentialsRequest.h>
#include <aws/iam/model/ListServiceSpecificCredentialsResult.h>
#include <aws/iam/model/ListSigningCertificatesRequest.h>
#include <aws/iam/model/ListSigningCertificatesResult.h>
#include <aws/iam/model/ListUserPoliciesRequest.h>
#include <aws/iam/model/ListUserPoliciesResult.h>
#include <aws/iam/model/ListUserTagsRequest.h>
#include <aws/iam/model/ListUserTagsResult.h>
#include <aws/iam/model/ListUsersRequest.h>
#include <aws/iam/model/ListUsersResult.h>
#include <aws/iam/model/ListVirtualMFADevicesRequest.h>
#include <aws/iam/model/ListVirtualMFADevicesResult.h>
#include <aws/iam/model/LoginProfile.h>
#include <aws/iam/model/MFADevice.h>
#include <aws/iam/model/ManagedPolicyDetail.h>
#include <aws/iam/model/OpenIDConnectProviderListEntry.h>
#include <aws/iam/model/OrganizationsDecisionDetail.h>
#include <aws/iam/model/PasswordPolicy.h>
#include <aws/iam/model/PermissionsBoundaryAttachmentType.h>
#include <aws/iam/model/PermissionsBoundaryDecisionDetail.h>
#include <aws/iam/model/Policy.h>
#include <aws/iam/model/PolicyDetail.h>
#include <aws/iam/model/PolicyEvaluationDecisionType.h>
#include <aws/iam/model/PolicyGrantingServiceAccess.h>
#include <aws/iam/model/PolicyGroup.h>
#include <aws/iam/model/PolicyOwnerEntityType.h>
#include <aws/iam/model/PolicyRole.h>
#include <aws/iam/model/PolicyScopeType.h>
#include <aws/iam/model/PolicySourceType.h>
#include <aws/iam/model/PolicyType.h>
#include <aws/iam/model/PolicyUsageType.h>
#include <aws/iam/model/PolicyUser.h>
#include <aws/iam/model/PolicyVersion.h>
#include <aws/iam/model/Position.h>
#include <aws/iam/model/PutGroupPolicyRequest.h>
#include <aws/iam/model/PutRolePermissionsBoundaryRequest.h>
#include <aws/iam/model/PutRolePolicyRequest.h>
#include <aws/iam/model/PutUserPermissionsBoundaryRequest.h>
#include <aws/iam/model/PutUserPolicyRequest.h>
#include <aws/iam/model/RemoveClientIDFromOpenIDConnectProviderRequest.h>
#include <aws/iam/model/RemoveRoleFromInstanceProfileRequest.h>
#include <aws/iam/model/RemoveUserFromGroupRequest.h>
#include <aws/iam/model/ReportFormatType.h>
#include <aws/iam/model/ReportStateType.h>
#include <aws/iam/model/ResetServiceSpecificCredentialRequest.h>
#include <aws/iam/model/ResetServiceSpecificCredentialResult.h>
#include <aws/iam/model/ResourceSpecificResult.h>
#include <aws/iam/model/ResponseMetadata.h>
#include <aws/iam/model/ResyncMFADeviceRequest.h>
#include <aws/iam/model/Role.h>
#include <aws/iam/model/RoleDetail.h>
#include <aws/iam/model/RoleLastUsed.h>
#include <aws/iam/model/RoleUsageType.h>
#include <aws/iam/model/SAMLPrivateKey.h>
#include <aws/iam/model/SAMLProviderListEntry.h>
#include <aws/iam/model/SSHPublicKey.h>
#include <aws/iam/model/SSHPublicKeyMetadata.h>
#include <aws/iam/model/ServerCertificate.h>
#include <aws/iam/model/ServerCertificateMetadata.h>
#include <aws/iam/model/ServiceLastAccessed.h>
#include <aws/iam/model/ServiceSpecificCredential.h>
#include <aws/iam/model/ServiceSpecificCredentialMetadata.h>
#include <aws/iam/model/SetDefaultPolicyVersionRequest.h>
#include <aws/iam/model/SetSecurityTokenServicePreferencesRequest.h>
#include <aws/iam/model/SigningCertificate.h>
#include <aws/iam/model/SimulateCustomPolicyRequest.h>
#include <aws/iam/model/SimulateCustomPolicyResult.h>
#include <aws/iam/model/SimulatePrincipalPolicyRequest.h>
#include <aws/iam/model/SimulatePrincipalPolicyResult.h>
#include <aws/iam/model/SortKeyType.h>
#include <aws/iam/model/Statement.h>
#include <aws/iam/model/StatusType.h>
#include <aws/iam/model/SummaryKeyType.h>
#include <aws/iam/model/Tag.h>
#include <aws/iam/model/TagInstanceProfileRequest.h>
#include <aws/iam/model/TagMFADeviceRequest.h>
#include <aws/iam/model/TagOpenIDConnectProviderRequest.h>
#include <aws/iam/model/TagPolicyRequest.h>
#include <aws/iam/model/TagRoleRequest.h>
#include <aws/iam/model/TagSAMLProviderRequest.h>
#include <aws/iam/model/TagServerCertificateRequest.h>
#include <aws/iam/model/TagUserRequest.h>
#include <aws/iam/model/TrackedActionLastAccessed.h>
#include <aws/iam/model/UntagInstanceProfileRequest.h>
#include <aws/iam/model/UntagMFADeviceRequest.h>
#include <aws/iam/model/UntagOpenIDConnectProviderRequest.h>
#include <aws/iam/model/UntagPolicyRequest.h>
#include <aws/iam/model/UntagRoleRequest.h>
#include <aws/iam/model/UntagSAMLProviderRequest.h>
#include <aws/iam/model/UntagServerCertificateRequest.h>
#include <aws/iam/model/UntagUserRequest.h>
#include <aws/iam/model/UpdateAccessKeyRequest.h>
#include <aws/iam/model/UpdateAccountPasswordPolicyRequest.h>
#include <aws/iam/model/UpdateAssumeRolePolicyRequest.h>
#include <aws/iam/model/UpdateGroupRequest.h>
#include <aws/iam/model/UpdateLoginProfileRequest.h>
#include <aws/iam/model/UpdateOpenIDConnectProviderThumbprintRequest.h>
#include <aws/iam/model/UpdateRoleDescriptionRequest.h>
#include <aws/iam/model/UpdateRoleDescriptionResult.h>
#include <aws/iam/model/UpdateRoleRequest.h>
#include <aws/iam/model/UpdateRoleResult.h>
#include <aws/iam/model/UpdateSAMLProviderRequest.h>
#include <aws/iam/model/UpdateSAMLProviderResult.h>
#include <aws/iam/model/UpdateSSHPublicKeyRequest.h>
#include <aws/iam/model/UpdateServerCertificateRequest.h>
#include <aws/iam/model/UpdateServiceSpecificCredentialRequest.h>
#include <aws/iam/model/UpdateSigningCertificateRequest.h>
#include <aws/iam/model/UpdateUserRequest.h>
#include <aws/iam/model/UploadSSHPublicKeyRequest.h>
#include <aws/iam/model/UploadSSHPublicKeyResult.h>
#include <aws/iam/model/UploadServerCertificateRequest.h>
#include <aws/iam/model/UploadServerCertificateResult.h>
#include <aws/iam/model/UploadSigningCertificateRequest.h>
#include <aws/iam/model/UploadSigningCertificateResult.h>
#include <aws/iam/model/User.h>
#include <aws/iam/model/UserDetail.h>
#include <aws/iam/model/VirtualMFADevice.h>

using IAMIncludeTest = ::testing::Test;

TEST_F(IAMIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::IAM::IAMClient>("IAMIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
