/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/imagebuilder/ImagebuilderClient.h>
#include <aws/imagebuilder/ImagebuilderEndpointProvider.h>
#include <aws/imagebuilder/ImagebuilderEndpointRules.h>
#include <aws/imagebuilder/ImagebuilderErrorMarshaller.h>
#include <aws/imagebuilder/ImagebuilderErrors.h>
#include <aws/imagebuilder/ImagebuilderRequest.h>
#include <aws/imagebuilder/ImagebuilderServiceClientModel.h>
#include <aws/imagebuilder/Imagebuilder_EXPORTS.h>
#include <aws/imagebuilder/model/AccountAggregation.h>
#include <aws/imagebuilder/model/AdditionalInstanceConfiguration.h>
#include <aws/imagebuilder/model/Ami.h>
#include <aws/imagebuilder/model/AmiDistributionConfiguration.h>
#include <aws/imagebuilder/model/BuildType.h>
#include <aws/imagebuilder/model/CancelImageCreationRequest.h>
#include <aws/imagebuilder/model/CancelImageCreationResult.h>
#include <aws/imagebuilder/model/CancelLifecycleExecutionRequest.h>
#include <aws/imagebuilder/model/CancelLifecycleExecutionResult.h>
#include <aws/imagebuilder/model/Component.h>
#include <aws/imagebuilder/model/ComponentConfiguration.h>
#include <aws/imagebuilder/model/ComponentFormat.h>
#include <aws/imagebuilder/model/ComponentParameter.h>
#include <aws/imagebuilder/model/ComponentParameterDetail.h>
#include <aws/imagebuilder/model/ComponentState.h>
#include <aws/imagebuilder/model/ComponentStatus.h>
#include <aws/imagebuilder/model/ComponentSummary.h>
#include <aws/imagebuilder/model/ComponentType.h>
#include <aws/imagebuilder/model/ComponentVersion.h>
#include <aws/imagebuilder/model/Container.h>
#include <aws/imagebuilder/model/ContainerDistributionConfiguration.h>
#include <aws/imagebuilder/model/ContainerRecipe.h>
#include <aws/imagebuilder/model/ContainerRecipeSummary.h>
#include <aws/imagebuilder/model/ContainerRepositoryService.h>
#include <aws/imagebuilder/model/ContainerType.h>
#include <aws/imagebuilder/model/CreateComponentRequest.h>
#include <aws/imagebuilder/model/CreateComponentResult.h>
#include <aws/imagebuilder/model/CreateContainerRecipeRequest.h>
#include <aws/imagebuilder/model/CreateContainerRecipeResult.h>
#include <aws/imagebuilder/model/CreateDistributionConfigurationRequest.h>
#include <aws/imagebuilder/model/CreateDistributionConfigurationResult.h>
#include <aws/imagebuilder/model/CreateImagePipelineRequest.h>
#include <aws/imagebuilder/model/CreateImagePipelineResult.h>
#include <aws/imagebuilder/model/CreateImageRecipeRequest.h>
#include <aws/imagebuilder/model/CreateImageRecipeResult.h>
#include <aws/imagebuilder/model/CreateImageRequest.h>
#include <aws/imagebuilder/model/CreateImageResult.h>
#include <aws/imagebuilder/model/CreateInfrastructureConfigurationRequest.h>
#include <aws/imagebuilder/model/CreateInfrastructureConfigurationResult.h>
#include <aws/imagebuilder/model/CreateLifecyclePolicyRequest.h>
#include <aws/imagebuilder/model/CreateLifecyclePolicyResult.h>
#include <aws/imagebuilder/model/CreateWorkflowRequest.h>
#include <aws/imagebuilder/model/CreateWorkflowResult.h>
#include <aws/imagebuilder/model/CvssScore.h>
#include <aws/imagebuilder/model/CvssScoreAdjustment.h>
#include <aws/imagebuilder/model/CvssScoreDetails.h>
#include <aws/imagebuilder/model/DeleteComponentRequest.h>
#include <aws/imagebuilder/model/DeleteComponentResult.h>
#include <aws/imagebuilder/model/DeleteContainerRecipeRequest.h>
#include <aws/imagebuilder/model/DeleteContainerRecipeResult.h>
#include <aws/imagebuilder/model/DeleteDistributionConfigurationRequest.h>
#include <aws/imagebuilder/model/DeleteDistributionConfigurationResult.h>
#include <aws/imagebuilder/model/DeleteImagePipelineRequest.h>
#include <aws/imagebuilder/model/DeleteImagePipelineResult.h>
#include <aws/imagebuilder/model/DeleteImageRecipeRequest.h>
#include <aws/imagebuilder/model/DeleteImageRecipeResult.h>
#include <aws/imagebuilder/model/DeleteImageRequest.h>
#include <aws/imagebuilder/model/DeleteImageResult.h>
#include <aws/imagebuilder/model/DeleteInfrastructureConfigurationRequest.h>
#include <aws/imagebuilder/model/DeleteInfrastructureConfigurationResult.h>
#include <aws/imagebuilder/model/DeleteLifecyclePolicyRequest.h>
#include <aws/imagebuilder/model/DeleteLifecyclePolicyResult.h>
#include <aws/imagebuilder/model/DeleteWorkflowRequest.h>
#include <aws/imagebuilder/model/DeleteWorkflowResult.h>
#include <aws/imagebuilder/model/DiskImageFormat.h>
#include <aws/imagebuilder/model/Distribution.h>
#include <aws/imagebuilder/model/DistributionConfiguration.h>
#include <aws/imagebuilder/model/DistributionConfigurationSummary.h>
#include <aws/imagebuilder/model/EbsInstanceBlockDeviceSpecification.h>
#include <aws/imagebuilder/model/EbsVolumeType.h>
#include <aws/imagebuilder/model/EcrConfiguration.h>
#include <aws/imagebuilder/model/FastLaunchConfiguration.h>
#include <aws/imagebuilder/model/FastLaunchLaunchTemplateSpecification.h>
#include <aws/imagebuilder/model/FastLaunchSnapshotConfiguration.h>
#include <aws/imagebuilder/model/Filter.h>
#include <aws/imagebuilder/model/GetComponentPolicyRequest.h>
#include <aws/imagebuilder/model/GetComponentPolicyResult.h>
#include <aws/imagebuilder/model/GetComponentRequest.h>
#include <aws/imagebuilder/model/GetComponentResult.h>
#include <aws/imagebuilder/model/GetContainerRecipePolicyRequest.h>
#include <aws/imagebuilder/model/GetContainerRecipePolicyResult.h>
#include <aws/imagebuilder/model/GetContainerRecipeRequest.h>
#include <aws/imagebuilder/model/GetContainerRecipeResult.h>
#include <aws/imagebuilder/model/GetDistributionConfigurationRequest.h>
#include <aws/imagebuilder/model/GetDistributionConfigurationResult.h>
#include <aws/imagebuilder/model/GetImagePipelineRequest.h>
#include <aws/imagebuilder/model/GetImagePipelineResult.h>
#include <aws/imagebuilder/model/GetImagePolicyRequest.h>
#include <aws/imagebuilder/model/GetImagePolicyResult.h>
#include <aws/imagebuilder/model/GetImageRecipePolicyRequest.h>
#include <aws/imagebuilder/model/GetImageRecipePolicyResult.h>
#include <aws/imagebuilder/model/GetImageRecipeRequest.h>
#include <aws/imagebuilder/model/GetImageRecipeResult.h>
#include <aws/imagebuilder/model/GetImageRequest.h>
#include <aws/imagebuilder/model/GetImageResult.h>
#include <aws/imagebuilder/model/GetInfrastructureConfigurationRequest.h>
#include <aws/imagebuilder/model/GetInfrastructureConfigurationResult.h>
#include <aws/imagebuilder/model/GetLifecycleExecutionRequest.h>
#include <aws/imagebuilder/model/GetLifecycleExecutionResult.h>
#include <aws/imagebuilder/model/GetLifecyclePolicyRequest.h>
#include <aws/imagebuilder/model/GetLifecyclePolicyResult.h>
#include <aws/imagebuilder/model/GetMarketplaceResourceRequest.h>
#include <aws/imagebuilder/model/GetMarketplaceResourceResult.h>
#include <aws/imagebuilder/model/GetWorkflowExecutionRequest.h>
#include <aws/imagebuilder/model/GetWorkflowExecutionResult.h>
#include <aws/imagebuilder/model/GetWorkflowRequest.h>
#include <aws/imagebuilder/model/GetWorkflowResult.h>
#include <aws/imagebuilder/model/GetWorkflowStepExecutionRequest.h>
#include <aws/imagebuilder/model/GetWorkflowStepExecutionResult.h>
#include <aws/imagebuilder/model/Image.h>
#include <aws/imagebuilder/model/ImageAggregation.h>
#include <aws/imagebuilder/model/ImagePackage.h>
#include <aws/imagebuilder/model/ImagePipeline.h>
#include <aws/imagebuilder/model/ImagePipelineAggregation.h>
#include <aws/imagebuilder/model/ImageRecipe.h>
#include <aws/imagebuilder/model/ImageRecipeSummary.h>
#include <aws/imagebuilder/model/ImageScanFinding.h>
#include <aws/imagebuilder/model/ImageScanFindingAggregation.h>
#include <aws/imagebuilder/model/ImageScanFindingsFilter.h>
#include <aws/imagebuilder/model/ImageScanState.h>
#include <aws/imagebuilder/model/ImageScanStatus.h>
#include <aws/imagebuilder/model/ImageScanningConfiguration.h>
#include <aws/imagebuilder/model/ImageSource.h>
#include <aws/imagebuilder/model/ImageState.h>
#include <aws/imagebuilder/model/ImageStatus.h>
#include <aws/imagebuilder/model/ImageSummary.h>
#include <aws/imagebuilder/model/ImageTestsConfiguration.h>
#include <aws/imagebuilder/model/ImageType.h>
#include <aws/imagebuilder/model/ImageVersion.h>
#include <aws/imagebuilder/model/ImportComponentRequest.h>
#include <aws/imagebuilder/model/ImportComponentResult.h>
#include <aws/imagebuilder/model/ImportDiskImageRequest.h>
#include <aws/imagebuilder/model/ImportDiskImageResult.h>
#include <aws/imagebuilder/model/ImportVmImageRequest.h>
#include <aws/imagebuilder/model/ImportVmImageResult.h>
#include <aws/imagebuilder/model/InfrastructureConfiguration.h>
#include <aws/imagebuilder/model/InfrastructureConfigurationSummary.h>
#include <aws/imagebuilder/model/InspectorScoreDetails.h>
#include <aws/imagebuilder/model/InstanceBlockDeviceMapping.h>
#include <aws/imagebuilder/model/InstanceConfiguration.h>
#include <aws/imagebuilder/model/InstanceMetadataOptions.h>
#include <aws/imagebuilder/model/LaunchPermissionConfiguration.h>
#include <aws/imagebuilder/model/LaunchTemplateConfiguration.h>
#include <aws/imagebuilder/model/LifecycleExecution.h>
#include <aws/imagebuilder/model/LifecycleExecutionResource.h>
#include <aws/imagebuilder/model/LifecycleExecutionResourceAction.h>
#include <aws/imagebuilder/model/LifecycleExecutionResourceActionName.h>
#include <aws/imagebuilder/model/LifecycleExecutionResourceState.h>
#include <aws/imagebuilder/model/LifecycleExecutionResourceStatus.h>
#include <aws/imagebuilder/model/LifecycleExecutionResourcesImpactedSummary.h>
#include <aws/imagebuilder/model/LifecycleExecutionSnapshotResource.h>
#include <aws/imagebuilder/model/LifecycleExecutionState.h>
#include <aws/imagebuilder/model/LifecycleExecutionStatus.h>
#include <aws/imagebuilder/model/LifecyclePolicy.h>
#include <aws/imagebuilder/model/LifecyclePolicyDetail.h>
#include <aws/imagebuilder/model/LifecyclePolicyDetailAction.h>
#include <aws/imagebuilder/model/LifecyclePolicyDetailActionIncludeResources.h>
#include <aws/imagebuilder/model/LifecyclePolicyDetailActionType.h>
#include <aws/imagebuilder/model/LifecyclePolicyDetailExclusionRules.h>
#include <aws/imagebuilder/model/LifecyclePolicyDetailExclusionRulesAmis.h>
#include <aws/imagebuilder/model/LifecyclePolicyDetailExclusionRulesAmisLastLaunched.h>
#include <aws/imagebuilder/model/LifecyclePolicyDetailFilter.h>
#include <aws/imagebuilder/model/LifecyclePolicyDetailFilterType.h>
#include <aws/imagebuilder/model/LifecyclePolicyResourceSelection.h>
#include <aws/imagebuilder/model/LifecyclePolicyResourceSelectionRecipe.h>
#include <aws/imagebuilder/model/LifecyclePolicyResourceType.h>
#include <aws/imagebuilder/model/LifecyclePolicyStatus.h>
#include <aws/imagebuilder/model/LifecyclePolicySummary.h>
#include <aws/imagebuilder/model/LifecyclePolicyTimeUnit.h>
#include <aws/imagebuilder/model/ListComponentBuildVersionsRequest.h>
#include <aws/imagebuilder/model/ListComponentBuildVersionsResult.h>
#include <aws/imagebuilder/model/ListComponentsRequest.h>
#include <aws/imagebuilder/model/ListComponentsResult.h>
#include <aws/imagebuilder/model/ListContainerRecipesRequest.h>
#include <aws/imagebuilder/model/ListContainerRecipesResult.h>
#include <aws/imagebuilder/model/ListDistributionConfigurationsRequest.h>
#include <aws/imagebuilder/model/ListDistributionConfigurationsResult.h>
#include <aws/imagebuilder/model/ListImageBuildVersionsRequest.h>
#include <aws/imagebuilder/model/ListImageBuildVersionsResult.h>
#include <aws/imagebuilder/model/ListImagePackagesRequest.h>
#include <aws/imagebuilder/model/ListImagePackagesResult.h>
#include <aws/imagebuilder/model/ListImagePipelineImagesRequest.h>
#include <aws/imagebuilder/model/ListImagePipelineImagesResult.h>
#include <aws/imagebuilder/model/ListImagePipelinesRequest.h>
#include <aws/imagebuilder/model/ListImagePipelinesResult.h>
#include <aws/imagebuilder/model/ListImageRecipesRequest.h>
#include <aws/imagebuilder/model/ListImageRecipesResult.h>
#include <aws/imagebuilder/model/ListImageScanFindingAggregationsRequest.h>
#include <aws/imagebuilder/model/ListImageScanFindingAggregationsResult.h>
#include <aws/imagebuilder/model/ListImageScanFindingsRequest.h>
#include <aws/imagebuilder/model/ListImageScanFindingsResult.h>
#include <aws/imagebuilder/model/ListImagesRequest.h>
#include <aws/imagebuilder/model/ListImagesResult.h>
#include <aws/imagebuilder/model/ListInfrastructureConfigurationsRequest.h>
#include <aws/imagebuilder/model/ListInfrastructureConfigurationsResult.h>
#include <aws/imagebuilder/model/ListLifecycleExecutionResourcesRequest.h>
#include <aws/imagebuilder/model/ListLifecycleExecutionResourcesResult.h>
#include <aws/imagebuilder/model/ListLifecycleExecutionsRequest.h>
#include <aws/imagebuilder/model/ListLifecycleExecutionsResult.h>
#include <aws/imagebuilder/model/ListLifecyclePoliciesRequest.h>
#include <aws/imagebuilder/model/ListLifecyclePoliciesResult.h>
#include <aws/imagebuilder/model/ListTagsForResourceRequest.h>
#include <aws/imagebuilder/model/ListTagsForResourceResult.h>
#include <aws/imagebuilder/model/ListWaitingWorkflowStepsRequest.h>
#include <aws/imagebuilder/model/ListWaitingWorkflowStepsResult.h>
#include <aws/imagebuilder/model/ListWorkflowBuildVersionsRequest.h>
#include <aws/imagebuilder/model/ListWorkflowBuildVersionsResult.h>
#include <aws/imagebuilder/model/ListWorkflowExecutionsRequest.h>
#include <aws/imagebuilder/model/ListWorkflowExecutionsResult.h>
#include <aws/imagebuilder/model/ListWorkflowStepExecutionsRequest.h>
#include <aws/imagebuilder/model/ListWorkflowStepExecutionsResult.h>
#include <aws/imagebuilder/model/ListWorkflowsRequest.h>
#include <aws/imagebuilder/model/ListWorkflowsResult.h>
#include <aws/imagebuilder/model/Logging.h>
#include <aws/imagebuilder/model/MarketplaceResourceType.h>
#include <aws/imagebuilder/model/OnWorkflowFailure.h>
#include <aws/imagebuilder/model/OutputResources.h>
#include <aws/imagebuilder/model/Ownership.h>
#include <aws/imagebuilder/model/PackageVulnerabilityDetails.h>
#include <aws/imagebuilder/model/PipelineExecutionStartCondition.h>
#include <aws/imagebuilder/model/PipelineStatus.h>
#include <aws/imagebuilder/model/Placement.h>
#include <aws/imagebuilder/model/Platform.h>
#include <aws/imagebuilder/model/ProductCodeListItem.h>
#include <aws/imagebuilder/model/ProductCodeType.h>
#include <aws/imagebuilder/model/PutComponentPolicyRequest.h>
#include <aws/imagebuilder/model/PutComponentPolicyResult.h>
#include <aws/imagebuilder/model/PutContainerRecipePolicyRequest.h>
#include <aws/imagebuilder/model/PutContainerRecipePolicyResult.h>
#include <aws/imagebuilder/model/PutImagePolicyRequest.h>
#include <aws/imagebuilder/model/PutImagePolicyResult.h>
#include <aws/imagebuilder/model/PutImageRecipePolicyRequest.h>
#include <aws/imagebuilder/model/PutImageRecipePolicyResult.h>
#include <aws/imagebuilder/model/Remediation.h>
#include <aws/imagebuilder/model/RemediationRecommendation.h>
#include <aws/imagebuilder/model/ResourceState.h>
#include <aws/imagebuilder/model/ResourceStateUpdateExclusionRules.h>
#include <aws/imagebuilder/model/ResourceStateUpdateIncludeResources.h>
#include <aws/imagebuilder/model/ResourceStatus.h>
#include <aws/imagebuilder/model/S3ExportConfiguration.h>
#include <aws/imagebuilder/model/S3Logs.h>
#include <aws/imagebuilder/model/Schedule.h>
#include <aws/imagebuilder/model/SendWorkflowStepActionRequest.h>
#include <aws/imagebuilder/model/SendWorkflowStepActionResult.h>
#include <aws/imagebuilder/model/SeverityCounts.h>
#include <aws/imagebuilder/model/SsmParameterConfiguration.h>
#include <aws/imagebuilder/model/SsmParameterDataType.h>
#include <aws/imagebuilder/model/StartImagePipelineExecutionRequest.h>
#include <aws/imagebuilder/model/StartImagePipelineExecutionResult.h>
#include <aws/imagebuilder/model/StartResourceStateUpdateRequest.h>
#include <aws/imagebuilder/model/StartResourceStateUpdateResult.h>
#include <aws/imagebuilder/model/SystemsManagerAgent.h>
#include <aws/imagebuilder/model/TagResourceRequest.h>
#include <aws/imagebuilder/model/TagResourceResult.h>
#include <aws/imagebuilder/model/TargetContainerRepository.h>
#include <aws/imagebuilder/model/TenancyType.h>
#include <aws/imagebuilder/model/UntagResourceRequest.h>
#include <aws/imagebuilder/model/UntagResourceResult.h>
#include <aws/imagebuilder/model/UpdateDistributionConfigurationRequest.h>
#include <aws/imagebuilder/model/UpdateDistributionConfigurationResult.h>
#include <aws/imagebuilder/model/UpdateImagePipelineRequest.h>
#include <aws/imagebuilder/model/UpdateImagePipelineResult.h>
#include <aws/imagebuilder/model/UpdateInfrastructureConfigurationRequest.h>
#include <aws/imagebuilder/model/UpdateInfrastructureConfigurationResult.h>
#include <aws/imagebuilder/model/UpdateLifecyclePolicyRequest.h>
#include <aws/imagebuilder/model/UpdateLifecyclePolicyResult.h>
#include <aws/imagebuilder/model/VulnerabilityIdAggregation.h>
#include <aws/imagebuilder/model/VulnerablePackage.h>
#include <aws/imagebuilder/model/Workflow.h>
#include <aws/imagebuilder/model/WorkflowConfiguration.h>
#include <aws/imagebuilder/model/WorkflowExecutionMetadata.h>
#include <aws/imagebuilder/model/WorkflowExecutionStatus.h>
#include <aws/imagebuilder/model/WorkflowParameter.h>
#include <aws/imagebuilder/model/WorkflowParameterDetail.h>
#include <aws/imagebuilder/model/WorkflowState.h>
#include <aws/imagebuilder/model/WorkflowStatus.h>
#include <aws/imagebuilder/model/WorkflowStepActionType.h>
#include <aws/imagebuilder/model/WorkflowStepExecution.h>
#include <aws/imagebuilder/model/WorkflowStepExecutionRollbackStatus.h>
#include <aws/imagebuilder/model/WorkflowStepExecutionStatus.h>
#include <aws/imagebuilder/model/WorkflowStepMetadata.h>
#include <aws/imagebuilder/model/WorkflowSummary.h>
#include <aws/imagebuilder/model/WorkflowType.h>
#include <aws/imagebuilder/model/WorkflowVersion.h>

using ImagebuilderIncludeTest = ::testing::Test;

TEST_F(ImagebuilderIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::imagebuilder::ImagebuilderClient>("ImagebuilderIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
