/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/inspector2/Inspector2Client.h>
#include <aws/inspector2/Inspector2EndpointProvider.h>
#include <aws/inspector2/Inspector2EndpointRules.h>
#include <aws/inspector2/Inspector2ErrorMarshaller.h>
#include <aws/inspector2/Inspector2Errors.h>
#include <aws/inspector2/Inspector2Request.h>
#include <aws/inspector2/Inspector2ServiceClientModel.h>
#include <aws/inspector2/Inspector2_EXPORTS.h>
#include <aws/inspector2/model/Account.h>
#include <aws/inspector2/model/AccountAggregation.h>
#include <aws/inspector2/model/AccountAggregationResponse.h>
#include <aws/inspector2/model/AccountSortBy.h>
#include <aws/inspector2/model/AccountState.h>
#include <aws/inspector2/model/AggregationFindingType.h>
#include <aws/inspector2/model/AggregationRequest.h>
#include <aws/inspector2/model/AggregationResourceType.h>
#include <aws/inspector2/model/AggregationResponse.h>
#include <aws/inspector2/model/AggregationType.h>
#include <aws/inspector2/model/AmiAggregation.h>
#include <aws/inspector2/model/AmiAggregationResponse.h>
#include <aws/inspector2/model/AmiSortBy.h>
#include <aws/inspector2/model/Architecture.h>
#include <aws/inspector2/model/AssociateConfigurationRequest.h>
#include <aws/inspector2/model/AssociateMemberRequest.h>
#include <aws/inspector2/model/AssociateMemberResult.h>
#include <aws/inspector2/model/AssociationResultStatusCode.h>
#include <aws/inspector2/model/AtigData.h>
#include <aws/inspector2/model/AutoEnable.h>
#include <aws/inspector2/model/AwsEc2InstanceDetails.h>
#include <aws/inspector2/model/AwsEcrContainerAggregation.h>
#include <aws/inspector2/model/AwsEcrContainerAggregationResponse.h>
#include <aws/inspector2/model/AwsEcrContainerImageDetails.h>
#include <aws/inspector2/model/AwsEcrContainerSortBy.h>
#include <aws/inspector2/model/AwsEcsMetadataDetails.h>
#include <aws/inspector2/model/AwsEksMetadataDetails.h>
#include <aws/inspector2/model/AwsEksWorkloadInfo.h>
#include <aws/inspector2/model/AwsLambdaFunctionDetails.h>
#include <aws/inspector2/model/BatchAssociateCodeSecurityScanConfigurationRequest.h>
#include <aws/inspector2/model/BatchAssociateCodeSecurityScanConfigurationResult.h>
#include <aws/inspector2/model/BatchDisassociateCodeSecurityScanConfigurationRequest.h>
#include <aws/inspector2/model/BatchDisassociateCodeSecurityScanConfigurationResult.h>
#include <aws/inspector2/model/BatchGetAccountStatusRequest.h>
#include <aws/inspector2/model/BatchGetAccountStatusResult.h>
#include <aws/inspector2/model/BatchGetCodeSnippetRequest.h>
#include <aws/inspector2/model/BatchGetCodeSnippetResult.h>
#include <aws/inspector2/model/BatchGetFindingDetailsRequest.h>
#include <aws/inspector2/model/BatchGetFindingDetailsResult.h>
#include <aws/inspector2/model/BatchGetFreeTrialInfoRequest.h>
#include <aws/inspector2/model/BatchGetFreeTrialInfoResult.h>
#include <aws/inspector2/model/BatchGetMemberEc2DeepInspectionStatusRequest.h>
#include <aws/inspector2/model/BatchGetMemberEc2DeepInspectionStatusResult.h>
#include <aws/inspector2/model/BatchUpdateMemberEc2DeepInspectionStatusRequest.h>
#include <aws/inspector2/model/BatchUpdateMemberEc2DeepInspectionStatusResult.h>
#include <aws/inspector2/model/CancelFindingsReportRequest.h>
#include <aws/inspector2/model/CancelFindingsReportResult.h>
#include <aws/inspector2/model/CancelSbomExportRequest.h>
#include <aws/inspector2/model/CancelSbomExportResult.h>
#include <aws/inspector2/model/CisCheckAggregation.h>
#include <aws/inspector2/model/CisDateFilter.h>
#include <aws/inspector2/model/CisFindingStatus.h>
#include <aws/inspector2/model/CisFindingStatusComparison.h>
#include <aws/inspector2/model/CisFindingStatusFilter.h>
#include <aws/inspector2/model/CisNumberFilter.h>
#include <aws/inspector2/model/CisReportFormat.h>
#include <aws/inspector2/model/CisReportStatus.h>
#include <aws/inspector2/model/CisResultStatus.h>
#include <aws/inspector2/model/CisResultStatusComparison.h>
#include <aws/inspector2/model/CisResultStatusFilter.h>
#include <aws/inspector2/model/CisRuleStatus.h>
#include <aws/inspector2/model/CisScan.h>
#include <aws/inspector2/model/CisScanConfiguration.h>
#include <aws/inspector2/model/CisScanConfigurationsSortBy.h>
#include <aws/inspector2/model/CisScanResultDetails.h>
#include <aws/inspector2/model/CisScanResultDetailsFilterCriteria.h>
#include <aws/inspector2/model/CisScanResultDetailsSortBy.h>
#include <aws/inspector2/model/CisScanResultsAggregatedByChecksFilterCriteria.h>
#include <aws/inspector2/model/CisScanResultsAggregatedByChecksSortBy.h>
#include <aws/inspector2/model/CisScanResultsAggregatedByTargetResourceFilterCriteria.h>
#include <aws/inspector2/model/CisScanResultsAggregatedByTargetResourceSortBy.h>
#include <aws/inspector2/model/CisScanStatus.h>
#include <aws/inspector2/model/CisScanStatusComparison.h>
#include <aws/inspector2/model/CisScanStatusFilter.h>
#include <aws/inspector2/model/CisSecurityLevel.h>
#include <aws/inspector2/model/CisSecurityLevelComparison.h>
#include <aws/inspector2/model/CisSecurityLevelFilter.h>
#include <aws/inspector2/model/CisSessionMessage.h>
#include <aws/inspector2/model/CisSortOrder.h>
#include <aws/inspector2/model/CisStringComparison.h>
#include <aws/inspector2/model/CisStringFilter.h>
#include <aws/inspector2/model/CisTargetResourceAggregation.h>
#include <aws/inspector2/model/CisTargetStatus.h>
#include <aws/inspector2/model/CisTargetStatusComparison.h>
#include <aws/inspector2/model/CisTargetStatusFilter.h>
#include <aws/inspector2/model/CisTargetStatusReason.h>
#include <aws/inspector2/model/CisTargetStatusReasonFilter.h>
#include <aws/inspector2/model/CisTargets.h>
#include <aws/inspector2/model/CisaData.h>
#include <aws/inspector2/model/ClusterDetails.h>
#include <aws/inspector2/model/ClusterForImageFilterCriteria.h>
#include <aws/inspector2/model/ClusterInformation.h>
#include <aws/inspector2/model/ClusterMetadata.h>
#include <aws/inspector2/model/CodeFilePath.h>
#include <aws/inspector2/model/CodeLine.h>
#include <aws/inspector2/model/CodeRepositoryAggregation.h>
#include <aws/inspector2/model/CodeRepositoryAggregationResponse.h>
#include <aws/inspector2/model/CodeRepositoryDetails.h>
#include <aws/inspector2/model/CodeRepositoryMetadata.h>
#include <aws/inspector2/model/CodeRepositoryOnDemandScan.h>
#include <aws/inspector2/model/CodeRepositoryProviderType.h>
#include <aws/inspector2/model/CodeRepositorySortBy.h>
#include <aws/inspector2/model/CodeScanStatus.h>
#include <aws/inspector2/model/CodeSecurityIntegrationSummary.h>
#include <aws/inspector2/model/CodeSecurityResource.h>
#include <aws/inspector2/model/CodeSecurityScanConfiguration.h>
#include <aws/inspector2/model/CodeSecurityScanConfigurationAssociationSummary.h>
#include <aws/inspector2/model/CodeSecurityScanConfigurationSummary.h>
#include <aws/inspector2/model/CodeSnippetError.h>
#include <aws/inspector2/model/CodeSnippetErrorCode.h>
#include <aws/inspector2/model/CodeSnippetResult.h>
#include <aws/inspector2/model/CodeVulnerabilityDetails.h>
#include <aws/inspector2/model/ComputePlatform.h>
#include <aws/inspector2/model/ConfigurationLevel.h>
#include <aws/inspector2/model/ConflictException.h>
#include <aws/inspector2/model/ContinuousIntegrationScanConfiguration.h>
#include <aws/inspector2/model/ContinuousIntegrationScanEvent.h>
#include <aws/inspector2/model/Counts.h>
#include <aws/inspector2/model/CoverageDateFilter.h>
#include <aws/inspector2/model/CoverageFilterCriteria.h>
#include <aws/inspector2/model/CoverageMapComparison.h>
#include <aws/inspector2/model/CoverageMapFilter.h>
#include <aws/inspector2/model/CoverageNumberFilter.h>
#include <aws/inspector2/model/CoverageResourceType.h>
#include <aws/inspector2/model/CoverageStringComparison.h>
#include <aws/inspector2/model/CoverageStringFilter.h>
#include <aws/inspector2/model/CoveredResource.h>
#include <aws/inspector2/model/CreateCisScanConfigurationRequest.h>
#include <aws/inspector2/model/CreateCisScanConfigurationResult.h>
#include <aws/inspector2/model/CreateCisTargets.h>
#include <aws/inspector2/model/CreateCodeSecurityIntegrationRequest.h>
#include <aws/inspector2/model/CreateCodeSecurityIntegrationResult.h>
#include <aws/inspector2/model/CreateCodeSecurityScanConfigurationRequest.h>
#include <aws/inspector2/model/CreateCodeSecurityScanConfigurationResult.h>
#include <aws/inspector2/model/CreateFilterRequest.h>
#include <aws/inspector2/model/CreateFilterResult.h>
#include <aws/inspector2/model/CreateFindingsReportRequest.h>
#include <aws/inspector2/model/CreateFindingsReportResult.h>
#include <aws/inspector2/model/CreateGitLabSelfManagedIntegrationDetail.h>
#include <aws/inspector2/model/CreateIntegrationDetail.h>
#include <aws/inspector2/model/CreateSbomExportRequest.h>
#include <aws/inspector2/model/CreateSbomExportResult.h>
#include <aws/inspector2/model/Currency.h>
#include <aws/inspector2/model/Cvss2.h>
#include <aws/inspector2/model/Cvss3.h>
#include <aws/inspector2/model/CvssScore.h>
#include <aws/inspector2/model/CvssScoreAdjustment.h>
#include <aws/inspector2/model/CvssScoreDetails.h>
#include <aws/inspector2/model/DailySchedule.h>
#include <aws/inspector2/model/DateFilter.h>
#include <aws/inspector2/model/Day.h>
#include <aws/inspector2/model/DelegatedAdmin.h>
#include <aws/inspector2/model/DelegatedAdminAccount.h>
#include <aws/inspector2/model/DelegatedAdminStatus.h>
#include <aws/inspector2/model/DeleteCisScanConfigurationRequest.h>
#include <aws/inspector2/model/DeleteCisScanConfigurationResult.h>
#include <aws/inspector2/model/DeleteCodeSecurityIntegrationRequest.h>
#include <aws/inspector2/model/DeleteCodeSecurityIntegrationResult.h>
#include <aws/inspector2/model/DeleteCodeSecurityScanConfigurationRequest.h>
#include <aws/inspector2/model/DeleteCodeSecurityScanConfigurationResult.h>
#include <aws/inspector2/model/DeleteFilterRequest.h>
#include <aws/inspector2/model/DeleteFilterResult.h>
#include <aws/inspector2/model/DescribeOrganizationConfigurationRequest.h>
#include <aws/inspector2/model/DescribeOrganizationConfigurationResult.h>
#include <aws/inspector2/model/Destination.h>
#include <aws/inspector2/model/DisableDelegatedAdminAccountRequest.h>
#include <aws/inspector2/model/DisableDelegatedAdminAccountResult.h>
#include <aws/inspector2/model/DisableRequest.h>
#include <aws/inspector2/model/DisableResult.h>
#include <aws/inspector2/model/DisassociateConfigurationRequest.h>
#include <aws/inspector2/model/DisassociateMemberRequest.h>
#include <aws/inspector2/model/DisassociateMemberResult.h>
#include <aws/inspector2/model/Ec2Configuration.h>
#include <aws/inspector2/model/Ec2ConfigurationState.h>
#include <aws/inspector2/model/Ec2DeepInspectionStatus.h>
#include <aws/inspector2/model/Ec2InstanceAggregation.h>
#include <aws/inspector2/model/Ec2InstanceAggregationResponse.h>
#include <aws/inspector2/model/Ec2InstanceSortBy.h>
#include <aws/inspector2/model/Ec2Metadata.h>
#include <aws/inspector2/model/Ec2Platform.h>
#include <aws/inspector2/model/Ec2ScanMode.h>
#include <aws/inspector2/model/Ec2ScanModeState.h>
#include <aws/inspector2/model/Ec2ScanModeStatus.h>
#include <aws/inspector2/model/EcrConfiguration.h>
#include <aws/inspector2/model/EcrConfigurationState.h>
#include <aws/inspector2/model/EcrContainerImageMetadata.h>
#include <aws/inspector2/model/EcrPullDateRescanDuration.h>
#include <aws/inspector2/model/EcrPullDateRescanMode.h>
#include <aws/inspector2/model/EcrRepositoryMetadata.h>
#include <aws/inspector2/model/EcrRescanDuration.h>
#include <aws/inspector2/model/EcrRescanDurationState.h>
#include <aws/inspector2/model/EcrRescanDurationStatus.h>
#include <aws/inspector2/model/EcrScanFrequency.h>
#include <aws/inspector2/model/EnableDelegatedAdminAccountRequest.h>
#include <aws/inspector2/model/EnableDelegatedAdminAccountResult.h>
#include <aws/inspector2/model/EnableRequest.h>
#include <aws/inspector2/model/EnableResult.h>
#include <aws/inspector2/model/Epss.h>
#include <aws/inspector2/model/EpssDetails.h>
#include <aws/inspector2/model/ErrorCode.h>
#include <aws/inspector2/model/Evidence.h>
#include <aws/inspector2/model/ExploitAvailable.h>
#include <aws/inspector2/model/ExploitObserved.h>
#include <aws/inspector2/model/ExploitabilityDetails.h>
#include <aws/inspector2/model/ExternalReportStatus.h>
#include <aws/inspector2/model/FailedAccount.h>
#include <aws/inspector2/model/FailedAssociationResult.h>
#include <aws/inspector2/model/FailedMemberAccountEc2DeepInspectionStatusState.h>
#include <aws/inspector2/model/Filter.h>
#include <aws/inspector2/model/FilterAction.h>
#include <aws/inspector2/model/FilterCriteria.h>
#include <aws/inspector2/model/Finding.h>
#include <aws/inspector2/model/FindingDetail.h>
#include <aws/inspector2/model/FindingDetailsError.h>
#include <aws/inspector2/model/FindingDetailsErrorCode.h>
#include <aws/inspector2/model/FindingStatus.h>
#include <aws/inspector2/model/FindingType.h>
#include <aws/inspector2/model/FindingTypeAggregation.h>
#include <aws/inspector2/model/FindingTypeAggregationResponse.h>
#include <aws/inspector2/model/FindingTypeSortBy.h>
#include <aws/inspector2/model/FixAvailable.h>
#include <aws/inspector2/model/FreeTrialAccountInfo.h>
#include <aws/inspector2/model/FreeTrialInfo.h>
#include <aws/inspector2/model/FreeTrialInfoError.h>
#include <aws/inspector2/model/FreeTrialInfoErrorCode.h>
#include <aws/inspector2/model/FreeTrialStatus.h>
#include <aws/inspector2/model/FreeTrialType.h>
#include <aws/inspector2/model/GetCisScanReportRequest.h>
#include <aws/inspector2/model/GetCisScanReportResult.h>
#include <aws/inspector2/model/GetCisScanResultDetailsRequest.h>
#include <aws/inspector2/model/GetCisScanResultDetailsResult.h>
#include <aws/inspector2/model/GetClustersForImageRequest.h>
#include <aws/inspector2/model/GetClustersForImageResult.h>
#include <aws/inspector2/model/GetCodeSecurityIntegrationRequest.h>
#include <aws/inspector2/model/GetCodeSecurityIntegrationResult.h>
#include <aws/inspector2/model/GetCodeSecurityScanConfigurationRequest.h>
#include <aws/inspector2/model/GetCodeSecurityScanConfigurationResult.h>
#include <aws/inspector2/model/GetCodeSecurityScanRequest.h>
#include <aws/inspector2/model/GetCodeSecurityScanResult.h>
#include <aws/inspector2/model/GetConfigurationRequest.h>
#include <aws/inspector2/model/GetConfigurationResult.h>
#include <aws/inspector2/model/GetDelegatedAdminAccountRequest.h>
#include <aws/inspector2/model/GetDelegatedAdminAccountResult.h>
#include <aws/inspector2/model/GetEc2DeepInspectionConfigurationRequest.h>
#include <aws/inspector2/model/GetEc2DeepInspectionConfigurationResult.h>
#include <aws/inspector2/model/GetEncryptionKeyRequest.h>
#include <aws/inspector2/model/GetEncryptionKeyResult.h>
#include <aws/inspector2/model/GetFindingsReportStatusRequest.h>
#include <aws/inspector2/model/GetFindingsReportStatusResult.h>
#include <aws/inspector2/model/GetMemberRequest.h>
#include <aws/inspector2/model/GetMemberResult.h>
#include <aws/inspector2/model/GetSbomExportRequest.h>
#include <aws/inspector2/model/GetSbomExportResult.h>
#include <aws/inspector2/model/GroupKey.h>
#include <aws/inspector2/model/ImageLayerAggregation.h>
#include <aws/inspector2/model/ImageLayerAggregationResponse.h>
#include <aws/inspector2/model/ImageLayerSortBy.h>
#include <aws/inspector2/model/InspectorScoreDetails.h>
#include <aws/inspector2/model/IntegrationStatus.h>
#include <aws/inspector2/model/IntegrationType.h>
#include <aws/inspector2/model/InternalServerException.h>
#include <aws/inspector2/model/LambdaFunctionAggregation.h>
#include <aws/inspector2/model/LambdaFunctionAggregationResponse.h>
#include <aws/inspector2/model/LambdaFunctionMetadata.h>
#include <aws/inspector2/model/LambdaFunctionSortBy.h>
#include <aws/inspector2/model/LambdaLayerAggregation.h>
#include <aws/inspector2/model/LambdaLayerAggregationResponse.h>
#include <aws/inspector2/model/LambdaLayerSortBy.h>
#include <aws/inspector2/model/LambdaVpcConfig.h>
#include <aws/inspector2/model/ListAccountPermissionsRequest.h>
#include <aws/inspector2/model/ListAccountPermissionsResult.h>
#include <aws/inspector2/model/ListCisScanConfigurationsFilterCriteria.h>
#include <aws/inspector2/model/ListCisScanConfigurationsRequest.h>
#include <aws/inspector2/model/ListCisScanConfigurationsResult.h>
#include <aws/inspector2/model/ListCisScanResultsAggregatedByChecksRequest.h>
#include <aws/inspector2/model/ListCisScanResultsAggregatedByChecksResult.h>
#include <aws/inspector2/model/ListCisScanResultsAggregatedByTargetResourceRequest.h>
#include <aws/inspector2/model/ListCisScanResultsAggregatedByTargetResourceResult.h>
#include <aws/inspector2/model/ListCisScansDetailLevel.h>
#include <aws/inspector2/model/ListCisScansFilterCriteria.h>
#include <aws/inspector2/model/ListCisScansRequest.h>
#include <aws/inspector2/model/ListCisScansResult.h>
#include <aws/inspector2/model/ListCisScansSortBy.h>
#include <aws/inspector2/model/ListCodeSecurityIntegrationsRequest.h>
#include <aws/inspector2/model/ListCodeSecurityIntegrationsResult.h>
#include <aws/inspector2/model/ListCodeSecurityScanConfigurationAssociationsRequest.h>
#include <aws/inspector2/model/ListCodeSecurityScanConfigurationAssociationsResult.h>
#include <aws/inspector2/model/ListCodeSecurityScanConfigurationsRequest.h>
#include <aws/inspector2/model/ListCodeSecurityScanConfigurationsResult.h>
#include <aws/inspector2/model/ListCoverageRequest.h>
#include <aws/inspector2/model/ListCoverageResult.h>
#include <aws/inspector2/model/ListCoverageStatisticsRequest.h>
#include <aws/inspector2/model/ListCoverageStatisticsResult.h>
#include <aws/inspector2/model/ListDelegatedAdminAccountsRequest.h>
#include <aws/inspector2/model/ListDelegatedAdminAccountsResult.h>
#include <aws/inspector2/model/ListFiltersRequest.h>
#include <aws/inspector2/model/ListFiltersResult.h>
#include <aws/inspector2/model/ListFindingAggregationsRequest.h>
#include <aws/inspector2/model/ListFindingAggregationsResult.h>
#include <aws/inspector2/model/ListFindingsRequest.h>
#include <aws/inspector2/model/ListFindingsResult.h>
#include <aws/inspector2/model/ListMembersRequest.h>
#include <aws/inspector2/model/ListMembersResult.h>
#include <aws/inspector2/model/ListTagsForResourceRequest.h>
#include <aws/inspector2/model/ListTagsForResourceResult.h>
#include <aws/inspector2/model/ListUsageTotalsRequest.h>
#include <aws/inspector2/model/ListUsageTotalsResult.h>
#include <aws/inspector2/model/MapComparison.h>
#include <aws/inspector2/model/MapFilter.h>
#include <aws/inspector2/model/Member.h>
#include <aws/inspector2/model/MemberAccountEc2DeepInspectionStatus.h>
#include <aws/inspector2/model/MemberAccountEc2DeepInspectionStatusState.h>
#include <aws/inspector2/model/MonthlySchedule.h>
#include <aws/inspector2/model/NetworkPath.h>
#include <aws/inspector2/model/NetworkProtocol.h>
#include <aws/inspector2/model/NetworkReachabilityDetails.h>
#include <aws/inspector2/model/NumberFilter.h>
#include <aws/inspector2/model/OneTimeSchedule.h>
#include <aws/inspector2/model/Operation.h>
#include <aws/inspector2/model/PackageAggregation.h>
#include <aws/inspector2/model/PackageAggregationResponse.h>
#include <aws/inspector2/model/PackageFilter.h>
#include <aws/inspector2/model/PackageManager.h>
#include <aws/inspector2/model/PackageSortBy.h>
#include <aws/inspector2/model/PackageType.h>
#include <aws/inspector2/model/PackageVulnerabilityDetails.h>
#include <aws/inspector2/model/PeriodicScanConfiguration.h>
#include <aws/inspector2/model/PeriodicScanFrequency.h>
#include <aws/inspector2/model/Permission.h>
#include <aws/inspector2/model/PortRange.h>
#include <aws/inspector2/model/PortRangeFilter.h>
#include <aws/inspector2/model/ProjectCodeSecurityScanConfiguration.h>
#include <aws/inspector2/model/ProjectContinuousIntegrationScanConfiguration.h>
#include <aws/inspector2/model/ProjectPeriodicScanConfiguration.h>
#include <aws/inspector2/model/ProjectSelectionScope.h>
#include <aws/inspector2/model/Recommendation.h>
#include <aws/inspector2/model/RelationshipStatus.h>
#include <aws/inspector2/model/Remediation.h>
#include <aws/inspector2/model/ReportFormat.h>
#include <aws/inspector2/model/ReportingErrorCode.h>
#include <aws/inspector2/model/RepositoryAggregation.h>
#include <aws/inspector2/model/RepositoryAggregationResponse.h>
#include <aws/inspector2/model/RepositorySortBy.h>
#include <aws/inspector2/model/ResetEncryptionKeyRequest.h>
#include <aws/inspector2/model/ResetEncryptionKeyResult.h>
#include <aws/inspector2/model/Resource.h>
#include <aws/inspector2/model/ResourceDetails.h>
#include <aws/inspector2/model/ResourceFilterCriteria.h>
#include <aws/inspector2/model/ResourceMapComparison.h>
#include <aws/inspector2/model/ResourceMapFilter.h>
#include <aws/inspector2/model/ResourceScanMetadata.h>
#include <aws/inspector2/model/ResourceScanType.h>
#include <aws/inspector2/model/ResourceState.h>
#include <aws/inspector2/model/ResourceStatus.h>
#include <aws/inspector2/model/ResourceStringComparison.h>
#include <aws/inspector2/model/ResourceStringFilter.h>
#include <aws/inspector2/model/ResourceType.h>
#include <aws/inspector2/model/RuleSetCategory.h>
#include <aws/inspector2/model/Runtime.h>
#include <aws/inspector2/model/SbomReportFormat.h>
#include <aws/inspector2/model/ScanMode.h>
#include <aws/inspector2/model/ScanStatus.h>
#include <aws/inspector2/model/ScanStatusCode.h>
#include <aws/inspector2/model/ScanStatusReason.h>
#include <aws/inspector2/model/ScanType.h>
#include <aws/inspector2/model/Schedule.h>
#include <aws/inspector2/model/ScopeSettings.h>
#include <aws/inspector2/model/SearchVulnerabilitiesFilterCriteria.h>
#include <aws/inspector2/model/SearchVulnerabilitiesRequest.h>
#include <aws/inspector2/model/SearchVulnerabilitiesResult.h>
#include <aws/inspector2/model/SendCisSessionHealthRequest.h>
#include <aws/inspector2/model/SendCisSessionHealthResult.h>
#include <aws/inspector2/model/SendCisSessionTelemetryRequest.h>
#include <aws/inspector2/model/SendCisSessionTelemetryResult.h>
#include <aws/inspector2/model/Service.h>
#include <aws/inspector2/model/ServiceQuotaExceededException.h>
#include <aws/inspector2/model/Severity.h>
#include <aws/inspector2/model/SeverityCounts.h>
#include <aws/inspector2/model/SortCriteria.h>
#include <aws/inspector2/model/SortField.h>
#include <aws/inspector2/model/SortOrder.h>
#include <aws/inspector2/model/StartCisSessionMessage.h>
#include <aws/inspector2/model/StartCisSessionRequest.h>
#include <aws/inspector2/model/StartCisSessionResult.h>
#include <aws/inspector2/model/StartCodeSecurityScanRequest.h>
#include <aws/inspector2/model/StartCodeSecurityScanResult.h>
#include <aws/inspector2/model/State.h>
#include <aws/inspector2/model/Status.h>
#include <aws/inspector2/model/StatusCounts.h>
#include <aws/inspector2/model/Step.h>
#include <aws/inspector2/model/StopCisMessageProgress.h>
#include <aws/inspector2/model/StopCisSessionMessage.h>
#include <aws/inspector2/model/StopCisSessionRequest.h>
#include <aws/inspector2/model/StopCisSessionResult.h>
#include <aws/inspector2/model/StopCisSessionStatus.h>
#include <aws/inspector2/model/StringComparison.h>
#include <aws/inspector2/model/StringFilter.h>
#include <aws/inspector2/model/SuccessfulAssociationResult.h>
#include <aws/inspector2/model/SuggestedFix.h>
#include <aws/inspector2/model/TagComparison.h>
#include <aws/inspector2/model/TagFilter.h>
#include <aws/inspector2/model/TagResourceRequest.h>
#include <aws/inspector2/model/TagResourceResult.h>
#include <aws/inspector2/model/ThrottlingException.h>
#include <aws/inspector2/model/Time.h>
#include <aws/inspector2/model/TitleAggregation.h>
#include <aws/inspector2/model/TitleAggregationResponse.h>
#include <aws/inspector2/model/TitleSortBy.h>
#include <aws/inspector2/model/UntagResourceRequest.h>
#include <aws/inspector2/model/UntagResourceResult.h>
#include <aws/inspector2/model/UpdateCisScanConfigurationRequest.h>
#include <aws/inspector2/model/UpdateCisScanConfigurationResult.h>
#include <aws/inspector2/model/UpdateCisTargets.h>
#include <aws/inspector2/model/UpdateCodeSecurityIntegrationRequest.h>
#include <aws/inspector2/model/UpdateCodeSecurityIntegrationResult.h>
#include <aws/inspector2/model/UpdateCodeSecurityScanConfigurationRequest.h>
#include <aws/inspector2/model/UpdateCodeSecurityScanConfigurationResult.h>
#include <aws/inspector2/model/UpdateConfigurationRequest.h>
#include <aws/inspector2/model/UpdateConfigurationResult.h>
#include <aws/inspector2/model/UpdateEc2DeepInspectionConfigurationRequest.h>
#include <aws/inspector2/model/UpdateEc2DeepInspectionConfigurationResult.h>
#include <aws/inspector2/model/UpdateEncryptionKeyRequest.h>
#include <aws/inspector2/model/UpdateEncryptionKeyResult.h>
#include <aws/inspector2/model/UpdateFilterRequest.h>
#include <aws/inspector2/model/UpdateFilterResult.h>
#include <aws/inspector2/model/UpdateGitHubIntegrationDetail.h>
#include <aws/inspector2/model/UpdateGitLabSelfManagedIntegrationDetail.h>
#include <aws/inspector2/model/UpdateIntegrationDetails.h>
#include <aws/inspector2/model/UpdateOrgEc2DeepInspectionConfigurationRequest.h>
#include <aws/inspector2/model/UpdateOrgEc2DeepInspectionConfigurationResult.h>
#include <aws/inspector2/model/UpdateOrganizationConfigurationRequest.h>
#include <aws/inspector2/model/UpdateOrganizationConfigurationResult.h>
#include <aws/inspector2/model/Usage.h>
#include <aws/inspector2/model/UsageTotal.h>
#include <aws/inspector2/model/UsageType.h>
#include <aws/inspector2/model/ValidationException.h>
#include <aws/inspector2/model/ValidationExceptionField.h>
#include <aws/inspector2/model/ValidationExceptionReason.h>
#include <aws/inspector2/model/Vulnerability.h>
#include <aws/inspector2/model/VulnerabilitySource.h>
#include <aws/inspector2/model/VulnerablePackage.h>
#include <aws/inspector2/model/WeeklySchedule.h>

using Inspector2IncludeTest = ::testing::Test;

TEST_F(Inspector2IncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::Inspector2::Inspector2Client>("Inspector2IncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
