/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/iot/IoTClient.h>
#include <aws/iot/IoTEndpointProvider.h>
#include <aws/iot/IoTEndpointRules.h>
#include <aws/iot/IoTErrorMarshaller.h>
#include <aws/iot/IoTErrors.h>
#include <aws/iot/IoTRequest.h>
#include <aws/iot/IoTServiceClientModel.h>
#include <aws/iot/IoT_EXPORTS.h>
#include <aws/iot/model/AbortAction.h>
#include <aws/iot/model/AbortConfig.h>
#include <aws/iot/model/AbortCriteria.h>
#include <aws/iot/model/AcceptCertificateTransferRequest.h>
#include <aws/iot/model/Action.h>
#include <aws/iot/model/ActionType.h>
#include <aws/iot/model/ActiveViolation.h>
#include <aws/iot/model/AddThingToBillingGroupRequest.h>
#include <aws/iot/model/AddThingToBillingGroupResult.h>
#include <aws/iot/model/AddThingToThingGroupRequest.h>
#include <aws/iot/model/AddThingToThingGroupResult.h>
#include <aws/iot/model/AddThingsToThingGroupParams.h>
#include <aws/iot/model/AggregationType.h>
#include <aws/iot/model/AggregationTypeName.h>
#include <aws/iot/model/AlertTarget.h>
#include <aws/iot/model/AlertTargetType.h>
#include <aws/iot/model/Allowed.h>
#include <aws/iot/model/ApplicationProtocol.h>
#include <aws/iot/model/AssetPropertyTimestamp.h>
#include <aws/iot/model/AssetPropertyValue.h>
#include <aws/iot/model/AssetPropertyVariant.h>
#include <aws/iot/model/AssociateSbomWithPackageVersionRequest.h>
#include <aws/iot/model/AssociateSbomWithPackageVersionResult.h>
#include <aws/iot/model/AssociateTargetsWithJobRequest.h>
#include <aws/iot/model/AssociateTargetsWithJobResult.h>
#include <aws/iot/model/AttachPolicyRequest.h>
#include <aws/iot/model/AttachSecurityProfileRequest.h>
#include <aws/iot/model/AttachSecurityProfileResult.h>
#include <aws/iot/model/AttachThingPrincipalRequest.h>
#include <aws/iot/model/AttachThingPrincipalResult.h>
#include <aws/iot/model/AttributePayload.h>
#include <aws/iot/model/AuditCheckConfiguration.h>
#include <aws/iot/model/AuditCheckDetails.h>
#include <aws/iot/model/AuditCheckRunStatus.h>
#include <aws/iot/model/AuditFinding.h>
#include <aws/iot/model/AuditFindingSeverity.h>
#include <aws/iot/model/AuditFrequency.h>
#include <aws/iot/model/AuditMitigationActionExecutionMetadata.h>
#include <aws/iot/model/AuditMitigationActionsExecutionStatus.h>
#include <aws/iot/model/AuditMitigationActionsTaskMetadata.h>
#include <aws/iot/model/AuditMitigationActionsTaskStatus.h>
#include <aws/iot/model/AuditMitigationActionsTaskTarget.h>
#include <aws/iot/model/AuditNotificationTarget.h>
#include <aws/iot/model/AuditNotificationType.h>
#include <aws/iot/model/AuditSuppression.h>
#include <aws/iot/model/AuditTaskMetadata.h>
#include <aws/iot/model/AuditTaskStatus.h>
#include <aws/iot/model/AuditTaskType.h>
#include <aws/iot/model/AuthDecision.h>
#include <aws/iot/model/AuthInfo.h>
#include <aws/iot/model/AuthResult.h>
#include <aws/iot/model/AuthenticationType.h>
#include <aws/iot/model/AuthorizerConfig.h>
#include <aws/iot/model/AuthorizerDescription.h>
#include <aws/iot/model/AuthorizerStatus.h>
#include <aws/iot/model/AuthorizerSummary.h>
#include <aws/iot/model/AutoRegistrationStatus.h>
#include <aws/iot/model/AwsJobAbortConfig.h>
#include <aws/iot/model/AwsJobAbortCriteria.h>
#include <aws/iot/model/AwsJobAbortCriteriaAbortAction.h>
#include <aws/iot/model/AwsJobAbortCriteriaFailureType.h>
#include <aws/iot/model/AwsJobExecutionsRolloutConfig.h>
#include <aws/iot/model/AwsJobExponentialRolloutRate.h>
#include <aws/iot/model/AwsJobPresignedUrlConfig.h>
#include <aws/iot/model/AwsJobRateIncreaseCriteria.h>
#include <aws/iot/model/AwsJobTimeoutConfig.h>
#include <aws/iot/model/Behavior.h>
#include <aws/iot/model/BehaviorCriteria.h>
#include <aws/iot/model/BehaviorCriteriaType.h>
#include <aws/iot/model/BehaviorModelTrainingSummary.h>
#include <aws/iot/model/BillingGroupMetadata.h>
#include <aws/iot/model/BillingGroupProperties.h>
#include <aws/iot/model/Bucket.h>
#include <aws/iot/model/BucketsAggregationType.h>
#include <aws/iot/model/CACertificate.h>
#include <aws/iot/model/CACertificateDescription.h>
#include <aws/iot/model/CACertificateStatus.h>
#include <aws/iot/model/CACertificateUpdateAction.h>
#include <aws/iot/model/CancelAuditMitigationActionsTaskRequest.h>
#include <aws/iot/model/CancelAuditMitigationActionsTaskResult.h>
#include <aws/iot/model/CancelAuditTaskRequest.h>
#include <aws/iot/model/CancelAuditTaskResult.h>
#include <aws/iot/model/CancelCertificateTransferRequest.h>
#include <aws/iot/model/CancelDetectMitigationActionsTaskRequest.h>
#include <aws/iot/model/CancelDetectMitigationActionsTaskResult.h>
#include <aws/iot/model/CancelJobExecutionRequest.h>
#include <aws/iot/model/CancelJobRequest.h>
#include <aws/iot/model/CancelJobResult.h>
#include <aws/iot/model/CannedAccessControlList.h>
#include <aws/iot/model/Certificate.h>
#include <aws/iot/model/CertificateDescription.h>
#include <aws/iot/model/CertificateMode.h>
#include <aws/iot/model/CertificateProviderOperation.h>
#include <aws/iot/model/CertificateProviderSummary.h>
#include <aws/iot/model/CertificateStatus.h>
#include <aws/iot/model/CertificateValidity.h>
#include <aws/iot/model/ClearDefaultAuthorizerRequest.h>
#include <aws/iot/model/ClearDefaultAuthorizerResult.h>
#include <aws/iot/model/ClientCertificateConfig.h>
#include <aws/iot/model/CloudwatchAlarmAction.h>
#include <aws/iot/model/CloudwatchLogsAction.h>
#include <aws/iot/model/CloudwatchMetricAction.h>
#include <aws/iot/model/CodeSigning.h>
#include <aws/iot/model/CodeSigningCertificateChain.h>
#include <aws/iot/model/CodeSigningSignature.h>
#include <aws/iot/model/CommandExecutionResult.h>
#include <aws/iot/model/CommandExecutionStatus.h>
#include <aws/iot/model/CommandExecutionSummary.h>
#include <aws/iot/model/CommandNamespace.h>
#include <aws/iot/model/CommandParameter.h>
#include <aws/iot/model/CommandParameterValue.h>
#include <aws/iot/model/CommandPayload.h>
#include <aws/iot/model/CommandSummary.h>
#include <aws/iot/model/ComparisonOperator.h>
#include <aws/iot/model/ConfidenceLevel.h>
#include <aws/iot/model/ConfigName.h>
#include <aws/iot/model/Configuration.h>
#include <aws/iot/model/ConfirmTopicRuleDestinationRequest.h>
#include <aws/iot/model/ConfirmTopicRuleDestinationResult.h>
#include <aws/iot/model/ConflictException.h>
#include <aws/iot/model/CreateAuditSuppressionRequest.h>
#include <aws/iot/model/CreateAuditSuppressionResult.h>
#include <aws/iot/model/CreateAuthorizerRequest.h>
#include <aws/iot/model/CreateAuthorizerResult.h>
#include <aws/iot/model/CreateBillingGroupRequest.h>
#include <aws/iot/model/CreateBillingGroupResult.h>
#include <aws/iot/model/CreateCertificateFromCsrRequest.h>
#include <aws/iot/model/CreateCertificateFromCsrResult.h>
#include <aws/iot/model/CreateCertificateProviderRequest.h>
#include <aws/iot/model/CreateCertificateProviderResult.h>
#include <aws/iot/model/CreateCommandRequest.h>
#include <aws/iot/model/CreateCommandResult.h>
#include <aws/iot/model/CreateCustomMetricRequest.h>
#include <aws/iot/model/CreateCustomMetricResult.h>
#include <aws/iot/model/CreateDimensionRequest.h>
#include <aws/iot/model/CreateDimensionResult.h>
#include <aws/iot/model/CreateDomainConfigurationRequest.h>
#include <aws/iot/model/CreateDomainConfigurationResult.h>
#include <aws/iot/model/CreateDynamicThingGroupRequest.h>
#include <aws/iot/model/CreateDynamicThingGroupResult.h>
#include <aws/iot/model/CreateFleetMetricRequest.h>
#include <aws/iot/model/CreateFleetMetricResult.h>
#include <aws/iot/model/CreateJobRequest.h>
#include <aws/iot/model/CreateJobResult.h>
#include <aws/iot/model/CreateJobTemplateRequest.h>
#include <aws/iot/model/CreateJobTemplateResult.h>
#include <aws/iot/model/CreateKeysAndCertificateRequest.h>
#include <aws/iot/model/CreateKeysAndCertificateResult.h>
#include <aws/iot/model/CreateMitigationActionRequest.h>
#include <aws/iot/model/CreateMitigationActionResult.h>
#include <aws/iot/model/CreateOTAUpdateRequest.h>
#include <aws/iot/model/CreateOTAUpdateResult.h>
#include <aws/iot/model/CreatePackageRequest.h>
#include <aws/iot/model/CreatePackageResult.h>
#include <aws/iot/model/CreatePackageVersionRequest.h>
#include <aws/iot/model/CreatePackageVersionResult.h>
#include <aws/iot/model/CreatePolicyRequest.h>
#include <aws/iot/model/CreatePolicyResult.h>
#include <aws/iot/model/CreatePolicyVersionRequest.h>
#include <aws/iot/model/CreatePolicyVersionResult.h>
#include <aws/iot/model/CreateProvisioningClaimRequest.h>
#include <aws/iot/model/CreateProvisioningClaimResult.h>
#include <aws/iot/model/CreateProvisioningTemplateRequest.h>
#include <aws/iot/model/CreateProvisioningTemplateResult.h>
#include <aws/iot/model/CreateProvisioningTemplateVersionRequest.h>
#include <aws/iot/model/CreateProvisioningTemplateVersionResult.h>
#include <aws/iot/model/CreateRoleAliasRequest.h>
#include <aws/iot/model/CreateRoleAliasResult.h>
#include <aws/iot/model/CreateScheduledAuditRequest.h>
#include <aws/iot/model/CreateScheduledAuditResult.h>
#include <aws/iot/model/CreateSecurityProfileRequest.h>
#include <aws/iot/model/CreateSecurityProfileResult.h>
#include <aws/iot/model/CreateStreamRequest.h>
#include <aws/iot/model/CreateStreamResult.h>
#include <aws/iot/model/CreateThingGroupRequest.h>
#include <aws/iot/model/CreateThingGroupResult.h>
#include <aws/iot/model/CreateThingRequest.h>
#include <aws/iot/model/CreateThingResult.h>
#include <aws/iot/model/CreateThingTypeRequest.h>
#include <aws/iot/model/CreateThingTypeResult.h>
#include <aws/iot/model/CreateTopicRuleDestinationRequest.h>
#include <aws/iot/model/CreateTopicRuleDestinationResult.h>
#include <aws/iot/model/CreateTopicRuleRequest.h>
#include <aws/iot/model/CustomCodeSigning.h>
#include <aws/iot/model/CustomMetricType.h>
#include <aws/iot/model/DayOfWeek.h>
#include <aws/iot/model/DeleteAccountAuditConfigurationRequest.h>
#include <aws/iot/model/DeleteAccountAuditConfigurationResult.h>
#include <aws/iot/model/DeleteAuditSuppressionRequest.h>
#include <aws/iot/model/DeleteAuditSuppressionResult.h>
#include <aws/iot/model/DeleteAuthorizerRequest.h>
#include <aws/iot/model/DeleteAuthorizerResult.h>
#include <aws/iot/model/DeleteBillingGroupRequest.h>
#include <aws/iot/model/DeleteBillingGroupResult.h>
#include <aws/iot/model/DeleteCACertificateRequest.h>
#include <aws/iot/model/DeleteCACertificateResult.h>
#include <aws/iot/model/DeleteCertificateProviderRequest.h>
#include <aws/iot/model/DeleteCertificateProviderResult.h>
#include <aws/iot/model/DeleteCertificateRequest.h>
#include <aws/iot/model/DeleteCommandExecutionRequest.h>
#include <aws/iot/model/DeleteCommandExecutionResult.h>
#include <aws/iot/model/DeleteCommandRequest.h>
#include <aws/iot/model/DeleteCommandResult.h>
#include <aws/iot/model/DeleteCustomMetricRequest.h>
#include <aws/iot/model/DeleteCustomMetricResult.h>
#include <aws/iot/model/DeleteDimensionRequest.h>
#include <aws/iot/model/DeleteDimensionResult.h>
#include <aws/iot/model/DeleteDomainConfigurationRequest.h>
#include <aws/iot/model/DeleteDomainConfigurationResult.h>
#include <aws/iot/model/DeleteDynamicThingGroupRequest.h>
#include <aws/iot/model/DeleteDynamicThingGroupResult.h>
#include <aws/iot/model/DeleteFleetMetricRequest.h>
#include <aws/iot/model/DeleteJobExecutionRequest.h>
#include <aws/iot/model/DeleteJobRequest.h>
#include <aws/iot/model/DeleteJobTemplateRequest.h>
#include <aws/iot/model/DeleteMitigationActionRequest.h>
#include <aws/iot/model/DeleteMitigationActionResult.h>
#include <aws/iot/model/DeleteOTAUpdateRequest.h>
#include <aws/iot/model/DeleteOTAUpdateResult.h>
#include <aws/iot/model/DeletePackageRequest.h>
#include <aws/iot/model/DeletePackageResult.h>
#include <aws/iot/model/DeletePackageVersionRequest.h>
#include <aws/iot/model/DeletePackageVersionResult.h>
#include <aws/iot/model/DeletePolicyRequest.h>
#include <aws/iot/model/DeletePolicyVersionRequest.h>
#include <aws/iot/model/DeleteProvisioningTemplateRequest.h>
#include <aws/iot/model/DeleteProvisioningTemplateResult.h>
#include <aws/iot/model/DeleteProvisioningTemplateVersionRequest.h>
#include <aws/iot/model/DeleteProvisioningTemplateVersionResult.h>
#include <aws/iot/model/DeleteRegistrationCodeRequest.h>
#include <aws/iot/model/DeleteRegistrationCodeResult.h>
#include <aws/iot/model/DeleteRoleAliasRequest.h>
#include <aws/iot/model/DeleteRoleAliasResult.h>
#include <aws/iot/model/DeleteScheduledAuditRequest.h>
#include <aws/iot/model/DeleteScheduledAuditResult.h>
#include <aws/iot/model/DeleteSecurityProfileRequest.h>
#include <aws/iot/model/DeleteSecurityProfileResult.h>
#include <aws/iot/model/DeleteStreamRequest.h>
#include <aws/iot/model/DeleteStreamResult.h>
#include <aws/iot/model/DeleteThingGroupRequest.h>
#include <aws/iot/model/DeleteThingGroupResult.h>
#include <aws/iot/model/DeleteThingRequest.h>
#include <aws/iot/model/DeleteThingResult.h>
#include <aws/iot/model/DeleteThingTypeRequest.h>
#include <aws/iot/model/DeleteThingTypeResult.h>
#include <aws/iot/model/DeleteTopicRuleDestinationRequest.h>
#include <aws/iot/model/DeleteTopicRuleDestinationResult.h>
#include <aws/iot/model/DeleteTopicRuleRequest.h>
#include <aws/iot/model/DeleteV2LoggingLevelRequest.h>
#include <aws/iot/model/Denied.h>
#include <aws/iot/model/DeprecateThingTypeRequest.h>
#include <aws/iot/model/DeprecateThingTypeResult.h>
#include <aws/iot/model/DescribeAccountAuditConfigurationRequest.h>
#include <aws/iot/model/DescribeAccountAuditConfigurationResult.h>
#include <aws/iot/model/DescribeAuditFindingRequest.h>
#include <aws/iot/model/DescribeAuditFindingResult.h>
#include <aws/iot/model/DescribeAuditMitigationActionsTaskRequest.h>
#include <aws/iot/model/DescribeAuditMitigationActionsTaskResult.h>
#include <aws/iot/model/DescribeAuditSuppressionRequest.h>
#include <aws/iot/model/DescribeAuditSuppressionResult.h>
#include <aws/iot/model/DescribeAuditTaskRequest.h>
#include <aws/iot/model/DescribeAuditTaskResult.h>
#include <aws/iot/model/DescribeAuthorizerRequest.h>
#include <aws/iot/model/DescribeAuthorizerResult.h>
#include <aws/iot/model/DescribeBillingGroupRequest.h>
#include <aws/iot/model/DescribeBillingGroupResult.h>
#include <aws/iot/model/DescribeCACertificateRequest.h>
#include <aws/iot/model/DescribeCACertificateResult.h>
#include <aws/iot/model/DescribeCertificateProviderRequest.h>
#include <aws/iot/model/DescribeCertificateProviderResult.h>
#include <aws/iot/model/DescribeCertificateRequest.h>
#include <aws/iot/model/DescribeCertificateResult.h>
#include <aws/iot/model/DescribeCustomMetricRequest.h>
#include <aws/iot/model/DescribeCustomMetricResult.h>
#include <aws/iot/model/DescribeDefaultAuthorizerRequest.h>
#include <aws/iot/model/DescribeDefaultAuthorizerResult.h>
#include <aws/iot/model/DescribeDetectMitigationActionsTaskRequest.h>
#include <aws/iot/model/DescribeDetectMitigationActionsTaskResult.h>
#include <aws/iot/model/DescribeDimensionRequest.h>
#include <aws/iot/model/DescribeDimensionResult.h>
#include <aws/iot/model/DescribeDomainConfigurationRequest.h>
#include <aws/iot/model/DescribeDomainConfigurationResult.h>
#include <aws/iot/model/DescribeEndpointRequest.h>
#include <aws/iot/model/DescribeEndpointResult.h>
#include <aws/iot/model/DescribeEventConfigurationsRequest.h>
#include <aws/iot/model/DescribeEventConfigurationsResult.h>
#include <aws/iot/model/DescribeFleetMetricRequest.h>
#include <aws/iot/model/DescribeFleetMetricResult.h>
#include <aws/iot/model/DescribeIndexRequest.h>
#include <aws/iot/model/DescribeIndexResult.h>
#include <aws/iot/model/DescribeJobExecutionRequest.h>
#include <aws/iot/model/DescribeJobExecutionResult.h>
#include <aws/iot/model/DescribeJobRequest.h>
#include <aws/iot/model/DescribeJobResult.h>
#include <aws/iot/model/DescribeJobTemplateRequest.h>
#include <aws/iot/model/DescribeJobTemplateResult.h>
#include <aws/iot/model/DescribeManagedJobTemplateRequest.h>
#include <aws/iot/model/DescribeManagedJobTemplateResult.h>
#include <aws/iot/model/DescribeMitigationActionRequest.h>
#include <aws/iot/model/DescribeMitigationActionResult.h>
#include <aws/iot/model/DescribeProvisioningTemplateRequest.h>
#include <aws/iot/model/DescribeProvisioningTemplateResult.h>
#include <aws/iot/model/DescribeProvisioningTemplateVersionRequest.h>
#include <aws/iot/model/DescribeProvisioningTemplateVersionResult.h>
#include <aws/iot/model/DescribeRoleAliasRequest.h>
#include <aws/iot/model/DescribeRoleAliasResult.h>
#include <aws/iot/model/DescribeScheduledAuditRequest.h>
#include <aws/iot/model/DescribeScheduledAuditResult.h>
#include <aws/iot/model/DescribeSecurityProfileRequest.h>
#include <aws/iot/model/DescribeSecurityProfileResult.h>
#include <aws/iot/model/DescribeStreamRequest.h>
#include <aws/iot/model/DescribeStreamResult.h>
#include <aws/iot/model/DescribeThingGroupRequest.h>
#include <aws/iot/model/DescribeThingGroupResult.h>
#include <aws/iot/model/DescribeThingRegistrationTaskRequest.h>
#include <aws/iot/model/DescribeThingRegistrationTaskResult.h>
#include <aws/iot/model/DescribeThingRequest.h>
#include <aws/iot/model/DescribeThingResult.h>
#include <aws/iot/model/DescribeThingTypeRequest.h>
#include <aws/iot/model/DescribeThingTypeResult.h>
#include <aws/iot/model/Destination.h>
#include <aws/iot/model/DetachPolicyRequest.h>
#include <aws/iot/model/DetachSecurityProfileRequest.h>
#include <aws/iot/model/DetachSecurityProfileResult.h>
#include <aws/iot/model/DetachThingPrincipalRequest.h>
#include <aws/iot/model/DetachThingPrincipalResult.h>
#include <aws/iot/model/DetectMitigationActionExecution.h>
#include <aws/iot/model/DetectMitigationActionExecutionStatus.h>
#include <aws/iot/model/DetectMitigationActionsTaskStatistics.h>
#include <aws/iot/model/DetectMitigationActionsTaskStatus.h>
#include <aws/iot/model/DetectMitigationActionsTaskSummary.h>
#include <aws/iot/model/DetectMitigationActionsTaskTarget.h>
#include <aws/iot/model/DeviceCertificateUpdateAction.h>
#include <aws/iot/model/DeviceDefenderIndexingMode.h>
#include <aws/iot/model/DimensionType.h>
#include <aws/iot/model/DimensionValueOperator.h>
#include <aws/iot/model/DisableTopicRuleRequest.h>
#include <aws/iot/model/DisassociateSbomFromPackageVersionRequest.h>
#include <aws/iot/model/DisassociateSbomFromPackageVersionResult.h>
#include <aws/iot/model/DisconnectReasonValue.h>
#include <aws/iot/model/DocumentParameter.h>
#include <aws/iot/model/DomainConfigurationStatus.h>
#include <aws/iot/model/DomainConfigurationSummary.h>
#include <aws/iot/model/DomainType.h>
#include <aws/iot/model/DynamicGroupStatus.h>
#include <aws/iot/model/DynamoDBAction.h>
#include <aws/iot/model/DynamoDBv2Action.h>
#include <aws/iot/model/DynamoKeyType.h>
#include <aws/iot/model/EffectivePolicy.h>
#include <aws/iot/model/ElasticsearchAction.h>
#include <aws/iot/model/EnableIoTLoggingParams.h>
#include <aws/iot/model/EnableTopicRuleRequest.h>
#include <aws/iot/model/ErrorInfo.h>
#include <aws/iot/model/EventType.h>
#include <aws/iot/model/ExplicitDeny.h>
#include <aws/iot/model/ExponentialRolloutRate.h>
#include <aws/iot/model/Field.h>
#include <aws/iot/model/FieldType.h>
#include <aws/iot/model/FileLocation.h>
#include <aws/iot/model/FirehoseAction.h>
#include <aws/iot/model/FleetMetricNameAndArn.h>
#include <aws/iot/model/FleetMetricUnit.h>
#include <aws/iot/model/GeoLocationTarget.h>
#include <aws/iot/model/GetBehaviorModelTrainingSummariesRequest.h>
#include <aws/iot/model/GetBehaviorModelTrainingSummariesResult.h>
#include <aws/iot/model/GetBucketsAggregationRequest.h>
#include <aws/iot/model/GetBucketsAggregationResult.h>
#include <aws/iot/model/GetCardinalityRequest.h>
#include <aws/iot/model/GetCardinalityResult.h>
#include <aws/iot/model/GetCommandExecutionRequest.h>
#include <aws/iot/model/GetCommandExecutionResult.h>
#include <aws/iot/model/GetCommandRequest.h>
#include <aws/iot/model/GetCommandResult.h>
#include <aws/iot/model/GetEffectivePoliciesRequest.h>
#include <aws/iot/model/GetEffectivePoliciesResult.h>
#include <aws/iot/model/GetIndexingConfigurationRequest.h>
#include <aws/iot/model/GetIndexingConfigurationResult.h>
#include <aws/iot/model/GetJobDocumentRequest.h>
#include <aws/iot/model/GetJobDocumentResult.h>
#include <aws/iot/model/GetLoggingOptionsRequest.h>
#include <aws/iot/model/GetLoggingOptionsResult.h>
#include <aws/iot/model/GetOTAUpdateRequest.h>
#include <aws/iot/model/GetOTAUpdateResult.h>
#include <aws/iot/model/GetPackageConfigurationRequest.h>
#include <aws/iot/model/GetPackageConfigurationResult.h>
#include <aws/iot/model/GetPackageRequest.h>
#include <aws/iot/model/GetPackageResult.h>
#include <aws/iot/model/GetPackageVersionRequest.h>
#include <aws/iot/model/GetPackageVersionResult.h>
#include <aws/iot/model/GetPercentilesRequest.h>
#include <aws/iot/model/GetPercentilesResult.h>
#include <aws/iot/model/GetPolicyRequest.h>
#include <aws/iot/model/GetPolicyResult.h>
#include <aws/iot/model/GetPolicyVersionRequest.h>
#include <aws/iot/model/GetPolicyVersionResult.h>
#include <aws/iot/model/GetRegistrationCodeRequest.h>
#include <aws/iot/model/GetRegistrationCodeResult.h>
#include <aws/iot/model/GetStatisticsRequest.h>
#include <aws/iot/model/GetStatisticsResult.h>
#include <aws/iot/model/GetThingConnectivityDataRequest.h>
#include <aws/iot/model/GetThingConnectivityDataResult.h>
#include <aws/iot/model/GetTopicRuleDestinationRequest.h>
#include <aws/iot/model/GetTopicRuleDestinationResult.h>
#include <aws/iot/model/GetTopicRuleRequest.h>
#include <aws/iot/model/GetTopicRuleResult.h>
#include <aws/iot/model/GetV2LoggingOptionsRequest.h>
#include <aws/iot/model/GetV2LoggingOptionsResult.h>
#include <aws/iot/model/GroupNameAndArn.h>
#include <aws/iot/model/HttpAction.h>
#include <aws/iot/model/HttpActionHeader.h>
#include <aws/iot/model/HttpAuthorization.h>
#include <aws/iot/model/HttpContext.h>
#include <aws/iot/model/HttpUrlDestinationConfiguration.h>
#include <aws/iot/model/HttpUrlDestinationProperties.h>
#include <aws/iot/model/HttpUrlDestinationSummary.h>
#include <aws/iot/model/ImplicitDeny.h>
#include <aws/iot/model/IndexStatus.h>
#include <aws/iot/model/IndexingFilter.h>
#include <aws/iot/model/IotAnalyticsAction.h>
#include <aws/iot/model/IotEventsAction.h>
#include <aws/iot/model/IotSiteWiseAction.h>
#include <aws/iot/model/IssuerCertificateIdentifier.h>
#include <aws/iot/model/Job.h>
#include <aws/iot/model/JobEndBehavior.h>
#include <aws/iot/model/JobExecution.h>
#include <aws/iot/model/JobExecutionFailureType.h>
#include <aws/iot/model/JobExecutionStatus.h>
#include <aws/iot/model/JobExecutionStatusDetails.h>
#include <aws/iot/model/JobExecutionSummary.h>
#include <aws/iot/model/JobExecutionSummaryForJob.h>
#include <aws/iot/model/JobExecutionSummaryForThing.h>
#include <aws/iot/model/JobExecutionsRetryConfig.h>
#include <aws/iot/model/JobExecutionsRolloutConfig.h>
#include <aws/iot/model/JobProcessDetails.h>
#include <aws/iot/model/JobStatus.h>
#include <aws/iot/model/JobSummary.h>
#include <aws/iot/model/JobTemplateSummary.h>
#include <aws/iot/model/KafkaAction.h>
#include <aws/iot/model/KafkaActionHeader.h>
#include <aws/iot/model/KeyPair.h>
#include <aws/iot/model/KinesisAction.h>
#include <aws/iot/model/LambdaAction.h>
#include <aws/iot/model/ListActiveViolationsRequest.h>
#include <aws/iot/model/ListActiveViolationsResult.h>
#include <aws/iot/model/ListAttachedPoliciesRequest.h>
#include <aws/iot/model/ListAttachedPoliciesResult.h>
#include <aws/iot/model/ListAuditFindingsRequest.h>
#include <aws/iot/model/ListAuditFindingsResult.h>
#include <aws/iot/model/ListAuditMitigationActionsExecutionsRequest.h>
#include <aws/iot/model/ListAuditMitigationActionsExecutionsResult.h>
#include <aws/iot/model/ListAuditMitigationActionsTasksRequest.h>
#include <aws/iot/model/ListAuditMitigationActionsTasksResult.h>
#include <aws/iot/model/ListAuditSuppressionsRequest.h>
#include <aws/iot/model/ListAuditSuppressionsResult.h>
#include <aws/iot/model/ListAuditTasksRequest.h>
#include <aws/iot/model/ListAuditTasksResult.h>
#include <aws/iot/model/ListAuthorizersRequest.h>
#include <aws/iot/model/ListAuthorizersResult.h>
#include <aws/iot/model/ListBillingGroupsRequest.h>
#include <aws/iot/model/ListBillingGroupsResult.h>
#include <aws/iot/model/ListCACertificatesRequest.h>
#include <aws/iot/model/ListCACertificatesResult.h>
#include <aws/iot/model/ListCertificateProvidersRequest.h>
#include <aws/iot/model/ListCertificateProvidersResult.h>
#include <aws/iot/model/ListCertificatesByCARequest.h>
#include <aws/iot/model/ListCertificatesByCAResult.h>
#include <aws/iot/model/ListCertificatesRequest.h>
#include <aws/iot/model/ListCertificatesResult.h>
#include <aws/iot/model/ListCommandExecutionsRequest.h>
#include <aws/iot/model/ListCommandExecutionsResult.h>
#include <aws/iot/model/ListCommandsRequest.h>
#include <aws/iot/model/ListCommandsResult.h>
#include <aws/iot/model/ListCustomMetricsRequest.h>
#include <aws/iot/model/ListCustomMetricsResult.h>
#include <aws/iot/model/ListDetectMitigationActionsExecutionsRequest.h>
#include <aws/iot/model/ListDetectMitigationActionsExecutionsResult.h>
#include <aws/iot/model/ListDetectMitigationActionsTasksRequest.h>
#include <aws/iot/model/ListDetectMitigationActionsTasksResult.h>
#include <aws/iot/model/ListDimensionsRequest.h>
#include <aws/iot/model/ListDimensionsResult.h>
#include <aws/iot/model/ListDomainConfigurationsRequest.h>
#include <aws/iot/model/ListDomainConfigurationsResult.h>
#include <aws/iot/model/ListFleetMetricsRequest.h>
#include <aws/iot/model/ListFleetMetricsResult.h>
#include <aws/iot/model/ListIndicesRequest.h>
#include <aws/iot/model/ListIndicesResult.h>
#include <aws/iot/model/ListJobExecutionsForJobRequest.h>
#include <aws/iot/model/ListJobExecutionsForJobResult.h>
#include <aws/iot/model/ListJobExecutionsForThingRequest.h>
#include <aws/iot/model/ListJobExecutionsForThingResult.h>
#include <aws/iot/model/ListJobTemplatesRequest.h>
#include <aws/iot/model/ListJobTemplatesResult.h>
#include <aws/iot/model/ListJobsRequest.h>
#include <aws/iot/model/ListJobsResult.h>
#include <aws/iot/model/ListManagedJobTemplatesRequest.h>
#include <aws/iot/model/ListManagedJobTemplatesResult.h>
#include <aws/iot/model/ListMetricValuesRequest.h>
#include <aws/iot/model/ListMetricValuesResult.h>
#include <aws/iot/model/ListMitigationActionsRequest.h>
#include <aws/iot/model/ListMitigationActionsResult.h>
#include <aws/iot/model/ListOTAUpdatesRequest.h>
#include <aws/iot/model/ListOTAUpdatesResult.h>
#include <aws/iot/model/ListOutgoingCertificatesRequest.h>
#include <aws/iot/model/ListOutgoingCertificatesResult.h>
#include <aws/iot/model/ListPackageVersionsRequest.h>
#include <aws/iot/model/ListPackageVersionsResult.h>
#include <aws/iot/model/ListPackagesRequest.h>
#include <aws/iot/model/ListPackagesResult.h>
#include <aws/iot/model/ListPoliciesRequest.h>
#include <aws/iot/model/ListPoliciesResult.h>
#include <aws/iot/model/ListPolicyVersionsRequest.h>
#include <aws/iot/model/ListPolicyVersionsResult.h>
#include <aws/iot/model/ListPrincipalThingsRequest.h>
#include <aws/iot/model/ListPrincipalThingsResult.h>
#include <aws/iot/model/ListPrincipalThingsV2Request.h>
#include <aws/iot/model/ListPrincipalThingsV2Result.h>
#include <aws/iot/model/ListProvisioningTemplateVersionsRequest.h>
#include <aws/iot/model/ListProvisioningTemplateVersionsResult.h>
#include <aws/iot/model/ListProvisioningTemplatesRequest.h>
#include <aws/iot/model/ListProvisioningTemplatesResult.h>
#include <aws/iot/model/ListRelatedResourcesForAuditFindingRequest.h>
#include <aws/iot/model/ListRelatedResourcesForAuditFindingResult.h>
#include <aws/iot/model/ListRoleAliasesRequest.h>
#include <aws/iot/model/ListRoleAliasesResult.h>
#include <aws/iot/model/ListSbomValidationResultsRequest.h>
#include <aws/iot/model/ListSbomValidationResultsResult.h>
#include <aws/iot/model/ListScheduledAuditsRequest.h>
#include <aws/iot/model/ListScheduledAuditsResult.h>
#include <aws/iot/model/ListSecurityProfilesForTargetRequest.h>
#include <aws/iot/model/ListSecurityProfilesForTargetResult.h>
#include <aws/iot/model/ListSecurityProfilesRequest.h>
#include <aws/iot/model/ListSecurityProfilesResult.h>
#include <aws/iot/model/ListStreamsRequest.h>
#include <aws/iot/model/ListStreamsResult.h>
#include <aws/iot/model/ListTagsForResourceRequest.h>
#include <aws/iot/model/ListTagsForResourceResult.h>
#include <aws/iot/model/ListTargetsForPolicyRequest.h>
#include <aws/iot/model/ListTargetsForPolicyResult.h>
#include <aws/iot/model/ListTargetsForSecurityProfileRequest.h>
#include <aws/iot/model/ListTargetsForSecurityProfileResult.h>
#include <aws/iot/model/ListThingGroupsForThingRequest.h>
#include <aws/iot/model/ListThingGroupsForThingResult.h>
#include <aws/iot/model/ListThingGroupsRequest.h>
#include <aws/iot/model/ListThingGroupsResult.h>
#include <aws/iot/model/ListThingPrincipalsRequest.h>
#include <aws/iot/model/ListThingPrincipalsResult.h>
#include <aws/iot/model/ListThingPrincipalsV2Request.h>
#include <aws/iot/model/ListThingPrincipalsV2Result.h>
#include <aws/iot/model/ListThingRegistrationTaskReportsRequest.h>
#include <aws/iot/model/ListThingRegistrationTaskReportsResult.h>
#include <aws/iot/model/ListThingRegistrationTasksRequest.h>
#include <aws/iot/model/ListThingRegistrationTasksResult.h>
#include <aws/iot/model/ListThingTypesRequest.h>
#include <aws/iot/model/ListThingTypesResult.h>
#include <aws/iot/model/ListThingsInBillingGroupRequest.h>
#include <aws/iot/model/ListThingsInBillingGroupResult.h>
#include <aws/iot/model/ListThingsInThingGroupRequest.h>
#include <aws/iot/model/ListThingsInThingGroupResult.h>
#include <aws/iot/model/ListThingsRequest.h>
#include <aws/iot/model/ListThingsResult.h>
#include <aws/iot/model/ListTopicRuleDestinationsRequest.h>
#include <aws/iot/model/ListTopicRuleDestinationsResult.h>
#include <aws/iot/model/ListTopicRulesRequest.h>
#include <aws/iot/model/ListTopicRulesResult.h>
#include <aws/iot/model/ListV2LoggingLevelsRequest.h>
#include <aws/iot/model/ListV2LoggingLevelsResult.h>
#include <aws/iot/model/ListViolationEventsRequest.h>
#include <aws/iot/model/ListViolationEventsResult.h>
#include <aws/iot/model/LocationAction.h>
#include <aws/iot/model/LocationTimestamp.h>
#include <aws/iot/model/LogLevel.h>
#include <aws/iot/model/LogTarget.h>
#include <aws/iot/model/LogTargetConfiguration.h>
#include <aws/iot/model/LogTargetType.h>
#include <aws/iot/model/LoggingOptionsPayload.h>
#include <aws/iot/model/MachineLearningDetectionConfig.h>
#include <aws/iot/model/MaintenanceWindow.h>
#include <aws/iot/model/ManagedJobTemplateSummary.h>
#include <aws/iot/model/MessageFormat.h>
#include <aws/iot/model/MetricDatum.h>
#include <aws/iot/model/MetricDimension.h>
#include <aws/iot/model/MetricToRetain.h>
#include <aws/iot/model/MetricValue.h>
#include <aws/iot/model/MetricsExportConfig.h>
#include <aws/iot/model/MitigationAction.h>
#include <aws/iot/model/MitigationActionIdentifier.h>
#include <aws/iot/model/MitigationActionParams.h>
#include <aws/iot/model/MitigationActionType.h>
#include <aws/iot/model/ModelStatus.h>
#include <aws/iot/model/Mqtt5Configuration.h>
#include <aws/iot/model/MqttContext.h>
#include <aws/iot/model/MqttHeaders.h>
#include <aws/iot/model/NamedShadowIndexingMode.h>
#include <aws/iot/model/NonCompliantResource.h>
#include <aws/iot/model/OTAUpdateFile.h>
#include <aws/iot/model/OTAUpdateInfo.h>
#include <aws/iot/model/OTAUpdateStatus.h>
#include <aws/iot/model/OTAUpdateSummary.h>
#include <aws/iot/model/OpenSearchAction.h>
#include <aws/iot/model/OutgoingCertificate.h>
#include <aws/iot/model/PackageSummary.h>
#include <aws/iot/model/PackageVersionAction.h>
#include <aws/iot/model/PackageVersionArtifact.h>
#include <aws/iot/model/PackageVersionStatus.h>
#include <aws/iot/model/PackageVersionSummary.h>
#include <aws/iot/model/PercentPair.h>
#include <aws/iot/model/Policy.h>
#include <aws/iot/model/PolicyTemplateName.h>
#include <aws/iot/model/PolicyVersion.h>
#include <aws/iot/model/PolicyVersionIdentifier.h>
#include <aws/iot/model/PresignedUrlConfig.h>
#include <aws/iot/model/PrincipalThingObject.h>
#include <aws/iot/model/PropagatingAttribute.h>
#include <aws/iot/model/Protocol.h>
#include <aws/iot/model/ProvisioningHook.h>
#include <aws/iot/model/ProvisioningTemplateSummary.h>
#include <aws/iot/model/ProvisioningTemplateVersionSummary.h>
#include <aws/iot/model/PublishFindingToSnsParams.h>
#include <aws/iot/model/PutAssetPropertyValueEntry.h>
#include <aws/iot/model/PutItemInput.h>
#include <aws/iot/model/PutVerificationStateOnViolationRequest.h>
#include <aws/iot/model/PutVerificationStateOnViolationResult.h>
#include <aws/iot/model/RateIncreaseCriteria.h>
#include <aws/iot/model/RegisterCACertificateRequest.h>
#include <aws/iot/model/RegisterCACertificateResult.h>
#include <aws/iot/model/RegisterCertificateRequest.h>
#include <aws/iot/model/RegisterCertificateResult.h>
#include <aws/iot/model/RegisterCertificateWithoutCARequest.h>
#include <aws/iot/model/RegisterCertificateWithoutCAResult.h>
#include <aws/iot/model/RegisterThingRequest.h>
#include <aws/iot/model/RegisterThingResult.h>
#include <aws/iot/model/RegistrationConfig.h>
#include <aws/iot/model/RejectCertificateTransferRequest.h>
#include <aws/iot/model/RelatedResource.h>
#include <aws/iot/model/RemoveThingFromBillingGroupRequest.h>
#include <aws/iot/model/RemoveThingFromBillingGroupResult.h>
#include <aws/iot/model/RemoveThingFromThingGroupRequest.h>
#include <aws/iot/model/RemoveThingFromThingGroupResult.h>
#include <aws/iot/model/ReplaceDefaultPolicyVersionParams.h>
#include <aws/iot/model/ReplaceTopicRuleRequest.h>
#include <aws/iot/model/ReportType.h>
#include <aws/iot/model/RepublishAction.h>
#include <aws/iot/model/ResourceAlreadyExistsException.h>
#include <aws/iot/model/ResourceIdentifier.h>
#include <aws/iot/model/ResourceType.h>
#include <aws/iot/model/RetryCriteria.h>
#include <aws/iot/model/RetryableFailureType.h>
#include <aws/iot/model/RoleAliasDescription.h>
#include <aws/iot/model/S3Action.h>
#include <aws/iot/model/S3Destination.h>
#include <aws/iot/model/S3Location.h>
#include <aws/iot/model/SalesforceAction.h>
#include <aws/iot/model/Sbom.h>
#include <aws/iot/model/SbomValidationErrorCode.h>
#include <aws/iot/model/SbomValidationResult.h>
#include <aws/iot/model/SbomValidationResultSummary.h>
#include <aws/iot/model/SbomValidationStatus.h>
#include <aws/iot/model/ScheduledAuditMetadata.h>
#include <aws/iot/model/ScheduledJobRollout.h>
#include <aws/iot/model/SchedulingConfig.h>
#include <aws/iot/model/SearchIndexRequest.h>
#include <aws/iot/model/SearchIndexResult.h>
#include <aws/iot/model/SecurityProfileIdentifier.h>
#include <aws/iot/model/SecurityProfileTarget.h>
#include <aws/iot/model/SecurityProfileTargetMapping.h>
#include <aws/iot/model/ServerCertificateConfig.h>
#include <aws/iot/model/ServerCertificateStatus.h>
#include <aws/iot/model/ServerCertificateSummary.h>
#include <aws/iot/model/ServiceType.h>
#include <aws/iot/model/SetDefaultAuthorizerRequest.h>
#include <aws/iot/model/SetDefaultAuthorizerResult.h>
#include <aws/iot/model/SetDefaultPolicyVersionRequest.h>
#include <aws/iot/model/SetLoggingOptionsRequest.h>
#include <aws/iot/model/SetV2LoggingLevelRequest.h>
#include <aws/iot/model/SetV2LoggingOptionsRequest.h>
#include <aws/iot/model/SigV4Authorization.h>
#include <aws/iot/model/SigningProfileParameter.h>
#include <aws/iot/model/SnsAction.h>
#include <aws/iot/model/SortOrder.h>
#include <aws/iot/model/SqsAction.h>
#include <aws/iot/model/StartAuditMitigationActionsTaskRequest.h>
#include <aws/iot/model/StartAuditMitigationActionsTaskResult.h>
#include <aws/iot/model/StartDetectMitigationActionsTaskRequest.h>
#include <aws/iot/model/StartDetectMitigationActionsTaskResult.h>
#include <aws/iot/model/StartOnDemandAuditTaskRequest.h>
#include <aws/iot/model/StartOnDemandAuditTaskResult.h>
#include <aws/iot/model/StartSigningJobParameter.h>
#include <aws/iot/model/StartThingRegistrationTaskRequest.h>
#include <aws/iot/model/StartThingRegistrationTaskResult.h>
#include <aws/iot/model/StatisticalThreshold.h>
#include <aws/iot/model/Statistics.h>
#include <aws/iot/model/Status.h>
#include <aws/iot/model/StatusReason.h>
#include <aws/iot/model/StepFunctionsAction.h>
#include <aws/iot/model/StopThingRegistrationTaskRequest.h>
#include <aws/iot/model/StopThingRegistrationTaskResult.h>
#include <aws/iot/model/Stream.h>
#include <aws/iot/model/StreamFile.h>
#include <aws/iot/model/StreamInfo.h>
#include <aws/iot/model/StreamSummary.h>
#include <aws/iot/model/Tag.h>
#include <aws/iot/model/TagResourceRequest.h>
#include <aws/iot/model/TagResourceResult.h>
#include <aws/iot/model/TargetFieldOrder.h>
#include <aws/iot/model/TargetSelection.h>
#include <aws/iot/model/TaskStatistics.h>
#include <aws/iot/model/TaskStatisticsForAuditCheck.h>
#include <aws/iot/model/TemplateType.h>
#include <aws/iot/model/TermsAggregation.h>
#include <aws/iot/model/TestAuthorizationRequest.h>
#include <aws/iot/model/TestAuthorizationResult.h>
#include <aws/iot/model/TestInvokeAuthorizerRequest.h>
#include <aws/iot/model/TestInvokeAuthorizerResult.h>
#include <aws/iot/model/ThingAttribute.h>
#include <aws/iot/model/ThingConnectivity.h>
#include <aws/iot/model/ThingConnectivityIndexingMode.h>
#include <aws/iot/model/ThingDocument.h>
#include <aws/iot/model/ThingGroupDocument.h>
#include <aws/iot/model/ThingGroupIndexingConfiguration.h>
#include <aws/iot/model/ThingGroupIndexingMode.h>
#include <aws/iot/model/ThingGroupMetadata.h>
#include <aws/iot/model/ThingGroupProperties.h>
#include <aws/iot/model/ThingIndexingConfiguration.h>
#include <aws/iot/model/ThingIndexingMode.h>
#include <aws/iot/model/ThingPrincipalObject.h>
#include <aws/iot/model/ThingPrincipalType.h>
#include <aws/iot/model/ThingTypeDefinition.h>
#include <aws/iot/model/ThingTypeMetadata.h>
#include <aws/iot/model/ThingTypeProperties.h>
#include <aws/iot/model/TimeFilter.h>
#include <aws/iot/model/TimeoutConfig.h>
#include <aws/iot/model/TimestreamAction.h>
#include <aws/iot/model/TimestreamDimension.h>
#include <aws/iot/model/TimestreamTimestamp.h>
#include <aws/iot/model/TlsConfig.h>
#include <aws/iot/model/TlsContext.h>
#include <aws/iot/model/TopicRule.h>
#include <aws/iot/model/TopicRuleDestination.h>
#include <aws/iot/model/TopicRuleDestinationConfiguration.h>
#include <aws/iot/model/TopicRuleDestinationStatus.h>
#include <aws/iot/model/TopicRuleDestinationSummary.h>
#include <aws/iot/model/TopicRuleListItem.h>
#include <aws/iot/model/TopicRulePayload.h>
#include <aws/iot/model/TransferCertificateRequest.h>
#include <aws/iot/model/TransferCertificateResult.h>
#include <aws/iot/model/TransferData.h>
#include <aws/iot/model/UntagResourceRequest.h>
#include <aws/iot/model/UntagResourceResult.h>
#include <aws/iot/model/UpdateAccountAuditConfigurationRequest.h>
#include <aws/iot/model/UpdateAccountAuditConfigurationResult.h>
#include <aws/iot/model/UpdateAuditSuppressionRequest.h>
#include <aws/iot/model/UpdateAuditSuppressionResult.h>
#include <aws/iot/model/UpdateAuthorizerRequest.h>
#include <aws/iot/model/UpdateAuthorizerResult.h>
#include <aws/iot/model/UpdateBillingGroupRequest.h>
#include <aws/iot/model/UpdateBillingGroupResult.h>
#include <aws/iot/model/UpdateCACertificateParams.h>
#include <aws/iot/model/UpdateCACertificateRequest.h>
#include <aws/iot/model/UpdateCertificateProviderRequest.h>
#include <aws/iot/model/UpdateCertificateProviderResult.h>
#include <aws/iot/model/UpdateCertificateRequest.h>
#include <aws/iot/model/UpdateCommandRequest.h>
#include <aws/iot/model/UpdateCommandResult.h>
#include <aws/iot/model/UpdateCustomMetricRequest.h>
#include <aws/iot/model/UpdateCustomMetricResult.h>
#include <aws/iot/model/UpdateDeviceCertificateParams.h>
#include <aws/iot/model/UpdateDimensionRequest.h>
#include <aws/iot/model/UpdateDimensionResult.h>
#include <aws/iot/model/UpdateDomainConfigurationRequest.h>
#include <aws/iot/model/UpdateDomainConfigurationResult.h>
#include <aws/iot/model/UpdateDynamicThingGroupRequest.h>
#include <aws/iot/model/UpdateDynamicThingGroupResult.h>
#include <aws/iot/model/UpdateEventConfigurationsRequest.h>
#include <aws/iot/model/UpdateEventConfigurationsResult.h>
#include <aws/iot/model/UpdateFleetMetricRequest.h>
#include <aws/iot/model/UpdateIndexingConfigurationRequest.h>
#include <aws/iot/model/UpdateIndexingConfigurationResult.h>
#include <aws/iot/model/UpdateJobRequest.h>
#include <aws/iot/model/UpdateMitigationActionRequest.h>
#include <aws/iot/model/UpdateMitigationActionResult.h>
#include <aws/iot/model/UpdatePackageConfigurationRequest.h>
#include <aws/iot/model/UpdatePackageConfigurationResult.h>
#include <aws/iot/model/UpdatePackageRequest.h>
#include <aws/iot/model/UpdatePackageResult.h>
#include <aws/iot/model/UpdatePackageVersionRequest.h>
#include <aws/iot/model/UpdatePackageVersionResult.h>
#include <aws/iot/model/UpdateProvisioningTemplateRequest.h>
#include <aws/iot/model/UpdateProvisioningTemplateResult.h>
#include <aws/iot/model/UpdateRoleAliasRequest.h>
#include <aws/iot/model/UpdateRoleAliasResult.h>
#include <aws/iot/model/UpdateScheduledAuditRequest.h>
#include <aws/iot/model/UpdateScheduledAuditResult.h>
#include <aws/iot/model/UpdateSecurityProfileRequest.h>
#include <aws/iot/model/UpdateSecurityProfileResult.h>
#include <aws/iot/model/UpdateStreamRequest.h>
#include <aws/iot/model/UpdateStreamResult.h>
#include <aws/iot/model/UpdateThingGroupRequest.h>
#include <aws/iot/model/UpdateThingGroupResult.h>
#include <aws/iot/model/UpdateThingGroupsForThingRequest.h>
#include <aws/iot/model/UpdateThingGroupsForThingResult.h>
#include <aws/iot/model/UpdateThingRequest.h>
#include <aws/iot/model/UpdateThingResult.h>
#include <aws/iot/model/UpdateThingTypeRequest.h>
#include <aws/iot/model/UpdateThingTypeResult.h>
#include <aws/iot/model/UpdateTopicRuleDestinationRequest.h>
#include <aws/iot/model/UpdateTopicRuleDestinationResult.h>
#include <aws/iot/model/UserProperty.h>
#include <aws/iot/model/ValidateSecurityProfileBehaviorsRequest.h>
#include <aws/iot/model/ValidateSecurityProfileBehaviorsResult.h>
#include <aws/iot/model/ValidationError.h>
#include <aws/iot/model/VerificationState.h>
#include <aws/iot/model/VersionUpdateByJobsConfig.h>
#include <aws/iot/model/ViolationEvent.h>
#include <aws/iot/model/ViolationEventAdditionalInfo.h>
#include <aws/iot/model/ViolationEventOccurrenceRange.h>
#include <aws/iot/model/ViolationEventType.h>
#include <aws/iot/model/VpcDestinationConfiguration.h>
#include <aws/iot/model/VpcDestinationProperties.h>
#include <aws/iot/model/VpcDestinationSummary.h>

using IoTIncludeTest = ::testing::Test;

TEST_F(IoTIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::IoT::IoTClient>("IoTIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
