/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/iot-managed-integrations/IoTManagedIntegrationsClient.h>
#include <aws/iot-managed-integrations/IoTManagedIntegrationsEndpointProvider.h>
#include <aws/iot-managed-integrations/IoTManagedIntegrationsEndpointRules.h>
#include <aws/iot-managed-integrations/IoTManagedIntegrationsErrorMarshaller.h>
#include <aws/iot-managed-integrations/IoTManagedIntegrationsErrors.h>
#include <aws/iot-managed-integrations/IoTManagedIntegrationsRequest.h>
#include <aws/iot-managed-integrations/IoTManagedIntegrationsServiceClientModel.h>
#include <aws/iot-managed-integrations/IoTManagedIntegrations_EXPORTS.h>
#include <aws/iot-managed-integrations/model/AbortConfigCriteria.h>
#include <aws/iot-managed-integrations/model/AbortCriteriaAction.h>
#include <aws/iot-managed-integrations/model/AbortCriteriaFailureType.h>
#include <aws/iot-managed-integrations/model/AccountAssociationItem.h>
#include <aws/iot-managed-integrations/model/AssociationState.h>
#include <aws/iot-managed-integrations/model/AuthConfig.h>
#include <aws/iot-managed-integrations/model/AuthConfigUpdate.h>
#include <aws/iot-managed-integrations/model/AuthMaterialType.h>
#include <aws/iot-managed-integrations/model/AuthType.h>
#include <aws/iot-managed-integrations/model/CapabilityAction.h>
#include <aws/iot-managed-integrations/model/CapabilityReport.h>
#include <aws/iot-managed-integrations/model/CapabilityReportCapability.h>
#include <aws/iot-managed-integrations/model/CapabilityReportEndpoint.h>
#include <aws/iot-managed-integrations/model/CapabilitySchemaItem.h>
#include <aws/iot-managed-integrations/model/CloudConnectorType.h>
#include <aws/iot-managed-integrations/model/CommandCapability.h>
#include <aws/iot-managed-integrations/model/CommandEndpoint.h>
#include <aws/iot-managed-integrations/model/ConfigurationError.h>
#include <aws/iot-managed-integrations/model/ConfigurationState.h>
#include <aws/iot-managed-integrations/model/ConfigurationStatus.h>
#include <aws/iot-managed-integrations/model/ConnectorDestinationSummary.h>
#include <aws/iot-managed-integrations/model/ConnectorEventOperation.h>
#include <aws/iot-managed-integrations/model/ConnectorItem.h>
#include <aws/iot-managed-integrations/model/CreateAccountAssociationRequest.h>
#include <aws/iot-managed-integrations/model/CreateAccountAssociationResult.h>
#include <aws/iot-managed-integrations/model/CreateCloudConnectorRequest.h>
#include <aws/iot-managed-integrations/model/CreateCloudConnectorResult.h>
#include <aws/iot-managed-integrations/model/CreateConnectorDestinationRequest.h>
#include <aws/iot-managed-integrations/model/CreateConnectorDestinationResult.h>
#include <aws/iot-managed-integrations/model/CreateCredentialLockerRequest.h>
#include <aws/iot-managed-integrations/model/CreateCredentialLockerResult.h>
#include <aws/iot-managed-integrations/model/CreateDestinationRequest.h>
#include <aws/iot-managed-integrations/model/CreateDestinationResult.h>
#include <aws/iot-managed-integrations/model/CreateEventLogConfigurationRequest.h>
#include <aws/iot-managed-integrations/model/CreateEventLogConfigurationResult.h>
#include <aws/iot-managed-integrations/model/CreateManagedThingRequest.h>
#include <aws/iot-managed-integrations/model/CreateManagedThingResult.h>
#include <aws/iot-managed-integrations/model/CreateNotificationConfigurationRequest.h>
#include <aws/iot-managed-integrations/model/CreateNotificationConfigurationResult.h>
#include <aws/iot-managed-integrations/model/CreateOtaTaskConfigurationRequest.h>
#include <aws/iot-managed-integrations/model/CreateOtaTaskConfigurationResult.h>
#include <aws/iot-managed-integrations/model/CreateOtaTaskRequest.h>
#include <aws/iot-managed-integrations/model/CreateOtaTaskResult.h>
#include <aws/iot-managed-integrations/model/CreateProvisioningProfileRequest.h>
#include <aws/iot-managed-integrations/model/CreateProvisioningProfileResult.h>
#include <aws/iot-managed-integrations/model/CredentialLockerSummary.h>
#include <aws/iot-managed-integrations/model/DeleteAccountAssociationRequest.h>
#include <aws/iot-managed-integrations/model/DeleteCloudConnectorRequest.h>
#include <aws/iot-managed-integrations/model/DeleteConnectorDestinationRequest.h>
#include <aws/iot-managed-integrations/model/DeleteCredentialLockerRequest.h>
#include <aws/iot-managed-integrations/model/DeleteDestinationRequest.h>
#include <aws/iot-managed-integrations/model/DeleteEventLogConfigurationRequest.h>
#include <aws/iot-managed-integrations/model/DeleteManagedThingRequest.h>
#include <aws/iot-managed-integrations/model/DeleteNotificationConfigurationRequest.h>
#include <aws/iot-managed-integrations/model/DeleteOtaTaskConfigurationRequest.h>
#include <aws/iot-managed-integrations/model/DeleteOtaTaskRequest.h>
#include <aws/iot-managed-integrations/model/DeleteProvisioningProfileRequest.h>
#include <aws/iot-managed-integrations/model/DeliveryDestinationType.h>
#include <aws/iot-managed-integrations/model/DeregisterAccountAssociationRequest.h>
#include <aws/iot-managed-integrations/model/DestinationSummary.h>
#include <aws/iot-managed-integrations/model/Device.h>
#include <aws/iot-managed-integrations/model/DeviceDiscoveryStatus.h>
#include <aws/iot-managed-integrations/model/DeviceDiscoverySummary.h>
#include <aws/iot-managed-integrations/model/DisconnectReasonValue.h>
#include <aws/iot-managed-integrations/model/DiscoveredDeviceSummary.h>
#include <aws/iot-managed-integrations/model/DiscoveryAuthMaterialType.h>
#include <aws/iot-managed-integrations/model/DiscoveryModification.h>
#include <aws/iot-managed-integrations/model/DiscoveryType.h>
#include <aws/iot-managed-integrations/model/EncryptionType.h>
#include <aws/iot-managed-integrations/model/EndpointConfig.h>
#include <aws/iot-managed-integrations/model/EndpointType.h>
#include <aws/iot-managed-integrations/model/EventLogConfigurationSummary.h>
#include <aws/iot-managed-integrations/model/EventType.h>
#include <aws/iot-managed-integrations/model/ExponentialRolloutRate.h>
#include <aws/iot-managed-integrations/model/GetAccountAssociationRequest.h>
#include <aws/iot-managed-integrations/model/GetAccountAssociationResult.h>
#include <aws/iot-managed-integrations/model/GetCloudConnectorRequest.h>
#include <aws/iot-managed-integrations/model/GetCloudConnectorResult.h>
#include <aws/iot-managed-integrations/model/GetConnectorDestinationRequest.h>
#include <aws/iot-managed-integrations/model/GetConnectorDestinationResult.h>
#include <aws/iot-managed-integrations/model/GetCredentialLockerRequest.h>
#include <aws/iot-managed-integrations/model/GetCredentialLockerResult.h>
#include <aws/iot-managed-integrations/model/GetCustomEndpointRequest.h>
#include <aws/iot-managed-integrations/model/GetCustomEndpointResult.h>
#include <aws/iot-managed-integrations/model/GetDefaultEncryptionConfigurationRequest.h>
#include <aws/iot-managed-integrations/model/GetDefaultEncryptionConfigurationResult.h>
#include <aws/iot-managed-integrations/model/GetDestinationRequest.h>
#include <aws/iot-managed-integrations/model/GetDestinationResult.h>
#include <aws/iot-managed-integrations/model/GetDeviceDiscoveryRequest.h>
#include <aws/iot-managed-integrations/model/GetDeviceDiscoveryResult.h>
#include <aws/iot-managed-integrations/model/GetEventLogConfigurationRequest.h>
#include <aws/iot-managed-integrations/model/GetEventLogConfigurationResult.h>
#include <aws/iot-managed-integrations/model/GetHubConfigurationRequest.h>
#include <aws/iot-managed-integrations/model/GetHubConfigurationResult.h>
#include <aws/iot-managed-integrations/model/GetManagedThingCapabilitiesRequest.h>
#include <aws/iot-managed-integrations/model/GetManagedThingCapabilitiesResult.h>
#include <aws/iot-managed-integrations/model/GetManagedThingConnectivityDataRequest.h>
#include <aws/iot-managed-integrations/model/GetManagedThingConnectivityDataResult.h>
#include <aws/iot-managed-integrations/model/GetManagedThingMetaDataRequest.h>
#include <aws/iot-managed-integrations/model/GetManagedThingMetaDataResult.h>
#include <aws/iot-managed-integrations/model/GetManagedThingRequest.h>
#include <aws/iot-managed-integrations/model/GetManagedThingResult.h>
#include <aws/iot-managed-integrations/model/GetManagedThingStateRequest.h>
#include <aws/iot-managed-integrations/model/GetManagedThingStateResult.h>
#include <aws/iot-managed-integrations/model/GetNotificationConfigurationRequest.h>
#include <aws/iot-managed-integrations/model/GetNotificationConfigurationResult.h>
#include <aws/iot-managed-integrations/model/GetOtaTaskConfigurationRequest.h>
#include <aws/iot-managed-integrations/model/GetOtaTaskConfigurationResult.h>
#include <aws/iot-managed-integrations/model/GetOtaTaskRequest.h>
#include <aws/iot-managed-integrations/model/GetOtaTaskResult.h>
#include <aws/iot-managed-integrations/model/GetProvisioningProfileRequest.h>
#include <aws/iot-managed-integrations/model/GetProvisioningProfileResult.h>
#include <aws/iot-managed-integrations/model/GetRuntimeLogConfigurationRequest.h>
#include <aws/iot-managed-integrations/model/GetRuntimeLogConfigurationResult.h>
#include <aws/iot-managed-integrations/model/GetSchemaVersionRequest.h>
#include <aws/iot-managed-integrations/model/GetSchemaVersionResult.h>
#include <aws/iot-managed-integrations/model/HubNetworkMode.h>
#include <aws/iot-managed-integrations/model/LambdaConfig.h>
#include <aws/iot-managed-integrations/model/ListAccountAssociationsRequest.h>
#include <aws/iot-managed-integrations/model/ListAccountAssociationsResult.h>
#include <aws/iot-managed-integrations/model/ListCloudConnectorsRequest.h>
#include <aws/iot-managed-integrations/model/ListCloudConnectorsResult.h>
#include <aws/iot-managed-integrations/model/ListConnectorDestinationsRequest.h>
#include <aws/iot-managed-integrations/model/ListConnectorDestinationsResult.h>
#include <aws/iot-managed-integrations/model/ListCredentialLockersRequest.h>
#include <aws/iot-managed-integrations/model/ListCredentialLockersResult.h>
#include <aws/iot-managed-integrations/model/ListDestinationsRequest.h>
#include <aws/iot-managed-integrations/model/ListDestinationsResult.h>
#include <aws/iot-managed-integrations/model/ListDeviceDiscoveriesRequest.h>
#include <aws/iot-managed-integrations/model/ListDeviceDiscoveriesResult.h>
#include <aws/iot-managed-integrations/model/ListDiscoveredDevicesRequest.h>
#include <aws/iot-managed-integrations/model/ListDiscoveredDevicesResult.h>
#include <aws/iot-managed-integrations/model/ListEventLogConfigurationsRequest.h>
#include <aws/iot-managed-integrations/model/ListEventLogConfigurationsResult.h>
#include <aws/iot-managed-integrations/model/ListManagedThingAccountAssociationsRequest.h>
#include <aws/iot-managed-integrations/model/ListManagedThingAccountAssociationsResult.h>
#include <aws/iot-managed-integrations/model/ListManagedThingSchemasRequest.h>
#include <aws/iot-managed-integrations/model/ListManagedThingSchemasResult.h>
#include <aws/iot-managed-integrations/model/ListManagedThingsRequest.h>
#include <aws/iot-managed-integrations/model/ListManagedThingsResult.h>
#include <aws/iot-managed-integrations/model/ListNotificationConfigurationsRequest.h>
#include <aws/iot-managed-integrations/model/ListNotificationConfigurationsResult.h>
#include <aws/iot-managed-integrations/model/ListOtaTaskConfigurationsRequest.h>
#include <aws/iot-managed-integrations/model/ListOtaTaskConfigurationsResult.h>
#include <aws/iot-managed-integrations/model/ListOtaTaskExecutionsRequest.h>
#include <aws/iot-managed-integrations/model/ListOtaTaskExecutionsResult.h>
#include <aws/iot-managed-integrations/model/ListOtaTasksRequest.h>
#include <aws/iot-managed-integrations/model/ListOtaTasksResult.h>
#include <aws/iot-managed-integrations/model/ListProvisioningProfilesRequest.h>
#include <aws/iot-managed-integrations/model/ListProvisioningProfilesResult.h>
#include <aws/iot-managed-integrations/model/ListSchemaVersionsRequest.h>
#include <aws/iot-managed-integrations/model/ListSchemaVersionsResult.h>
#include <aws/iot-managed-integrations/model/ListTagsForResourceRequest.h>
#include <aws/iot-managed-integrations/model/ListTagsForResourceResult.h>
#include <aws/iot-managed-integrations/model/LogLevel.h>
#include <aws/iot-managed-integrations/model/ManagedThingAssociation.h>
#include <aws/iot-managed-integrations/model/ManagedThingSchemaListItem.h>
#include <aws/iot-managed-integrations/model/ManagedThingSummary.h>
#include <aws/iot-managed-integrations/model/MatterCapabilityReport.h>
#include <aws/iot-managed-integrations/model/MatterCapabilityReportAttribute.h>
#include <aws/iot-managed-integrations/model/MatterCapabilityReportCluster.h>
#include <aws/iot-managed-integrations/model/MatterCapabilityReportEndpoint.h>
#include <aws/iot-managed-integrations/model/MatterCluster.h>
#include <aws/iot-managed-integrations/model/MatterEndpoint.h>
#include <aws/iot-managed-integrations/model/NotificationConfigurationSummary.h>
#include <aws/iot-managed-integrations/model/OAuthConfig.h>
#include <aws/iot-managed-integrations/model/OAuthUpdate.h>
#include <aws/iot-managed-integrations/model/OtaMechanism.h>
#include <aws/iot-managed-integrations/model/OtaProtocol.h>
#include <aws/iot-managed-integrations/model/OtaStatus.h>
#include <aws/iot-managed-integrations/model/OtaTaskAbortConfig.h>
#include <aws/iot-managed-integrations/model/OtaTaskConfigurationSummary.h>
#include <aws/iot-managed-integrations/model/OtaTaskExecutionRetryConfig.h>
#include <aws/iot-managed-integrations/model/OtaTaskExecutionRolloutConfig.h>
#include <aws/iot-managed-integrations/model/OtaTaskExecutionStatus.h>
#include <aws/iot-managed-integrations/model/OtaTaskExecutionSummaries.h>
#include <aws/iot-managed-integrations/model/OtaTaskExecutionSummary.h>
#include <aws/iot-managed-integrations/model/OtaTaskSchedulingConfig.h>
#include <aws/iot-managed-integrations/model/OtaTaskSummary.h>
#include <aws/iot-managed-integrations/model/OtaTaskTimeoutConfig.h>
#include <aws/iot-managed-integrations/model/OtaType.h>
#include <aws/iot-managed-integrations/model/ProactiveRefreshTokenRenewal.h>
#include <aws/iot-managed-integrations/model/ProvisioningProfileSummary.h>
#include <aws/iot-managed-integrations/model/ProvisioningStatus.h>
#include <aws/iot-managed-integrations/model/ProvisioningType.h>
#include <aws/iot-managed-integrations/model/PushConfig.h>
#include <aws/iot-managed-integrations/model/PutDefaultEncryptionConfigurationRequest.h>
#include <aws/iot-managed-integrations/model/PutDefaultEncryptionConfigurationResult.h>
#include <aws/iot-managed-integrations/model/PutHubConfigurationRequest.h>
#include <aws/iot-managed-integrations/model/PutHubConfigurationResult.h>
#include <aws/iot-managed-integrations/model/PutRuntimeLogConfigurationRequest.h>
#include <aws/iot-managed-integrations/model/RegisterAccountAssociationRequest.h>
#include <aws/iot-managed-integrations/model/RegisterAccountAssociationResult.h>
#include <aws/iot-managed-integrations/model/RegisterCustomEndpointRequest.h>
#include <aws/iot-managed-integrations/model/RegisterCustomEndpointResult.h>
#include <aws/iot-managed-integrations/model/ResetRuntimeLogConfigurationRequest.h>
#include <aws/iot-managed-integrations/model/ResourceNotFoundException.h>
#include <aws/iot-managed-integrations/model/RetryConfigCriteria.h>
#include <aws/iot-managed-integrations/model/RetryCriteriaFailureType.h>
#include <aws/iot-managed-integrations/model/Role.h>
#include <aws/iot-managed-integrations/model/RolloutRateIncreaseCriteria.h>
#include <aws/iot-managed-integrations/model/RuntimeLogConfigurations.h>
#include <aws/iot-managed-integrations/model/ScheduleMaintenanceWindow.h>
#include <aws/iot-managed-integrations/model/SchedulingConfigEndBehavior.h>
#include <aws/iot-managed-integrations/model/SchemaVersionFormat.h>
#include <aws/iot-managed-integrations/model/SchemaVersionListItem.h>
#include <aws/iot-managed-integrations/model/SchemaVersionType.h>
#include <aws/iot-managed-integrations/model/SchemaVersionVisibility.h>
#include <aws/iot-managed-integrations/model/SecretsManager.h>
#include <aws/iot-managed-integrations/model/SendConnectorEventRequest.h>
#include <aws/iot-managed-integrations/model/SendConnectorEventResult.h>
#include <aws/iot-managed-integrations/model/SendManagedThingCommandRequest.h>
#include <aws/iot-managed-integrations/model/SendManagedThingCommandResult.h>
#include <aws/iot-managed-integrations/model/StartAccountAssociationRefreshRequest.h>
#include <aws/iot-managed-integrations/model/StartAccountAssociationRefreshResult.h>
#include <aws/iot-managed-integrations/model/StartDeviceDiscoveryRequest.h>
#include <aws/iot-managed-integrations/model/StartDeviceDiscoveryResult.h>
#include <aws/iot-managed-integrations/model/StateCapability.h>
#include <aws/iot-managed-integrations/model/StateEndpoint.h>
#include <aws/iot-managed-integrations/model/TagResourceRequest.h>
#include <aws/iot-managed-integrations/model/TagResourceResult.h>
#include <aws/iot-managed-integrations/model/TaskProcessingDetails.h>
#include <aws/iot-managed-integrations/model/TokenEndpointAuthenticationScheme.h>
#include <aws/iot-managed-integrations/model/UntagResourceRequest.h>
#include <aws/iot-managed-integrations/model/UntagResourceResult.h>
#include <aws/iot-managed-integrations/model/UpdateAccountAssociationRequest.h>
#include <aws/iot-managed-integrations/model/UpdateCloudConnectorRequest.h>
#include <aws/iot-managed-integrations/model/UpdateConnectorDestinationRequest.h>
#include <aws/iot-managed-integrations/model/UpdateDestinationRequest.h>
#include <aws/iot-managed-integrations/model/UpdateEventLogConfigurationRequest.h>
#include <aws/iot-managed-integrations/model/UpdateManagedThingRequest.h>
#include <aws/iot-managed-integrations/model/UpdateNotificationConfigurationRequest.h>
#include <aws/iot-managed-integrations/model/UpdateOtaTaskRequest.h>

using IoTManagedIntegrationsIncludeTest = ::testing::Test;

TEST_F(IoTManagedIntegrationsIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::IoTManagedIntegrations::IoTManagedIntegrationsClient>("IoTManagedIntegrationsIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
