/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/iotanalytics/IoTAnalyticsClient.h>
#include <aws/iotanalytics/IoTAnalyticsEndpointProvider.h>
#include <aws/iotanalytics/IoTAnalyticsEndpointRules.h>
#include <aws/iotanalytics/IoTAnalyticsErrorMarshaller.h>
#include <aws/iotanalytics/IoTAnalyticsErrors.h>
#include <aws/iotanalytics/IoTAnalyticsRequest.h>
#include <aws/iotanalytics/IoTAnalyticsServiceClientModel.h>
#include <aws/iotanalytics/IoTAnalytics_EXPORTS.h>
#include <aws/iotanalytics/model/AddAttributesActivity.h>
#include <aws/iotanalytics/model/BatchPutMessageErrorEntry.h>
#include <aws/iotanalytics/model/BatchPutMessageRequest.h>
#include <aws/iotanalytics/model/BatchPutMessageResult.h>
#include <aws/iotanalytics/model/CancelPipelineReprocessingRequest.h>
#include <aws/iotanalytics/model/CancelPipelineReprocessingResult.h>
#include <aws/iotanalytics/model/Channel.h>
#include <aws/iotanalytics/model/ChannelActivity.h>
#include <aws/iotanalytics/model/ChannelMessages.h>
#include <aws/iotanalytics/model/ChannelStatistics.h>
#include <aws/iotanalytics/model/ChannelStatus.h>
#include <aws/iotanalytics/model/ChannelStorage.h>
#include <aws/iotanalytics/model/ChannelStorageSummary.h>
#include <aws/iotanalytics/model/ChannelSummary.h>
#include <aws/iotanalytics/model/Column.h>
#include <aws/iotanalytics/model/ComputeType.h>
#include <aws/iotanalytics/model/ContainerDatasetAction.h>
#include <aws/iotanalytics/model/CreateChannelRequest.h>
#include <aws/iotanalytics/model/CreateChannelResult.h>
#include <aws/iotanalytics/model/CreateDatasetContentRequest.h>
#include <aws/iotanalytics/model/CreateDatasetContentResult.h>
#include <aws/iotanalytics/model/CreateDatasetRequest.h>
#include <aws/iotanalytics/model/CreateDatasetResult.h>
#include <aws/iotanalytics/model/CreateDatastoreRequest.h>
#include <aws/iotanalytics/model/CreateDatastoreResult.h>
#include <aws/iotanalytics/model/CreatePipelineRequest.h>
#include <aws/iotanalytics/model/CreatePipelineResult.h>
#include <aws/iotanalytics/model/CustomerManagedChannelS3Storage.h>
#include <aws/iotanalytics/model/CustomerManagedChannelS3StorageSummary.h>
#include <aws/iotanalytics/model/CustomerManagedDatastoreS3Storage.h>
#include <aws/iotanalytics/model/CustomerManagedDatastoreS3StorageSummary.h>
#include <aws/iotanalytics/model/Dataset.h>
#include <aws/iotanalytics/model/DatasetAction.h>
#include <aws/iotanalytics/model/DatasetActionSummary.h>
#include <aws/iotanalytics/model/DatasetActionType.h>
#include <aws/iotanalytics/model/DatasetContentDeliveryDestination.h>
#include <aws/iotanalytics/model/DatasetContentDeliveryRule.h>
#include <aws/iotanalytics/model/DatasetContentState.h>
#include <aws/iotanalytics/model/DatasetContentStatus.h>
#include <aws/iotanalytics/model/DatasetContentSummary.h>
#include <aws/iotanalytics/model/DatasetContentVersionValue.h>
#include <aws/iotanalytics/model/DatasetEntry.h>
#include <aws/iotanalytics/model/DatasetStatus.h>
#include <aws/iotanalytics/model/DatasetSummary.h>
#include <aws/iotanalytics/model/DatasetTrigger.h>
#include <aws/iotanalytics/model/Datastore.h>
#include <aws/iotanalytics/model/DatastoreActivity.h>
#include <aws/iotanalytics/model/DatastoreIotSiteWiseMultiLayerStorage.h>
#include <aws/iotanalytics/model/DatastoreIotSiteWiseMultiLayerStorageSummary.h>
#include <aws/iotanalytics/model/DatastorePartition.h>
#include <aws/iotanalytics/model/DatastorePartitions.h>
#include <aws/iotanalytics/model/DatastoreStatistics.h>
#include <aws/iotanalytics/model/DatastoreStatus.h>
#include <aws/iotanalytics/model/DatastoreStorage.h>
#include <aws/iotanalytics/model/DatastoreStorageSummary.h>
#include <aws/iotanalytics/model/DatastoreSummary.h>
#include <aws/iotanalytics/model/DeleteChannelRequest.h>
#include <aws/iotanalytics/model/DeleteDatasetContentRequest.h>
#include <aws/iotanalytics/model/DeleteDatasetRequest.h>
#include <aws/iotanalytics/model/DeleteDatastoreRequest.h>
#include <aws/iotanalytics/model/DeletePipelineRequest.h>
#include <aws/iotanalytics/model/DeltaTime.h>
#include <aws/iotanalytics/model/DeltaTimeSessionWindowConfiguration.h>
#include <aws/iotanalytics/model/DescribeChannelRequest.h>
#include <aws/iotanalytics/model/DescribeChannelResult.h>
#include <aws/iotanalytics/model/DescribeDatasetRequest.h>
#include <aws/iotanalytics/model/DescribeDatasetResult.h>
#include <aws/iotanalytics/model/DescribeDatastoreRequest.h>
#include <aws/iotanalytics/model/DescribeDatastoreResult.h>
#include <aws/iotanalytics/model/DescribeLoggingOptionsRequest.h>
#include <aws/iotanalytics/model/DescribeLoggingOptionsResult.h>
#include <aws/iotanalytics/model/DescribePipelineRequest.h>
#include <aws/iotanalytics/model/DescribePipelineResult.h>
#include <aws/iotanalytics/model/DeviceRegistryEnrichActivity.h>
#include <aws/iotanalytics/model/DeviceShadowEnrichActivity.h>
#include <aws/iotanalytics/model/EstimatedResourceSize.h>
#include <aws/iotanalytics/model/FileFormatConfiguration.h>
#include <aws/iotanalytics/model/FileFormatType.h>
#include <aws/iotanalytics/model/FilterActivity.h>
#include <aws/iotanalytics/model/GetDatasetContentRequest.h>
#include <aws/iotanalytics/model/GetDatasetContentResult.h>
#include <aws/iotanalytics/model/GlueConfiguration.h>
#include <aws/iotanalytics/model/IotEventsDestinationConfiguration.h>
#include <aws/iotanalytics/model/IotSiteWiseCustomerManagedDatastoreS3Storage.h>
#include <aws/iotanalytics/model/IotSiteWiseCustomerManagedDatastoreS3StorageSummary.h>
#include <aws/iotanalytics/model/JsonConfiguration.h>
#include <aws/iotanalytics/model/LambdaActivity.h>
#include <aws/iotanalytics/model/LateDataRule.h>
#include <aws/iotanalytics/model/LateDataRuleConfiguration.h>
#include <aws/iotanalytics/model/ListChannelsRequest.h>
#include <aws/iotanalytics/model/ListChannelsResult.h>
#include <aws/iotanalytics/model/ListDatasetContentsRequest.h>
#include <aws/iotanalytics/model/ListDatasetContentsResult.h>
#include <aws/iotanalytics/model/ListDatasetsRequest.h>
#include <aws/iotanalytics/model/ListDatasetsResult.h>
#include <aws/iotanalytics/model/ListDatastoresRequest.h>
#include <aws/iotanalytics/model/ListDatastoresResult.h>
#include <aws/iotanalytics/model/ListPipelinesRequest.h>
#include <aws/iotanalytics/model/ListPipelinesResult.h>
#include <aws/iotanalytics/model/ListTagsForResourceRequest.h>
#include <aws/iotanalytics/model/ListTagsForResourceResult.h>
#include <aws/iotanalytics/model/LoggingLevel.h>
#include <aws/iotanalytics/model/LoggingOptions.h>
#include <aws/iotanalytics/model/MathActivity.h>
#include <aws/iotanalytics/model/Message.h>
#include <aws/iotanalytics/model/OutputFileUriValue.h>
#include <aws/iotanalytics/model/ParquetConfiguration.h>
#include <aws/iotanalytics/model/Partition.h>
#include <aws/iotanalytics/model/Pipeline.h>
#include <aws/iotanalytics/model/PipelineActivity.h>
#include <aws/iotanalytics/model/PipelineSummary.h>
#include <aws/iotanalytics/model/PutLoggingOptionsRequest.h>
#include <aws/iotanalytics/model/QueryFilter.h>
#include <aws/iotanalytics/model/RemoveAttributesActivity.h>
#include <aws/iotanalytics/model/ReprocessingStatus.h>
#include <aws/iotanalytics/model/ReprocessingSummary.h>
#include <aws/iotanalytics/model/ResourceAlreadyExistsException.h>
#include <aws/iotanalytics/model/ResourceConfiguration.h>
#include <aws/iotanalytics/model/RetentionPeriod.h>
#include <aws/iotanalytics/model/RunPipelineActivityRequest.h>
#include <aws/iotanalytics/model/RunPipelineActivityResult.h>
#include <aws/iotanalytics/model/S3DestinationConfiguration.h>
#include <aws/iotanalytics/model/SampleChannelDataRequest.h>
#include <aws/iotanalytics/model/SampleChannelDataResult.h>
#include <aws/iotanalytics/model/Schedule.h>
#include <aws/iotanalytics/model/SchemaDefinition.h>
#include <aws/iotanalytics/model/SelectAttributesActivity.h>
#include <aws/iotanalytics/model/ServiceManagedChannelS3Storage.h>
#include <aws/iotanalytics/model/ServiceManagedChannelS3StorageSummary.h>
#include <aws/iotanalytics/model/ServiceManagedDatastoreS3Storage.h>
#include <aws/iotanalytics/model/ServiceManagedDatastoreS3StorageSummary.h>
#include <aws/iotanalytics/model/SqlQueryDatasetAction.h>
#include <aws/iotanalytics/model/StartPipelineReprocessingRequest.h>
#include <aws/iotanalytics/model/StartPipelineReprocessingResult.h>
#include <aws/iotanalytics/model/Tag.h>
#include <aws/iotanalytics/model/TagResourceRequest.h>
#include <aws/iotanalytics/model/TagResourceResult.h>
#include <aws/iotanalytics/model/TimestampPartition.h>
#include <aws/iotanalytics/model/TriggeringDataset.h>
#include <aws/iotanalytics/model/UntagResourceRequest.h>
#include <aws/iotanalytics/model/UntagResourceResult.h>
#include <aws/iotanalytics/model/UpdateChannelRequest.h>
#include <aws/iotanalytics/model/UpdateDatasetRequest.h>
#include <aws/iotanalytics/model/UpdateDatastoreRequest.h>
#include <aws/iotanalytics/model/UpdatePipelineRequest.h>
#include <aws/iotanalytics/model/Variable.h>
#include <aws/iotanalytics/model/VersioningConfiguration.h>

using IoTAnalyticsIncludeTest = ::testing::Test;

TEST_F(IoTAnalyticsIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::IoTAnalytics::IoTAnalyticsClient>("IoTAnalyticsIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
