/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/iotfleetwise/IoTFleetWiseClient.h>
#include <aws/iotfleetwise/IoTFleetWiseEndpointProvider.h>
#include <aws/iotfleetwise/IoTFleetWiseEndpointRules.h>
#include <aws/iotfleetwise/IoTFleetWiseErrorMarshaller.h>
#include <aws/iotfleetwise/IoTFleetWiseErrors.h>
#include <aws/iotfleetwise/IoTFleetWiseRequest.h>
#include <aws/iotfleetwise/IoTFleetWiseServiceClientModel.h>
#include <aws/iotfleetwise/IoTFleetWise_EXPORTS.h>
#include <aws/iotfleetwise/model/Actuator.h>
#include <aws/iotfleetwise/model/AssociateVehicleFleetRequest.h>
#include <aws/iotfleetwise/model/AssociateVehicleFleetResult.h>
#include <aws/iotfleetwise/model/Attribute.h>
#include <aws/iotfleetwise/model/BatchCreateVehicleRequest.h>
#include <aws/iotfleetwise/model/BatchCreateVehicleResult.h>
#include <aws/iotfleetwise/model/BatchUpdateVehicleRequest.h>
#include <aws/iotfleetwise/model/BatchUpdateVehicleResult.h>
#include <aws/iotfleetwise/model/Branch.h>
#include <aws/iotfleetwise/model/CampaignStatus.h>
#include <aws/iotfleetwise/model/CampaignSummary.h>
#include <aws/iotfleetwise/model/CanDbcDefinition.h>
#include <aws/iotfleetwise/model/CanInterface.h>
#include <aws/iotfleetwise/model/CanSignal.h>
#include <aws/iotfleetwise/model/CloudWatchLogDeliveryOptions.h>
#include <aws/iotfleetwise/model/CollectionScheme.h>
#include <aws/iotfleetwise/model/Compression.h>
#include <aws/iotfleetwise/model/ConditionBasedCollectionScheme.h>
#include <aws/iotfleetwise/model/ConditionBasedSignalFetchConfig.h>
#include <aws/iotfleetwise/model/ConflictException.h>
#include <aws/iotfleetwise/model/CreateCampaignRequest.h>
#include <aws/iotfleetwise/model/CreateCampaignResult.h>
#include <aws/iotfleetwise/model/CreateDecoderManifestRequest.h>
#include <aws/iotfleetwise/model/CreateDecoderManifestResult.h>
#include <aws/iotfleetwise/model/CreateFleetRequest.h>
#include <aws/iotfleetwise/model/CreateFleetResult.h>
#include <aws/iotfleetwise/model/CreateModelManifestRequest.h>
#include <aws/iotfleetwise/model/CreateModelManifestResult.h>
#include <aws/iotfleetwise/model/CreateSignalCatalogRequest.h>
#include <aws/iotfleetwise/model/CreateSignalCatalogResult.h>
#include <aws/iotfleetwise/model/CreateStateTemplateRequest.h>
#include <aws/iotfleetwise/model/CreateStateTemplateResult.h>
#include <aws/iotfleetwise/model/CreateVehicleError.h>
#include <aws/iotfleetwise/model/CreateVehicleRequest.h>
#include <aws/iotfleetwise/model/CreateVehicleRequestItem.h>
#include <aws/iotfleetwise/model/CreateVehicleResponseItem.h>
#include <aws/iotfleetwise/model/CreateVehicleResult.h>
#include <aws/iotfleetwise/model/CustomDecodingInterface.h>
#include <aws/iotfleetwise/model/CustomDecodingSignal.h>
#include <aws/iotfleetwise/model/CustomProperty.h>
#include <aws/iotfleetwise/model/CustomStruct.h>
#include <aws/iotfleetwise/model/DataDestinationConfig.h>
#include <aws/iotfleetwise/model/DataFormat.h>
#include <aws/iotfleetwise/model/DataPartition.h>
#include <aws/iotfleetwise/model/DataPartitionStorageOptions.h>
#include <aws/iotfleetwise/model/DataPartitionUploadOptions.h>
#include <aws/iotfleetwise/model/DecoderManifestSummary.h>
#include <aws/iotfleetwise/model/DecoderManifestValidationException.h>
#include <aws/iotfleetwise/model/DefaultForUnmappedSignalsType.h>
#include <aws/iotfleetwise/model/DeleteCampaignRequest.h>
#include <aws/iotfleetwise/model/DeleteCampaignResult.h>
#include <aws/iotfleetwise/model/DeleteDecoderManifestRequest.h>
#include <aws/iotfleetwise/model/DeleteDecoderManifestResult.h>
#include <aws/iotfleetwise/model/DeleteFleetRequest.h>
#include <aws/iotfleetwise/model/DeleteFleetResult.h>
#include <aws/iotfleetwise/model/DeleteModelManifestRequest.h>
#include <aws/iotfleetwise/model/DeleteModelManifestResult.h>
#include <aws/iotfleetwise/model/DeleteSignalCatalogRequest.h>
#include <aws/iotfleetwise/model/DeleteSignalCatalogResult.h>
#include <aws/iotfleetwise/model/DeleteStateTemplateRequest.h>
#include <aws/iotfleetwise/model/DeleteStateTemplateResult.h>
#include <aws/iotfleetwise/model/DeleteVehicleRequest.h>
#include <aws/iotfleetwise/model/DeleteVehicleResult.h>
#include <aws/iotfleetwise/model/DiagnosticsMode.h>
#include <aws/iotfleetwise/model/DisassociateVehicleFleetRequest.h>
#include <aws/iotfleetwise/model/DisassociateVehicleFleetResult.h>
#include <aws/iotfleetwise/model/EncryptionStatus.h>
#include <aws/iotfleetwise/model/EncryptionType.h>
#include <aws/iotfleetwise/model/FleetSummary.h>
#include <aws/iotfleetwise/model/FormattedVss.h>
#include <aws/iotfleetwise/model/GetCampaignRequest.h>
#include <aws/iotfleetwise/model/GetCampaignResult.h>
#include <aws/iotfleetwise/model/GetDecoderManifestRequest.h>
#include <aws/iotfleetwise/model/GetDecoderManifestResult.h>
#include <aws/iotfleetwise/model/GetEncryptionConfigurationRequest.h>
#include <aws/iotfleetwise/model/GetEncryptionConfigurationResult.h>
#include <aws/iotfleetwise/model/GetFleetRequest.h>
#include <aws/iotfleetwise/model/GetFleetResult.h>
#include <aws/iotfleetwise/model/GetLoggingOptionsRequest.h>
#include <aws/iotfleetwise/model/GetLoggingOptionsResult.h>
#include <aws/iotfleetwise/model/GetModelManifestRequest.h>
#include <aws/iotfleetwise/model/GetModelManifestResult.h>
#include <aws/iotfleetwise/model/GetRegisterAccountStatusRequest.h>
#include <aws/iotfleetwise/model/GetRegisterAccountStatusResult.h>
#include <aws/iotfleetwise/model/GetSignalCatalogRequest.h>
#include <aws/iotfleetwise/model/GetSignalCatalogResult.h>
#include <aws/iotfleetwise/model/GetStateTemplateRequest.h>
#include <aws/iotfleetwise/model/GetStateTemplateResult.h>
#include <aws/iotfleetwise/model/GetVehicleRequest.h>
#include <aws/iotfleetwise/model/GetVehicleResult.h>
#include <aws/iotfleetwise/model/GetVehicleStatusRequest.h>
#include <aws/iotfleetwise/model/GetVehicleStatusResult.h>
#include <aws/iotfleetwise/model/IamRegistrationResponse.h>
#include <aws/iotfleetwise/model/IamResources.h>
#include <aws/iotfleetwise/model/ImportDecoderManifestRequest.h>
#include <aws/iotfleetwise/model/ImportDecoderManifestResult.h>
#include <aws/iotfleetwise/model/ImportSignalCatalogRequest.h>
#include <aws/iotfleetwise/model/ImportSignalCatalogResult.h>
#include <aws/iotfleetwise/model/InternalServerException.h>
#include <aws/iotfleetwise/model/InvalidNetworkInterface.h>
#include <aws/iotfleetwise/model/InvalidNodeException.h>
#include <aws/iotfleetwise/model/InvalidSignal.h>
#include <aws/iotfleetwise/model/InvalidSignalDecoder.h>
#include <aws/iotfleetwise/model/InvalidSignalsException.h>
#include <aws/iotfleetwise/model/LimitExceededException.h>
#include <aws/iotfleetwise/model/ListCampaignsRequest.h>
#include <aws/iotfleetwise/model/ListCampaignsResult.h>
#include <aws/iotfleetwise/model/ListDecoderManifestNetworkInterfacesRequest.h>
#include <aws/iotfleetwise/model/ListDecoderManifestNetworkInterfacesResult.h>
#include <aws/iotfleetwise/model/ListDecoderManifestSignalsRequest.h>
#include <aws/iotfleetwise/model/ListDecoderManifestSignalsResult.h>
#include <aws/iotfleetwise/model/ListDecoderManifestsRequest.h>
#include <aws/iotfleetwise/model/ListDecoderManifestsResult.h>
#include <aws/iotfleetwise/model/ListFleetsForVehicleRequest.h>
#include <aws/iotfleetwise/model/ListFleetsForVehicleResult.h>
#include <aws/iotfleetwise/model/ListFleetsRequest.h>
#include <aws/iotfleetwise/model/ListFleetsResult.h>
#include <aws/iotfleetwise/model/ListModelManifestNodesRequest.h>
#include <aws/iotfleetwise/model/ListModelManifestNodesResult.h>
#include <aws/iotfleetwise/model/ListModelManifestsRequest.h>
#include <aws/iotfleetwise/model/ListModelManifestsResult.h>
#include <aws/iotfleetwise/model/ListResponseScope.h>
#include <aws/iotfleetwise/model/ListSignalCatalogNodesRequest.h>
#include <aws/iotfleetwise/model/ListSignalCatalogNodesResult.h>
#include <aws/iotfleetwise/model/ListSignalCatalogsRequest.h>
#include <aws/iotfleetwise/model/ListSignalCatalogsResult.h>
#include <aws/iotfleetwise/model/ListStateTemplatesRequest.h>
#include <aws/iotfleetwise/model/ListStateTemplatesResult.h>
#include <aws/iotfleetwise/model/ListTagsForResourceRequest.h>
#include <aws/iotfleetwise/model/ListTagsForResourceResult.h>
#include <aws/iotfleetwise/model/ListVehiclesInFleetRequest.h>
#include <aws/iotfleetwise/model/ListVehiclesInFleetResult.h>
#include <aws/iotfleetwise/model/ListVehiclesRequest.h>
#include <aws/iotfleetwise/model/ListVehiclesResult.h>
#include <aws/iotfleetwise/model/LogType.h>
#include <aws/iotfleetwise/model/ManifestStatus.h>
#include <aws/iotfleetwise/model/MessageSignal.h>
#include <aws/iotfleetwise/model/ModelManifestSummary.h>
#include <aws/iotfleetwise/model/MqttTopicConfig.h>
#include <aws/iotfleetwise/model/NetworkFileDefinition.h>
#include <aws/iotfleetwise/model/NetworkInterface.h>
#include <aws/iotfleetwise/model/NetworkInterfaceFailureReason.h>
#include <aws/iotfleetwise/model/NetworkInterfaceType.h>
#include <aws/iotfleetwise/model/Node.h>
#include <aws/iotfleetwise/model/NodeCounts.h>
#include <aws/iotfleetwise/model/NodeDataEncoding.h>
#include <aws/iotfleetwise/model/NodeDataType.h>
#include <aws/iotfleetwise/model/ObdInterface.h>
#include <aws/iotfleetwise/model/ObdSignal.h>
#include <aws/iotfleetwise/model/OnChangeStateTemplateUpdateStrategy.h>
#include <aws/iotfleetwise/model/PeriodicStateTemplateUpdateStrategy.h>
#include <aws/iotfleetwise/model/PrimitiveMessageDefinition.h>
#include <aws/iotfleetwise/model/PutEncryptionConfigurationRequest.h>
#include <aws/iotfleetwise/model/PutEncryptionConfigurationResult.h>
#include <aws/iotfleetwise/model/PutLoggingOptionsRequest.h>
#include <aws/iotfleetwise/model/PutLoggingOptionsResult.h>
#include <aws/iotfleetwise/model/ROS2PrimitiveMessageDefinition.h>
#include <aws/iotfleetwise/model/ROS2PrimitiveType.h>
#include <aws/iotfleetwise/model/RegisterAccountRequest.h>
#include <aws/iotfleetwise/model/RegisterAccountResult.h>
#include <aws/iotfleetwise/model/RegistrationStatus.h>
#include <aws/iotfleetwise/model/ResourceNotFoundException.h>
#include <aws/iotfleetwise/model/S3Config.h>
#include <aws/iotfleetwise/model/Sensor.h>
#include <aws/iotfleetwise/model/SignalCatalogSummary.h>
#include <aws/iotfleetwise/model/SignalDecoder.h>
#include <aws/iotfleetwise/model/SignalDecoderFailureReason.h>
#include <aws/iotfleetwise/model/SignalDecoderType.h>
#include <aws/iotfleetwise/model/SignalFetchConfig.h>
#include <aws/iotfleetwise/model/SignalFetchInformation.h>
#include <aws/iotfleetwise/model/SignalInformation.h>
#include <aws/iotfleetwise/model/SignalNodeType.h>
#include <aws/iotfleetwise/model/SignalValueType.h>
#include <aws/iotfleetwise/model/SpoolingMode.h>
#include <aws/iotfleetwise/model/StateTemplateAssociation.h>
#include <aws/iotfleetwise/model/StateTemplateSummary.h>
#include <aws/iotfleetwise/model/StateTemplateUpdateStrategy.h>
#include <aws/iotfleetwise/model/StorageCompressionFormat.h>
#include <aws/iotfleetwise/model/StorageMaximumSize.h>
#include <aws/iotfleetwise/model/StorageMaximumSizeUnit.h>
#include <aws/iotfleetwise/model/StorageMinimumTimeToLive.h>
#include <aws/iotfleetwise/model/StorageMinimumTimeToLiveUnit.h>
#include <aws/iotfleetwise/model/StructuredMessage.h>
#include <aws/iotfleetwise/model/StructuredMessageFieldNameAndDataTypePair.h>
#include <aws/iotfleetwise/model/StructuredMessageListDefinition.h>
#include <aws/iotfleetwise/model/StructuredMessageListType.h>
#include <aws/iotfleetwise/model/Tag.h>
#include <aws/iotfleetwise/model/TagResourceRequest.h>
#include <aws/iotfleetwise/model/TagResourceResult.h>
#include <aws/iotfleetwise/model/ThrottlingException.h>
#include <aws/iotfleetwise/model/TimeBasedCollectionScheme.h>
#include <aws/iotfleetwise/model/TimeBasedSignalFetchConfig.h>
#include <aws/iotfleetwise/model/TimePeriod.h>
#include <aws/iotfleetwise/model/TimeUnit.h>
#include <aws/iotfleetwise/model/TimestreamConfig.h>
#include <aws/iotfleetwise/model/TimestreamRegistrationResponse.h>
#include <aws/iotfleetwise/model/TimestreamResources.h>
#include <aws/iotfleetwise/model/TriggerMode.h>
#include <aws/iotfleetwise/model/UntagResourceRequest.h>
#include <aws/iotfleetwise/model/UntagResourceResult.h>
#include <aws/iotfleetwise/model/UpdateCampaignAction.h>
#include <aws/iotfleetwise/model/UpdateCampaignRequest.h>
#include <aws/iotfleetwise/model/UpdateCampaignResult.h>
#include <aws/iotfleetwise/model/UpdateDecoderManifestRequest.h>
#include <aws/iotfleetwise/model/UpdateDecoderManifestResult.h>
#include <aws/iotfleetwise/model/UpdateFleetRequest.h>
#include <aws/iotfleetwise/model/UpdateFleetResult.h>
#include <aws/iotfleetwise/model/UpdateMode.h>
#include <aws/iotfleetwise/model/UpdateModelManifestRequest.h>
#include <aws/iotfleetwise/model/UpdateModelManifestResult.h>
#include <aws/iotfleetwise/model/UpdateSignalCatalogRequest.h>
#include <aws/iotfleetwise/model/UpdateSignalCatalogResult.h>
#include <aws/iotfleetwise/model/UpdateStateTemplateRequest.h>
#include <aws/iotfleetwise/model/UpdateStateTemplateResult.h>
#include <aws/iotfleetwise/model/UpdateVehicleError.h>
#include <aws/iotfleetwise/model/UpdateVehicleRequest.h>
#include <aws/iotfleetwise/model/UpdateVehicleRequestItem.h>
#include <aws/iotfleetwise/model/UpdateVehicleResponseItem.h>
#include <aws/iotfleetwise/model/UpdateVehicleResult.h>
#include <aws/iotfleetwise/model/ValidationException.h>
#include <aws/iotfleetwise/model/ValidationExceptionField.h>
#include <aws/iotfleetwise/model/ValidationExceptionReason.h>
#include <aws/iotfleetwise/model/VehicleAssociationBehavior.h>
#include <aws/iotfleetwise/model/VehicleMiddleware.h>
#include <aws/iotfleetwise/model/VehicleMiddlewareProtocol.h>
#include <aws/iotfleetwise/model/VehicleState.h>
#include <aws/iotfleetwise/model/VehicleStatus.h>
#include <aws/iotfleetwise/model/VehicleSummary.h>

using IoTFleetWiseIncludeTest = ::testing::Test;

TEST_F(IoTFleetWiseIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::IoTFleetWise::IoTFleetWiseClient>("IoTFleetWiseIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
