/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/iotsitewise/IoTSiteWiseClient.h>
#include <aws/iotsitewise/IoTSiteWiseEndpointProvider.h>
#include <aws/iotsitewise/IoTSiteWiseEndpointRules.h>
#include <aws/iotsitewise/IoTSiteWiseErrorMarshaller.h>
#include <aws/iotsitewise/IoTSiteWiseErrors.h>
#include <aws/iotsitewise/IoTSiteWiseRequest.h>
#include <aws/iotsitewise/IoTSiteWiseServiceClientModel.h>
#include <aws/iotsitewise/IoTSiteWise_EXPORTS.h>
#include <aws/iotsitewise/model/AccessPolicySummary.h>
#include <aws/iotsitewise/model/ActionDefinition.h>
#include <aws/iotsitewise/model/ActionPayload.h>
#include <aws/iotsitewise/model/ActionSummary.h>
#include <aws/iotsitewise/model/AggregateType.h>
#include <aws/iotsitewise/model/AggregatedValue.h>
#include <aws/iotsitewise/model/Aggregates.h>
#include <aws/iotsitewise/model/Alarms.h>
#include <aws/iotsitewise/model/AssetCompositeModel.h>
#include <aws/iotsitewise/model/AssetCompositeModelPathSegment.h>
#include <aws/iotsitewise/model/AssetCompositeModelSummary.h>
#include <aws/iotsitewise/model/AssetErrorCode.h>
#include <aws/iotsitewise/model/AssetErrorDetails.h>
#include <aws/iotsitewise/model/AssetHierarchy.h>
#include <aws/iotsitewise/model/AssetHierarchyInfo.h>
#include <aws/iotsitewise/model/AssetModelCompositeModel.h>
#include <aws/iotsitewise/model/AssetModelCompositeModelDefinition.h>
#include <aws/iotsitewise/model/AssetModelCompositeModelPathSegment.h>
#include <aws/iotsitewise/model/AssetModelCompositeModelSummary.h>
#include <aws/iotsitewise/model/AssetModelHierarchy.h>
#include <aws/iotsitewise/model/AssetModelHierarchyDefinition.h>
#include <aws/iotsitewise/model/AssetModelProperty.h>
#include <aws/iotsitewise/model/AssetModelPropertyDefinition.h>
#include <aws/iotsitewise/model/AssetModelPropertyPathSegment.h>
#include <aws/iotsitewise/model/AssetModelPropertySummary.h>
#include <aws/iotsitewise/model/AssetModelState.h>
#include <aws/iotsitewise/model/AssetModelStatus.h>
#include <aws/iotsitewise/model/AssetModelSummary.h>
#include <aws/iotsitewise/model/AssetModelType.h>
#include <aws/iotsitewise/model/AssetModelVersionType.h>
#include <aws/iotsitewise/model/AssetProperty.h>
#include <aws/iotsitewise/model/AssetPropertyPathSegment.h>
#include <aws/iotsitewise/model/AssetPropertySummary.h>
#include <aws/iotsitewise/model/AssetPropertyValue.h>
#include <aws/iotsitewise/model/AssetRelationshipSummary.h>
#include <aws/iotsitewise/model/AssetRelationshipType.h>
#include <aws/iotsitewise/model/AssetState.h>
#include <aws/iotsitewise/model/AssetStatus.h>
#include <aws/iotsitewise/model/AssetSummary.h>
#include <aws/iotsitewise/model/AssociateAssetsRequest.h>
#include <aws/iotsitewise/model/AssociateTimeSeriesToAssetPropertyRequest.h>
#include <aws/iotsitewise/model/AssociatedAssetsSummary.h>
#include <aws/iotsitewise/model/Attribute.h>
#include <aws/iotsitewise/model/AuthMode.h>
#include <aws/iotsitewise/model/BatchAssociateProjectAssetsRequest.h>
#include <aws/iotsitewise/model/BatchAssociateProjectAssetsResult.h>
#include <aws/iotsitewise/model/BatchDisassociateProjectAssetsRequest.h>
#include <aws/iotsitewise/model/BatchDisassociateProjectAssetsResult.h>
#include <aws/iotsitewise/model/BatchEntryCompletionStatus.h>
#include <aws/iotsitewise/model/BatchGetAssetPropertyAggregatesEntry.h>
#include <aws/iotsitewise/model/BatchGetAssetPropertyAggregatesErrorCode.h>
#include <aws/iotsitewise/model/BatchGetAssetPropertyAggregatesErrorEntry.h>
#include <aws/iotsitewise/model/BatchGetAssetPropertyAggregatesErrorInfo.h>
#include <aws/iotsitewise/model/BatchGetAssetPropertyAggregatesRequest.h>
#include <aws/iotsitewise/model/BatchGetAssetPropertyAggregatesResult.h>
#include <aws/iotsitewise/model/BatchGetAssetPropertyAggregatesSkippedEntry.h>
#include <aws/iotsitewise/model/BatchGetAssetPropertyAggregatesSuccessEntry.h>
#include <aws/iotsitewise/model/BatchGetAssetPropertyValueEntry.h>
#include <aws/iotsitewise/model/BatchGetAssetPropertyValueErrorCode.h>
#include <aws/iotsitewise/model/BatchGetAssetPropertyValueErrorEntry.h>
#include <aws/iotsitewise/model/BatchGetAssetPropertyValueErrorInfo.h>
#include <aws/iotsitewise/model/BatchGetAssetPropertyValueHistoryEntry.h>
#include <aws/iotsitewise/model/BatchGetAssetPropertyValueHistoryErrorCode.h>
#include <aws/iotsitewise/model/BatchGetAssetPropertyValueHistoryErrorEntry.h>
#include <aws/iotsitewise/model/BatchGetAssetPropertyValueHistoryErrorInfo.h>
#include <aws/iotsitewise/model/BatchGetAssetPropertyValueHistoryRequest.h>
#include <aws/iotsitewise/model/BatchGetAssetPropertyValueHistoryResult.h>
#include <aws/iotsitewise/model/BatchGetAssetPropertyValueHistorySkippedEntry.h>
#include <aws/iotsitewise/model/BatchGetAssetPropertyValueHistorySuccessEntry.h>
#include <aws/iotsitewise/model/BatchGetAssetPropertyValueRequest.h>
#include <aws/iotsitewise/model/BatchGetAssetPropertyValueResult.h>
#include <aws/iotsitewise/model/BatchGetAssetPropertyValueSkippedEntry.h>
#include <aws/iotsitewise/model/BatchGetAssetPropertyValueSuccessEntry.h>
#include <aws/iotsitewise/model/BatchPutAssetPropertyError.h>
#include <aws/iotsitewise/model/BatchPutAssetPropertyErrorEntry.h>
#include <aws/iotsitewise/model/BatchPutAssetPropertyValueErrorCode.h>
#include <aws/iotsitewise/model/BatchPutAssetPropertyValueRequest.h>
#include <aws/iotsitewise/model/BatchPutAssetPropertyValueResult.h>
#include <aws/iotsitewise/model/CapabilitySyncStatus.h>
#include <aws/iotsitewise/model/Citation.h>
#include <aws/iotsitewise/model/ColumnInfo.h>
#include <aws/iotsitewise/model/ColumnName.h>
#include <aws/iotsitewise/model/ColumnType.h>
#include <aws/iotsitewise/model/CompositeModelProperty.h>
#include <aws/iotsitewise/model/CompositionDetails.h>
#include <aws/iotsitewise/model/CompositionRelationshipItem.h>
#include <aws/iotsitewise/model/CompositionRelationshipSummary.h>
#include <aws/iotsitewise/model/ComputeLocation.h>
#include <aws/iotsitewise/model/ConfigurationErrorDetails.h>
#include <aws/iotsitewise/model/ConfigurationState.h>
#include <aws/iotsitewise/model/ConfigurationStatus.h>
#include <aws/iotsitewise/model/ConflictingOperationException.h>
#include <aws/iotsitewise/model/Content.h>
#include <aws/iotsitewise/model/CoreDeviceOperatingSystem.h>
#include <aws/iotsitewise/model/CreateAccessPolicyRequest.h>
#include <aws/iotsitewise/model/CreateAccessPolicyResult.h>
#include <aws/iotsitewise/model/CreateAssetModelCompositeModelRequest.h>
#include <aws/iotsitewise/model/CreateAssetModelCompositeModelResult.h>
#include <aws/iotsitewise/model/CreateAssetModelRequest.h>
#include <aws/iotsitewise/model/CreateAssetModelResult.h>
#include <aws/iotsitewise/model/CreateAssetRequest.h>
#include <aws/iotsitewise/model/CreateAssetResult.h>
#include <aws/iotsitewise/model/CreateBulkImportJobRequest.h>
#include <aws/iotsitewise/model/CreateBulkImportJobResult.h>
#include <aws/iotsitewise/model/CreateDashboardRequest.h>
#include <aws/iotsitewise/model/CreateDashboardResult.h>
#include <aws/iotsitewise/model/CreateDatasetRequest.h>
#include <aws/iotsitewise/model/CreateDatasetResult.h>
#include <aws/iotsitewise/model/CreateGatewayRequest.h>
#include <aws/iotsitewise/model/CreateGatewayResult.h>
#include <aws/iotsitewise/model/CreatePortalRequest.h>
#include <aws/iotsitewise/model/CreatePortalResult.h>
#include <aws/iotsitewise/model/CreateProjectRequest.h>
#include <aws/iotsitewise/model/CreateProjectResult.h>
#include <aws/iotsitewise/model/Csv.h>
#include <aws/iotsitewise/model/CustomerManagedS3Storage.h>
#include <aws/iotsitewise/model/DashboardSummary.h>
#include <aws/iotsitewise/model/DataSetReference.h>
#include <aws/iotsitewise/model/DatasetSource.h>
#include <aws/iotsitewise/model/DatasetSourceFormat.h>
#include <aws/iotsitewise/model/DatasetSourceType.h>
#include <aws/iotsitewise/model/DatasetState.h>
#include <aws/iotsitewise/model/DatasetStatus.h>
#include <aws/iotsitewise/model/DatasetSummary.h>
#include <aws/iotsitewise/model/Datum.h>
#include <aws/iotsitewise/model/DeleteAccessPolicyRequest.h>
#include <aws/iotsitewise/model/DeleteAccessPolicyResult.h>
#include <aws/iotsitewise/model/DeleteAssetModelCompositeModelRequest.h>
#include <aws/iotsitewise/model/DeleteAssetModelCompositeModelResult.h>
#include <aws/iotsitewise/model/DeleteAssetModelRequest.h>
#include <aws/iotsitewise/model/DeleteAssetModelResult.h>
#include <aws/iotsitewise/model/DeleteAssetRequest.h>
#include <aws/iotsitewise/model/DeleteAssetResult.h>
#include <aws/iotsitewise/model/DeleteDashboardRequest.h>
#include <aws/iotsitewise/model/DeleteDashboardResult.h>
#include <aws/iotsitewise/model/DeleteDatasetRequest.h>
#include <aws/iotsitewise/model/DeleteDatasetResult.h>
#include <aws/iotsitewise/model/DeleteGatewayRequest.h>
#include <aws/iotsitewise/model/DeletePortalRequest.h>
#include <aws/iotsitewise/model/DeletePortalResult.h>
#include <aws/iotsitewise/model/DeleteProjectRequest.h>
#include <aws/iotsitewise/model/DeleteProjectResult.h>
#include <aws/iotsitewise/model/DeleteTimeSeriesRequest.h>
#include <aws/iotsitewise/model/DescribeAccessPolicyRequest.h>
#include <aws/iotsitewise/model/DescribeAccessPolicyResult.h>
#include <aws/iotsitewise/model/DescribeActionRequest.h>
#include <aws/iotsitewise/model/DescribeActionResult.h>
#include <aws/iotsitewise/model/DescribeAssetCompositeModelRequest.h>
#include <aws/iotsitewise/model/DescribeAssetCompositeModelResult.h>
#include <aws/iotsitewise/model/DescribeAssetModelCompositeModelRequest.h>
#include <aws/iotsitewise/model/DescribeAssetModelCompositeModelResult.h>
#include <aws/iotsitewise/model/DescribeAssetModelRequest.h>
#include <aws/iotsitewise/model/DescribeAssetModelResult.h>
#include <aws/iotsitewise/model/DescribeAssetPropertyRequest.h>
#include <aws/iotsitewise/model/DescribeAssetPropertyResult.h>
#include <aws/iotsitewise/model/DescribeAssetRequest.h>
#include <aws/iotsitewise/model/DescribeAssetResult.h>
#include <aws/iotsitewise/model/DescribeBulkImportJobRequest.h>
#include <aws/iotsitewise/model/DescribeBulkImportJobResult.h>
#include <aws/iotsitewise/model/DescribeDashboardRequest.h>
#include <aws/iotsitewise/model/DescribeDashboardResult.h>
#include <aws/iotsitewise/model/DescribeDatasetRequest.h>
#include <aws/iotsitewise/model/DescribeDatasetResult.h>
#include <aws/iotsitewise/model/DescribeDefaultEncryptionConfigurationRequest.h>
#include <aws/iotsitewise/model/DescribeDefaultEncryptionConfigurationResult.h>
#include <aws/iotsitewise/model/DescribeGatewayCapabilityConfigurationRequest.h>
#include <aws/iotsitewise/model/DescribeGatewayCapabilityConfigurationResult.h>
#include <aws/iotsitewise/model/DescribeGatewayRequest.h>
#include <aws/iotsitewise/model/DescribeGatewayResult.h>
#include <aws/iotsitewise/model/DescribeLoggingOptionsRequest.h>
#include <aws/iotsitewise/model/DescribeLoggingOptionsResult.h>
#include <aws/iotsitewise/model/DescribePortalRequest.h>
#include <aws/iotsitewise/model/DescribePortalResult.h>
#include <aws/iotsitewise/model/DescribeProjectRequest.h>
#include <aws/iotsitewise/model/DescribeProjectResult.h>
#include <aws/iotsitewise/model/DescribeStorageConfigurationRequest.h>
#include <aws/iotsitewise/model/DescribeStorageConfigurationResult.h>
#include <aws/iotsitewise/model/DescribeTimeSeriesRequest.h>
#include <aws/iotsitewise/model/DescribeTimeSeriesResult.h>
#include <aws/iotsitewise/model/DetailedError.h>
#include <aws/iotsitewise/model/DetailedErrorCode.h>
#include <aws/iotsitewise/model/DisassociateAssetsRequest.h>
#include <aws/iotsitewise/model/DisassociateTimeSeriesFromAssetPropertyRequest.h>
#include <aws/iotsitewise/model/DisassociatedDataStorageState.h>
#include <aws/iotsitewise/model/EncryptionType.h>
#include <aws/iotsitewise/model/ErrorCode.h>
#include <aws/iotsitewise/model/ErrorDetails.h>
#include <aws/iotsitewise/model/ErrorReportLocation.h>
#include <aws/iotsitewise/model/ExecuteActionRequest.h>
#include <aws/iotsitewise/model/ExecuteActionResult.h>
#include <aws/iotsitewise/model/ExecuteQueryRequest.h>
#include <aws/iotsitewise/model/ExecuteQueryResult.h>
#include <aws/iotsitewise/model/ExpressionVariable.h>
#include <aws/iotsitewise/model/File.h>
#include <aws/iotsitewise/model/FileFormat.h>
#include <aws/iotsitewise/model/ForwardingConfig.h>
#include <aws/iotsitewise/model/ForwardingConfigState.h>
#include <aws/iotsitewise/model/GatewayCapabilitySummary.h>
#include <aws/iotsitewise/model/GatewayPlatform.h>
#include <aws/iotsitewise/model/GatewaySummary.h>
#include <aws/iotsitewise/model/GetAssetPropertyAggregatesRequest.h>
#include <aws/iotsitewise/model/GetAssetPropertyAggregatesResult.h>
#include <aws/iotsitewise/model/GetAssetPropertyValueHistoryRequest.h>
#include <aws/iotsitewise/model/GetAssetPropertyValueHistoryResult.h>
#include <aws/iotsitewise/model/GetAssetPropertyValueRequest.h>
#include <aws/iotsitewise/model/GetAssetPropertyValueResult.h>
#include <aws/iotsitewise/model/GetInterpolatedAssetPropertyValuesRequest.h>
#include <aws/iotsitewise/model/GetInterpolatedAssetPropertyValuesResult.h>
#include <aws/iotsitewise/model/Greengrass.h>
#include <aws/iotsitewise/model/GreengrassV2.h>
#include <aws/iotsitewise/model/GroupIdentity.h>
#include <aws/iotsitewise/model/IAMRoleIdentity.h>
#include <aws/iotsitewise/model/IAMUserIdentity.h>
#include <aws/iotsitewise/model/Identity.h>
#include <aws/iotsitewise/model/IdentityType.h>
#include <aws/iotsitewise/model/Image.h>
#include <aws/iotsitewise/model/ImageFile.h>
#include <aws/iotsitewise/model/ImageFileType.h>
#include <aws/iotsitewise/model/ImageLocation.h>
#include <aws/iotsitewise/model/InterpolatedAssetPropertyValue.h>
#include <aws/iotsitewise/model/InvocationOutput.h>
#include <aws/iotsitewise/model/InvokeAssistantHandler.h>
#include <aws/iotsitewise/model/InvokeAssistantInitialResponse.h>
#include <aws/iotsitewise/model/InvokeAssistantRequest.h>
#include <aws/iotsitewise/model/JobConfiguration.h>
#include <aws/iotsitewise/model/JobStatus.h>
#include <aws/iotsitewise/model/JobSummary.h>
#include <aws/iotsitewise/model/KendraSourceDetail.h>
#include <aws/iotsitewise/model/ListAccessPoliciesRequest.h>
#include <aws/iotsitewise/model/ListAccessPoliciesResult.h>
#include <aws/iotsitewise/model/ListActionsRequest.h>
#include <aws/iotsitewise/model/ListActionsResult.h>
#include <aws/iotsitewise/model/ListAssetModelCompositeModelsRequest.h>
#include <aws/iotsitewise/model/ListAssetModelCompositeModelsResult.h>
#include <aws/iotsitewise/model/ListAssetModelPropertiesFilter.h>
#include <aws/iotsitewise/model/ListAssetModelPropertiesRequest.h>
#include <aws/iotsitewise/model/ListAssetModelPropertiesResult.h>
#include <aws/iotsitewise/model/ListAssetModelsRequest.h>
#include <aws/iotsitewise/model/ListAssetModelsResult.h>
#include <aws/iotsitewise/model/ListAssetPropertiesFilter.h>
#include <aws/iotsitewise/model/ListAssetPropertiesRequest.h>
#include <aws/iotsitewise/model/ListAssetPropertiesResult.h>
#include <aws/iotsitewise/model/ListAssetRelationshipsRequest.h>
#include <aws/iotsitewise/model/ListAssetRelationshipsResult.h>
#include <aws/iotsitewise/model/ListAssetsFilter.h>
#include <aws/iotsitewise/model/ListAssetsRequest.h>
#include <aws/iotsitewise/model/ListAssetsResult.h>
#include <aws/iotsitewise/model/ListAssociatedAssetsRequest.h>
#include <aws/iotsitewise/model/ListAssociatedAssetsResult.h>
#include <aws/iotsitewise/model/ListBulkImportJobsFilter.h>
#include <aws/iotsitewise/model/ListBulkImportJobsRequest.h>
#include <aws/iotsitewise/model/ListBulkImportJobsResult.h>
#include <aws/iotsitewise/model/ListCompositionRelationshipsRequest.h>
#include <aws/iotsitewise/model/ListCompositionRelationshipsResult.h>
#include <aws/iotsitewise/model/ListDashboardsRequest.h>
#include <aws/iotsitewise/model/ListDashboardsResult.h>
#include <aws/iotsitewise/model/ListDatasetsRequest.h>
#include <aws/iotsitewise/model/ListDatasetsResult.h>
#include <aws/iotsitewise/model/ListGatewaysRequest.h>
#include <aws/iotsitewise/model/ListGatewaysResult.h>
#include <aws/iotsitewise/model/ListPortalsRequest.h>
#include <aws/iotsitewise/model/ListPortalsResult.h>
#include <aws/iotsitewise/model/ListProjectAssetsRequest.h>
#include <aws/iotsitewise/model/ListProjectAssetsResult.h>
#include <aws/iotsitewise/model/ListProjectsRequest.h>
#include <aws/iotsitewise/model/ListProjectsResult.h>
#include <aws/iotsitewise/model/ListTagsForResourceRequest.h>
#include <aws/iotsitewise/model/ListTagsForResourceResult.h>
#include <aws/iotsitewise/model/ListTimeSeriesRequest.h>
#include <aws/iotsitewise/model/ListTimeSeriesResult.h>
#include <aws/iotsitewise/model/ListTimeSeriesType.h>
#include <aws/iotsitewise/model/Location.h>
#include <aws/iotsitewise/model/LoggingLevel.h>
#include <aws/iotsitewise/model/LoggingOptions.h>
#include <aws/iotsitewise/model/Measurement.h>
#include <aws/iotsitewise/model/MeasurementProcessingConfig.h>
#include <aws/iotsitewise/model/Metric.h>
#include <aws/iotsitewise/model/MetricProcessingConfig.h>
#include <aws/iotsitewise/model/MetricWindow.h>
#include <aws/iotsitewise/model/MonitorErrorCode.h>
#include <aws/iotsitewise/model/MonitorErrorDetails.h>
#include <aws/iotsitewise/model/MultiLayerStorage.h>
#include <aws/iotsitewise/model/Parquet.h>
#include <aws/iotsitewise/model/Permission.h>
#include <aws/iotsitewise/model/PortalResource.h>
#include <aws/iotsitewise/model/PortalState.h>
#include <aws/iotsitewise/model/PortalStatus.h>
#include <aws/iotsitewise/model/PortalSummary.h>
#include <aws/iotsitewise/model/PortalType.h>
#include <aws/iotsitewise/model/PortalTypeEntry.h>
#include <aws/iotsitewise/model/PreconditionFailedException.h>
#include <aws/iotsitewise/model/ProjectResource.h>
#include <aws/iotsitewise/model/ProjectSummary.h>
#include <aws/iotsitewise/model/Property.h>
#include <aws/iotsitewise/model/PropertyDataType.h>
#include <aws/iotsitewise/model/PropertyNotification.h>
#include <aws/iotsitewise/model/PropertyNotificationState.h>
#include <aws/iotsitewise/model/PropertyType.h>
#include <aws/iotsitewise/model/PropertyValueNullValue.h>
#include <aws/iotsitewise/model/PutAssetPropertyValueEntry.h>
#include <aws/iotsitewise/model/PutDefaultEncryptionConfigurationRequest.h>
#include <aws/iotsitewise/model/PutDefaultEncryptionConfigurationResult.h>
#include <aws/iotsitewise/model/PutLoggingOptionsRequest.h>
#include <aws/iotsitewise/model/PutLoggingOptionsResult.h>
#include <aws/iotsitewise/model/PutStorageConfigurationRequest.h>
#include <aws/iotsitewise/model/PutStorageConfigurationResult.h>
#include <aws/iotsitewise/model/Quality.h>
#include <aws/iotsitewise/model/RawValueType.h>
#include <aws/iotsitewise/model/Reference.h>
#include <aws/iotsitewise/model/Resource.h>
#include <aws/iotsitewise/model/ResourceAlreadyExistsException.h>
#include <aws/iotsitewise/model/ResourceType.h>
#include <aws/iotsitewise/model/ResponseStream.h>
#include <aws/iotsitewise/model/RetentionPeriod.h>
#include <aws/iotsitewise/model/Row.h>
#include <aws/iotsitewise/model/ScalarType.h>
#include <aws/iotsitewise/model/SiemensIE.h>
#include <aws/iotsitewise/model/Source.h>
#include <aws/iotsitewise/model/SourceDetail.h>
#include <aws/iotsitewise/model/StorageType.h>
#include <aws/iotsitewise/model/TagResourceRequest.h>
#include <aws/iotsitewise/model/TagResourceResult.h>
#include <aws/iotsitewise/model/TargetResource.h>
#include <aws/iotsitewise/model/TargetResourceType.h>
#include <aws/iotsitewise/model/TimeInNanos.h>
#include <aws/iotsitewise/model/TimeOrdering.h>
#include <aws/iotsitewise/model/TimeSeriesSummary.h>
#include <aws/iotsitewise/model/TooManyTagsException.h>
#include <aws/iotsitewise/model/Trace.h>
#include <aws/iotsitewise/model/Transform.h>
#include <aws/iotsitewise/model/TransformProcessingConfig.h>
#include <aws/iotsitewise/model/TraversalDirection.h>
#include <aws/iotsitewise/model/TraversalType.h>
#include <aws/iotsitewise/model/TumblingWindow.h>
#include <aws/iotsitewise/model/UntagResourceRequest.h>
#include <aws/iotsitewise/model/UntagResourceResult.h>
#include <aws/iotsitewise/model/UpdateAccessPolicyRequest.h>
#include <aws/iotsitewise/model/UpdateAccessPolicyResult.h>
#include <aws/iotsitewise/model/UpdateAssetModelCompositeModelRequest.h>
#include <aws/iotsitewise/model/UpdateAssetModelCompositeModelResult.h>
#include <aws/iotsitewise/model/UpdateAssetModelRequest.h>
#include <aws/iotsitewise/model/UpdateAssetModelResult.h>
#include <aws/iotsitewise/model/UpdateAssetPropertyRequest.h>
#include <aws/iotsitewise/model/UpdateAssetRequest.h>
#include <aws/iotsitewise/model/UpdateAssetResult.h>
#include <aws/iotsitewise/model/UpdateDashboardRequest.h>
#include <aws/iotsitewise/model/UpdateDashboardResult.h>
#include <aws/iotsitewise/model/UpdateDatasetRequest.h>
#include <aws/iotsitewise/model/UpdateDatasetResult.h>
#include <aws/iotsitewise/model/UpdateGatewayCapabilityConfigurationRequest.h>
#include <aws/iotsitewise/model/UpdateGatewayCapabilityConfigurationResult.h>
#include <aws/iotsitewise/model/UpdateGatewayRequest.h>
#include <aws/iotsitewise/model/UpdatePortalRequest.h>
#include <aws/iotsitewise/model/UpdatePortalResult.h>
#include <aws/iotsitewise/model/UpdateProjectRequest.h>
#include <aws/iotsitewise/model/UpdateProjectResult.h>
#include <aws/iotsitewise/model/UserIdentity.h>
#include <aws/iotsitewise/model/VariableValue.h>
#include <aws/iotsitewise/model/Variant.h>
#include <aws/iotsitewise/model/WarmTierRetentionPeriod.h>
#include <aws/iotsitewise/model/WarmTierState.h>

using IoTSiteWiseIncludeTest = ::testing::Test;

TEST_F(IoTSiteWiseIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::IoTSiteWise::IoTSiteWiseClient>("IoTSiteWiseIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
