/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/iottwinmaker/IoTTwinMakerClient.h>
#include <aws/iottwinmaker/IoTTwinMakerEndpointProvider.h>
#include <aws/iottwinmaker/IoTTwinMakerEndpointRules.h>
#include <aws/iottwinmaker/IoTTwinMakerErrorMarshaller.h>
#include <aws/iottwinmaker/IoTTwinMakerErrors.h>
#include <aws/iottwinmaker/IoTTwinMakerRequest.h>
#include <aws/iottwinmaker/IoTTwinMakerServiceClientModel.h>
#include <aws/iottwinmaker/IoTTwinMaker_EXPORTS.h>
#include <aws/iottwinmaker/model/BatchPutPropertyError.h>
#include <aws/iottwinmaker/model/BatchPutPropertyErrorEntry.h>
#include <aws/iottwinmaker/model/BatchPutPropertyValuesRequest.h>
#include <aws/iottwinmaker/model/BatchPutPropertyValuesResult.h>
#include <aws/iottwinmaker/model/BundleInformation.h>
#include <aws/iottwinmaker/model/CancelMetadataTransferJobRequest.h>
#include <aws/iottwinmaker/model/CancelMetadataTransferJobResult.h>
#include <aws/iottwinmaker/model/ColumnDescription.h>
#include <aws/iottwinmaker/model/ColumnType.h>
#include <aws/iottwinmaker/model/ComponentPropertyGroupRequest.h>
#include <aws/iottwinmaker/model/ComponentPropertyGroupResponse.h>
#include <aws/iottwinmaker/model/ComponentRequest.h>
#include <aws/iottwinmaker/model/ComponentResponse.h>
#include <aws/iottwinmaker/model/ComponentSummary.h>
#include <aws/iottwinmaker/model/ComponentTypeSummary.h>
#include <aws/iottwinmaker/model/ComponentUpdateRequest.h>
#include <aws/iottwinmaker/model/ComponentUpdateType.h>
#include <aws/iottwinmaker/model/CompositeComponentRequest.h>
#include <aws/iottwinmaker/model/CompositeComponentTypeRequest.h>
#include <aws/iottwinmaker/model/CompositeComponentTypeResponse.h>
#include <aws/iottwinmaker/model/CompositeComponentUpdateRequest.h>
#include <aws/iottwinmaker/model/CreateComponentTypeRequest.h>
#include <aws/iottwinmaker/model/CreateComponentTypeResult.h>
#include <aws/iottwinmaker/model/CreateEntityRequest.h>
#include <aws/iottwinmaker/model/CreateEntityResult.h>
#include <aws/iottwinmaker/model/CreateMetadataTransferJobRequest.h>
#include <aws/iottwinmaker/model/CreateMetadataTransferJobResult.h>
#include <aws/iottwinmaker/model/CreateSceneRequest.h>
#include <aws/iottwinmaker/model/CreateSceneResult.h>
#include <aws/iottwinmaker/model/CreateSyncJobRequest.h>
#include <aws/iottwinmaker/model/CreateSyncJobResult.h>
#include <aws/iottwinmaker/model/CreateWorkspaceRequest.h>
#include <aws/iottwinmaker/model/CreateWorkspaceResult.h>
#include <aws/iottwinmaker/model/DataConnector.h>
#include <aws/iottwinmaker/model/DataType.h>
#include <aws/iottwinmaker/model/DataValue.h>
#include <aws/iottwinmaker/model/DeleteComponentTypeRequest.h>
#include <aws/iottwinmaker/model/DeleteComponentTypeResult.h>
#include <aws/iottwinmaker/model/DeleteEntityRequest.h>
#include <aws/iottwinmaker/model/DeleteEntityResult.h>
#include <aws/iottwinmaker/model/DeleteSceneRequest.h>
#include <aws/iottwinmaker/model/DeleteSceneResult.h>
#include <aws/iottwinmaker/model/DeleteSyncJobRequest.h>
#include <aws/iottwinmaker/model/DeleteSyncJobResult.h>
#include <aws/iottwinmaker/model/DeleteWorkspaceRequest.h>
#include <aws/iottwinmaker/model/DeleteWorkspaceResult.h>
#include <aws/iottwinmaker/model/DestinationConfiguration.h>
#include <aws/iottwinmaker/model/DestinationType.h>
#include <aws/iottwinmaker/model/EntityPropertyReference.h>
#include <aws/iottwinmaker/model/EntitySummary.h>
#include <aws/iottwinmaker/model/ErrorCode.h>
#include <aws/iottwinmaker/model/ErrorDetails.h>
#include <aws/iottwinmaker/model/ExecuteQueryRequest.h>
#include <aws/iottwinmaker/model/ExecuteQueryResult.h>
#include <aws/iottwinmaker/model/FilterByAsset.h>
#include <aws/iottwinmaker/model/FilterByAssetModel.h>
#include <aws/iottwinmaker/model/FilterByComponentType.h>
#include <aws/iottwinmaker/model/FilterByEntity.h>
#include <aws/iottwinmaker/model/FunctionRequest.h>
#include <aws/iottwinmaker/model/FunctionResponse.h>
#include <aws/iottwinmaker/model/GetComponentTypeRequest.h>
#include <aws/iottwinmaker/model/GetComponentTypeResult.h>
#include <aws/iottwinmaker/model/GetEntityRequest.h>
#include <aws/iottwinmaker/model/GetEntityResult.h>
#include <aws/iottwinmaker/model/GetMetadataTransferJobRequest.h>
#include <aws/iottwinmaker/model/GetMetadataTransferJobResult.h>
#include <aws/iottwinmaker/model/GetPricingPlanRequest.h>
#include <aws/iottwinmaker/model/GetPricingPlanResult.h>
#include <aws/iottwinmaker/model/GetPropertyValueHistoryRequest.h>
#include <aws/iottwinmaker/model/GetPropertyValueHistoryResult.h>
#include <aws/iottwinmaker/model/GetPropertyValueRequest.h>
#include <aws/iottwinmaker/model/GetPropertyValueResult.h>
#include <aws/iottwinmaker/model/GetSceneRequest.h>
#include <aws/iottwinmaker/model/GetSceneResult.h>
#include <aws/iottwinmaker/model/GetSyncJobRequest.h>
#include <aws/iottwinmaker/model/GetSyncJobResult.h>
#include <aws/iottwinmaker/model/GetWorkspaceRequest.h>
#include <aws/iottwinmaker/model/GetWorkspaceResult.h>
#include <aws/iottwinmaker/model/GroupType.h>
#include <aws/iottwinmaker/model/InterpolationParameters.h>
#include <aws/iottwinmaker/model/InterpolationType.h>
#include <aws/iottwinmaker/model/IotSiteWiseSourceConfiguration.h>
#include <aws/iottwinmaker/model/IotSiteWiseSourceConfigurationFilter.h>
#include <aws/iottwinmaker/model/IotTwinMakerDestinationConfiguration.h>
#include <aws/iottwinmaker/model/IotTwinMakerSourceConfiguration.h>
#include <aws/iottwinmaker/model/IotTwinMakerSourceConfigurationFilter.h>
#include <aws/iottwinmaker/model/LambdaFunction.h>
#include <aws/iottwinmaker/model/ListComponentTypesFilter.h>
#include <aws/iottwinmaker/model/ListComponentTypesRequest.h>
#include <aws/iottwinmaker/model/ListComponentTypesResult.h>
#include <aws/iottwinmaker/model/ListComponentsRequest.h>
#include <aws/iottwinmaker/model/ListComponentsResult.h>
#include <aws/iottwinmaker/model/ListEntitiesFilter.h>
#include <aws/iottwinmaker/model/ListEntitiesRequest.h>
#include <aws/iottwinmaker/model/ListEntitiesResult.h>
#include <aws/iottwinmaker/model/ListMetadataTransferJobsFilter.h>
#include <aws/iottwinmaker/model/ListMetadataTransferJobsRequest.h>
#include <aws/iottwinmaker/model/ListMetadataTransferJobsResult.h>
#include <aws/iottwinmaker/model/ListPropertiesRequest.h>
#include <aws/iottwinmaker/model/ListPropertiesResult.h>
#include <aws/iottwinmaker/model/ListScenesRequest.h>
#include <aws/iottwinmaker/model/ListScenesResult.h>
#include <aws/iottwinmaker/model/ListSyncJobsRequest.h>
#include <aws/iottwinmaker/model/ListSyncJobsResult.h>
#include <aws/iottwinmaker/model/ListSyncResourcesRequest.h>
#include <aws/iottwinmaker/model/ListSyncResourcesResult.h>
#include <aws/iottwinmaker/model/ListTagsForResourceRequest.h>
#include <aws/iottwinmaker/model/ListTagsForResourceResult.h>
#include <aws/iottwinmaker/model/ListWorkspacesRequest.h>
#include <aws/iottwinmaker/model/ListWorkspacesResult.h>
#include <aws/iottwinmaker/model/MetadataTransferJobProgress.h>
#include <aws/iottwinmaker/model/MetadataTransferJobState.h>
#include <aws/iottwinmaker/model/MetadataTransferJobStatus.h>
#include <aws/iottwinmaker/model/MetadataTransferJobSummary.h>
#include <aws/iottwinmaker/model/Order.h>
#include <aws/iottwinmaker/model/OrderBy.h>
#include <aws/iottwinmaker/model/OrderByTime.h>
#include <aws/iottwinmaker/model/ParentEntityUpdateRequest.h>
#include <aws/iottwinmaker/model/ParentEntityUpdateType.h>
#include <aws/iottwinmaker/model/PricingMode.h>
#include <aws/iottwinmaker/model/PricingPlan.h>
#include <aws/iottwinmaker/model/PricingTier.h>
#include <aws/iottwinmaker/model/PropertyDefinitionRequest.h>
#include <aws/iottwinmaker/model/PropertyDefinitionResponse.h>
#include <aws/iottwinmaker/model/PropertyFilter.h>
#include <aws/iottwinmaker/model/PropertyGroupRequest.h>
#include <aws/iottwinmaker/model/PropertyGroupResponse.h>
#include <aws/iottwinmaker/model/PropertyGroupUpdateType.h>
#include <aws/iottwinmaker/model/PropertyLatestValue.h>
#include <aws/iottwinmaker/model/PropertyRequest.h>
#include <aws/iottwinmaker/model/PropertyResponse.h>
#include <aws/iottwinmaker/model/PropertySummary.h>
#include <aws/iottwinmaker/model/PropertyUpdateType.h>
#include <aws/iottwinmaker/model/PropertyValue.h>
#include <aws/iottwinmaker/model/PropertyValueEntry.h>
#include <aws/iottwinmaker/model/PropertyValueHistory.h>
#include <aws/iottwinmaker/model/Relationship.h>
#include <aws/iottwinmaker/model/RelationshipValue.h>
#include <aws/iottwinmaker/model/Row.h>
#include <aws/iottwinmaker/model/S3DestinationConfiguration.h>
#include <aws/iottwinmaker/model/S3SourceConfiguration.h>
#include <aws/iottwinmaker/model/SceneError.h>
#include <aws/iottwinmaker/model/SceneErrorCode.h>
#include <aws/iottwinmaker/model/SceneSummary.h>
#include <aws/iottwinmaker/model/Scope.h>
#include <aws/iottwinmaker/model/SourceConfiguration.h>
#include <aws/iottwinmaker/model/SourceType.h>
#include <aws/iottwinmaker/model/State.h>
#include <aws/iottwinmaker/model/Status.h>
#include <aws/iottwinmaker/model/SyncJobState.h>
#include <aws/iottwinmaker/model/SyncJobStatus.h>
#include <aws/iottwinmaker/model/SyncJobSummary.h>
#include <aws/iottwinmaker/model/SyncResourceFilter.h>
#include <aws/iottwinmaker/model/SyncResourceState.h>
#include <aws/iottwinmaker/model/SyncResourceStatus.h>
#include <aws/iottwinmaker/model/SyncResourceSummary.h>
#include <aws/iottwinmaker/model/SyncResourceType.h>
#include <aws/iottwinmaker/model/TabularConditions.h>
#include <aws/iottwinmaker/model/TagResourceRequest.h>
#include <aws/iottwinmaker/model/TagResourceResult.h>
#include <aws/iottwinmaker/model/Type.h>
#include <aws/iottwinmaker/model/UntagResourceRequest.h>
#include <aws/iottwinmaker/model/UntagResourceResult.h>
#include <aws/iottwinmaker/model/UpdateComponentTypeRequest.h>
#include <aws/iottwinmaker/model/UpdateComponentTypeResult.h>
#include <aws/iottwinmaker/model/UpdateEntityRequest.h>
#include <aws/iottwinmaker/model/UpdateEntityResult.h>
#include <aws/iottwinmaker/model/UpdatePricingPlanRequest.h>
#include <aws/iottwinmaker/model/UpdatePricingPlanResult.h>
#include <aws/iottwinmaker/model/UpdateReason.h>
#include <aws/iottwinmaker/model/UpdateSceneRequest.h>
#include <aws/iottwinmaker/model/UpdateSceneResult.h>
#include <aws/iottwinmaker/model/UpdateWorkspaceRequest.h>
#include <aws/iottwinmaker/model/UpdateWorkspaceResult.h>
#include <aws/iottwinmaker/model/WorkspaceSummary.h>

using IoTTwinMakerIncludeTest = ::testing::Test;

TEST_F(IoTTwinMakerIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::IoTTwinMaker::IoTTwinMakerClient>("IoTTwinMakerIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
