/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/iotwireless/IoTWirelessClient.h>
#include <aws/iotwireless/IoTWirelessEndpointProvider.h>
#include <aws/iotwireless/IoTWirelessEndpointRules.h>
#include <aws/iotwireless/IoTWirelessErrorMarshaller.h>
#include <aws/iotwireless/IoTWirelessErrors.h>
#include <aws/iotwireless/IoTWirelessRequest.h>
#include <aws/iotwireless/IoTWirelessServiceClientModel.h>
#include <aws/iotwireless/IoTWireless_EXPORTS.h>
#include <aws/iotwireless/model/AbpV1_0_x.h>
#include <aws/iotwireless/model/AbpV1_1.h>
#include <aws/iotwireless/model/Accuracy.h>
#include <aws/iotwireless/model/AggregationPeriod.h>
#include <aws/iotwireless/model/ApplicationConfig.h>
#include <aws/iotwireless/model/ApplicationConfigType.h>
#include <aws/iotwireless/model/AssociateAwsAccountWithPartnerAccountRequest.h>
#include <aws/iotwireless/model/AssociateAwsAccountWithPartnerAccountResult.h>
#include <aws/iotwireless/model/AssociateMulticastGroupWithFuotaTaskRequest.h>
#include <aws/iotwireless/model/AssociateMulticastGroupWithFuotaTaskResult.h>
#include <aws/iotwireless/model/AssociateWirelessDeviceWithFuotaTaskRequest.h>
#include <aws/iotwireless/model/AssociateWirelessDeviceWithFuotaTaskResult.h>
#include <aws/iotwireless/model/AssociateWirelessDeviceWithMulticastGroupRequest.h>
#include <aws/iotwireless/model/AssociateWirelessDeviceWithMulticastGroupResult.h>
#include <aws/iotwireless/model/AssociateWirelessDeviceWithThingRequest.h>
#include <aws/iotwireless/model/AssociateWirelessDeviceWithThingResult.h>
#include <aws/iotwireless/model/AssociateWirelessGatewayWithCertificateRequest.h>
#include <aws/iotwireless/model/AssociateWirelessGatewayWithCertificateResult.h>
#include <aws/iotwireless/model/AssociateWirelessGatewayWithThingRequest.h>
#include <aws/iotwireless/model/AssociateWirelessGatewayWithThingResult.h>
#include <aws/iotwireless/model/BatteryLevel.h>
#include <aws/iotwireless/model/Beaconing.h>
#include <aws/iotwireless/model/CancelMulticastGroupSessionRequest.h>
#include <aws/iotwireless/model/CancelMulticastGroupSessionResult.h>
#include <aws/iotwireless/model/CdmaLocalId.h>
#include <aws/iotwireless/model/CdmaNmrObj.h>
#include <aws/iotwireless/model/CdmaObj.h>
#include <aws/iotwireless/model/CellTowers.h>
#include <aws/iotwireless/model/CertificateList.h>
#include <aws/iotwireless/model/ConflictException.h>
#include <aws/iotwireless/model/ConnectionStatus.h>
#include <aws/iotwireless/model/ConnectionStatusEventConfiguration.h>
#include <aws/iotwireless/model/ConnectionStatusResourceTypeEventConfiguration.h>
#include <aws/iotwireless/model/CreateDestinationRequest.h>
#include <aws/iotwireless/model/CreateDestinationResult.h>
#include <aws/iotwireless/model/CreateDeviceProfileRequest.h>
#include <aws/iotwireless/model/CreateDeviceProfileResult.h>
#include <aws/iotwireless/model/CreateFuotaTaskRequest.h>
#include <aws/iotwireless/model/CreateFuotaTaskResult.h>
#include <aws/iotwireless/model/CreateMulticastGroupRequest.h>
#include <aws/iotwireless/model/CreateMulticastGroupResult.h>
#include <aws/iotwireless/model/CreateNetworkAnalyzerConfigurationRequest.h>
#include <aws/iotwireless/model/CreateNetworkAnalyzerConfigurationResult.h>
#include <aws/iotwireless/model/CreateServiceProfileRequest.h>
#include <aws/iotwireless/model/CreateServiceProfileResult.h>
#include <aws/iotwireless/model/CreateWirelessDeviceRequest.h>
#include <aws/iotwireless/model/CreateWirelessDeviceResult.h>
#include <aws/iotwireless/model/CreateWirelessGatewayRequest.h>
#include <aws/iotwireless/model/CreateWirelessGatewayResult.h>
#include <aws/iotwireless/model/CreateWirelessGatewayTaskDefinitionRequest.h>
#include <aws/iotwireless/model/CreateWirelessGatewayTaskDefinitionResult.h>
#include <aws/iotwireless/model/CreateWirelessGatewayTaskRequest.h>
#include <aws/iotwireless/model/CreateWirelessGatewayTaskResult.h>
#include <aws/iotwireless/model/DakCertificateMetadata.h>
#include <aws/iotwireless/model/DeleteDestinationRequest.h>
#include <aws/iotwireless/model/DeleteDestinationResult.h>
#include <aws/iotwireless/model/DeleteDeviceProfileRequest.h>
#include <aws/iotwireless/model/DeleteDeviceProfileResult.h>
#include <aws/iotwireless/model/DeleteFuotaTaskRequest.h>
#include <aws/iotwireless/model/DeleteFuotaTaskResult.h>
#include <aws/iotwireless/model/DeleteMulticastGroupRequest.h>
#include <aws/iotwireless/model/DeleteMulticastGroupResult.h>
#include <aws/iotwireless/model/DeleteNetworkAnalyzerConfigurationRequest.h>
#include <aws/iotwireless/model/DeleteNetworkAnalyzerConfigurationResult.h>
#include <aws/iotwireless/model/DeleteQueuedMessagesRequest.h>
#include <aws/iotwireless/model/DeleteQueuedMessagesResult.h>
#include <aws/iotwireless/model/DeleteServiceProfileRequest.h>
#include <aws/iotwireless/model/DeleteServiceProfileResult.h>
#include <aws/iotwireless/model/DeleteWirelessDeviceImportTaskRequest.h>
#include <aws/iotwireless/model/DeleteWirelessDeviceImportTaskResult.h>
#include <aws/iotwireless/model/DeleteWirelessDeviceRequest.h>
#include <aws/iotwireless/model/DeleteWirelessDeviceResult.h>
#include <aws/iotwireless/model/DeleteWirelessGatewayRequest.h>
#include <aws/iotwireless/model/DeleteWirelessGatewayResult.h>
#include <aws/iotwireless/model/DeleteWirelessGatewayTaskDefinitionRequest.h>
#include <aws/iotwireless/model/DeleteWirelessGatewayTaskDefinitionResult.h>
#include <aws/iotwireless/model/DeleteWirelessGatewayTaskRequest.h>
#include <aws/iotwireless/model/DeleteWirelessGatewayTaskResult.h>
#include <aws/iotwireless/model/DeregisterWirelessDeviceRequest.h>
#include <aws/iotwireless/model/DeregisterWirelessDeviceResult.h>
#include <aws/iotwireless/model/Destinations.h>
#include <aws/iotwireless/model/DeviceProfile.h>
#include <aws/iotwireless/model/DeviceProfileType.h>
#include <aws/iotwireless/model/DeviceRegistrationStateEventConfiguration.h>
#include <aws/iotwireless/model/DeviceRegistrationStateResourceTypeEventConfiguration.h>
#include <aws/iotwireless/model/DeviceState.h>
#include <aws/iotwireless/model/Dimension.h>
#include <aws/iotwireless/model/DimensionName.h>
#include <aws/iotwireless/model/DisassociateAwsAccountFromPartnerAccountRequest.h>
#include <aws/iotwireless/model/DisassociateAwsAccountFromPartnerAccountResult.h>
#include <aws/iotwireless/model/DisassociateMulticastGroupFromFuotaTaskRequest.h>
#include <aws/iotwireless/model/DisassociateMulticastGroupFromFuotaTaskResult.h>
#include <aws/iotwireless/model/DisassociateWirelessDeviceFromFuotaTaskRequest.h>
#include <aws/iotwireless/model/DisassociateWirelessDeviceFromFuotaTaskResult.h>
#include <aws/iotwireless/model/DisassociateWirelessDeviceFromMulticastGroupRequest.h>
#include <aws/iotwireless/model/DisassociateWirelessDeviceFromMulticastGroupResult.h>
#include <aws/iotwireless/model/DisassociateWirelessDeviceFromThingRequest.h>
#include <aws/iotwireless/model/DisassociateWirelessDeviceFromThingResult.h>
#include <aws/iotwireless/model/DisassociateWirelessGatewayFromCertificateRequest.h>
#include <aws/iotwireless/model/DisassociateWirelessGatewayFromCertificateResult.h>
#include <aws/iotwireless/model/DisassociateWirelessGatewayFromThingRequest.h>
#include <aws/iotwireless/model/DisassociateWirelessGatewayFromThingResult.h>
#include <aws/iotwireless/model/DlClass.h>
#include <aws/iotwireless/model/DownlinkMode.h>
#include <aws/iotwireless/model/DownlinkQueueMessage.h>
#include <aws/iotwireless/model/Event.h>
#include <aws/iotwireless/model/EventConfigurationItem.h>
#include <aws/iotwireless/model/EventNotificationItemConfigurations.h>
#include <aws/iotwireless/model/EventNotificationPartnerType.h>
#include <aws/iotwireless/model/EventNotificationResourceType.h>
#include <aws/iotwireless/model/EventNotificationTopicStatus.h>
#include <aws/iotwireless/model/ExpressionType.h>
#include <aws/iotwireless/model/FPorts.h>
#include <aws/iotwireless/model/FuotaDeviceStatus.h>
#include <aws/iotwireless/model/FuotaTask.h>
#include <aws/iotwireless/model/FuotaTaskEvent.h>
#include <aws/iotwireless/model/FuotaTaskEventLogOption.h>
#include <aws/iotwireless/model/FuotaTaskLogOption.h>
#include <aws/iotwireless/model/FuotaTaskStatus.h>
#include <aws/iotwireless/model/FuotaTaskType.h>
#include <aws/iotwireless/model/GatewayListItem.h>
#include <aws/iotwireless/model/GetDestinationRequest.h>
#include <aws/iotwireless/model/GetDestinationResult.h>
#include <aws/iotwireless/model/GetDeviceProfileRequest.h>
#include <aws/iotwireless/model/GetDeviceProfileResult.h>
#include <aws/iotwireless/model/GetEventConfigurationByResourceTypesRequest.h>
#include <aws/iotwireless/model/GetEventConfigurationByResourceTypesResult.h>
#include <aws/iotwireless/model/GetFuotaTaskRequest.h>
#include <aws/iotwireless/model/GetFuotaTaskResult.h>
#include <aws/iotwireless/model/GetLogLevelsByResourceTypesRequest.h>
#include <aws/iotwireless/model/GetLogLevelsByResourceTypesResult.h>
#include <aws/iotwireless/model/GetMetricConfigurationRequest.h>
#include <aws/iotwireless/model/GetMetricConfigurationResult.h>
#include <aws/iotwireless/model/GetMetricsRequest.h>
#include <aws/iotwireless/model/GetMetricsResult.h>
#include <aws/iotwireless/model/GetMulticastGroupRequest.h>
#include <aws/iotwireless/model/GetMulticastGroupResult.h>
#include <aws/iotwireless/model/GetMulticastGroupSessionRequest.h>
#include <aws/iotwireless/model/GetMulticastGroupSessionResult.h>
#include <aws/iotwireless/model/GetNetworkAnalyzerConfigurationRequest.h>
#include <aws/iotwireless/model/GetNetworkAnalyzerConfigurationResult.h>
#include <aws/iotwireless/model/GetPartnerAccountRequest.h>
#include <aws/iotwireless/model/GetPartnerAccountResult.h>
#include <aws/iotwireless/model/GetPositionEstimateRequest.h>
#include <aws/iotwireless/model/GetPositionEstimateResult.h>
#include <aws/iotwireless/model/GetResourceEventConfigurationRequest.h>
#include <aws/iotwireless/model/GetResourceEventConfigurationResult.h>
#include <aws/iotwireless/model/GetResourceLogLevelRequest.h>
#include <aws/iotwireless/model/GetResourceLogLevelResult.h>
#include <aws/iotwireless/model/GetResourcePositionRequest.h>
#include <aws/iotwireless/model/GetResourcePositionResult.h>
#include <aws/iotwireless/model/GetServiceEndpointRequest.h>
#include <aws/iotwireless/model/GetServiceEndpointResult.h>
#include <aws/iotwireless/model/GetServiceProfileRequest.h>
#include <aws/iotwireless/model/GetServiceProfileResult.h>
#include <aws/iotwireless/model/GetWirelessDeviceImportTaskRequest.h>
#include <aws/iotwireless/model/GetWirelessDeviceImportTaskResult.h>
#include <aws/iotwireless/model/GetWirelessDeviceRequest.h>
#include <aws/iotwireless/model/GetWirelessDeviceResult.h>
#include <aws/iotwireless/model/GetWirelessDeviceStatisticsRequest.h>
#include <aws/iotwireless/model/GetWirelessDeviceStatisticsResult.h>
#include <aws/iotwireless/model/GetWirelessGatewayCertificateRequest.h>
#include <aws/iotwireless/model/GetWirelessGatewayCertificateResult.h>
#include <aws/iotwireless/model/GetWirelessGatewayFirmwareInformationRequest.h>
#include <aws/iotwireless/model/GetWirelessGatewayFirmwareInformationResult.h>
#include <aws/iotwireless/model/GetWirelessGatewayRequest.h>
#include <aws/iotwireless/model/GetWirelessGatewayResult.h>
#include <aws/iotwireless/model/GetWirelessGatewayStatisticsRequest.h>
#include <aws/iotwireless/model/GetWirelessGatewayStatisticsResult.h>
#include <aws/iotwireless/model/GetWirelessGatewayTaskDefinitionRequest.h>
#include <aws/iotwireless/model/GetWirelessGatewayTaskDefinitionResult.h>
#include <aws/iotwireless/model/GetWirelessGatewayTaskRequest.h>
#include <aws/iotwireless/model/GetWirelessGatewayTaskResult.h>
#include <aws/iotwireless/model/GlobalIdentity.h>
#include <aws/iotwireless/model/Gnss.h>
#include <aws/iotwireless/model/GsmLocalId.h>
#include <aws/iotwireless/model/GsmNmrObj.h>
#include <aws/iotwireless/model/GsmObj.h>
#include <aws/iotwireless/model/IdentifierType.h>
#include <aws/iotwireless/model/ImportTaskStatus.h>
#include <aws/iotwireless/model/ImportedSidewalkDevice.h>
#include <aws/iotwireless/model/ImportedWirelessDevice.h>
#include <aws/iotwireless/model/Ip.h>
#include <aws/iotwireless/model/JoinEventConfiguration.h>
#include <aws/iotwireless/model/JoinResourceTypeEventConfiguration.h>
#include <aws/iotwireless/model/ListDestinationsRequest.h>
#include <aws/iotwireless/model/ListDestinationsResult.h>
#include <aws/iotwireless/model/ListDeviceProfilesRequest.h>
#include <aws/iotwireless/model/ListDeviceProfilesResult.h>
#include <aws/iotwireless/model/ListDevicesForWirelessDeviceImportTaskRequest.h>
#include <aws/iotwireless/model/ListDevicesForWirelessDeviceImportTaskResult.h>
#include <aws/iotwireless/model/ListEventConfigurationsRequest.h>
#include <aws/iotwireless/model/ListEventConfigurationsResult.h>
#include <aws/iotwireless/model/ListFuotaTasksRequest.h>
#include <aws/iotwireless/model/ListFuotaTasksResult.h>
#include <aws/iotwireless/model/ListMulticastGroupsByFuotaTaskRequest.h>
#include <aws/iotwireless/model/ListMulticastGroupsByFuotaTaskResult.h>
#include <aws/iotwireless/model/ListMulticastGroupsRequest.h>
#include <aws/iotwireless/model/ListMulticastGroupsResult.h>
#include <aws/iotwireless/model/ListNetworkAnalyzerConfigurationsRequest.h>
#include <aws/iotwireless/model/ListNetworkAnalyzerConfigurationsResult.h>
#include <aws/iotwireless/model/ListPartnerAccountsRequest.h>
#include <aws/iotwireless/model/ListPartnerAccountsResult.h>
#include <aws/iotwireless/model/ListQueuedMessagesRequest.h>
#include <aws/iotwireless/model/ListQueuedMessagesResult.h>
#include <aws/iotwireless/model/ListServiceProfilesRequest.h>
#include <aws/iotwireless/model/ListServiceProfilesResult.h>
#include <aws/iotwireless/model/ListTagsForResourceRequest.h>
#include <aws/iotwireless/model/ListTagsForResourceResult.h>
#include <aws/iotwireless/model/ListWirelessDeviceImportTasksRequest.h>
#include <aws/iotwireless/model/ListWirelessDeviceImportTasksResult.h>
#include <aws/iotwireless/model/ListWirelessDevicesRequest.h>
#include <aws/iotwireless/model/ListWirelessDevicesResult.h>
#include <aws/iotwireless/model/ListWirelessGatewayTaskDefinitionsRequest.h>
#include <aws/iotwireless/model/ListWirelessGatewayTaskDefinitionsResult.h>
#include <aws/iotwireless/model/ListWirelessGatewaysRequest.h>
#include <aws/iotwireless/model/ListWirelessGatewaysResult.h>
#include <aws/iotwireless/model/LoRaWANConnectionStatusEventNotificationConfigurations.h>
#include <aws/iotwireless/model/LoRaWANConnectionStatusResourceTypeEventConfiguration.h>
#include <aws/iotwireless/model/LoRaWANDevice.h>
#include <aws/iotwireless/model/LoRaWANDeviceMetadata.h>
#include <aws/iotwireless/model/LoRaWANDeviceProfile.h>
#include <aws/iotwireless/model/LoRaWANFuotaTask.h>
#include <aws/iotwireless/model/LoRaWANFuotaTaskGetInfo.h>
#include <aws/iotwireless/model/LoRaWANGateway.h>
#include <aws/iotwireless/model/LoRaWANGatewayCurrentVersion.h>
#include <aws/iotwireless/model/LoRaWANGatewayMetadata.h>
#include <aws/iotwireless/model/LoRaWANGatewayVersion.h>
#include <aws/iotwireless/model/LoRaWANGetServiceProfileInfo.h>
#include <aws/iotwireless/model/LoRaWANJoinEventNotificationConfigurations.h>
#include <aws/iotwireless/model/LoRaWANJoinResourceTypeEventConfiguration.h>
#include <aws/iotwireless/model/LoRaWANListDevice.h>
#include <aws/iotwireless/model/LoRaWANMulticast.h>
#include <aws/iotwireless/model/LoRaWANMulticastGet.h>
#include <aws/iotwireless/model/LoRaWANMulticastMetadata.h>
#include <aws/iotwireless/model/LoRaWANMulticastSession.h>
#include <aws/iotwireless/model/LoRaWANPublicGatewayMetadata.h>
#include <aws/iotwireless/model/LoRaWANSendDataToDevice.h>
#include <aws/iotwireless/model/LoRaWANServiceProfile.h>
#include <aws/iotwireless/model/LoRaWANStartFuotaTask.h>
#include <aws/iotwireless/model/LoRaWANUpdateDevice.h>
#include <aws/iotwireless/model/LoRaWANUpdateGatewayTaskCreate.h>
#include <aws/iotwireless/model/LoRaWANUpdateGatewayTaskEntry.h>
#include <aws/iotwireless/model/LogLevel.h>
#include <aws/iotwireless/model/LteLocalId.h>
#include <aws/iotwireless/model/LteNmrObj.h>
#include <aws/iotwireless/model/LteObj.h>
#include <aws/iotwireless/model/MessageDeliveryStatusEventConfiguration.h>
#include <aws/iotwireless/model/MessageDeliveryStatusResourceTypeEventConfiguration.h>
#include <aws/iotwireless/model/MessageType.h>
#include <aws/iotwireless/model/MetricName.h>
#include <aws/iotwireless/model/MetricQueryStatus.h>
#include <aws/iotwireless/model/MetricQueryValue.h>
#include <aws/iotwireless/model/MulticastFrameInfo.h>
#include <aws/iotwireless/model/MulticastGroup.h>
#include <aws/iotwireless/model/MulticastGroupByFuotaTask.h>
#include <aws/iotwireless/model/MulticastWirelessMetadata.h>
#include <aws/iotwireless/model/NetworkAnalyzerConfigurations.h>
#include <aws/iotwireless/model/OnboardStatus.h>
#include <aws/iotwireless/model/OtaaV1_0_x.h>
#include <aws/iotwireless/model/OtaaV1_1.h>
#include <aws/iotwireless/model/ParticipatingGateways.h>
#include <aws/iotwireless/model/ParticipatingGatewaysMulticast.h>
#include <aws/iotwireless/model/PartnerType.h>
#include <aws/iotwireless/model/PositionConfigurationFec.h>
#include <aws/iotwireless/model/PositionConfigurationItem.h>
#include <aws/iotwireless/model/PositionConfigurationStatus.h>
#include <aws/iotwireless/model/PositionResourceType.h>
#include <aws/iotwireless/model/PositionSolverConfigurations.h>
#include <aws/iotwireless/model/PositionSolverDetails.h>
#include <aws/iotwireless/model/PositionSolverProvider.h>
#include <aws/iotwireless/model/PositionSolverType.h>
#include <aws/iotwireless/model/Positioning.h>
#include <aws/iotwireless/model/PositioningConfigStatus.h>
#include <aws/iotwireless/model/ProximityEventConfiguration.h>
#include <aws/iotwireless/model/ProximityResourceTypeEventConfiguration.h>
#include <aws/iotwireless/model/PutResourceLogLevelRequest.h>
#include <aws/iotwireless/model/PutResourceLogLevelResult.h>
#include <aws/iotwireless/model/ResetAllResourceLogLevelsRequest.h>
#include <aws/iotwireless/model/ResetAllResourceLogLevelsResult.h>
#include <aws/iotwireless/model/ResetResourceLogLevelRequest.h>
#include <aws/iotwireless/model/ResetResourceLogLevelResult.h>
#include <aws/iotwireless/model/ResourceNotFoundException.h>
#include <aws/iotwireless/model/SemtechGnssConfiguration.h>
#include <aws/iotwireless/model/SemtechGnssDetail.h>
#include <aws/iotwireless/model/SendDataToMulticastGroupRequest.h>
#include <aws/iotwireless/model/SendDataToMulticastGroupResult.h>
#include <aws/iotwireless/model/SendDataToWirelessDeviceRequest.h>
#include <aws/iotwireless/model/SendDataToWirelessDeviceResult.h>
#include <aws/iotwireless/model/ServiceProfile.h>
#include <aws/iotwireless/model/SessionKeysAbpV1_0_x.h>
#include <aws/iotwireless/model/SessionKeysAbpV1_1.h>
#include <aws/iotwireless/model/SidewalkAccountInfo.h>
#include <aws/iotwireless/model/SidewalkAccountInfoWithFingerprint.h>
#include <aws/iotwireless/model/SidewalkCreateDeviceProfile.h>
#include <aws/iotwireless/model/SidewalkCreateWirelessDevice.h>
#include <aws/iotwireless/model/SidewalkDevice.h>
#include <aws/iotwireless/model/SidewalkDeviceMetadata.h>
#include <aws/iotwireless/model/SidewalkEventNotificationConfigurations.h>
#include <aws/iotwireless/model/SidewalkGetDeviceProfile.h>
#include <aws/iotwireless/model/SidewalkGetStartImportInfo.h>
#include <aws/iotwireless/model/SidewalkListDevice.h>
#include <aws/iotwireless/model/SidewalkResourceTypeEventConfiguration.h>
#include <aws/iotwireless/model/SidewalkSendDataToDevice.h>
#include <aws/iotwireless/model/SidewalkSingleStartImportInfo.h>
#include <aws/iotwireless/model/SidewalkStartImportInfo.h>
#include <aws/iotwireless/model/SidewalkUpdateAccount.h>
#include <aws/iotwireless/model/SidewalkUpdateImportInfo.h>
#include <aws/iotwireless/model/SigningAlg.h>
#include <aws/iotwireless/model/StartBulkAssociateWirelessDeviceWithMulticastGroupRequest.h>
#include <aws/iotwireless/model/StartBulkAssociateWirelessDeviceWithMulticastGroupResult.h>
#include <aws/iotwireless/model/StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest.h>
#include <aws/iotwireless/model/StartBulkDisassociateWirelessDeviceFromMulticastGroupResult.h>
#include <aws/iotwireless/model/StartFuotaTaskRequest.h>
#include <aws/iotwireless/model/StartFuotaTaskResult.h>
#include <aws/iotwireless/model/StartMulticastGroupSessionRequest.h>
#include <aws/iotwireless/model/StartMulticastGroupSessionResult.h>
#include <aws/iotwireless/model/StartSingleWirelessDeviceImportTaskRequest.h>
#include <aws/iotwireless/model/StartSingleWirelessDeviceImportTaskResult.h>
#include <aws/iotwireless/model/StartWirelessDeviceImportTaskRequest.h>
#include <aws/iotwireless/model/StartWirelessDeviceImportTaskResult.h>
#include <aws/iotwireless/model/SummaryMetricConfiguration.h>
#include <aws/iotwireless/model/SummaryMetricConfigurationStatus.h>
#include <aws/iotwireless/model/SummaryMetricQuery.h>
#include <aws/iotwireless/model/SummaryMetricQueryResult.h>
#include <aws/iotwireless/model/SupportedRfRegion.h>
#include <aws/iotwireless/model/Tag.h>
#include <aws/iotwireless/model/TagResourceRequest.h>
#include <aws/iotwireless/model/TagResourceResult.h>
#include <aws/iotwireless/model/TdscdmaLocalId.h>
#include <aws/iotwireless/model/TdscdmaNmrObj.h>
#include <aws/iotwireless/model/TdscdmaObj.h>
#include <aws/iotwireless/model/TestWirelessDeviceRequest.h>
#include <aws/iotwireless/model/TestWirelessDeviceResult.h>
#include <aws/iotwireless/model/TooManyTagsException.h>
#include <aws/iotwireless/model/TraceContent.h>
#include <aws/iotwireless/model/UntagResourceRequest.h>
#include <aws/iotwireless/model/UntagResourceResult.h>
#include <aws/iotwireless/model/UpdateAbpV1_0_x.h>
#include <aws/iotwireless/model/UpdateAbpV1_1.h>
#include <aws/iotwireless/model/UpdateDestinationRequest.h>
#include <aws/iotwireless/model/UpdateDestinationResult.h>
#include <aws/iotwireless/model/UpdateEventConfigurationByResourceTypesRequest.h>
#include <aws/iotwireless/model/UpdateEventConfigurationByResourceTypesResult.h>
#include <aws/iotwireless/model/UpdateFPorts.h>
#include <aws/iotwireless/model/UpdateFuotaTaskRequest.h>
#include <aws/iotwireless/model/UpdateFuotaTaskResult.h>
#include <aws/iotwireless/model/UpdateLogLevelsByResourceTypesRequest.h>
#include <aws/iotwireless/model/UpdateLogLevelsByResourceTypesResult.h>
#include <aws/iotwireless/model/UpdateMetricConfigurationRequest.h>
#include <aws/iotwireless/model/UpdateMetricConfigurationResult.h>
#include <aws/iotwireless/model/UpdateMulticastGroupRequest.h>
#include <aws/iotwireless/model/UpdateMulticastGroupResult.h>
#include <aws/iotwireless/model/UpdateNetworkAnalyzerConfigurationRequest.h>
#include <aws/iotwireless/model/UpdateNetworkAnalyzerConfigurationResult.h>
#include <aws/iotwireless/model/UpdatePartnerAccountRequest.h>
#include <aws/iotwireless/model/UpdatePartnerAccountResult.h>
#include <aws/iotwireless/model/UpdateResourceEventConfigurationRequest.h>
#include <aws/iotwireless/model/UpdateResourceEventConfigurationResult.h>
#include <aws/iotwireless/model/UpdateResourcePositionRequest.h>
#include <aws/iotwireless/model/UpdateResourcePositionResult.h>
#include <aws/iotwireless/model/UpdateWirelessDeviceImportTaskRequest.h>
#include <aws/iotwireless/model/UpdateWirelessDeviceImportTaskResult.h>
#include <aws/iotwireless/model/UpdateWirelessDeviceRequest.h>
#include <aws/iotwireless/model/UpdateWirelessDeviceResult.h>
#include <aws/iotwireless/model/UpdateWirelessGatewayRequest.h>
#include <aws/iotwireless/model/UpdateWirelessGatewayResult.h>
#include <aws/iotwireless/model/UpdateWirelessGatewayTaskCreate.h>
#include <aws/iotwireless/model/UpdateWirelessGatewayTaskEntry.h>
#include <aws/iotwireless/model/WcdmaLocalId.h>
#include <aws/iotwireless/model/WcdmaNmrObj.h>
#include <aws/iotwireless/model/WcdmaObj.h>
#include <aws/iotwireless/model/WiFiAccessPoint.h>
#include <aws/iotwireless/model/WirelessDeviceEvent.h>
#include <aws/iotwireless/model/WirelessDeviceEventLogOption.h>
#include <aws/iotwireless/model/WirelessDeviceFrameInfo.h>
#include <aws/iotwireless/model/WirelessDeviceIdType.h>
#include <aws/iotwireless/model/WirelessDeviceImportTask.h>
#include <aws/iotwireless/model/WirelessDeviceLogOption.h>
#include <aws/iotwireless/model/WirelessDeviceSidewalkStatus.h>
#include <aws/iotwireless/model/WirelessDeviceStatistics.h>
#include <aws/iotwireless/model/WirelessDeviceType.h>
#include <aws/iotwireless/model/WirelessGatewayEvent.h>
#include <aws/iotwireless/model/WirelessGatewayEventLogOption.h>
#include <aws/iotwireless/model/WirelessGatewayIdType.h>
#include <aws/iotwireless/model/WirelessGatewayLogOption.h>
#include <aws/iotwireless/model/WirelessGatewayServiceType.h>
#include <aws/iotwireless/model/WirelessGatewayStatistics.h>
#include <aws/iotwireless/model/WirelessGatewayTaskDefinitionType.h>
#include <aws/iotwireless/model/WirelessGatewayTaskStatus.h>
#include <aws/iotwireless/model/WirelessGatewayType.h>
#include <aws/iotwireless/model/WirelessMetadata.h>

using IoTWirelessIncludeTest = ::testing::Test;

TEST_F(IoTWirelessIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::IoTWireless::IoTWirelessClient>("IoTWirelessIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
