/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/kafka/KafkaClient.h>
#include <aws/kafka/KafkaEndpointProvider.h>
#include <aws/kafka/KafkaEndpointRules.h>
#include <aws/kafka/KafkaErrorMarshaller.h>
#include <aws/kafka/KafkaErrors.h>
#include <aws/kafka/KafkaRequest.h>
#include <aws/kafka/KafkaServiceClientModel.h>
#include <aws/kafka/Kafka_EXPORTS.h>
#include <aws/kafka/model/AmazonMskCluster.h>
#include <aws/kafka/model/BadRequestException.h>
#include <aws/kafka/model/BatchAssociateScramSecretRequest.h>
#include <aws/kafka/model/BatchAssociateScramSecretResult.h>
#include <aws/kafka/model/BatchDisassociateScramSecretRequest.h>
#include <aws/kafka/model/BatchDisassociateScramSecretResult.h>
#include <aws/kafka/model/BrokerAZDistribution.h>
#include <aws/kafka/model/BrokerCountUpdateInfo.h>
#include <aws/kafka/model/BrokerEBSVolumeInfo.h>
#include <aws/kafka/model/BrokerLogs.h>
#include <aws/kafka/model/BrokerNodeGroupInfo.h>
#include <aws/kafka/model/BrokerNodeInfo.h>
#include <aws/kafka/model/BrokerSoftwareInfo.h>
#include <aws/kafka/model/ClientAuthentication.h>
#include <aws/kafka/model/ClientBroker.h>
#include <aws/kafka/model/ClientVpcConnection.h>
#include <aws/kafka/model/CloudWatchLogs.h>
#include <aws/kafka/model/Cluster.h>
#include <aws/kafka/model/ClusterInfo.h>
#include <aws/kafka/model/ClusterOperationInfo.h>
#include <aws/kafka/model/ClusterOperationStep.h>
#include <aws/kafka/model/ClusterOperationStepInfo.h>
#include <aws/kafka/model/ClusterOperationV2.h>
#include <aws/kafka/model/ClusterOperationV2Provisioned.h>
#include <aws/kafka/model/ClusterOperationV2Serverless.h>
#include <aws/kafka/model/ClusterOperationV2Summary.h>
#include <aws/kafka/model/ClusterState.h>
#include <aws/kafka/model/ClusterType.h>
#include <aws/kafka/model/CompatibleKafkaVersion.h>
#include <aws/kafka/model/Configuration.h>
#include <aws/kafka/model/ConfigurationInfo.h>
#include <aws/kafka/model/ConfigurationRevision.h>
#include <aws/kafka/model/ConfigurationState.h>
#include <aws/kafka/model/ConflictException.h>
#include <aws/kafka/model/ConnectivityInfo.h>
#include <aws/kafka/model/ConsumerGroupReplication.h>
#include <aws/kafka/model/ConsumerGroupReplicationUpdate.h>
#include <aws/kafka/model/ControllerNodeInfo.h>
#include <aws/kafka/model/CreateClusterRequest.h>
#include <aws/kafka/model/CreateClusterResult.h>
#include <aws/kafka/model/CreateClusterV2Request.h>
#include <aws/kafka/model/CreateClusterV2Result.h>
#include <aws/kafka/model/CreateConfigurationRequest.h>
#include <aws/kafka/model/CreateConfigurationResult.h>
#include <aws/kafka/model/CreateReplicatorRequest.h>
#include <aws/kafka/model/CreateReplicatorResult.h>
#include <aws/kafka/model/CreateVpcConnectionRequest.h>
#include <aws/kafka/model/CreateVpcConnectionResult.h>
#include <aws/kafka/model/CustomerActionStatus.h>
#include <aws/kafka/model/DeleteClusterPolicyRequest.h>
#include <aws/kafka/model/DeleteClusterPolicyResult.h>
#include <aws/kafka/model/DeleteClusterRequest.h>
#include <aws/kafka/model/DeleteClusterResult.h>
#include <aws/kafka/model/DeleteConfigurationRequest.h>
#include <aws/kafka/model/DeleteConfigurationResult.h>
#include <aws/kafka/model/DeleteReplicatorRequest.h>
#include <aws/kafka/model/DeleteReplicatorResult.h>
#include <aws/kafka/model/DeleteVpcConnectionRequest.h>
#include <aws/kafka/model/DeleteVpcConnectionResult.h>
#include <aws/kafka/model/DescribeClusterOperationRequest.h>
#include <aws/kafka/model/DescribeClusterOperationResult.h>
#include <aws/kafka/model/DescribeClusterOperationV2Request.h>
#include <aws/kafka/model/DescribeClusterOperationV2Result.h>
#include <aws/kafka/model/DescribeClusterRequest.h>
#include <aws/kafka/model/DescribeClusterResult.h>
#include <aws/kafka/model/DescribeClusterV2Request.h>
#include <aws/kafka/model/DescribeClusterV2Result.h>
#include <aws/kafka/model/DescribeConfigurationRequest.h>
#include <aws/kafka/model/DescribeConfigurationResult.h>
#include <aws/kafka/model/DescribeConfigurationRevisionRequest.h>
#include <aws/kafka/model/DescribeConfigurationRevisionResult.h>
#include <aws/kafka/model/DescribeReplicatorRequest.h>
#include <aws/kafka/model/DescribeReplicatorResult.h>
#include <aws/kafka/model/DescribeVpcConnectionRequest.h>
#include <aws/kafka/model/DescribeVpcConnectionResult.h>
#include <aws/kafka/model/EBSStorageInfo.h>
#include <aws/kafka/model/EncryptionAtRest.h>
#include <aws/kafka/model/EncryptionInTransit.h>
#include <aws/kafka/model/EncryptionInfo.h>
#include <aws/kafka/model/EnhancedMonitoring.h>
#include <aws/kafka/model/ErrorInfo.h>
#include <aws/kafka/model/Firehose.h>
#include <aws/kafka/model/ForbiddenException.h>
#include <aws/kafka/model/GetBootstrapBrokersRequest.h>
#include <aws/kafka/model/GetBootstrapBrokersResult.h>
#include <aws/kafka/model/GetClusterPolicyRequest.h>
#include <aws/kafka/model/GetClusterPolicyResult.h>
#include <aws/kafka/model/GetCompatibleKafkaVersionsRequest.h>
#include <aws/kafka/model/GetCompatibleKafkaVersionsResult.h>
#include <aws/kafka/model/Iam.h>
#include <aws/kafka/model/InternalServerErrorException.h>
#include <aws/kafka/model/JmxExporter.h>
#include <aws/kafka/model/JmxExporterInfo.h>
#include <aws/kafka/model/KafkaCluster.h>
#include <aws/kafka/model/KafkaClusterClientVpcConfig.h>
#include <aws/kafka/model/KafkaClusterDescription.h>
#include <aws/kafka/model/KafkaClusterSummary.h>
#include <aws/kafka/model/KafkaVersion.h>
#include <aws/kafka/model/KafkaVersionStatus.h>
#include <aws/kafka/model/ListClientVpcConnectionsRequest.h>
#include <aws/kafka/model/ListClientVpcConnectionsResult.h>
#include <aws/kafka/model/ListClusterOperationsRequest.h>
#include <aws/kafka/model/ListClusterOperationsResult.h>
#include <aws/kafka/model/ListClusterOperationsV2Request.h>
#include <aws/kafka/model/ListClusterOperationsV2Result.h>
#include <aws/kafka/model/ListClustersRequest.h>
#include <aws/kafka/model/ListClustersResult.h>
#include <aws/kafka/model/ListClustersV2Request.h>
#include <aws/kafka/model/ListClustersV2Result.h>
#include <aws/kafka/model/ListConfigurationRevisionsRequest.h>
#include <aws/kafka/model/ListConfigurationRevisionsResult.h>
#include <aws/kafka/model/ListConfigurationsRequest.h>
#include <aws/kafka/model/ListConfigurationsResult.h>
#include <aws/kafka/model/ListKafkaVersionsRequest.h>
#include <aws/kafka/model/ListKafkaVersionsResult.h>
#include <aws/kafka/model/ListNodesRequest.h>
#include <aws/kafka/model/ListNodesResult.h>
#include <aws/kafka/model/ListReplicatorsRequest.h>
#include <aws/kafka/model/ListReplicatorsResult.h>
#include <aws/kafka/model/ListScramSecretsRequest.h>
#include <aws/kafka/model/ListScramSecretsResult.h>
#include <aws/kafka/model/ListTagsForResourceRequest.h>
#include <aws/kafka/model/ListTagsForResourceResult.h>
#include <aws/kafka/model/ListVpcConnectionsRequest.h>
#include <aws/kafka/model/ListVpcConnectionsResult.h>
#include <aws/kafka/model/LoggingInfo.h>
#include <aws/kafka/model/MutableClusterInfo.h>
#include <aws/kafka/model/NodeExporter.h>
#include <aws/kafka/model/NodeExporterInfo.h>
#include <aws/kafka/model/NodeInfo.h>
#include <aws/kafka/model/NodeType.h>
#include <aws/kafka/model/NotFoundException.h>
#include <aws/kafka/model/OpenMonitoring.h>
#include <aws/kafka/model/OpenMonitoringInfo.h>
#include <aws/kafka/model/Prometheus.h>
#include <aws/kafka/model/PrometheusInfo.h>
#include <aws/kafka/model/Provisioned.h>
#include <aws/kafka/model/ProvisionedRequest.h>
#include <aws/kafka/model/ProvisionedThroughput.h>
#include <aws/kafka/model/PublicAccess.h>
#include <aws/kafka/model/PutClusterPolicyRequest.h>
#include <aws/kafka/model/PutClusterPolicyResult.h>
#include <aws/kafka/model/RebootBrokerRequest.h>
#include <aws/kafka/model/RebootBrokerResult.h>
#include <aws/kafka/model/RejectClientVpcConnectionRequest.h>
#include <aws/kafka/model/RejectClientVpcConnectionResult.h>
#include <aws/kafka/model/ReplicationInfo.h>
#include <aws/kafka/model/ReplicationInfoDescription.h>
#include <aws/kafka/model/ReplicationInfoSummary.h>
#include <aws/kafka/model/ReplicationStartingPosition.h>
#include <aws/kafka/model/ReplicationStartingPositionType.h>
#include <aws/kafka/model/ReplicationStateInfo.h>
#include <aws/kafka/model/ReplicationTopicNameConfiguration.h>
#include <aws/kafka/model/ReplicationTopicNameConfigurationType.h>
#include <aws/kafka/model/ReplicatorState.h>
#include <aws/kafka/model/ReplicatorSummary.h>
#include <aws/kafka/model/S3.h>
#include <aws/kafka/model/Sasl.h>
#include <aws/kafka/model/Scram.h>
#include <aws/kafka/model/Serverless.h>
#include <aws/kafka/model/ServerlessClientAuthentication.h>
#include <aws/kafka/model/ServerlessRequest.h>
#include <aws/kafka/model/ServerlessSasl.h>
#include <aws/kafka/model/ServiceUnavailableException.h>
#include <aws/kafka/model/StateInfo.h>
#include <aws/kafka/model/StorageInfo.h>
#include <aws/kafka/model/StorageMode.h>
#include <aws/kafka/model/TagResourceRequest.h>
#include <aws/kafka/model/TargetCompressionType.h>
#include <aws/kafka/model/Tls.h>
#include <aws/kafka/model/TooManyRequestsException.h>
#include <aws/kafka/model/TopicReplication.h>
#include <aws/kafka/model/TopicReplicationUpdate.h>
#include <aws/kafka/model/Unauthenticated.h>
#include <aws/kafka/model/UnauthorizedException.h>
#include <aws/kafka/model/UnprocessedScramSecret.h>
#include <aws/kafka/model/UntagResourceRequest.h>
#include <aws/kafka/model/UpdateBrokerCountRequest.h>
#include <aws/kafka/model/UpdateBrokerCountResult.h>
#include <aws/kafka/model/UpdateBrokerStorageRequest.h>
#include <aws/kafka/model/UpdateBrokerStorageResult.h>
#include <aws/kafka/model/UpdateBrokerTypeRequest.h>
#include <aws/kafka/model/UpdateBrokerTypeResult.h>
#include <aws/kafka/model/UpdateClusterConfigurationRequest.h>
#include <aws/kafka/model/UpdateClusterConfigurationResult.h>
#include <aws/kafka/model/UpdateClusterKafkaVersionRequest.h>
#include <aws/kafka/model/UpdateClusterKafkaVersionResult.h>
#include <aws/kafka/model/UpdateConfigurationRequest.h>
#include <aws/kafka/model/UpdateConfigurationResult.h>
#include <aws/kafka/model/UpdateConnectivityRequest.h>
#include <aws/kafka/model/UpdateConnectivityResult.h>
#include <aws/kafka/model/UpdateMonitoringRequest.h>
#include <aws/kafka/model/UpdateMonitoringResult.h>
#include <aws/kafka/model/UpdateReplicationInfoRequest.h>
#include <aws/kafka/model/UpdateReplicationInfoResult.h>
#include <aws/kafka/model/UpdateSecurityRequest.h>
#include <aws/kafka/model/UpdateSecurityResult.h>
#include <aws/kafka/model/UpdateStorageRequest.h>
#include <aws/kafka/model/UpdateStorageResult.h>
#include <aws/kafka/model/UserIdentity.h>
#include <aws/kafka/model/UserIdentityType.h>
#include <aws/kafka/model/VpcConfig.h>
#include <aws/kafka/model/VpcConnection.h>
#include <aws/kafka/model/VpcConnectionInfo.h>
#include <aws/kafka/model/VpcConnectionInfoServerless.h>
#include <aws/kafka/model/VpcConnectionState.h>
#include <aws/kafka/model/VpcConnectivity.h>
#include <aws/kafka/model/VpcConnectivityClientAuthentication.h>
#include <aws/kafka/model/VpcConnectivityIam.h>
#include <aws/kafka/model/VpcConnectivitySasl.h>
#include <aws/kafka/model/VpcConnectivityScram.h>
#include <aws/kafka/model/VpcConnectivityTls.h>
#include <aws/kafka/model/ZookeeperNodeInfo.h>

using KafkaIncludeTest = ::testing::Test;

TEST_F(KafkaIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::Kafka::KafkaClient>("KafkaIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
