/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/kendra/KendraClient.h>
#include <aws/kendra/KendraEndpointProvider.h>
#include <aws/kendra/KendraEndpointRules.h>
#include <aws/kendra/KendraErrorMarshaller.h>
#include <aws/kendra/KendraErrors.h>
#include <aws/kendra/KendraRequest.h>
#include <aws/kendra/KendraServiceClientModel.h>
#include <aws/kendra/Kendra_EXPORTS.h>
#include <aws/kendra/model/AccessControlConfigurationSummary.h>
#include <aws/kendra/model/AccessControlListConfiguration.h>
#include <aws/kendra/model/AclConfiguration.h>
#include <aws/kendra/model/AdditionalResultAttribute.h>
#include <aws/kendra/model/AdditionalResultAttributeValue.h>
#include <aws/kendra/model/AdditionalResultAttributeValueType.h>
#include <aws/kendra/model/AlfrescoEntity.h>
#include <aws/kendra/model/AssociateEntitiesToExperienceRequest.h>
#include <aws/kendra/model/AssociateEntitiesToExperienceResult.h>
#include <aws/kendra/model/AssociatePersonasToEntitiesRequest.h>
#include <aws/kendra/model/AssociatePersonasToEntitiesResult.h>
#include <aws/kendra/model/AttributeFilter.h>
#include <aws/kendra/model/AttributeSuggestionsDescribeConfig.h>
#include <aws/kendra/model/AttributeSuggestionsGetConfig.h>
#include <aws/kendra/model/AttributeSuggestionsMode.h>
#include <aws/kendra/model/AttributeSuggestionsUpdateConfig.h>
#include <aws/kendra/model/AuthenticationConfiguration.h>
#include <aws/kendra/model/BasicAuthenticationConfiguration.h>
#include <aws/kendra/model/BatchDeleteDocumentRequest.h>
#include <aws/kendra/model/BatchDeleteDocumentResponseFailedDocument.h>
#include <aws/kendra/model/BatchDeleteDocumentResult.h>
#include <aws/kendra/model/BatchDeleteFeaturedResultsSetError.h>
#include <aws/kendra/model/BatchDeleteFeaturedResultsSetRequest.h>
#include <aws/kendra/model/BatchDeleteFeaturedResultsSetResult.h>
#include <aws/kendra/model/BatchGetDocumentStatusRequest.h>
#include <aws/kendra/model/BatchGetDocumentStatusResponseError.h>
#include <aws/kendra/model/BatchGetDocumentStatusResult.h>
#include <aws/kendra/model/BatchPutDocumentRequest.h>
#include <aws/kendra/model/BatchPutDocumentResponseFailedDocument.h>
#include <aws/kendra/model/BatchPutDocumentResult.h>
#include <aws/kendra/model/BoxConfiguration.h>
#include <aws/kendra/model/CapacityUnitsConfiguration.h>
#include <aws/kendra/model/ClearQuerySuggestionsRequest.h>
#include <aws/kendra/model/ClickFeedback.h>
#include <aws/kendra/model/CollapseConfiguration.h>
#include <aws/kendra/model/CollapsedResultDetail.h>
#include <aws/kendra/model/ColumnConfiguration.h>
#include <aws/kendra/model/ConditionOperator.h>
#include <aws/kendra/model/ConflictingItem.h>
#include <aws/kendra/model/ConfluenceAttachmentConfiguration.h>
#include <aws/kendra/model/ConfluenceAttachmentFieldName.h>
#include <aws/kendra/model/ConfluenceAttachmentToIndexFieldMapping.h>
#include <aws/kendra/model/ConfluenceAuthenticationType.h>
#include <aws/kendra/model/ConfluenceBlogConfiguration.h>
#include <aws/kendra/model/ConfluenceBlogFieldName.h>
#include <aws/kendra/model/ConfluenceBlogToIndexFieldMapping.h>
#include <aws/kendra/model/ConfluenceConfiguration.h>
#include <aws/kendra/model/ConfluencePageConfiguration.h>
#include <aws/kendra/model/ConfluencePageFieldName.h>
#include <aws/kendra/model/ConfluencePageToIndexFieldMapping.h>
#include <aws/kendra/model/ConfluenceSpaceConfiguration.h>
#include <aws/kendra/model/ConfluenceSpaceFieldName.h>
#include <aws/kendra/model/ConfluenceSpaceToIndexFieldMapping.h>
#include <aws/kendra/model/ConfluenceVersion.h>
#include <aws/kendra/model/ConnectionConfiguration.h>
#include <aws/kendra/model/ContentSourceConfiguration.h>
#include <aws/kendra/model/ContentType.h>
#include <aws/kendra/model/Correction.h>
#include <aws/kendra/model/CreateAccessControlConfigurationRequest.h>
#include <aws/kendra/model/CreateAccessControlConfigurationResult.h>
#include <aws/kendra/model/CreateDataSourceRequest.h>
#include <aws/kendra/model/CreateDataSourceResult.h>
#include <aws/kendra/model/CreateExperienceRequest.h>
#include <aws/kendra/model/CreateExperienceResult.h>
#include <aws/kendra/model/CreateFaqRequest.h>
#include <aws/kendra/model/CreateFaqResult.h>
#include <aws/kendra/model/CreateFeaturedResultsSetRequest.h>
#include <aws/kendra/model/CreateFeaturedResultsSetResult.h>
#include <aws/kendra/model/CreateIndexRequest.h>
#include <aws/kendra/model/CreateIndexResult.h>
#include <aws/kendra/model/CreateQuerySuggestionsBlockListRequest.h>
#include <aws/kendra/model/CreateQuerySuggestionsBlockListResult.h>
#include <aws/kendra/model/CreateThesaurusRequest.h>
#include <aws/kendra/model/CreateThesaurusResult.h>
#include <aws/kendra/model/CustomDocumentEnrichmentConfiguration.h>
#include <aws/kendra/model/DataSourceConfiguration.h>
#include <aws/kendra/model/DataSourceGroup.h>
#include <aws/kendra/model/DataSourceStatus.h>
#include <aws/kendra/model/DataSourceSummary.h>
#include <aws/kendra/model/DataSourceSyncJob.h>
#include <aws/kendra/model/DataSourceSyncJobMetricTarget.h>
#include <aws/kendra/model/DataSourceSyncJobMetrics.h>
#include <aws/kendra/model/DataSourceSyncJobStatus.h>
#include <aws/kendra/model/DataSourceToIndexFieldMapping.h>
#include <aws/kendra/model/DataSourceType.h>
#include <aws/kendra/model/DataSourceVpcConfiguration.h>
#include <aws/kendra/model/DatabaseConfiguration.h>
#include <aws/kendra/model/DatabaseEngineType.h>
#include <aws/kendra/model/DeleteAccessControlConfigurationRequest.h>
#include <aws/kendra/model/DeleteAccessControlConfigurationResult.h>
#include <aws/kendra/model/DeleteDataSourceRequest.h>
#include <aws/kendra/model/DeleteExperienceRequest.h>
#include <aws/kendra/model/DeleteExperienceResult.h>
#include <aws/kendra/model/DeleteFaqRequest.h>
#include <aws/kendra/model/DeleteIndexRequest.h>
#include <aws/kendra/model/DeletePrincipalMappingRequest.h>
#include <aws/kendra/model/DeleteQuerySuggestionsBlockListRequest.h>
#include <aws/kendra/model/DeleteThesaurusRequest.h>
#include <aws/kendra/model/DescribeAccessControlConfigurationRequest.h>
#include <aws/kendra/model/DescribeAccessControlConfigurationResult.h>
#include <aws/kendra/model/DescribeDataSourceRequest.h>
#include <aws/kendra/model/DescribeDataSourceResult.h>
#include <aws/kendra/model/DescribeExperienceRequest.h>
#include <aws/kendra/model/DescribeExperienceResult.h>
#include <aws/kendra/model/DescribeFaqRequest.h>
#include <aws/kendra/model/DescribeFaqResult.h>
#include <aws/kendra/model/DescribeFeaturedResultsSetRequest.h>
#include <aws/kendra/model/DescribeFeaturedResultsSetResult.h>
#include <aws/kendra/model/DescribeIndexRequest.h>
#include <aws/kendra/model/DescribeIndexResult.h>
#include <aws/kendra/model/DescribePrincipalMappingRequest.h>
#include <aws/kendra/model/DescribePrincipalMappingResult.h>
#include <aws/kendra/model/DescribeQuerySuggestionsBlockListRequest.h>
#include <aws/kendra/model/DescribeQuerySuggestionsBlockListResult.h>
#include <aws/kendra/model/DescribeQuerySuggestionsConfigRequest.h>
#include <aws/kendra/model/DescribeQuerySuggestionsConfigResult.h>
#include <aws/kendra/model/DescribeThesaurusRequest.h>
#include <aws/kendra/model/DescribeThesaurusResult.h>
#include <aws/kendra/model/DisassociateEntitiesFromExperienceRequest.h>
#include <aws/kendra/model/DisassociateEntitiesFromExperienceResult.h>
#include <aws/kendra/model/DisassociatePersonasFromEntitiesRequest.h>
#include <aws/kendra/model/DisassociatePersonasFromEntitiesResult.h>
#include <aws/kendra/model/Document.h>
#include <aws/kendra/model/DocumentAttribute.h>
#include <aws/kendra/model/DocumentAttributeCondition.h>
#include <aws/kendra/model/DocumentAttributeTarget.h>
#include <aws/kendra/model/DocumentAttributeValue.h>
#include <aws/kendra/model/DocumentAttributeValueCountPair.h>
#include <aws/kendra/model/DocumentAttributeValueType.h>
#include <aws/kendra/model/DocumentInfo.h>
#include <aws/kendra/model/DocumentMetadataConfiguration.h>
#include <aws/kendra/model/DocumentRelevanceConfiguration.h>
#include <aws/kendra/model/DocumentStatus.h>
#include <aws/kendra/model/DocumentsMetadataConfiguration.h>
#include <aws/kendra/model/EndpointType.h>
#include <aws/kendra/model/EntityConfiguration.h>
#include <aws/kendra/model/EntityDisplayData.h>
#include <aws/kendra/model/EntityPersonaConfiguration.h>
#include <aws/kendra/model/EntityType.h>
#include <aws/kendra/model/ErrorCode.h>
#include <aws/kendra/model/ExpandConfiguration.h>
#include <aws/kendra/model/ExpandedResultItem.h>
#include <aws/kendra/model/ExperienceConfiguration.h>
#include <aws/kendra/model/ExperienceEndpoint.h>
#include <aws/kendra/model/ExperienceEntitiesSummary.h>
#include <aws/kendra/model/ExperienceStatus.h>
#include <aws/kendra/model/ExperiencesSummary.h>
#include <aws/kendra/model/Facet.h>
#include <aws/kendra/model/FacetResult.h>
#include <aws/kendra/model/FailedEntity.h>
#include <aws/kendra/model/FaqFileFormat.h>
#include <aws/kendra/model/FaqStatistics.h>
#include <aws/kendra/model/FaqStatus.h>
#include <aws/kendra/model/FaqSummary.h>
#include <aws/kendra/model/FeaturedDocument.h>
#include <aws/kendra/model/FeaturedDocumentMissing.h>
#include <aws/kendra/model/FeaturedDocumentWithMetadata.h>
#include <aws/kendra/model/FeaturedResultsConflictException.h>
#include <aws/kendra/model/FeaturedResultsItem.h>
#include <aws/kendra/model/FeaturedResultsSet.h>
#include <aws/kendra/model/FeaturedResultsSetStatus.h>
#include <aws/kendra/model/FeaturedResultsSetSummary.h>
#include <aws/kendra/model/FsxConfiguration.h>
#include <aws/kendra/model/FsxFileSystemType.h>
#include <aws/kendra/model/GetQuerySuggestionsRequest.h>
#include <aws/kendra/model/GetQuerySuggestionsResult.h>
#include <aws/kendra/model/GetSnapshotsRequest.h>
#include <aws/kendra/model/GetSnapshotsResult.h>
#include <aws/kendra/model/GitHubConfiguration.h>
#include <aws/kendra/model/GitHubDocumentCrawlProperties.h>
#include <aws/kendra/model/GoogleDriveConfiguration.h>
#include <aws/kendra/model/GroupMembers.h>
#include <aws/kendra/model/GroupOrderingIdSummary.h>
#include <aws/kendra/model/GroupSummary.h>
#include <aws/kendra/model/HierarchicalPrincipal.h>
#include <aws/kendra/model/Highlight.h>
#include <aws/kendra/model/HighlightType.h>
#include <aws/kendra/model/HookConfiguration.h>
#include <aws/kendra/model/IndexConfigurationSummary.h>
#include <aws/kendra/model/IndexEdition.h>
#include <aws/kendra/model/IndexStatistics.h>
#include <aws/kendra/model/IndexStatus.h>
#include <aws/kendra/model/InlineCustomDocumentEnrichmentConfiguration.h>
#include <aws/kendra/model/Interval.h>
#include <aws/kendra/model/IssueSubEntity.h>
#include <aws/kendra/model/JiraConfiguration.h>
#include <aws/kendra/model/JsonTokenTypeConfiguration.h>
#include <aws/kendra/model/JwtTokenTypeConfiguration.h>
#include <aws/kendra/model/KeyLocation.h>
#include <aws/kendra/model/ListAccessControlConfigurationsRequest.h>
#include <aws/kendra/model/ListAccessControlConfigurationsResult.h>
#include <aws/kendra/model/ListDataSourceSyncJobsRequest.h>
#include <aws/kendra/model/ListDataSourceSyncJobsResult.h>
#include <aws/kendra/model/ListDataSourcesRequest.h>
#include <aws/kendra/model/ListDataSourcesResult.h>
#include <aws/kendra/model/ListEntityPersonasRequest.h>
#include <aws/kendra/model/ListEntityPersonasResult.h>
#include <aws/kendra/model/ListExperienceEntitiesRequest.h>
#include <aws/kendra/model/ListExperienceEntitiesResult.h>
#include <aws/kendra/model/ListExperiencesRequest.h>
#include <aws/kendra/model/ListExperiencesResult.h>
#include <aws/kendra/model/ListFaqsRequest.h>
#include <aws/kendra/model/ListFaqsResult.h>
#include <aws/kendra/model/ListFeaturedResultsSetsRequest.h>
#include <aws/kendra/model/ListFeaturedResultsSetsResult.h>
#include <aws/kendra/model/ListGroupsOlderThanOrderingIdRequest.h>
#include <aws/kendra/model/ListGroupsOlderThanOrderingIdResult.h>
#include <aws/kendra/model/ListIndicesRequest.h>
#include <aws/kendra/model/ListIndicesResult.h>
#include <aws/kendra/model/ListQuerySuggestionsBlockListsRequest.h>
#include <aws/kendra/model/ListQuerySuggestionsBlockListsResult.h>
#include <aws/kendra/model/ListTagsForResourceRequest.h>
#include <aws/kendra/model/ListTagsForResourceResult.h>
#include <aws/kendra/model/ListThesauriRequest.h>
#include <aws/kendra/model/ListThesauriResult.h>
#include <aws/kendra/model/MemberGroup.h>
#include <aws/kendra/model/MemberUser.h>
#include <aws/kendra/model/MetricType.h>
#include <aws/kendra/model/MissingAttributeKeyStrategy.h>
#include <aws/kendra/model/Mode.h>
#include <aws/kendra/model/OnPremiseConfiguration.h>
#include <aws/kendra/model/OneDriveConfiguration.h>
#include <aws/kendra/model/OneDriveUsers.h>
#include <aws/kendra/model/Order.h>
#include <aws/kendra/model/Persona.h>
#include <aws/kendra/model/PersonasSummary.h>
#include <aws/kendra/model/Principal.h>
#include <aws/kendra/model/PrincipalMappingStatus.h>
#include <aws/kendra/model/PrincipalType.h>
#include <aws/kendra/model/ProxyConfiguration.h>
#include <aws/kendra/model/PutPrincipalMappingRequest.h>
#include <aws/kendra/model/QueryIdentifiersEnclosingOption.h>
#include <aws/kendra/model/QueryRequest.h>
#include <aws/kendra/model/QueryResult.h>
#include <aws/kendra/model/QueryResultFormat.h>
#include <aws/kendra/model/QueryResultItem.h>
#include <aws/kendra/model/QueryResultType.h>
#include <aws/kendra/model/QuerySuggestionsBlockListStatus.h>
#include <aws/kendra/model/QuerySuggestionsBlockListSummary.h>
#include <aws/kendra/model/QuerySuggestionsStatus.h>
#include <aws/kendra/model/QuipConfiguration.h>
#include <aws/kendra/model/ReadAccessType.h>
#include <aws/kendra/model/Relevance.h>
#include <aws/kendra/model/RelevanceFeedback.h>
#include <aws/kendra/model/RelevanceType.h>
#include <aws/kendra/model/RetrieveRequest.h>
#include <aws/kendra/model/RetrieveResult.h>
#include <aws/kendra/model/RetrieveResultItem.h>
#include <aws/kendra/model/S3DataSourceConfiguration.h>
#include <aws/kendra/model/S3Path.h>
#include <aws/kendra/model/SaaSConfiguration.h>
#include <aws/kendra/model/SalesforceChatterFeedConfiguration.h>
#include <aws/kendra/model/SalesforceChatterFeedIncludeFilterType.h>
#include <aws/kendra/model/SalesforceConfiguration.h>
#include <aws/kendra/model/SalesforceCustomKnowledgeArticleTypeConfiguration.h>
#include <aws/kendra/model/SalesforceKnowledgeArticleConfiguration.h>
#include <aws/kendra/model/SalesforceKnowledgeArticleState.h>
#include <aws/kendra/model/SalesforceStandardKnowledgeArticleTypeConfiguration.h>
#include <aws/kendra/model/SalesforceStandardObjectAttachmentConfiguration.h>
#include <aws/kendra/model/SalesforceStandardObjectConfiguration.h>
#include <aws/kendra/model/SalesforceStandardObjectName.h>
#include <aws/kendra/model/ScoreAttributes.h>
#include <aws/kendra/model/ScoreConfidence.h>
#include <aws/kendra/model/Search.h>
#include <aws/kendra/model/SeedUrlConfiguration.h>
#include <aws/kendra/model/ServerSideEncryptionConfiguration.h>
#include <aws/kendra/model/ServiceNowAuthenticationType.h>
#include <aws/kendra/model/ServiceNowBuildVersionType.h>
#include <aws/kendra/model/ServiceNowConfiguration.h>
#include <aws/kendra/model/ServiceNowKnowledgeArticleConfiguration.h>
#include <aws/kendra/model/ServiceNowServiceCatalogConfiguration.h>
#include <aws/kendra/model/SharePointConfiguration.h>
#include <aws/kendra/model/SharePointOnlineAuthenticationType.h>
#include <aws/kendra/model/SharePointVersion.h>
#include <aws/kendra/model/SiteMapsConfiguration.h>
#include <aws/kendra/model/SlackConfiguration.h>
#include <aws/kendra/model/SlackEntity.h>
#include <aws/kendra/model/SortOrder.h>
#include <aws/kendra/model/SortingConfiguration.h>
#include <aws/kendra/model/SourceDocument.h>
#include <aws/kendra/model/SpellCorrectedQuery.h>
#include <aws/kendra/model/SpellCorrectionConfiguration.h>
#include <aws/kendra/model/SqlConfiguration.h>
#include <aws/kendra/model/StartDataSourceSyncJobRequest.h>
#include <aws/kendra/model/StartDataSourceSyncJobResult.h>
#include <aws/kendra/model/Status.h>
#include <aws/kendra/model/StopDataSourceSyncJobRequest.h>
#include <aws/kendra/model/SubmitFeedbackRequest.h>
#include <aws/kendra/model/SuggestableConfig.h>
#include <aws/kendra/model/Suggestion.h>
#include <aws/kendra/model/SuggestionHighlight.h>
#include <aws/kendra/model/SuggestionTextWithHighlights.h>
#include <aws/kendra/model/SuggestionType.h>
#include <aws/kendra/model/SuggestionValue.h>
#include <aws/kendra/model/TableCell.h>
#include <aws/kendra/model/TableExcerpt.h>
#include <aws/kendra/model/TableRow.h>
#include <aws/kendra/model/Tag.h>
#include <aws/kendra/model/TagResourceRequest.h>
#include <aws/kendra/model/TagResourceResult.h>
#include <aws/kendra/model/TemplateConfiguration.h>
#include <aws/kendra/model/TextDocumentStatistics.h>
#include <aws/kendra/model/TextWithHighlights.h>
#include <aws/kendra/model/ThesaurusStatus.h>
#include <aws/kendra/model/ThesaurusSummary.h>
#include <aws/kendra/model/TimeRange.h>
#include <aws/kendra/model/Type.h>
#include <aws/kendra/model/UntagResourceRequest.h>
#include <aws/kendra/model/UntagResourceResult.h>
#include <aws/kendra/model/UpdateAccessControlConfigurationRequest.h>
#include <aws/kendra/model/UpdateAccessControlConfigurationResult.h>
#include <aws/kendra/model/UpdateDataSourceRequest.h>
#include <aws/kendra/model/UpdateExperienceRequest.h>
#include <aws/kendra/model/UpdateFeaturedResultsSetRequest.h>
#include <aws/kendra/model/UpdateFeaturedResultsSetResult.h>
#include <aws/kendra/model/UpdateIndexRequest.h>
#include <aws/kendra/model/UpdateQuerySuggestionsBlockListRequest.h>
#include <aws/kendra/model/UpdateQuerySuggestionsConfigRequest.h>
#include <aws/kendra/model/UpdateThesaurusRequest.h>
#include <aws/kendra/model/Urls.h>
#include <aws/kendra/model/UserContext.h>
#include <aws/kendra/model/UserContextPolicy.h>
#include <aws/kendra/model/UserGroupResolutionConfiguration.h>
#include <aws/kendra/model/UserGroupResolutionMode.h>
#include <aws/kendra/model/UserIdentityConfiguration.h>
#include <aws/kendra/model/UserTokenConfiguration.h>
#include <aws/kendra/model/Warning.h>
#include <aws/kendra/model/WarningCode.h>
#include <aws/kendra/model/WebCrawlerConfiguration.h>
#include <aws/kendra/model/WebCrawlerMode.h>
#include <aws/kendra/model/WorkDocsConfiguration.h>

using KendraIncludeTest = ::testing::Test;

TEST_F(KendraIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::kendra::KendraClient>("KendraIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
