/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/kinesisanalyticsv2/KinesisAnalyticsV2Client.h>
#include <aws/kinesisanalyticsv2/KinesisAnalyticsV2EndpointProvider.h>
#include <aws/kinesisanalyticsv2/KinesisAnalyticsV2EndpointRules.h>
#include <aws/kinesisanalyticsv2/KinesisAnalyticsV2ErrorMarshaller.h>
#include <aws/kinesisanalyticsv2/KinesisAnalyticsV2Errors.h>
#include <aws/kinesisanalyticsv2/KinesisAnalyticsV2Request.h>
#include <aws/kinesisanalyticsv2/KinesisAnalyticsV2ServiceClientModel.h>
#include <aws/kinesisanalyticsv2/KinesisAnalyticsV2_EXPORTS.h>
#include <aws/kinesisanalyticsv2/model/AddApplicationCloudWatchLoggingOptionRequest.h>
#include <aws/kinesisanalyticsv2/model/AddApplicationCloudWatchLoggingOptionResult.h>
#include <aws/kinesisanalyticsv2/model/AddApplicationInputProcessingConfigurationRequest.h>
#include <aws/kinesisanalyticsv2/model/AddApplicationInputProcessingConfigurationResult.h>
#include <aws/kinesisanalyticsv2/model/AddApplicationInputRequest.h>
#include <aws/kinesisanalyticsv2/model/AddApplicationInputResult.h>
#include <aws/kinesisanalyticsv2/model/AddApplicationOutputRequest.h>
#include <aws/kinesisanalyticsv2/model/AddApplicationOutputResult.h>
#include <aws/kinesisanalyticsv2/model/AddApplicationReferenceDataSourceRequest.h>
#include <aws/kinesisanalyticsv2/model/AddApplicationReferenceDataSourceResult.h>
#include <aws/kinesisanalyticsv2/model/AddApplicationVpcConfigurationRequest.h>
#include <aws/kinesisanalyticsv2/model/AddApplicationVpcConfigurationResult.h>
#include <aws/kinesisanalyticsv2/model/ApplicationCodeConfiguration.h>
#include <aws/kinesisanalyticsv2/model/ApplicationCodeConfigurationDescription.h>
#include <aws/kinesisanalyticsv2/model/ApplicationCodeConfigurationUpdate.h>
#include <aws/kinesisanalyticsv2/model/ApplicationConfiguration.h>
#include <aws/kinesisanalyticsv2/model/ApplicationConfigurationDescription.h>
#include <aws/kinesisanalyticsv2/model/ApplicationConfigurationUpdate.h>
#include <aws/kinesisanalyticsv2/model/ApplicationDetail.h>
#include <aws/kinesisanalyticsv2/model/ApplicationMaintenanceConfigurationDescription.h>
#include <aws/kinesisanalyticsv2/model/ApplicationMaintenanceConfigurationUpdate.h>
#include <aws/kinesisanalyticsv2/model/ApplicationMode.h>
#include <aws/kinesisanalyticsv2/model/ApplicationOperationInfo.h>
#include <aws/kinesisanalyticsv2/model/ApplicationOperationInfoDetails.h>
#include <aws/kinesisanalyticsv2/model/ApplicationRestoreConfiguration.h>
#include <aws/kinesisanalyticsv2/model/ApplicationRestoreType.h>
#include <aws/kinesisanalyticsv2/model/ApplicationSnapshotConfiguration.h>
#include <aws/kinesisanalyticsv2/model/ApplicationSnapshotConfigurationDescription.h>
#include <aws/kinesisanalyticsv2/model/ApplicationSnapshotConfigurationUpdate.h>
#include <aws/kinesisanalyticsv2/model/ApplicationStatus.h>
#include <aws/kinesisanalyticsv2/model/ApplicationSummary.h>
#include <aws/kinesisanalyticsv2/model/ApplicationSystemRollbackConfiguration.h>
#include <aws/kinesisanalyticsv2/model/ApplicationSystemRollbackConfigurationDescription.h>
#include <aws/kinesisanalyticsv2/model/ApplicationSystemRollbackConfigurationUpdate.h>
#include <aws/kinesisanalyticsv2/model/ApplicationVersionChangeDetails.h>
#include <aws/kinesisanalyticsv2/model/ApplicationVersionSummary.h>
#include <aws/kinesisanalyticsv2/model/ArtifactType.h>
#include <aws/kinesisanalyticsv2/model/CSVMappingParameters.h>
#include <aws/kinesisanalyticsv2/model/CatalogConfiguration.h>
#include <aws/kinesisanalyticsv2/model/CatalogConfigurationDescription.h>
#include <aws/kinesisanalyticsv2/model/CatalogConfigurationUpdate.h>
#include <aws/kinesisanalyticsv2/model/CheckpointConfiguration.h>
#include <aws/kinesisanalyticsv2/model/CheckpointConfigurationDescription.h>
#include <aws/kinesisanalyticsv2/model/CheckpointConfigurationUpdate.h>
#include <aws/kinesisanalyticsv2/model/CloudWatchLoggingOption.h>
#include <aws/kinesisanalyticsv2/model/CloudWatchLoggingOptionDescription.h>
#include <aws/kinesisanalyticsv2/model/CloudWatchLoggingOptionUpdate.h>
#include <aws/kinesisanalyticsv2/model/CodeContent.h>
#include <aws/kinesisanalyticsv2/model/CodeContentDescription.h>
#include <aws/kinesisanalyticsv2/model/CodeContentType.h>
#include <aws/kinesisanalyticsv2/model/CodeContentUpdate.h>
#include <aws/kinesisanalyticsv2/model/ConfigurationType.h>
#include <aws/kinesisanalyticsv2/model/CreateApplicationPresignedUrlRequest.h>
#include <aws/kinesisanalyticsv2/model/CreateApplicationPresignedUrlResult.h>
#include <aws/kinesisanalyticsv2/model/CreateApplicationRequest.h>
#include <aws/kinesisanalyticsv2/model/CreateApplicationResult.h>
#include <aws/kinesisanalyticsv2/model/CreateApplicationSnapshotRequest.h>
#include <aws/kinesisanalyticsv2/model/CreateApplicationSnapshotResult.h>
#include <aws/kinesisanalyticsv2/model/CustomArtifactConfiguration.h>
#include <aws/kinesisanalyticsv2/model/CustomArtifactConfigurationDescription.h>
#include <aws/kinesisanalyticsv2/model/DeleteApplicationCloudWatchLoggingOptionRequest.h>
#include <aws/kinesisanalyticsv2/model/DeleteApplicationCloudWatchLoggingOptionResult.h>
#include <aws/kinesisanalyticsv2/model/DeleteApplicationInputProcessingConfigurationRequest.h>
#include <aws/kinesisanalyticsv2/model/DeleteApplicationInputProcessingConfigurationResult.h>
#include <aws/kinesisanalyticsv2/model/DeleteApplicationOutputRequest.h>
#include <aws/kinesisanalyticsv2/model/DeleteApplicationOutputResult.h>
#include <aws/kinesisanalyticsv2/model/DeleteApplicationReferenceDataSourceRequest.h>
#include <aws/kinesisanalyticsv2/model/DeleteApplicationReferenceDataSourceResult.h>
#include <aws/kinesisanalyticsv2/model/DeleteApplicationRequest.h>
#include <aws/kinesisanalyticsv2/model/DeleteApplicationResult.h>
#include <aws/kinesisanalyticsv2/model/DeleteApplicationSnapshotRequest.h>
#include <aws/kinesisanalyticsv2/model/DeleteApplicationSnapshotResult.h>
#include <aws/kinesisanalyticsv2/model/DeleteApplicationVpcConfigurationRequest.h>
#include <aws/kinesisanalyticsv2/model/DeleteApplicationVpcConfigurationResult.h>
#include <aws/kinesisanalyticsv2/model/DeployAsApplicationConfiguration.h>
#include <aws/kinesisanalyticsv2/model/DeployAsApplicationConfigurationDescription.h>
#include <aws/kinesisanalyticsv2/model/DeployAsApplicationConfigurationUpdate.h>
#include <aws/kinesisanalyticsv2/model/DescribeApplicationOperationRequest.h>
#include <aws/kinesisanalyticsv2/model/DescribeApplicationOperationResult.h>
#include <aws/kinesisanalyticsv2/model/DescribeApplicationRequest.h>
#include <aws/kinesisanalyticsv2/model/DescribeApplicationResult.h>
#include <aws/kinesisanalyticsv2/model/DescribeApplicationSnapshotRequest.h>
#include <aws/kinesisanalyticsv2/model/DescribeApplicationSnapshotResult.h>
#include <aws/kinesisanalyticsv2/model/DescribeApplicationVersionRequest.h>
#include <aws/kinesisanalyticsv2/model/DescribeApplicationVersionResult.h>
#include <aws/kinesisanalyticsv2/model/DestinationSchema.h>
#include <aws/kinesisanalyticsv2/model/DiscoverInputSchemaRequest.h>
#include <aws/kinesisanalyticsv2/model/DiscoverInputSchemaResult.h>
#include <aws/kinesisanalyticsv2/model/EnvironmentProperties.h>
#include <aws/kinesisanalyticsv2/model/EnvironmentPropertyDescriptions.h>
#include <aws/kinesisanalyticsv2/model/EnvironmentPropertyUpdates.h>
#include <aws/kinesisanalyticsv2/model/ErrorInfo.h>
#include <aws/kinesisanalyticsv2/model/FlinkApplicationConfiguration.h>
#include <aws/kinesisanalyticsv2/model/FlinkApplicationConfigurationDescription.h>
#include <aws/kinesisanalyticsv2/model/FlinkApplicationConfigurationUpdate.h>
#include <aws/kinesisanalyticsv2/model/FlinkRunConfiguration.h>
#include <aws/kinesisanalyticsv2/model/GlueDataCatalogConfiguration.h>
#include <aws/kinesisanalyticsv2/model/GlueDataCatalogConfigurationDescription.h>
#include <aws/kinesisanalyticsv2/model/GlueDataCatalogConfigurationUpdate.h>
#include <aws/kinesisanalyticsv2/model/Input.h>
#include <aws/kinesisanalyticsv2/model/InputDescription.h>
#include <aws/kinesisanalyticsv2/model/InputLambdaProcessor.h>
#include <aws/kinesisanalyticsv2/model/InputLambdaProcessorDescription.h>
#include <aws/kinesisanalyticsv2/model/InputLambdaProcessorUpdate.h>
#include <aws/kinesisanalyticsv2/model/InputParallelism.h>
#include <aws/kinesisanalyticsv2/model/InputParallelismUpdate.h>
#include <aws/kinesisanalyticsv2/model/InputProcessingConfiguration.h>
#include <aws/kinesisanalyticsv2/model/InputProcessingConfigurationDescription.h>
#include <aws/kinesisanalyticsv2/model/InputProcessingConfigurationUpdate.h>
#include <aws/kinesisanalyticsv2/model/InputSchemaUpdate.h>
#include <aws/kinesisanalyticsv2/model/InputStartingPosition.h>
#include <aws/kinesisanalyticsv2/model/InputStartingPositionConfiguration.h>
#include <aws/kinesisanalyticsv2/model/InputUpdate.h>
#include <aws/kinesisanalyticsv2/model/JSONMappingParameters.h>
#include <aws/kinesisanalyticsv2/model/KinesisFirehoseInput.h>
#include <aws/kinesisanalyticsv2/model/KinesisFirehoseInputDescription.h>
#include <aws/kinesisanalyticsv2/model/KinesisFirehoseInputUpdate.h>
#include <aws/kinesisanalyticsv2/model/KinesisFirehoseOutput.h>
#include <aws/kinesisanalyticsv2/model/KinesisFirehoseOutputDescription.h>
#include <aws/kinesisanalyticsv2/model/KinesisFirehoseOutputUpdate.h>
#include <aws/kinesisanalyticsv2/model/KinesisStreamsInput.h>
#include <aws/kinesisanalyticsv2/model/KinesisStreamsInputDescription.h>
#include <aws/kinesisanalyticsv2/model/KinesisStreamsInputUpdate.h>
#include <aws/kinesisanalyticsv2/model/KinesisStreamsOutput.h>
#include <aws/kinesisanalyticsv2/model/KinesisStreamsOutputDescription.h>
#include <aws/kinesisanalyticsv2/model/KinesisStreamsOutputUpdate.h>
#include <aws/kinesisanalyticsv2/model/LambdaOutput.h>
#include <aws/kinesisanalyticsv2/model/LambdaOutputDescription.h>
#include <aws/kinesisanalyticsv2/model/LambdaOutputUpdate.h>
#include <aws/kinesisanalyticsv2/model/ListApplicationOperationsRequest.h>
#include <aws/kinesisanalyticsv2/model/ListApplicationOperationsResult.h>
#include <aws/kinesisanalyticsv2/model/ListApplicationSnapshotsRequest.h>
#include <aws/kinesisanalyticsv2/model/ListApplicationSnapshotsResult.h>
#include <aws/kinesisanalyticsv2/model/ListApplicationVersionsRequest.h>
#include <aws/kinesisanalyticsv2/model/ListApplicationVersionsResult.h>
#include <aws/kinesisanalyticsv2/model/ListApplicationsRequest.h>
#include <aws/kinesisanalyticsv2/model/ListApplicationsResult.h>
#include <aws/kinesisanalyticsv2/model/ListTagsForResourceRequest.h>
#include <aws/kinesisanalyticsv2/model/ListTagsForResourceResult.h>
#include <aws/kinesisanalyticsv2/model/LogLevel.h>
#include <aws/kinesisanalyticsv2/model/MappingParameters.h>
#include <aws/kinesisanalyticsv2/model/MavenReference.h>
#include <aws/kinesisanalyticsv2/model/MetricsLevel.h>
#include <aws/kinesisanalyticsv2/model/MonitoringConfiguration.h>
#include <aws/kinesisanalyticsv2/model/MonitoringConfigurationDescription.h>
#include <aws/kinesisanalyticsv2/model/MonitoringConfigurationUpdate.h>
#include <aws/kinesisanalyticsv2/model/OperationFailureDetails.h>
#include <aws/kinesisanalyticsv2/model/OperationStatus.h>
#include <aws/kinesisanalyticsv2/model/Output.h>
#include <aws/kinesisanalyticsv2/model/OutputDescription.h>
#include <aws/kinesisanalyticsv2/model/OutputUpdate.h>
#include <aws/kinesisanalyticsv2/model/ParallelismConfiguration.h>
#include <aws/kinesisanalyticsv2/model/ParallelismConfigurationDescription.h>
#include <aws/kinesisanalyticsv2/model/ParallelismConfigurationUpdate.h>
#include <aws/kinesisanalyticsv2/model/PropertyGroup.h>
#include <aws/kinesisanalyticsv2/model/RecordColumn.h>
#include <aws/kinesisanalyticsv2/model/RecordFormat.h>
#include <aws/kinesisanalyticsv2/model/RecordFormatType.h>
#include <aws/kinesisanalyticsv2/model/ReferenceDataSource.h>
#include <aws/kinesisanalyticsv2/model/ReferenceDataSourceDescription.h>
#include <aws/kinesisanalyticsv2/model/ReferenceDataSourceUpdate.h>
#include <aws/kinesisanalyticsv2/model/RollbackApplicationRequest.h>
#include <aws/kinesisanalyticsv2/model/RollbackApplicationResult.h>
#include <aws/kinesisanalyticsv2/model/RunConfiguration.h>
#include <aws/kinesisanalyticsv2/model/RunConfigurationDescription.h>
#include <aws/kinesisanalyticsv2/model/RunConfigurationUpdate.h>
#include <aws/kinesisanalyticsv2/model/RuntimeEnvironment.h>
#include <aws/kinesisanalyticsv2/model/S3ApplicationCodeLocationDescription.h>
#include <aws/kinesisanalyticsv2/model/S3Configuration.h>
#include <aws/kinesisanalyticsv2/model/S3ContentBaseLocation.h>
#include <aws/kinesisanalyticsv2/model/S3ContentBaseLocationDescription.h>
#include <aws/kinesisanalyticsv2/model/S3ContentBaseLocationUpdate.h>
#include <aws/kinesisanalyticsv2/model/S3ContentLocation.h>
#include <aws/kinesisanalyticsv2/model/S3ContentLocationUpdate.h>
#include <aws/kinesisanalyticsv2/model/S3ReferenceDataSource.h>
#include <aws/kinesisanalyticsv2/model/S3ReferenceDataSourceDescription.h>
#include <aws/kinesisanalyticsv2/model/S3ReferenceDataSourceUpdate.h>
#include <aws/kinesisanalyticsv2/model/SnapshotDetails.h>
#include <aws/kinesisanalyticsv2/model/SnapshotStatus.h>
#include <aws/kinesisanalyticsv2/model/SourceSchema.h>
#include <aws/kinesisanalyticsv2/model/SqlApplicationConfiguration.h>
#include <aws/kinesisanalyticsv2/model/SqlApplicationConfigurationDescription.h>
#include <aws/kinesisanalyticsv2/model/SqlApplicationConfigurationUpdate.h>
#include <aws/kinesisanalyticsv2/model/SqlRunConfiguration.h>
#include <aws/kinesisanalyticsv2/model/StartApplicationRequest.h>
#include <aws/kinesisanalyticsv2/model/StartApplicationResult.h>
#include <aws/kinesisanalyticsv2/model/StopApplicationRequest.h>
#include <aws/kinesisanalyticsv2/model/StopApplicationResult.h>
#include <aws/kinesisanalyticsv2/model/Tag.h>
#include <aws/kinesisanalyticsv2/model/TagResourceRequest.h>
#include <aws/kinesisanalyticsv2/model/TagResourceResult.h>
#include <aws/kinesisanalyticsv2/model/UnableToDetectSchemaException.h>
#include <aws/kinesisanalyticsv2/model/UntagResourceRequest.h>
#include <aws/kinesisanalyticsv2/model/UntagResourceResult.h>
#include <aws/kinesisanalyticsv2/model/UpdateApplicationMaintenanceConfigurationRequest.h>
#include <aws/kinesisanalyticsv2/model/UpdateApplicationMaintenanceConfigurationResult.h>
#include <aws/kinesisanalyticsv2/model/UpdateApplicationRequest.h>
#include <aws/kinesisanalyticsv2/model/UpdateApplicationResult.h>
#include <aws/kinesisanalyticsv2/model/UrlType.h>
#include <aws/kinesisanalyticsv2/model/VpcConfiguration.h>
#include <aws/kinesisanalyticsv2/model/VpcConfigurationDescription.h>
#include <aws/kinesisanalyticsv2/model/VpcConfigurationUpdate.h>
#include <aws/kinesisanalyticsv2/model/ZeppelinApplicationConfiguration.h>
#include <aws/kinesisanalyticsv2/model/ZeppelinApplicationConfigurationDescription.h>
#include <aws/kinesisanalyticsv2/model/ZeppelinApplicationConfigurationUpdate.h>
#include <aws/kinesisanalyticsv2/model/ZeppelinMonitoringConfiguration.h>
#include <aws/kinesisanalyticsv2/model/ZeppelinMonitoringConfigurationDescription.h>
#include <aws/kinesisanalyticsv2/model/ZeppelinMonitoringConfigurationUpdate.h>

using KinesisAnalyticsV2IncludeTest = ::testing::Test;

TEST_F(KinesisAnalyticsV2IncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::KinesisAnalyticsV2::KinesisAnalyticsV2Client>("KinesisAnalyticsV2IncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
