/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/lakeformation/LakeFormationClient.h>
#include <aws/lakeformation/LakeFormationEndpointProvider.h>
#include <aws/lakeformation/LakeFormationEndpointRules.h>
#include <aws/lakeformation/LakeFormationErrorMarshaller.h>
#include <aws/lakeformation/LakeFormationErrors.h>
#include <aws/lakeformation/LakeFormationRequest.h>
#include <aws/lakeformation/LakeFormationServiceClientModel.h>
#include <aws/lakeformation/LakeFormation_EXPORTS.h>
#include <aws/lakeformation/model/AddLFTagsToResourceRequest.h>
#include <aws/lakeformation/model/AddLFTagsToResourceResult.h>
#include <aws/lakeformation/model/AddObjectInput.h>
#include <aws/lakeformation/model/AllRowsWildcard.h>
#include <aws/lakeformation/model/ApplicationStatus.h>
#include <aws/lakeformation/model/AssumeDecoratedRoleWithSAMLRequest.h>
#include <aws/lakeformation/model/AssumeDecoratedRoleWithSAMLResult.h>
#include <aws/lakeformation/model/AuditContext.h>
#include <aws/lakeformation/model/BatchGrantPermissionsRequest.h>
#include <aws/lakeformation/model/BatchGrantPermissionsResult.h>
#include <aws/lakeformation/model/BatchPermissionsFailureEntry.h>
#include <aws/lakeformation/model/BatchPermissionsRequestEntry.h>
#include <aws/lakeformation/model/BatchRevokePermissionsRequest.h>
#include <aws/lakeformation/model/BatchRevokePermissionsResult.h>
#include <aws/lakeformation/model/CancelTransactionRequest.h>
#include <aws/lakeformation/model/CancelTransactionResult.h>
#include <aws/lakeformation/model/CatalogResource.h>
#include <aws/lakeformation/model/ColumnLFTag.h>
#include <aws/lakeformation/model/ColumnWildcard.h>
#include <aws/lakeformation/model/CommitTransactionRequest.h>
#include <aws/lakeformation/model/CommitTransactionResult.h>
#include <aws/lakeformation/model/ComparisonOperator.h>
#include <aws/lakeformation/model/Condition.h>
#include <aws/lakeformation/model/CreateDataCellsFilterRequest.h>
#include <aws/lakeformation/model/CreateDataCellsFilterResult.h>
#include <aws/lakeformation/model/CreateLFTagExpressionRequest.h>
#include <aws/lakeformation/model/CreateLFTagExpressionResult.h>
#include <aws/lakeformation/model/CreateLFTagRequest.h>
#include <aws/lakeformation/model/CreateLFTagResult.h>
#include <aws/lakeformation/model/CreateLakeFormationIdentityCenterConfigurationRequest.h>
#include <aws/lakeformation/model/CreateLakeFormationIdentityCenterConfigurationResult.h>
#include <aws/lakeformation/model/CreateLakeFormationOptInRequest.h>
#include <aws/lakeformation/model/CreateLakeFormationOptInResult.h>
#include <aws/lakeformation/model/DataCellsFilter.h>
#include <aws/lakeformation/model/DataCellsFilterResource.h>
#include <aws/lakeformation/model/DataLakePrincipal.h>
#include <aws/lakeformation/model/DataLakeResourceType.h>
#include <aws/lakeformation/model/DataLakeSettings.h>
#include <aws/lakeformation/model/DataLocationResource.h>
#include <aws/lakeformation/model/DatabaseResource.h>
#include <aws/lakeformation/model/DeleteDataCellsFilterRequest.h>
#include <aws/lakeformation/model/DeleteDataCellsFilterResult.h>
#include <aws/lakeformation/model/DeleteLFTagExpressionRequest.h>
#include <aws/lakeformation/model/DeleteLFTagExpressionResult.h>
#include <aws/lakeformation/model/DeleteLFTagRequest.h>
#include <aws/lakeformation/model/DeleteLFTagResult.h>
#include <aws/lakeformation/model/DeleteLakeFormationIdentityCenterConfigurationRequest.h>
#include <aws/lakeformation/model/DeleteLakeFormationIdentityCenterConfigurationResult.h>
#include <aws/lakeformation/model/DeleteLakeFormationOptInRequest.h>
#include <aws/lakeformation/model/DeleteLakeFormationOptInResult.h>
#include <aws/lakeformation/model/DeleteObjectInput.h>
#include <aws/lakeformation/model/DeleteObjectsOnCancelRequest.h>
#include <aws/lakeformation/model/DeleteObjectsOnCancelResult.h>
#include <aws/lakeformation/model/DeregisterResourceRequest.h>
#include <aws/lakeformation/model/DeregisterResourceResult.h>
#include <aws/lakeformation/model/DescribeLakeFormationIdentityCenterConfigurationRequest.h>
#include <aws/lakeformation/model/DescribeLakeFormationIdentityCenterConfigurationResult.h>
#include <aws/lakeformation/model/DescribeResourceRequest.h>
#include <aws/lakeformation/model/DescribeResourceResult.h>
#include <aws/lakeformation/model/DescribeTransactionRequest.h>
#include <aws/lakeformation/model/DescribeTransactionResult.h>
#include <aws/lakeformation/model/DetailsMap.h>
#include <aws/lakeformation/model/EnableStatus.h>
#include <aws/lakeformation/model/ErrorDetail.h>
#include <aws/lakeformation/model/ExecutionStatistics.h>
#include <aws/lakeformation/model/ExtendTransactionRequest.h>
#include <aws/lakeformation/model/ExtendTransactionResult.h>
#include <aws/lakeformation/model/ExternalFilteringConfiguration.h>
#include <aws/lakeformation/model/FieldNameString.h>
#include <aws/lakeformation/model/FilterCondition.h>
#include <aws/lakeformation/model/GetDataCellsFilterRequest.h>
#include <aws/lakeformation/model/GetDataCellsFilterResult.h>
#include <aws/lakeformation/model/GetDataLakePrincipalRequest.h>
#include <aws/lakeformation/model/GetDataLakePrincipalResult.h>
#include <aws/lakeformation/model/GetDataLakeSettingsRequest.h>
#include <aws/lakeformation/model/GetDataLakeSettingsResult.h>
#include <aws/lakeformation/model/GetEffectivePermissionsForPathRequest.h>
#include <aws/lakeformation/model/GetEffectivePermissionsForPathResult.h>
#include <aws/lakeformation/model/GetLFTagExpressionRequest.h>
#include <aws/lakeformation/model/GetLFTagExpressionResult.h>
#include <aws/lakeformation/model/GetLFTagRequest.h>
#include <aws/lakeformation/model/GetLFTagResult.h>
#include <aws/lakeformation/model/GetQueryStateRequest.h>
#include <aws/lakeformation/model/GetQueryStateResult.h>
#include <aws/lakeformation/model/GetQueryStatisticsRequest.h>
#include <aws/lakeformation/model/GetQueryStatisticsResult.h>
#include <aws/lakeformation/model/GetResourceLFTagsRequest.h>
#include <aws/lakeformation/model/GetResourceLFTagsResult.h>
#include <aws/lakeformation/model/GetTableObjectsRequest.h>
#include <aws/lakeformation/model/GetTableObjectsResult.h>
#include <aws/lakeformation/model/GetTemporaryGluePartitionCredentialsRequest.h>
#include <aws/lakeformation/model/GetTemporaryGluePartitionCredentialsResult.h>
#include <aws/lakeformation/model/GetTemporaryGlueTableCredentialsRequest.h>
#include <aws/lakeformation/model/GetTemporaryGlueTableCredentialsResult.h>
#include <aws/lakeformation/model/GetWorkUnitResultsRequest.h>
#include <aws/lakeformation/model/GetWorkUnitResultsResult.h>
#include <aws/lakeformation/model/GetWorkUnitsRequest.h>
#include <aws/lakeformation/model/GetWorkUnitsResult.h>
#include <aws/lakeformation/model/GrantPermissionsRequest.h>
#include <aws/lakeformation/model/GrantPermissionsResult.h>
#include <aws/lakeformation/model/LFTag.h>
#include <aws/lakeformation/model/LFTagError.h>
#include <aws/lakeformation/model/LFTagExpression.h>
#include <aws/lakeformation/model/LFTagExpressionResource.h>
#include <aws/lakeformation/model/LFTagKeyResource.h>
#include <aws/lakeformation/model/LFTagPair.h>
#include <aws/lakeformation/model/LFTagPolicyResource.h>
#include <aws/lakeformation/model/LakeFormationOptInsInfo.h>
#include <aws/lakeformation/model/ListDataCellsFilterRequest.h>
#include <aws/lakeformation/model/ListDataCellsFilterResult.h>
#include <aws/lakeformation/model/ListLFTagExpressionsRequest.h>
#include <aws/lakeformation/model/ListLFTagExpressionsResult.h>
#include <aws/lakeformation/model/ListLFTagsRequest.h>
#include <aws/lakeformation/model/ListLFTagsResult.h>
#include <aws/lakeformation/model/ListLakeFormationOptInsRequest.h>
#include <aws/lakeformation/model/ListLakeFormationOptInsResult.h>
#include <aws/lakeformation/model/ListPermissionsRequest.h>
#include <aws/lakeformation/model/ListPermissionsResult.h>
#include <aws/lakeformation/model/ListResourcesRequest.h>
#include <aws/lakeformation/model/ListResourcesResult.h>
#include <aws/lakeformation/model/ListTableStorageOptimizersRequest.h>
#include <aws/lakeformation/model/ListTableStorageOptimizersResult.h>
#include <aws/lakeformation/model/ListTransactionsRequest.h>
#include <aws/lakeformation/model/ListTransactionsResult.h>
#include <aws/lakeformation/model/OptimizerType.h>
#include <aws/lakeformation/model/PartitionObjects.h>
#include <aws/lakeformation/model/PartitionValueList.h>
#include <aws/lakeformation/model/Permission.h>
#include <aws/lakeformation/model/PermissionType.h>
#include <aws/lakeformation/model/PlanningStatistics.h>
#include <aws/lakeformation/model/PrincipalPermissions.h>
#include <aws/lakeformation/model/PrincipalResourcePermissions.h>
#include <aws/lakeformation/model/PutDataLakeSettingsRequest.h>
#include <aws/lakeformation/model/PutDataLakeSettingsResult.h>
#include <aws/lakeformation/model/QueryPlanningContext.h>
#include <aws/lakeformation/model/QuerySessionContext.h>
#include <aws/lakeformation/model/QueryStateString.h>
#include <aws/lakeformation/model/RegisterResourceRequest.h>
#include <aws/lakeformation/model/RegisterResourceResult.h>
#include <aws/lakeformation/model/RemoveLFTagsFromResourceRequest.h>
#include <aws/lakeformation/model/RemoveLFTagsFromResourceResult.h>
#include <aws/lakeformation/model/Resource.h>
#include <aws/lakeformation/model/ResourceInfo.h>
#include <aws/lakeformation/model/ResourceShareType.h>
#include <aws/lakeformation/model/ResourceType.h>
#include <aws/lakeformation/model/RevokePermissionsRequest.h>
#include <aws/lakeformation/model/RevokePermissionsResult.h>
#include <aws/lakeformation/model/RowFilter.h>
#include <aws/lakeformation/model/SearchDatabasesByLFTagsRequest.h>
#include <aws/lakeformation/model/SearchDatabasesByLFTagsResult.h>
#include <aws/lakeformation/model/SearchTablesByLFTagsRequest.h>
#include <aws/lakeformation/model/SearchTablesByLFTagsResult.h>
#include <aws/lakeformation/model/StartQueryPlanningRequest.h>
#include <aws/lakeformation/model/StartQueryPlanningResult.h>
#include <aws/lakeformation/model/StartTransactionRequest.h>
#include <aws/lakeformation/model/StartTransactionResult.h>
#include <aws/lakeformation/model/StorageOptimizer.h>
#include <aws/lakeformation/model/TableObject.h>
#include <aws/lakeformation/model/TableResource.h>
#include <aws/lakeformation/model/TableWildcard.h>
#include <aws/lakeformation/model/TableWithColumnsResource.h>
#include <aws/lakeformation/model/TaggedDatabase.h>
#include <aws/lakeformation/model/TaggedTable.h>
#include <aws/lakeformation/model/TransactionDescription.h>
#include <aws/lakeformation/model/TransactionStatus.h>
#include <aws/lakeformation/model/TransactionStatusFilter.h>
#include <aws/lakeformation/model/TransactionType.h>
#include <aws/lakeformation/model/UpdateDataCellsFilterRequest.h>
#include <aws/lakeformation/model/UpdateDataCellsFilterResult.h>
#include <aws/lakeformation/model/UpdateLFTagExpressionRequest.h>
#include <aws/lakeformation/model/UpdateLFTagExpressionResult.h>
#include <aws/lakeformation/model/UpdateLFTagRequest.h>
#include <aws/lakeformation/model/UpdateLFTagResult.h>
#include <aws/lakeformation/model/UpdateLakeFormationIdentityCenterConfigurationRequest.h>
#include <aws/lakeformation/model/UpdateLakeFormationIdentityCenterConfigurationResult.h>
#include <aws/lakeformation/model/UpdateResourceRequest.h>
#include <aws/lakeformation/model/UpdateResourceResult.h>
#include <aws/lakeformation/model/UpdateTableObjectsRequest.h>
#include <aws/lakeformation/model/UpdateTableObjectsResult.h>
#include <aws/lakeformation/model/UpdateTableStorageOptimizerRequest.h>
#include <aws/lakeformation/model/UpdateTableStorageOptimizerResult.h>
#include <aws/lakeformation/model/VirtualObject.h>
#include <aws/lakeformation/model/WorkUnitRange.h>
#include <aws/lakeformation/model/WriteOperation.h>

using LakeFormationIncludeTest = ::testing::Test;

TEST_F(LakeFormationIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::LakeFormation::LakeFormationClient>("LakeFormationIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
