/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/lambda/LambdaClient.h>
#include <aws/lambda/LambdaEndpointProvider.h>
#include <aws/lambda/LambdaEndpointRules.h>
#include <aws/lambda/LambdaErrorMarshaller.h>
#include <aws/lambda/LambdaErrors.h>
#include <aws/lambda/LambdaRequest.h>
#include <aws/lambda/LambdaServiceClientModel.h>
#include <aws/lambda/Lambda_EXPORTS.h>
#include <aws/lambda/model/AccountLimit.h>
#include <aws/lambda/model/AccountUsage.h>
#include <aws/lambda/model/AddLayerVersionPermissionRequest.h>
#include <aws/lambda/model/AddLayerVersionPermissionResult.h>
#include <aws/lambda/model/AddPermissionRequest.h>
#include <aws/lambda/model/AddPermissionResult.h>
#include <aws/lambda/model/AliasConfiguration.h>
#include <aws/lambda/model/AliasRoutingConfiguration.h>
#include <aws/lambda/model/AllowedPublishers.h>
#include <aws/lambda/model/AmazonManagedKafkaEventSourceConfig.h>
#include <aws/lambda/model/ApplicationLogLevel.h>
#include <aws/lambda/model/Architecture.h>
#include <aws/lambda/model/CodeSigningConfig.h>
#include <aws/lambda/model/CodeSigningConfigNotFoundException.h>
#include <aws/lambda/model/CodeSigningPolicies.h>
#include <aws/lambda/model/CodeSigningPolicy.h>
#include <aws/lambda/model/CodeStorageExceededException.h>
#include <aws/lambda/model/CodeVerificationFailedException.h>
#include <aws/lambda/model/Concurrency.h>
#include <aws/lambda/model/Cors.h>
#include <aws/lambda/model/CreateAliasRequest.h>
#include <aws/lambda/model/CreateAliasResult.h>
#include <aws/lambda/model/CreateCodeSigningConfigRequest.h>
#include <aws/lambda/model/CreateCodeSigningConfigResult.h>
#include <aws/lambda/model/CreateEventSourceMappingRequest.h>
#include <aws/lambda/model/CreateEventSourceMappingResult.h>
#include <aws/lambda/model/CreateFunctionRequest.h>
#include <aws/lambda/model/CreateFunctionResult.h>
#include <aws/lambda/model/CreateFunctionUrlConfigRequest.h>
#include <aws/lambda/model/CreateFunctionUrlConfigResult.h>
#include <aws/lambda/model/DeadLetterConfig.h>
#include <aws/lambda/model/DeleteAliasRequest.h>
#include <aws/lambda/model/DeleteCodeSigningConfigRequest.h>
#include <aws/lambda/model/DeleteCodeSigningConfigResult.h>
#include <aws/lambda/model/DeleteEventSourceMappingRequest.h>
#include <aws/lambda/model/DeleteEventSourceMappingResult.h>
#include <aws/lambda/model/DeleteFunctionCodeSigningConfigRequest.h>
#include <aws/lambda/model/DeleteFunctionConcurrencyRequest.h>
#include <aws/lambda/model/DeleteFunctionEventInvokeConfigRequest.h>
#include <aws/lambda/model/DeleteFunctionRequest.h>
#include <aws/lambda/model/DeleteFunctionUrlConfigRequest.h>
#include <aws/lambda/model/DeleteLayerVersionRequest.h>
#include <aws/lambda/model/DeleteProvisionedConcurrencyConfigRequest.h>
#include <aws/lambda/model/DestinationConfig.h>
#include <aws/lambda/model/DocumentDBEventSourceConfig.h>
#include <aws/lambda/model/EC2AccessDeniedException.h>
#include <aws/lambda/model/EC2ThrottledException.h>
#include <aws/lambda/model/EC2UnexpectedException.h>
#include <aws/lambda/model/EFSIOException.h>
#include <aws/lambda/model/EFSMountConnectivityException.h>
#include <aws/lambda/model/EFSMountFailureException.h>
#include <aws/lambda/model/EFSMountTimeoutException.h>
#include <aws/lambda/model/ENILimitReachedException.h>
#include <aws/lambda/model/EndPointType.h>
#include <aws/lambda/model/Environment.h>
#include <aws/lambda/model/EnvironmentError.h>
#include <aws/lambda/model/EnvironmentResponse.h>
#include <aws/lambda/model/EphemeralStorage.h>
#include <aws/lambda/model/EventSourceMappingConfiguration.h>
#include <aws/lambda/model/EventSourceMappingMetric.h>
#include <aws/lambda/model/EventSourceMappingMetricsConfig.h>
#include <aws/lambda/model/EventSourcePosition.h>
#include <aws/lambda/model/FileSystemConfig.h>
#include <aws/lambda/model/Filter.h>
#include <aws/lambda/model/FilterCriteria.h>
#include <aws/lambda/model/FilterCriteriaError.h>
#include <aws/lambda/model/FullDocument.h>
#include <aws/lambda/model/FunctionCode.h>
#include <aws/lambda/model/FunctionCodeLocation.h>
#include <aws/lambda/model/FunctionConfiguration.h>
#include <aws/lambda/model/FunctionEventInvokeConfig.h>
#include <aws/lambda/model/FunctionResponseType.h>
#include <aws/lambda/model/FunctionUrlAuthType.h>
#include <aws/lambda/model/FunctionUrlConfig.h>
#include <aws/lambda/model/FunctionVersion.h>
#include <aws/lambda/model/GetAccountSettingsRequest.h>
#include <aws/lambda/model/GetAccountSettingsResult.h>
#include <aws/lambda/model/GetAliasRequest.h>
#include <aws/lambda/model/GetAliasResult.h>
#include <aws/lambda/model/GetCodeSigningConfigRequest.h>
#include <aws/lambda/model/GetCodeSigningConfigResult.h>
#include <aws/lambda/model/GetEventSourceMappingRequest.h>
#include <aws/lambda/model/GetEventSourceMappingResult.h>
#include <aws/lambda/model/GetFunctionCodeSigningConfigRequest.h>
#include <aws/lambda/model/GetFunctionCodeSigningConfigResult.h>
#include <aws/lambda/model/GetFunctionConcurrencyRequest.h>
#include <aws/lambda/model/GetFunctionConcurrencyResult.h>
#include <aws/lambda/model/GetFunctionConfigurationRequest.h>
#include <aws/lambda/model/GetFunctionConfigurationResult.h>
#include <aws/lambda/model/GetFunctionEventInvokeConfigRequest.h>
#include <aws/lambda/model/GetFunctionEventInvokeConfigResult.h>
#include <aws/lambda/model/GetFunctionRecursionConfigRequest.h>
#include <aws/lambda/model/GetFunctionRecursionConfigResult.h>
#include <aws/lambda/model/GetFunctionRequest.h>
#include <aws/lambda/model/GetFunctionResult.h>
#include <aws/lambda/model/GetFunctionUrlConfigRequest.h>
#include <aws/lambda/model/GetFunctionUrlConfigResult.h>
#include <aws/lambda/model/GetLayerVersionByArnRequest.h>
#include <aws/lambda/model/GetLayerVersionByArnResult.h>
#include <aws/lambda/model/GetLayerVersionPolicyRequest.h>
#include <aws/lambda/model/GetLayerVersionPolicyResult.h>
#include <aws/lambda/model/GetLayerVersionRequest.h>
#include <aws/lambda/model/GetLayerVersionResult.h>
#include <aws/lambda/model/GetPolicyRequest.h>
#include <aws/lambda/model/GetPolicyResult.h>
#include <aws/lambda/model/GetProvisionedConcurrencyConfigRequest.h>
#include <aws/lambda/model/GetProvisionedConcurrencyConfigResult.h>
#include <aws/lambda/model/GetRuntimeManagementConfigRequest.h>
#include <aws/lambda/model/GetRuntimeManagementConfigResult.h>
#include <aws/lambda/model/ImageConfig.h>
#include <aws/lambda/model/ImageConfigError.h>
#include <aws/lambda/model/ImageConfigResponse.h>
#include <aws/lambda/model/InvalidCodeSignatureException.h>
#include <aws/lambda/model/InvalidParameterValueException.h>
#include <aws/lambda/model/InvalidRequestContentException.h>
#include <aws/lambda/model/InvalidRuntimeException.h>
#include <aws/lambda/model/InvalidSecurityGroupIDException.h>
#include <aws/lambda/model/InvalidSubnetIDException.h>
#include <aws/lambda/model/InvalidZipFileException.h>
#include <aws/lambda/model/InvocationType.h>
#include <aws/lambda/model/InvokeMode.h>
#include <aws/lambda/model/InvokeRequest.h>
#include <aws/lambda/model/InvokeResponseStreamUpdate.h>
#include <aws/lambda/model/InvokeResult.h>
#include <aws/lambda/model/InvokeWithResponseStreamCompleteEvent.h>
#include <aws/lambda/model/InvokeWithResponseStreamHandler.h>
#include <aws/lambda/model/InvokeWithResponseStreamInitialResponse.h>
#include <aws/lambda/model/InvokeWithResponseStreamRequest.h>
#include <aws/lambda/model/InvokeWithResponseStreamResponseEvent.h>
#include <aws/lambda/model/KMSAccessDeniedException.h>
#include <aws/lambda/model/KMSDisabledException.h>
#include <aws/lambda/model/KMSInvalidStateException.h>
#include <aws/lambda/model/KMSNotFoundException.h>
#include <aws/lambda/model/KafkaSchemaRegistryAccessConfig.h>
#include <aws/lambda/model/KafkaSchemaRegistryAuthType.h>
#include <aws/lambda/model/KafkaSchemaRegistryConfig.h>
#include <aws/lambda/model/KafkaSchemaValidationAttribute.h>
#include <aws/lambda/model/KafkaSchemaValidationConfig.h>
#include <aws/lambda/model/LastUpdateStatus.h>
#include <aws/lambda/model/LastUpdateStatusReasonCode.h>
#include <aws/lambda/model/Layer.h>
#include <aws/lambda/model/LayerVersionContentInput.h>
#include <aws/lambda/model/LayerVersionContentOutput.h>
#include <aws/lambda/model/LayerVersionsListItem.h>
#include <aws/lambda/model/LayersListItem.h>
#include <aws/lambda/model/ListAliasesRequest.h>
#include <aws/lambda/model/ListAliasesResult.h>
#include <aws/lambda/model/ListCodeSigningConfigsRequest.h>
#include <aws/lambda/model/ListCodeSigningConfigsResult.h>
#include <aws/lambda/model/ListEventSourceMappingsRequest.h>
#include <aws/lambda/model/ListEventSourceMappingsResult.h>
#include <aws/lambda/model/ListFunctionEventInvokeConfigsRequest.h>
#include <aws/lambda/model/ListFunctionEventInvokeConfigsResult.h>
#include <aws/lambda/model/ListFunctionUrlConfigsRequest.h>
#include <aws/lambda/model/ListFunctionUrlConfigsResult.h>
#include <aws/lambda/model/ListFunctionsByCodeSigningConfigRequest.h>
#include <aws/lambda/model/ListFunctionsByCodeSigningConfigResult.h>
#include <aws/lambda/model/ListFunctionsRequest.h>
#include <aws/lambda/model/ListFunctionsResult.h>
#include <aws/lambda/model/ListLayerVersionsRequest.h>
#include <aws/lambda/model/ListLayerVersionsResult.h>
#include <aws/lambda/model/ListLayersRequest.h>
#include <aws/lambda/model/ListLayersResult.h>
#include <aws/lambda/model/ListProvisionedConcurrencyConfigsRequest.h>
#include <aws/lambda/model/ListProvisionedConcurrencyConfigsResult.h>
#include <aws/lambda/model/ListTagsRequest.h>
#include <aws/lambda/model/ListTagsResult.h>
#include <aws/lambda/model/ListVersionsByFunctionRequest.h>
#include <aws/lambda/model/ListVersionsByFunctionResult.h>
#include <aws/lambda/model/LogFormat.h>
#include <aws/lambda/model/LogType.h>
#include <aws/lambda/model/LoggingConfig.h>
#include <aws/lambda/model/OnFailure.h>
#include <aws/lambda/model/OnSuccess.h>
#include <aws/lambda/model/PackageType.h>
#include <aws/lambda/model/PolicyLengthExceededException.h>
#include <aws/lambda/model/PreconditionFailedException.h>
#include <aws/lambda/model/ProvisionedConcurrencyConfigListItem.h>
#include <aws/lambda/model/ProvisionedConcurrencyConfigNotFoundException.h>
#include <aws/lambda/model/ProvisionedConcurrencyStatusEnum.h>
#include <aws/lambda/model/ProvisionedPollerConfig.h>
#include <aws/lambda/model/PublishLayerVersionRequest.h>
#include <aws/lambda/model/PublishLayerVersionResult.h>
#include <aws/lambda/model/PublishVersionRequest.h>
#include <aws/lambda/model/PublishVersionResult.h>
#include <aws/lambda/model/PutFunctionCodeSigningConfigRequest.h>
#include <aws/lambda/model/PutFunctionCodeSigningConfigResult.h>
#include <aws/lambda/model/PutFunctionConcurrencyRequest.h>
#include <aws/lambda/model/PutFunctionConcurrencyResult.h>
#include <aws/lambda/model/PutFunctionEventInvokeConfigRequest.h>
#include <aws/lambda/model/PutFunctionEventInvokeConfigResult.h>
#include <aws/lambda/model/PutFunctionRecursionConfigRequest.h>
#include <aws/lambda/model/PutFunctionRecursionConfigResult.h>
#include <aws/lambda/model/PutProvisionedConcurrencyConfigRequest.h>
#include <aws/lambda/model/PutProvisionedConcurrencyConfigResult.h>
#include <aws/lambda/model/PutRuntimeManagementConfigRequest.h>
#include <aws/lambda/model/PutRuntimeManagementConfigResult.h>
#include <aws/lambda/model/RecursiveInvocationException.h>
#include <aws/lambda/model/RecursiveLoop.h>
#include <aws/lambda/model/RemoveLayerVersionPermissionRequest.h>
#include <aws/lambda/model/RemovePermissionRequest.h>
#include <aws/lambda/model/RequestTooLargeException.h>
#include <aws/lambda/model/ResourceConflictException.h>
#include <aws/lambda/model/ResourceInUseException.h>
#include <aws/lambda/model/ResourceNotFoundException.h>
#include <aws/lambda/model/ResourceNotReadyException.h>
#include <aws/lambda/model/ResponseStreamingInvocationType.h>
#include <aws/lambda/model/Runtime.h>
#include <aws/lambda/model/RuntimeVersionConfig.h>
#include <aws/lambda/model/RuntimeVersionError.h>
#include <aws/lambda/model/ScalingConfig.h>
#include <aws/lambda/model/SchemaRegistryEventRecordFormat.h>
#include <aws/lambda/model/SelfManagedEventSource.h>
#include <aws/lambda/model/SelfManagedKafkaEventSourceConfig.h>
#include <aws/lambda/model/ServiceException.h>
#include <aws/lambda/model/SnapStart.h>
#include <aws/lambda/model/SnapStartApplyOn.h>
#include <aws/lambda/model/SnapStartException.h>
#include <aws/lambda/model/SnapStartNotReadyException.h>
#include <aws/lambda/model/SnapStartOptimizationStatus.h>
#include <aws/lambda/model/SnapStartResponse.h>
#include <aws/lambda/model/SnapStartTimeoutException.h>
#include <aws/lambda/model/SourceAccessConfiguration.h>
#include <aws/lambda/model/SourceAccessType.h>
#include <aws/lambda/model/State.h>
#include <aws/lambda/model/StateReasonCode.h>
#include <aws/lambda/model/SubnetIPAddressLimitReachedException.h>
#include <aws/lambda/model/SystemLogLevel.h>
#include <aws/lambda/model/TagResourceRequest.h>
#include <aws/lambda/model/TagsError.h>
#include <aws/lambda/model/ThrottleReason.h>
#include <aws/lambda/model/TooManyRequestsException.h>
#include <aws/lambda/model/TracingConfig.h>
#include <aws/lambda/model/TracingConfigResponse.h>
#include <aws/lambda/model/TracingMode.h>
#include <aws/lambda/model/UnsupportedMediaTypeException.h>
#include <aws/lambda/model/UntagResourceRequest.h>
#include <aws/lambda/model/UpdateAliasRequest.h>
#include <aws/lambda/model/UpdateAliasResult.h>
#include <aws/lambda/model/UpdateCodeSigningConfigRequest.h>
#include <aws/lambda/model/UpdateCodeSigningConfigResult.h>
#include <aws/lambda/model/UpdateEventSourceMappingRequest.h>
#include <aws/lambda/model/UpdateEventSourceMappingResult.h>
#include <aws/lambda/model/UpdateFunctionCodeRequest.h>
#include <aws/lambda/model/UpdateFunctionCodeResult.h>
#include <aws/lambda/model/UpdateFunctionConfigurationRequest.h>
#include <aws/lambda/model/UpdateFunctionConfigurationResult.h>
#include <aws/lambda/model/UpdateFunctionEventInvokeConfigRequest.h>
#include <aws/lambda/model/UpdateFunctionEventInvokeConfigResult.h>
#include <aws/lambda/model/UpdateFunctionUrlConfigRequest.h>
#include <aws/lambda/model/UpdateFunctionUrlConfigResult.h>
#include <aws/lambda/model/UpdateRuntimeOn.h>
#include <aws/lambda/model/VpcConfig.h>
#include <aws/lambda/model/VpcConfigResponse.h>

using LambdaIncludeTest = ::testing::Test;

TEST_F(LambdaIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::Lambda::LambdaClient>("LambdaIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
