/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/lexv2-models/LexModelsV2Client.h>
#include <aws/lexv2-models/LexModelsV2EndpointProvider.h>
#include <aws/lexv2-models/LexModelsV2EndpointRules.h>
#include <aws/lexv2-models/LexModelsV2ErrorMarshaller.h>
#include <aws/lexv2-models/LexModelsV2Errors.h>
#include <aws/lexv2-models/LexModelsV2Request.h>
#include <aws/lexv2-models/LexModelsV2ServiceClientModel.h>
#include <aws/lexv2-models/LexModelsV2_EXPORTS.h>
#include <aws/lexv2-models/model/ActiveContext.h>
#include <aws/lexv2-models/model/AdvancedRecognitionSetting.h>
#include <aws/lexv2-models/model/AgentTurnResult.h>
#include <aws/lexv2-models/model/AgentTurnSpecification.h>
#include <aws/lexv2-models/model/AggregatedUtterancesFilter.h>
#include <aws/lexv2-models/model/AggregatedUtterancesFilterName.h>
#include <aws/lexv2-models/model/AggregatedUtterancesFilterOperator.h>
#include <aws/lexv2-models/model/AggregatedUtterancesSortAttribute.h>
#include <aws/lexv2-models/model/AggregatedUtterancesSortBy.h>
#include <aws/lexv2-models/model/AggregatedUtterancesSummary.h>
#include <aws/lexv2-models/model/AllowedInputTypes.h>
#include <aws/lexv2-models/model/AnalyticsBinByName.h>
#include <aws/lexv2-models/model/AnalyticsBinBySpecification.h>
#include <aws/lexv2-models/model/AnalyticsBinKey.h>
#include <aws/lexv2-models/model/AnalyticsCommonFilterName.h>
#include <aws/lexv2-models/model/AnalyticsFilterOperator.h>
#include <aws/lexv2-models/model/AnalyticsIntentField.h>
#include <aws/lexv2-models/model/AnalyticsIntentFilter.h>
#include <aws/lexv2-models/model/AnalyticsIntentFilterName.h>
#include <aws/lexv2-models/model/AnalyticsIntentGroupByKey.h>
#include <aws/lexv2-models/model/AnalyticsIntentGroupBySpecification.h>
#include <aws/lexv2-models/model/AnalyticsIntentMetric.h>
#include <aws/lexv2-models/model/AnalyticsIntentMetricName.h>
#include <aws/lexv2-models/model/AnalyticsIntentMetricResult.h>
#include <aws/lexv2-models/model/AnalyticsIntentNodeSummary.h>
#include <aws/lexv2-models/model/AnalyticsIntentResult.h>
#include <aws/lexv2-models/model/AnalyticsIntentStageField.h>
#include <aws/lexv2-models/model/AnalyticsIntentStageFilter.h>
#include <aws/lexv2-models/model/AnalyticsIntentStageFilterName.h>
#include <aws/lexv2-models/model/AnalyticsIntentStageGroupByKey.h>
#include <aws/lexv2-models/model/AnalyticsIntentStageGroupBySpecification.h>
#include <aws/lexv2-models/model/AnalyticsIntentStageMetric.h>
#include <aws/lexv2-models/model/AnalyticsIntentStageMetricName.h>
#include <aws/lexv2-models/model/AnalyticsIntentStageMetricResult.h>
#include <aws/lexv2-models/model/AnalyticsIntentStageResult.h>
#include <aws/lexv2-models/model/AnalyticsInterval.h>
#include <aws/lexv2-models/model/AnalyticsMetricStatistic.h>
#include <aws/lexv2-models/model/AnalyticsModality.h>
#include <aws/lexv2-models/model/AnalyticsNodeType.h>
#include <aws/lexv2-models/model/AnalyticsPathFilter.h>
#include <aws/lexv2-models/model/AnalyticsSessionField.h>
#include <aws/lexv2-models/model/AnalyticsSessionFilter.h>
#include <aws/lexv2-models/model/AnalyticsSessionFilterName.h>
#include <aws/lexv2-models/model/AnalyticsSessionGroupByKey.h>
#include <aws/lexv2-models/model/AnalyticsSessionGroupBySpecification.h>
#include <aws/lexv2-models/model/AnalyticsSessionMetric.h>
#include <aws/lexv2-models/model/AnalyticsSessionMetricName.h>
#include <aws/lexv2-models/model/AnalyticsSessionMetricResult.h>
#include <aws/lexv2-models/model/AnalyticsSessionResult.h>
#include <aws/lexv2-models/model/AnalyticsSessionSortByName.h>
#include <aws/lexv2-models/model/AnalyticsSortOrder.h>
#include <aws/lexv2-models/model/AnalyticsUtteranceAttribute.h>
#include <aws/lexv2-models/model/AnalyticsUtteranceAttributeName.h>
#include <aws/lexv2-models/model/AnalyticsUtteranceAttributeResult.h>
#include <aws/lexv2-models/model/AnalyticsUtteranceField.h>
#include <aws/lexv2-models/model/AnalyticsUtteranceFilter.h>
#include <aws/lexv2-models/model/AnalyticsUtteranceFilterName.h>
#include <aws/lexv2-models/model/AnalyticsUtteranceGroupByKey.h>
#include <aws/lexv2-models/model/AnalyticsUtteranceGroupBySpecification.h>
#include <aws/lexv2-models/model/AnalyticsUtteranceMetric.h>
#include <aws/lexv2-models/model/AnalyticsUtteranceMetricName.h>
#include <aws/lexv2-models/model/AnalyticsUtteranceMetricResult.h>
#include <aws/lexv2-models/model/AnalyticsUtteranceResult.h>
#include <aws/lexv2-models/model/AnalyticsUtteranceSortByName.h>
#include <aws/lexv2-models/model/AssociatedTranscript.h>
#include <aws/lexv2-models/model/AssociatedTranscriptFilter.h>
#include <aws/lexv2-models/model/AssociatedTranscriptFilterName.h>
#include <aws/lexv2-models/model/AudioAndDTMFInputSpecification.h>
#include <aws/lexv2-models/model/AudioLogDestination.h>
#include <aws/lexv2-models/model/AudioLogSetting.h>
#include <aws/lexv2-models/model/AudioRecognitionStrategy.h>
#include <aws/lexv2-models/model/AudioSpecification.h>
#include <aws/lexv2-models/model/BatchCreateCustomVocabularyItemRequest.h>
#include <aws/lexv2-models/model/BatchCreateCustomVocabularyItemResult.h>
#include <aws/lexv2-models/model/BatchDeleteCustomVocabularyItemRequest.h>
#include <aws/lexv2-models/model/BatchDeleteCustomVocabularyItemResult.h>
#include <aws/lexv2-models/model/BatchUpdateCustomVocabularyItemRequest.h>
#include <aws/lexv2-models/model/BatchUpdateCustomVocabularyItemResult.h>
#include <aws/lexv2-models/model/BedrockGuardrailConfiguration.h>
#include <aws/lexv2-models/model/BedrockKnowledgeStoreConfiguration.h>
#include <aws/lexv2-models/model/BedrockKnowledgeStoreExactResponseFields.h>
#include <aws/lexv2-models/model/BedrockModelSpecification.h>
#include <aws/lexv2-models/model/BedrockTraceStatus.h>
#include <aws/lexv2-models/model/BotAliasHistoryEvent.h>
#include <aws/lexv2-models/model/BotAliasLocaleSettings.h>
#include <aws/lexv2-models/model/BotAliasReplicaSummary.h>
#include <aws/lexv2-models/model/BotAliasReplicationStatus.h>
#include <aws/lexv2-models/model/BotAliasStatus.h>
#include <aws/lexv2-models/model/BotAliasSummary.h>
#include <aws/lexv2-models/model/BotAliasTestExecutionTarget.h>
#include <aws/lexv2-models/model/BotExportSpecification.h>
#include <aws/lexv2-models/model/BotFilter.h>
#include <aws/lexv2-models/model/BotFilterName.h>
#include <aws/lexv2-models/model/BotFilterOperator.h>
#include <aws/lexv2-models/model/BotImportSpecification.h>
#include <aws/lexv2-models/model/BotLocaleExportSpecification.h>
#include <aws/lexv2-models/model/BotLocaleFilter.h>
#include <aws/lexv2-models/model/BotLocaleFilterName.h>
#include <aws/lexv2-models/model/BotLocaleFilterOperator.h>
#include <aws/lexv2-models/model/BotLocaleHistoryEvent.h>
#include <aws/lexv2-models/model/BotLocaleImportSpecification.h>
#include <aws/lexv2-models/model/BotLocaleSortAttribute.h>
#include <aws/lexv2-models/model/BotLocaleSortBy.h>
#include <aws/lexv2-models/model/BotLocaleStatus.h>
#include <aws/lexv2-models/model/BotLocaleSummary.h>
#include <aws/lexv2-models/model/BotMember.h>
#include <aws/lexv2-models/model/BotRecommendationResultStatistics.h>
#include <aws/lexv2-models/model/BotRecommendationResults.h>
#include <aws/lexv2-models/model/BotRecommendationStatus.h>
#include <aws/lexv2-models/model/BotRecommendationSummary.h>
#include <aws/lexv2-models/model/BotReplicaStatus.h>
#include <aws/lexv2-models/model/BotReplicaSummary.h>
#include <aws/lexv2-models/model/BotSortAttribute.h>
#include <aws/lexv2-models/model/BotSortBy.h>
#include <aws/lexv2-models/model/BotStatus.h>
#include <aws/lexv2-models/model/BotSummary.h>
#include <aws/lexv2-models/model/BotType.h>
#include <aws/lexv2-models/model/BotVersionLocaleDetails.h>
#include <aws/lexv2-models/model/BotVersionReplicaSortAttribute.h>
#include <aws/lexv2-models/model/BotVersionReplicaSortBy.h>
#include <aws/lexv2-models/model/BotVersionReplicaSummary.h>
#include <aws/lexv2-models/model/BotVersionReplicationStatus.h>
#include <aws/lexv2-models/model/BotVersionSortAttribute.h>
#include <aws/lexv2-models/model/BotVersionSortBy.h>
#include <aws/lexv2-models/model/BotVersionSummary.h>
#include <aws/lexv2-models/model/BuildBotLocaleRequest.h>
#include <aws/lexv2-models/model/BuildBotLocaleResult.h>
#include <aws/lexv2-models/model/BuildtimeSettings.h>
#include <aws/lexv2-models/model/BuiltInIntentSortAttribute.h>
#include <aws/lexv2-models/model/BuiltInIntentSortBy.h>
#include <aws/lexv2-models/model/BuiltInIntentSummary.h>
#include <aws/lexv2-models/model/BuiltInSlotTypeSortAttribute.h>
#include <aws/lexv2-models/model/BuiltInSlotTypeSortBy.h>
#include <aws/lexv2-models/model/BuiltInSlotTypeSummary.h>
#include <aws/lexv2-models/model/Button.h>
#include <aws/lexv2-models/model/CloudWatchLogGroupLogDestination.h>
#include <aws/lexv2-models/model/CodeHookSpecification.h>
#include <aws/lexv2-models/model/CompositeSlotTypeSetting.h>
#include <aws/lexv2-models/model/Condition.h>
#include <aws/lexv2-models/model/ConditionalBranch.h>
#include <aws/lexv2-models/model/ConditionalSpecification.h>
#include <aws/lexv2-models/model/ConversationEndState.h>
#include <aws/lexv2-models/model/ConversationLevelIntentClassificationResultItem.h>
#include <aws/lexv2-models/model/ConversationLevelResultDetail.h>
#include <aws/lexv2-models/model/ConversationLevelSlotResolutionResultItem.h>
#include <aws/lexv2-models/model/ConversationLevelTestResultItem.h>
#include <aws/lexv2-models/model/ConversationLevelTestResults.h>
#include <aws/lexv2-models/model/ConversationLevelTestResultsFilterBy.h>
#include <aws/lexv2-models/model/ConversationLogSettings.h>
#include <aws/lexv2-models/model/ConversationLogsDataSource.h>
#include <aws/lexv2-models/model/ConversationLogsDataSourceFilterBy.h>
#include <aws/lexv2-models/model/ConversationLogsInputModeFilter.h>
#include <aws/lexv2-models/model/CreateBotAliasRequest.h>
#include <aws/lexv2-models/model/CreateBotAliasResult.h>
#include <aws/lexv2-models/model/CreateBotLocaleRequest.h>
#include <aws/lexv2-models/model/CreateBotLocaleResult.h>
#include <aws/lexv2-models/model/CreateBotReplicaRequest.h>
#include <aws/lexv2-models/model/CreateBotReplicaResult.h>
#include <aws/lexv2-models/model/CreateBotRequest.h>
#include <aws/lexv2-models/model/CreateBotResult.h>
#include <aws/lexv2-models/model/CreateBotVersionRequest.h>
#include <aws/lexv2-models/model/CreateBotVersionResult.h>
#include <aws/lexv2-models/model/CreateExportRequest.h>
#include <aws/lexv2-models/model/CreateExportResult.h>
#include <aws/lexv2-models/model/CreateIntentRequest.h>
#include <aws/lexv2-models/model/CreateIntentResult.h>
#include <aws/lexv2-models/model/CreateResourcePolicyRequest.h>
#include <aws/lexv2-models/model/CreateResourcePolicyResult.h>
#include <aws/lexv2-models/model/CreateResourcePolicyStatementRequest.h>
#include <aws/lexv2-models/model/CreateResourcePolicyStatementResult.h>
#include <aws/lexv2-models/model/CreateSlotRequest.h>
#include <aws/lexv2-models/model/CreateSlotResult.h>
#include <aws/lexv2-models/model/CreateSlotTypeRequest.h>
#include <aws/lexv2-models/model/CreateSlotTypeResult.h>
#include <aws/lexv2-models/model/CreateTestSetDiscrepancyReportRequest.h>
#include <aws/lexv2-models/model/CreateTestSetDiscrepancyReportResult.h>
#include <aws/lexv2-models/model/CreateUploadUrlRequest.h>
#include <aws/lexv2-models/model/CreateUploadUrlResult.h>
#include <aws/lexv2-models/model/CustomPayload.h>
#include <aws/lexv2-models/model/CustomVocabularyEntryId.h>
#include <aws/lexv2-models/model/CustomVocabularyExportSpecification.h>
#include <aws/lexv2-models/model/CustomVocabularyImportSpecification.h>
#include <aws/lexv2-models/model/CustomVocabularyItem.h>
#include <aws/lexv2-models/model/CustomVocabularyStatus.h>
#include <aws/lexv2-models/model/DTMFSpecification.h>
#include <aws/lexv2-models/model/DataPrivacy.h>
#include <aws/lexv2-models/model/DataSourceConfiguration.h>
#include <aws/lexv2-models/model/DateRangeFilter.h>
#include <aws/lexv2-models/model/DefaultConditionalBranch.h>
#include <aws/lexv2-models/model/DeleteBotAliasRequest.h>
#include <aws/lexv2-models/model/DeleteBotAliasResult.h>
#include <aws/lexv2-models/model/DeleteBotLocaleRequest.h>
#include <aws/lexv2-models/model/DeleteBotLocaleResult.h>
#include <aws/lexv2-models/model/DeleteBotReplicaRequest.h>
#include <aws/lexv2-models/model/DeleteBotReplicaResult.h>
#include <aws/lexv2-models/model/DeleteBotRequest.h>
#include <aws/lexv2-models/model/DeleteBotResult.h>
#include <aws/lexv2-models/model/DeleteBotVersionRequest.h>
#include <aws/lexv2-models/model/DeleteBotVersionResult.h>
#include <aws/lexv2-models/model/DeleteCustomVocabularyRequest.h>
#include <aws/lexv2-models/model/DeleteCustomVocabularyResult.h>
#include <aws/lexv2-models/model/DeleteExportRequest.h>
#include <aws/lexv2-models/model/DeleteExportResult.h>
#include <aws/lexv2-models/model/DeleteImportRequest.h>
#include <aws/lexv2-models/model/DeleteImportResult.h>
#include <aws/lexv2-models/model/DeleteIntentRequest.h>
#include <aws/lexv2-models/model/DeleteResourcePolicyRequest.h>
#include <aws/lexv2-models/model/DeleteResourcePolicyResult.h>
#include <aws/lexv2-models/model/DeleteResourcePolicyStatementRequest.h>
#include <aws/lexv2-models/model/DeleteResourcePolicyStatementResult.h>
#include <aws/lexv2-models/model/DeleteSlotRequest.h>
#include <aws/lexv2-models/model/DeleteSlotTypeRequest.h>
#include <aws/lexv2-models/model/DeleteTestSetRequest.h>
#include <aws/lexv2-models/model/DeleteUtterancesRequest.h>
#include <aws/lexv2-models/model/DeleteUtterancesResult.h>
#include <aws/lexv2-models/model/DescribeBotAliasRequest.h>
#include <aws/lexv2-models/model/DescribeBotAliasResult.h>
#include <aws/lexv2-models/model/DescribeBotLocaleRequest.h>
#include <aws/lexv2-models/model/DescribeBotLocaleResult.h>
#include <aws/lexv2-models/model/DescribeBotRecommendationRequest.h>
#include <aws/lexv2-models/model/DescribeBotRecommendationResult.h>
#include <aws/lexv2-models/model/DescribeBotReplicaRequest.h>
#include <aws/lexv2-models/model/DescribeBotReplicaResult.h>
#include <aws/lexv2-models/model/DescribeBotRequest.h>
#include <aws/lexv2-models/model/DescribeBotResourceGenerationRequest.h>
#include <aws/lexv2-models/model/DescribeBotResourceGenerationResult.h>
#include <aws/lexv2-models/model/DescribeBotResult.h>
#include <aws/lexv2-models/model/DescribeBotVersionRequest.h>
#include <aws/lexv2-models/model/DescribeBotVersionResult.h>
#include <aws/lexv2-models/model/DescribeCustomVocabularyMetadataRequest.h>
#include <aws/lexv2-models/model/DescribeCustomVocabularyMetadataResult.h>
#include <aws/lexv2-models/model/DescribeExportRequest.h>
#include <aws/lexv2-models/model/DescribeExportResult.h>
#include <aws/lexv2-models/model/DescribeImportRequest.h>
#include <aws/lexv2-models/model/DescribeImportResult.h>
#include <aws/lexv2-models/model/DescribeIntentRequest.h>
#include <aws/lexv2-models/model/DescribeIntentResult.h>
#include <aws/lexv2-models/model/DescribeResourcePolicyRequest.h>
#include <aws/lexv2-models/model/DescribeResourcePolicyResult.h>
#include <aws/lexv2-models/model/DescribeSlotRequest.h>
#include <aws/lexv2-models/model/DescribeSlotResult.h>
#include <aws/lexv2-models/model/DescribeSlotTypeRequest.h>
#include <aws/lexv2-models/model/DescribeSlotTypeResult.h>
#include <aws/lexv2-models/model/DescribeTestExecutionRequest.h>
#include <aws/lexv2-models/model/DescribeTestExecutionResult.h>
#include <aws/lexv2-models/model/DescribeTestSetDiscrepancyReportRequest.h>
#include <aws/lexv2-models/model/DescribeTestSetDiscrepancyReportResult.h>
#include <aws/lexv2-models/model/DescribeTestSetGenerationRequest.h>
#include <aws/lexv2-models/model/DescribeTestSetGenerationResult.h>
#include <aws/lexv2-models/model/DescribeTestSetRequest.h>
#include <aws/lexv2-models/model/DescribeTestSetResult.h>
#include <aws/lexv2-models/model/DescriptiveBotBuilderSpecification.h>
#include <aws/lexv2-models/model/DialogAction.h>
#include <aws/lexv2-models/model/DialogActionType.h>
#include <aws/lexv2-models/model/DialogCodeHookInvocationSetting.h>
#include <aws/lexv2-models/model/DialogCodeHookSettings.h>
#include <aws/lexv2-models/model/DialogState.h>
#include <aws/lexv2-models/model/Effect.h>
#include <aws/lexv2-models/model/ElicitationCodeHookInvocationSetting.h>
#include <aws/lexv2-models/model/EncryptionSetting.h>
#include <aws/lexv2-models/model/ErrorCode.h>
#include <aws/lexv2-models/model/ErrorLogSettings.h>
#include <aws/lexv2-models/model/ExactResponseFields.h>
#include <aws/lexv2-models/model/ExecutionErrorDetails.h>
#include <aws/lexv2-models/model/ExportFilter.h>
#include <aws/lexv2-models/model/ExportFilterName.h>
#include <aws/lexv2-models/model/ExportFilterOperator.h>
#include <aws/lexv2-models/model/ExportResourceSpecification.h>
#include <aws/lexv2-models/model/ExportSortAttribute.h>
#include <aws/lexv2-models/model/ExportSortBy.h>
#include <aws/lexv2-models/model/ExportStatus.h>
#include <aws/lexv2-models/model/ExportSummary.h>
#include <aws/lexv2-models/model/ExternalSourceSetting.h>
#include <aws/lexv2-models/model/FailedCustomVocabularyItem.h>
#include <aws/lexv2-models/model/FulfillmentCodeHookSettings.h>
#include <aws/lexv2-models/model/FulfillmentStartResponseSpecification.h>
#include <aws/lexv2-models/model/FulfillmentUpdateResponseSpecification.h>
#include <aws/lexv2-models/model/FulfillmentUpdatesSpecification.h>
#include <aws/lexv2-models/model/GenerateBotElementRequest.h>
#include <aws/lexv2-models/model/GenerateBotElementResult.h>
#include <aws/lexv2-models/model/GenerationSortBy.h>
#include <aws/lexv2-models/model/GenerationSortByAttribute.h>
#include <aws/lexv2-models/model/GenerationStatus.h>
#include <aws/lexv2-models/model/GenerationSummary.h>
#include <aws/lexv2-models/model/GenerativeAISettings.h>
#include <aws/lexv2-models/model/GetTestExecutionArtifactsUrlRequest.h>
#include <aws/lexv2-models/model/GetTestExecutionArtifactsUrlResult.h>
#include <aws/lexv2-models/model/GrammarSlotTypeSetting.h>
#include <aws/lexv2-models/model/GrammarSlotTypeSource.h>
#include <aws/lexv2-models/model/ImageResponseCard.h>
#include <aws/lexv2-models/model/ImportExportFileFormat.h>
#include <aws/lexv2-models/model/ImportFilter.h>
#include <aws/lexv2-models/model/ImportFilterName.h>
#include <aws/lexv2-models/model/ImportFilterOperator.h>
#include <aws/lexv2-models/model/ImportResourceSpecification.h>
#include <aws/lexv2-models/model/ImportResourceType.h>
#include <aws/lexv2-models/model/ImportSortAttribute.h>
#include <aws/lexv2-models/model/ImportSortBy.h>
#include <aws/lexv2-models/model/ImportStatus.h>
#include <aws/lexv2-models/model/ImportSummary.h>
#include <aws/lexv2-models/model/InitialResponseSetting.h>
#include <aws/lexv2-models/model/InputContext.h>
#include <aws/lexv2-models/model/InputSessionStateSpecification.h>
#include <aws/lexv2-models/model/IntentClassificationTestResultItem.h>
#include <aws/lexv2-models/model/IntentClassificationTestResultItemCounts.h>
#include <aws/lexv2-models/model/IntentClassificationTestResults.h>
#include <aws/lexv2-models/model/IntentClosingSetting.h>
#include <aws/lexv2-models/model/IntentConfirmationSetting.h>
#include <aws/lexv2-models/model/IntentFilter.h>
#include <aws/lexv2-models/model/IntentFilterName.h>
#include <aws/lexv2-models/model/IntentFilterOperator.h>
#include <aws/lexv2-models/model/IntentLevelSlotResolutionTestResultItem.h>
#include <aws/lexv2-models/model/IntentLevelSlotResolutionTestResults.h>
#include <aws/lexv2-models/model/IntentOverride.h>
#include <aws/lexv2-models/model/IntentSortAttribute.h>
#include <aws/lexv2-models/model/IntentSortBy.h>
#include <aws/lexv2-models/model/IntentState.h>
#include <aws/lexv2-models/model/IntentStatistics.h>
#include <aws/lexv2-models/model/IntentSummary.h>
#include <aws/lexv2-models/model/InvokedIntentSample.h>
#include <aws/lexv2-models/model/KendraConfiguration.h>
#include <aws/lexv2-models/model/LambdaCodeHook.h>
#include <aws/lexv2-models/model/LexTranscriptFilter.h>
#include <aws/lexv2-models/model/ListAggregatedUtterancesRequest.h>
#include <aws/lexv2-models/model/ListAggregatedUtterancesResult.h>
#include <aws/lexv2-models/model/ListBotAliasReplicasRequest.h>
#include <aws/lexv2-models/model/ListBotAliasReplicasResult.h>
#include <aws/lexv2-models/model/ListBotAliasesRequest.h>
#include <aws/lexv2-models/model/ListBotAliasesResult.h>
#include <aws/lexv2-models/model/ListBotLocalesRequest.h>
#include <aws/lexv2-models/model/ListBotLocalesResult.h>
#include <aws/lexv2-models/model/ListBotRecommendationsRequest.h>
#include <aws/lexv2-models/model/ListBotRecommendationsResult.h>
#include <aws/lexv2-models/model/ListBotReplicasRequest.h>
#include <aws/lexv2-models/model/ListBotReplicasResult.h>
#include <aws/lexv2-models/model/ListBotResourceGenerationsRequest.h>
#include <aws/lexv2-models/model/ListBotResourceGenerationsResult.h>
#include <aws/lexv2-models/model/ListBotVersionReplicasRequest.h>
#include <aws/lexv2-models/model/ListBotVersionReplicasResult.h>
#include <aws/lexv2-models/model/ListBotVersionsRequest.h>
#include <aws/lexv2-models/model/ListBotVersionsResult.h>
#include <aws/lexv2-models/model/ListBotsRequest.h>
#include <aws/lexv2-models/model/ListBotsResult.h>
#include <aws/lexv2-models/model/ListBuiltInIntentsRequest.h>
#include <aws/lexv2-models/model/ListBuiltInIntentsResult.h>
#include <aws/lexv2-models/model/ListBuiltInSlotTypesRequest.h>
#include <aws/lexv2-models/model/ListBuiltInSlotTypesResult.h>
#include <aws/lexv2-models/model/ListCustomVocabularyItemsRequest.h>
#include <aws/lexv2-models/model/ListCustomVocabularyItemsResult.h>
#include <aws/lexv2-models/model/ListExportsRequest.h>
#include <aws/lexv2-models/model/ListExportsResult.h>
#include <aws/lexv2-models/model/ListImportsRequest.h>
#include <aws/lexv2-models/model/ListImportsResult.h>
#include <aws/lexv2-models/model/ListIntentMetricsRequest.h>
#include <aws/lexv2-models/model/ListIntentMetricsResult.h>
#include <aws/lexv2-models/model/ListIntentPathsRequest.h>
#include <aws/lexv2-models/model/ListIntentPathsResult.h>
#include <aws/lexv2-models/model/ListIntentStageMetricsRequest.h>
#include <aws/lexv2-models/model/ListIntentStageMetricsResult.h>
#include <aws/lexv2-models/model/ListIntentsRequest.h>
#include <aws/lexv2-models/model/ListIntentsResult.h>
#include <aws/lexv2-models/model/ListRecommendedIntentsRequest.h>
#include <aws/lexv2-models/model/ListRecommendedIntentsResult.h>
#include <aws/lexv2-models/model/ListSessionAnalyticsDataRequest.h>
#include <aws/lexv2-models/model/ListSessionAnalyticsDataResult.h>
#include <aws/lexv2-models/model/ListSessionMetricsRequest.h>
#include <aws/lexv2-models/model/ListSessionMetricsResult.h>
#include <aws/lexv2-models/model/ListSlotTypesRequest.h>
#include <aws/lexv2-models/model/ListSlotTypesResult.h>
#include <aws/lexv2-models/model/ListSlotsRequest.h>
#include <aws/lexv2-models/model/ListSlotsResult.h>
#include <aws/lexv2-models/model/ListTagsForResourceRequest.h>
#include <aws/lexv2-models/model/ListTagsForResourceResult.h>
#include <aws/lexv2-models/model/ListTestExecutionResultItemsRequest.h>
#include <aws/lexv2-models/model/ListTestExecutionResultItemsResult.h>
#include <aws/lexv2-models/model/ListTestExecutionsRequest.h>
#include <aws/lexv2-models/model/ListTestExecutionsResult.h>
#include <aws/lexv2-models/model/ListTestSetRecordsRequest.h>
#include <aws/lexv2-models/model/ListTestSetRecordsResult.h>
#include <aws/lexv2-models/model/ListTestSetsRequest.h>
#include <aws/lexv2-models/model/ListTestSetsResult.h>
#include <aws/lexv2-models/model/ListUtteranceAnalyticsDataRequest.h>
#include <aws/lexv2-models/model/ListUtteranceAnalyticsDataResult.h>
#include <aws/lexv2-models/model/ListUtteranceMetricsRequest.h>
#include <aws/lexv2-models/model/ListUtteranceMetricsResult.h>
#include <aws/lexv2-models/model/MergeStrategy.h>
#include <aws/lexv2-models/model/Message.h>
#include <aws/lexv2-models/model/MessageGroup.h>
#include <aws/lexv2-models/model/MessageSelectionStrategy.h>
#include <aws/lexv2-models/model/MultipleValuesSetting.h>
#include <aws/lexv2-models/model/NewCustomVocabularyItem.h>
#include <aws/lexv2-models/model/NluImprovementSpecification.h>
#include <aws/lexv2-models/model/ObfuscationSetting.h>
#include <aws/lexv2-models/model/ObfuscationSettingType.h>
#include <aws/lexv2-models/model/OpensearchConfiguration.h>
#include <aws/lexv2-models/model/OutputContext.h>
#include <aws/lexv2-models/model/OverallTestResultItem.h>
#include <aws/lexv2-models/model/OverallTestResults.h>
#include <aws/lexv2-models/model/ParentBotNetwork.h>
#include <aws/lexv2-models/model/PathFormat.h>
#include <aws/lexv2-models/model/PlainTextMessage.h>
#include <aws/lexv2-models/model/PostDialogCodeHookInvocationSpecification.h>
#include <aws/lexv2-models/model/PostFulfillmentStatusSpecification.h>
#include <aws/lexv2-models/model/Principal.h>
#include <aws/lexv2-models/model/PromptAttempt.h>
#include <aws/lexv2-models/model/PromptAttemptSpecification.h>
#include <aws/lexv2-models/model/PromptSpecification.h>
#include <aws/lexv2-models/model/QInConnectAssistantConfiguration.h>
#include <aws/lexv2-models/model/QInConnectIntentConfiguration.h>
#include <aws/lexv2-models/model/QnAIntentConfiguration.h>
#include <aws/lexv2-models/model/QnAKendraConfiguration.h>
#include <aws/lexv2-models/model/RecommendedIntentSummary.h>
#include <aws/lexv2-models/model/RelativeAggregationDuration.h>
#include <aws/lexv2-models/model/ResponseSpecification.h>
#include <aws/lexv2-models/model/RuntimeHintDetails.h>
#include <aws/lexv2-models/model/RuntimeHintValue.h>
#include <aws/lexv2-models/model/RuntimeHints.h>
#include <aws/lexv2-models/model/RuntimeSettings.h>
#include <aws/lexv2-models/model/S3BucketLogDestination.h>
#include <aws/lexv2-models/model/S3BucketTranscriptSource.h>
#include <aws/lexv2-models/model/SSMLMessage.h>
#include <aws/lexv2-models/model/SampleUtterance.h>
#include <aws/lexv2-models/model/SampleUtteranceGenerationSpecification.h>
#include <aws/lexv2-models/model/SampleValue.h>
#include <aws/lexv2-models/model/SearchAssociatedTranscriptsRequest.h>
#include <aws/lexv2-models/model/SearchAssociatedTranscriptsResult.h>
#include <aws/lexv2-models/model/SearchOrder.h>
#include <aws/lexv2-models/model/SentimentAnalysisSettings.h>
#include <aws/lexv2-models/model/SessionDataSortBy.h>
#include <aws/lexv2-models/model/SessionSpecification.h>
#include <aws/lexv2-models/model/SlotCaptureSetting.h>
#include <aws/lexv2-models/model/SlotConstraint.h>
#include <aws/lexv2-models/model/SlotDefaultValue.h>
#include <aws/lexv2-models/model/SlotDefaultValueSpecification.h>
#include <aws/lexv2-models/model/SlotFilter.h>
#include <aws/lexv2-models/model/SlotFilterName.h>
#include <aws/lexv2-models/model/SlotFilterOperator.h>
#include <aws/lexv2-models/model/SlotPriority.h>
#include <aws/lexv2-models/model/SlotResolutionImprovementSpecification.h>
#include <aws/lexv2-models/model/SlotResolutionSetting.h>
#include <aws/lexv2-models/model/SlotResolutionStrategy.h>
#include <aws/lexv2-models/model/SlotResolutionTestResultItem.h>
#include <aws/lexv2-models/model/SlotResolutionTestResultItemCounts.h>
#include <aws/lexv2-models/model/SlotShape.h>
#include <aws/lexv2-models/model/SlotSortAttribute.h>
#include <aws/lexv2-models/model/SlotSortBy.h>
#include <aws/lexv2-models/model/SlotSummary.h>
#include <aws/lexv2-models/model/SlotTypeCategory.h>
#include <aws/lexv2-models/model/SlotTypeFilter.h>
#include <aws/lexv2-models/model/SlotTypeFilterName.h>
#include <aws/lexv2-models/model/SlotTypeFilterOperator.h>
#include <aws/lexv2-models/model/SlotTypeSortAttribute.h>
#include <aws/lexv2-models/model/SlotTypeSortBy.h>
#include <aws/lexv2-models/model/SlotTypeStatistics.h>
#include <aws/lexv2-models/model/SlotTypeSummary.h>
#include <aws/lexv2-models/model/SlotTypeValue.h>
#include <aws/lexv2-models/model/SlotValue.h>
#include <aws/lexv2-models/model/SlotValueElicitationSetting.h>
#include <aws/lexv2-models/model/SlotValueOverride.h>
#include <aws/lexv2-models/model/SlotValueRegexFilter.h>
#include <aws/lexv2-models/model/SlotValueResolutionStrategy.h>
#include <aws/lexv2-models/model/SlotValueSelectionSetting.h>
#include <aws/lexv2-models/model/SortOrder.h>
#include <aws/lexv2-models/model/Specifications.h>
#include <aws/lexv2-models/model/StartBotRecommendationRequest.h>
#include <aws/lexv2-models/model/StartBotRecommendationResult.h>
#include <aws/lexv2-models/model/StartBotResourceGenerationRequest.h>
#include <aws/lexv2-models/model/StartBotResourceGenerationResult.h>
#include <aws/lexv2-models/model/StartImportRequest.h>
#include <aws/lexv2-models/model/StartImportResult.h>
#include <aws/lexv2-models/model/StartTestExecutionRequest.h>
#include <aws/lexv2-models/model/StartTestExecutionResult.h>
#include <aws/lexv2-models/model/StartTestSetGenerationRequest.h>
#include <aws/lexv2-models/model/StartTestSetGenerationResult.h>
#include <aws/lexv2-models/model/StillWaitingResponseSpecification.h>
#include <aws/lexv2-models/model/StopBotRecommendationRequest.h>
#include <aws/lexv2-models/model/StopBotRecommendationResult.h>
#include <aws/lexv2-models/model/SubSlotSetting.h>
#include <aws/lexv2-models/model/SubSlotTypeComposition.h>
#include <aws/lexv2-models/model/SubSlotValueElicitationSetting.h>
#include <aws/lexv2-models/model/TagResourceRequest.h>
#include <aws/lexv2-models/model/TagResourceResult.h>
#include <aws/lexv2-models/model/TestExecutionApiMode.h>
#include <aws/lexv2-models/model/TestExecutionModality.h>
#include <aws/lexv2-models/model/TestExecutionResultFilterBy.h>
#include <aws/lexv2-models/model/TestExecutionResultItems.h>
#include <aws/lexv2-models/model/TestExecutionSortAttribute.h>
#include <aws/lexv2-models/model/TestExecutionSortBy.h>
#include <aws/lexv2-models/model/TestExecutionStatus.h>
#include <aws/lexv2-models/model/TestExecutionSummary.h>
#include <aws/lexv2-models/model/TestExecutionTarget.h>
#include <aws/lexv2-models/model/TestResultMatchStatus.h>
#include <aws/lexv2-models/model/TestResultTypeFilter.h>
#include <aws/lexv2-models/model/TestSetDiscrepancyErrors.h>
#include <aws/lexv2-models/model/TestSetDiscrepancyReportBotAliasTarget.h>
#include <aws/lexv2-models/model/TestSetDiscrepancyReportResourceTarget.h>
#include <aws/lexv2-models/model/TestSetDiscrepancyReportStatus.h>
#include <aws/lexv2-models/model/TestSetExportSpecification.h>
#include <aws/lexv2-models/model/TestSetGenerationDataSource.h>
#include <aws/lexv2-models/model/TestSetGenerationStatus.h>
#include <aws/lexv2-models/model/TestSetImportInputLocation.h>
#include <aws/lexv2-models/model/TestSetImportResourceSpecification.h>
#include <aws/lexv2-models/model/TestSetIntentDiscrepancyItem.h>
#include <aws/lexv2-models/model/TestSetModality.h>
#include <aws/lexv2-models/model/TestSetSlotDiscrepancyItem.h>
#include <aws/lexv2-models/model/TestSetSortAttribute.h>
#include <aws/lexv2-models/model/TestSetSortBy.h>
#include <aws/lexv2-models/model/TestSetStatus.h>
#include <aws/lexv2-models/model/TestSetStorageLocation.h>
#include <aws/lexv2-models/model/TestSetSummary.h>
#include <aws/lexv2-models/model/TestSetTurnRecord.h>
#include <aws/lexv2-models/model/TestSetTurnResult.h>
#include <aws/lexv2-models/model/TextInputSpecification.h>
#include <aws/lexv2-models/model/TextLogDestination.h>
#include <aws/lexv2-models/model/TextLogSetting.h>
#include <aws/lexv2-models/model/ThrottlingException.h>
#include <aws/lexv2-models/model/TimeDimension.h>
#include <aws/lexv2-models/model/TranscriptFilter.h>
#include <aws/lexv2-models/model/TranscriptFormat.h>
#include <aws/lexv2-models/model/TranscriptSourceSetting.h>
#include <aws/lexv2-models/model/TurnSpecification.h>
#include <aws/lexv2-models/model/UntagResourceRequest.h>
#include <aws/lexv2-models/model/UntagResourceResult.h>
#include <aws/lexv2-models/model/UpdateBotAliasRequest.h>
#include <aws/lexv2-models/model/UpdateBotAliasResult.h>
#include <aws/lexv2-models/model/UpdateBotLocaleRequest.h>
#include <aws/lexv2-models/model/UpdateBotLocaleResult.h>
#include <aws/lexv2-models/model/UpdateBotRecommendationRequest.h>
#include <aws/lexv2-models/model/UpdateBotRecommendationResult.h>
#include <aws/lexv2-models/model/UpdateBotRequest.h>
#include <aws/lexv2-models/model/UpdateBotResult.h>
#include <aws/lexv2-models/model/UpdateExportRequest.h>
#include <aws/lexv2-models/model/UpdateExportResult.h>
#include <aws/lexv2-models/model/UpdateIntentRequest.h>
#include <aws/lexv2-models/model/UpdateIntentResult.h>
#include <aws/lexv2-models/model/UpdateResourcePolicyRequest.h>
#include <aws/lexv2-models/model/UpdateResourcePolicyResult.h>
#include <aws/lexv2-models/model/UpdateSlotRequest.h>
#include <aws/lexv2-models/model/UpdateSlotResult.h>
#include <aws/lexv2-models/model/UpdateSlotTypeRequest.h>
#include <aws/lexv2-models/model/UpdateSlotTypeResult.h>
#include <aws/lexv2-models/model/UpdateTestSetRequest.h>
#include <aws/lexv2-models/model/UpdateTestSetResult.h>
#include <aws/lexv2-models/model/UserTurnInputSpecification.h>
#include <aws/lexv2-models/model/UserTurnIntentOutput.h>
#include <aws/lexv2-models/model/UserTurnOutputSpecification.h>
#include <aws/lexv2-models/model/UserTurnResult.h>
#include <aws/lexv2-models/model/UserTurnSlotOutput.h>
#include <aws/lexv2-models/model/UserTurnSpecification.h>
#include <aws/lexv2-models/model/UtteranceAggregationDuration.h>
#include <aws/lexv2-models/model/UtteranceAudioInputSpecification.h>
#include <aws/lexv2-models/model/UtteranceBotResponse.h>
#include <aws/lexv2-models/model/UtteranceContentType.h>
#include <aws/lexv2-models/model/UtteranceDataSortBy.h>
#include <aws/lexv2-models/model/UtteranceInputSpecification.h>
#include <aws/lexv2-models/model/UtteranceLevelTestResultItem.h>
#include <aws/lexv2-models/model/UtteranceLevelTestResults.h>
#include <aws/lexv2-models/model/UtteranceSpecification.h>
#include <aws/lexv2-models/model/VoiceEngine.h>
#include <aws/lexv2-models/model/VoiceSettings.h>
#include <aws/lexv2-models/model/WaitAndContinueSpecification.h>

using LexModelsV2IncludeTest = ::testing::Test;

TEST_F(LexModelsV2IncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::LexModelsV2::LexModelsV2Client>("LexModelsV2IncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
