/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/license-manager/LicenseManagerClient.h>
#include <aws/license-manager/LicenseManagerEndpointProvider.h>
#include <aws/license-manager/LicenseManagerEndpointRules.h>
#include <aws/license-manager/LicenseManagerErrorMarshaller.h>
#include <aws/license-manager/LicenseManagerErrors.h>
#include <aws/license-manager/LicenseManagerRequest.h>
#include <aws/license-manager/LicenseManagerServiceClientModel.h>
#include <aws/license-manager/LicenseManager_EXPORTS.h>
#include <aws/license-manager/model/AcceptGrantRequest.h>
#include <aws/license-manager/model/AcceptGrantResult.h>
#include <aws/license-manager/model/ActivationOverrideBehavior.h>
#include <aws/license-manager/model/AllowedOperation.h>
#include <aws/license-manager/model/AutomatedDiscoveryInformation.h>
#include <aws/license-manager/model/BorrowConfiguration.h>
#include <aws/license-manager/model/CheckInLicenseRequest.h>
#include <aws/license-manager/model/CheckInLicenseResult.h>
#include <aws/license-manager/model/CheckoutBorrowLicenseRequest.h>
#include <aws/license-manager/model/CheckoutBorrowLicenseResult.h>
#include <aws/license-manager/model/CheckoutLicenseRequest.h>
#include <aws/license-manager/model/CheckoutLicenseResult.h>
#include <aws/license-manager/model/CheckoutType.h>
#include <aws/license-manager/model/ConsumedLicenseSummary.h>
#include <aws/license-manager/model/ConsumptionConfiguration.h>
#include <aws/license-manager/model/CreateGrantRequest.h>
#include <aws/license-manager/model/CreateGrantResult.h>
#include <aws/license-manager/model/CreateGrantVersionRequest.h>
#include <aws/license-manager/model/CreateGrantVersionResult.h>
#include <aws/license-manager/model/CreateLicenseConfigurationRequest.h>
#include <aws/license-manager/model/CreateLicenseConfigurationResult.h>
#include <aws/license-manager/model/CreateLicenseConversionTaskForResourceRequest.h>
#include <aws/license-manager/model/CreateLicenseConversionTaskForResourceResult.h>
#include <aws/license-manager/model/CreateLicenseManagerReportGeneratorRequest.h>
#include <aws/license-manager/model/CreateLicenseManagerReportGeneratorResult.h>
#include <aws/license-manager/model/CreateLicenseRequest.h>
#include <aws/license-manager/model/CreateLicenseResult.h>
#include <aws/license-manager/model/CreateLicenseVersionRequest.h>
#include <aws/license-manager/model/CreateLicenseVersionResult.h>
#include <aws/license-manager/model/CreateTokenRequest.h>
#include <aws/license-manager/model/CreateTokenResult.h>
#include <aws/license-manager/model/DatetimeRange.h>
#include <aws/license-manager/model/DeleteGrantRequest.h>
#include <aws/license-manager/model/DeleteGrantResult.h>
#include <aws/license-manager/model/DeleteLicenseConfigurationRequest.h>
#include <aws/license-manager/model/DeleteLicenseConfigurationResult.h>
#include <aws/license-manager/model/DeleteLicenseManagerReportGeneratorRequest.h>
#include <aws/license-manager/model/DeleteLicenseManagerReportGeneratorResult.h>
#include <aws/license-manager/model/DeleteLicenseRequest.h>
#include <aws/license-manager/model/DeleteLicenseResult.h>
#include <aws/license-manager/model/DeleteTokenRequest.h>
#include <aws/license-manager/model/DeleteTokenResult.h>
#include <aws/license-manager/model/DigitalSignatureMethod.h>
#include <aws/license-manager/model/Entitlement.h>
#include <aws/license-manager/model/EntitlementData.h>
#include <aws/license-manager/model/EntitlementDataUnit.h>
#include <aws/license-manager/model/EntitlementUnit.h>
#include <aws/license-manager/model/EntitlementUsage.h>
#include <aws/license-manager/model/ExtendLicenseConsumptionRequest.h>
#include <aws/license-manager/model/ExtendLicenseConsumptionResult.h>
#include <aws/license-manager/model/FailedDependencyException.h>
#include <aws/license-manager/model/Filter.h>
#include <aws/license-manager/model/GetAccessTokenRequest.h>
#include <aws/license-manager/model/GetAccessTokenResult.h>
#include <aws/license-manager/model/GetGrantRequest.h>
#include <aws/license-manager/model/GetGrantResult.h>
#include <aws/license-manager/model/GetLicenseConfigurationRequest.h>
#include <aws/license-manager/model/GetLicenseConfigurationResult.h>
#include <aws/license-manager/model/GetLicenseConversionTaskRequest.h>
#include <aws/license-manager/model/GetLicenseConversionTaskResult.h>
#include <aws/license-manager/model/GetLicenseManagerReportGeneratorRequest.h>
#include <aws/license-manager/model/GetLicenseManagerReportGeneratorResult.h>
#include <aws/license-manager/model/GetLicenseRequest.h>
#include <aws/license-manager/model/GetLicenseResult.h>
#include <aws/license-manager/model/GetLicenseUsageRequest.h>
#include <aws/license-manager/model/GetLicenseUsageResult.h>
#include <aws/license-manager/model/GetServiceSettingsRequest.h>
#include <aws/license-manager/model/GetServiceSettingsResult.h>
#include <aws/license-manager/model/Grant.h>
#include <aws/license-manager/model/GrantStatus.h>
#include <aws/license-manager/model/GrantedLicense.h>
#include <aws/license-manager/model/InventoryFilter.h>
#include <aws/license-manager/model/InventoryFilterCondition.h>
#include <aws/license-manager/model/Issuer.h>
#include <aws/license-manager/model/IssuerDetails.h>
#include <aws/license-manager/model/License.h>
#include <aws/license-manager/model/LicenseConfiguration.h>
#include <aws/license-manager/model/LicenseConfigurationAssociation.h>
#include <aws/license-manager/model/LicenseConfigurationStatus.h>
#include <aws/license-manager/model/LicenseConfigurationUsage.h>
#include <aws/license-manager/model/LicenseConversionContext.h>
#include <aws/license-manager/model/LicenseConversionTask.h>
#include <aws/license-manager/model/LicenseConversionTaskStatus.h>
#include <aws/license-manager/model/LicenseCountingType.h>
#include <aws/license-manager/model/LicenseDeletionStatus.h>
#include <aws/license-manager/model/LicenseOperationFailure.h>
#include <aws/license-manager/model/LicenseSpecification.h>
#include <aws/license-manager/model/LicenseStatus.h>
#include <aws/license-manager/model/LicenseUsage.h>
#include <aws/license-manager/model/ListAssociationsForLicenseConfigurationRequest.h>
#include <aws/license-manager/model/ListAssociationsForLicenseConfigurationResult.h>
#include <aws/license-manager/model/ListDistributedGrantsRequest.h>
#include <aws/license-manager/model/ListDistributedGrantsResult.h>
#include <aws/license-manager/model/ListFailuresForLicenseConfigurationOperationsRequest.h>
#include <aws/license-manager/model/ListFailuresForLicenseConfigurationOperationsResult.h>
#include <aws/license-manager/model/ListLicenseConfigurationsRequest.h>
#include <aws/license-manager/model/ListLicenseConfigurationsResult.h>
#include <aws/license-manager/model/ListLicenseConversionTasksRequest.h>
#include <aws/license-manager/model/ListLicenseConversionTasksResult.h>
#include <aws/license-manager/model/ListLicenseManagerReportGeneratorsRequest.h>
#include <aws/license-manager/model/ListLicenseManagerReportGeneratorsResult.h>
#include <aws/license-manager/model/ListLicenseSpecificationsForResourceRequest.h>
#include <aws/license-manager/model/ListLicenseSpecificationsForResourceResult.h>
#include <aws/license-manager/model/ListLicenseVersionsRequest.h>
#include <aws/license-manager/model/ListLicenseVersionsResult.h>
#include <aws/license-manager/model/ListLicensesRequest.h>
#include <aws/license-manager/model/ListLicensesResult.h>
#include <aws/license-manager/model/ListReceivedGrantsForOrganizationRequest.h>
#include <aws/license-manager/model/ListReceivedGrantsForOrganizationResult.h>
#include <aws/license-manager/model/ListReceivedGrantsRequest.h>
#include <aws/license-manager/model/ListReceivedGrantsResult.h>
#include <aws/license-manager/model/ListReceivedLicensesForOrganizationRequest.h>
#include <aws/license-manager/model/ListReceivedLicensesForOrganizationResult.h>
#include <aws/license-manager/model/ListReceivedLicensesRequest.h>
#include <aws/license-manager/model/ListReceivedLicensesResult.h>
#include <aws/license-manager/model/ListResourceInventoryRequest.h>
#include <aws/license-manager/model/ListResourceInventoryResult.h>
#include <aws/license-manager/model/ListTagsForResourceRequest.h>
#include <aws/license-manager/model/ListTagsForResourceResult.h>
#include <aws/license-manager/model/ListTokensRequest.h>
#include <aws/license-manager/model/ListTokensResult.h>
#include <aws/license-manager/model/ListUsageForLicenseConfigurationRequest.h>
#include <aws/license-manager/model/ListUsageForLicenseConfigurationResult.h>
#include <aws/license-manager/model/ManagedResourceSummary.h>
#include <aws/license-manager/model/Metadata.h>
#include <aws/license-manager/model/Options.h>
#include <aws/license-manager/model/OrganizationConfiguration.h>
#include <aws/license-manager/model/ProductCodeListItem.h>
#include <aws/license-manager/model/ProductCodeType.h>
#include <aws/license-manager/model/ProductInformation.h>
#include <aws/license-manager/model/ProductInformationFilter.h>
#include <aws/license-manager/model/ProvisionalConfiguration.h>
#include <aws/license-manager/model/ReceivedMetadata.h>
#include <aws/license-manager/model/ReceivedStatus.h>
#include <aws/license-manager/model/RedirectException.h>
#include <aws/license-manager/model/RejectGrantRequest.h>
#include <aws/license-manager/model/RejectGrantResult.h>
#include <aws/license-manager/model/RenewType.h>
#include <aws/license-manager/model/ReportContext.h>
#include <aws/license-manager/model/ReportFrequency.h>
#include <aws/license-manager/model/ReportFrequencyType.h>
#include <aws/license-manager/model/ReportGenerator.h>
#include <aws/license-manager/model/ReportType.h>
#include <aws/license-manager/model/ResourceInventory.h>
#include <aws/license-manager/model/ResourceType.h>
#include <aws/license-manager/model/S3Location.h>
#include <aws/license-manager/model/Tag.h>
#include <aws/license-manager/model/TagResourceRequest.h>
#include <aws/license-manager/model/TagResourceResult.h>
#include <aws/license-manager/model/TokenData.h>
#include <aws/license-manager/model/TokenType.h>
#include <aws/license-manager/model/UntagResourceRequest.h>
#include <aws/license-manager/model/UntagResourceResult.h>
#include <aws/license-manager/model/UpdateLicenseConfigurationRequest.h>
#include <aws/license-manager/model/UpdateLicenseConfigurationResult.h>
#include <aws/license-manager/model/UpdateLicenseManagerReportGeneratorRequest.h>
#include <aws/license-manager/model/UpdateLicenseManagerReportGeneratorResult.h>
#include <aws/license-manager/model/UpdateLicenseSpecificationsForResourceRequest.h>
#include <aws/license-manager/model/UpdateLicenseSpecificationsForResourceResult.h>
#include <aws/license-manager/model/UpdateServiceSettingsRequest.h>
#include <aws/license-manager/model/UpdateServiceSettingsResult.h>

using LicenseManagerIncludeTest = ::testing::Test;

TEST_F(LicenseManagerIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::LicenseManager::LicenseManagerClient>("LicenseManagerIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
