/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/lightsail/LightsailClient.h>
#include <aws/lightsail/LightsailEndpointProvider.h>
#include <aws/lightsail/LightsailEndpointRules.h>
#include <aws/lightsail/LightsailErrorMarshaller.h>
#include <aws/lightsail/LightsailErrors.h>
#include <aws/lightsail/LightsailRequest.h>
#include <aws/lightsail/LightsailServiceClientModel.h>
#include <aws/lightsail/Lightsail_EXPORTS.h>
#include <aws/lightsail/model/AccessDeniedException.h>
#include <aws/lightsail/model/AccessDirection.h>
#include <aws/lightsail/model/AccessKey.h>
#include <aws/lightsail/model/AccessKeyLastUsed.h>
#include <aws/lightsail/model/AccessRules.h>
#include <aws/lightsail/model/AccessType.h>
#include <aws/lightsail/model/AccountLevelBpaSync.h>
#include <aws/lightsail/model/AccountLevelBpaSyncStatus.h>
#include <aws/lightsail/model/AccountSetupInProgressException.h>
#include <aws/lightsail/model/AddOn.h>
#include <aws/lightsail/model/AddOnRequest.h>
#include <aws/lightsail/model/AddOnType.h>
#include <aws/lightsail/model/Alarm.h>
#include <aws/lightsail/model/AlarmState.h>
#include <aws/lightsail/model/AllocateStaticIpRequest.h>
#include <aws/lightsail/model/AllocateStaticIpResult.h>
#include <aws/lightsail/model/AppCategory.h>
#include <aws/lightsail/model/AttachCertificateToDistributionRequest.h>
#include <aws/lightsail/model/AttachCertificateToDistributionResult.h>
#include <aws/lightsail/model/AttachDiskRequest.h>
#include <aws/lightsail/model/AttachDiskResult.h>
#include <aws/lightsail/model/AttachInstancesToLoadBalancerRequest.h>
#include <aws/lightsail/model/AttachInstancesToLoadBalancerResult.h>
#include <aws/lightsail/model/AttachLoadBalancerTlsCertificateRequest.h>
#include <aws/lightsail/model/AttachLoadBalancerTlsCertificateResult.h>
#include <aws/lightsail/model/AttachStaticIpRequest.h>
#include <aws/lightsail/model/AttachStaticIpResult.h>
#include <aws/lightsail/model/AttachedDisk.h>
#include <aws/lightsail/model/AutoMountStatus.h>
#include <aws/lightsail/model/AutoSnapshotAddOnRequest.h>
#include <aws/lightsail/model/AutoSnapshotDetails.h>
#include <aws/lightsail/model/AutoSnapshotStatus.h>
#include <aws/lightsail/model/AvailabilityZone.h>
#include <aws/lightsail/model/BPAStatusMessage.h>
#include <aws/lightsail/model/BehaviorEnum.h>
#include <aws/lightsail/model/Blueprint.h>
#include <aws/lightsail/model/BlueprintType.h>
#include <aws/lightsail/model/Bucket.h>
#include <aws/lightsail/model/BucketAccessLogConfig.h>
#include <aws/lightsail/model/BucketBundle.h>
#include <aws/lightsail/model/BucketMetricName.h>
#include <aws/lightsail/model/BucketState.h>
#include <aws/lightsail/model/Bundle.h>
#include <aws/lightsail/model/CacheBehavior.h>
#include <aws/lightsail/model/CacheBehaviorPerPath.h>
#include <aws/lightsail/model/CacheSettings.h>
#include <aws/lightsail/model/Certificate.h>
#include <aws/lightsail/model/CertificateDomainValidationStatus.h>
#include <aws/lightsail/model/CertificateProvider.h>
#include <aws/lightsail/model/CertificateStatus.h>
#include <aws/lightsail/model/CertificateSummary.h>
#include <aws/lightsail/model/CloseInstancePublicPortsRequest.h>
#include <aws/lightsail/model/CloseInstancePublicPortsResult.h>
#include <aws/lightsail/model/CloudFormationStackRecord.h>
#include <aws/lightsail/model/CloudFormationStackRecordSourceInfo.h>
#include <aws/lightsail/model/CloudFormationStackRecordSourceType.h>
#include <aws/lightsail/model/ComparisonOperator.h>
#include <aws/lightsail/model/ContactMethod.h>
#include <aws/lightsail/model/ContactMethodStatus.h>
#include <aws/lightsail/model/ContactMethodVerificationProtocol.h>
#include <aws/lightsail/model/ContactProtocol.h>
#include <aws/lightsail/model/Container.h>
#include <aws/lightsail/model/ContainerImage.h>
#include <aws/lightsail/model/ContainerService.h>
#include <aws/lightsail/model/ContainerServiceDeployment.h>
#include <aws/lightsail/model/ContainerServiceDeploymentRequest.h>
#include <aws/lightsail/model/ContainerServiceDeploymentState.h>
#include <aws/lightsail/model/ContainerServiceECRImagePullerRole.h>
#include <aws/lightsail/model/ContainerServiceECRImagePullerRoleRequest.h>
#include <aws/lightsail/model/ContainerServiceEndpoint.h>
#include <aws/lightsail/model/ContainerServiceHealthCheckConfig.h>
#include <aws/lightsail/model/ContainerServiceLogEvent.h>
#include <aws/lightsail/model/ContainerServiceMetricName.h>
#include <aws/lightsail/model/ContainerServicePower.h>
#include <aws/lightsail/model/ContainerServicePowerName.h>
#include <aws/lightsail/model/ContainerServiceProtocol.h>
#include <aws/lightsail/model/ContainerServiceRegistryLogin.h>
#include <aws/lightsail/model/ContainerServiceState.h>
#include <aws/lightsail/model/ContainerServiceStateDetail.h>
#include <aws/lightsail/model/ContainerServiceStateDetailCode.h>
#include <aws/lightsail/model/CookieObject.h>
#include <aws/lightsail/model/CopySnapshotRequest.h>
#include <aws/lightsail/model/CopySnapshotResult.h>
#include <aws/lightsail/model/CostEstimate.h>
#include <aws/lightsail/model/CreateBucketAccessKeyRequest.h>
#include <aws/lightsail/model/CreateBucketAccessKeyResult.h>
#include <aws/lightsail/model/CreateBucketRequest.h>
#include <aws/lightsail/model/CreateBucketResult.h>
#include <aws/lightsail/model/CreateCertificateRequest.h>
#include <aws/lightsail/model/CreateCertificateResult.h>
#include <aws/lightsail/model/CreateCloudFormationStackRequest.h>
#include <aws/lightsail/model/CreateCloudFormationStackResult.h>
#include <aws/lightsail/model/CreateContactMethodRequest.h>
#include <aws/lightsail/model/CreateContactMethodResult.h>
#include <aws/lightsail/model/CreateContainerServiceDeploymentRequest.h>
#include <aws/lightsail/model/CreateContainerServiceDeploymentResult.h>
#include <aws/lightsail/model/CreateContainerServiceRegistryLoginRequest.h>
#include <aws/lightsail/model/CreateContainerServiceRegistryLoginResult.h>
#include <aws/lightsail/model/CreateContainerServiceRequest.h>
#include <aws/lightsail/model/CreateContainerServiceResult.h>
#include <aws/lightsail/model/CreateDiskFromSnapshotRequest.h>
#include <aws/lightsail/model/CreateDiskFromSnapshotResult.h>
#include <aws/lightsail/model/CreateDiskRequest.h>
#include <aws/lightsail/model/CreateDiskResult.h>
#include <aws/lightsail/model/CreateDiskSnapshotRequest.h>
#include <aws/lightsail/model/CreateDiskSnapshotResult.h>
#include <aws/lightsail/model/CreateDistributionRequest.h>
#include <aws/lightsail/model/CreateDistributionResult.h>
#include <aws/lightsail/model/CreateDomainEntryRequest.h>
#include <aws/lightsail/model/CreateDomainEntryResult.h>
#include <aws/lightsail/model/CreateDomainRequest.h>
#include <aws/lightsail/model/CreateDomainResult.h>
#include <aws/lightsail/model/CreateGUISessionAccessDetailsRequest.h>
#include <aws/lightsail/model/CreateGUISessionAccessDetailsResult.h>
#include <aws/lightsail/model/CreateInstanceSnapshotRequest.h>
#include <aws/lightsail/model/CreateInstanceSnapshotResult.h>
#include <aws/lightsail/model/CreateInstancesFromSnapshotRequest.h>
#include <aws/lightsail/model/CreateInstancesFromSnapshotResult.h>
#include <aws/lightsail/model/CreateInstancesRequest.h>
#include <aws/lightsail/model/CreateInstancesResult.h>
#include <aws/lightsail/model/CreateKeyPairRequest.h>
#include <aws/lightsail/model/CreateKeyPairResult.h>
#include <aws/lightsail/model/CreateLoadBalancerRequest.h>
#include <aws/lightsail/model/CreateLoadBalancerResult.h>
#include <aws/lightsail/model/CreateLoadBalancerTlsCertificateRequest.h>
#include <aws/lightsail/model/CreateLoadBalancerTlsCertificateResult.h>
#include <aws/lightsail/model/CreateRelationalDatabaseFromSnapshotRequest.h>
#include <aws/lightsail/model/CreateRelationalDatabaseFromSnapshotResult.h>
#include <aws/lightsail/model/CreateRelationalDatabaseRequest.h>
#include <aws/lightsail/model/CreateRelationalDatabaseResult.h>
#include <aws/lightsail/model/CreateRelationalDatabaseSnapshotRequest.h>
#include <aws/lightsail/model/CreateRelationalDatabaseSnapshotResult.h>
#include <aws/lightsail/model/Currency.h>
#include <aws/lightsail/model/DeleteAlarmRequest.h>
#include <aws/lightsail/model/DeleteAlarmResult.h>
#include <aws/lightsail/model/DeleteAutoSnapshotRequest.h>
#include <aws/lightsail/model/DeleteAutoSnapshotResult.h>
#include <aws/lightsail/model/DeleteBucketAccessKeyRequest.h>
#include <aws/lightsail/model/DeleteBucketAccessKeyResult.h>
#include <aws/lightsail/model/DeleteBucketRequest.h>
#include <aws/lightsail/model/DeleteBucketResult.h>
#include <aws/lightsail/model/DeleteCertificateRequest.h>
#include <aws/lightsail/model/DeleteCertificateResult.h>
#include <aws/lightsail/model/DeleteContactMethodRequest.h>
#include <aws/lightsail/model/DeleteContactMethodResult.h>
#include <aws/lightsail/model/DeleteContainerImageRequest.h>
#include <aws/lightsail/model/DeleteContainerImageResult.h>
#include <aws/lightsail/model/DeleteContainerServiceRequest.h>
#include <aws/lightsail/model/DeleteContainerServiceResult.h>
#include <aws/lightsail/model/DeleteDiskRequest.h>
#include <aws/lightsail/model/DeleteDiskResult.h>
#include <aws/lightsail/model/DeleteDiskSnapshotRequest.h>
#include <aws/lightsail/model/DeleteDiskSnapshotResult.h>
#include <aws/lightsail/model/DeleteDistributionRequest.h>
#include <aws/lightsail/model/DeleteDistributionResult.h>
#include <aws/lightsail/model/DeleteDomainEntryRequest.h>
#include <aws/lightsail/model/DeleteDomainEntryResult.h>
#include <aws/lightsail/model/DeleteDomainRequest.h>
#include <aws/lightsail/model/DeleteDomainResult.h>
#include <aws/lightsail/model/DeleteInstanceRequest.h>
#include <aws/lightsail/model/DeleteInstanceResult.h>
#include <aws/lightsail/model/DeleteInstanceSnapshotRequest.h>
#include <aws/lightsail/model/DeleteInstanceSnapshotResult.h>
#include <aws/lightsail/model/DeleteKeyPairRequest.h>
#include <aws/lightsail/model/DeleteKeyPairResult.h>
#include <aws/lightsail/model/DeleteKnownHostKeysRequest.h>
#include <aws/lightsail/model/DeleteKnownHostKeysResult.h>
#include <aws/lightsail/model/DeleteLoadBalancerRequest.h>
#include <aws/lightsail/model/DeleteLoadBalancerResult.h>
#include <aws/lightsail/model/DeleteLoadBalancerTlsCertificateRequest.h>
#include <aws/lightsail/model/DeleteLoadBalancerTlsCertificateResult.h>
#include <aws/lightsail/model/DeleteRelationalDatabaseRequest.h>
#include <aws/lightsail/model/DeleteRelationalDatabaseResult.h>
#include <aws/lightsail/model/DeleteRelationalDatabaseSnapshotRequest.h>
#include <aws/lightsail/model/DeleteRelationalDatabaseSnapshotResult.h>
#include <aws/lightsail/model/DestinationInfo.h>
#include <aws/lightsail/model/DetachCertificateFromDistributionRequest.h>
#include <aws/lightsail/model/DetachCertificateFromDistributionResult.h>
#include <aws/lightsail/model/DetachDiskRequest.h>
#include <aws/lightsail/model/DetachDiskResult.h>
#include <aws/lightsail/model/DetachInstancesFromLoadBalancerRequest.h>
#include <aws/lightsail/model/DetachInstancesFromLoadBalancerResult.h>
#include <aws/lightsail/model/DetachStaticIpRequest.h>
#include <aws/lightsail/model/DetachStaticIpResult.h>
#include <aws/lightsail/model/DisableAddOnRequest.h>
#include <aws/lightsail/model/DisableAddOnResult.h>
#include <aws/lightsail/model/Disk.h>
#include <aws/lightsail/model/DiskInfo.h>
#include <aws/lightsail/model/DiskMap.h>
#include <aws/lightsail/model/DiskSnapshot.h>
#include <aws/lightsail/model/DiskSnapshotInfo.h>
#include <aws/lightsail/model/DiskSnapshotState.h>
#include <aws/lightsail/model/DiskState.h>
#include <aws/lightsail/model/DistributionBundle.h>
#include <aws/lightsail/model/DistributionMetricName.h>
#include <aws/lightsail/model/DnsRecordCreationState.h>
#include <aws/lightsail/model/DnsRecordCreationStateCode.h>
#include <aws/lightsail/model/Domain.h>
#include <aws/lightsail/model/DomainEntry.h>
#include <aws/lightsail/model/DomainValidationRecord.h>
#include <aws/lightsail/model/DownloadDefaultKeyPairRequest.h>
#include <aws/lightsail/model/DownloadDefaultKeyPairResult.h>
#include <aws/lightsail/model/EnableAddOnRequest.h>
#include <aws/lightsail/model/EnableAddOnResult.h>
#include <aws/lightsail/model/EndpointRequest.h>
#include <aws/lightsail/model/EstimateByTime.h>
#include <aws/lightsail/model/ExportSnapshotRecord.h>
#include <aws/lightsail/model/ExportSnapshotRecordSourceInfo.h>
#include <aws/lightsail/model/ExportSnapshotRecordSourceType.h>
#include <aws/lightsail/model/ExportSnapshotRequest.h>
#include <aws/lightsail/model/ExportSnapshotResult.h>
#include <aws/lightsail/model/ForwardValues.h>
#include <aws/lightsail/model/GetActiveNamesRequest.h>
#include <aws/lightsail/model/GetActiveNamesResult.h>
#include <aws/lightsail/model/GetAlarmsRequest.h>
#include <aws/lightsail/model/GetAlarmsResult.h>
#include <aws/lightsail/model/GetAutoSnapshotsRequest.h>
#include <aws/lightsail/model/GetAutoSnapshotsResult.h>
#include <aws/lightsail/model/GetBlueprintsRequest.h>
#include <aws/lightsail/model/GetBlueprintsResult.h>
#include <aws/lightsail/model/GetBucketAccessKeysRequest.h>
#include <aws/lightsail/model/GetBucketAccessKeysResult.h>
#include <aws/lightsail/model/GetBucketBundlesRequest.h>
#include <aws/lightsail/model/GetBucketBundlesResult.h>
#include <aws/lightsail/model/GetBucketMetricDataRequest.h>
#include <aws/lightsail/model/GetBucketMetricDataResult.h>
#include <aws/lightsail/model/GetBucketsRequest.h>
#include <aws/lightsail/model/GetBucketsResult.h>
#include <aws/lightsail/model/GetBundlesRequest.h>
#include <aws/lightsail/model/GetBundlesResult.h>
#include <aws/lightsail/model/GetCertificatesRequest.h>
#include <aws/lightsail/model/GetCertificatesResult.h>
#include <aws/lightsail/model/GetCloudFormationStackRecordsRequest.h>
#include <aws/lightsail/model/GetCloudFormationStackRecordsResult.h>
#include <aws/lightsail/model/GetContactMethodsRequest.h>
#include <aws/lightsail/model/GetContactMethodsResult.h>
#include <aws/lightsail/model/GetContainerAPIMetadataRequest.h>
#include <aws/lightsail/model/GetContainerAPIMetadataResult.h>
#include <aws/lightsail/model/GetContainerImagesRequest.h>
#include <aws/lightsail/model/GetContainerImagesResult.h>
#include <aws/lightsail/model/GetContainerLogRequest.h>
#include <aws/lightsail/model/GetContainerLogResult.h>
#include <aws/lightsail/model/GetContainerServiceDeploymentsRequest.h>
#include <aws/lightsail/model/GetContainerServiceDeploymentsResult.h>
#include <aws/lightsail/model/GetContainerServiceMetricDataRequest.h>
#include <aws/lightsail/model/GetContainerServiceMetricDataResult.h>
#include <aws/lightsail/model/GetContainerServicePowersRequest.h>
#include <aws/lightsail/model/GetContainerServicePowersResult.h>
#include <aws/lightsail/model/GetContainerServicesRequest.h>
#include <aws/lightsail/model/GetContainerServicesResult.h>
#include <aws/lightsail/model/GetCostEstimateRequest.h>
#include <aws/lightsail/model/GetCostEstimateResult.h>
#include <aws/lightsail/model/GetDiskRequest.h>
#include <aws/lightsail/model/GetDiskResult.h>
#include <aws/lightsail/model/GetDiskSnapshotRequest.h>
#include <aws/lightsail/model/GetDiskSnapshotResult.h>
#include <aws/lightsail/model/GetDiskSnapshotsRequest.h>
#include <aws/lightsail/model/GetDiskSnapshotsResult.h>
#include <aws/lightsail/model/GetDisksRequest.h>
#include <aws/lightsail/model/GetDisksResult.h>
#include <aws/lightsail/model/GetDistributionBundlesRequest.h>
#include <aws/lightsail/model/GetDistributionBundlesResult.h>
#include <aws/lightsail/model/GetDistributionLatestCacheResetRequest.h>
#include <aws/lightsail/model/GetDistributionLatestCacheResetResult.h>
#include <aws/lightsail/model/GetDistributionMetricDataRequest.h>
#include <aws/lightsail/model/GetDistributionMetricDataResult.h>
#include <aws/lightsail/model/GetDistributionsRequest.h>
#include <aws/lightsail/model/GetDistributionsResult.h>
#include <aws/lightsail/model/GetDomainRequest.h>
#include <aws/lightsail/model/GetDomainResult.h>
#include <aws/lightsail/model/GetDomainsRequest.h>
#include <aws/lightsail/model/GetDomainsResult.h>
#include <aws/lightsail/model/GetExportSnapshotRecordsRequest.h>
#include <aws/lightsail/model/GetExportSnapshotRecordsResult.h>
#include <aws/lightsail/model/GetInstanceAccessDetailsRequest.h>
#include <aws/lightsail/model/GetInstanceAccessDetailsResult.h>
#include <aws/lightsail/model/GetInstanceMetricDataRequest.h>
#include <aws/lightsail/model/GetInstanceMetricDataResult.h>
#include <aws/lightsail/model/GetInstancePortStatesRequest.h>
#include <aws/lightsail/model/GetInstancePortStatesResult.h>
#include <aws/lightsail/model/GetInstanceRequest.h>
#include <aws/lightsail/model/GetInstanceResult.h>
#include <aws/lightsail/model/GetInstanceSnapshotRequest.h>
#include <aws/lightsail/model/GetInstanceSnapshotResult.h>
#include <aws/lightsail/model/GetInstanceSnapshotsRequest.h>
#include <aws/lightsail/model/GetInstanceSnapshotsResult.h>
#include <aws/lightsail/model/GetInstanceStateRequest.h>
#include <aws/lightsail/model/GetInstanceStateResult.h>
#include <aws/lightsail/model/GetInstancesRequest.h>
#include <aws/lightsail/model/GetInstancesResult.h>
#include <aws/lightsail/model/GetKeyPairRequest.h>
#include <aws/lightsail/model/GetKeyPairResult.h>
#include <aws/lightsail/model/GetKeyPairsRequest.h>
#include <aws/lightsail/model/GetKeyPairsResult.h>
#include <aws/lightsail/model/GetLoadBalancerMetricDataRequest.h>
#include <aws/lightsail/model/GetLoadBalancerMetricDataResult.h>
#include <aws/lightsail/model/GetLoadBalancerRequest.h>
#include <aws/lightsail/model/GetLoadBalancerResult.h>
#include <aws/lightsail/model/GetLoadBalancerTlsCertificatesRequest.h>
#include <aws/lightsail/model/GetLoadBalancerTlsCertificatesResult.h>
#include <aws/lightsail/model/GetLoadBalancerTlsPoliciesRequest.h>
#include <aws/lightsail/model/GetLoadBalancerTlsPoliciesResult.h>
#include <aws/lightsail/model/GetLoadBalancersRequest.h>
#include <aws/lightsail/model/GetLoadBalancersResult.h>
#include <aws/lightsail/model/GetOperationRequest.h>
#include <aws/lightsail/model/GetOperationResult.h>
#include <aws/lightsail/model/GetOperationsForResourceRequest.h>
#include <aws/lightsail/model/GetOperationsForResourceResult.h>
#include <aws/lightsail/model/GetOperationsRequest.h>
#include <aws/lightsail/model/GetOperationsResult.h>
#include <aws/lightsail/model/GetRegionsRequest.h>
#include <aws/lightsail/model/GetRegionsResult.h>
#include <aws/lightsail/model/GetRelationalDatabaseBlueprintsRequest.h>
#include <aws/lightsail/model/GetRelationalDatabaseBlueprintsResult.h>
#include <aws/lightsail/model/GetRelationalDatabaseBundlesRequest.h>
#include <aws/lightsail/model/GetRelationalDatabaseBundlesResult.h>
#include <aws/lightsail/model/GetRelationalDatabaseEventsRequest.h>
#include <aws/lightsail/model/GetRelationalDatabaseEventsResult.h>
#include <aws/lightsail/model/GetRelationalDatabaseLogEventsRequest.h>
#include <aws/lightsail/model/GetRelationalDatabaseLogEventsResult.h>
#include <aws/lightsail/model/GetRelationalDatabaseLogStreamsRequest.h>
#include <aws/lightsail/model/GetRelationalDatabaseLogStreamsResult.h>
#include <aws/lightsail/model/GetRelationalDatabaseMasterUserPasswordRequest.h>
#include <aws/lightsail/model/GetRelationalDatabaseMasterUserPasswordResult.h>
#include <aws/lightsail/model/GetRelationalDatabaseMetricDataRequest.h>
#include <aws/lightsail/model/GetRelationalDatabaseMetricDataResult.h>
#include <aws/lightsail/model/GetRelationalDatabaseParametersRequest.h>
#include <aws/lightsail/model/GetRelationalDatabaseParametersResult.h>
#include <aws/lightsail/model/GetRelationalDatabaseRequest.h>
#include <aws/lightsail/model/GetRelationalDatabaseResult.h>
#include <aws/lightsail/model/GetRelationalDatabaseSnapshotRequest.h>
#include <aws/lightsail/model/GetRelationalDatabaseSnapshotResult.h>
#include <aws/lightsail/model/GetRelationalDatabaseSnapshotsRequest.h>
#include <aws/lightsail/model/GetRelationalDatabaseSnapshotsResult.h>
#include <aws/lightsail/model/GetRelationalDatabasesRequest.h>
#include <aws/lightsail/model/GetRelationalDatabasesResult.h>
#include <aws/lightsail/model/GetSetupHistoryRequest.h>
#include <aws/lightsail/model/GetSetupHistoryResult.h>
#include <aws/lightsail/model/GetStaticIpRequest.h>
#include <aws/lightsail/model/GetStaticIpResult.h>
#include <aws/lightsail/model/GetStaticIpsRequest.h>
#include <aws/lightsail/model/GetStaticIpsResult.h>
#include <aws/lightsail/model/HeaderEnum.h>
#include <aws/lightsail/model/HeaderObject.h>
#include <aws/lightsail/model/HostKeyAttributes.h>
#include <aws/lightsail/model/HttpEndpoint.h>
#include <aws/lightsail/model/HttpProtocolIpv6.h>
#include <aws/lightsail/model/HttpTokens.h>
#include <aws/lightsail/model/ImportKeyPairRequest.h>
#include <aws/lightsail/model/ImportKeyPairResult.h>
#include <aws/lightsail/model/InputOrigin.h>
#include <aws/lightsail/model/Instance.h>
#include <aws/lightsail/model/InstanceAccessDetails.h>
#include <aws/lightsail/model/InstanceAccessProtocol.h>
#include <aws/lightsail/model/InstanceEntry.h>
#include <aws/lightsail/model/InstanceHardware.h>
#include <aws/lightsail/model/InstanceHealthReason.h>
#include <aws/lightsail/model/InstanceHealthState.h>
#include <aws/lightsail/model/InstanceHealthSummary.h>
#include <aws/lightsail/model/InstanceMetadataOptions.h>
#include <aws/lightsail/model/InstanceMetadataState.h>
#include <aws/lightsail/model/InstanceMetricName.h>
#include <aws/lightsail/model/InstanceNetworking.h>
#include <aws/lightsail/model/InstancePlatform.h>
#include <aws/lightsail/model/InstancePortInfo.h>
#include <aws/lightsail/model/InstancePortState.h>
#include <aws/lightsail/model/InstanceSnapshot.h>
#include <aws/lightsail/model/InstanceSnapshotInfo.h>
#include <aws/lightsail/model/InstanceSnapshotState.h>
#include <aws/lightsail/model/InstanceState.h>
#include <aws/lightsail/model/InvalidInputException.h>
#include <aws/lightsail/model/IpAddressType.h>
#include <aws/lightsail/model/IsVpcPeeredRequest.h>
#include <aws/lightsail/model/IsVpcPeeredResult.h>
#include <aws/lightsail/model/KeyPair.h>
#include <aws/lightsail/model/LightsailDistribution.h>
#include <aws/lightsail/model/LoadBalancer.h>
#include <aws/lightsail/model/LoadBalancerAttributeName.h>
#include <aws/lightsail/model/LoadBalancerMetricName.h>
#include <aws/lightsail/model/LoadBalancerProtocol.h>
#include <aws/lightsail/model/LoadBalancerState.h>
#include <aws/lightsail/model/LoadBalancerTlsCertificate.h>
#include <aws/lightsail/model/LoadBalancerTlsCertificateDnsRecordCreationState.h>
#include <aws/lightsail/model/LoadBalancerTlsCertificateDnsRecordCreationStateCode.h>
#include <aws/lightsail/model/LoadBalancerTlsCertificateDomainStatus.h>
#include <aws/lightsail/model/LoadBalancerTlsCertificateDomainValidationOption.h>
#include <aws/lightsail/model/LoadBalancerTlsCertificateDomainValidationRecord.h>
#include <aws/lightsail/model/LoadBalancerTlsCertificateFailureReason.h>
#include <aws/lightsail/model/LoadBalancerTlsCertificateRenewalStatus.h>
#include <aws/lightsail/model/LoadBalancerTlsCertificateRenewalSummary.h>
#include <aws/lightsail/model/LoadBalancerTlsCertificateRevocationReason.h>
#include <aws/lightsail/model/LoadBalancerTlsCertificateStatus.h>
#include <aws/lightsail/model/LoadBalancerTlsCertificateSummary.h>
#include <aws/lightsail/model/LoadBalancerTlsPolicy.h>
#include <aws/lightsail/model/LogEvent.h>
#include <aws/lightsail/model/MetricDatapoint.h>
#include <aws/lightsail/model/MetricName.h>
#include <aws/lightsail/model/MetricStatistic.h>
#include <aws/lightsail/model/MetricUnit.h>
#include <aws/lightsail/model/MonitoredResourceInfo.h>
#include <aws/lightsail/model/MonthlyTransfer.h>
#include <aws/lightsail/model/NameServersUpdateState.h>
#include <aws/lightsail/model/NameServersUpdateStateCode.h>
#include <aws/lightsail/model/NetworkProtocol.h>
#include <aws/lightsail/model/NotFoundException.h>
#include <aws/lightsail/model/OpenInstancePublicPortsRequest.h>
#include <aws/lightsail/model/OpenInstancePublicPortsResult.h>
#include <aws/lightsail/model/Operation.h>
#include <aws/lightsail/model/OperationFailureException.h>
#include <aws/lightsail/model/OperationStatus.h>
#include <aws/lightsail/model/OperationType.h>
#include <aws/lightsail/model/Origin.h>
#include <aws/lightsail/model/OriginProtocolPolicyEnum.h>
#include <aws/lightsail/model/PasswordData.h>
#include <aws/lightsail/model/PeerVpcRequest.h>
#include <aws/lightsail/model/PeerVpcResult.h>
#include <aws/lightsail/model/PendingMaintenanceAction.h>
#include <aws/lightsail/model/PendingModifiedRelationalDatabaseValues.h>
#include <aws/lightsail/model/PortAccessType.h>
#include <aws/lightsail/model/PortInfo.h>
#include <aws/lightsail/model/PortInfoSourceType.h>
#include <aws/lightsail/model/PortState.h>
#include <aws/lightsail/model/PricingUnit.h>
#include <aws/lightsail/model/PrivateRegistryAccess.h>
#include <aws/lightsail/model/PrivateRegistryAccessRequest.h>
#include <aws/lightsail/model/PutAlarmRequest.h>
#include <aws/lightsail/model/PutAlarmResult.h>
#include <aws/lightsail/model/PutInstancePublicPortsRequest.h>
#include <aws/lightsail/model/PutInstancePublicPortsResult.h>
#include <aws/lightsail/model/QueryStringObject.h>
#include <aws/lightsail/model/R53HostedZoneDeletionState.h>
#include <aws/lightsail/model/R53HostedZoneDeletionStateCode.h>
#include <aws/lightsail/model/RebootInstanceRequest.h>
#include <aws/lightsail/model/RebootInstanceResult.h>
#include <aws/lightsail/model/RebootRelationalDatabaseRequest.h>
#include <aws/lightsail/model/RebootRelationalDatabaseResult.h>
#include <aws/lightsail/model/RecordState.h>
#include <aws/lightsail/model/Region.h>
#include <aws/lightsail/model/RegionName.h>
#include <aws/lightsail/model/RegisterContainerImageRequest.h>
#include <aws/lightsail/model/RegisterContainerImageResult.h>
#include <aws/lightsail/model/RegisteredDomainDelegationInfo.h>
#include <aws/lightsail/model/RelationalDatabase.h>
#include <aws/lightsail/model/RelationalDatabaseBlueprint.h>
#include <aws/lightsail/model/RelationalDatabaseBundle.h>
#include <aws/lightsail/model/RelationalDatabaseEndpoint.h>
#include <aws/lightsail/model/RelationalDatabaseEngine.h>
#include <aws/lightsail/model/RelationalDatabaseEvent.h>
#include <aws/lightsail/model/RelationalDatabaseHardware.h>
#include <aws/lightsail/model/RelationalDatabaseMetricName.h>
#include <aws/lightsail/model/RelationalDatabaseParameter.h>
#include <aws/lightsail/model/RelationalDatabasePasswordVersion.h>
#include <aws/lightsail/model/RelationalDatabaseSnapshot.h>
#include <aws/lightsail/model/ReleaseStaticIpRequest.h>
#include <aws/lightsail/model/ReleaseStaticIpResult.h>
#include <aws/lightsail/model/RenewalStatus.h>
#include <aws/lightsail/model/RenewalSummary.h>
#include <aws/lightsail/model/ResetDistributionCacheRequest.h>
#include <aws/lightsail/model/ResetDistributionCacheResult.h>
#include <aws/lightsail/model/ResourceBucketAccess.h>
#include <aws/lightsail/model/ResourceBudgetEstimate.h>
#include <aws/lightsail/model/ResourceLocation.h>
#include <aws/lightsail/model/ResourceReceivingAccess.h>
#include <aws/lightsail/model/ResourceRecord.h>
#include <aws/lightsail/model/ResourceType.h>
#include <aws/lightsail/model/SendContactMethodVerificationRequest.h>
#include <aws/lightsail/model/SendContactMethodVerificationResult.h>
#include <aws/lightsail/model/ServiceException.h>
#include <aws/lightsail/model/Session.h>
#include <aws/lightsail/model/SetIpAddressTypeRequest.h>
#include <aws/lightsail/model/SetIpAddressTypeResult.h>
#include <aws/lightsail/model/SetResourceAccessForBucketRequest.h>
#include <aws/lightsail/model/SetResourceAccessForBucketResult.h>
#include <aws/lightsail/model/SetupExecutionDetails.h>
#include <aws/lightsail/model/SetupHistory.h>
#include <aws/lightsail/model/SetupHistoryResource.h>
#include <aws/lightsail/model/SetupInstanceHttpsRequest.h>
#include <aws/lightsail/model/SetupInstanceHttpsResult.h>
#include <aws/lightsail/model/SetupRequest.h>
#include <aws/lightsail/model/SetupStatus.h>
#include <aws/lightsail/model/StartGUISessionRequest.h>
#include <aws/lightsail/model/StartGUISessionResult.h>
#include <aws/lightsail/model/StartInstanceRequest.h>
#include <aws/lightsail/model/StartInstanceResult.h>
#include <aws/lightsail/model/StartRelationalDatabaseRequest.h>
#include <aws/lightsail/model/StartRelationalDatabaseResult.h>
#include <aws/lightsail/model/StaticIp.h>
#include <aws/lightsail/model/Status.h>
#include <aws/lightsail/model/StatusType.h>
#include <aws/lightsail/model/StopGUISessionRequest.h>
#include <aws/lightsail/model/StopGUISessionResult.h>
#include <aws/lightsail/model/StopInstanceOnIdleRequest.h>
#include <aws/lightsail/model/StopInstanceRequest.h>
#include <aws/lightsail/model/StopInstanceResult.h>
#include <aws/lightsail/model/StopRelationalDatabaseRequest.h>
#include <aws/lightsail/model/StopRelationalDatabaseResult.h>
#include <aws/lightsail/model/Tag.h>
#include <aws/lightsail/model/TagResourceRequest.h>
#include <aws/lightsail/model/TagResourceResult.h>
#include <aws/lightsail/model/TestAlarmRequest.h>
#include <aws/lightsail/model/TestAlarmResult.h>
#include <aws/lightsail/model/TimePeriod.h>
#include <aws/lightsail/model/TreatMissingData.h>
#include <aws/lightsail/model/UnauthenticatedException.h>
#include <aws/lightsail/model/UnpeerVpcRequest.h>
#include <aws/lightsail/model/UnpeerVpcResult.h>
#include <aws/lightsail/model/UntagResourceRequest.h>
#include <aws/lightsail/model/UntagResourceResult.h>
#include <aws/lightsail/model/UpdateBucketBundleRequest.h>
#include <aws/lightsail/model/UpdateBucketBundleResult.h>
#include <aws/lightsail/model/UpdateBucketRequest.h>
#include <aws/lightsail/model/UpdateBucketResult.h>
#include <aws/lightsail/model/UpdateContainerServiceRequest.h>
#include <aws/lightsail/model/UpdateContainerServiceResult.h>
#include <aws/lightsail/model/UpdateDistributionBundleRequest.h>
#include <aws/lightsail/model/UpdateDistributionBundleResult.h>
#include <aws/lightsail/model/UpdateDistributionRequest.h>
#include <aws/lightsail/model/UpdateDistributionResult.h>
#include <aws/lightsail/model/UpdateDomainEntryRequest.h>
#include <aws/lightsail/model/UpdateDomainEntryResult.h>
#include <aws/lightsail/model/UpdateInstanceMetadataOptionsRequest.h>
#include <aws/lightsail/model/UpdateInstanceMetadataOptionsResult.h>
#include <aws/lightsail/model/UpdateLoadBalancerAttributeRequest.h>
#include <aws/lightsail/model/UpdateLoadBalancerAttributeResult.h>
#include <aws/lightsail/model/UpdateRelationalDatabaseParametersRequest.h>
#include <aws/lightsail/model/UpdateRelationalDatabaseParametersResult.h>
#include <aws/lightsail/model/UpdateRelationalDatabaseRequest.h>
#include <aws/lightsail/model/UpdateRelationalDatabaseResult.h>
#include <aws/lightsail/model/ViewerMinimumTlsProtocolVersionEnum.h>

using LightsailIncludeTest = ::testing::Test;

TEST_F(LightsailIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::Lightsail::LightsailClient>("LightsailIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
