/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/location/LocationServiceClient.h>
#include <aws/location/LocationServiceEndpointProvider.h>
#include <aws/location/LocationServiceEndpointRules.h>
#include <aws/location/LocationServiceErrorMarshaller.h>
#include <aws/location/LocationServiceErrors.h>
#include <aws/location/LocationServiceRequest.h>
#include <aws/location/LocationServiceServiceClientModel.h>
#include <aws/location/LocationService_EXPORTS.h>
#include <aws/location/model/ApiKeyFilter.h>
#include <aws/location/model/ApiKeyRestrictions.h>
#include <aws/location/model/AssociateTrackerConsumerRequest.h>
#include <aws/location/model/AssociateTrackerConsumerResult.h>
#include <aws/location/model/BatchDeleteDevicePositionHistoryError.h>
#include <aws/location/model/BatchDeleteDevicePositionHistoryRequest.h>
#include <aws/location/model/BatchDeleteDevicePositionHistoryResult.h>
#include <aws/location/model/BatchDeleteGeofenceError.h>
#include <aws/location/model/BatchDeleteGeofenceRequest.h>
#include <aws/location/model/BatchDeleteGeofenceResult.h>
#include <aws/location/model/BatchEvaluateGeofencesError.h>
#include <aws/location/model/BatchEvaluateGeofencesRequest.h>
#include <aws/location/model/BatchEvaluateGeofencesResult.h>
#include <aws/location/model/BatchGetDevicePositionError.h>
#include <aws/location/model/BatchGetDevicePositionRequest.h>
#include <aws/location/model/BatchGetDevicePositionResult.h>
#include <aws/location/model/BatchItemError.h>
#include <aws/location/model/BatchItemErrorCode.h>
#include <aws/location/model/BatchPutGeofenceError.h>
#include <aws/location/model/BatchPutGeofenceRequest.h>
#include <aws/location/model/BatchPutGeofenceRequestEntry.h>
#include <aws/location/model/BatchPutGeofenceResult.h>
#include <aws/location/model/BatchPutGeofenceSuccess.h>
#include <aws/location/model/BatchUpdateDevicePositionError.h>
#include <aws/location/model/BatchUpdateDevicePositionRequest.h>
#include <aws/location/model/BatchUpdateDevicePositionResult.h>
#include <aws/location/model/CalculateRouteCarModeOptions.h>
#include <aws/location/model/CalculateRouteMatrixRequest.h>
#include <aws/location/model/CalculateRouteMatrixResult.h>
#include <aws/location/model/CalculateRouteMatrixSummary.h>
#include <aws/location/model/CalculateRouteRequest.h>
#include <aws/location/model/CalculateRouteResult.h>
#include <aws/location/model/CalculateRouteSummary.h>
#include <aws/location/model/CalculateRouteTruckModeOptions.h>
#include <aws/location/model/CellSignals.h>
#include <aws/location/model/Circle.h>
#include <aws/location/model/CreateGeofenceCollectionRequest.h>
#include <aws/location/model/CreateGeofenceCollectionResult.h>
#include <aws/location/model/CreateKeyRequest.h>
#include <aws/location/model/CreateKeyResult.h>
#include <aws/location/model/CreateMapRequest.h>
#include <aws/location/model/CreateMapResult.h>
#include <aws/location/model/CreatePlaceIndexRequest.h>
#include <aws/location/model/CreatePlaceIndexResult.h>
#include <aws/location/model/CreateRouteCalculatorRequest.h>
#include <aws/location/model/CreateRouteCalculatorResult.h>
#include <aws/location/model/CreateTrackerRequest.h>
#include <aws/location/model/CreateTrackerResult.h>
#include <aws/location/model/DataSourceConfiguration.h>
#include <aws/location/model/DeleteGeofenceCollectionRequest.h>
#include <aws/location/model/DeleteGeofenceCollectionResult.h>
#include <aws/location/model/DeleteKeyRequest.h>
#include <aws/location/model/DeleteKeyResult.h>
#include <aws/location/model/DeleteMapRequest.h>
#include <aws/location/model/DeleteMapResult.h>
#include <aws/location/model/DeletePlaceIndexRequest.h>
#include <aws/location/model/DeletePlaceIndexResult.h>
#include <aws/location/model/DeleteRouteCalculatorRequest.h>
#include <aws/location/model/DeleteRouteCalculatorResult.h>
#include <aws/location/model/DeleteTrackerRequest.h>
#include <aws/location/model/DeleteTrackerResult.h>
#include <aws/location/model/DescribeGeofenceCollectionRequest.h>
#include <aws/location/model/DescribeGeofenceCollectionResult.h>
#include <aws/location/model/DescribeKeyRequest.h>
#include <aws/location/model/DescribeKeyResult.h>
#include <aws/location/model/DescribeMapRequest.h>
#include <aws/location/model/DescribeMapResult.h>
#include <aws/location/model/DescribePlaceIndexRequest.h>
#include <aws/location/model/DescribePlaceIndexResult.h>
#include <aws/location/model/DescribeRouteCalculatorRequest.h>
#include <aws/location/model/DescribeRouteCalculatorResult.h>
#include <aws/location/model/DescribeTrackerRequest.h>
#include <aws/location/model/DescribeTrackerResult.h>
#include <aws/location/model/DevicePosition.h>
#include <aws/location/model/DevicePositionUpdate.h>
#include <aws/location/model/DeviceState.h>
#include <aws/location/model/DimensionUnit.h>
#include <aws/location/model/DisassociateTrackerConsumerRequest.h>
#include <aws/location/model/DisassociateTrackerConsumerResult.h>
#include <aws/location/model/DistanceUnit.h>
#include <aws/location/model/ForecastGeofenceEventsDeviceState.h>
#include <aws/location/model/ForecastGeofenceEventsRequest.h>
#include <aws/location/model/ForecastGeofenceEventsResult.h>
#include <aws/location/model/ForecastedEvent.h>
#include <aws/location/model/ForecastedGeofenceEventType.h>
#include <aws/location/model/GeofenceGeometry.h>
#include <aws/location/model/GetDevicePositionHistoryRequest.h>
#include <aws/location/model/GetDevicePositionHistoryResult.h>
#include <aws/location/model/GetDevicePositionRequest.h>
#include <aws/location/model/GetDevicePositionResult.h>
#include <aws/location/model/GetGeofenceRequest.h>
#include <aws/location/model/GetGeofenceResult.h>
#include <aws/location/model/GetMapGlyphsRequest.h>
#include <aws/location/model/GetMapGlyphsResult.h>
#include <aws/location/model/GetMapSpritesRequest.h>
#include <aws/location/model/GetMapSpritesResult.h>
#include <aws/location/model/GetMapStyleDescriptorRequest.h>
#include <aws/location/model/GetMapStyleDescriptorResult.h>
#include <aws/location/model/GetMapTileRequest.h>
#include <aws/location/model/GetMapTileResult.h>
#include <aws/location/model/GetPlaceRequest.h>
#include <aws/location/model/GetPlaceResult.h>
#include <aws/location/model/InferredState.h>
#include <aws/location/model/IntendedUse.h>
#include <aws/location/model/Leg.h>
#include <aws/location/model/LegGeometry.h>
#include <aws/location/model/ListDevicePositionsRequest.h>
#include <aws/location/model/ListDevicePositionsResponseEntry.h>
#include <aws/location/model/ListDevicePositionsResult.h>
#include <aws/location/model/ListGeofenceCollectionsRequest.h>
#include <aws/location/model/ListGeofenceCollectionsResponseEntry.h>
#include <aws/location/model/ListGeofenceCollectionsResult.h>
#include <aws/location/model/ListGeofenceResponseEntry.h>
#include <aws/location/model/ListGeofencesRequest.h>
#include <aws/location/model/ListGeofencesResult.h>
#include <aws/location/model/ListKeysRequest.h>
#include <aws/location/model/ListKeysResponseEntry.h>
#include <aws/location/model/ListKeysResult.h>
#include <aws/location/model/ListMapsRequest.h>
#include <aws/location/model/ListMapsResponseEntry.h>
#include <aws/location/model/ListMapsResult.h>
#include <aws/location/model/ListPlaceIndexesRequest.h>
#include <aws/location/model/ListPlaceIndexesResponseEntry.h>
#include <aws/location/model/ListPlaceIndexesResult.h>
#include <aws/location/model/ListRouteCalculatorsRequest.h>
#include <aws/location/model/ListRouteCalculatorsResponseEntry.h>
#include <aws/location/model/ListRouteCalculatorsResult.h>
#include <aws/location/model/ListTagsForResourceRequest.h>
#include <aws/location/model/ListTagsForResourceResult.h>
#include <aws/location/model/ListTrackerConsumersRequest.h>
#include <aws/location/model/ListTrackerConsumersResult.h>
#include <aws/location/model/ListTrackersRequest.h>
#include <aws/location/model/ListTrackersResponseEntry.h>
#include <aws/location/model/ListTrackersResult.h>
#include <aws/location/model/LteCellDetails.h>
#include <aws/location/model/LteLocalId.h>
#include <aws/location/model/LteNetworkMeasurements.h>
#include <aws/location/model/MapConfiguration.h>
#include <aws/location/model/MapConfigurationUpdate.h>
#include <aws/location/model/OptimizationMode.h>
#include <aws/location/model/Place.h>
#include <aws/location/model/PlaceGeometry.h>
#include <aws/location/model/PositionFiltering.h>
#include <aws/location/model/PositionalAccuracy.h>
#include <aws/location/model/PutGeofenceRequest.h>
#include <aws/location/model/PutGeofenceResult.h>
#include <aws/location/model/RouteMatrixEntry.h>
#include <aws/location/model/RouteMatrixEntryError.h>
#include <aws/location/model/RouteMatrixErrorCode.h>
#include <aws/location/model/SearchForPositionResult.h>
#include <aws/location/model/SearchForSuggestionsResult.h>
#include <aws/location/model/SearchForTextResult.h>
#include <aws/location/model/SearchPlaceIndexForPositionRequest.h>
#include <aws/location/model/SearchPlaceIndexForPositionResult.h>
#include <aws/location/model/SearchPlaceIndexForPositionSummary.h>
#include <aws/location/model/SearchPlaceIndexForSuggestionsRequest.h>
#include <aws/location/model/SearchPlaceIndexForSuggestionsResult.h>
#include <aws/location/model/SearchPlaceIndexForSuggestionsSummary.h>
#include <aws/location/model/SearchPlaceIndexForTextRequest.h>
#include <aws/location/model/SearchPlaceIndexForTextResult.h>
#include <aws/location/model/SearchPlaceIndexForTextSummary.h>
#include <aws/location/model/SpeedUnit.h>
#include <aws/location/model/Status.h>
#include <aws/location/model/Step.h>
#include <aws/location/model/TagResourceRequest.h>
#include <aws/location/model/TagResourceResult.h>
#include <aws/location/model/TimeZone.h>
#include <aws/location/model/TrackingFilterGeometry.h>
#include <aws/location/model/TravelMode.h>
#include <aws/location/model/TruckDimensions.h>
#include <aws/location/model/TruckWeight.h>
#include <aws/location/model/UntagResourceRequest.h>
#include <aws/location/model/UntagResourceResult.h>
#include <aws/location/model/UpdateGeofenceCollectionRequest.h>
#include <aws/location/model/UpdateGeofenceCollectionResult.h>
#include <aws/location/model/UpdateKeyRequest.h>
#include <aws/location/model/UpdateKeyResult.h>
#include <aws/location/model/UpdateMapRequest.h>
#include <aws/location/model/UpdateMapResult.h>
#include <aws/location/model/UpdatePlaceIndexRequest.h>
#include <aws/location/model/UpdatePlaceIndexResult.h>
#include <aws/location/model/UpdateRouteCalculatorRequest.h>
#include <aws/location/model/UpdateRouteCalculatorResult.h>
#include <aws/location/model/UpdateTrackerRequest.h>
#include <aws/location/model/UpdateTrackerResult.h>
#include <aws/location/model/ValidationException.h>
#include <aws/location/model/ValidationExceptionField.h>
#include <aws/location/model/ValidationExceptionReason.h>
#include <aws/location/model/VehicleWeightUnit.h>
#include <aws/location/model/VerifyDevicePositionRequest.h>
#include <aws/location/model/VerifyDevicePositionResult.h>
#include <aws/location/model/WiFiAccessPoint.h>

using LocationServiceIncludeTest = ::testing::Test;

TEST_F(LocationServiceIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::LocationService::LocationServiceClient>("LocationServiceIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
