/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/logs/CloudWatchLogsClient.h>
#include <aws/logs/CloudWatchLogsEndpointProvider.h>
#include <aws/logs/CloudWatchLogsEndpointRules.h>
#include <aws/logs/CloudWatchLogsErrorMarshaller.h>
#include <aws/logs/CloudWatchLogsErrors.h>
#include <aws/logs/CloudWatchLogsRequest.h>
#include <aws/logs/CloudWatchLogsServiceClientModel.h>
#include <aws/logs/CloudWatchLogs_EXPORTS.h>
#include <aws/logs/model/AccountPolicy.h>
#include <aws/logs/model/AddKeyEntry.h>
#include <aws/logs/model/AddKeys.h>
#include <aws/logs/model/Anomaly.h>
#include <aws/logs/model/AnomalyDetector.h>
#include <aws/logs/model/AnomalyDetectorStatus.h>
#include <aws/logs/model/AssociateKmsKeyRequest.h>
#include <aws/logs/model/CSV.h>
#include <aws/logs/model/CancelExportTaskRequest.h>
#include <aws/logs/model/ConfigurationTemplate.h>
#include <aws/logs/model/ConfigurationTemplateDeliveryConfigValues.h>
#include <aws/logs/model/CopyValue.h>
#include <aws/logs/model/CopyValueEntry.h>
#include <aws/logs/model/CreateDeliveryRequest.h>
#include <aws/logs/model/CreateDeliveryResult.h>
#include <aws/logs/model/CreateExportTaskRequest.h>
#include <aws/logs/model/CreateExportTaskResult.h>
#include <aws/logs/model/CreateLogAnomalyDetectorRequest.h>
#include <aws/logs/model/CreateLogAnomalyDetectorResult.h>
#include <aws/logs/model/CreateLogGroupRequest.h>
#include <aws/logs/model/CreateLogStreamRequest.h>
#include <aws/logs/model/DataAlreadyAcceptedException.h>
#include <aws/logs/model/DataProtectionStatus.h>
#include <aws/logs/model/DateTimeConverter.h>
#include <aws/logs/model/DeleteAccountPolicyRequest.h>
#include <aws/logs/model/DeleteDataProtectionPolicyRequest.h>
#include <aws/logs/model/DeleteDeliveryDestinationPolicyRequest.h>
#include <aws/logs/model/DeleteDeliveryDestinationRequest.h>
#include <aws/logs/model/DeleteDeliveryRequest.h>
#include <aws/logs/model/DeleteDeliverySourceRequest.h>
#include <aws/logs/model/DeleteDestinationRequest.h>
#include <aws/logs/model/DeleteIndexPolicyRequest.h>
#include <aws/logs/model/DeleteIndexPolicyResult.h>
#include <aws/logs/model/DeleteIntegrationRequest.h>
#include <aws/logs/model/DeleteIntegrationResult.h>
#include <aws/logs/model/DeleteKeys.h>
#include <aws/logs/model/DeleteLogAnomalyDetectorRequest.h>
#include <aws/logs/model/DeleteLogGroupRequest.h>
#include <aws/logs/model/DeleteLogStreamRequest.h>
#include <aws/logs/model/DeleteMetricFilterRequest.h>
#include <aws/logs/model/DeleteQueryDefinitionRequest.h>
#include <aws/logs/model/DeleteQueryDefinitionResult.h>
#include <aws/logs/model/DeleteResourcePolicyRequest.h>
#include <aws/logs/model/DeleteRetentionPolicyRequest.h>
#include <aws/logs/model/DeleteSubscriptionFilterRequest.h>
#include <aws/logs/model/DeleteTransformerRequest.h>
#include <aws/logs/model/Delivery.h>
#include <aws/logs/model/DeliveryDestination.h>
#include <aws/logs/model/DeliveryDestinationConfiguration.h>
#include <aws/logs/model/DeliveryDestinationType.h>
#include <aws/logs/model/DeliverySource.h>
#include <aws/logs/model/DescribeAccountPoliciesRequest.h>
#include <aws/logs/model/DescribeAccountPoliciesResult.h>
#include <aws/logs/model/DescribeConfigurationTemplatesRequest.h>
#include <aws/logs/model/DescribeConfigurationTemplatesResult.h>
#include <aws/logs/model/DescribeDeliveriesRequest.h>
#include <aws/logs/model/DescribeDeliveriesResult.h>
#include <aws/logs/model/DescribeDeliveryDestinationsRequest.h>
#include <aws/logs/model/DescribeDeliveryDestinationsResult.h>
#include <aws/logs/model/DescribeDeliverySourcesRequest.h>
#include <aws/logs/model/DescribeDeliverySourcesResult.h>
#include <aws/logs/model/DescribeDestinationsRequest.h>
#include <aws/logs/model/DescribeDestinationsResult.h>
#include <aws/logs/model/DescribeExportTasksRequest.h>
#include <aws/logs/model/DescribeExportTasksResult.h>
#include <aws/logs/model/DescribeFieldIndexesRequest.h>
#include <aws/logs/model/DescribeFieldIndexesResult.h>
#include <aws/logs/model/DescribeIndexPoliciesRequest.h>
#include <aws/logs/model/DescribeIndexPoliciesResult.h>
#include <aws/logs/model/DescribeLogGroupsRequest.h>
#include <aws/logs/model/DescribeLogGroupsResult.h>
#include <aws/logs/model/DescribeLogStreamsRequest.h>
#include <aws/logs/model/DescribeLogStreamsResult.h>
#include <aws/logs/model/DescribeMetricFiltersRequest.h>
#include <aws/logs/model/DescribeMetricFiltersResult.h>
#include <aws/logs/model/DescribeQueriesRequest.h>
#include <aws/logs/model/DescribeQueriesResult.h>
#include <aws/logs/model/DescribeQueryDefinitionsRequest.h>
#include <aws/logs/model/DescribeQueryDefinitionsResult.h>
#include <aws/logs/model/DescribeResourcePoliciesRequest.h>
#include <aws/logs/model/DescribeResourcePoliciesResult.h>
#include <aws/logs/model/DescribeSubscriptionFiltersRequest.h>
#include <aws/logs/model/DescribeSubscriptionFiltersResult.h>
#include <aws/logs/model/Destination.h>
#include <aws/logs/model/DisassociateKmsKeyRequest.h>
#include <aws/logs/model/Distribution.h>
#include <aws/logs/model/Entity.h>
#include <aws/logs/model/EntityRejectionErrorType.h>
#include <aws/logs/model/EvaluationFrequency.h>
#include <aws/logs/model/EventSource.h>
#include <aws/logs/model/ExportTask.h>
#include <aws/logs/model/ExportTaskExecutionInfo.h>
#include <aws/logs/model/ExportTaskStatus.h>
#include <aws/logs/model/ExportTaskStatusCode.h>
#include <aws/logs/model/FieldIndex.h>
#include <aws/logs/model/FilterLogEventsRequest.h>
#include <aws/logs/model/FilterLogEventsResult.h>
#include <aws/logs/model/FilteredLogEvent.h>
#include <aws/logs/model/FlattenedElement.h>
#include <aws/logs/model/GetDataProtectionPolicyRequest.h>
#include <aws/logs/model/GetDataProtectionPolicyResult.h>
#include <aws/logs/model/GetDeliveryDestinationPolicyRequest.h>
#include <aws/logs/model/GetDeliveryDestinationPolicyResult.h>
#include <aws/logs/model/GetDeliveryDestinationRequest.h>
#include <aws/logs/model/GetDeliveryDestinationResult.h>
#include <aws/logs/model/GetDeliveryRequest.h>
#include <aws/logs/model/GetDeliveryResult.h>
#include <aws/logs/model/GetDeliverySourceRequest.h>
#include <aws/logs/model/GetDeliverySourceResult.h>
#include <aws/logs/model/GetIntegrationRequest.h>
#include <aws/logs/model/GetIntegrationResult.h>
#include <aws/logs/model/GetLogAnomalyDetectorRequest.h>
#include <aws/logs/model/GetLogAnomalyDetectorResult.h>
#include <aws/logs/model/GetLogEventsRequest.h>
#include <aws/logs/model/GetLogEventsResult.h>
#include <aws/logs/model/GetLogGroupFieldsRequest.h>
#include <aws/logs/model/GetLogGroupFieldsResult.h>
#include <aws/logs/model/GetLogRecordRequest.h>
#include <aws/logs/model/GetLogRecordResult.h>
#include <aws/logs/model/GetQueryResultsRequest.h>
#include <aws/logs/model/GetQueryResultsResult.h>
#include <aws/logs/model/GetTransformerRequest.h>
#include <aws/logs/model/GetTransformerResult.h>
#include <aws/logs/model/Grok.h>
#include <aws/logs/model/IndexPolicy.h>
#include <aws/logs/model/IndexSource.h>
#include <aws/logs/model/InheritedProperty.h>
#include <aws/logs/model/InputLogEvent.h>
#include <aws/logs/model/IntegrationDetails.h>
#include <aws/logs/model/IntegrationStatus.h>
#include <aws/logs/model/IntegrationSummary.h>
#include <aws/logs/model/IntegrationType.h>
#include <aws/logs/model/InvalidSequenceTokenException.h>
#include <aws/logs/model/ListAnomaliesRequest.h>
#include <aws/logs/model/ListAnomaliesResult.h>
#include <aws/logs/model/ListIntegrationsRequest.h>
#include <aws/logs/model/ListIntegrationsResult.h>
#include <aws/logs/model/ListLogAnomalyDetectorsRequest.h>
#include <aws/logs/model/ListLogAnomalyDetectorsResult.h>
#include <aws/logs/model/ListLogGroupsForQueryRequest.h>
#include <aws/logs/model/ListLogGroupsForQueryResult.h>
#include <aws/logs/model/ListLogGroupsRequest.h>
#include <aws/logs/model/ListLogGroupsResult.h>
#include <aws/logs/model/ListTagsForResourceRequest.h>
#include <aws/logs/model/ListTagsForResourceResult.h>
#include <aws/logs/model/ListToMap.h>
#include <aws/logs/model/LiveTailSessionLogEvent.h>
#include <aws/logs/model/LiveTailSessionMetadata.h>
#include <aws/logs/model/LiveTailSessionStart.h>
#include <aws/logs/model/LiveTailSessionUpdate.h>
#include <aws/logs/model/LogEvent.h>
#include <aws/logs/model/LogGroup.h>
#include <aws/logs/model/LogGroupClass.h>
#include <aws/logs/model/LogGroupField.h>
#include <aws/logs/model/LogGroupSummary.h>
#include <aws/logs/model/LogStream.h>
#include <aws/logs/model/LowerCaseString.h>
#include <aws/logs/model/MalformedQueryException.h>
#include <aws/logs/model/MetricFilter.h>
#include <aws/logs/model/MetricFilterMatchRecord.h>
#include <aws/logs/model/MetricTransformation.h>
#include <aws/logs/model/MoveKeyEntry.h>
#include <aws/logs/model/MoveKeys.h>
#include <aws/logs/model/OCSFVersion.h>
#include <aws/logs/model/OpenSearchApplication.h>
#include <aws/logs/model/OpenSearchCollection.h>
#include <aws/logs/model/OpenSearchDataAccessPolicy.h>
#include <aws/logs/model/OpenSearchDataSource.h>
#include <aws/logs/model/OpenSearchEncryptionPolicy.h>
#include <aws/logs/model/OpenSearchIntegrationDetails.h>
#include <aws/logs/model/OpenSearchLifecyclePolicy.h>
#include <aws/logs/model/OpenSearchNetworkPolicy.h>
#include <aws/logs/model/OpenSearchResourceConfig.h>
#include <aws/logs/model/OpenSearchResourceStatus.h>
#include <aws/logs/model/OpenSearchResourceStatusType.h>
#include <aws/logs/model/OpenSearchWorkspace.h>
#include <aws/logs/model/OrderBy.h>
#include <aws/logs/model/OutputFormat.h>
#include <aws/logs/model/OutputLogEvent.h>
#include <aws/logs/model/ParseCloudfront.h>
#include <aws/logs/model/ParseJSON.h>
#include <aws/logs/model/ParseKeyValue.h>
#include <aws/logs/model/ParsePostgres.h>
#include <aws/logs/model/ParseRoute53.h>
#include <aws/logs/model/ParseToOCSF.h>
#include <aws/logs/model/ParseVPC.h>
#include <aws/logs/model/ParseWAF.h>
#include <aws/logs/model/PatternToken.h>
#include <aws/logs/model/Policy.h>
#include <aws/logs/model/PolicyType.h>
#include <aws/logs/model/Processor.h>
#include <aws/logs/model/PutAccountPolicyRequest.h>
#include <aws/logs/model/PutAccountPolicyResult.h>
#include <aws/logs/model/PutDataProtectionPolicyRequest.h>
#include <aws/logs/model/PutDataProtectionPolicyResult.h>
#include <aws/logs/model/PutDeliveryDestinationPolicyRequest.h>
#include <aws/logs/model/PutDeliveryDestinationPolicyResult.h>
#include <aws/logs/model/PutDeliveryDestinationRequest.h>
#include <aws/logs/model/PutDeliveryDestinationResult.h>
#include <aws/logs/model/PutDeliverySourceRequest.h>
#include <aws/logs/model/PutDeliverySourceResult.h>
#include <aws/logs/model/PutDestinationPolicyRequest.h>
#include <aws/logs/model/PutDestinationRequest.h>
#include <aws/logs/model/PutDestinationResult.h>
#include <aws/logs/model/PutIndexPolicyRequest.h>
#include <aws/logs/model/PutIndexPolicyResult.h>
#include <aws/logs/model/PutIntegrationRequest.h>
#include <aws/logs/model/PutIntegrationResult.h>
#include <aws/logs/model/PutLogEventsRequest.h>
#include <aws/logs/model/PutLogEventsResult.h>
#include <aws/logs/model/PutMetricFilterRequest.h>
#include <aws/logs/model/PutQueryDefinitionRequest.h>
#include <aws/logs/model/PutQueryDefinitionResult.h>
#include <aws/logs/model/PutResourcePolicyRequest.h>
#include <aws/logs/model/PutResourcePolicyResult.h>
#include <aws/logs/model/PutRetentionPolicyRequest.h>
#include <aws/logs/model/PutSubscriptionFilterRequest.h>
#include <aws/logs/model/PutTransformerRequest.h>
#include <aws/logs/model/QueryCompileError.h>
#include <aws/logs/model/QueryCompileErrorLocation.h>
#include <aws/logs/model/QueryDefinition.h>
#include <aws/logs/model/QueryInfo.h>
#include <aws/logs/model/QueryLanguage.h>
#include <aws/logs/model/QueryStatistics.h>
#include <aws/logs/model/QueryStatus.h>
#include <aws/logs/model/RecordField.h>
#include <aws/logs/model/RejectedEntityInfo.h>
#include <aws/logs/model/RejectedLogEventsInfo.h>
#include <aws/logs/model/RenameKeyEntry.h>
#include <aws/logs/model/RenameKeys.h>
#include <aws/logs/model/ResourceConfig.h>
#include <aws/logs/model/ResourcePolicy.h>
#include <aws/logs/model/ResultField.h>
#include <aws/logs/model/S3DeliveryConfiguration.h>
#include <aws/logs/model/Scope.h>
#include <aws/logs/model/SearchedLogStream.h>
#include <aws/logs/model/SplitString.h>
#include <aws/logs/model/SplitStringEntry.h>
#include <aws/logs/model/StandardUnit.h>
#include <aws/logs/model/StartLiveTailHandler.h>
#include <aws/logs/model/StartLiveTailInitialResponse.h>
#include <aws/logs/model/StartLiveTailRequest.h>
#include <aws/logs/model/StartLiveTailResponseStream.h>
#include <aws/logs/model/StartQueryRequest.h>
#include <aws/logs/model/StartQueryResult.h>
#include <aws/logs/model/State.h>
#include <aws/logs/model/StopQueryRequest.h>
#include <aws/logs/model/StopQueryResult.h>
#include <aws/logs/model/SubscriptionFilter.h>
#include <aws/logs/model/SubstituteString.h>
#include <aws/logs/model/SubstituteStringEntry.h>
#include <aws/logs/model/SuppressionPeriod.h>
#include <aws/logs/model/SuppressionState.h>
#include <aws/logs/model/SuppressionType.h>
#include <aws/logs/model/SuppressionUnit.h>
#include <aws/logs/model/TagResourceRequest.h>
#include <aws/logs/model/TestMetricFilterRequest.h>
#include <aws/logs/model/TestMetricFilterResult.h>
#include <aws/logs/model/TestTransformerRequest.h>
#include <aws/logs/model/TestTransformerResult.h>
#include <aws/logs/model/TooManyTagsException.h>
#include <aws/logs/model/TransformedLogRecord.h>
#include <aws/logs/model/TrimString.h>
#include <aws/logs/model/Type.h>
#include <aws/logs/model/TypeConverter.h>
#include <aws/logs/model/TypeConverterEntry.h>
#include <aws/logs/model/UntagResourceRequest.h>
#include <aws/logs/model/UpdateAnomalyRequest.h>
#include <aws/logs/model/UpdateDeliveryConfigurationRequest.h>
#include <aws/logs/model/UpdateDeliveryConfigurationResult.h>
#include <aws/logs/model/UpdateLogAnomalyDetectorRequest.h>
#include <aws/logs/model/UpperCaseString.h>

using CloudWatchLogsIncludeTest = ::testing::Test;

TEST_F(CloudWatchLogsIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::CloudWatchLogs::CloudWatchLogsClient>("CloudWatchLogsIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
