/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/lookoutequipment/LookoutEquipmentClient.h>
#include <aws/lookoutequipment/LookoutEquipmentEndpointProvider.h>
#include <aws/lookoutequipment/LookoutEquipmentEndpointRules.h>
#include <aws/lookoutequipment/LookoutEquipmentErrorMarshaller.h>
#include <aws/lookoutequipment/LookoutEquipmentErrors.h>
#include <aws/lookoutequipment/LookoutEquipmentRequest.h>
#include <aws/lookoutequipment/LookoutEquipmentServiceClientModel.h>
#include <aws/lookoutequipment/LookoutEquipment_EXPORTS.h>
#include <aws/lookoutequipment/model/AutoPromotionResult.h>
#include <aws/lookoutequipment/model/CategoricalValues.h>
#include <aws/lookoutequipment/model/CountPercent.h>
#include <aws/lookoutequipment/model/CreateDatasetRequest.h>
#include <aws/lookoutequipment/model/CreateDatasetResult.h>
#include <aws/lookoutequipment/model/CreateInferenceSchedulerRequest.h>
#include <aws/lookoutequipment/model/CreateInferenceSchedulerResult.h>
#include <aws/lookoutequipment/model/CreateLabelGroupRequest.h>
#include <aws/lookoutequipment/model/CreateLabelGroupResult.h>
#include <aws/lookoutequipment/model/CreateLabelRequest.h>
#include <aws/lookoutequipment/model/CreateLabelResult.h>
#include <aws/lookoutequipment/model/CreateModelRequest.h>
#include <aws/lookoutequipment/model/CreateModelResult.h>
#include <aws/lookoutequipment/model/CreateRetrainingSchedulerRequest.h>
#include <aws/lookoutequipment/model/CreateRetrainingSchedulerResult.h>
#include <aws/lookoutequipment/model/DataIngestionJobSummary.h>
#include <aws/lookoutequipment/model/DataPreProcessingConfiguration.h>
#include <aws/lookoutequipment/model/DataQualitySummary.h>
#include <aws/lookoutequipment/model/DataUploadFrequency.h>
#include <aws/lookoutequipment/model/DatasetSchema.h>
#include <aws/lookoutequipment/model/DatasetStatus.h>
#include <aws/lookoutequipment/model/DatasetSummary.h>
#include <aws/lookoutequipment/model/DeleteDatasetRequest.h>
#include <aws/lookoutequipment/model/DeleteInferenceSchedulerRequest.h>
#include <aws/lookoutequipment/model/DeleteLabelGroupRequest.h>
#include <aws/lookoutequipment/model/DeleteLabelRequest.h>
#include <aws/lookoutequipment/model/DeleteModelRequest.h>
#include <aws/lookoutequipment/model/DeleteResourcePolicyRequest.h>
#include <aws/lookoutequipment/model/DeleteRetrainingSchedulerRequest.h>
#include <aws/lookoutequipment/model/DescribeDataIngestionJobRequest.h>
#include <aws/lookoutequipment/model/DescribeDataIngestionJobResult.h>
#include <aws/lookoutequipment/model/DescribeDatasetRequest.h>
#include <aws/lookoutequipment/model/DescribeDatasetResult.h>
#include <aws/lookoutequipment/model/DescribeInferenceSchedulerRequest.h>
#include <aws/lookoutequipment/model/DescribeInferenceSchedulerResult.h>
#include <aws/lookoutequipment/model/DescribeLabelGroupRequest.h>
#include <aws/lookoutequipment/model/DescribeLabelGroupResult.h>
#include <aws/lookoutequipment/model/DescribeLabelRequest.h>
#include <aws/lookoutequipment/model/DescribeLabelResult.h>
#include <aws/lookoutequipment/model/DescribeModelRequest.h>
#include <aws/lookoutequipment/model/DescribeModelResult.h>
#include <aws/lookoutequipment/model/DescribeModelVersionRequest.h>
#include <aws/lookoutequipment/model/DescribeModelVersionResult.h>
#include <aws/lookoutequipment/model/DescribeResourcePolicyRequest.h>
#include <aws/lookoutequipment/model/DescribeResourcePolicyResult.h>
#include <aws/lookoutequipment/model/DescribeRetrainingSchedulerRequest.h>
#include <aws/lookoutequipment/model/DescribeRetrainingSchedulerResult.h>
#include <aws/lookoutequipment/model/DuplicateTimestamps.h>
#include <aws/lookoutequipment/model/ImportDatasetRequest.h>
#include <aws/lookoutequipment/model/ImportDatasetResult.h>
#include <aws/lookoutequipment/model/ImportModelVersionRequest.h>
#include <aws/lookoutequipment/model/ImportModelVersionResult.h>
#include <aws/lookoutequipment/model/InferenceDataImportStrategy.h>
#include <aws/lookoutequipment/model/InferenceEventSummary.h>
#include <aws/lookoutequipment/model/InferenceExecutionStatus.h>
#include <aws/lookoutequipment/model/InferenceExecutionSummary.h>
#include <aws/lookoutequipment/model/InferenceInputConfiguration.h>
#include <aws/lookoutequipment/model/InferenceInputNameConfiguration.h>
#include <aws/lookoutequipment/model/InferenceOutputConfiguration.h>
#include <aws/lookoutequipment/model/InferenceS3InputConfiguration.h>
#include <aws/lookoutequipment/model/InferenceS3OutputConfiguration.h>
#include <aws/lookoutequipment/model/InferenceSchedulerStatus.h>
#include <aws/lookoutequipment/model/InferenceSchedulerSummary.h>
#include <aws/lookoutequipment/model/IngestedFilesSummary.h>
#include <aws/lookoutequipment/model/IngestionInputConfiguration.h>
#include <aws/lookoutequipment/model/IngestionJobStatus.h>
#include <aws/lookoutequipment/model/IngestionS3InputConfiguration.h>
#include <aws/lookoutequipment/model/InsufficientSensorData.h>
#include <aws/lookoutequipment/model/InvalidSensorData.h>
#include <aws/lookoutequipment/model/LabelGroupSummary.h>
#include <aws/lookoutequipment/model/LabelRating.h>
#include <aws/lookoutequipment/model/LabelSummary.h>
#include <aws/lookoutequipment/model/LabelsInputConfiguration.h>
#include <aws/lookoutequipment/model/LabelsS3InputConfiguration.h>
#include <aws/lookoutequipment/model/LargeTimestampGaps.h>
#include <aws/lookoutequipment/model/LatestInferenceResult.h>
#include <aws/lookoutequipment/model/ListDataIngestionJobsRequest.h>
#include <aws/lookoutequipment/model/ListDataIngestionJobsResult.h>
#include <aws/lookoutequipment/model/ListDatasetsRequest.h>
#include <aws/lookoutequipment/model/ListDatasetsResult.h>
#include <aws/lookoutequipment/model/ListInferenceEventsRequest.h>
#include <aws/lookoutequipment/model/ListInferenceEventsResult.h>
#include <aws/lookoutequipment/model/ListInferenceExecutionsRequest.h>
#include <aws/lookoutequipment/model/ListInferenceExecutionsResult.h>
#include <aws/lookoutequipment/model/ListInferenceSchedulersRequest.h>
#include <aws/lookoutequipment/model/ListInferenceSchedulersResult.h>
#include <aws/lookoutequipment/model/ListLabelGroupsRequest.h>
#include <aws/lookoutequipment/model/ListLabelGroupsResult.h>
#include <aws/lookoutequipment/model/ListLabelsRequest.h>
#include <aws/lookoutequipment/model/ListLabelsResult.h>
#include <aws/lookoutequipment/model/ListModelVersionsRequest.h>
#include <aws/lookoutequipment/model/ListModelVersionsResult.h>
#include <aws/lookoutequipment/model/ListModelsRequest.h>
#include <aws/lookoutequipment/model/ListModelsResult.h>
#include <aws/lookoutequipment/model/ListRetrainingSchedulersRequest.h>
#include <aws/lookoutequipment/model/ListRetrainingSchedulersResult.h>
#include <aws/lookoutequipment/model/ListSensorStatisticsRequest.h>
#include <aws/lookoutequipment/model/ListSensorStatisticsResult.h>
#include <aws/lookoutequipment/model/ListTagsForResourceRequest.h>
#include <aws/lookoutequipment/model/ListTagsForResourceResult.h>
#include <aws/lookoutequipment/model/MissingCompleteSensorData.h>
#include <aws/lookoutequipment/model/MissingSensorData.h>
#include <aws/lookoutequipment/model/ModelDiagnosticsOutputConfiguration.h>
#include <aws/lookoutequipment/model/ModelDiagnosticsS3OutputConfiguration.h>
#include <aws/lookoutequipment/model/ModelPromoteMode.h>
#include <aws/lookoutequipment/model/ModelQuality.h>
#include <aws/lookoutequipment/model/ModelStatus.h>
#include <aws/lookoutequipment/model/ModelSummary.h>
#include <aws/lookoutequipment/model/ModelVersionSourceType.h>
#include <aws/lookoutequipment/model/ModelVersionStatus.h>
#include <aws/lookoutequipment/model/ModelVersionSummary.h>
#include <aws/lookoutequipment/model/MonotonicValues.h>
#include <aws/lookoutequipment/model/Monotonicity.h>
#include <aws/lookoutequipment/model/MultipleOperatingModes.h>
#include <aws/lookoutequipment/model/PutResourcePolicyRequest.h>
#include <aws/lookoutequipment/model/PutResourcePolicyResult.h>
#include <aws/lookoutequipment/model/RetrainingSchedulerStatus.h>
#include <aws/lookoutequipment/model/RetrainingSchedulerSummary.h>
#include <aws/lookoutequipment/model/S3Object.h>
#include <aws/lookoutequipment/model/SensorStatisticsSummary.h>
#include <aws/lookoutequipment/model/SensorsWithShortDateRange.h>
#include <aws/lookoutequipment/model/StartDataIngestionJobRequest.h>
#include <aws/lookoutequipment/model/StartDataIngestionJobResult.h>
#include <aws/lookoutequipment/model/StartInferenceSchedulerRequest.h>
#include <aws/lookoutequipment/model/StartInferenceSchedulerResult.h>
#include <aws/lookoutequipment/model/StartRetrainingSchedulerRequest.h>
#include <aws/lookoutequipment/model/StartRetrainingSchedulerResult.h>
#include <aws/lookoutequipment/model/StatisticalIssueStatus.h>
#include <aws/lookoutequipment/model/StopInferenceSchedulerRequest.h>
#include <aws/lookoutequipment/model/StopInferenceSchedulerResult.h>
#include <aws/lookoutequipment/model/StopRetrainingSchedulerRequest.h>
#include <aws/lookoutequipment/model/StopRetrainingSchedulerResult.h>
#include <aws/lookoutequipment/model/Tag.h>
#include <aws/lookoutequipment/model/TagResourceRequest.h>
#include <aws/lookoutequipment/model/TagResourceResult.h>
#include <aws/lookoutequipment/model/TargetSamplingRate.h>
#include <aws/lookoutequipment/model/UnsupportedTimestamps.h>
#include <aws/lookoutequipment/model/UntagResourceRequest.h>
#include <aws/lookoutequipment/model/UntagResourceResult.h>
#include <aws/lookoutequipment/model/UpdateActiveModelVersionRequest.h>
#include <aws/lookoutequipment/model/UpdateActiveModelVersionResult.h>
#include <aws/lookoutequipment/model/UpdateInferenceSchedulerRequest.h>
#include <aws/lookoutequipment/model/UpdateLabelGroupRequest.h>
#include <aws/lookoutequipment/model/UpdateModelRequest.h>
#include <aws/lookoutequipment/model/UpdateRetrainingSchedulerRequest.h>

using LookoutEquipmentIncludeTest = ::testing::Test;

TEST_F(LookoutEquipmentIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::LookoutEquipment::LookoutEquipmentClient>("LookoutEquipmentIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
