/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/m2/MainframeModernizationClient.h>
#include <aws/m2/MainframeModernizationEndpointProvider.h>
#include <aws/m2/MainframeModernizationEndpointRules.h>
#include <aws/m2/MainframeModernizationErrorMarshaller.h>
#include <aws/m2/MainframeModernizationErrors.h>
#include <aws/m2/MainframeModernizationRequest.h>
#include <aws/m2/MainframeModernizationServiceClientModel.h>
#include <aws/m2/MainframeModernization_EXPORTS.h>
#include <aws/m2/model/AlternateKey.h>
#include <aws/m2/model/ApplicationDeploymentLifecycle.h>
#include <aws/m2/model/ApplicationLifecycle.h>
#include <aws/m2/model/ApplicationSummary.h>
#include <aws/m2/model/ApplicationVersionLifecycle.h>
#include <aws/m2/model/ApplicationVersionSummary.h>
#include <aws/m2/model/BatchJobDefinition.h>
#include <aws/m2/model/BatchJobExecutionStatus.h>
#include <aws/m2/model/BatchJobExecutionSummary.h>
#include <aws/m2/model/BatchJobIdentifier.h>
#include <aws/m2/model/BatchJobType.h>
#include <aws/m2/model/CancelBatchJobExecutionRequest.h>
#include <aws/m2/model/CancelBatchJobExecutionResult.h>
#include <aws/m2/model/ConflictException.h>
#include <aws/m2/model/CreateApplicationRequest.h>
#include <aws/m2/model/CreateApplicationResult.h>
#include <aws/m2/model/CreateDataSetExportTaskRequest.h>
#include <aws/m2/model/CreateDataSetExportTaskResult.h>
#include <aws/m2/model/CreateDataSetImportTaskRequest.h>
#include <aws/m2/model/CreateDataSetImportTaskResult.h>
#include <aws/m2/model/CreateDeploymentRequest.h>
#include <aws/m2/model/CreateDeploymentResult.h>
#include <aws/m2/model/CreateEnvironmentRequest.h>
#include <aws/m2/model/CreateEnvironmentResult.h>
#include <aws/m2/model/DataSet.h>
#include <aws/m2/model/DataSetExportConfig.h>
#include <aws/m2/model/DataSetExportItem.h>
#include <aws/m2/model/DataSetExportSummary.h>
#include <aws/m2/model/DataSetExportTask.h>
#include <aws/m2/model/DataSetImportConfig.h>
#include <aws/m2/model/DataSetImportItem.h>
#include <aws/m2/model/DataSetImportSummary.h>
#include <aws/m2/model/DataSetImportTask.h>
#include <aws/m2/model/DataSetSummary.h>
#include <aws/m2/model/DataSetTaskLifecycle.h>
#include <aws/m2/model/DatasetDetailOrgAttributes.h>
#include <aws/m2/model/DatasetOrgAttributes.h>
#include <aws/m2/model/Definition.h>
#include <aws/m2/model/DeleteApplicationFromEnvironmentRequest.h>
#include <aws/m2/model/DeleteApplicationFromEnvironmentResult.h>
#include <aws/m2/model/DeleteApplicationRequest.h>
#include <aws/m2/model/DeleteApplicationResult.h>
#include <aws/m2/model/DeleteEnvironmentRequest.h>
#include <aws/m2/model/DeleteEnvironmentResult.h>
#include <aws/m2/model/DeployedVersionSummary.h>
#include <aws/m2/model/DeploymentLifecycle.h>
#include <aws/m2/model/DeploymentSummary.h>
#include <aws/m2/model/EfsStorageConfiguration.h>
#include <aws/m2/model/EngineType.h>
#include <aws/m2/model/EngineVersionsSummary.h>
#include <aws/m2/model/EnvironmentLifecycle.h>
#include <aws/m2/model/EnvironmentSummary.h>
#include <aws/m2/model/ExternalLocation.h>
#include <aws/m2/model/FileBatchJobDefinition.h>
#include <aws/m2/model/FileBatchJobIdentifier.h>
#include <aws/m2/model/FsxStorageConfiguration.h>
#include <aws/m2/model/GdgAttributes.h>
#include <aws/m2/model/GdgDetailAttributes.h>
#include <aws/m2/model/GetApplicationRequest.h>
#include <aws/m2/model/GetApplicationResult.h>
#include <aws/m2/model/GetApplicationVersionRequest.h>
#include <aws/m2/model/GetApplicationVersionResult.h>
#include <aws/m2/model/GetBatchJobExecutionRequest.h>
#include <aws/m2/model/GetBatchJobExecutionResult.h>
#include <aws/m2/model/GetDataSetDetailsRequest.h>
#include <aws/m2/model/GetDataSetDetailsResult.h>
#include <aws/m2/model/GetDataSetExportTaskRequest.h>
#include <aws/m2/model/GetDataSetExportTaskResult.h>
#include <aws/m2/model/GetDataSetImportTaskRequest.h>
#include <aws/m2/model/GetDataSetImportTaskResult.h>
#include <aws/m2/model/GetDeploymentRequest.h>
#include <aws/m2/model/GetDeploymentResult.h>
#include <aws/m2/model/GetEnvironmentRequest.h>
#include <aws/m2/model/GetEnvironmentResult.h>
#include <aws/m2/model/GetSignedBluinsightsUrlRequest.h>
#include <aws/m2/model/GetSignedBluinsightsUrlResult.h>
#include <aws/m2/model/HighAvailabilityConfig.h>
#include <aws/m2/model/InternalServerException.h>
#include <aws/m2/model/JobIdentifier.h>
#include <aws/m2/model/JobStep.h>
#include <aws/m2/model/JobStepRestartMarker.h>
#include <aws/m2/model/ListApplicationVersionsRequest.h>
#include <aws/m2/model/ListApplicationVersionsResult.h>
#include <aws/m2/model/ListApplicationsRequest.h>
#include <aws/m2/model/ListApplicationsResult.h>
#include <aws/m2/model/ListBatchJobDefinitionsRequest.h>
#include <aws/m2/model/ListBatchJobDefinitionsResult.h>
#include <aws/m2/model/ListBatchJobExecutionsRequest.h>
#include <aws/m2/model/ListBatchJobExecutionsResult.h>
#include <aws/m2/model/ListBatchJobRestartPointsRequest.h>
#include <aws/m2/model/ListBatchJobRestartPointsResult.h>
#include <aws/m2/model/ListDataSetExportHistoryRequest.h>
#include <aws/m2/model/ListDataSetExportHistoryResult.h>
#include <aws/m2/model/ListDataSetImportHistoryRequest.h>
#include <aws/m2/model/ListDataSetImportHistoryResult.h>
#include <aws/m2/model/ListDataSetsRequest.h>
#include <aws/m2/model/ListDataSetsResult.h>
#include <aws/m2/model/ListDeploymentsRequest.h>
#include <aws/m2/model/ListDeploymentsResult.h>
#include <aws/m2/model/ListEngineVersionsRequest.h>
#include <aws/m2/model/ListEngineVersionsResult.h>
#include <aws/m2/model/ListEnvironmentsRequest.h>
#include <aws/m2/model/ListEnvironmentsResult.h>
#include <aws/m2/model/ListTagsForResourceRequest.h>
#include <aws/m2/model/ListTagsForResourceResult.h>
#include <aws/m2/model/LogGroupSummary.h>
#include <aws/m2/model/MaintenanceSchedule.h>
#include <aws/m2/model/NetworkType.h>
#include <aws/m2/model/PendingMaintenance.h>
#include <aws/m2/model/PoAttributes.h>
#include <aws/m2/model/PoDetailAttributes.h>
#include <aws/m2/model/PrimaryKey.h>
#include <aws/m2/model/PsAttributes.h>
#include <aws/m2/model/PsDetailAttributes.h>
#include <aws/m2/model/RecordLength.h>
#include <aws/m2/model/ResourceNotFoundException.h>
#include <aws/m2/model/RestartBatchJobIdentifier.h>
#include <aws/m2/model/S3BatchJobIdentifier.h>
#include <aws/m2/model/ScriptBatchJobDefinition.h>
#include <aws/m2/model/ScriptBatchJobIdentifier.h>
#include <aws/m2/model/ServiceQuotaExceededException.h>
#include <aws/m2/model/StartApplicationRequest.h>
#include <aws/m2/model/StartApplicationResult.h>
#include <aws/m2/model/StartBatchJobRequest.h>
#include <aws/m2/model/StartBatchJobResult.h>
#include <aws/m2/model/StopApplicationRequest.h>
#include <aws/m2/model/StopApplicationResult.h>
#include <aws/m2/model/StorageConfiguration.h>
#include <aws/m2/model/TagResourceRequest.h>
#include <aws/m2/model/TagResourceResult.h>
#include <aws/m2/model/ThrottlingException.h>
#include <aws/m2/model/UntagResourceRequest.h>
#include <aws/m2/model/UntagResourceResult.h>
#include <aws/m2/model/UpdateApplicationRequest.h>
#include <aws/m2/model/UpdateApplicationResult.h>
#include <aws/m2/model/UpdateEnvironmentRequest.h>
#include <aws/m2/model/UpdateEnvironmentResult.h>
#include <aws/m2/model/ValidationException.h>
#include <aws/m2/model/ValidationExceptionField.h>
#include <aws/m2/model/ValidationExceptionReason.h>
#include <aws/m2/model/VsamAttributes.h>
#include <aws/m2/model/VsamDetailAttributes.h>

using MainframeModernizationIncludeTest = ::testing::Test;

TEST_F(MainframeModernizationIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::MainframeModernization::MainframeModernizationClient>("MainframeModernizationIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
