/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/macie2/Macie2Client.h>
#include <aws/macie2/Macie2EndpointProvider.h>
#include <aws/macie2/Macie2EndpointRules.h>
#include <aws/macie2/Macie2ErrorMarshaller.h>
#include <aws/macie2/Macie2Errors.h>
#include <aws/macie2/Macie2Request.h>
#include <aws/macie2/Macie2ServiceClientModel.h>
#include <aws/macie2/Macie2_EXPORTS.h>
#include <aws/macie2/model/AcceptInvitationRequest.h>
#include <aws/macie2/model/AcceptInvitationResult.h>
#include <aws/macie2/model/AccessControlList.h>
#include <aws/macie2/model/AccountDetail.h>
#include <aws/macie2/model/AccountLevelPermissions.h>
#include <aws/macie2/model/AdminAccount.h>
#include <aws/macie2/model/AdminStatus.h>
#include <aws/macie2/model/AllowListCriteria.h>
#include <aws/macie2/model/AllowListStatus.h>
#include <aws/macie2/model/AllowListStatusCode.h>
#include <aws/macie2/model/AllowListSummary.h>
#include <aws/macie2/model/AllowsUnencryptedObjectUploads.h>
#include <aws/macie2/model/ApiCallDetails.h>
#include <aws/macie2/model/AssumedRole.h>
#include <aws/macie2/model/AutoEnableMode.h>
#include <aws/macie2/model/AutomatedDiscoveryAccount.h>
#include <aws/macie2/model/AutomatedDiscoveryAccountStatus.h>
#include <aws/macie2/model/AutomatedDiscoveryAccountUpdate.h>
#include <aws/macie2/model/AutomatedDiscoveryAccountUpdateError.h>
#include <aws/macie2/model/AutomatedDiscoveryAccountUpdateErrorCode.h>
#include <aws/macie2/model/AutomatedDiscoveryMonitoringStatus.h>
#include <aws/macie2/model/AutomatedDiscoveryStatus.h>
#include <aws/macie2/model/AvailabilityCode.h>
#include <aws/macie2/model/AwsAccount.h>
#include <aws/macie2/model/AwsService.h>
#include <aws/macie2/model/BatchGetCustomDataIdentifierSummary.h>
#include <aws/macie2/model/BatchGetCustomDataIdentifiersRequest.h>
#include <aws/macie2/model/BatchGetCustomDataIdentifiersResult.h>
#include <aws/macie2/model/BatchUpdateAutomatedDiscoveryAccountsRequest.h>
#include <aws/macie2/model/BatchUpdateAutomatedDiscoveryAccountsResult.h>
#include <aws/macie2/model/BlockPublicAccess.h>
#include <aws/macie2/model/BucketCountByEffectivePermission.h>
#include <aws/macie2/model/BucketCountByEncryptionType.h>
#include <aws/macie2/model/BucketCountBySharedAccessType.h>
#include <aws/macie2/model/BucketCountPolicyAllowsUnencryptedObjectUploads.h>
#include <aws/macie2/model/BucketCriteriaAdditionalProperties.h>
#include <aws/macie2/model/BucketLevelPermissions.h>
#include <aws/macie2/model/BucketMetadata.h>
#include <aws/macie2/model/BucketMetadataErrorCode.h>
#include <aws/macie2/model/BucketPermissionConfiguration.h>
#include <aws/macie2/model/BucketPolicy.h>
#include <aws/macie2/model/BucketPublicAccess.h>
#include <aws/macie2/model/BucketServerSideEncryption.h>
#include <aws/macie2/model/BucketSortCriteria.h>
#include <aws/macie2/model/BucketStatisticsBySensitivity.h>
#include <aws/macie2/model/Cell.h>
#include <aws/macie2/model/ClassificationDetails.h>
#include <aws/macie2/model/ClassificationExportConfiguration.h>
#include <aws/macie2/model/ClassificationResult.h>
#include <aws/macie2/model/ClassificationResultStatus.h>
#include <aws/macie2/model/ClassificationScopeSummary.h>
#include <aws/macie2/model/ClassificationScopeUpdateOperation.h>
#include <aws/macie2/model/CreateAllowListRequest.h>
#include <aws/macie2/model/CreateAllowListResult.h>
#include <aws/macie2/model/CreateClassificationJobRequest.h>
#include <aws/macie2/model/CreateClassificationJobResult.h>
#include <aws/macie2/model/CreateCustomDataIdentifierRequest.h>
#include <aws/macie2/model/CreateCustomDataIdentifierResult.h>
#include <aws/macie2/model/CreateFindingsFilterRequest.h>
#include <aws/macie2/model/CreateFindingsFilterResult.h>
#include <aws/macie2/model/CreateInvitationsRequest.h>
#include <aws/macie2/model/CreateInvitationsResult.h>
#include <aws/macie2/model/CreateMemberRequest.h>
#include <aws/macie2/model/CreateMemberResult.h>
#include <aws/macie2/model/CreateSampleFindingsRequest.h>
#include <aws/macie2/model/CreateSampleFindingsResult.h>
#include <aws/macie2/model/CriteriaBlockForJob.h>
#include <aws/macie2/model/CriteriaForJob.h>
#include <aws/macie2/model/CriterionAdditionalProperties.h>
#include <aws/macie2/model/Currency.h>
#include <aws/macie2/model/CustomDataIdentifierSummary.h>
#include <aws/macie2/model/CustomDataIdentifiers.h>
#include <aws/macie2/model/CustomDetection.h>
#include <aws/macie2/model/DailySchedule.h>
#include <aws/macie2/model/DataIdentifierSeverity.h>
#include <aws/macie2/model/DataIdentifierType.h>
#include <aws/macie2/model/DayOfWeek.h>
#include <aws/macie2/model/DeclineInvitationsRequest.h>
#include <aws/macie2/model/DeclineInvitationsResult.h>
#include <aws/macie2/model/DefaultDetection.h>
#include <aws/macie2/model/DeleteAllowListRequest.h>
#include <aws/macie2/model/DeleteAllowListResult.h>
#include <aws/macie2/model/DeleteCustomDataIdentifierRequest.h>
#include <aws/macie2/model/DeleteCustomDataIdentifierResult.h>
#include <aws/macie2/model/DeleteFindingsFilterRequest.h>
#include <aws/macie2/model/DeleteFindingsFilterResult.h>
#include <aws/macie2/model/DeleteInvitationsRequest.h>
#include <aws/macie2/model/DeleteInvitationsResult.h>
#include <aws/macie2/model/DeleteMemberRequest.h>
#include <aws/macie2/model/DeleteMemberResult.h>
#include <aws/macie2/model/DescribeBucketsRequest.h>
#include <aws/macie2/model/DescribeBucketsResult.h>
#include <aws/macie2/model/DescribeClassificationJobRequest.h>
#include <aws/macie2/model/DescribeClassificationJobResult.h>
#include <aws/macie2/model/DescribeOrganizationConfigurationRequest.h>
#include <aws/macie2/model/DescribeOrganizationConfigurationResult.h>
#include <aws/macie2/model/DetectedDataDetails.h>
#include <aws/macie2/model/Detection.h>
#include <aws/macie2/model/DisableMacieRequest.h>
#include <aws/macie2/model/DisableMacieResult.h>
#include <aws/macie2/model/DisableOrganizationAdminAccountRequest.h>
#include <aws/macie2/model/DisableOrganizationAdminAccountResult.h>
#include <aws/macie2/model/DisassociateFromAdministratorAccountRequest.h>
#include <aws/macie2/model/DisassociateFromAdministratorAccountResult.h>
#include <aws/macie2/model/DisassociateFromMasterAccountRequest.h>
#include <aws/macie2/model/DisassociateFromMasterAccountResult.h>
#include <aws/macie2/model/DisassociateMemberRequest.h>
#include <aws/macie2/model/DisassociateMemberResult.h>
#include <aws/macie2/model/DomainDetails.h>
#include <aws/macie2/model/EffectivePermission.h>
#include <aws/macie2/model/EnableMacieRequest.h>
#include <aws/macie2/model/EnableMacieResult.h>
#include <aws/macie2/model/EnableOrganizationAdminAccountRequest.h>
#include <aws/macie2/model/EnableOrganizationAdminAccountResult.h>
#include <aws/macie2/model/EncryptionType.h>
#include <aws/macie2/model/ErrorCode.h>
#include <aws/macie2/model/FederatedUser.h>
#include <aws/macie2/model/Finding.h>
#include <aws/macie2/model/FindingAction.h>
#include <aws/macie2/model/FindingActionType.h>
#include <aws/macie2/model/FindingActor.h>
#include <aws/macie2/model/FindingCategory.h>
#include <aws/macie2/model/FindingCriteria.h>
#include <aws/macie2/model/FindingPublishingFrequency.h>
#include <aws/macie2/model/FindingStatisticsSortAttributeName.h>
#include <aws/macie2/model/FindingStatisticsSortCriteria.h>
#include <aws/macie2/model/FindingType.h>
#include <aws/macie2/model/FindingsFilterAction.h>
#include <aws/macie2/model/FindingsFilterListItem.h>
#include <aws/macie2/model/GetAdministratorAccountRequest.h>
#include <aws/macie2/model/GetAdministratorAccountResult.h>
#include <aws/macie2/model/GetAllowListRequest.h>
#include <aws/macie2/model/GetAllowListResult.h>
#include <aws/macie2/model/GetAutomatedDiscoveryConfigurationRequest.h>
#include <aws/macie2/model/GetAutomatedDiscoveryConfigurationResult.h>
#include <aws/macie2/model/GetBucketStatisticsRequest.h>
#include <aws/macie2/model/GetBucketStatisticsResult.h>
#include <aws/macie2/model/GetClassificationExportConfigurationRequest.h>
#include <aws/macie2/model/GetClassificationExportConfigurationResult.h>
#include <aws/macie2/model/GetClassificationScopeRequest.h>
#include <aws/macie2/model/GetClassificationScopeResult.h>
#include <aws/macie2/model/GetCustomDataIdentifierRequest.h>
#include <aws/macie2/model/GetCustomDataIdentifierResult.h>
#include <aws/macie2/model/GetFindingStatisticsRequest.h>
#include <aws/macie2/model/GetFindingStatisticsResult.h>
#include <aws/macie2/model/GetFindingsFilterRequest.h>
#include <aws/macie2/model/GetFindingsFilterResult.h>
#include <aws/macie2/model/GetFindingsPublicationConfigurationRequest.h>
#include <aws/macie2/model/GetFindingsPublicationConfigurationResult.h>
#include <aws/macie2/model/GetFindingsRequest.h>
#include <aws/macie2/model/GetFindingsResult.h>
#include <aws/macie2/model/GetInvitationsCountRequest.h>
#include <aws/macie2/model/GetInvitationsCountResult.h>
#include <aws/macie2/model/GetMacieSessionRequest.h>
#include <aws/macie2/model/GetMacieSessionResult.h>
#include <aws/macie2/model/GetMasterAccountRequest.h>
#include <aws/macie2/model/GetMasterAccountResult.h>
#include <aws/macie2/model/GetMemberRequest.h>
#include <aws/macie2/model/GetMemberResult.h>
#include <aws/macie2/model/GetResourceProfileRequest.h>
#include <aws/macie2/model/GetResourceProfileResult.h>
#include <aws/macie2/model/GetRevealConfigurationRequest.h>
#include <aws/macie2/model/GetRevealConfigurationResult.h>
#include <aws/macie2/model/GetSensitiveDataOccurrencesAvailabilityRequest.h>
#include <aws/macie2/model/GetSensitiveDataOccurrencesAvailabilityResult.h>
#include <aws/macie2/model/GetSensitiveDataOccurrencesRequest.h>
#include <aws/macie2/model/GetSensitiveDataOccurrencesResult.h>
#include <aws/macie2/model/GetSensitivityInspectionTemplateRequest.h>
#include <aws/macie2/model/GetSensitivityInspectionTemplateResult.h>
#include <aws/macie2/model/GetUsageStatisticsRequest.h>
#include <aws/macie2/model/GetUsageStatisticsResult.h>
#include <aws/macie2/model/GetUsageTotalsRequest.h>
#include <aws/macie2/model/GetUsageTotalsResult.h>
#include <aws/macie2/model/GroupBy.h>
#include <aws/macie2/model/GroupCount.h>
#include <aws/macie2/model/IamUser.h>
#include <aws/macie2/model/Invitation.h>
#include <aws/macie2/model/IpAddressDetails.h>
#include <aws/macie2/model/IpCity.h>
#include <aws/macie2/model/IpCountry.h>
#include <aws/macie2/model/IpGeoLocation.h>
#include <aws/macie2/model/IpOwner.h>
#include <aws/macie2/model/IsDefinedInJob.h>
#include <aws/macie2/model/IsMonitoredByJob.h>
#include <aws/macie2/model/JobComparator.h>
#include <aws/macie2/model/JobDetails.h>
#include <aws/macie2/model/JobScheduleFrequency.h>
#include <aws/macie2/model/JobScopeTerm.h>
#include <aws/macie2/model/JobScopingBlock.h>
#include <aws/macie2/model/JobStatus.h>
#include <aws/macie2/model/JobSummary.h>
#include <aws/macie2/model/JobType.h>
#include <aws/macie2/model/KeyValuePair.h>
#include <aws/macie2/model/LastRunErrorStatus.h>
#include <aws/macie2/model/LastRunErrorStatusCode.h>
#include <aws/macie2/model/ListAllowListsRequest.h>
#include <aws/macie2/model/ListAllowListsResult.h>
#include <aws/macie2/model/ListAutomatedDiscoveryAccountsRequest.h>
#include <aws/macie2/model/ListAutomatedDiscoveryAccountsResult.h>
#include <aws/macie2/model/ListClassificationJobsRequest.h>
#include <aws/macie2/model/ListClassificationJobsResult.h>
#include <aws/macie2/model/ListClassificationScopesRequest.h>
#include <aws/macie2/model/ListClassificationScopesResult.h>
#include <aws/macie2/model/ListCustomDataIdentifiersRequest.h>
#include <aws/macie2/model/ListCustomDataIdentifiersResult.h>
#include <aws/macie2/model/ListFindingsFiltersRequest.h>
#include <aws/macie2/model/ListFindingsFiltersResult.h>
#include <aws/macie2/model/ListFindingsRequest.h>
#include <aws/macie2/model/ListFindingsResult.h>
#include <aws/macie2/model/ListInvitationsRequest.h>
#include <aws/macie2/model/ListInvitationsResult.h>
#include <aws/macie2/model/ListJobsFilterCriteria.h>
#include <aws/macie2/model/ListJobsFilterKey.h>
#include <aws/macie2/model/ListJobsFilterTerm.h>
#include <aws/macie2/model/ListJobsSortAttributeName.h>
#include <aws/macie2/model/ListJobsSortCriteria.h>
#include <aws/macie2/model/ListManagedDataIdentifiersRequest.h>
#include <aws/macie2/model/ListManagedDataIdentifiersResult.h>
#include <aws/macie2/model/ListMembersRequest.h>
#include <aws/macie2/model/ListMembersResult.h>
#include <aws/macie2/model/ListOrganizationAdminAccountsRequest.h>
#include <aws/macie2/model/ListOrganizationAdminAccountsResult.h>
#include <aws/macie2/model/ListResourceProfileArtifactsRequest.h>
#include <aws/macie2/model/ListResourceProfileArtifactsResult.h>
#include <aws/macie2/model/ListResourceProfileDetectionsRequest.h>
#include <aws/macie2/model/ListResourceProfileDetectionsResult.h>
#include <aws/macie2/model/ListSensitivityInspectionTemplatesRequest.h>
#include <aws/macie2/model/ListSensitivityInspectionTemplatesResult.h>
#include <aws/macie2/model/ListTagsForResourceRequest.h>
#include <aws/macie2/model/ListTagsForResourceResult.h>
#include <aws/macie2/model/MacieStatus.h>
#include <aws/macie2/model/ManagedDataIdentifierSelector.h>
#include <aws/macie2/model/ManagedDataIdentifierSummary.h>
#include <aws/macie2/model/MatchingBucket.h>
#include <aws/macie2/model/MatchingResource.h>
#include <aws/macie2/model/Member.h>
#include <aws/macie2/model/MonthlySchedule.h>
#include <aws/macie2/model/ObjectCountByEncryptionType.h>
#include <aws/macie2/model/ObjectLevelStatistics.h>
#include <aws/macie2/model/Occurrences.h>
#include <aws/macie2/model/OrderBy.h>
#include <aws/macie2/model/OriginType.h>
#include <aws/macie2/model/Page.h>
#include <aws/macie2/model/PolicyDetails.h>
#include <aws/macie2/model/PutClassificationExportConfigurationRequest.h>
#include <aws/macie2/model/PutClassificationExportConfigurationResult.h>
#include <aws/macie2/model/PutFindingsPublicationConfigurationRequest.h>
#include <aws/macie2/model/PutFindingsPublicationConfigurationResult.h>
#include <aws/macie2/model/Range.h>
#include <aws/macie2/model/Record.h>
#include <aws/macie2/model/RelationshipStatus.h>
#include <aws/macie2/model/ReplicationDetails.h>
#include <aws/macie2/model/ResourceProfileArtifact.h>
#include <aws/macie2/model/ResourceStatistics.h>
#include <aws/macie2/model/ResourcesAffected.h>
#include <aws/macie2/model/RetrievalConfiguration.h>
#include <aws/macie2/model/RetrievalMode.h>
#include <aws/macie2/model/RevealConfiguration.h>
#include <aws/macie2/model/RevealRequestStatus.h>
#include <aws/macie2/model/RevealStatus.h>
#include <aws/macie2/model/S3Bucket.h>
#include <aws/macie2/model/S3BucketCriteriaForJob.h>
#include <aws/macie2/model/S3BucketDefinitionForJob.h>
#include <aws/macie2/model/S3BucketOwner.h>
#include <aws/macie2/model/S3ClassificationScope.h>
#include <aws/macie2/model/S3ClassificationScopeExclusion.h>
#include <aws/macie2/model/S3ClassificationScopeExclusionUpdate.h>
#include <aws/macie2/model/S3ClassificationScopeUpdate.h>
#include <aws/macie2/model/S3Destination.h>
#include <aws/macie2/model/S3JobDefinition.h>
#include <aws/macie2/model/S3Object.h>
#include <aws/macie2/model/S3WordsList.h>
#include <aws/macie2/model/ScopeFilterKey.h>
#include <aws/macie2/model/Scoping.h>
#include <aws/macie2/model/SearchResourcesBucketCriteria.h>
#include <aws/macie2/model/SearchResourcesComparator.h>
#include <aws/macie2/model/SearchResourcesCriteria.h>
#include <aws/macie2/model/SearchResourcesCriteriaBlock.h>
#include <aws/macie2/model/SearchResourcesRequest.h>
#include <aws/macie2/model/SearchResourcesResult.h>
#include <aws/macie2/model/SearchResourcesSimpleCriterion.h>
#include <aws/macie2/model/SearchResourcesSimpleCriterionKey.h>
#include <aws/macie2/model/SearchResourcesSortAttributeName.h>
#include <aws/macie2/model/SearchResourcesSortCriteria.h>
#include <aws/macie2/model/SearchResourcesTagCriterion.h>
#include <aws/macie2/model/SearchResourcesTagCriterionPair.h>
#include <aws/macie2/model/SecurityHubConfiguration.h>
#include <aws/macie2/model/SensitiveDataItem.h>
#include <aws/macie2/model/SensitiveDataItemCategory.h>
#include <aws/macie2/model/SensitivityAggregations.h>
#include <aws/macie2/model/SensitivityInspectionTemplateExcludes.h>
#include <aws/macie2/model/SensitivityInspectionTemplateIncludes.h>
#include <aws/macie2/model/SensitivityInspectionTemplatesEntry.h>
#include <aws/macie2/model/ServerSideEncryption.h>
#include <aws/macie2/model/ServiceLimit.h>
#include <aws/macie2/model/SessionContext.h>
#include <aws/macie2/model/SessionContextAttributes.h>
#include <aws/macie2/model/SessionIssuer.h>
#include <aws/macie2/model/Severity.h>
#include <aws/macie2/model/SeverityDescription.h>
#include <aws/macie2/model/SeverityLevel.h>
#include <aws/macie2/model/SharedAccess.h>
#include <aws/macie2/model/SimpleCriterionForJob.h>
#include <aws/macie2/model/SimpleCriterionKeyForJob.h>
#include <aws/macie2/model/SimpleScopeTerm.h>
#include <aws/macie2/model/SortCriteria.h>
#include <aws/macie2/model/Statistics.h>
#include <aws/macie2/model/StorageClass.h>
#include <aws/macie2/model/SuppressDataIdentifier.h>
#include <aws/macie2/model/TagCriterionForJob.h>
#include <aws/macie2/model/TagCriterionPairForJob.h>
#include <aws/macie2/model/TagResourceRequest.h>
#include <aws/macie2/model/TagResourceResult.h>
#include <aws/macie2/model/TagScopeTerm.h>
#include <aws/macie2/model/TagTarget.h>
#include <aws/macie2/model/TagValuePair.h>
#include <aws/macie2/model/TestCustomDataIdentifierRequest.h>
#include <aws/macie2/model/TestCustomDataIdentifierResult.h>
#include <aws/macie2/model/TimeRange.h>
#include <aws/macie2/model/Type.h>
#include <aws/macie2/model/UnavailabilityReasonCode.h>
#include <aws/macie2/model/Unit.h>
#include <aws/macie2/model/UnprocessedAccount.h>
#include <aws/macie2/model/UntagResourceRequest.h>
#include <aws/macie2/model/UntagResourceResult.h>
#include <aws/macie2/model/UpdateAllowListRequest.h>
#include <aws/macie2/model/UpdateAllowListResult.h>
#include <aws/macie2/model/UpdateAutomatedDiscoveryConfigurationRequest.h>
#include <aws/macie2/model/UpdateAutomatedDiscoveryConfigurationResult.h>
#include <aws/macie2/model/UpdateClassificationJobRequest.h>
#include <aws/macie2/model/UpdateClassificationJobResult.h>
#include <aws/macie2/model/UpdateClassificationScopeRequest.h>
#include <aws/macie2/model/UpdateClassificationScopeResult.h>
#include <aws/macie2/model/UpdateFindingsFilterRequest.h>
#include <aws/macie2/model/UpdateFindingsFilterResult.h>
#include <aws/macie2/model/UpdateMacieSessionRequest.h>
#include <aws/macie2/model/UpdateMacieSessionResult.h>
#include <aws/macie2/model/UpdateMemberSessionRequest.h>
#include <aws/macie2/model/UpdateMemberSessionResult.h>
#include <aws/macie2/model/UpdateOrganizationConfigurationRequest.h>
#include <aws/macie2/model/UpdateOrganizationConfigurationResult.h>
#include <aws/macie2/model/UpdateResourceProfileDetectionsRequest.h>
#include <aws/macie2/model/UpdateResourceProfileDetectionsResult.h>
#include <aws/macie2/model/UpdateResourceProfileRequest.h>
#include <aws/macie2/model/UpdateResourceProfileResult.h>
#include <aws/macie2/model/UpdateRetrievalConfiguration.h>
#include <aws/macie2/model/UpdateRevealConfigurationRequest.h>
#include <aws/macie2/model/UpdateRevealConfigurationResult.h>
#include <aws/macie2/model/UpdateSensitivityInspectionTemplateRequest.h>
#include <aws/macie2/model/UpdateSensitivityInspectionTemplateResult.h>
#include <aws/macie2/model/UsageByAccount.h>
#include <aws/macie2/model/UsageRecord.h>
#include <aws/macie2/model/UsageStatisticsFilter.h>
#include <aws/macie2/model/UsageStatisticsFilterComparator.h>
#include <aws/macie2/model/UsageStatisticsFilterKey.h>
#include <aws/macie2/model/UsageStatisticsSortBy.h>
#include <aws/macie2/model/UsageStatisticsSortKey.h>
#include <aws/macie2/model/UsageTotal.h>
#include <aws/macie2/model/UsageType.h>
#include <aws/macie2/model/UserIdentity.h>
#include <aws/macie2/model/UserIdentityRoot.h>
#include <aws/macie2/model/UserIdentityType.h>
#include <aws/macie2/model/UserPausedDetails.h>
#include <aws/macie2/model/WeeklySchedule.h>

using Macie2IncludeTest = ::testing::Test;

TEST_F(Macie2IncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::Macie2::Macie2Client>("Macie2IncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
