/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/mailmanager/MailManagerClient.h>
#include <aws/mailmanager/MailManagerEndpointProvider.h>
#include <aws/mailmanager/MailManagerEndpointRules.h>
#include <aws/mailmanager/MailManagerErrorMarshaller.h>
#include <aws/mailmanager/MailManagerErrors.h>
#include <aws/mailmanager/MailManagerRequest.h>
#include <aws/mailmanager/MailManagerServiceClientModel.h>
#include <aws/mailmanager/MailManager_EXPORTS.h>
#include <aws/mailmanager/model/AcceptAction.h>
#include <aws/mailmanager/model/ActionFailurePolicy.h>
#include <aws/mailmanager/model/AddHeaderAction.h>
#include <aws/mailmanager/model/AddonInstance.h>
#include <aws/mailmanager/model/AddonSubscription.h>
#include <aws/mailmanager/model/AddressFilter.h>
#include <aws/mailmanager/model/AddressList.h>
#include <aws/mailmanager/model/Analysis.h>
#include <aws/mailmanager/model/Archive.h>
#include <aws/mailmanager/model/ArchiveAction.h>
#include <aws/mailmanager/model/ArchiveBooleanEmailAttribute.h>
#include <aws/mailmanager/model/ArchiveBooleanExpression.h>
#include <aws/mailmanager/model/ArchiveBooleanOperator.h>
#include <aws/mailmanager/model/ArchiveBooleanToEvaluate.h>
#include <aws/mailmanager/model/ArchiveFilterCondition.h>
#include <aws/mailmanager/model/ArchiveFilters.h>
#include <aws/mailmanager/model/ArchiveRetention.h>
#include <aws/mailmanager/model/ArchiveState.h>
#include <aws/mailmanager/model/ArchiveStringEmailAttribute.h>
#include <aws/mailmanager/model/ArchiveStringExpression.h>
#include <aws/mailmanager/model/ArchiveStringOperator.h>
#include <aws/mailmanager/model/ArchiveStringToEvaluate.h>
#include <aws/mailmanager/model/CreateAddonInstanceRequest.h>
#include <aws/mailmanager/model/CreateAddonInstanceResult.h>
#include <aws/mailmanager/model/CreateAddonSubscriptionRequest.h>
#include <aws/mailmanager/model/CreateAddonSubscriptionResult.h>
#include <aws/mailmanager/model/CreateAddressListImportJobRequest.h>
#include <aws/mailmanager/model/CreateAddressListImportJobResult.h>
#include <aws/mailmanager/model/CreateAddressListRequest.h>
#include <aws/mailmanager/model/CreateAddressListResult.h>
#include <aws/mailmanager/model/CreateArchiveRequest.h>
#include <aws/mailmanager/model/CreateArchiveResult.h>
#include <aws/mailmanager/model/CreateIngressPointRequest.h>
#include <aws/mailmanager/model/CreateIngressPointResult.h>
#include <aws/mailmanager/model/CreateRelayRequest.h>
#include <aws/mailmanager/model/CreateRelayResult.h>
#include <aws/mailmanager/model/CreateRuleSetRequest.h>
#include <aws/mailmanager/model/CreateRuleSetResult.h>
#include <aws/mailmanager/model/CreateTrafficPolicyRequest.h>
#include <aws/mailmanager/model/CreateTrafficPolicyResult.h>
#include <aws/mailmanager/model/DeleteAddonInstanceRequest.h>
#include <aws/mailmanager/model/DeleteAddonInstanceResult.h>
#include <aws/mailmanager/model/DeleteAddonSubscriptionRequest.h>
#include <aws/mailmanager/model/DeleteAddonSubscriptionResult.h>
#include <aws/mailmanager/model/DeleteAddressListRequest.h>
#include <aws/mailmanager/model/DeleteAddressListResult.h>
#include <aws/mailmanager/model/DeleteArchiveRequest.h>
#include <aws/mailmanager/model/DeleteArchiveResult.h>
#include <aws/mailmanager/model/DeleteIngressPointRequest.h>
#include <aws/mailmanager/model/DeleteIngressPointResult.h>
#include <aws/mailmanager/model/DeleteRelayRequest.h>
#include <aws/mailmanager/model/DeleteRelayResult.h>
#include <aws/mailmanager/model/DeleteRuleSetRequest.h>
#include <aws/mailmanager/model/DeleteRuleSetResult.h>
#include <aws/mailmanager/model/DeleteTrafficPolicyRequest.h>
#include <aws/mailmanager/model/DeleteTrafficPolicyResult.h>
#include <aws/mailmanager/model/DeliverToMailboxAction.h>
#include <aws/mailmanager/model/DeliverToQBusinessAction.h>
#include <aws/mailmanager/model/DeregisterMemberFromAddressListRequest.h>
#include <aws/mailmanager/model/DeregisterMemberFromAddressListResult.h>
#include <aws/mailmanager/model/DropAction.h>
#include <aws/mailmanager/model/Envelope.h>
#include <aws/mailmanager/model/ExportDestinationConfiguration.h>
#include <aws/mailmanager/model/ExportState.h>
#include <aws/mailmanager/model/ExportStatus.h>
#include <aws/mailmanager/model/ExportSummary.h>
#include <aws/mailmanager/model/GetAddonInstanceRequest.h>
#include <aws/mailmanager/model/GetAddonInstanceResult.h>
#include <aws/mailmanager/model/GetAddonSubscriptionRequest.h>
#include <aws/mailmanager/model/GetAddonSubscriptionResult.h>
#include <aws/mailmanager/model/GetAddressListImportJobRequest.h>
#include <aws/mailmanager/model/GetAddressListImportJobResult.h>
#include <aws/mailmanager/model/GetAddressListRequest.h>
#include <aws/mailmanager/model/GetAddressListResult.h>
#include <aws/mailmanager/model/GetArchiveExportRequest.h>
#include <aws/mailmanager/model/GetArchiveExportResult.h>
#include <aws/mailmanager/model/GetArchiveMessageContentRequest.h>
#include <aws/mailmanager/model/GetArchiveMessageContentResult.h>
#include <aws/mailmanager/model/GetArchiveMessageRequest.h>
#include <aws/mailmanager/model/GetArchiveMessageResult.h>
#include <aws/mailmanager/model/GetArchiveRequest.h>
#include <aws/mailmanager/model/GetArchiveResult.h>
#include <aws/mailmanager/model/GetArchiveSearchRequest.h>
#include <aws/mailmanager/model/GetArchiveSearchResult.h>
#include <aws/mailmanager/model/GetArchiveSearchResultsRequest.h>
#include <aws/mailmanager/model/GetArchiveSearchResultsResult.h>
#include <aws/mailmanager/model/GetIngressPointRequest.h>
#include <aws/mailmanager/model/GetIngressPointResult.h>
#include <aws/mailmanager/model/GetMemberOfAddressListRequest.h>
#include <aws/mailmanager/model/GetMemberOfAddressListResult.h>
#include <aws/mailmanager/model/GetRelayRequest.h>
#include <aws/mailmanager/model/GetRelayResult.h>
#include <aws/mailmanager/model/GetRuleSetRequest.h>
#include <aws/mailmanager/model/GetRuleSetResult.h>
#include <aws/mailmanager/model/GetTrafficPolicyRequest.h>
#include <aws/mailmanager/model/GetTrafficPolicyResult.h>
#include <aws/mailmanager/model/ImportDataFormat.h>
#include <aws/mailmanager/model/ImportDataType.h>
#include <aws/mailmanager/model/ImportJob.h>
#include <aws/mailmanager/model/ImportJobStatus.h>
#include <aws/mailmanager/model/IngressAddressListEmailAttribute.h>
#include <aws/mailmanager/model/IngressAnalysis.h>
#include <aws/mailmanager/model/IngressBooleanExpression.h>
#include <aws/mailmanager/model/IngressBooleanOperator.h>
#include <aws/mailmanager/model/IngressBooleanToEvaluate.h>
#include <aws/mailmanager/model/IngressIpOperator.h>
#include <aws/mailmanager/model/IngressIpToEvaluate.h>
#include <aws/mailmanager/model/IngressIpv4Attribute.h>
#include <aws/mailmanager/model/IngressIpv4Expression.h>
#include <aws/mailmanager/model/IngressIpv6Attribute.h>
#include <aws/mailmanager/model/IngressIpv6Expression.h>
#include <aws/mailmanager/model/IngressIpv6ToEvaluate.h>
#include <aws/mailmanager/model/IngressIsInAddressList.h>
#include <aws/mailmanager/model/IngressPoint.h>
#include <aws/mailmanager/model/IngressPointAuthConfiguration.h>
#include <aws/mailmanager/model/IngressPointConfiguration.h>
#include <aws/mailmanager/model/IngressPointPasswordConfiguration.h>
#include <aws/mailmanager/model/IngressPointStatus.h>
#include <aws/mailmanager/model/IngressPointStatusToUpdate.h>
#include <aws/mailmanager/model/IngressPointType.h>
#include <aws/mailmanager/model/IngressStringEmailAttribute.h>
#include <aws/mailmanager/model/IngressStringExpression.h>
#include <aws/mailmanager/model/IngressStringOperator.h>
#include <aws/mailmanager/model/IngressStringToEvaluate.h>
#include <aws/mailmanager/model/IngressTlsAttribute.h>
#include <aws/mailmanager/model/IngressTlsProtocolAttribute.h>
#include <aws/mailmanager/model/IngressTlsProtocolExpression.h>
#include <aws/mailmanager/model/IngressTlsProtocolOperator.h>
#include <aws/mailmanager/model/IngressTlsProtocolToEvaluate.h>
#include <aws/mailmanager/model/IpType.h>
#include <aws/mailmanager/model/ListAddonInstancesRequest.h>
#include <aws/mailmanager/model/ListAddonInstancesResult.h>
#include <aws/mailmanager/model/ListAddonSubscriptionsRequest.h>
#include <aws/mailmanager/model/ListAddonSubscriptionsResult.h>
#include <aws/mailmanager/model/ListAddressListImportJobsRequest.h>
#include <aws/mailmanager/model/ListAddressListImportJobsResult.h>
#include <aws/mailmanager/model/ListAddressListsRequest.h>
#include <aws/mailmanager/model/ListAddressListsResult.h>
#include <aws/mailmanager/model/ListArchiveExportsRequest.h>
#include <aws/mailmanager/model/ListArchiveExportsResult.h>
#include <aws/mailmanager/model/ListArchiveSearchesRequest.h>
#include <aws/mailmanager/model/ListArchiveSearchesResult.h>
#include <aws/mailmanager/model/ListArchivesRequest.h>
#include <aws/mailmanager/model/ListArchivesResult.h>
#include <aws/mailmanager/model/ListIngressPointsRequest.h>
#include <aws/mailmanager/model/ListIngressPointsResult.h>
#include <aws/mailmanager/model/ListMembersOfAddressListRequest.h>
#include <aws/mailmanager/model/ListMembersOfAddressListResult.h>
#include <aws/mailmanager/model/ListRelaysRequest.h>
#include <aws/mailmanager/model/ListRelaysResult.h>
#include <aws/mailmanager/model/ListRuleSetsRequest.h>
#include <aws/mailmanager/model/ListRuleSetsResult.h>
#include <aws/mailmanager/model/ListTagsForResourceRequest.h>
#include <aws/mailmanager/model/ListTagsForResourceResult.h>
#include <aws/mailmanager/model/ListTrafficPoliciesRequest.h>
#include <aws/mailmanager/model/ListTrafficPoliciesResult.h>
#include <aws/mailmanager/model/MailFrom.h>
#include <aws/mailmanager/model/MessageBody.h>
#include <aws/mailmanager/model/Metadata.h>
#include <aws/mailmanager/model/NetworkConfiguration.h>
#include <aws/mailmanager/model/NoAuthentication.h>
#include <aws/mailmanager/model/PolicyCondition.h>
#include <aws/mailmanager/model/PolicyStatement.h>
#include <aws/mailmanager/model/PrivateNetworkConfiguration.h>
#include <aws/mailmanager/model/PublicNetworkConfiguration.h>
#include <aws/mailmanager/model/RegisterMemberToAddressListRequest.h>
#include <aws/mailmanager/model/RegisterMemberToAddressListResult.h>
#include <aws/mailmanager/model/Relay.h>
#include <aws/mailmanager/model/RelayAction.h>
#include <aws/mailmanager/model/RelayAuthentication.h>
#include <aws/mailmanager/model/ReplaceRecipientAction.h>
#include <aws/mailmanager/model/RetentionPeriod.h>
#include <aws/mailmanager/model/Row.h>
#include <aws/mailmanager/model/Rule.h>
#include <aws/mailmanager/model/RuleAction.h>
#include <aws/mailmanager/model/RuleAddressListEmailAttribute.h>
#include <aws/mailmanager/model/RuleBooleanEmailAttribute.h>
#include <aws/mailmanager/model/RuleBooleanExpression.h>
#include <aws/mailmanager/model/RuleBooleanOperator.h>
#include <aws/mailmanager/model/RuleBooleanToEvaluate.h>
#include <aws/mailmanager/model/RuleCondition.h>
#include <aws/mailmanager/model/RuleDmarcExpression.h>
#include <aws/mailmanager/model/RuleDmarcOperator.h>
#include <aws/mailmanager/model/RuleDmarcPolicy.h>
#include <aws/mailmanager/model/RuleIpEmailAttribute.h>
#include <aws/mailmanager/model/RuleIpExpression.h>
#include <aws/mailmanager/model/RuleIpOperator.h>
#include <aws/mailmanager/model/RuleIpToEvaluate.h>
#include <aws/mailmanager/model/RuleIsInAddressList.h>
#include <aws/mailmanager/model/RuleNumberEmailAttribute.h>
#include <aws/mailmanager/model/RuleNumberExpression.h>
#include <aws/mailmanager/model/RuleNumberOperator.h>
#include <aws/mailmanager/model/RuleNumberToEvaluate.h>
#include <aws/mailmanager/model/RuleSet.h>
#include <aws/mailmanager/model/RuleStringEmailAttribute.h>
#include <aws/mailmanager/model/RuleStringExpression.h>
#include <aws/mailmanager/model/RuleStringOperator.h>
#include <aws/mailmanager/model/RuleStringToEvaluate.h>
#include <aws/mailmanager/model/RuleVerdict.h>
#include <aws/mailmanager/model/RuleVerdictAttribute.h>
#include <aws/mailmanager/model/RuleVerdictExpression.h>
#include <aws/mailmanager/model/RuleVerdictOperator.h>
#include <aws/mailmanager/model/RuleVerdictToEvaluate.h>
#include <aws/mailmanager/model/S3Action.h>
#include <aws/mailmanager/model/S3ExportDestinationConfiguration.h>
#include <aws/mailmanager/model/SavedAddress.h>
#include <aws/mailmanager/model/SearchState.h>
#include <aws/mailmanager/model/SearchStatus.h>
#include <aws/mailmanager/model/SearchSummary.h>
#include <aws/mailmanager/model/SendAction.h>
#include <aws/mailmanager/model/SnsAction.h>
#include <aws/mailmanager/model/SnsNotificationEncoding.h>
#include <aws/mailmanager/model/SnsNotificationPayloadType.h>
#include <aws/mailmanager/model/StartAddressListImportJobRequest.h>
#include <aws/mailmanager/model/StartAddressListImportJobResult.h>
#include <aws/mailmanager/model/StartArchiveExportRequest.h>
#include <aws/mailmanager/model/StartArchiveExportResult.h>
#include <aws/mailmanager/model/StartArchiveSearchRequest.h>
#include <aws/mailmanager/model/StartArchiveSearchResult.h>
#include <aws/mailmanager/model/StopAddressListImportJobRequest.h>
#include <aws/mailmanager/model/StopAddressListImportJobResult.h>
#include <aws/mailmanager/model/StopArchiveExportRequest.h>
#include <aws/mailmanager/model/StopArchiveExportResult.h>
#include <aws/mailmanager/model/StopArchiveSearchRequest.h>
#include <aws/mailmanager/model/StopArchiveSearchResult.h>
#include <aws/mailmanager/model/Tag.h>
#include <aws/mailmanager/model/TagResourceRequest.h>
#include <aws/mailmanager/model/TagResourceResult.h>
#include <aws/mailmanager/model/TrafficPolicy.h>
#include <aws/mailmanager/model/UntagResourceRequest.h>
#include <aws/mailmanager/model/UntagResourceResult.h>
#include <aws/mailmanager/model/UpdateArchiveRequest.h>
#include <aws/mailmanager/model/UpdateArchiveResult.h>
#include <aws/mailmanager/model/UpdateIngressPointRequest.h>
#include <aws/mailmanager/model/UpdateIngressPointResult.h>
#include <aws/mailmanager/model/UpdateRelayRequest.h>
#include <aws/mailmanager/model/UpdateRelayResult.h>
#include <aws/mailmanager/model/UpdateRuleSetRequest.h>
#include <aws/mailmanager/model/UpdateRuleSetResult.h>
#include <aws/mailmanager/model/UpdateTrafficPolicyRequest.h>
#include <aws/mailmanager/model/UpdateTrafficPolicyResult.h>

using MailManagerIncludeTest = ::testing::Test;

TEST_F(MailManagerIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::MailManager::MailManagerClient>("MailManagerIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
