/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/mediaconnect/MediaConnectClient.h>
#include <aws/mediaconnect/MediaConnectEndpointProvider.h>
#include <aws/mediaconnect/MediaConnectEndpointRules.h>
#include <aws/mediaconnect/MediaConnectErrorMarshaller.h>
#include <aws/mediaconnect/MediaConnectErrors.h>
#include <aws/mediaconnect/MediaConnectRequest.h>
#include <aws/mediaconnect/MediaConnectServiceClientModel.h>
#include <aws/mediaconnect/MediaConnect_EXPORTS.h>
#include <aws/mediaconnect/model/AddBridgeFlowSourceRequest.h>
#include <aws/mediaconnect/model/AddBridgeNetworkOutputRequest.h>
#include <aws/mediaconnect/model/AddBridgeNetworkSourceRequest.h>
#include <aws/mediaconnect/model/AddBridgeOutputRequest.h>
#include <aws/mediaconnect/model/AddBridgeOutputsRequest.h>
#include <aws/mediaconnect/model/AddBridgeOutputsResult.h>
#include <aws/mediaconnect/model/AddBridgeSourceRequest.h>
#include <aws/mediaconnect/model/AddBridgeSourcesRequest.h>
#include <aws/mediaconnect/model/AddBridgeSourcesResult.h>
#include <aws/mediaconnect/model/AddEgressGatewayBridgeRequest.h>
#include <aws/mediaconnect/model/AddFlowMediaStreamsRequest.h>
#include <aws/mediaconnect/model/AddFlowMediaStreamsResult.h>
#include <aws/mediaconnect/model/AddFlowOutputsRequest.h>
#include <aws/mediaconnect/model/AddFlowOutputsResult.h>
#include <aws/mediaconnect/model/AddFlowSourcesRequest.h>
#include <aws/mediaconnect/model/AddFlowSourcesResult.h>
#include <aws/mediaconnect/model/AddFlowVpcInterfacesRequest.h>
#include <aws/mediaconnect/model/AddFlowVpcInterfacesResult.h>
#include <aws/mediaconnect/model/AddIngressGatewayBridgeRequest.h>
#include <aws/mediaconnect/model/AddMaintenance.h>
#include <aws/mediaconnect/model/AddMediaStreamRequest.h>
#include <aws/mediaconnect/model/AddOutputRequest.h>
#include <aws/mediaconnect/model/Algorithm.h>
#include <aws/mediaconnect/model/AudioMonitoringSetting.h>
#include <aws/mediaconnect/model/BlackFrames.h>
#include <aws/mediaconnect/model/Bridge.h>
#include <aws/mediaconnect/model/BridgeFlowOutput.h>
#include <aws/mediaconnect/model/BridgeFlowSource.h>
#include <aws/mediaconnect/model/BridgeNetworkOutput.h>
#include <aws/mediaconnect/model/BridgeNetworkSource.h>
#include <aws/mediaconnect/model/BridgeOutput.h>
#include <aws/mediaconnect/model/BridgePlacement.h>
#include <aws/mediaconnect/model/BridgeSource.h>
#include <aws/mediaconnect/model/BridgeState.h>
#include <aws/mediaconnect/model/Colorimetry.h>
#include <aws/mediaconnect/model/ConnectionStatus.h>
#include <aws/mediaconnect/model/ContentQualityAnalysisState.h>
#include <aws/mediaconnect/model/CreateBridgeRequest.h>
#include <aws/mediaconnect/model/CreateBridgeResult.h>
#include <aws/mediaconnect/model/CreateFlowRequest.h>
#include <aws/mediaconnect/model/CreateFlowResult.h>
#include <aws/mediaconnect/model/CreateGatewayRequest.h>
#include <aws/mediaconnect/model/CreateGatewayResult.h>
#include <aws/mediaconnect/model/DeleteBridgeRequest.h>
#include <aws/mediaconnect/model/DeleteBridgeResult.h>
#include <aws/mediaconnect/model/DeleteFlowRequest.h>
#include <aws/mediaconnect/model/DeleteFlowResult.h>
#include <aws/mediaconnect/model/DeleteGatewayRequest.h>
#include <aws/mediaconnect/model/DeleteGatewayResult.h>
#include <aws/mediaconnect/model/DeregisterGatewayInstanceRequest.h>
#include <aws/mediaconnect/model/DeregisterGatewayInstanceResult.h>
#include <aws/mediaconnect/model/DescribeBridgeRequest.h>
#include <aws/mediaconnect/model/DescribeBridgeResult.h>
#include <aws/mediaconnect/model/DescribeFlowRequest.h>
#include <aws/mediaconnect/model/DescribeFlowResult.h>
#include <aws/mediaconnect/model/DescribeFlowSourceMetadataRequest.h>
#include <aws/mediaconnect/model/DescribeFlowSourceMetadataResult.h>
#include <aws/mediaconnect/model/DescribeFlowSourceThumbnailRequest.h>
#include <aws/mediaconnect/model/DescribeFlowSourceThumbnailResult.h>
#include <aws/mediaconnect/model/DescribeGatewayInstanceRequest.h>
#include <aws/mediaconnect/model/DescribeGatewayInstanceResult.h>
#include <aws/mediaconnect/model/DescribeGatewayRequest.h>
#include <aws/mediaconnect/model/DescribeGatewayResult.h>
#include <aws/mediaconnect/model/DescribeOfferingRequest.h>
#include <aws/mediaconnect/model/DescribeOfferingResult.h>
#include <aws/mediaconnect/model/DescribeReservationRequest.h>
#include <aws/mediaconnect/model/DescribeReservationResult.h>
#include <aws/mediaconnect/model/DesiredState.h>
#include <aws/mediaconnect/model/DestinationConfiguration.h>
#include <aws/mediaconnect/model/DestinationConfigurationRequest.h>
#include <aws/mediaconnect/model/DurationUnits.h>
#include <aws/mediaconnect/model/EgressGatewayBridge.h>
#include <aws/mediaconnect/model/EncoderProfile.h>
#include <aws/mediaconnect/model/EncodingName.h>
#include <aws/mediaconnect/model/EncodingParameters.h>
#include <aws/mediaconnect/model/EncodingParametersRequest.h>
#include <aws/mediaconnect/model/Encryption.h>
#include <aws/mediaconnect/model/Entitlement.h>
#include <aws/mediaconnect/model/EntitlementStatus.h>
#include <aws/mediaconnect/model/FailoverConfig.h>
#include <aws/mediaconnect/model/FailoverMode.h>
#include <aws/mediaconnect/model/Flow.h>
#include <aws/mediaconnect/model/FlowSize.h>
#include <aws/mediaconnect/model/Fmtp.h>
#include <aws/mediaconnect/model/FmtpRequest.h>
#include <aws/mediaconnect/model/FrameResolution.h>
#include <aws/mediaconnect/model/FrozenFrames.h>
#include <aws/mediaconnect/model/Gateway.h>
#include <aws/mediaconnect/model/GatewayBridgeSource.h>
#include <aws/mediaconnect/model/GatewayInstance.h>
#include <aws/mediaconnect/model/GatewayNetwork.h>
#include <aws/mediaconnect/model/GatewayState.h>
#include <aws/mediaconnect/model/GrantEntitlementRequest.h>
#include <aws/mediaconnect/model/GrantFlowEntitlementsRequest.h>
#include <aws/mediaconnect/model/GrantFlowEntitlementsResult.h>
#include <aws/mediaconnect/model/IngressGatewayBridge.h>
#include <aws/mediaconnect/model/InputConfiguration.h>
#include <aws/mediaconnect/model/InputConfigurationRequest.h>
#include <aws/mediaconnect/model/InstanceState.h>
#include <aws/mediaconnect/model/Interface.h>
#include <aws/mediaconnect/model/InterfaceRequest.h>
#include <aws/mediaconnect/model/KeyType.h>
#include <aws/mediaconnect/model/ListBridgesRequest.h>
#include <aws/mediaconnect/model/ListBridgesResult.h>
#include <aws/mediaconnect/model/ListEntitlementsRequest.h>
#include <aws/mediaconnect/model/ListEntitlementsResult.h>
#include <aws/mediaconnect/model/ListFlowsRequest.h>
#include <aws/mediaconnect/model/ListFlowsResult.h>
#include <aws/mediaconnect/model/ListGatewayInstancesRequest.h>
#include <aws/mediaconnect/model/ListGatewayInstancesResult.h>
#include <aws/mediaconnect/model/ListGatewaysRequest.h>
#include <aws/mediaconnect/model/ListGatewaysResult.h>
#include <aws/mediaconnect/model/ListOfferingsRequest.h>
#include <aws/mediaconnect/model/ListOfferingsResult.h>
#include <aws/mediaconnect/model/ListReservationsRequest.h>
#include <aws/mediaconnect/model/ListReservationsResult.h>
#include <aws/mediaconnect/model/ListTagsForResourceRequest.h>
#include <aws/mediaconnect/model/ListTagsForResourceResult.h>
#include <aws/mediaconnect/model/ListedBridge.h>
#include <aws/mediaconnect/model/ListedEntitlement.h>
#include <aws/mediaconnect/model/ListedFlow.h>
#include <aws/mediaconnect/model/ListedGateway.h>
#include <aws/mediaconnect/model/ListedGatewayInstance.h>
#include <aws/mediaconnect/model/Maintenance.h>
#include <aws/mediaconnect/model/MaintenanceDay.h>
#include <aws/mediaconnect/model/MediaStream.h>
#include <aws/mediaconnect/model/MediaStreamAttributes.h>
#include <aws/mediaconnect/model/MediaStreamAttributesRequest.h>
#include <aws/mediaconnect/model/MediaStreamOutputConfiguration.h>
#include <aws/mediaconnect/model/MediaStreamOutputConfigurationRequest.h>
#include <aws/mediaconnect/model/MediaStreamSourceConfiguration.h>
#include <aws/mediaconnect/model/MediaStreamSourceConfigurationRequest.h>
#include <aws/mediaconnect/model/MediaStreamType.h>
#include <aws/mediaconnect/model/MessageDetail.h>
#include <aws/mediaconnect/model/Messages.h>
#include <aws/mediaconnect/model/MonitoringConfig.h>
#include <aws/mediaconnect/model/MulticastSourceSettings.h>
#include <aws/mediaconnect/model/NdiConfig.h>
#include <aws/mediaconnect/model/NdiDiscoveryServerConfig.h>
#include <aws/mediaconnect/model/NdiState.h>
#include <aws/mediaconnect/model/NetworkInterfaceType.h>
#include <aws/mediaconnect/model/Offering.h>
#include <aws/mediaconnect/model/Output.h>
#include <aws/mediaconnect/model/OutputStatus.h>
#include <aws/mediaconnect/model/PriceUnits.h>
#include <aws/mediaconnect/model/Protocol.h>
#include <aws/mediaconnect/model/PurchaseOfferingRequest.h>
#include <aws/mediaconnect/model/PurchaseOfferingResult.h>
#include <aws/mediaconnect/model/Range.h>
#include <aws/mediaconnect/model/RemoveBridgeOutputRequest.h>
#include <aws/mediaconnect/model/RemoveBridgeOutputResult.h>
#include <aws/mediaconnect/model/RemoveBridgeSourceRequest.h>
#include <aws/mediaconnect/model/RemoveBridgeSourceResult.h>
#include <aws/mediaconnect/model/RemoveFlowMediaStreamRequest.h>
#include <aws/mediaconnect/model/RemoveFlowMediaStreamResult.h>
#include <aws/mediaconnect/model/RemoveFlowOutputRequest.h>
#include <aws/mediaconnect/model/RemoveFlowOutputResult.h>
#include <aws/mediaconnect/model/RemoveFlowSourceRequest.h>
#include <aws/mediaconnect/model/RemoveFlowSourceResult.h>
#include <aws/mediaconnect/model/RemoveFlowVpcInterfaceRequest.h>
#include <aws/mediaconnect/model/RemoveFlowVpcInterfaceResult.h>
#include <aws/mediaconnect/model/Reservation.h>
#include <aws/mediaconnect/model/ReservationState.h>
#include <aws/mediaconnect/model/ResourceSpecification.h>
#include <aws/mediaconnect/model/ResourceType.h>
#include <aws/mediaconnect/model/RevokeFlowEntitlementRequest.h>
#include <aws/mediaconnect/model/RevokeFlowEntitlementResult.h>
#include <aws/mediaconnect/model/ScanMode.h>
#include <aws/mediaconnect/model/SetGatewayBridgeSourceRequest.h>
#include <aws/mediaconnect/model/SetSourceRequest.h>
#include <aws/mediaconnect/model/SilentAudio.h>
#include <aws/mediaconnect/model/Source.h>
#include <aws/mediaconnect/model/SourcePriority.h>
#include <aws/mediaconnect/model/SourceType.h>
#include <aws/mediaconnect/model/StartFlowRequest.h>
#include <aws/mediaconnect/model/StartFlowResult.h>
#include <aws/mediaconnect/model/State.h>
#include <aws/mediaconnect/model/Status.h>
#include <aws/mediaconnect/model/StopFlowRequest.h>
#include <aws/mediaconnect/model/StopFlowResult.h>
#include <aws/mediaconnect/model/TagResourceRequest.h>
#include <aws/mediaconnect/model/Tcs.h>
#include <aws/mediaconnect/model/ThumbnailDetails.h>
#include <aws/mediaconnect/model/ThumbnailState.h>
#include <aws/mediaconnect/model/Transport.h>
#include <aws/mediaconnect/model/TransportMediaInfo.h>
#include <aws/mediaconnect/model/TransportStream.h>
#include <aws/mediaconnect/model/TransportStreamProgram.h>
#include <aws/mediaconnect/model/UntagResourceRequest.h>
#include <aws/mediaconnect/model/UpdateBridgeFlowSourceRequest.h>
#include <aws/mediaconnect/model/UpdateBridgeNetworkOutputRequest.h>
#include <aws/mediaconnect/model/UpdateBridgeNetworkSourceRequest.h>
#include <aws/mediaconnect/model/UpdateBridgeOutputRequest.h>
#include <aws/mediaconnect/model/UpdateBridgeOutputResult.h>
#include <aws/mediaconnect/model/UpdateBridgeRequest.h>
#include <aws/mediaconnect/model/UpdateBridgeResult.h>
#include <aws/mediaconnect/model/UpdateBridgeSourceRequest.h>
#include <aws/mediaconnect/model/UpdateBridgeSourceResult.h>
#include <aws/mediaconnect/model/UpdateBridgeStateRequest.h>
#include <aws/mediaconnect/model/UpdateBridgeStateResult.h>
#include <aws/mediaconnect/model/UpdateEgressGatewayBridgeRequest.h>
#include <aws/mediaconnect/model/UpdateEncryption.h>
#include <aws/mediaconnect/model/UpdateFailoverConfig.h>
#include <aws/mediaconnect/model/UpdateFlowEntitlementRequest.h>
#include <aws/mediaconnect/model/UpdateFlowEntitlementResult.h>
#include <aws/mediaconnect/model/UpdateFlowMediaStreamRequest.h>
#include <aws/mediaconnect/model/UpdateFlowMediaStreamResult.h>
#include <aws/mediaconnect/model/UpdateFlowOutputRequest.h>
#include <aws/mediaconnect/model/UpdateFlowOutputResult.h>
#include <aws/mediaconnect/model/UpdateFlowRequest.h>
#include <aws/mediaconnect/model/UpdateFlowResult.h>
#include <aws/mediaconnect/model/UpdateFlowSourceRequest.h>
#include <aws/mediaconnect/model/UpdateFlowSourceResult.h>
#include <aws/mediaconnect/model/UpdateGatewayBridgeSourceRequest.h>
#include <aws/mediaconnect/model/UpdateGatewayInstanceRequest.h>
#include <aws/mediaconnect/model/UpdateGatewayInstanceResult.h>
#include <aws/mediaconnect/model/UpdateIngressGatewayBridgeRequest.h>
#include <aws/mediaconnect/model/UpdateMaintenance.h>
#include <aws/mediaconnect/model/VideoMonitoringSetting.h>
#include <aws/mediaconnect/model/VpcInterface.h>
#include <aws/mediaconnect/model/VpcInterfaceAttachment.h>
#include <aws/mediaconnect/model/VpcInterfaceRequest.h>

using MediaConnectIncludeTest = ::testing::Test;

TEST_F(MediaConnectIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::MediaConnect::MediaConnectClient>("MediaConnectIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
