/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/mediaconvert/MediaConvertClient.h>
#include <aws/mediaconvert/MediaConvertEndpointProvider.h>
#include <aws/mediaconvert/MediaConvertEndpointRules.h>
#include <aws/mediaconvert/MediaConvertErrorMarshaller.h>
#include <aws/mediaconvert/MediaConvertErrors.h>
#include <aws/mediaconvert/MediaConvertRequest.h>
#include <aws/mediaconvert/MediaConvertServiceClientModel.h>
#include <aws/mediaconvert/MediaConvert_EXPORTS.h>
#include <aws/mediaconvert/model/AacAudioDescriptionBroadcasterMix.h>
#include <aws/mediaconvert/model/AacCodecProfile.h>
#include <aws/mediaconvert/model/AacCodingMode.h>
#include <aws/mediaconvert/model/AacRateControlMode.h>
#include <aws/mediaconvert/model/AacRawFormat.h>
#include <aws/mediaconvert/model/AacSettings.h>
#include <aws/mediaconvert/model/AacSpecification.h>
#include <aws/mediaconvert/model/AacVbrQuality.h>
#include <aws/mediaconvert/model/Ac3BitstreamMode.h>
#include <aws/mediaconvert/model/Ac3CodingMode.h>
#include <aws/mediaconvert/model/Ac3DynamicRangeCompressionLine.h>
#include <aws/mediaconvert/model/Ac3DynamicRangeCompressionProfile.h>
#include <aws/mediaconvert/model/Ac3DynamicRangeCompressionRf.h>
#include <aws/mediaconvert/model/Ac3LfeFilter.h>
#include <aws/mediaconvert/model/Ac3MetadataControl.h>
#include <aws/mediaconvert/model/Ac3Settings.h>
#include <aws/mediaconvert/model/AccelerationMode.h>
#include <aws/mediaconvert/model/AccelerationSettings.h>
#include <aws/mediaconvert/model/AccelerationStatus.h>
#include <aws/mediaconvert/model/AdvancedInputFilter.h>
#include <aws/mediaconvert/model/AdvancedInputFilterAddTexture.h>
#include <aws/mediaconvert/model/AdvancedInputFilterSettings.h>
#include <aws/mediaconvert/model/AdvancedInputFilterSharpen.h>
#include <aws/mediaconvert/model/AfdSignaling.h>
#include <aws/mediaconvert/model/AiffSettings.h>
#include <aws/mediaconvert/model/AllowedRenditionSize.h>
#include <aws/mediaconvert/model/AlphaBehavior.h>
#include <aws/mediaconvert/model/AncillaryConvert608To708.h>
#include <aws/mediaconvert/model/AncillarySourceSettings.h>
#include <aws/mediaconvert/model/AncillaryTerminateCaptions.h>
#include <aws/mediaconvert/model/AntiAlias.h>
#include <aws/mediaconvert/model/AssociateCertificateRequest.h>
#include <aws/mediaconvert/model/AssociateCertificateResult.h>
#include <aws/mediaconvert/model/AudioChannelTag.h>
#include <aws/mediaconvert/model/AudioChannelTaggingSettings.h>
#include <aws/mediaconvert/model/AudioCodec.h>
#include <aws/mediaconvert/model/AudioCodecSettings.h>
#include <aws/mediaconvert/model/AudioDefaultSelection.h>
#include <aws/mediaconvert/model/AudioDescription.h>
#include <aws/mediaconvert/model/AudioDurationCorrection.h>
#include <aws/mediaconvert/model/AudioLanguageCodeControl.h>
#include <aws/mediaconvert/model/AudioNormalizationAlgorithm.h>
#include <aws/mediaconvert/model/AudioNormalizationAlgorithmControl.h>
#include <aws/mediaconvert/model/AudioNormalizationLoudnessLogging.h>
#include <aws/mediaconvert/model/AudioNormalizationPeakCalculation.h>
#include <aws/mediaconvert/model/AudioNormalizationSettings.h>
#include <aws/mediaconvert/model/AudioProperties.h>
#include <aws/mediaconvert/model/AudioSelector.h>
#include <aws/mediaconvert/model/AudioSelectorGroup.h>
#include <aws/mediaconvert/model/AudioSelectorType.h>
#include <aws/mediaconvert/model/AudioTypeControl.h>
#include <aws/mediaconvert/model/AutomatedAbrRule.h>
#include <aws/mediaconvert/model/AutomatedAbrSettings.h>
#include <aws/mediaconvert/model/AutomatedEncodingSettings.h>
#include <aws/mediaconvert/model/Av1AdaptiveQuantization.h>
#include <aws/mediaconvert/model/Av1BitDepth.h>
#include <aws/mediaconvert/model/Av1FilmGrainSynthesis.h>
#include <aws/mediaconvert/model/Av1FramerateControl.h>
#include <aws/mediaconvert/model/Av1FramerateConversionAlgorithm.h>
#include <aws/mediaconvert/model/Av1QvbrSettings.h>
#include <aws/mediaconvert/model/Av1RateControlMode.h>
#include <aws/mediaconvert/model/Av1Settings.h>
#include <aws/mediaconvert/model/Av1SpatialAdaptiveQuantization.h>
#include <aws/mediaconvert/model/AvailBlanking.h>
#include <aws/mediaconvert/model/AvcIntraClass.h>
#include <aws/mediaconvert/model/AvcIntraFramerateControl.h>
#include <aws/mediaconvert/model/AvcIntraFramerateConversionAlgorithm.h>
#include <aws/mediaconvert/model/AvcIntraInterlaceMode.h>
#include <aws/mediaconvert/model/AvcIntraScanTypeConversionMode.h>
#include <aws/mediaconvert/model/AvcIntraSettings.h>
#include <aws/mediaconvert/model/AvcIntraSlowPal.h>
#include <aws/mediaconvert/model/AvcIntraTelecine.h>
#include <aws/mediaconvert/model/AvcIntraUhdQualityTuningLevel.h>
#include <aws/mediaconvert/model/AvcIntraUhdSettings.h>
#include <aws/mediaconvert/model/BandwidthReductionFilter.h>
#include <aws/mediaconvert/model/BandwidthReductionFilterSharpening.h>
#include <aws/mediaconvert/model/BandwidthReductionFilterStrength.h>
#include <aws/mediaconvert/model/BillingTagsSource.h>
#include <aws/mediaconvert/model/BurnInSubtitleStylePassthrough.h>
#include <aws/mediaconvert/model/BurninDestinationSettings.h>
#include <aws/mediaconvert/model/BurninSubtitleAlignment.h>
#include <aws/mediaconvert/model/BurninSubtitleApplyFontColor.h>
#include <aws/mediaconvert/model/BurninSubtitleBackgroundColor.h>
#include <aws/mediaconvert/model/BurninSubtitleFallbackFont.h>
#include <aws/mediaconvert/model/BurninSubtitleFontColor.h>
#include <aws/mediaconvert/model/BurninSubtitleOutlineColor.h>
#include <aws/mediaconvert/model/BurninSubtitleShadowColor.h>
#include <aws/mediaconvert/model/BurninSubtitleTeletextSpacing.h>
#include <aws/mediaconvert/model/CancelJobRequest.h>
#include <aws/mediaconvert/model/CancelJobResult.h>
#include <aws/mediaconvert/model/CaptionDescription.h>
#include <aws/mediaconvert/model/CaptionDescriptionPreset.h>
#include <aws/mediaconvert/model/CaptionDestinationSettings.h>
#include <aws/mediaconvert/model/CaptionDestinationType.h>
#include <aws/mediaconvert/model/CaptionSelector.h>
#include <aws/mediaconvert/model/CaptionSourceByteRateLimit.h>
#include <aws/mediaconvert/model/CaptionSourceConvertPaintOnToPopOn.h>
#include <aws/mediaconvert/model/CaptionSourceFramerate.h>
#include <aws/mediaconvert/model/CaptionSourceSettings.h>
#include <aws/mediaconvert/model/CaptionSourceType.h>
#include <aws/mediaconvert/model/CaptionSourceUpconvertSTLToTeletext.h>
#include <aws/mediaconvert/model/ChannelMapping.h>
#include <aws/mediaconvert/model/ChromaPositionMode.h>
#include <aws/mediaconvert/model/ClipLimits.h>
#include <aws/mediaconvert/model/CmafAdditionalManifest.h>
#include <aws/mediaconvert/model/CmafClientCache.h>
#include <aws/mediaconvert/model/CmafCodecSpecification.h>
#include <aws/mediaconvert/model/CmafEncryptionSettings.h>
#include <aws/mediaconvert/model/CmafEncryptionType.h>
#include <aws/mediaconvert/model/CmafGroupSettings.h>
#include <aws/mediaconvert/model/CmafImageBasedTrickPlay.h>
#include <aws/mediaconvert/model/CmafImageBasedTrickPlaySettings.h>
#include <aws/mediaconvert/model/CmafInitializationVectorInManifest.h>
#include <aws/mediaconvert/model/CmafIntervalCadence.h>
#include <aws/mediaconvert/model/CmafKeyProviderType.h>
#include <aws/mediaconvert/model/CmafManifestCompression.h>
#include <aws/mediaconvert/model/CmafManifestDurationFormat.h>
#include <aws/mediaconvert/model/CmafMpdManifestBandwidthType.h>
#include <aws/mediaconvert/model/CmafMpdProfile.h>
#include <aws/mediaconvert/model/CmafPtsOffsetHandlingForBFrames.h>
#include <aws/mediaconvert/model/CmafSegmentControl.h>
#include <aws/mediaconvert/model/CmafSegmentLengthControl.h>
#include <aws/mediaconvert/model/CmafStreamInfResolution.h>
#include <aws/mediaconvert/model/CmafTargetDurationCompatibilityMode.h>
#include <aws/mediaconvert/model/CmafVideoCompositionOffsets.h>
#include <aws/mediaconvert/model/CmafWriteDASHManifest.h>
#include <aws/mediaconvert/model/CmafWriteHLSManifest.h>
#include <aws/mediaconvert/model/CmafWriteSegmentTimelineInRepresentation.h>
#include <aws/mediaconvert/model/CmfcAudioDuration.h>
#include <aws/mediaconvert/model/CmfcAudioTrackType.h>
#include <aws/mediaconvert/model/CmfcDescriptiveVideoServiceFlag.h>
#include <aws/mediaconvert/model/CmfcIFrameOnlyManifest.h>
#include <aws/mediaconvert/model/CmfcKlvMetadata.h>
#include <aws/mediaconvert/model/CmfcManifestMetadataSignaling.h>
#include <aws/mediaconvert/model/CmfcScte35Esam.h>
#include <aws/mediaconvert/model/CmfcScte35Source.h>
#include <aws/mediaconvert/model/CmfcSettings.h>
#include <aws/mediaconvert/model/CmfcTimedMetadata.h>
#include <aws/mediaconvert/model/CmfcTimedMetadataBoxVersion.h>
#include <aws/mediaconvert/model/Codec.h>
#include <aws/mediaconvert/model/ColorConversion3DLUTSetting.h>
#include <aws/mediaconvert/model/ColorCorrector.h>
#include <aws/mediaconvert/model/ColorMetadata.h>
#include <aws/mediaconvert/model/ColorPrimaries.h>
#include <aws/mediaconvert/model/ColorSpace.h>
#include <aws/mediaconvert/model/ColorSpaceConversion.h>
#include <aws/mediaconvert/model/ColorSpaceUsage.h>
#include <aws/mediaconvert/model/Commitment.h>
#include <aws/mediaconvert/model/Container.h>
#include <aws/mediaconvert/model/ContainerSettings.h>
#include <aws/mediaconvert/model/ContainerType.h>
#include <aws/mediaconvert/model/CopyProtectionAction.h>
#include <aws/mediaconvert/model/CreateJobRequest.h>
#include <aws/mediaconvert/model/CreateJobResult.h>
#include <aws/mediaconvert/model/CreateJobTemplateRequest.h>
#include <aws/mediaconvert/model/CreateJobTemplateResult.h>
#include <aws/mediaconvert/model/CreatePresetRequest.h>
#include <aws/mediaconvert/model/CreatePresetResult.h>
#include <aws/mediaconvert/model/CreateQueueRequest.h>
#include <aws/mediaconvert/model/CreateQueueResult.h>
#include <aws/mediaconvert/model/DashAdditionalManifest.h>
#include <aws/mediaconvert/model/DashIsoEncryptionSettings.h>
#include <aws/mediaconvert/model/DashIsoGroupAudioChannelConfigSchemeIdUri.h>
#include <aws/mediaconvert/model/DashIsoGroupSettings.h>
#include <aws/mediaconvert/model/DashIsoHbbtvCompliance.h>
#include <aws/mediaconvert/model/DashIsoImageBasedTrickPlay.h>
#include <aws/mediaconvert/model/DashIsoImageBasedTrickPlaySettings.h>
#include <aws/mediaconvert/model/DashIsoIntervalCadence.h>
#include <aws/mediaconvert/model/DashIsoMpdManifestBandwidthType.h>
#include <aws/mediaconvert/model/DashIsoMpdProfile.h>
#include <aws/mediaconvert/model/DashIsoPlaybackDeviceCompatibility.h>
#include <aws/mediaconvert/model/DashIsoPtsOffsetHandlingForBFrames.h>
#include <aws/mediaconvert/model/DashIsoSegmentControl.h>
#include <aws/mediaconvert/model/DashIsoSegmentLengthControl.h>
#include <aws/mediaconvert/model/DashIsoVideoCompositionOffsets.h>
#include <aws/mediaconvert/model/DashIsoWriteSegmentTimelineInRepresentation.h>
#include <aws/mediaconvert/model/DashManifestStyle.h>
#include <aws/mediaconvert/model/DataProperties.h>
#include <aws/mediaconvert/model/DecryptionMode.h>
#include <aws/mediaconvert/model/DeinterlaceAlgorithm.h>
#include <aws/mediaconvert/model/Deinterlacer.h>
#include <aws/mediaconvert/model/DeinterlacerControl.h>
#include <aws/mediaconvert/model/DeinterlacerMode.h>
#include <aws/mediaconvert/model/DeleteJobTemplateRequest.h>
#include <aws/mediaconvert/model/DeleteJobTemplateResult.h>
#include <aws/mediaconvert/model/DeletePolicyRequest.h>
#include <aws/mediaconvert/model/DeletePolicyResult.h>
#include <aws/mediaconvert/model/DeletePresetRequest.h>
#include <aws/mediaconvert/model/DeletePresetResult.h>
#include <aws/mediaconvert/model/DeleteQueueRequest.h>
#include <aws/mediaconvert/model/DeleteQueueResult.h>
#include <aws/mediaconvert/model/DescribeEndpointsMode.h>
#include <aws/mediaconvert/model/DestinationSettings.h>
#include <aws/mediaconvert/model/DisassociateCertificateRequest.h>
#include <aws/mediaconvert/model/DisassociateCertificateResult.h>
#include <aws/mediaconvert/model/DolbyVision.h>
#include <aws/mediaconvert/model/DolbyVisionLevel6Metadata.h>
#include <aws/mediaconvert/model/DolbyVisionLevel6Mode.h>
#include <aws/mediaconvert/model/DolbyVisionMapping.h>
#include <aws/mediaconvert/model/DolbyVisionProfile.h>
#include <aws/mediaconvert/model/DropFrameTimecode.h>
#include <aws/mediaconvert/model/DvbNitSettings.h>
#include <aws/mediaconvert/model/DvbSdtSettings.h>
#include <aws/mediaconvert/model/DvbSubDestinationSettings.h>
#include <aws/mediaconvert/model/DvbSubSourceSettings.h>
#include <aws/mediaconvert/model/DvbSubSubtitleFallbackFont.h>
#include <aws/mediaconvert/model/DvbSubtitleAlignment.h>
#include <aws/mediaconvert/model/DvbSubtitleApplyFontColor.h>
#include <aws/mediaconvert/model/DvbSubtitleBackgroundColor.h>
#include <aws/mediaconvert/model/DvbSubtitleFontColor.h>
#include <aws/mediaconvert/model/DvbSubtitleOutlineColor.h>
#include <aws/mediaconvert/model/DvbSubtitleShadowColor.h>
#include <aws/mediaconvert/model/DvbSubtitleStylePassthrough.h>
#include <aws/mediaconvert/model/DvbSubtitleTeletextSpacing.h>
#include <aws/mediaconvert/model/DvbSubtitlingType.h>
#include <aws/mediaconvert/model/DvbTdtSettings.h>
#include <aws/mediaconvert/model/DvbddsHandling.h>
#include <aws/mediaconvert/model/DynamicAudioSelector.h>
#include <aws/mediaconvert/model/DynamicAudioSelectorType.h>
#include <aws/mediaconvert/model/Eac3AtmosBitstreamMode.h>
#include <aws/mediaconvert/model/Eac3AtmosCodingMode.h>
#include <aws/mediaconvert/model/Eac3AtmosDialogueIntelligence.h>
#include <aws/mediaconvert/model/Eac3AtmosDownmixControl.h>
#include <aws/mediaconvert/model/Eac3AtmosDynamicRangeCompressionLine.h>
#include <aws/mediaconvert/model/Eac3AtmosDynamicRangeCompressionRf.h>
#include <aws/mediaconvert/model/Eac3AtmosDynamicRangeControl.h>
#include <aws/mediaconvert/model/Eac3AtmosMeteringMode.h>
#include <aws/mediaconvert/model/Eac3AtmosSettings.h>
#include <aws/mediaconvert/model/Eac3AtmosStereoDownmix.h>
#include <aws/mediaconvert/model/Eac3AtmosSurroundExMode.h>
#include <aws/mediaconvert/model/Eac3AttenuationControl.h>
#include <aws/mediaconvert/model/Eac3BitstreamMode.h>
#include <aws/mediaconvert/model/Eac3CodingMode.h>
#include <aws/mediaconvert/model/Eac3DcFilter.h>
#include <aws/mediaconvert/model/Eac3DynamicRangeCompressionLine.h>
#include <aws/mediaconvert/model/Eac3DynamicRangeCompressionRf.h>
#include <aws/mediaconvert/model/Eac3LfeControl.h>
#include <aws/mediaconvert/model/Eac3LfeFilter.h>
#include <aws/mediaconvert/model/Eac3MetadataControl.h>
#include <aws/mediaconvert/model/Eac3PassthroughControl.h>
#include <aws/mediaconvert/model/Eac3PhaseControl.h>
#include <aws/mediaconvert/model/Eac3Settings.h>
#include <aws/mediaconvert/model/Eac3StereoDownmix.h>
#include <aws/mediaconvert/model/Eac3SurroundExMode.h>
#include <aws/mediaconvert/model/Eac3SurroundMode.h>
#include <aws/mediaconvert/model/EmbeddedConvert608To708.h>
#include <aws/mediaconvert/model/EmbeddedDestinationSettings.h>
#include <aws/mediaconvert/model/EmbeddedSourceSettings.h>
#include <aws/mediaconvert/model/EmbeddedTerminateCaptions.h>
#include <aws/mediaconvert/model/EmbeddedTimecodeOverride.h>
#include <aws/mediaconvert/model/EncryptionContractConfiguration.h>
#include <aws/mediaconvert/model/Endpoint.h>
#include <aws/mediaconvert/model/EsamManifestConfirmConditionNotification.h>
#include <aws/mediaconvert/model/EsamSettings.h>
#include <aws/mediaconvert/model/EsamSignalProcessingNotification.h>
#include <aws/mediaconvert/model/ExtendedDataServices.h>
#include <aws/mediaconvert/model/F4vMoovPlacement.h>
#include <aws/mediaconvert/model/F4vSettings.h>
#include <aws/mediaconvert/model/FileGroupSettings.h>
#include <aws/mediaconvert/model/FileSourceConvert608To708.h>
#include <aws/mediaconvert/model/FileSourceSettings.h>
#include <aws/mediaconvert/model/FileSourceTimeDeltaUnits.h>
#include <aws/mediaconvert/model/FlacSettings.h>
#include <aws/mediaconvert/model/FontScript.h>
#include <aws/mediaconvert/model/ForceIncludeRenditionSize.h>
#include <aws/mediaconvert/model/Format.h>
#include <aws/mediaconvert/model/FrameCaptureSettings.h>
#include <aws/mediaconvert/model/FrameMetricType.h>
#include <aws/mediaconvert/model/FrameRate.h>
#include <aws/mediaconvert/model/GetJobRequest.h>
#include <aws/mediaconvert/model/GetJobResult.h>
#include <aws/mediaconvert/model/GetJobTemplateRequest.h>
#include <aws/mediaconvert/model/GetJobTemplateResult.h>
#include <aws/mediaconvert/model/GetPolicyRequest.h>
#include <aws/mediaconvert/model/GetPolicyResult.h>
#include <aws/mediaconvert/model/GetPresetRequest.h>
#include <aws/mediaconvert/model/GetPresetResult.h>
#include <aws/mediaconvert/model/GetQueueRequest.h>
#include <aws/mediaconvert/model/GetQueueResult.h>
#include <aws/mediaconvert/model/GifFramerateControl.h>
#include <aws/mediaconvert/model/GifFramerateConversionAlgorithm.h>
#include <aws/mediaconvert/model/GifSettings.h>
#include <aws/mediaconvert/model/H264AdaptiveQuantization.h>
#include <aws/mediaconvert/model/H264CodecLevel.h>
#include <aws/mediaconvert/model/H264CodecProfile.h>
#include <aws/mediaconvert/model/H264DynamicSubGop.h>
#include <aws/mediaconvert/model/H264EndOfStreamMarkers.h>
#include <aws/mediaconvert/model/H264EntropyEncoding.h>
#include <aws/mediaconvert/model/H264FieldEncoding.h>
#include <aws/mediaconvert/model/H264FlickerAdaptiveQuantization.h>
#include <aws/mediaconvert/model/H264FramerateControl.h>
#include <aws/mediaconvert/model/H264FramerateConversionAlgorithm.h>
#include <aws/mediaconvert/model/H264GopBReference.h>
#include <aws/mediaconvert/model/H264GopSizeUnits.h>
#include <aws/mediaconvert/model/H264InterlaceMode.h>
#include <aws/mediaconvert/model/H264ParControl.h>
#include <aws/mediaconvert/model/H264QualityTuningLevel.h>
#include <aws/mediaconvert/model/H264QvbrSettings.h>
#include <aws/mediaconvert/model/H264RateControlMode.h>
#include <aws/mediaconvert/model/H264RepeatPps.h>
#include <aws/mediaconvert/model/H264SaliencyAwareEncoding.h>
#include <aws/mediaconvert/model/H264ScanTypeConversionMode.h>
#include <aws/mediaconvert/model/H264SceneChangeDetect.h>
#include <aws/mediaconvert/model/H264Settings.h>
#include <aws/mediaconvert/model/H264SlowPal.h>
#include <aws/mediaconvert/model/H264SpatialAdaptiveQuantization.h>
#include <aws/mediaconvert/model/H264Syntax.h>
#include <aws/mediaconvert/model/H264Telecine.h>
#include <aws/mediaconvert/model/H264TemporalAdaptiveQuantization.h>
#include <aws/mediaconvert/model/H264UnregisteredSeiTimecode.h>
#include <aws/mediaconvert/model/H264WriteMp4PackagingType.h>
#include <aws/mediaconvert/model/H265AdaptiveQuantization.h>
#include <aws/mediaconvert/model/H265AlternateTransferFunctionSei.h>
#include <aws/mediaconvert/model/H265CodecLevel.h>
#include <aws/mediaconvert/model/H265CodecProfile.h>
#include <aws/mediaconvert/model/H265Deblocking.h>
#include <aws/mediaconvert/model/H265DynamicSubGop.h>
#include <aws/mediaconvert/model/H265EndOfStreamMarkers.h>
#include <aws/mediaconvert/model/H265FlickerAdaptiveQuantization.h>
#include <aws/mediaconvert/model/H265FramerateControl.h>
#include <aws/mediaconvert/model/H265FramerateConversionAlgorithm.h>
#include <aws/mediaconvert/model/H265GopBReference.h>
#include <aws/mediaconvert/model/H265GopSizeUnits.h>
#include <aws/mediaconvert/model/H265InterlaceMode.h>
#include <aws/mediaconvert/model/H265ParControl.h>
#include <aws/mediaconvert/model/H265QualityTuningLevel.h>
#include <aws/mediaconvert/model/H265QvbrSettings.h>
#include <aws/mediaconvert/model/H265RateControlMode.h>
#include <aws/mediaconvert/model/H265SampleAdaptiveOffsetFilterMode.h>
#include <aws/mediaconvert/model/H265ScanTypeConversionMode.h>
#include <aws/mediaconvert/model/H265SceneChangeDetect.h>
#include <aws/mediaconvert/model/H265Settings.h>
#include <aws/mediaconvert/model/H265SlowPal.h>
#include <aws/mediaconvert/model/H265SpatialAdaptiveQuantization.h>
#include <aws/mediaconvert/model/H265Telecine.h>
#include <aws/mediaconvert/model/H265TemporalAdaptiveQuantization.h>
#include <aws/mediaconvert/model/H265TemporalIds.h>
#include <aws/mediaconvert/model/H265Tiles.h>
#include <aws/mediaconvert/model/H265UnregisteredSeiTimecode.h>
#include <aws/mediaconvert/model/H265WriteMp4PackagingType.h>
#include <aws/mediaconvert/model/HDRToSDRToneMapper.h>
#include <aws/mediaconvert/model/Hdr10Metadata.h>
#include <aws/mediaconvert/model/Hdr10Plus.h>
#include <aws/mediaconvert/model/HlsAdMarkers.h>
#include <aws/mediaconvert/model/HlsAdditionalManifest.h>
#include <aws/mediaconvert/model/HlsAudioOnlyContainer.h>
#include <aws/mediaconvert/model/HlsAudioOnlyHeader.h>
#include <aws/mediaconvert/model/HlsAudioTrackType.h>
#include <aws/mediaconvert/model/HlsCaptionLanguageMapping.h>
#include <aws/mediaconvert/model/HlsCaptionLanguageSetting.h>
#include <aws/mediaconvert/model/HlsCaptionSegmentLengthControl.h>
#include <aws/mediaconvert/model/HlsClientCache.h>
#include <aws/mediaconvert/model/HlsCodecSpecification.h>
#include <aws/mediaconvert/model/HlsDescriptiveVideoServiceFlag.h>
#include <aws/mediaconvert/model/HlsDirectoryStructure.h>
#include <aws/mediaconvert/model/HlsEncryptionSettings.h>
#include <aws/mediaconvert/model/HlsEncryptionType.h>
#include <aws/mediaconvert/model/HlsGroupSettings.h>
#include <aws/mediaconvert/model/HlsIFrameOnlyManifest.h>
#include <aws/mediaconvert/model/HlsImageBasedTrickPlay.h>
#include <aws/mediaconvert/model/HlsImageBasedTrickPlaySettings.h>
#include <aws/mediaconvert/model/HlsInitializationVectorInManifest.h>
#include <aws/mediaconvert/model/HlsIntervalCadence.h>
#include <aws/mediaconvert/model/HlsKeyProviderType.h>
#include <aws/mediaconvert/model/HlsManifestCompression.h>
#include <aws/mediaconvert/model/HlsManifestDurationFormat.h>
#include <aws/mediaconvert/model/HlsOfflineEncrypted.h>
#include <aws/mediaconvert/model/HlsOutputSelection.h>
#include <aws/mediaconvert/model/HlsProgramDateTime.h>
#include <aws/mediaconvert/model/HlsProgressiveWriteHlsManifest.h>
#include <aws/mediaconvert/model/HlsRenditionGroupSettings.h>
#include <aws/mediaconvert/model/HlsSegmentControl.h>
#include <aws/mediaconvert/model/HlsSegmentLengthControl.h>
#include <aws/mediaconvert/model/HlsSettings.h>
#include <aws/mediaconvert/model/HlsStreamInfResolution.h>
#include <aws/mediaconvert/model/HlsTargetDurationCompatibilityMode.h>
#include <aws/mediaconvert/model/HlsTimedMetadataId3Frame.h>
#include <aws/mediaconvert/model/HopDestination.h>
#include <aws/mediaconvert/model/Id3Insertion.h>
#include <aws/mediaconvert/model/ImageInserter.h>
#include <aws/mediaconvert/model/ImscAccessibilitySubs.h>
#include <aws/mediaconvert/model/ImscDestinationSettings.h>
#include <aws/mediaconvert/model/ImscStylePassthrough.h>
#include <aws/mediaconvert/model/Input.h>
#include <aws/mediaconvert/model/InputClipping.h>
#include <aws/mediaconvert/model/InputDeblockFilter.h>
#include <aws/mediaconvert/model/InputDecryptionSettings.h>
#include <aws/mediaconvert/model/InputDenoiseFilter.h>
#include <aws/mediaconvert/model/InputFilterEnable.h>
#include <aws/mediaconvert/model/InputPolicy.h>
#include <aws/mediaconvert/model/InputPsiControl.h>
#include <aws/mediaconvert/model/InputRotate.h>
#include <aws/mediaconvert/model/InputSampleRange.h>
#include <aws/mediaconvert/model/InputScanType.h>
#include <aws/mediaconvert/model/InputTemplate.h>
#include <aws/mediaconvert/model/InputTimecodeSource.h>
#include <aws/mediaconvert/model/InputVideoGenerator.h>
#include <aws/mediaconvert/model/InsertableImage.h>
#include <aws/mediaconvert/model/Job.h>
#include <aws/mediaconvert/model/JobEngineVersion.h>
#include <aws/mediaconvert/model/JobMessages.h>
#include <aws/mediaconvert/model/JobPhase.h>
#include <aws/mediaconvert/model/JobSettings.h>
#include <aws/mediaconvert/model/JobStatus.h>
#include <aws/mediaconvert/model/JobTemplate.h>
#include <aws/mediaconvert/model/JobTemplateListBy.h>
#include <aws/mediaconvert/model/JobTemplateSettings.h>
#include <aws/mediaconvert/model/KantarWatermarkSettings.h>
#include <aws/mediaconvert/model/LanguageCode.h>
#include <aws/mediaconvert/model/ListJobTemplatesRequest.h>
#include <aws/mediaconvert/model/ListJobTemplatesResult.h>
#include <aws/mediaconvert/model/ListJobsRequest.h>
#include <aws/mediaconvert/model/ListJobsResult.h>
#include <aws/mediaconvert/model/ListPresetsRequest.h>
#include <aws/mediaconvert/model/ListPresetsResult.h>
#include <aws/mediaconvert/model/ListQueuesRequest.h>
#include <aws/mediaconvert/model/ListQueuesResult.h>
#include <aws/mediaconvert/model/ListTagsForResourceRequest.h>
#include <aws/mediaconvert/model/ListTagsForResourceResult.h>
#include <aws/mediaconvert/model/ListVersionsRequest.h>
#include <aws/mediaconvert/model/ListVersionsResult.h>
#include <aws/mediaconvert/model/M2tsAudioBufferModel.h>
#include <aws/mediaconvert/model/M2tsAudioDuration.h>
#include <aws/mediaconvert/model/M2tsBufferModel.h>
#include <aws/mediaconvert/model/M2tsDataPtsControl.h>
#include <aws/mediaconvert/model/M2tsEbpAudioInterval.h>
#include <aws/mediaconvert/model/M2tsEbpPlacement.h>
#include <aws/mediaconvert/model/M2tsEsRateInPes.h>
#include <aws/mediaconvert/model/M2tsForceTsVideoEbpOrder.h>
#include <aws/mediaconvert/model/M2tsKlvMetadata.h>
#include <aws/mediaconvert/model/M2tsNielsenId3.h>
#include <aws/mediaconvert/model/M2tsPcrControl.h>
#include <aws/mediaconvert/model/M2tsPreventBufferUnderflow.h>
#include <aws/mediaconvert/model/M2tsRateMode.h>
#include <aws/mediaconvert/model/M2tsScte35Esam.h>
#include <aws/mediaconvert/model/M2tsScte35Source.h>
#include <aws/mediaconvert/model/M2tsSegmentationMarkers.h>
#include <aws/mediaconvert/model/M2tsSegmentationStyle.h>
#include <aws/mediaconvert/model/M2tsSettings.h>
#include <aws/mediaconvert/model/M3u8AudioDuration.h>
#include <aws/mediaconvert/model/M3u8DataPtsControl.h>
#include <aws/mediaconvert/model/M3u8NielsenId3.h>
#include <aws/mediaconvert/model/M3u8PcrControl.h>
#include <aws/mediaconvert/model/M3u8Scte35Source.h>
#include <aws/mediaconvert/model/M3u8Settings.h>
#include <aws/mediaconvert/model/MatrixCoefficients.h>
#include <aws/mediaconvert/model/Metadata.h>
#include <aws/mediaconvert/model/MinBottomRenditionSize.h>
#include <aws/mediaconvert/model/MinTopRenditionSize.h>
#include <aws/mediaconvert/model/MotionImageInserter.h>
#include <aws/mediaconvert/model/MotionImageInsertionFramerate.h>
#include <aws/mediaconvert/model/MotionImageInsertionMode.h>
#include <aws/mediaconvert/model/MotionImageInsertionOffset.h>
#include <aws/mediaconvert/model/MotionImagePlayback.h>
#include <aws/mediaconvert/model/MovClapAtom.h>
#include <aws/mediaconvert/model/MovCslgAtom.h>
#include <aws/mediaconvert/model/MovMpeg2FourCCControl.h>
#include <aws/mediaconvert/model/MovPaddingControl.h>
#include <aws/mediaconvert/model/MovReference.h>
#include <aws/mediaconvert/model/MovSettings.h>
#include <aws/mediaconvert/model/Mp2Settings.h>
#include <aws/mediaconvert/model/Mp3RateControlMode.h>
#include <aws/mediaconvert/model/Mp3Settings.h>
#include <aws/mediaconvert/model/Mp4C2paManifest.h>
#include <aws/mediaconvert/model/Mp4CslgAtom.h>
#include <aws/mediaconvert/model/Mp4FreeSpaceBox.h>
#include <aws/mediaconvert/model/Mp4MoovPlacement.h>
#include <aws/mediaconvert/model/Mp4Settings.h>
#include <aws/mediaconvert/model/MpdAccessibilityCaptionHints.h>
#include <aws/mediaconvert/model/MpdAudioDuration.h>
#include <aws/mediaconvert/model/MpdCaptionContainerType.h>
#include <aws/mediaconvert/model/MpdKlvMetadata.h>
#include <aws/mediaconvert/model/MpdManifestMetadataSignaling.h>
#include <aws/mediaconvert/model/MpdScte35Esam.h>
#include <aws/mediaconvert/model/MpdScte35Source.h>
#include <aws/mediaconvert/model/MpdSettings.h>
#include <aws/mediaconvert/model/MpdTimedMetadata.h>
#include <aws/mediaconvert/model/MpdTimedMetadataBoxVersion.h>
#include <aws/mediaconvert/model/Mpeg2AdaptiveQuantization.h>
#include <aws/mediaconvert/model/Mpeg2CodecLevel.h>
#include <aws/mediaconvert/model/Mpeg2CodecProfile.h>
#include <aws/mediaconvert/model/Mpeg2DynamicSubGop.h>
#include <aws/mediaconvert/model/Mpeg2FramerateControl.h>
#include <aws/mediaconvert/model/Mpeg2FramerateConversionAlgorithm.h>
#include <aws/mediaconvert/model/Mpeg2GopSizeUnits.h>
#include <aws/mediaconvert/model/Mpeg2InterlaceMode.h>
#include <aws/mediaconvert/model/Mpeg2IntraDcPrecision.h>
#include <aws/mediaconvert/model/Mpeg2ParControl.h>
#include <aws/mediaconvert/model/Mpeg2QualityTuningLevel.h>
#include <aws/mediaconvert/model/Mpeg2RateControlMode.h>
#include <aws/mediaconvert/model/Mpeg2ScanTypeConversionMode.h>
#include <aws/mediaconvert/model/Mpeg2SceneChangeDetect.h>
#include <aws/mediaconvert/model/Mpeg2Settings.h>
#include <aws/mediaconvert/model/Mpeg2SlowPal.h>
#include <aws/mediaconvert/model/Mpeg2SpatialAdaptiveQuantization.h>
#include <aws/mediaconvert/model/Mpeg2Syntax.h>
#include <aws/mediaconvert/model/Mpeg2Telecine.h>
#include <aws/mediaconvert/model/Mpeg2TemporalAdaptiveQuantization.h>
#include <aws/mediaconvert/model/MsSmoothAdditionalManifest.h>
#include <aws/mediaconvert/model/MsSmoothAudioDeduplication.h>
#include <aws/mediaconvert/model/MsSmoothEncryptionSettings.h>
#include <aws/mediaconvert/model/MsSmoothFragmentLengthControl.h>
#include <aws/mediaconvert/model/MsSmoothGroupSettings.h>
#include <aws/mediaconvert/model/MsSmoothManifestEncoding.h>
#include <aws/mediaconvert/model/MxfAfdSignaling.h>
#include <aws/mediaconvert/model/MxfProfile.h>
#include <aws/mediaconvert/model/MxfSettings.h>
#include <aws/mediaconvert/model/MxfXavcDurationMode.h>
#include <aws/mediaconvert/model/MxfXavcProfileSettings.h>
#include <aws/mediaconvert/model/NexGuardFileMarkerSettings.h>
#include <aws/mediaconvert/model/NielsenActiveWatermarkProcessType.h>
#include <aws/mediaconvert/model/NielsenConfiguration.h>
#include <aws/mediaconvert/model/NielsenNonLinearWatermarkSettings.h>
#include <aws/mediaconvert/model/NielsenSourceWatermarkStatusType.h>
#include <aws/mediaconvert/model/NielsenUniqueTicPerAudioTrackType.h>
#include <aws/mediaconvert/model/NoiseFilterPostTemporalSharpening.h>
#include <aws/mediaconvert/model/NoiseFilterPostTemporalSharpeningStrength.h>
#include <aws/mediaconvert/model/NoiseReducer.h>
#include <aws/mediaconvert/model/NoiseReducerFilter.h>
#include <aws/mediaconvert/model/NoiseReducerFilterSettings.h>
#include <aws/mediaconvert/model/NoiseReducerSpatialFilterSettings.h>
#include <aws/mediaconvert/model/NoiseReducerTemporalFilterSettings.h>
#include <aws/mediaconvert/model/OpusSettings.h>
#include <aws/mediaconvert/model/Order.h>
#include <aws/mediaconvert/model/Output.h>
#include <aws/mediaconvert/model/OutputChannelMapping.h>
#include <aws/mediaconvert/model/OutputDetail.h>
#include <aws/mediaconvert/model/OutputGroup.h>
#include <aws/mediaconvert/model/OutputGroupDetail.h>
#include <aws/mediaconvert/model/OutputGroupSettings.h>
#include <aws/mediaconvert/model/OutputGroupType.h>
#include <aws/mediaconvert/model/OutputSdt.h>
#include <aws/mediaconvert/model/OutputSettings.h>
#include <aws/mediaconvert/model/PadVideo.h>
#include <aws/mediaconvert/model/PartnerWatermarking.h>
#include <aws/mediaconvert/model/Policy.h>
#include <aws/mediaconvert/model/Preset.h>
#include <aws/mediaconvert/model/PresetListBy.h>
#include <aws/mediaconvert/model/PresetSettings.h>
#include <aws/mediaconvert/model/PresetSpeke20Audio.h>
#include <aws/mediaconvert/model/PresetSpeke20Video.h>
#include <aws/mediaconvert/model/PricingPlan.h>
#include <aws/mediaconvert/model/ProbeInputFile.h>
#include <aws/mediaconvert/model/ProbeRequest.h>
#include <aws/mediaconvert/model/ProbeResult.h>
#include <aws/mediaconvert/model/ProbeSdkResult.h>
#include <aws/mediaconvert/model/ProresChromaSampling.h>
#include <aws/mediaconvert/model/ProresCodecProfile.h>
#include <aws/mediaconvert/model/ProresFramerateControl.h>
#include <aws/mediaconvert/model/ProresFramerateConversionAlgorithm.h>
#include <aws/mediaconvert/model/ProresInterlaceMode.h>
#include <aws/mediaconvert/model/ProresParControl.h>
#include <aws/mediaconvert/model/ProresScanTypeConversionMode.h>
#include <aws/mediaconvert/model/ProresSettings.h>
#include <aws/mediaconvert/model/ProresSlowPal.h>
#include <aws/mediaconvert/model/ProresTelecine.h>
#include <aws/mediaconvert/model/PutPolicyRequest.h>
#include <aws/mediaconvert/model/PutPolicyResult.h>
#include <aws/mediaconvert/model/Queue.h>
#include <aws/mediaconvert/model/QueueListBy.h>
#include <aws/mediaconvert/model/QueueStatus.h>
#include <aws/mediaconvert/model/QueueTransition.h>
#include <aws/mediaconvert/model/Rectangle.h>
#include <aws/mediaconvert/model/RemixSettings.h>
#include <aws/mediaconvert/model/RemoveRubyReserveAttributes.h>
#include <aws/mediaconvert/model/RenewalType.h>
#include <aws/mediaconvert/model/RequiredFlag.h>
#include <aws/mediaconvert/model/ReservationPlan.h>
#include <aws/mediaconvert/model/ReservationPlanSettings.h>
#include <aws/mediaconvert/model/ReservationPlanStatus.h>
#include <aws/mediaconvert/model/ResourceTags.h>
#include <aws/mediaconvert/model/RespondToAfd.h>
#include <aws/mediaconvert/model/RuleType.h>
#include <aws/mediaconvert/model/S3DestinationAccessControl.h>
#include <aws/mediaconvert/model/S3DestinationSettings.h>
#include <aws/mediaconvert/model/S3EncryptionSettings.h>
#include <aws/mediaconvert/model/S3ObjectCannedAcl.h>
#include <aws/mediaconvert/model/S3ServerSideEncryptionType.h>
#include <aws/mediaconvert/model/S3StorageClass.h>
#include <aws/mediaconvert/model/SampleRangeConversion.h>
#include <aws/mediaconvert/model/ScalingBehavior.h>
#include <aws/mediaconvert/model/SccDestinationFramerate.h>
#include <aws/mediaconvert/model/SccDestinationSettings.h>
#include <aws/mediaconvert/model/SearchJobsRequest.h>
#include <aws/mediaconvert/model/SearchJobsResult.h>
#include <aws/mediaconvert/model/ServiceOverride.h>
#include <aws/mediaconvert/model/SimulateReservedQueue.h>
#include <aws/mediaconvert/model/SpekeKeyProvider.h>
#include <aws/mediaconvert/model/SpekeKeyProviderCmaf.h>
#include <aws/mediaconvert/model/SrtDestinationSettings.h>
#include <aws/mediaconvert/model/SrtStylePassthrough.h>
#include <aws/mediaconvert/model/StaticKeyProvider.h>
#include <aws/mediaconvert/model/StatusUpdateInterval.h>
#include <aws/mediaconvert/model/TagResourceRequest.h>
#include <aws/mediaconvert/model/TagResourceResult.h>
#include <aws/mediaconvert/model/TeletextDestinationSettings.h>
#include <aws/mediaconvert/model/TeletextPageType.h>
#include <aws/mediaconvert/model/TeletextSourceSettings.h>
#include <aws/mediaconvert/model/TimecodeBurnin.h>
#include <aws/mediaconvert/model/TimecodeBurninPosition.h>
#include <aws/mediaconvert/model/TimecodeConfig.h>
#include <aws/mediaconvert/model/TimecodeSource.h>
#include <aws/mediaconvert/model/TimecodeTrack.h>
#include <aws/mediaconvert/model/TimedMetadata.h>
#include <aws/mediaconvert/model/TimedMetadataInsertion.h>
#include <aws/mediaconvert/model/Timing.h>
#include <aws/mediaconvert/model/Track.h>
#include <aws/mediaconvert/model/TrackMapping.h>
#include <aws/mediaconvert/model/TrackSourceSettings.h>
#include <aws/mediaconvert/model/TrackType.h>
#include <aws/mediaconvert/model/TransferCharacteristics.h>
#include <aws/mediaconvert/model/TsPtsOffset.h>
#include <aws/mediaconvert/model/TtmlDestinationSettings.h>
#include <aws/mediaconvert/model/TtmlStylePassthrough.h>
#include <aws/mediaconvert/model/Type.h>
#include <aws/mediaconvert/model/UncompressedFourcc.h>
#include <aws/mediaconvert/model/UncompressedFramerateControl.h>
#include <aws/mediaconvert/model/UncompressedFramerateConversionAlgorithm.h>
#include <aws/mediaconvert/model/UncompressedInterlaceMode.h>
#include <aws/mediaconvert/model/UncompressedScanTypeConversionMode.h>
#include <aws/mediaconvert/model/UncompressedSettings.h>
#include <aws/mediaconvert/model/UncompressedSlowPal.h>
#include <aws/mediaconvert/model/UncompressedTelecine.h>
#include <aws/mediaconvert/model/UntagResourceRequest.h>
#include <aws/mediaconvert/model/UntagResourceResult.h>
#include <aws/mediaconvert/model/UpdateJobTemplateRequest.h>
#include <aws/mediaconvert/model/UpdateJobTemplateResult.h>
#include <aws/mediaconvert/model/UpdatePresetRequest.h>
#include <aws/mediaconvert/model/UpdatePresetResult.h>
#include <aws/mediaconvert/model/UpdateQueueRequest.h>
#include <aws/mediaconvert/model/UpdateQueueResult.h>
#include <aws/mediaconvert/model/Vc3Class.h>
#include <aws/mediaconvert/model/Vc3FramerateControl.h>
#include <aws/mediaconvert/model/Vc3FramerateConversionAlgorithm.h>
#include <aws/mediaconvert/model/Vc3InterlaceMode.h>
#include <aws/mediaconvert/model/Vc3ScanTypeConversionMode.h>
#include <aws/mediaconvert/model/Vc3Settings.h>
#include <aws/mediaconvert/model/Vc3SlowPal.h>
#include <aws/mediaconvert/model/Vc3Telecine.h>
#include <aws/mediaconvert/model/VchipAction.h>
#include <aws/mediaconvert/model/VideoCodec.h>
#include <aws/mediaconvert/model/VideoCodecSettings.h>
#include <aws/mediaconvert/model/VideoDescription.h>
#include <aws/mediaconvert/model/VideoDetail.h>
#include <aws/mediaconvert/model/VideoOverlay.h>
#include <aws/mediaconvert/model/VideoOverlayCrop.h>
#include <aws/mediaconvert/model/VideoOverlayInput.h>
#include <aws/mediaconvert/model/VideoOverlayInputClipping.h>
#include <aws/mediaconvert/model/VideoOverlayPlayBackMode.h>
#include <aws/mediaconvert/model/VideoOverlayPosition.h>
#include <aws/mediaconvert/model/VideoOverlayTransition.h>
#include <aws/mediaconvert/model/VideoOverlayUnit.h>
#include <aws/mediaconvert/model/VideoPreprocessor.h>
#include <aws/mediaconvert/model/VideoProperties.h>
#include <aws/mediaconvert/model/VideoSelector.h>
#include <aws/mediaconvert/model/VideoTimecodeInsertion.h>
#include <aws/mediaconvert/model/VorbisSettings.h>
#include <aws/mediaconvert/model/Vp8FramerateControl.h>
#include <aws/mediaconvert/model/Vp8FramerateConversionAlgorithm.h>
#include <aws/mediaconvert/model/Vp8ParControl.h>
#include <aws/mediaconvert/model/Vp8QualityTuningLevel.h>
#include <aws/mediaconvert/model/Vp8RateControlMode.h>
#include <aws/mediaconvert/model/Vp8Settings.h>
#include <aws/mediaconvert/model/Vp9FramerateControl.h>
#include <aws/mediaconvert/model/Vp9FramerateConversionAlgorithm.h>
#include <aws/mediaconvert/model/Vp9ParControl.h>
#include <aws/mediaconvert/model/Vp9QualityTuningLevel.h>
#include <aws/mediaconvert/model/Vp9RateControlMode.h>
#include <aws/mediaconvert/model/Vp9Settings.h>
#include <aws/mediaconvert/model/WarningGroup.h>
#include <aws/mediaconvert/model/WatermarkingStrength.h>
#include <aws/mediaconvert/model/WavFormat.h>
#include <aws/mediaconvert/model/WavSettings.h>
#include <aws/mediaconvert/model/WebvttAccessibilitySubs.h>
#include <aws/mediaconvert/model/WebvttDestinationSettings.h>
#include <aws/mediaconvert/model/WebvttHlsSourceSettings.h>
#include <aws/mediaconvert/model/WebvttStylePassthrough.h>
#include <aws/mediaconvert/model/Xavc4kIntraCbgProfileClass.h>
#include <aws/mediaconvert/model/Xavc4kIntraCbgProfileSettings.h>
#include <aws/mediaconvert/model/Xavc4kIntraVbrProfileClass.h>
#include <aws/mediaconvert/model/Xavc4kIntraVbrProfileSettings.h>
#include <aws/mediaconvert/model/Xavc4kProfileBitrateClass.h>
#include <aws/mediaconvert/model/Xavc4kProfileCodecProfile.h>
#include <aws/mediaconvert/model/Xavc4kProfileQualityTuningLevel.h>
#include <aws/mediaconvert/model/Xavc4kProfileSettings.h>
#include <aws/mediaconvert/model/XavcAdaptiveQuantization.h>
#include <aws/mediaconvert/model/XavcEntropyEncoding.h>
#include <aws/mediaconvert/model/XavcFlickerAdaptiveQuantization.h>
#include <aws/mediaconvert/model/XavcFramerateControl.h>
#include <aws/mediaconvert/model/XavcFramerateConversionAlgorithm.h>
#include <aws/mediaconvert/model/XavcGopBReference.h>
#include <aws/mediaconvert/model/XavcHdIntraCbgProfileClass.h>
#include <aws/mediaconvert/model/XavcHdIntraCbgProfileSettings.h>
#include <aws/mediaconvert/model/XavcHdProfileBitrateClass.h>
#include <aws/mediaconvert/model/XavcHdProfileQualityTuningLevel.h>
#include <aws/mediaconvert/model/XavcHdProfileSettings.h>
#include <aws/mediaconvert/model/XavcHdProfileTelecine.h>
#include <aws/mediaconvert/model/XavcInterlaceMode.h>
#include <aws/mediaconvert/model/XavcProfile.h>
#include <aws/mediaconvert/model/XavcSettings.h>
#include <aws/mediaconvert/model/XavcSlowPal.h>
#include <aws/mediaconvert/model/XavcSpatialAdaptiveQuantization.h>
#include <aws/mediaconvert/model/XavcTemporalAdaptiveQuantization.h>

using MediaConvertIncludeTest = ::testing::Test;

TEST_F(MediaConvertIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::MediaConvert::MediaConvertClient>("MediaConvertIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
