/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/medialive/MediaLiveClient.h>
#include <aws/medialive/MediaLiveEndpointProvider.h>
#include <aws/medialive/MediaLiveEndpointRules.h>
#include <aws/medialive/MediaLiveErrorMarshaller.h>
#include <aws/medialive/MediaLiveErrors.h>
#include <aws/medialive/MediaLiveRequest.h>
#include <aws/medialive/MediaLiveServiceClientModel.h>
#include <aws/medialive/MediaLive_EXPORTS.h>
#include <aws/medialive/model/AacCodingMode.h>
#include <aws/medialive/model/AacInputType.h>
#include <aws/medialive/model/AacProfile.h>
#include <aws/medialive/model/AacRateControlMode.h>
#include <aws/medialive/model/AacRawFormat.h>
#include <aws/medialive/model/AacSettings.h>
#include <aws/medialive/model/AacSpec.h>
#include <aws/medialive/model/AacVbrQuality.h>
#include <aws/medialive/model/Ac3AttenuationControl.h>
#include <aws/medialive/model/Ac3BitstreamMode.h>
#include <aws/medialive/model/Ac3CodingMode.h>
#include <aws/medialive/model/Ac3DrcProfile.h>
#include <aws/medialive/model/Ac3LfeFilter.h>
#include <aws/medialive/model/Ac3MetadataControl.h>
#include <aws/medialive/model/Ac3Settings.h>
#include <aws/medialive/model/AcceptHeader.h>
#include <aws/medialive/model/AcceptInputDeviceTransferRequest.h>
#include <aws/medialive/model/AcceptInputDeviceTransferResult.h>
#include <aws/medialive/model/AccessibilityType.h>
#include <aws/medialive/model/AccountConfiguration.h>
#include <aws/medialive/model/AfdSignaling.h>
#include <aws/medialive/model/Algorithm.h>
#include <aws/medialive/model/AncillarySourceSettings.h>
#include <aws/medialive/model/AnywhereSettings.h>
#include <aws/medialive/model/ArchiveCdnSettings.h>
#include <aws/medialive/model/ArchiveContainerSettings.h>
#include <aws/medialive/model/ArchiveGroupSettings.h>
#include <aws/medialive/model/ArchiveOutputSettings.h>
#include <aws/medialive/model/ArchiveS3Settings.h>
#include <aws/medialive/model/AribDestinationSettings.h>
#include <aws/medialive/model/AribSourceSettings.h>
#include <aws/medialive/model/AudioChannelMapping.h>
#include <aws/medialive/model/AudioCodecSettings.h>
#include <aws/medialive/model/AudioDescription.h>
#include <aws/medialive/model/AudioDescriptionAudioTypeControl.h>
#include <aws/medialive/model/AudioDescriptionLanguageCodeControl.h>
#include <aws/medialive/model/AudioDolbyEDecode.h>
#include <aws/medialive/model/AudioHlsRenditionSelection.h>
#include <aws/medialive/model/AudioLanguageSelection.h>
#include <aws/medialive/model/AudioLanguageSelectionPolicy.h>
#include <aws/medialive/model/AudioNormalizationAlgorithm.h>
#include <aws/medialive/model/AudioNormalizationAlgorithmControl.h>
#include <aws/medialive/model/AudioNormalizationSettings.h>
#include <aws/medialive/model/AudioOnlyHlsSegmentType.h>
#include <aws/medialive/model/AudioOnlyHlsSettings.h>
#include <aws/medialive/model/AudioOnlyHlsTrackType.h>
#include <aws/medialive/model/AudioPidSelection.h>
#include <aws/medialive/model/AudioSelector.h>
#include <aws/medialive/model/AudioSelectorSettings.h>
#include <aws/medialive/model/AudioSilenceFailoverSettings.h>
#include <aws/medialive/model/AudioTrack.h>
#include <aws/medialive/model/AudioTrackSelection.h>
#include <aws/medialive/model/AudioType.h>
#include <aws/medialive/model/AudioWatermarkSettings.h>
#include <aws/medialive/model/AuthenticationScheme.h>
#include <aws/medialive/model/AutomaticInputFailoverSettings.h>
#include <aws/medialive/model/Av1ColorSpaceSettings.h>
#include <aws/medialive/model/Av1GopSizeUnits.h>
#include <aws/medialive/model/Av1Level.h>
#include <aws/medialive/model/Av1LookAheadRateControl.h>
#include <aws/medialive/model/Av1RateControlMode.h>
#include <aws/medialive/model/Av1SceneChangeDetect.h>
#include <aws/medialive/model/Av1Settings.h>
#include <aws/medialive/model/AvailBlanking.h>
#include <aws/medialive/model/AvailBlankingState.h>
#include <aws/medialive/model/AvailConfiguration.h>
#include <aws/medialive/model/AvailSettings.h>
#include <aws/medialive/model/BandwidthReductionFilterSettings.h>
#include <aws/medialive/model/BandwidthReductionFilterStrength.h>
#include <aws/medialive/model/BandwidthReductionPostFilterSharpening.h>
#include <aws/medialive/model/BatchDeleteRequest.h>
#include <aws/medialive/model/BatchDeleteResult.h>
#include <aws/medialive/model/BatchFailedResultModel.h>
#include <aws/medialive/model/BatchScheduleActionCreateRequest.h>
#include <aws/medialive/model/BatchScheduleActionCreateResult.h>
#include <aws/medialive/model/BatchScheduleActionDeleteRequest.h>
#include <aws/medialive/model/BatchScheduleActionDeleteResult.h>
#include <aws/medialive/model/BatchStartRequest.h>
#include <aws/medialive/model/BatchStartResult.h>
#include <aws/medialive/model/BatchStopRequest.h>
#include <aws/medialive/model/BatchStopResult.h>
#include <aws/medialive/model/BatchSuccessfulResultModel.h>
#include <aws/medialive/model/BatchUpdateScheduleRequest.h>
#include <aws/medialive/model/BatchUpdateScheduleResult.h>
#include <aws/medialive/model/BlackoutSlate.h>
#include <aws/medialive/model/BlackoutSlateNetworkEndBlackout.h>
#include <aws/medialive/model/BlackoutSlateState.h>
#include <aws/medialive/model/BurnInAlignment.h>
#include <aws/medialive/model/BurnInBackgroundColor.h>
#include <aws/medialive/model/BurnInDestinationSettings.h>
#include <aws/medialive/model/BurnInFontColor.h>
#include <aws/medialive/model/BurnInOutlineColor.h>
#include <aws/medialive/model/BurnInShadowColor.h>
#include <aws/medialive/model/BurnInTeletextGridControl.h>
#include <aws/medialive/model/CancelInputDeviceTransferRequest.h>
#include <aws/medialive/model/CancelInputDeviceTransferResult.h>
#include <aws/medialive/model/CaptionDescription.h>
#include <aws/medialive/model/CaptionDestinationSettings.h>
#include <aws/medialive/model/CaptionLanguageMapping.h>
#include <aws/medialive/model/CaptionRectangle.h>
#include <aws/medialive/model/CaptionSelector.h>
#include <aws/medialive/model/CaptionSelectorSettings.h>
#include <aws/medialive/model/CdiInputResolution.h>
#include <aws/medialive/model/CdiInputSpecification.h>
#include <aws/medialive/model/Channel.h>
#include <aws/medialive/model/ChannelClass.h>
#include <aws/medialive/model/ChannelEgressEndpoint.h>
#include <aws/medialive/model/ChannelEngineVersionRequest.h>
#include <aws/medialive/model/ChannelEngineVersionResponse.h>
#include <aws/medialive/model/ChannelPipelineIdToRestart.h>
#include <aws/medialive/model/ChannelPlacementGroupState.h>
#include <aws/medialive/model/ChannelState.h>
#include <aws/medialive/model/ChannelSummary.h>
#include <aws/medialive/model/ClaimDeviceRequest.h>
#include <aws/medialive/model/ClaimDeviceResult.h>
#include <aws/medialive/model/CloudWatchAlarmTemplateComparisonOperator.h>
#include <aws/medialive/model/CloudWatchAlarmTemplateGroupSummary.h>
#include <aws/medialive/model/CloudWatchAlarmTemplateStatistic.h>
#include <aws/medialive/model/CloudWatchAlarmTemplateSummary.h>
#include <aws/medialive/model/CloudWatchAlarmTemplateTargetResourceType.h>
#include <aws/medialive/model/CloudWatchAlarmTemplateTreatMissingData.h>
#include <aws/medialive/model/ClusterNetworkSettings.h>
#include <aws/medialive/model/ClusterNetworkSettingsCreateRequest.h>
#include <aws/medialive/model/ClusterNetworkSettingsUpdateRequest.h>
#include <aws/medialive/model/ClusterState.h>
#include <aws/medialive/model/ClusterType.h>
#include <aws/medialive/model/CmafId3Behavior.h>
#include <aws/medialive/model/CmafIngestCaptionLanguageMapping.h>
#include <aws/medialive/model/CmafIngestGroupSettings.h>
#include <aws/medialive/model/CmafIngestOutputSettings.h>
#include <aws/medialive/model/CmafIngestSegmentLengthUnits.h>
#include <aws/medialive/model/CmafKLVBehavior.h>
#include <aws/medialive/model/CmafNielsenId3Behavior.h>
#include <aws/medialive/model/CmafTimedMetadataId3Frame.h>
#include <aws/medialive/model/CmafTimedMetadataPassthrough.h>
#include <aws/medialive/model/ColorCorrection.h>
#include <aws/medialive/model/ColorCorrectionSettings.h>
#include <aws/medialive/model/ColorSpace.h>
#include <aws/medialive/model/ColorSpacePassthroughSettings.h>
#include <aws/medialive/model/ContentType.h>
#include <aws/medialive/model/CreateChannelPlacementGroupRequest.h>
#include <aws/medialive/model/CreateChannelPlacementGroupResult.h>
#include <aws/medialive/model/CreateChannelRequest.h>
#include <aws/medialive/model/CreateChannelResult.h>
#include <aws/medialive/model/CreateCloudWatchAlarmTemplateGroupRequest.h>
#include <aws/medialive/model/CreateCloudWatchAlarmTemplateGroupResult.h>
#include <aws/medialive/model/CreateCloudWatchAlarmTemplateRequest.h>
#include <aws/medialive/model/CreateCloudWatchAlarmTemplateResult.h>
#include <aws/medialive/model/CreateClusterRequest.h>
#include <aws/medialive/model/CreateClusterResult.h>
#include <aws/medialive/model/CreateEventBridgeRuleTemplateGroupRequest.h>
#include <aws/medialive/model/CreateEventBridgeRuleTemplateGroupResult.h>
#include <aws/medialive/model/CreateEventBridgeRuleTemplateRequest.h>
#include <aws/medialive/model/CreateEventBridgeRuleTemplateResult.h>
#include <aws/medialive/model/CreateInputRequest.h>
#include <aws/medialive/model/CreateInputResult.h>
#include <aws/medialive/model/CreateInputSecurityGroupRequest.h>
#include <aws/medialive/model/CreateInputSecurityGroupResult.h>
#include <aws/medialive/model/CreateMultiplexProgramRequest.h>
#include <aws/medialive/model/CreateMultiplexProgramResult.h>
#include <aws/medialive/model/CreateMultiplexRequest.h>
#include <aws/medialive/model/CreateMultiplexResult.h>
#include <aws/medialive/model/CreateNetworkRequest.h>
#include <aws/medialive/model/CreateNetworkResult.h>
#include <aws/medialive/model/CreateNodeRegistrationScriptRequest.h>
#include <aws/medialive/model/CreateNodeRegistrationScriptSdkResult.h>
#include <aws/medialive/model/CreateNodeRequest.h>
#include <aws/medialive/model/CreateNodeResult.h>
#include <aws/medialive/model/CreatePartnerInputRequest.h>
#include <aws/medialive/model/CreatePartnerInputResult.h>
#include <aws/medialive/model/CreateSdiSourceRequest.h>
#include <aws/medialive/model/CreateSdiSourceResult.h>
#include <aws/medialive/model/CreateSignalMapRequest.h>
#include <aws/medialive/model/CreateSignalMapResult.h>
#include <aws/medialive/model/CreateTagsRequest.h>
#include <aws/medialive/model/DashRoleAudio.h>
#include <aws/medialive/model/DashRoleCaption.h>
#include <aws/medialive/model/DeleteChannelPlacementGroupRequest.h>
#include <aws/medialive/model/DeleteChannelPlacementGroupResult.h>
#include <aws/medialive/model/DeleteChannelRequest.h>
#include <aws/medialive/model/DeleteChannelResult.h>
#include <aws/medialive/model/DeleteCloudWatchAlarmTemplateGroupRequest.h>
#include <aws/medialive/model/DeleteCloudWatchAlarmTemplateRequest.h>
#include <aws/medialive/model/DeleteClusterRequest.h>
#include <aws/medialive/model/DeleteClusterResult.h>
#include <aws/medialive/model/DeleteEventBridgeRuleTemplateGroupRequest.h>
#include <aws/medialive/model/DeleteEventBridgeRuleTemplateRequest.h>
#include <aws/medialive/model/DeleteInputRequest.h>
#include <aws/medialive/model/DeleteInputResult.h>
#include <aws/medialive/model/DeleteInputSecurityGroupRequest.h>
#include <aws/medialive/model/DeleteInputSecurityGroupResult.h>
#include <aws/medialive/model/DeleteMultiplexProgramRequest.h>
#include <aws/medialive/model/DeleteMultiplexProgramResult.h>
#include <aws/medialive/model/DeleteMultiplexRequest.h>
#include <aws/medialive/model/DeleteMultiplexResult.h>
#include <aws/medialive/model/DeleteNetworkRequest.h>
#include <aws/medialive/model/DeleteNetworkResult.h>
#include <aws/medialive/model/DeleteNodeRequest.h>
#include <aws/medialive/model/DeleteNodeResult.h>
#include <aws/medialive/model/DeleteReservationRequest.h>
#include <aws/medialive/model/DeleteReservationResult.h>
#include <aws/medialive/model/DeleteScheduleRequest.h>
#include <aws/medialive/model/DeleteScheduleResult.h>
#include <aws/medialive/model/DeleteSdiSourceRequest.h>
#include <aws/medialive/model/DeleteSdiSourceResult.h>
#include <aws/medialive/model/DeleteSignalMapRequest.h>
#include <aws/medialive/model/DeleteTagsRequest.h>
#include <aws/medialive/model/DescribeAccountConfigurationRequest.h>
#include <aws/medialive/model/DescribeAccountConfigurationResult.h>
#include <aws/medialive/model/DescribeAnywhereSettings.h>
#include <aws/medialive/model/DescribeChannelPlacementGroupRequest.h>
#include <aws/medialive/model/DescribeChannelPlacementGroupSdkResult.h>
#include <aws/medialive/model/DescribeChannelPlacementGroupSummary.h>
#include <aws/medialive/model/DescribeChannelRequest.h>
#include <aws/medialive/model/DescribeChannelResult.h>
#include <aws/medialive/model/DescribeClusterRequest.h>
#include <aws/medialive/model/DescribeClusterSdkResult.h>
#include <aws/medialive/model/DescribeClusterSummary.h>
#include <aws/medialive/model/DescribeInputDeviceRequest.h>
#include <aws/medialive/model/DescribeInputDeviceResult.h>
#include <aws/medialive/model/DescribeInputDeviceThumbnailRequest.h>
#include <aws/medialive/model/DescribeInputDeviceThumbnailResult.h>
#include <aws/medialive/model/DescribeInputRequest.h>
#include <aws/medialive/model/DescribeInputResult.h>
#include <aws/medialive/model/DescribeInputSecurityGroupRequest.h>
#include <aws/medialive/model/DescribeInputSecurityGroupResult.h>
#include <aws/medialive/model/DescribeMultiplexProgramRequest.h>
#include <aws/medialive/model/DescribeMultiplexProgramResult.h>
#include <aws/medialive/model/DescribeMultiplexRequest.h>
#include <aws/medialive/model/DescribeMultiplexResult.h>
#include <aws/medialive/model/DescribeNetworkRequest.h>
#include <aws/medialive/model/DescribeNetworkSdkResult.h>
#include <aws/medialive/model/DescribeNetworkSummary.h>
#include <aws/medialive/model/DescribeNodeRequest.h>
#include <aws/medialive/model/DescribeNodeSdkResult.h>
#include <aws/medialive/model/DescribeNodeSummary.h>
#include <aws/medialive/model/DescribeOfferingRequest.h>
#include <aws/medialive/model/DescribeOfferingResult.h>
#include <aws/medialive/model/DescribeReservationRequest.h>
#include <aws/medialive/model/DescribeReservationResult.h>
#include <aws/medialive/model/DescribeScheduleRequest.h>
#include <aws/medialive/model/DescribeScheduleResult.h>
#include <aws/medialive/model/DescribeSdiSourceRequest.h>
#include <aws/medialive/model/DescribeSdiSourceResult.h>
#include <aws/medialive/model/DescribeThumbnailsRequest.h>
#include <aws/medialive/model/DescribeThumbnailsResult.h>
#include <aws/medialive/model/DeviceSettingsSyncState.h>
#include <aws/medialive/model/DeviceUpdateStatus.h>
#include <aws/medialive/model/DolbyEProgramSelection.h>
#include <aws/medialive/model/DolbyVision81Settings.h>
#include <aws/medialive/model/DvbDashAccessibility.h>
#include <aws/medialive/model/DvbNitSettings.h>
#include <aws/medialive/model/DvbSdtOutputSdt.h>
#include <aws/medialive/model/DvbSdtSettings.h>
#include <aws/medialive/model/DvbSubDestinationAlignment.h>
#include <aws/medialive/model/DvbSubDestinationBackgroundColor.h>
#include <aws/medialive/model/DvbSubDestinationFontColor.h>
#include <aws/medialive/model/DvbSubDestinationOutlineColor.h>
#include <aws/medialive/model/DvbSubDestinationSettings.h>
#include <aws/medialive/model/DvbSubDestinationShadowColor.h>
#include <aws/medialive/model/DvbSubDestinationTeletextGridControl.h>
#include <aws/medialive/model/DvbSubOcrLanguage.h>
#include <aws/medialive/model/DvbSubSourceSettings.h>
#include <aws/medialive/model/DvbTdtSettings.h>
#include <aws/medialive/model/Eac3AtmosCodingMode.h>
#include <aws/medialive/model/Eac3AtmosDrcLine.h>
#include <aws/medialive/model/Eac3AtmosDrcRf.h>
#include <aws/medialive/model/Eac3AtmosSettings.h>
#include <aws/medialive/model/Eac3AttenuationControl.h>
#include <aws/medialive/model/Eac3BitstreamMode.h>
#include <aws/medialive/model/Eac3CodingMode.h>
#include <aws/medialive/model/Eac3DcFilter.h>
#include <aws/medialive/model/Eac3DrcLine.h>
#include <aws/medialive/model/Eac3DrcRf.h>
#include <aws/medialive/model/Eac3LfeControl.h>
#include <aws/medialive/model/Eac3LfeFilter.h>
#include <aws/medialive/model/Eac3MetadataControl.h>
#include <aws/medialive/model/Eac3PassthroughControl.h>
#include <aws/medialive/model/Eac3PhaseControl.h>
#include <aws/medialive/model/Eac3Settings.h>
#include <aws/medialive/model/Eac3StereoDownmix.h>
#include <aws/medialive/model/Eac3SurroundExMode.h>
#include <aws/medialive/model/Eac3SurroundMode.h>
#include <aws/medialive/model/EbuTtDDestinationSettings.h>
#include <aws/medialive/model/EbuTtDDestinationStyleControl.h>
#include <aws/medialive/model/EbuTtDFillLineGapControl.h>
#include <aws/medialive/model/EmbeddedConvert608To708.h>
#include <aws/medialive/model/EmbeddedDestinationSettings.h>
#include <aws/medialive/model/EmbeddedPlusScte20DestinationSettings.h>
#include <aws/medialive/model/EmbeddedScte20Detection.h>
#include <aws/medialive/model/EmbeddedSourceSettings.h>
#include <aws/medialive/model/EncoderSettings.h>
#include <aws/medialive/model/EpochLockingSettings.h>
#include <aws/medialive/model/Esam.h>
#include <aws/medialive/model/EventBridgeRuleTemplateEventType.h>
#include <aws/medialive/model/EventBridgeRuleTemplateGroupSummary.h>
#include <aws/medialive/model/EventBridgeRuleTemplateSummary.h>
#include <aws/medialive/model/EventBridgeRuleTemplateTarget.h>
#include <aws/medialive/model/FailoverCondition.h>
#include <aws/medialive/model/FailoverConditionSettings.h>
#include <aws/medialive/model/FeatureActivations.h>
#include <aws/medialive/model/FeatureActivationsInputPrepareScheduleActions.h>
#include <aws/medialive/model/FeatureActivationsOutputStaticImageOverlayScheduleActions.h>
#include <aws/medialive/model/FecOutputIncludeFec.h>
#include <aws/medialive/model/FecOutputSettings.h>
#include <aws/medialive/model/FixedAfd.h>
#include <aws/medialive/model/FixedModeScheduleActionStartSettings.h>
#include <aws/medialive/model/Fmp4HlsSettings.h>
#include <aws/medialive/model/Fmp4NielsenId3Behavior.h>
#include <aws/medialive/model/Fmp4TimedMetadataBehavior.h>
#include <aws/medialive/model/FollowModeScheduleActionStartSettings.h>
#include <aws/medialive/model/FollowPoint.h>
#include <aws/medialive/model/FrameCaptureCdnSettings.h>
#include <aws/medialive/model/FrameCaptureGroupSettings.h>
#include <aws/medialive/model/FrameCaptureHlsSettings.h>
#include <aws/medialive/model/FrameCaptureIntervalUnit.h>
#include <aws/medialive/model/FrameCaptureOutputSettings.h>
#include <aws/medialive/model/FrameCaptureS3Settings.h>
#include <aws/medialive/model/FrameCaptureSettings.h>
#include <aws/medialive/model/GetCloudWatchAlarmTemplateGroupRequest.h>
#include <aws/medialive/model/GetCloudWatchAlarmTemplateGroupResult.h>
#include <aws/medialive/model/GetCloudWatchAlarmTemplateRequest.h>
#include <aws/medialive/model/GetCloudWatchAlarmTemplateResult.h>
#include <aws/medialive/model/GetEventBridgeRuleTemplateGroupRequest.h>
#include <aws/medialive/model/GetEventBridgeRuleTemplateGroupResult.h>
#include <aws/medialive/model/GetEventBridgeRuleTemplateRequest.h>
#include <aws/medialive/model/GetEventBridgeRuleTemplateResult.h>
#include <aws/medialive/model/GetSignalMapRequest.h>
#include <aws/medialive/model/GetSignalMapResult.h>
#include <aws/medialive/model/GlobalConfiguration.h>
#include <aws/medialive/model/GlobalConfigurationInputEndAction.h>
#include <aws/medialive/model/GlobalConfigurationLowFramerateInputs.h>
#include <aws/medialive/model/GlobalConfigurationOutputLockingMode.h>
#include <aws/medialive/model/GlobalConfigurationOutputTimingSource.h>
#include <aws/medialive/model/H264AdaptiveQuantization.h>
#include <aws/medialive/model/H264ColorMetadata.h>
#include <aws/medialive/model/H264ColorSpaceSettings.h>
#include <aws/medialive/model/H264EntropyEncoding.h>
#include <aws/medialive/model/H264FilterSettings.h>
#include <aws/medialive/model/H264FlickerAq.h>
#include <aws/medialive/model/H264ForceFieldPictures.h>
#include <aws/medialive/model/H264FramerateControl.h>
#include <aws/medialive/model/H264GopBReference.h>
#include <aws/medialive/model/H264GopSizeUnits.h>
#include <aws/medialive/model/H264Level.h>
#include <aws/medialive/model/H264LookAheadRateControl.h>
#include <aws/medialive/model/H264ParControl.h>
#include <aws/medialive/model/H264Profile.h>
#include <aws/medialive/model/H264QualityLevel.h>
#include <aws/medialive/model/H264RateControlMode.h>
#include <aws/medialive/model/H264ScanType.h>
#include <aws/medialive/model/H264SceneChangeDetect.h>
#include <aws/medialive/model/H264Settings.h>
#include <aws/medialive/model/H264SpatialAq.h>
#include <aws/medialive/model/H264SubGopLength.h>
#include <aws/medialive/model/H264Syntax.h>
#include <aws/medialive/model/H264TemporalAq.h>
#include <aws/medialive/model/H264TimecodeInsertionBehavior.h>
#include <aws/medialive/model/H265AdaptiveQuantization.h>
#include <aws/medialive/model/H265AlternativeTransferFunction.h>
#include <aws/medialive/model/H265ColorMetadata.h>
#include <aws/medialive/model/H265ColorSpaceSettings.h>
#include <aws/medialive/model/H265Deblocking.h>
#include <aws/medialive/model/H265FilterSettings.h>
#include <aws/medialive/model/H265FlickerAq.h>
#include <aws/medialive/model/H265GopSizeUnits.h>
#include <aws/medialive/model/H265Level.h>
#include <aws/medialive/model/H265LookAheadRateControl.h>
#include <aws/medialive/model/H265MvOverPictureBoundaries.h>
#include <aws/medialive/model/H265MvTemporalPredictor.h>
#include <aws/medialive/model/H265Profile.h>
#include <aws/medialive/model/H265RateControlMode.h>
#include <aws/medialive/model/H265ScanType.h>
#include <aws/medialive/model/H265SceneChangeDetect.h>
#include <aws/medialive/model/H265Settings.h>
#include <aws/medialive/model/H265Tier.h>
#include <aws/medialive/model/H265TilePadding.h>
#include <aws/medialive/model/H265TimecodeInsertionBehavior.h>
#include <aws/medialive/model/H265TreeblockSize.h>
#include <aws/medialive/model/Hdr10Settings.h>
#include <aws/medialive/model/HlsAdMarkers.h>
#include <aws/medialive/model/HlsAkamaiHttpTransferMode.h>
#include <aws/medialive/model/HlsAkamaiSettings.h>
#include <aws/medialive/model/HlsBasicPutSettings.h>
#include <aws/medialive/model/HlsCaptionLanguageSetting.h>
#include <aws/medialive/model/HlsCdnSettings.h>
#include <aws/medialive/model/HlsClientCache.h>
#include <aws/medialive/model/HlsCodecSpecification.h>
#include <aws/medialive/model/HlsDirectoryStructure.h>
#include <aws/medialive/model/HlsDiscontinuityTags.h>
#include <aws/medialive/model/HlsEncryptionType.h>
#include <aws/medialive/model/HlsGroupSettings.h>
#include <aws/medialive/model/HlsH265PackagingType.h>
#include <aws/medialive/model/HlsId3SegmentTaggingScheduleActionSettings.h>
#include <aws/medialive/model/HlsId3SegmentTaggingState.h>
#include <aws/medialive/model/HlsIncompleteSegmentBehavior.h>
#include <aws/medialive/model/HlsInputSettings.h>
#include <aws/medialive/model/HlsIvInManifest.h>
#include <aws/medialive/model/HlsIvSource.h>
#include <aws/medialive/model/HlsManifestCompression.h>
#include <aws/medialive/model/HlsManifestDurationFormat.h>
#include <aws/medialive/model/HlsMediaStoreSettings.h>
#include <aws/medialive/model/HlsMediaStoreStorageClass.h>
#include <aws/medialive/model/HlsMode.h>
#include <aws/medialive/model/HlsOutputSelection.h>
#include <aws/medialive/model/HlsOutputSettings.h>
#include <aws/medialive/model/HlsProgramDateTime.h>
#include <aws/medialive/model/HlsProgramDateTimeClock.h>
#include <aws/medialive/model/HlsRedundantManifest.h>
#include <aws/medialive/model/HlsS3Settings.h>
#include <aws/medialive/model/HlsScte35SourceType.h>
#include <aws/medialive/model/HlsSegmentationMode.h>
#include <aws/medialive/model/HlsSettings.h>
#include <aws/medialive/model/HlsStreamInfResolution.h>
#include <aws/medialive/model/HlsTimedMetadataId3Frame.h>
#include <aws/medialive/model/HlsTimedMetadataScheduleActionSettings.h>
#include <aws/medialive/model/HlsTsFileMode.h>
#include <aws/medialive/model/HlsWebdavHttpTransferMode.h>
#include <aws/medialive/model/HlsWebdavSettings.h>
#include <aws/medialive/model/HtmlMotionGraphicsSettings.h>
#include <aws/medialive/model/IFrameOnlyPlaylistType.h>
#include <aws/medialive/model/Id3SegmentTaggingScheduleActionSettings.h>
#include <aws/medialive/model/ImmediateModeScheduleActionStartSettings.h>
#include <aws/medialive/model/IncludeFillerNalUnits.h>
#include <aws/medialive/model/Input.h>
#include <aws/medialive/model/InputAttachment.h>
#include <aws/medialive/model/InputChannelLevel.h>
#include <aws/medialive/model/InputClass.h>
#include <aws/medialive/model/InputClippingSettings.h>
#include <aws/medialive/model/InputCodec.h>
#include <aws/medialive/model/InputDeblockFilter.h>
#include <aws/medialive/model/InputDenoiseFilter.h>
#include <aws/medialive/model/InputDestination.h>
#include <aws/medialive/model/InputDestinationRequest.h>
#include <aws/medialive/model/InputDestinationRoute.h>
#include <aws/medialive/model/InputDestinationVpc.h>
#include <aws/medialive/model/InputDeviceActiveInput.h>
#include <aws/medialive/model/InputDeviceCodec.h>
#include <aws/medialive/model/InputDeviceConfigurableAudioChannelPairConfig.h>
#include <aws/medialive/model/InputDeviceConfigurableAudioChannelPairProfile.h>
#include <aws/medialive/model/InputDeviceConfigurableSettings.h>
#include <aws/medialive/model/InputDeviceConfiguredInput.h>
#include <aws/medialive/model/InputDeviceConnectionState.h>
#include <aws/medialive/model/InputDeviceHdSettings.h>
#include <aws/medialive/model/InputDeviceIpScheme.h>
#include <aws/medialive/model/InputDeviceMediaConnectConfigurableSettings.h>
#include <aws/medialive/model/InputDeviceMediaConnectSettings.h>
#include <aws/medialive/model/InputDeviceNetworkSettings.h>
#include <aws/medialive/model/InputDeviceOutputType.h>
#include <aws/medialive/model/InputDeviceRequest.h>
#include <aws/medialive/model/InputDeviceScanType.h>
#include <aws/medialive/model/InputDeviceSettings.h>
#include <aws/medialive/model/InputDeviceState.h>
#include <aws/medialive/model/InputDeviceSummary.h>
#include <aws/medialive/model/InputDeviceTransferType.h>
#include <aws/medialive/model/InputDeviceType.h>
#include <aws/medialive/model/InputDeviceUhdAudioChannelPairConfig.h>
#include <aws/medialive/model/InputDeviceUhdAudioChannelPairProfile.h>
#include <aws/medialive/model/InputDeviceUhdSettings.h>
#include <aws/medialive/model/InputFilter.h>
#include <aws/medialive/model/InputLocation.h>
#include <aws/medialive/model/InputLossActionForHlsOut.h>
#include <aws/medialive/model/InputLossActionForMsSmoothOut.h>
#include <aws/medialive/model/InputLossActionForRtmpOut.h>
#include <aws/medialive/model/InputLossActionForUdpOut.h>
#include <aws/medialive/model/InputLossBehavior.h>
#include <aws/medialive/model/InputLossFailoverSettings.h>
#include <aws/medialive/model/InputLossImageType.h>
#include <aws/medialive/model/InputMaximumBitrate.h>
#include <aws/medialive/model/InputNetworkLocation.h>
#include <aws/medialive/model/InputPreference.h>
#include <aws/medialive/model/InputPrepareScheduleActionSettings.h>
#include <aws/medialive/model/InputRequestDestinationRoute.h>
#include <aws/medialive/model/InputResolution.h>
#include <aws/medialive/model/InputSdpLocation.h>
#include <aws/medialive/model/InputSecurityGroup.h>
#include <aws/medialive/model/InputSecurityGroupState.h>
#include <aws/medialive/model/InputSettings.h>
#include <aws/medialive/model/InputSource.h>
#include <aws/medialive/model/InputSourceEndBehavior.h>
#include <aws/medialive/model/InputSourceRequest.h>
#include <aws/medialive/model/InputSourceType.h>
#include <aws/medialive/model/InputSpecification.h>
#include <aws/medialive/model/InputState.h>
#include <aws/medialive/model/InputSwitchScheduleActionSettings.h>
#include <aws/medialive/model/InputTimecodeSource.h>
#include <aws/medialive/model/InputType.h>
#include <aws/medialive/model/InputVpcRequest.h>
#include <aws/medialive/model/InputWhitelistRule.h>
#include <aws/medialive/model/InputWhitelistRuleCidr.h>
#include <aws/medialive/model/InterfaceMapping.h>
#include <aws/medialive/model/InterfaceMappingCreateRequest.h>
#include <aws/medialive/model/InterfaceMappingUpdateRequest.h>
#include <aws/medialive/model/IpPool.h>
#include <aws/medialive/model/IpPoolCreateRequest.h>
#include <aws/medialive/model/IpPoolUpdateRequest.h>
#include <aws/medialive/model/KeyProviderSettings.h>
#include <aws/medialive/model/LastFrameClippingBehavior.h>
#include <aws/medialive/model/ListChannelPlacementGroupsRequest.h>
#include <aws/medialive/model/ListChannelPlacementGroupsSdkResult.h>
#include <aws/medialive/model/ListChannelsRequest.h>
#include <aws/medialive/model/ListChannelsResult.h>
#include <aws/medialive/model/ListCloudWatchAlarmTemplateGroupsRequest.h>
#include <aws/medialive/model/ListCloudWatchAlarmTemplateGroupsResult.h>
#include <aws/medialive/model/ListCloudWatchAlarmTemplatesRequest.h>
#include <aws/medialive/model/ListCloudWatchAlarmTemplatesResult.h>
#include <aws/medialive/model/ListClustersRequest.h>
#include <aws/medialive/model/ListClustersSdkResult.h>
#include <aws/medialive/model/ListEventBridgeRuleTemplateGroupsRequest.h>
#include <aws/medialive/model/ListEventBridgeRuleTemplateGroupsResult.h>
#include <aws/medialive/model/ListEventBridgeRuleTemplatesRequest.h>
#include <aws/medialive/model/ListEventBridgeRuleTemplatesResult.h>
#include <aws/medialive/model/ListInputDeviceTransfersRequest.h>
#include <aws/medialive/model/ListInputDeviceTransfersResult.h>
#include <aws/medialive/model/ListInputDevicesRequest.h>
#include <aws/medialive/model/ListInputDevicesResult.h>
#include <aws/medialive/model/ListInputSecurityGroupsRequest.h>
#include <aws/medialive/model/ListInputSecurityGroupsResult.h>
#include <aws/medialive/model/ListInputsRequest.h>
#include <aws/medialive/model/ListInputsResult.h>
#include <aws/medialive/model/ListMultiplexProgramsRequest.h>
#include <aws/medialive/model/ListMultiplexProgramsResult.h>
#include <aws/medialive/model/ListMultiplexesRequest.h>
#include <aws/medialive/model/ListMultiplexesResult.h>
#include <aws/medialive/model/ListNetworksRequest.h>
#include <aws/medialive/model/ListNetworksSdkResult.h>
#include <aws/medialive/model/ListNodesRequest.h>
#include <aws/medialive/model/ListNodesSdkResult.h>
#include <aws/medialive/model/ListOfferingsRequest.h>
#include <aws/medialive/model/ListOfferingsResult.h>
#include <aws/medialive/model/ListReservationsRequest.h>
#include <aws/medialive/model/ListReservationsResult.h>
#include <aws/medialive/model/ListSdiSourcesRequest.h>
#include <aws/medialive/model/ListSdiSourcesResult.h>
#include <aws/medialive/model/ListSignalMapsRequest.h>
#include <aws/medialive/model/ListSignalMapsResult.h>
#include <aws/medialive/model/ListTagsForResourceRequest.h>
#include <aws/medialive/model/ListTagsForResourceResult.h>
#include <aws/medialive/model/ListVersionsRequest.h>
#include <aws/medialive/model/ListVersionsResult.h>
#include <aws/medialive/model/LogLevel.h>
#include <aws/medialive/model/M2tsAbsentInputAudioBehavior.h>
#include <aws/medialive/model/M2tsArib.h>
#include <aws/medialive/model/M2tsAribCaptionsPidControl.h>
#include <aws/medialive/model/M2tsAudioBufferModel.h>
#include <aws/medialive/model/M2tsAudioInterval.h>
#include <aws/medialive/model/M2tsAudioStreamType.h>
#include <aws/medialive/model/M2tsBufferModel.h>
#include <aws/medialive/model/M2tsCcDescriptor.h>
#include <aws/medialive/model/M2tsEbifControl.h>
#include <aws/medialive/model/M2tsEbpPlacement.h>
#include <aws/medialive/model/M2tsEsRateInPes.h>
#include <aws/medialive/model/M2tsKlv.h>
#include <aws/medialive/model/M2tsNielsenId3Behavior.h>
#include <aws/medialive/model/M2tsPcrControl.h>
#include <aws/medialive/model/M2tsRateMode.h>
#include <aws/medialive/model/M2tsScte35Control.h>
#include <aws/medialive/model/M2tsSegmentationMarkers.h>
#include <aws/medialive/model/M2tsSegmentationStyle.h>
#include <aws/medialive/model/M2tsSettings.h>
#include <aws/medialive/model/M2tsTimedMetadataBehavior.h>
#include <aws/medialive/model/M3u8KlvBehavior.h>
#include <aws/medialive/model/M3u8NielsenId3Behavior.h>
#include <aws/medialive/model/M3u8PcrControl.h>
#include <aws/medialive/model/M3u8Scte35Behavior.h>
#include <aws/medialive/model/M3u8Settings.h>
#include <aws/medialive/model/M3u8TimedMetadataBehavior.h>
#include <aws/medialive/model/MaintenanceCreateSettings.h>
#include <aws/medialive/model/MaintenanceDay.h>
#include <aws/medialive/model/MaintenanceStatus.h>
#include <aws/medialive/model/MaintenanceUpdateSettings.h>
#include <aws/medialive/model/MediaConnectFlow.h>
#include <aws/medialive/model/MediaConnectFlowRequest.h>
#include <aws/medialive/model/MediaPackageGroupSettings.h>
#include <aws/medialive/model/MediaPackageOutputDestinationSettings.h>
#include <aws/medialive/model/MediaPackageOutputSettings.h>
#include <aws/medialive/model/MediaResource.h>
#include <aws/medialive/model/MediaResourceNeighbor.h>
#include <aws/medialive/model/MonitorDeployment.h>
#include <aws/medialive/model/MotionGraphicsActivateScheduleActionSettings.h>
#include <aws/medialive/model/MotionGraphicsConfiguration.h>
#include <aws/medialive/model/MotionGraphicsDeactivateScheduleActionSettings.h>
#include <aws/medialive/model/MotionGraphicsInsertion.h>
#include <aws/medialive/model/MotionGraphicsSettings.h>
#include <aws/medialive/model/Mp2CodingMode.h>
#include <aws/medialive/model/Mp2Settings.h>
#include <aws/medialive/model/Mpeg2AdaptiveQuantization.h>
#include <aws/medialive/model/Mpeg2ColorMetadata.h>
#include <aws/medialive/model/Mpeg2ColorSpace.h>
#include <aws/medialive/model/Mpeg2DisplayRatio.h>
#include <aws/medialive/model/Mpeg2FilterSettings.h>
#include <aws/medialive/model/Mpeg2GopSizeUnits.h>
#include <aws/medialive/model/Mpeg2ScanType.h>
#include <aws/medialive/model/Mpeg2Settings.h>
#include <aws/medialive/model/Mpeg2SubGopLength.h>
#include <aws/medialive/model/Mpeg2TimecodeInsertionBehavior.h>
#include <aws/medialive/model/MsSmoothGroupSettings.h>
#include <aws/medialive/model/MsSmoothH265PackagingType.h>
#include <aws/medialive/model/MsSmoothOutputSettings.h>
#include <aws/medialive/model/MulticastInputSettings.h>
#include <aws/medialive/model/MulticastSettings.h>
#include <aws/medialive/model/MulticastSettingsCreateRequest.h>
#include <aws/medialive/model/MulticastSettingsUpdateRequest.h>
#include <aws/medialive/model/MulticastSource.h>
#include <aws/medialive/model/MulticastSourceCreateRequest.h>
#include <aws/medialive/model/MulticastSourceUpdateRequest.h>
#include <aws/medialive/model/Multiplex.h>
#include <aws/medialive/model/MultiplexContainerSettings.h>
#include <aws/medialive/model/MultiplexGroupSettings.h>
#include <aws/medialive/model/MultiplexM2tsSettings.h>
#include <aws/medialive/model/MultiplexMediaConnectOutputDestinationSettings.h>
#include <aws/medialive/model/MultiplexOutputDestination.h>
#include <aws/medialive/model/MultiplexOutputSettings.h>
#include <aws/medialive/model/MultiplexProgram.h>
#include <aws/medialive/model/MultiplexProgramChannelDestinationSettings.h>
#include <aws/medialive/model/MultiplexProgramPacketIdentifiersMap.h>
#include <aws/medialive/model/MultiplexProgramPipelineDetail.h>
#include <aws/medialive/model/MultiplexProgramServiceDescriptor.h>
#include <aws/medialive/model/MultiplexProgramSettings.h>
#include <aws/medialive/model/MultiplexProgramSummary.h>
#include <aws/medialive/model/MultiplexSettings.h>
#include <aws/medialive/model/MultiplexSettingsSummary.h>
#include <aws/medialive/model/MultiplexState.h>
#include <aws/medialive/model/MultiplexStatmuxVideoSettings.h>
#include <aws/medialive/model/MultiplexSummary.h>
#include <aws/medialive/model/MultiplexVideoSettings.h>
#include <aws/medialive/model/NetworkInputServerValidation.h>
#include <aws/medialive/model/NetworkInputSettings.h>
#include <aws/medialive/model/NetworkInterfaceMode.h>
#include <aws/medialive/model/NetworkState.h>
#include <aws/medialive/model/NielsenCBET.h>
#include <aws/medialive/model/NielsenConfiguration.h>
#include <aws/medialive/model/NielsenNaesIiNw.h>
#include <aws/medialive/model/NielsenPcmToId3TaggingState.h>
#include <aws/medialive/model/NielsenWatermarkTimezones.h>
#include <aws/medialive/model/NielsenWatermarksCbetStepaside.h>
#include <aws/medialive/model/NielsenWatermarksDistributionTypes.h>
#include <aws/medialive/model/NielsenWatermarksSettings.h>
#include <aws/medialive/model/NodeConnectionState.h>
#include <aws/medialive/model/NodeInterfaceMapping.h>
#include <aws/medialive/model/NodeInterfaceMappingCreateRequest.h>
#include <aws/medialive/model/NodeRole.h>
#include <aws/medialive/model/NodeState.h>
#include <aws/medialive/model/Offering.h>
#include <aws/medialive/model/OfferingDurationUnits.h>
#include <aws/medialive/model/OfferingType.h>
#include <aws/medialive/model/Output.h>
#include <aws/medialive/model/OutputDestination.h>
#include <aws/medialive/model/OutputDestinationSettings.h>
#include <aws/medialive/model/OutputGroup.h>
#include <aws/medialive/model/OutputGroupSettings.h>
#include <aws/medialive/model/OutputLocationRef.h>
#include <aws/medialive/model/OutputLockingSettings.h>
#include <aws/medialive/model/OutputSettings.h>
#include <aws/medialive/model/PassThroughSettings.h>
#include <aws/medialive/model/PauseStateScheduleActionSettings.h>
#include <aws/medialive/model/PipelineDetail.h>
#include <aws/medialive/model/PipelineId.h>
#include <aws/medialive/model/PipelineLockingSettings.h>
#include <aws/medialive/model/PipelinePauseStateSettings.h>
#include <aws/medialive/model/PreferredChannelPipeline.h>
#include <aws/medialive/model/PurchaseOfferingRequest.h>
#include <aws/medialive/model/PurchaseOfferingResult.h>
#include <aws/medialive/model/RawSettings.h>
#include <aws/medialive/model/RebootInputDeviceForce.h>
#include <aws/medialive/model/RebootInputDeviceRequest.h>
#include <aws/medialive/model/RebootInputDeviceResult.h>
#include <aws/medialive/model/Rec601Settings.h>
#include <aws/medialive/model/Rec709Settings.h>
#include <aws/medialive/model/RejectInputDeviceTransferRequest.h>
#include <aws/medialive/model/RejectInputDeviceTransferResult.h>
#include <aws/medialive/model/RemixSettings.h>
#include <aws/medialive/model/RenewalSettings.h>
#include <aws/medialive/model/Reservation.h>
#include <aws/medialive/model/ReservationAutomaticRenewal.h>
#include <aws/medialive/model/ReservationCodec.h>
#include <aws/medialive/model/ReservationMaximumBitrate.h>
#include <aws/medialive/model/ReservationMaximumFramerate.h>
#include <aws/medialive/model/ReservationResolution.h>
#include <aws/medialive/model/ReservationResourceSpecification.h>
#include <aws/medialive/model/ReservationResourceType.h>
#include <aws/medialive/model/ReservationSpecialFeature.h>
#include <aws/medialive/model/ReservationState.h>
#include <aws/medialive/model/ReservationVideoQuality.h>
#include <aws/medialive/model/RestartChannelPipelinesRequest.h>
#include <aws/medialive/model/RestartChannelPipelinesResult.h>
#include <aws/medialive/model/Route.h>
#include <aws/medialive/model/RouteCreateRequest.h>
#include <aws/medialive/model/RouteUpdateRequest.h>
#include <aws/medialive/model/RtmpAdMarkers.h>
#include <aws/medialive/model/RtmpCacheFullBehavior.h>
#include <aws/medialive/model/RtmpCaptionData.h>
#include <aws/medialive/model/RtmpCaptionInfoDestinationSettings.h>
#include <aws/medialive/model/RtmpGroupSettings.h>
#include <aws/medialive/model/RtmpOutputCertificateMode.h>
#include <aws/medialive/model/RtmpOutputSettings.h>
#include <aws/medialive/model/S3CannedAcl.h>
#include <aws/medialive/model/ScheduleAction.h>
#include <aws/medialive/model/ScheduleActionSettings.h>
#include <aws/medialive/model/ScheduleActionStartSettings.h>
#include <aws/medialive/model/Scte20Convert608To708.h>
#include <aws/medialive/model/Scte20PlusEmbeddedDestinationSettings.h>
#include <aws/medialive/model/Scte20SourceSettings.h>
#include <aws/medialive/model/Scte27DestinationSettings.h>
#include <aws/medialive/model/Scte27OcrLanguage.h>
#include <aws/medialive/model/Scte27SourceSettings.h>
#include <aws/medialive/model/Scte35AposNoRegionalBlackoutBehavior.h>
#include <aws/medialive/model/Scte35AposWebDeliveryAllowedBehavior.h>
#include <aws/medialive/model/Scte35ArchiveAllowedFlag.h>
#include <aws/medialive/model/Scte35DeliveryRestrictions.h>
#include <aws/medialive/model/Scte35Descriptor.h>
#include <aws/medialive/model/Scte35DescriptorSettings.h>
#include <aws/medialive/model/Scte35DeviceRestrictions.h>
#include <aws/medialive/model/Scte35InputMode.h>
#include <aws/medialive/model/Scte35InputScheduleActionSettings.h>
#include <aws/medialive/model/Scte35NoRegionalBlackoutFlag.h>
#include <aws/medialive/model/Scte35ReturnToNetworkScheduleActionSettings.h>
#include <aws/medialive/model/Scte35SegmentationCancelIndicator.h>
#include <aws/medialive/model/Scte35SegmentationDescriptor.h>
#include <aws/medialive/model/Scte35SegmentationScope.h>
#include <aws/medialive/model/Scte35SpliceInsert.h>
#include <aws/medialive/model/Scte35SpliceInsertNoRegionalBlackoutBehavior.h>
#include <aws/medialive/model/Scte35SpliceInsertScheduleActionSettings.h>
#include <aws/medialive/model/Scte35SpliceInsertWebDeliveryAllowedBehavior.h>
#include <aws/medialive/model/Scte35TimeSignalApos.h>
#include <aws/medialive/model/Scte35TimeSignalScheduleActionSettings.h>
#include <aws/medialive/model/Scte35Type.h>
#include <aws/medialive/model/Scte35WebDeliveryAllowedFlag.h>
#include <aws/medialive/model/SdiSource.h>
#include <aws/medialive/model/SdiSourceMapping.h>
#include <aws/medialive/model/SdiSourceMappingUpdateRequest.h>
#include <aws/medialive/model/SdiSourceMode.h>
#include <aws/medialive/model/SdiSourceState.h>
#include <aws/medialive/model/SdiSourceSummary.h>
#include <aws/medialive/model/SdiSourceType.h>
#include <aws/medialive/model/SignalMapMonitorDeploymentStatus.h>
#include <aws/medialive/model/SignalMapStatus.h>
#include <aws/medialive/model/SignalMapSummary.h>
#include <aws/medialive/model/SmoothGroupAudioOnlyTimecodeControl.h>
#include <aws/medialive/model/SmoothGroupCertificateMode.h>
#include <aws/medialive/model/SmoothGroupEventIdMode.h>
#include <aws/medialive/model/SmoothGroupEventStopBehavior.h>
#include <aws/medialive/model/SmoothGroupSegmentationMode.h>
#include <aws/medialive/model/SmoothGroupSparseTrackType.h>
#include <aws/medialive/model/SmoothGroupStreamManifestBehavior.h>
#include <aws/medialive/model/SmoothGroupTimestampOffsetMode.h>
#include <aws/medialive/model/Smpte2038DataPreference.h>
#include <aws/medialive/model/Smpte2110ReceiverGroup.h>
#include <aws/medialive/model/Smpte2110ReceiverGroupSdpSettings.h>
#include <aws/medialive/model/Smpte2110ReceiverGroupSettings.h>
#include <aws/medialive/model/SmpteTtDestinationSettings.h>
#include <aws/medialive/model/SrtCallerDecryption.h>
#include <aws/medialive/model/SrtCallerDecryptionRequest.h>
#include <aws/medialive/model/SrtCallerSource.h>
#include <aws/medialive/model/SrtCallerSourceRequest.h>
#include <aws/medialive/model/SrtEncryptionType.h>
#include <aws/medialive/model/SrtGroupSettings.h>
#include <aws/medialive/model/SrtOutputDestinationSettings.h>
#include <aws/medialive/model/SrtOutputSettings.h>
#include <aws/medialive/model/SrtSettings.h>
#include <aws/medialive/model/SrtSettingsRequest.h>
#include <aws/medialive/model/StandardHlsSettings.h>
#include <aws/medialive/model/StartChannelRequest.h>
#include <aws/medialive/model/StartChannelResult.h>
#include <aws/medialive/model/StartDeleteMonitorDeploymentRequest.h>
#include <aws/medialive/model/StartDeleteMonitorDeploymentResult.h>
#include <aws/medialive/model/StartInputDeviceMaintenanceWindowRequest.h>
#include <aws/medialive/model/StartInputDeviceMaintenanceWindowResult.h>
#include <aws/medialive/model/StartInputDeviceRequest.h>
#include <aws/medialive/model/StartInputDeviceResult.h>
#include <aws/medialive/model/StartMonitorDeploymentRequest.h>
#include <aws/medialive/model/StartMonitorDeploymentResult.h>
#include <aws/medialive/model/StartMultiplexRequest.h>
#include <aws/medialive/model/StartMultiplexResult.h>
#include <aws/medialive/model/StartTimecode.h>
#include <aws/medialive/model/StartUpdateSignalMapRequest.h>
#include <aws/medialive/model/StartUpdateSignalMapResult.h>
#include <aws/medialive/model/StaticImageActivateScheduleActionSettings.h>
#include <aws/medialive/model/StaticImageDeactivateScheduleActionSettings.h>
#include <aws/medialive/model/StaticImageOutputActivateScheduleActionSettings.h>
#include <aws/medialive/model/StaticImageOutputDeactivateScheduleActionSettings.h>
#include <aws/medialive/model/StaticKeySettings.h>
#include <aws/medialive/model/StopChannelRequest.h>
#include <aws/medialive/model/StopChannelResult.h>
#include <aws/medialive/model/StopInputDeviceRequest.h>
#include <aws/medialive/model/StopInputDeviceResult.h>
#include <aws/medialive/model/StopMultiplexRequest.h>
#include <aws/medialive/model/StopMultiplexResult.h>
#include <aws/medialive/model/StopTimecode.h>
#include <aws/medialive/model/SuccessfulMonitorDeployment.h>
#include <aws/medialive/model/TeletextDestinationSettings.h>
#include <aws/medialive/model/TeletextSourceSettings.h>
#include <aws/medialive/model/TemporalFilterPostFilterSharpening.h>
#include <aws/medialive/model/TemporalFilterSettings.h>
#include <aws/medialive/model/TemporalFilterStrength.h>
#include <aws/medialive/model/Thumbnail.h>
#include <aws/medialive/model/ThumbnailConfiguration.h>
#include <aws/medialive/model/ThumbnailDetail.h>
#include <aws/medialive/model/ThumbnailState.h>
#include <aws/medialive/model/ThumbnailType.h>
#include <aws/medialive/model/TimecodeBurninFontSize.h>
#include <aws/medialive/model/TimecodeBurninPosition.h>
#include <aws/medialive/model/TimecodeBurninSettings.h>
#include <aws/medialive/model/TimecodeConfig.h>
#include <aws/medialive/model/TimecodeConfigSource.h>
#include <aws/medialive/model/TimedMetadataScheduleActionSettings.h>
#include <aws/medialive/model/TransferInputDeviceRequest.h>
#include <aws/medialive/model/TransferInputDeviceResult.h>
#include <aws/medialive/model/TransferringInputDeviceSummary.h>
#include <aws/medialive/model/TtmlDestinationSettings.h>
#include <aws/medialive/model/TtmlDestinationStyleControl.h>
#include <aws/medialive/model/UdpContainerSettings.h>
#include <aws/medialive/model/UdpGroupSettings.h>
#include <aws/medialive/model/UdpOutputSettings.h>
#include <aws/medialive/model/UdpTimedMetadataId3Frame.h>
#include <aws/medialive/model/UnprocessableEntityException.h>
#include <aws/medialive/model/UpdateAccountConfigurationRequest.h>
#include <aws/medialive/model/UpdateAccountConfigurationResult.h>
#include <aws/medialive/model/UpdateChannelClassRequest.h>
#include <aws/medialive/model/UpdateChannelClassResult.h>
#include <aws/medialive/model/UpdateChannelPlacementGroupRequest.h>
#include <aws/medialive/model/UpdateChannelPlacementGroupResult.h>
#include <aws/medialive/model/UpdateChannelRequest.h>
#include <aws/medialive/model/UpdateChannelResult.h>
#include <aws/medialive/model/UpdateCloudWatchAlarmTemplateGroupRequest.h>
#include <aws/medialive/model/UpdateCloudWatchAlarmTemplateGroupResult.h>
#include <aws/medialive/model/UpdateCloudWatchAlarmTemplateRequest.h>
#include <aws/medialive/model/UpdateCloudWatchAlarmTemplateResult.h>
#include <aws/medialive/model/UpdateClusterRequest.h>
#include <aws/medialive/model/UpdateClusterSdkResult.h>
#include <aws/medialive/model/UpdateEventBridgeRuleTemplateGroupRequest.h>
#include <aws/medialive/model/UpdateEventBridgeRuleTemplateGroupResult.h>
#include <aws/medialive/model/UpdateEventBridgeRuleTemplateRequest.h>
#include <aws/medialive/model/UpdateEventBridgeRuleTemplateResult.h>
#include <aws/medialive/model/UpdateInputDeviceRequest.h>
#include <aws/medialive/model/UpdateInputDeviceResult.h>
#include <aws/medialive/model/UpdateInputRequest.h>
#include <aws/medialive/model/UpdateInputResult.h>
#include <aws/medialive/model/UpdateInputSecurityGroupRequest.h>
#include <aws/medialive/model/UpdateInputSecurityGroupResult.h>
#include <aws/medialive/model/UpdateMultiplexProgramRequest.h>
#include <aws/medialive/model/UpdateMultiplexProgramResult.h>
#include <aws/medialive/model/UpdateMultiplexRequest.h>
#include <aws/medialive/model/UpdateMultiplexResult.h>
#include <aws/medialive/model/UpdateNetworkRequest.h>
#include <aws/medialive/model/UpdateNetworkSdkResult.h>
#include <aws/medialive/model/UpdateNodeRequest.h>
#include <aws/medialive/model/UpdateNodeResult.h>
#include <aws/medialive/model/UpdateNodeState.h>
#include <aws/medialive/model/UpdateNodeStateRequest.h>
#include <aws/medialive/model/UpdateNodeStateResult.h>
#include <aws/medialive/model/UpdateReservationRequest.h>
#include <aws/medialive/model/UpdateReservationResult.h>
#include <aws/medialive/model/UpdateSdiSourceRequest.h>
#include <aws/medialive/model/UpdateSdiSourceResult.h>
#include <aws/medialive/model/ValidationError.h>
#include <aws/medialive/model/VideoBlackFailoverSettings.h>
#include <aws/medialive/model/VideoCodecSettings.h>
#include <aws/medialive/model/VideoDescription.h>
#include <aws/medialive/model/VideoDescriptionRespondToAfd.h>
#include <aws/medialive/model/VideoDescriptionScalingBehavior.h>
#include <aws/medialive/model/VideoSelector.h>
#include <aws/medialive/model/VideoSelectorColorSpace.h>
#include <aws/medialive/model/VideoSelectorColorSpaceSettings.h>
#include <aws/medialive/model/VideoSelectorColorSpaceUsage.h>
#include <aws/medialive/model/VideoSelectorPid.h>
#include <aws/medialive/model/VideoSelectorProgramId.h>
#include <aws/medialive/model/VideoSelectorSettings.h>
#include <aws/medialive/model/VpcOutputSettings.h>
#include <aws/medialive/model/VpcOutputSettingsDescription.h>
#include <aws/medialive/model/WavCodingMode.h>
#include <aws/medialive/model/WavSettings.h>
#include <aws/medialive/model/WebvttDestinationSettings.h>
#include <aws/medialive/model/WebvttDestinationStyleControl.h>

using MediaLiveIncludeTest = ::testing::Test;

TEST_F(MediaLiveIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::MediaLive::MediaLiveClient>("MediaLiveIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
