/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/mediatailor/MediaTailorClient.h>
#include <aws/mediatailor/MediaTailorEndpointProvider.h>
#include <aws/mediatailor/MediaTailorEndpointRules.h>
#include <aws/mediatailor/MediaTailorErrorMarshaller.h>
#include <aws/mediatailor/MediaTailorErrors.h>
#include <aws/mediatailor/MediaTailorRequest.h>
#include <aws/mediatailor/MediaTailorServiceClientModel.h>
#include <aws/mediatailor/MediaTailor_EXPORTS.h>
#include <aws/mediatailor/model/AccessConfiguration.h>
#include <aws/mediatailor/model/AccessType.h>
#include <aws/mediatailor/model/AdBreak.h>
#include <aws/mediatailor/model/AdBreakOpportunity.h>
#include <aws/mediatailor/model/AdConditioningConfiguration.h>
#include <aws/mediatailor/model/AdMarkerPassthrough.h>
#include <aws/mediatailor/model/AdMarkupType.h>
#include <aws/mediatailor/model/AdsInteractionExcludeEventType.h>
#include <aws/mediatailor/model/AdsInteractionLog.h>
#include <aws/mediatailor/model/AdsInteractionPublishOptInEventType.h>
#include <aws/mediatailor/model/Alert.h>
#include <aws/mediatailor/model/AlertCategory.h>
#include <aws/mediatailor/model/AlternateMedia.h>
#include <aws/mediatailor/model/AudienceMedia.h>
#include <aws/mediatailor/model/AvailMatchingCriteria.h>
#include <aws/mediatailor/model/AvailSuppression.h>
#include <aws/mediatailor/model/Bumper.h>
#include <aws/mediatailor/model/CdnConfiguration.h>
#include <aws/mediatailor/model/Channel.h>
#include <aws/mediatailor/model/ChannelState.h>
#include <aws/mediatailor/model/ClipRange.h>
#include <aws/mediatailor/model/ConfigureLogsForChannelRequest.h>
#include <aws/mediatailor/model/ConfigureLogsForChannelResult.h>
#include <aws/mediatailor/model/ConfigureLogsForPlaybackConfigurationRequest.h>
#include <aws/mediatailor/model/ConfigureLogsForPlaybackConfigurationResult.h>
#include <aws/mediatailor/model/CreateChannelRequest.h>
#include <aws/mediatailor/model/CreateChannelResult.h>
#include <aws/mediatailor/model/CreateLiveSourceRequest.h>
#include <aws/mediatailor/model/CreateLiveSourceResult.h>
#include <aws/mediatailor/model/CreatePrefetchScheduleRequest.h>
#include <aws/mediatailor/model/CreatePrefetchScheduleResult.h>
#include <aws/mediatailor/model/CreateProgramRequest.h>
#include <aws/mediatailor/model/CreateProgramResult.h>
#include <aws/mediatailor/model/CreateSourceLocationRequest.h>
#include <aws/mediatailor/model/CreateSourceLocationResult.h>
#include <aws/mediatailor/model/CreateVodSourceRequest.h>
#include <aws/mediatailor/model/CreateVodSourceResult.h>
#include <aws/mediatailor/model/DashConfiguration.h>
#include <aws/mediatailor/model/DashConfigurationForPut.h>
#include <aws/mediatailor/model/DashPlaylistSettings.h>
#include <aws/mediatailor/model/DefaultSegmentDeliveryConfiguration.h>
#include <aws/mediatailor/model/DeleteChannelPolicyRequest.h>
#include <aws/mediatailor/model/DeleteChannelPolicyResult.h>
#include <aws/mediatailor/model/DeleteChannelRequest.h>
#include <aws/mediatailor/model/DeleteChannelResult.h>
#include <aws/mediatailor/model/DeleteLiveSourceRequest.h>
#include <aws/mediatailor/model/DeleteLiveSourceResult.h>
#include <aws/mediatailor/model/DeletePlaybackConfigurationRequest.h>
#include <aws/mediatailor/model/DeletePlaybackConfigurationResult.h>
#include <aws/mediatailor/model/DeletePrefetchScheduleRequest.h>
#include <aws/mediatailor/model/DeletePrefetchScheduleResult.h>
#include <aws/mediatailor/model/DeleteProgramRequest.h>
#include <aws/mediatailor/model/DeleteProgramResult.h>
#include <aws/mediatailor/model/DeleteSourceLocationRequest.h>
#include <aws/mediatailor/model/DeleteSourceLocationResult.h>
#include <aws/mediatailor/model/DeleteVodSourceRequest.h>
#include <aws/mediatailor/model/DeleteVodSourceResult.h>
#include <aws/mediatailor/model/DescribeChannelRequest.h>
#include <aws/mediatailor/model/DescribeChannelResult.h>
#include <aws/mediatailor/model/DescribeLiveSourceRequest.h>
#include <aws/mediatailor/model/DescribeLiveSourceResult.h>
#include <aws/mediatailor/model/DescribeProgramRequest.h>
#include <aws/mediatailor/model/DescribeProgramResult.h>
#include <aws/mediatailor/model/DescribeSourceLocationRequest.h>
#include <aws/mediatailor/model/DescribeSourceLocationResult.h>
#include <aws/mediatailor/model/DescribeVodSourceRequest.h>
#include <aws/mediatailor/model/DescribeVodSourceResult.h>
#include <aws/mediatailor/model/FillPolicy.h>
#include <aws/mediatailor/model/GetChannelPolicyRequest.h>
#include <aws/mediatailor/model/GetChannelPolicyResult.h>
#include <aws/mediatailor/model/GetChannelScheduleRequest.h>
#include <aws/mediatailor/model/GetChannelScheduleResult.h>
#include <aws/mediatailor/model/GetPlaybackConfigurationRequest.h>
#include <aws/mediatailor/model/GetPlaybackConfigurationResult.h>
#include <aws/mediatailor/model/GetPrefetchScheduleRequest.h>
#include <aws/mediatailor/model/GetPrefetchScheduleResult.h>
#include <aws/mediatailor/model/HlsConfiguration.h>
#include <aws/mediatailor/model/HlsPlaylistSettings.h>
#include <aws/mediatailor/model/HttpConfiguration.h>
#include <aws/mediatailor/model/HttpPackageConfiguration.h>
#include <aws/mediatailor/model/InsertionMode.h>
#include <aws/mediatailor/model/KeyValuePair.h>
#include <aws/mediatailor/model/ListAlertsRequest.h>
#include <aws/mediatailor/model/ListAlertsResult.h>
#include <aws/mediatailor/model/ListChannelsRequest.h>
#include <aws/mediatailor/model/ListChannelsResult.h>
#include <aws/mediatailor/model/ListLiveSourcesRequest.h>
#include <aws/mediatailor/model/ListLiveSourcesResult.h>
#include <aws/mediatailor/model/ListPlaybackConfigurationsRequest.h>
#include <aws/mediatailor/model/ListPlaybackConfigurationsResult.h>
#include <aws/mediatailor/model/ListPrefetchScheduleType.h>
#include <aws/mediatailor/model/ListPrefetchSchedulesRequest.h>
#include <aws/mediatailor/model/ListPrefetchSchedulesResult.h>
#include <aws/mediatailor/model/ListSourceLocationsRequest.h>
#include <aws/mediatailor/model/ListSourceLocationsResult.h>
#include <aws/mediatailor/model/ListTagsForResourceRequest.h>
#include <aws/mediatailor/model/ListTagsForResourceResult.h>
#include <aws/mediatailor/model/ListVodSourcesRequest.h>
#include <aws/mediatailor/model/ListVodSourcesResult.h>
#include <aws/mediatailor/model/LivePreRollConfiguration.h>
#include <aws/mediatailor/model/LiveSource.h>
#include <aws/mediatailor/model/LogConfiguration.h>
#include <aws/mediatailor/model/LogConfigurationForChannel.h>
#include <aws/mediatailor/model/LogType.h>
#include <aws/mediatailor/model/LoggingStrategy.h>
#include <aws/mediatailor/model/ManifestProcessingRules.h>
#include <aws/mediatailor/model/ManifestServiceExcludeEventType.h>
#include <aws/mediatailor/model/ManifestServiceInteractionLog.h>
#include <aws/mediatailor/model/MessageType.h>
#include <aws/mediatailor/model/Mode.h>
#include <aws/mediatailor/model/Operator.h>
#include <aws/mediatailor/model/OriginManifestType.h>
#include <aws/mediatailor/model/PlaybackConfiguration.h>
#include <aws/mediatailor/model/PlaybackMode.h>
#include <aws/mediatailor/model/PrefetchConsumption.h>
#include <aws/mediatailor/model/PrefetchRetrieval.h>
#include <aws/mediatailor/model/PrefetchSchedule.h>
#include <aws/mediatailor/model/PrefetchScheduleType.h>
#include <aws/mediatailor/model/PutChannelPolicyRequest.h>
#include <aws/mediatailor/model/PutChannelPolicyResult.h>
#include <aws/mediatailor/model/PutPlaybackConfigurationRequest.h>
#include <aws/mediatailor/model/PutPlaybackConfigurationResult.h>
#include <aws/mediatailor/model/RecurringConsumption.h>
#include <aws/mediatailor/model/RecurringPrefetchConfiguration.h>
#include <aws/mediatailor/model/RecurringRetrieval.h>
#include <aws/mediatailor/model/RelativePosition.h>
#include <aws/mediatailor/model/RequestOutputItem.h>
#include <aws/mediatailor/model/ResponseOutputItem.h>
#include <aws/mediatailor/model/ScheduleAdBreak.h>
#include <aws/mediatailor/model/ScheduleConfiguration.h>
#include <aws/mediatailor/model/ScheduleEntry.h>
#include <aws/mediatailor/model/ScheduleEntryType.h>
#include <aws/mediatailor/model/SecretsManagerAccessTokenConfiguration.h>
#include <aws/mediatailor/model/SegmentDeliveryConfiguration.h>
#include <aws/mediatailor/model/SegmentationDescriptor.h>
#include <aws/mediatailor/model/SlateSource.h>
#include <aws/mediatailor/model/SourceLocation.h>
#include <aws/mediatailor/model/SpliceInsertMessage.h>
#include <aws/mediatailor/model/StartChannelRequest.h>
#include <aws/mediatailor/model/StartChannelResult.h>
#include <aws/mediatailor/model/StopChannelRequest.h>
#include <aws/mediatailor/model/StopChannelResult.h>
#include <aws/mediatailor/model/StreamingMediaFileConditioning.h>
#include <aws/mediatailor/model/TagResourceRequest.h>
#include <aws/mediatailor/model/Tier.h>
#include <aws/mediatailor/model/TimeShiftConfiguration.h>
#include <aws/mediatailor/model/TimeSignalMessage.h>
#include <aws/mediatailor/model/TrafficShapingRetrievalWindow.h>
#include <aws/mediatailor/model/TrafficShapingType.h>
#include <aws/mediatailor/model/Transition.h>
#include <aws/mediatailor/model/Type.h>
#include <aws/mediatailor/model/UntagResourceRequest.h>
#include <aws/mediatailor/model/UpdateChannelRequest.h>
#include <aws/mediatailor/model/UpdateChannelResult.h>
#include <aws/mediatailor/model/UpdateLiveSourceRequest.h>
#include <aws/mediatailor/model/UpdateLiveSourceResult.h>
#include <aws/mediatailor/model/UpdateProgramRequest.h>
#include <aws/mediatailor/model/UpdateProgramResult.h>
#include <aws/mediatailor/model/UpdateProgramScheduleConfiguration.h>
#include <aws/mediatailor/model/UpdateProgramTransition.h>
#include <aws/mediatailor/model/UpdateSourceLocationRequest.h>
#include <aws/mediatailor/model/UpdateSourceLocationResult.h>
#include <aws/mediatailor/model/UpdateVodSourceRequest.h>
#include <aws/mediatailor/model/UpdateVodSourceResult.h>
#include <aws/mediatailor/model/VodSource.h>

using MediaTailorIncludeTest = ::testing::Test;

TEST_F(MediaTailorIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::MediaTailor::MediaTailorClient>("MediaTailorIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
