/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/migrationhubstrategy/MigrationHubStrategyRecommendationsClient.h>
#include <aws/migrationhubstrategy/MigrationHubStrategyRecommendationsEndpointProvider.h>
#include <aws/migrationhubstrategy/MigrationHubStrategyRecommendationsEndpointRules.h>
#include <aws/migrationhubstrategy/MigrationHubStrategyRecommendationsErrorMarshaller.h>
#include <aws/migrationhubstrategy/MigrationHubStrategyRecommendationsErrors.h>
#include <aws/migrationhubstrategy/MigrationHubStrategyRecommendationsRequest.h>
#include <aws/migrationhubstrategy/MigrationHubStrategyRecommendationsServiceClientModel.h>
#include <aws/migrationhubstrategy/MigrationHubStrategyRecommendations_EXPORTS.h>
#include <aws/migrationhubstrategy/model/AnalysisStatusUnion.h>
#include <aws/migrationhubstrategy/model/AnalysisType.h>
#include <aws/migrationhubstrategy/model/AnalyzableServerSummary.h>
#include <aws/migrationhubstrategy/model/AnalyzerNameUnion.h>
#include <aws/migrationhubstrategy/model/AntipatternReportResult.h>
#include <aws/migrationhubstrategy/model/AntipatternReportStatus.h>
#include <aws/migrationhubstrategy/model/AntipatternSeveritySummary.h>
#include <aws/migrationhubstrategy/model/AppType.h>
#include <aws/migrationhubstrategy/model/AppUnitError.h>
#include <aws/migrationhubstrategy/model/AppUnitErrorCategory.h>
#include <aws/migrationhubstrategy/model/ApplicationComponentCriteria.h>
#include <aws/migrationhubstrategy/model/ApplicationComponentDetail.h>
#include <aws/migrationhubstrategy/model/ApplicationComponentStatusSummary.h>
#include <aws/migrationhubstrategy/model/ApplicationComponentStrategy.h>
#include <aws/migrationhubstrategy/model/ApplicationComponentSummary.h>
#include <aws/migrationhubstrategy/model/ApplicationMode.h>
#include <aws/migrationhubstrategy/model/ApplicationPreferences.h>
#include <aws/migrationhubstrategy/model/AssessmentDataSourceType.h>
#include <aws/migrationhubstrategy/model/AssessmentStatus.h>
#include <aws/migrationhubstrategy/model/AssessmentSummary.h>
#include <aws/migrationhubstrategy/model/AssessmentTarget.h>
#include <aws/migrationhubstrategy/model/AssociatedApplication.h>
#include <aws/migrationhubstrategy/model/AuthType.h>
#include <aws/migrationhubstrategy/model/AwsManagedResources.h>
#include <aws/migrationhubstrategy/model/AwsManagedTargetDestination.h>
#include <aws/migrationhubstrategy/model/BinaryAnalyzerName.h>
#include <aws/migrationhubstrategy/model/BusinessGoals.h>
#include <aws/migrationhubstrategy/model/Collector.h>
#include <aws/migrationhubstrategy/model/CollectorHealth.h>
#include <aws/migrationhubstrategy/model/Condition.h>
#include <aws/migrationhubstrategy/model/ConfigurationSummary.h>
#include <aws/migrationhubstrategy/model/DataCollectionDetails.h>
#include <aws/migrationhubstrategy/model/DataSourceType.h>
#include <aws/migrationhubstrategy/model/DatabaseConfigDetail.h>
#include <aws/migrationhubstrategy/model/DatabaseManagementPreference.h>
#include <aws/migrationhubstrategy/model/DatabaseMigrationPreference.h>
#include <aws/migrationhubstrategy/model/DatabasePreferences.h>
#include <aws/migrationhubstrategy/model/GetApplicationComponentDetailsRequest.h>
#include <aws/migrationhubstrategy/model/GetApplicationComponentDetailsResult.h>
#include <aws/migrationhubstrategy/model/GetApplicationComponentStrategiesRequest.h>
#include <aws/migrationhubstrategy/model/GetApplicationComponentStrategiesResult.h>
#include <aws/migrationhubstrategy/model/GetAssessmentRequest.h>
#include <aws/migrationhubstrategy/model/GetAssessmentResult.h>
#include <aws/migrationhubstrategy/model/GetImportFileTaskRequest.h>
#include <aws/migrationhubstrategy/model/GetImportFileTaskResult.h>
#include <aws/migrationhubstrategy/model/GetLatestAssessmentIdRequest.h>
#include <aws/migrationhubstrategy/model/GetLatestAssessmentIdResult.h>
#include <aws/migrationhubstrategy/model/GetPortfolioPreferencesRequest.h>
#include <aws/migrationhubstrategy/model/GetPortfolioPreferencesResult.h>
#include <aws/migrationhubstrategy/model/GetPortfolioSummaryRequest.h>
#include <aws/migrationhubstrategy/model/GetPortfolioSummaryResult.h>
#include <aws/migrationhubstrategy/model/GetRecommendationReportDetailsRequest.h>
#include <aws/migrationhubstrategy/model/GetRecommendationReportDetailsResult.h>
#include <aws/migrationhubstrategy/model/GetServerDetailsRequest.h>
#include <aws/migrationhubstrategy/model/GetServerDetailsResult.h>
#include <aws/migrationhubstrategy/model/GetServerStrategiesRequest.h>
#include <aws/migrationhubstrategy/model/GetServerStrategiesResult.h>
#include <aws/migrationhubstrategy/model/Group.h>
#include <aws/migrationhubstrategy/model/GroupName.h>
#include <aws/migrationhubstrategy/model/Heterogeneous.h>
#include <aws/migrationhubstrategy/model/HeterogeneousTargetDatabaseEngine.h>
#include <aws/migrationhubstrategy/model/Homogeneous.h>
#include <aws/migrationhubstrategy/model/HomogeneousTargetDatabaseEngine.h>
#include <aws/migrationhubstrategy/model/IPAddressBasedRemoteInfo.h>
#include <aws/migrationhubstrategy/model/ImportFileTaskInformation.h>
#include <aws/migrationhubstrategy/model/ImportFileTaskStatus.h>
#include <aws/migrationhubstrategy/model/InclusionStatus.h>
#include <aws/migrationhubstrategy/model/ListAnalyzableServersRequest.h>
#include <aws/migrationhubstrategy/model/ListAnalyzableServersResult.h>
#include <aws/migrationhubstrategy/model/ListApplicationComponentsRequest.h>
#include <aws/migrationhubstrategy/model/ListApplicationComponentsResult.h>
#include <aws/migrationhubstrategy/model/ListCollectorsRequest.h>
#include <aws/migrationhubstrategy/model/ListCollectorsResult.h>
#include <aws/migrationhubstrategy/model/ListImportFileTaskRequest.h>
#include <aws/migrationhubstrategy/model/ListImportFileTaskResult.h>
#include <aws/migrationhubstrategy/model/ListServersRequest.h>
#include <aws/migrationhubstrategy/model/ListServersResult.h>
#include <aws/migrationhubstrategy/model/ManagementPreference.h>
#include <aws/migrationhubstrategy/model/NetworkInfo.h>
#include <aws/migrationhubstrategy/model/NoDatabaseMigrationPreference.h>
#include <aws/migrationhubstrategy/model/NoManagementPreference.h>
#include <aws/migrationhubstrategy/model/NoPreferenceTargetDestination.h>
#include <aws/migrationhubstrategy/model/OSInfo.h>
#include <aws/migrationhubstrategy/model/OSType.h>
#include <aws/migrationhubstrategy/model/OutputFormat.h>
#include <aws/migrationhubstrategy/model/PipelineInfo.h>
#include <aws/migrationhubstrategy/model/PipelineType.h>
#include <aws/migrationhubstrategy/model/PrioritizeBusinessGoals.h>
#include <aws/migrationhubstrategy/model/PutPortfolioPreferencesRequest.h>
#include <aws/migrationhubstrategy/model/PutPortfolioPreferencesResult.h>
#include <aws/migrationhubstrategy/model/RecommendationReportDetails.h>
#include <aws/migrationhubstrategy/model/RecommendationReportStatus.h>
#include <aws/migrationhubstrategy/model/RecommendationSet.h>
#include <aws/migrationhubstrategy/model/RemoteSourceCodeAnalysisServerInfo.h>
#include <aws/migrationhubstrategy/model/ResourceSubType.h>
#include <aws/migrationhubstrategy/model/Result.h>
#include <aws/migrationhubstrategy/model/RunTimeAnalyzerName.h>
#include <aws/migrationhubstrategy/model/RunTimeAssessmentStatus.h>
#include <aws/migrationhubstrategy/model/RuntimeAnalysisStatus.h>
#include <aws/migrationhubstrategy/model/S3Object.h>
#include <aws/migrationhubstrategy/model/SelfManageResources.h>
#include <aws/migrationhubstrategy/model/SelfManageTargetDestination.h>
#include <aws/migrationhubstrategy/model/ServerCriteria.h>
#include <aws/migrationhubstrategy/model/ServerDetail.h>
#include <aws/migrationhubstrategy/model/ServerError.h>
#include <aws/migrationhubstrategy/model/ServerErrorCategory.h>
#include <aws/migrationhubstrategy/model/ServerOsType.h>
#include <aws/migrationhubstrategy/model/ServerStatusSummary.h>
#include <aws/migrationhubstrategy/model/ServerStrategy.h>
#include <aws/migrationhubstrategy/model/ServerSummary.h>
#include <aws/migrationhubstrategy/model/Severity.h>
#include <aws/migrationhubstrategy/model/SortOrder.h>
#include <aws/migrationhubstrategy/model/SourceCode.h>
#include <aws/migrationhubstrategy/model/SourceCodeAnalyzerName.h>
#include <aws/migrationhubstrategy/model/SourceCodeRepository.h>
#include <aws/migrationhubstrategy/model/SrcCodeOrDbAnalysisStatus.h>
#include <aws/migrationhubstrategy/model/StartAssessmentRequest.h>
#include <aws/migrationhubstrategy/model/StartAssessmentResult.h>
#include <aws/migrationhubstrategy/model/StartImportFileTaskRequest.h>
#include <aws/migrationhubstrategy/model/StartImportFileTaskResult.h>
#include <aws/migrationhubstrategy/model/StartRecommendationReportGenerationRequest.h>
#include <aws/migrationhubstrategy/model/StartRecommendationReportGenerationResult.h>
#include <aws/migrationhubstrategy/model/StopAssessmentRequest.h>
#include <aws/migrationhubstrategy/model/StopAssessmentResult.h>
#include <aws/migrationhubstrategy/model/Strategy.h>
#include <aws/migrationhubstrategy/model/StrategyOption.h>
#include <aws/migrationhubstrategy/model/StrategyRecommendation.h>
#include <aws/migrationhubstrategy/model/StrategySummary.h>
#include <aws/migrationhubstrategy/model/SystemInfo.h>
#include <aws/migrationhubstrategy/model/TargetDatabaseEngine.h>
#include <aws/migrationhubstrategy/model/TargetDestination.h>
#include <aws/migrationhubstrategy/model/TransformationTool.h>
#include <aws/migrationhubstrategy/model/TransformationToolName.h>
#include <aws/migrationhubstrategy/model/UpdateApplicationComponentConfigRequest.h>
#include <aws/migrationhubstrategy/model/UpdateApplicationComponentConfigResult.h>
#include <aws/migrationhubstrategy/model/UpdateServerConfigRequest.h>
#include <aws/migrationhubstrategy/model/UpdateServerConfigResult.h>
#include <aws/migrationhubstrategy/model/VcenterBasedRemoteInfo.h>
#include <aws/migrationhubstrategy/model/VersionControl.h>
#include <aws/migrationhubstrategy/model/VersionControlInfo.h>
#include <aws/migrationhubstrategy/model/VersionControlType.h>

using MigrationHubStrategyRecommendationsIncludeTest = ::testing::Test;

TEST_F(MigrationHubStrategyRecommendationsIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::MigrationHubStrategyRecommendations::MigrationHubStrategyRecommendationsClient>("MigrationHubStrategyRecommendationsIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
