/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/neptunedata/NeptunedataClient.h>
#include <aws/neptunedata/NeptunedataEndpointProvider.h>
#include <aws/neptunedata/NeptunedataEndpointRules.h>
#include <aws/neptunedata/NeptunedataErrorMarshaller.h>
#include <aws/neptunedata/NeptunedataErrors.h>
#include <aws/neptunedata/NeptunedataRequest.h>
#include <aws/neptunedata/NeptunedataServiceClientModel.h>
#include <aws/neptunedata/Neptunedata_EXPORTS.h>
#include <aws/neptunedata/model/AccessDeniedException.h>
#include <aws/neptunedata/model/Action.h>
#include <aws/neptunedata/model/BadRequestException.h>
#include <aws/neptunedata/model/BulkLoadIdNotFoundException.h>
#include <aws/neptunedata/model/CancelGremlinQueryRequest.h>
#include <aws/neptunedata/model/CancelGremlinQueryResult.h>
#include <aws/neptunedata/model/CancelLoaderJobRequest.h>
#include <aws/neptunedata/model/CancelLoaderJobResult.h>
#include <aws/neptunedata/model/CancelMLDataProcessingJobRequest.h>
#include <aws/neptunedata/model/CancelMLDataProcessingJobResult.h>
#include <aws/neptunedata/model/CancelMLModelTrainingJobRequest.h>
#include <aws/neptunedata/model/CancelMLModelTrainingJobResult.h>
#include <aws/neptunedata/model/CancelMLModelTransformJobRequest.h>
#include <aws/neptunedata/model/CancelMLModelTransformJobResult.h>
#include <aws/neptunedata/model/CancelOpenCypherQueryRequest.h>
#include <aws/neptunedata/model/CancelOpenCypherQueryResult.h>
#include <aws/neptunedata/model/CancelledByUserException.h>
#include <aws/neptunedata/model/ClientTimeoutException.h>
#include <aws/neptunedata/model/ConcurrentModificationException.h>
#include <aws/neptunedata/model/ConstraintViolationException.h>
#include <aws/neptunedata/model/CreateMLEndpointRequest.h>
#include <aws/neptunedata/model/CreateMLEndpointResult.h>
#include <aws/neptunedata/model/CustomModelTrainingParameters.h>
#include <aws/neptunedata/model/CustomModelTransformParameters.h>
#include <aws/neptunedata/model/DeleteMLEndpointRequest.h>
#include <aws/neptunedata/model/DeleteMLEndpointResult.h>
#include <aws/neptunedata/model/DeletePropertygraphStatisticsRequest.h>
#include <aws/neptunedata/model/DeletePropertygraphStatisticsResult.h>
#include <aws/neptunedata/model/DeleteSparqlStatisticsRequest.h>
#include <aws/neptunedata/model/DeleteSparqlStatisticsResult.h>
#include <aws/neptunedata/model/DeleteStatisticsValueMap.h>
#include <aws/neptunedata/model/EdgeStructure.h>
#include <aws/neptunedata/model/Encoding.h>
#include <aws/neptunedata/model/ExecuteFastResetRequest.h>
#include <aws/neptunedata/model/ExecuteFastResetResult.h>
#include <aws/neptunedata/model/ExecuteGremlinExplainQueryRequest.h>
#include <aws/neptunedata/model/ExecuteGremlinExplainQueryResult.h>
#include <aws/neptunedata/model/ExecuteGremlinProfileQueryRequest.h>
#include <aws/neptunedata/model/ExecuteGremlinProfileQueryResult.h>
#include <aws/neptunedata/model/ExecuteGremlinQueryRequest.h>
#include <aws/neptunedata/model/ExecuteGremlinQueryResult.h>
#include <aws/neptunedata/model/ExecuteOpenCypherExplainQueryRequest.h>
#include <aws/neptunedata/model/ExecuteOpenCypherExplainQueryResult.h>
#include <aws/neptunedata/model/ExecuteOpenCypherQueryRequest.h>
#include <aws/neptunedata/model/ExecuteOpenCypherQueryResult.h>
#include <aws/neptunedata/model/ExpiredStreamException.h>
#include <aws/neptunedata/model/FailureByQueryException.h>
#include <aws/neptunedata/model/FastResetToken.h>
#include <aws/neptunedata/model/Format.h>
#include <aws/neptunedata/model/GetEngineStatusRequest.h>
#include <aws/neptunedata/model/GetEngineStatusResult.h>
#include <aws/neptunedata/model/GetGremlinQueryStatusRequest.h>
#include <aws/neptunedata/model/GetGremlinQueryStatusResult.h>
#include <aws/neptunedata/model/GetLoaderJobStatusRequest.h>
#include <aws/neptunedata/model/GetLoaderJobStatusResult.h>
#include <aws/neptunedata/model/GetMLDataProcessingJobRequest.h>
#include <aws/neptunedata/model/GetMLDataProcessingJobResult.h>
#include <aws/neptunedata/model/GetMLEndpointRequest.h>
#include <aws/neptunedata/model/GetMLEndpointResult.h>
#include <aws/neptunedata/model/GetMLModelTrainingJobRequest.h>
#include <aws/neptunedata/model/GetMLModelTrainingJobResult.h>
#include <aws/neptunedata/model/GetMLModelTransformJobRequest.h>
#include <aws/neptunedata/model/GetMLModelTransformJobResult.h>
#include <aws/neptunedata/model/GetOpenCypherQueryStatusRequest.h>
#include <aws/neptunedata/model/GetOpenCypherQueryStatusResult.h>
#include <aws/neptunedata/model/GetPropertygraphStatisticsRequest.h>
#include <aws/neptunedata/model/GetPropertygraphStatisticsResult.h>
#include <aws/neptunedata/model/GetPropertygraphStreamRequest.h>
#include <aws/neptunedata/model/GetPropertygraphStreamResult.h>
#include <aws/neptunedata/model/GetPropertygraphSummaryRequest.h>
#include <aws/neptunedata/model/GetPropertygraphSummaryResult.h>
#include <aws/neptunedata/model/GetRDFGraphSummaryRequest.h>
#include <aws/neptunedata/model/GetRDFGraphSummaryResult.h>
#include <aws/neptunedata/model/GetSparqlStatisticsRequest.h>
#include <aws/neptunedata/model/GetSparqlStatisticsResult.h>
#include <aws/neptunedata/model/GetSparqlStreamRequest.h>
#include <aws/neptunedata/model/GetSparqlStreamResult.h>
#include <aws/neptunedata/model/GraphSummaryType.h>
#include <aws/neptunedata/model/GremlinQueryStatus.h>
#include <aws/neptunedata/model/GremlinQueryStatusAttributes.h>
#include <aws/neptunedata/model/IllegalArgumentException.h>
#include <aws/neptunedata/model/InternalFailureException.h>
#include <aws/neptunedata/model/InvalidArgumentException.h>
#include <aws/neptunedata/model/InvalidNumericDataException.h>
#include <aws/neptunedata/model/InvalidParameterException.h>
#include <aws/neptunedata/model/IteratorType.h>
#include <aws/neptunedata/model/ListGremlinQueriesRequest.h>
#include <aws/neptunedata/model/ListGremlinQueriesResult.h>
#include <aws/neptunedata/model/ListLoaderJobsRequest.h>
#include <aws/neptunedata/model/ListLoaderJobsResult.h>
#include <aws/neptunedata/model/ListMLDataProcessingJobsRequest.h>
#include <aws/neptunedata/model/ListMLDataProcessingJobsResult.h>
#include <aws/neptunedata/model/ListMLEndpointsRequest.h>
#include <aws/neptunedata/model/ListMLEndpointsResult.h>
#include <aws/neptunedata/model/ListMLModelTrainingJobsRequest.h>
#include <aws/neptunedata/model/ListMLModelTrainingJobsResult.h>
#include <aws/neptunedata/model/ListMLModelTransformJobsRequest.h>
#include <aws/neptunedata/model/ListMLModelTransformJobsResult.h>
#include <aws/neptunedata/model/ListOpenCypherQueriesRequest.h>
#include <aws/neptunedata/model/ListOpenCypherQueriesResult.h>
#include <aws/neptunedata/model/LoadUrlAccessDeniedException.h>
#include <aws/neptunedata/model/LoaderIdResult.h>
#include <aws/neptunedata/model/MLResourceNotFoundException.h>
#include <aws/neptunedata/model/MalformedQueryException.h>
#include <aws/neptunedata/model/ManagePropertygraphStatisticsRequest.h>
#include <aws/neptunedata/model/ManagePropertygraphStatisticsResult.h>
#include <aws/neptunedata/model/ManageSparqlStatisticsRequest.h>
#include <aws/neptunedata/model/ManageSparqlStatisticsResult.h>
#include <aws/neptunedata/model/MemoryLimitExceededException.h>
#include <aws/neptunedata/model/MethodNotAllowedException.h>
#include <aws/neptunedata/model/MissingParameterException.h>
#include <aws/neptunedata/model/MlConfigDefinition.h>
#include <aws/neptunedata/model/MlResourceDefinition.h>
#include <aws/neptunedata/model/Mode.h>
#include <aws/neptunedata/model/NodeStructure.h>
#include <aws/neptunedata/model/OpenCypherExplainMode.h>
#include <aws/neptunedata/model/Parallelism.h>
#include <aws/neptunedata/model/ParsingException.h>
#include <aws/neptunedata/model/PreconditionsFailedException.h>
#include <aws/neptunedata/model/PropertygraphData.h>
#include <aws/neptunedata/model/PropertygraphRecord.h>
#include <aws/neptunedata/model/PropertygraphSummary.h>
#include <aws/neptunedata/model/PropertygraphSummaryValueMap.h>
#include <aws/neptunedata/model/QueryEvalStats.h>
#include <aws/neptunedata/model/QueryLanguageVersion.h>
#include <aws/neptunedata/model/QueryLimitExceededException.h>
#include <aws/neptunedata/model/QueryLimitException.h>
#include <aws/neptunedata/model/QueryTooLargeException.h>
#include <aws/neptunedata/model/RDFGraphSummary.h>
#include <aws/neptunedata/model/RDFGraphSummaryValueMap.h>
#include <aws/neptunedata/model/ReadOnlyViolationException.h>
#include <aws/neptunedata/model/RefreshStatisticsIdMap.h>
#include <aws/neptunedata/model/S3BucketRegion.h>
#include <aws/neptunedata/model/S3Exception.h>
#include <aws/neptunedata/model/ServerShutdownException.h>
#include <aws/neptunedata/model/SparqlData.h>
#include <aws/neptunedata/model/SparqlRecord.h>
#include <aws/neptunedata/model/StartLoaderJobRequest.h>
#include <aws/neptunedata/model/StartLoaderJobResult.h>
#include <aws/neptunedata/model/StartMLDataProcessingJobRequest.h>
#include <aws/neptunedata/model/StartMLDataProcessingJobResult.h>
#include <aws/neptunedata/model/StartMLModelTrainingJobRequest.h>
#include <aws/neptunedata/model/StartMLModelTrainingJobResult.h>
#include <aws/neptunedata/model/StartMLModelTransformJobRequest.h>
#include <aws/neptunedata/model/StartMLModelTransformJobResult.h>
#include <aws/neptunedata/model/Statistics.h>
#include <aws/neptunedata/model/StatisticsAutoGenerationMode.h>
#include <aws/neptunedata/model/StatisticsNotAvailableException.h>
#include <aws/neptunedata/model/StatisticsSummary.h>
#include <aws/neptunedata/model/StreamRecordsNotFoundException.h>
#include <aws/neptunedata/model/SubjectStructure.h>
#include <aws/neptunedata/model/ThrottlingException.h>
#include <aws/neptunedata/model/TimeLimitExceededException.h>
#include <aws/neptunedata/model/TooManyRequestsException.h>
#include <aws/neptunedata/model/UnsupportedOperationException.h>

using NeptunedataIncludeTest = ::testing::Test;

TEST_F(NeptunedataIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::neptunedata::NeptunedataClient>("NeptunedataIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
