/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/network-firewall/NetworkFirewallClient.h>
#include <aws/network-firewall/NetworkFirewallEndpointProvider.h>
#include <aws/network-firewall/NetworkFirewallEndpointRules.h>
#include <aws/network-firewall/NetworkFirewallErrorMarshaller.h>
#include <aws/network-firewall/NetworkFirewallErrors.h>
#include <aws/network-firewall/NetworkFirewallRequest.h>
#include <aws/network-firewall/NetworkFirewallServiceClientModel.h>
#include <aws/network-firewall/NetworkFirewall_EXPORTS.h>
#include <aws/network-firewall/model/AZSyncState.h>
#include <aws/network-firewall/model/AcceptNetworkFirewallTransitGatewayAttachmentRequest.h>
#include <aws/network-firewall/model/AcceptNetworkFirewallTransitGatewayAttachmentResult.h>
#include <aws/network-firewall/model/ActionDefinition.h>
#include <aws/network-firewall/model/Address.h>
#include <aws/network-firewall/model/AnalysisReport.h>
#include <aws/network-firewall/model/AnalysisResult.h>
#include <aws/network-firewall/model/AnalysisTypeReportResult.h>
#include <aws/network-firewall/model/AssociateAvailabilityZonesRequest.h>
#include <aws/network-firewall/model/AssociateAvailabilityZonesResult.h>
#include <aws/network-firewall/model/AssociateFirewallPolicyRequest.h>
#include <aws/network-firewall/model/AssociateFirewallPolicyResult.h>
#include <aws/network-firewall/model/AssociateSubnetsRequest.h>
#include <aws/network-firewall/model/AssociateSubnetsResult.h>
#include <aws/network-firewall/model/Attachment.h>
#include <aws/network-firewall/model/AttachmentStatus.h>
#include <aws/network-firewall/model/AvailabilityZoneMapping.h>
#include <aws/network-firewall/model/AvailabilityZoneMetadata.h>
#include <aws/network-firewall/model/CIDRSummary.h>
#include <aws/network-firewall/model/CapacityUsageSummary.h>
#include <aws/network-firewall/model/CheckCertificateRevocationStatusActions.h>
#include <aws/network-firewall/model/ConfigurationSyncState.h>
#include <aws/network-firewall/model/CreateFirewallPolicyRequest.h>
#include <aws/network-firewall/model/CreateFirewallPolicyResult.h>
#include <aws/network-firewall/model/CreateFirewallRequest.h>
#include <aws/network-firewall/model/CreateFirewallResult.h>
#include <aws/network-firewall/model/CreateRuleGroupRequest.h>
#include <aws/network-firewall/model/CreateRuleGroupResult.h>
#include <aws/network-firewall/model/CreateTLSInspectionConfigurationRequest.h>
#include <aws/network-firewall/model/CreateTLSInspectionConfigurationResult.h>
#include <aws/network-firewall/model/CreateVpcEndpointAssociationRequest.h>
#include <aws/network-firewall/model/CreateVpcEndpointAssociationResult.h>
#include <aws/network-firewall/model/CustomAction.h>
#include <aws/network-firewall/model/DeleteFirewallPolicyRequest.h>
#include <aws/network-firewall/model/DeleteFirewallPolicyResult.h>
#include <aws/network-firewall/model/DeleteFirewallRequest.h>
#include <aws/network-firewall/model/DeleteFirewallResult.h>
#include <aws/network-firewall/model/DeleteNetworkFirewallTransitGatewayAttachmentRequest.h>
#include <aws/network-firewall/model/DeleteNetworkFirewallTransitGatewayAttachmentResult.h>
#include <aws/network-firewall/model/DeleteResourcePolicyRequest.h>
#include <aws/network-firewall/model/DeleteResourcePolicyResult.h>
#include <aws/network-firewall/model/DeleteRuleGroupRequest.h>
#include <aws/network-firewall/model/DeleteRuleGroupResult.h>
#include <aws/network-firewall/model/DeleteTLSInspectionConfigurationRequest.h>
#include <aws/network-firewall/model/DeleteTLSInspectionConfigurationResult.h>
#include <aws/network-firewall/model/DeleteVpcEndpointAssociationRequest.h>
#include <aws/network-firewall/model/DeleteVpcEndpointAssociationResult.h>
#include <aws/network-firewall/model/DescribeFirewallMetadataRequest.h>
#include <aws/network-firewall/model/DescribeFirewallMetadataResult.h>
#include <aws/network-firewall/model/DescribeFirewallPolicyRequest.h>
#include <aws/network-firewall/model/DescribeFirewallPolicyResult.h>
#include <aws/network-firewall/model/DescribeFirewallRequest.h>
#include <aws/network-firewall/model/DescribeFirewallResult.h>
#include <aws/network-firewall/model/DescribeFlowOperationRequest.h>
#include <aws/network-firewall/model/DescribeFlowOperationResult.h>
#include <aws/network-firewall/model/DescribeLoggingConfigurationRequest.h>
#include <aws/network-firewall/model/DescribeLoggingConfigurationResult.h>
#include <aws/network-firewall/model/DescribeResourcePolicyRequest.h>
#include <aws/network-firewall/model/DescribeResourcePolicyResult.h>
#include <aws/network-firewall/model/DescribeRuleGroupMetadataRequest.h>
#include <aws/network-firewall/model/DescribeRuleGroupMetadataResult.h>
#include <aws/network-firewall/model/DescribeRuleGroupRequest.h>
#include <aws/network-firewall/model/DescribeRuleGroupResult.h>
#include <aws/network-firewall/model/DescribeRuleGroupSummaryRequest.h>
#include <aws/network-firewall/model/DescribeRuleGroupSummaryResult.h>
#include <aws/network-firewall/model/DescribeTLSInspectionConfigurationRequest.h>
#include <aws/network-firewall/model/DescribeTLSInspectionConfigurationResult.h>
#include <aws/network-firewall/model/DescribeVpcEndpointAssociationRequest.h>
#include <aws/network-firewall/model/DescribeVpcEndpointAssociationResult.h>
#include <aws/network-firewall/model/Dimension.h>
#include <aws/network-firewall/model/DisassociateAvailabilityZonesRequest.h>
#include <aws/network-firewall/model/DisassociateAvailabilityZonesResult.h>
#include <aws/network-firewall/model/DisassociateSubnetsRequest.h>
#include <aws/network-firewall/model/DisassociateSubnetsResult.h>
#include <aws/network-firewall/model/EnabledAnalysisType.h>
#include <aws/network-firewall/model/EncryptionConfiguration.h>
#include <aws/network-firewall/model/EncryptionType.h>
#include <aws/network-firewall/model/Firewall.h>
#include <aws/network-firewall/model/FirewallMetadata.h>
#include <aws/network-firewall/model/FirewallPolicy.h>
#include <aws/network-firewall/model/FirewallPolicyMetadata.h>
#include <aws/network-firewall/model/FirewallPolicyResponse.h>
#include <aws/network-firewall/model/FirewallStatus.h>
#include <aws/network-firewall/model/FirewallStatusValue.h>
#include <aws/network-firewall/model/Flow.h>
#include <aws/network-firewall/model/FlowFilter.h>
#include <aws/network-firewall/model/FlowOperation.h>
#include <aws/network-firewall/model/FlowOperationMetadata.h>
#include <aws/network-firewall/model/FlowOperationStatus.h>
#include <aws/network-firewall/model/FlowOperationType.h>
#include <aws/network-firewall/model/FlowTimeouts.h>
#include <aws/network-firewall/model/GeneratedRulesType.h>
#include <aws/network-firewall/model/GetAnalysisReportResultsRequest.h>
#include <aws/network-firewall/model/GetAnalysisReportResultsResult.h>
#include <aws/network-firewall/model/Header.h>
#include <aws/network-firewall/model/Hits.h>
#include <aws/network-firewall/model/IPAddressType.h>
#include <aws/network-firewall/model/IPSet.h>
#include <aws/network-firewall/model/IPSetMetadata.h>
#include <aws/network-firewall/model/IPSetReference.h>
#include <aws/network-firewall/model/IdentifiedType.h>
#include <aws/network-firewall/model/ListAnalysisReportsRequest.h>
#include <aws/network-firewall/model/ListAnalysisReportsResult.h>
#include <aws/network-firewall/model/ListFirewallPoliciesRequest.h>
#include <aws/network-firewall/model/ListFirewallPoliciesResult.h>
#include <aws/network-firewall/model/ListFirewallsRequest.h>
#include <aws/network-firewall/model/ListFirewallsResult.h>
#include <aws/network-firewall/model/ListFlowOperationResultsRequest.h>
#include <aws/network-firewall/model/ListFlowOperationResultsResult.h>
#include <aws/network-firewall/model/ListFlowOperationsRequest.h>
#include <aws/network-firewall/model/ListFlowOperationsResult.h>
#include <aws/network-firewall/model/ListRuleGroupsRequest.h>
#include <aws/network-firewall/model/ListRuleGroupsResult.h>
#include <aws/network-firewall/model/ListTLSInspectionConfigurationsRequest.h>
#include <aws/network-firewall/model/ListTLSInspectionConfigurationsResult.h>
#include <aws/network-firewall/model/ListTagsForResourceRequest.h>
#include <aws/network-firewall/model/ListTagsForResourceResult.h>
#include <aws/network-firewall/model/ListVpcEndpointAssociationsRequest.h>
#include <aws/network-firewall/model/ListVpcEndpointAssociationsResult.h>
#include <aws/network-firewall/model/LogDestinationConfig.h>
#include <aws/network-firewall/model/LogDestinationType.h>
#include <aws/network-firewall/model/LogType.h>
#include <aws/network-firewall/model/LoggingConfiguration.h>
#include <aws/network-firewall/model/MatchAttributes.h>
#include <aws/network-firewall/model/OverrideAction.h>
#include <aws/network-firewall/model/PerObjectStatus.h>
#include <aws/network-firewall/model/PerObjectSyncStatus.h>
#include <aws/network-firewall/model/PolicyVariables.h>
#include <aws/network-firewall/model/PortRange.h>
#include <aws/network-firewall/model/PortSet.h>
#include <aws/network-firewall/model/PublishMetricAction.h>
#include <aws/network-firewall/model/PutResourcePolicyRequest.h>
#include <aws/network-firewall/model/PutResourcePolicyResult.h>
#include <aws/network-firewall/model/ReferenceSets.h>
#include <aws/network-firewall/model/RejectNetworkFirewallTransitGatewayAttachmentRequest.h>
#include <aws/network-firewall/model/RejectNetworkFirewallTransitGatewayAttachmentResult.h>
#include <aws/network-firewall/model/ResourceManagedStatus.h>
#include <aws/network-firewall/model/ResourceManagedType.h>
#include <aws/network-firewall/model/ResourceStatus.h>
#include <aws/network-firewall/model/RevocationCheckAction.h>
#include <aws/network-firewall/model/RuleDefinition.h>
#include <aws/network-firewall/model/RuleGroup.h>
#include <aws/network-firewall/model/RuleGroupMetadata.h>
#include <aws/network-firewall/model/RuleGroupResponse.h>
#include <aws/network-firewall/model/RuleGroupType.h>
#include <aws/network-firewall/model/RuleOption.h>
#include <aws/network-firewall/model/RuleOrder.h>
#include <aws/network-firewall/model/RuleSummary.h>
#include <aws/network-firewall/model/RuleVariables.h>
#include <aws/network-firewall/model/RulesSource.h>
#include <aws/network-firewall/model/RulesSourceList.h>
#include <aws/network-firewall/model/ServerCertificate.h>
#include <aws/network-firewall/model/ServerCertificateConfiguration.h>
#include <aws/network-firewall/model/ServerCertificateScope.h>
#include <aws/network-firewall/model/SourceMetadata.h>
#include <aws/network-firewall/model/StartAnalysisReportRequest.h>
#include <aws/network-firewall/model/StartAnalysisReportResult.h>
#include <aws/network-firewall/model/StartFlowCaptureRequest.h>
#include <aws/network-firewall/model/StartFlowCaptureResult.h>
#include <aws/network-firewall/model/StartFlowFlushRequest.h>
#include <aws/network-firewall/model/StartFlowFlushResult.h>
#include <aws/network-firewall/model/StatefulAction.h>
#include <aws/network-firewall/model/StatefulEngineOptions.h>
#include <aws/network-firewall/model/StatefulRule.h>
#include <aws/network-firewall/model/StatefulRuleDirection.h>
#include <aws/network-firewall/model/StatefulRuleGroupOverride.h>
#include <aws/network-firewall/model/StatefulRuleGroupReference.h>
#include <aws/network-firewall/model/StatefulRuleOptions.h>
#include <aws/network-firewall/model/StatefulRuleProtocol.h>
#include <aws/network-firewall/model/StatelessRule.h>
#include <aws/network-firewall/model/StatelessRuleGroupReference.h>
#include <aws/network-firewall/model/StatelessRulesAndCustomActions.h>
#include <aws/network-firewall/model/StreamExceptionPolicy.h>
#include <aws/network-firewall/model/SubnetMapping.h>
#include <aws/network-firewall/model/Summary.h>
#include <aws/network-firewall/model/SummaryConfiguration.h>
#include <aws/network-firewall/model/SummaryRuleOption.h>
#include <aws/network-firewall/model/SyncState.h>
#include <aws/network-firewall/model/TCPFlag.h>
#include <aws/network-firewall/model/TCPFlagField.h>
#include <aws/network-firewall/model/TLSInspectionConfiguration.h>
#include <aws/network-firewall/model/TLSInspectionConfigurationMetadata.h>
#include <aws/network-firewall/model/TLSInspectionConfigurationResponse.h>
#include <aws/network-firewall/model/Tag.h>
#include <aws/network-firewall/model/TagResourceRequest.h>
#include <aws/network-firewall/model/TagResourceResult.h>
#include <aws/network-firewall/model/TargetType.h>
#include <aws/network-firewall/model/TlsCertificateData.h>
#include <aws/network-firewall/model/TransitGatewayAttachmentStatus.h>
#include <aws/network-firewall/model/TransitGatewayAttachmentSyncState.h>
#include <aws/network-firewall/model/UniqueSources.h>
#include <aws/network-firewall/model/UntagResourceRequest.h>
#include <aws/network-firewall/model/UntagResourceResult.h>
#include <aws/network-firewall/model/UpdateAvailabilityZoneChangeProtectionRequest.h>
#include <aws/network-firewall/model/UpdateAvailabilityZoneChangeProtectionResult.h>
#include <aws/network-firewall/model/UpdateFirewallAnalysisSettingsRequest.h>
#include <aws/network-firewall/model/UpdateFirewallAnalysisSettingsResult.h>
#include <aws/network-firewall/model/UpdateFirewallDeleteProtectionRequest.h>
#include <aws/network-firewall/model/UpdateFirewallDeleteProtectionResult.h>
#include <aws/network-firewall/model/UpdateFirewallDescriptionRequest.h>
#include <aws/network-firewall/model/UpdateFirewallDescriptionResult.h>
#include <aws/network-firewall/model/UpdateFirewallEncryptionConfigurationRequest.h>
#include <aws/network-firewall/model/UpdateFirewallEncryptionConfigurationResult.h>
#include <aws/network-firewall/model/UpdateFirewallPolicyChangeProtectionRequest.h>
#include <aws/network-firewall/model/UpdateFirewallPolicyChangeProtectionResult.h>
#include <aws/network-firewall/model/UpdateFirewallPolicyRequest.h>
#include <aws/network-firewall/model/UpdateFirewallPolicyResult.h>
#include <aws/network-firewall/model/UpdateLoggingConfigurationRequest.h>
#include <aws/network-firewall/model/UpdateLoggingConfigurationResult.h>
#include <aws/network-firewall/model/UpdateRuleGroupRequest.h>
#include <aws/network-firewall/model/UpdateRuleGroupResult.h>
#include <aws/network-firewall/model/UpdateSubnetChangeProtectionRequest.h>
#include <aws/network-firewall/model/UpdateSubnetChangeProtectionResult.h>
#include <aws/network-firewall/model/UpdateTLSInspectionConfigurationRequest.h>
#include <aws/network-firewall/model/UpdateTLSInspectionConfigurationResult.h>
#include <aws/network-firewall/model/VpcEndpointAssociation.h>
#include <aws/network-firewall/model/VpcEndpointAssociationMetadata.h>
#include <aws/network-firewall/model/VpcEndpointAssociationStatus.h>

using NetworkFirewallIncludeTest = ::testing::Test;

TEST_F(NetworkFirewallIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::NetworkFirewall::NetworkFirewallClient>("NetworkFirewallIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
