/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/networkmanager/NetworkManagerClient.h>
#include <aws/networkmanager/NetworkManagerEndpointProvider.h>
#include <aws/networkmanager/NetworkManagerEndpointRules.h>
#include <aws/networkmanager/NetworkManagerErrorMarshaller.h>
#include <aws/networkmanager/NetworkManagerErrors.h>
#include <aws/networkmanager/NetworkManagerRequest.h>
#include <aws/networkmanager/NetworkManagerServiceClientModel.h>
#include <aws/networkmanager/NetworkManager_EXPORTS.h>
#include <aws/networkmanager/model/AWSLocation.h>
#include <aws/networkmanager/model/AcceptAttachmentRequest.h>
#include <aws/networkmanager/model/AcceptAttachmentResult.h>
#include <aws/networkmanager/model/AccountStatus.h>
#include <aws/networkmanager/model/AssociateConnectPeerRequest.h>
#include <aws/networkmanager/model/AssociateConnectPeerResult.h>
#include <aws/networkmanager/model/AssociateCustomerGatewayRequest.h>
#include <aws/networkmanager/model/AssociateCustomerGatewayResult.h>
#include <aws/networkmanager/model/AssociateLinkRequest.h>
#include <aws/networkmanager/model/AssociateLinkResult.h>
#include <aws/networkmanager/model/AssociateTransitGatewayConnectPeerRequest.h>
#include <aws/networkmanager/model/AssociateTransitGatewayConnectPeerResult.h>
#include <aws/networkmanager/model/Attachment.h>
#include <aws/networkmanager/model/AttachmentError.h>
#include <aws/networkmanager/model/AttachmentErrorCode.h>
#include <aws/networkmanager/model/AttachmentState.h>
#include <aws/networkmanager/model/AttachmentType.h>
#include <aws/networkmanager/model/Bandwidth.h>
#include <aws/networkmanager/model/BgpOptions.h>
#include <aws/networkmanager/model/ChangeAction.h>
#include <aws/networkmanager/model/ChangeSetState.h>
#include <aws/networkmanager/model/ChangeStatus.h>
#include <aws/networkmanager/model/ChangeType.h>
#include <aws/networkmanager/model/ConflictException.h>
#include <aws/networkmanager/model/ConnectAttachment.h>
#include <aws/networkmanager/model/ConnectAttachmentOptions.h>
#include <aws/networkmanager/model/ConnectPeer.h>
#include <aws/networkmanager/model/ConnectPeerAssociation.h>
#include <aws/networkmanager/model/ConnectPeerAssociationState.h>
#include <aws/networkmanager/model/ConnectPeerBgpConfiguration.h>
#include <aws/networkmanager/model/ConnectPeerConfiguration.h>
#include <aws/networkmanager/model/ConnectPeerError.h>
#include <aws/networkmanager/model/ConnectPeerErrorCode.h>
#include <aws/networkmanager/model/ConnectPeerState.h>
#include <aws/networkmanager/model/ConnectPeerSummary.h>
#include <aws/networkmanager/model/Connection.h>
#include <aws/networkmanager/model/ConnectionHealth.h>
#include <aws/networkmanager/model/ConnectionState.h>
#include <aws/networkmanager/model/ConnectionStatus.h>
#include <aws/networkmanager/model/ConnectionType.h>
#include <aws/networkmanager/model/CoreNetwork.h>
#include <aws/networkmanager/model/CoreNetworkChange.h>
#include <aws/networkmanager/model/CoreNetworkChangeEvent.h>
#include <aws/networkmanager/model/CoreNetworkChangeEventValues.h>
#include <aws/networkmanager/model/CoreNetworkChangeValues.h>
#include <aws/networkmanager/model/CoreNetworkEdge.h>
#include <aws/networkmanager/model/CoreNetworkNetworkFunctionGroup.h>
#include <aws/networkmanager/model/CoreNetworkNetworkFunctionGroupIdentifier.h>
#include <aws/networkmanager/model/CoreNetworkPolicy.h>
#include <aws/networkmanager/model/CoreNetworkPolicyAlias.h>
#include <aws/networkmanager/model/CoreNetworkPolicyError.h>
#include <aws/networkmanager/model/CoreNetworkPolicyException.h>
#include <aws/networkmanager/model/CoreNetworkPolicyVersion.h>
#include <aws/networkmanager/model/CoreNetworkSegment.h>
#include <aws/networkmanager/model/CoreNetworkSegmentEdgeIdentifier.h>
#include <aws/networkmanager/model/CoreNetworkState.h>
#include <aws/networkmanager/model/CoreNetworkSummary.h>
#include <aws/networkmanager/model/CreateConnectAttachmentRequest.h>
#include <aws/networkmanager/model/CreateConnectAttachmentResult.h>
#include <aws/networkmanager/model/CreateConnectPeerRequest.h>
#include <aws/networkmanager/model/CreateConnectPeerResult.h>
#include <aws/networkmanager/model/CreateConnectionRequest.h>
#include <aws/networkmanager/model/CreateConnectionResult.h>
#include <aws/networkmanager/model/CreateCoreNetworkRequest.h>
#include <aws/networkmanager/model/CreateCoreNetworkResult.h>
#include <aws/networkmanager/model/CreateDeviceRequest.h>
#include <aws/networkmanager/model/CreateDeviceResult.h>
#include <aws/networkmanager/model/CreateDirectConnectGatewayAttachmentRequest.h>
#include <aws/networkmanager/model/CreateDirectConnectGatewayAttachmentResult.h>
#include <aws/networkmanager/model/CreateGlobalNetworkRequest.h>
#include <aws/networkmanager/model/CreateGlobalNetworkResult.h>
#include <aws/networkmanager/model/CreateLinkRequest.h>
#include <aws/networkmanager/model/CreateLinkResult.h>
#include <aws/networkmanager/model/CreateSiteRequest.h>
#include <aws/networkmanager/model/CreateSiteResult.h>
#include <aws/networkmanager/model/CreateSiteToSiteVpnAttachmentRequest.h>
#include <aws/networkmanager/model/CreateSiteToSiteVpnAttachmentResult.h>
#include <aws/networkmanager/model/CreateTransitGatewayPeeringRequest.h>
#include <aws/networkmanager/model/CreateTransitGatewayPeeringResult.h>
#include <aws/networkmanager/model/CreateTransitGatewayRouteTableAttachmentRequest.h>
#include <aws/networkmanager/model/CreateTransitGatewayRouteTableAttachmentResult.h>
#include <aws/networkmanager/model/CreateVpcAttachmentRequest.h>
#include <aws/networkmanager/model/CreateVpcAttachmentResult.h>
#include <aws/networkmanager/model/CustomerGatewayAssociation.h>
#include <aws/networkmanager/model/CustomerGatewayAssociationState.h>
#include <aws/networkmanager/model/DeleteAttachmentRequest.h>
#include <aws/networkmanager/model/DeleteAttachmentResult.h>
#include <aws/networkmanager/model/DeleteConnectPeerRequest.h>
#include <aws/networkmanager/model/DeleteConnectPeerResult.h>
#include <aws/networkmanager/model/DeleteConnectionRequest.h>
#include <aws/networkmanager/model/DeleteConnectionResult.h>
#include <aws/networkmanager/model/DeleteCoreNetworkPolicyVersionRequest.h>
#include <aws/networkmanager/model/DeleteCoreNetworkPolicyVersionResult.h>
#include <aws/networkmanager/model/DeleteCoreNetworkRequest.h>
#include <aws/networkmanager/model/DeleteCoreNetworkResult.h>
#include <aws/networkmanager/model/DeleteDeviceRequest.h>
#include <aws/networkmanager/model/DeleteDeviceResult.h>
#include <aws/networkmanager/model/DeleteGlobalNetworkRequest.h>
#include <aws/networkmanager/model/DeleteGlobalNetworkResult.h>
#include <aws/networkmanager/model/DeleteLinkRequest.h>
#include <aws/networkmanager/model/DeleteLinkResult.h>
#include <aws/networkmanager/model/DeletePeeringRequest.h>
#include <aws/networkmanager/model/DeletePeeringResult.h>
#include <aws/networkmanager/model/DeleteResourcePolicyRequest.h>
#include <aws/networkmanager/model/DeleteResourcePolicyResult.h>
#include <aws/networkmanager/model/DeleteSiteRequest.h>
#include <aws/networkmanager/model/DeleteSiteResult.h>
#include <aws/networkmanager/model/DeregisterTransitGatewayRequest.h>
#include <aws/networkmanager/model/DeregisterTransitGatewayResult.h>
#include <aws/networkmanager/model/DescribeGlobalNetworksRequest.h>
#include <aws/networkmanager/model/DescribeGlobalNetworksResult.h>
#include <aws/networkmanager/model/Device.h>
#include <aws/networkmanager/model/DeviceState.h>
#include <aws/networkmanager/model/DirectConnectGatewayAttachment.h>
#include <aws/networkmanager/model/DisassociateConnectPeerRequest.h>
#include <aws/networkmanager/model/DisassociateConnectPeerResult.h>
#include <aws/networkmanager/model/DisassociateCustomerGatewayRequest.h>
#include <aws/networkmanager/model/DisassociateCustomerGatewayResult.h>
#include <aws/networkmanager/model/DisassociateLinkRequest.h>
#include <aws/networkmanager/model/DisassociateLinkResult.h>
#include <aws/networkmanager/model/DisassociateTransitGatewayConnectPeerRequest.h>
#include <aws/networkmanager/model/DisassociateTransitGatewayConnectPeerResult.h>
#include <aws/networkmanager/model/EdgeOverride.h>
#include <aws/networkmanager/model/ExecuteCoreNetworkChangeSetRequest.h>
#include <aws/networkmanager/model/ExecuteCoreNetworkChangeSetResult.h>
#include <aws/networkmanager/model/GetConnectAttachmentRequest.h>
#include <aws/networkmanager/model/GetConnectAttachmentResult.h>
#include <aws/networkmanager/model/GetConnectPeerAssociationsRequest.h>
#include <aws/networkmanager/model/GetConnectPeerAssociationsResult.h>
#include <aws/networkmanager/model/GetConnectPeerRequest.h>
#include <aws/networkmanager/model/GetConnectPeerResult.h>
#include <aws/networkmanager/model/GetConnectionsRequest.h>
#include <aws/networkmanager/model/GetConnectionsResult.h>
#include <aws/networkmanager/model/GetCoreNetworkChangeEventsRequest.h>
#include <aws/networkmanager/model/GetCoreNetworkChangeEventsResult.h>
#include <aws/networkmanager/model/GetCoreNetworkChangeSetRequest.h>
#include <aws/networkmanager/model/GetCoreNetworkChangeSetResult.h>
#include <aws/networkmanager/model/GetCoreNetworkPolicyRequest.h>
#include <aws/networkmanager/model/GetCoreNetworkPolicyResult.h>
#include <aws/networkmanager/model/GetCoreNetworkRequest.h>
#include <aws/networkmanager/model/GetCoreNetworkResult.h>
#include <aws/networkmanager/model/GetCustomerGatewayAssociationsRequest.h>
#include <aws/networkmanager/model/GetCustomerGatewayAssociationsResult.h>
#include <aws/networkmanager/model/GetDevicesRequest.h>
#include <aws/networkmanager/model/GetDevicesResult.h>
#include <aws/networkmanager/model/GetDirectConnectGatewayAttachmentRequest.h>
#include <aws/networkmanager/model/GetDirectConnectGatewayAttachmentResult.h>
#include <aws/networkmanager/model/GetLinkAssociationsRequest.h>
#include <aws/networkmanager/model/GetLinkAssociationsResult.h>
#include <aws/networkmanager/model/GetLinksRequest.h>
#include <aws/networkmanager/model/GetLinksResult.h>
#include <aws/networkmanager/model/GetNetworkResourceCountsRequest.h>
#include <aws/networkmanager/model/GetNetworkResourceCountsResult.h>
#include <aws/networkmanager/model/GetNetworkResourceRelationshipsRequest.h>
#include <aws/networkmanager/model/GetNetworkResourceRelationshipsResult.h>
#include <aws/networkmanager/model/GetNetworkResourcesRequest.h>
#include <aws/networkmanager/model/GetNetworkResourcesResult.h>
#include <aws/networkmanager/model/GetNetworkRoutesRequest.h>
#include <aws/networkmanager/model/GetNetworkRoutesResult.h>
#include <aws/networkmanager/model/GetNetworkTelemetryRequest.h>
#include <aws/networkmanager/model/GetNetworkTelemetryResult.h>
#include <aws/networkmanager/model/GetResourcePolicyRequest.h>
#include <aws/networkmanager/model/GetResourcePolicyResult.h>
#include <aws/networkmanager/model/GetRouteAnalysisRequest.h>
#include <aws/networkmanager/model/GetRouteAnalysisResult.h>
#include <aws/networkmanager/model/GetSiteToSiteVpnAttachmentRequest.h>
#include <aws/networkmanager/model/GetSiteToSiteVpnAttachmentResult.h>
#include <aws/networkmanager/model/GetSitesRequest.h>
#include <aws/networkmanager/model/GetSitesResult.h>
#include <aws/networkmanager/model/GetTransitGatewayConnectPeerAssociationsRequest.h>
#include <aws/networkmanager/model/GetTransitGatewayConnectPeerAssociationsResult.h>
#include <aws/networkmanager/model/GetTransitGatewayPeeringRequest.h>
#include <aws/networkmanager/model/GetTransitGatewayPeeringResult.h>
#include <aws/networkmanager/model/GetTransitGatewayRegistrationsRequest.h>
#include <aws/networkmanager/model/GetTransitGatewayRegistrationsResult.h>
#include <aws/networkmanager/model/GetTransitGatewayRouteTableAttachmentRequest.h>
#include <aws/networkmanager/model/GetTransitGatewayRouteTableAttachmentResult.h>
#include <aws/networkmanager/model/GetVpcAttachmentRequest.h>
#include <aws/networkmanager/model/GetVpcAttachmentResult.h>
#include <aws/networkmanager/model/GlobalNetwork.h>
#include <aws/networkmanager/model/GlobalNetworkState.h>
#include <aws/networkmanager/model/InternalServerException.h>
#include <aws/networkmanager/model/Link.h>
#include <aws/networkmanager/model/LinkAssociation.h>
#include <aws/networkmanager/model/LinkAssociationState.h>
#include <aws/networkmanager/model/LinkState.h>
#include <aws/networkmanager/model/ListAttachmentsRequest.h>
#include <aws/networkmanager/model/ListAttachmentsResult.h>
#include <aws/networkmanager/model/ListConnectPeersRequest.h>
#include <aws/networkmanager/model/ListConnectPeersResult.h>
#include <aws/networkmanager/model/ListCoreNetworkPolicyVersionsRequest.h>
#include <aws/networkmanager/model/ListCoreNetworkPolicyVersionsResult.h>
#include <aws/networkmanager/model/ListCoreNetworksRequest.h>
#include <aws/networkmanager/model/ListCoreNetworksResult.h>
#include <aws/networkmanager/model/ListOrganizationServiceAccessStatusRequest.h>
#include <aws/networkmanager/model/ListOrganizationServiceAccessStatusResult.h>
#include <aws/networkmanager/model/ListPeeringsRequest.h>
#include <aws/networkmanager/model/ListPeeringsResult.h>
#include <aws/networkmanager/model/ListTagsForResourceRequest.h>
#include <aws/networkmanager/model/ListTagsForResourceResult.h>
#include <aws/networkmanager/model/Location.h>
#include <aws/networkmanager/model/NetworkFunctionGroup.h>
#include <aws/networkmanager/model/NetworkResource.h>
#include <aws/networkmanager/model/NetworkResourceCount.h>
#include <aws/networkmanager/model/NetworkResourceSummary.h>
#include <aws/networkmanager/model/NetworkRoute.h>
#include <aws/networkmanager/model/NetworkRouteDestination.h>
#include <aws/networkmanager/model/NetworkTelemetry.h>
#include <aws/networkmanager/model/OrganizationStatus.h>
#include <aws/networkmanager/model/PathComponent.h>
#include <aws/networkmanager/model/Peering.h>
#include <aws/networkmanager/model/PeeringError.h>
#include <aws/networkmanager/model/PeeringErrorCode.h>
#include <aws/networkmanager/model/PeeringState.h>
#include <aws/networkmanager/model/PeeringType.h>
#include <aws/networkmanager/model/PermissionsErrorContext.h>
#include <aws/networkmanager/model/ProposedNetworkFunctionGroupChange.h>
#include <aws/networkmanager/model/ProposedSegmentChange.h>
#include <aws/networkmanager/model/PutCoreNetworkPolicyRequest.h>
#include <aws/networkmanager/model/PutCoreNetworkPolicyResult.h>
#include <aws/networkmanager/model/PutResourcePolicyRequest.h>
#include <aws/networkmanager/model/PutResourcePolicyResult.h>
#include <aws/networkmanager/model/RegisterTransitGatewayRequest.h>
#include <aws/networkmanager/model/RegisterTransitGatewayResult.h>
#include <aws/networkmanager/model/RejectAttachmentRequest.h>
#include <aws/networkmanager/model/RejectAttachmentResult.h>
#include <aws/networkmanager/model/Relationship.h>
#include <aws/networkmanager/model/ResourceNotFoundException.h>
#include <aws/networkmanager/model/RestoreCoreNetworkPolicyVersionRequest.h>
#include <aws/networkmanager/model/RestoreCoreNetworkPolicyVersionResult.h>
#include <aws/networkmanager/model/RouteAnalysis.h>
#include <aws/networkmanager/model/RouteAnalysisCompletion.h>
#include <aws/networkmanager/model/RouteAnalysisCompletionReasonCode.h>
#include <aws/networkmanager/model/RouteAnalysisCompletionResultCode.h>
#include <aws/networkmanager/model/RouteAnalysisEndpointOptions.h>
#include <aws/networkmanager/model/RouteAnalysisEndpointOptionsSpecification.h>
#include <aws/networkmanager/model/RouteAnalysisPath.h>
#include <aws/networkmanager/model/RouteAnalysisStatus.h>
#include <aws/networkmanager/model/RouteState.h>
#include <aws/networkmanager/model/RouteTableIdentifier.h>
#include <aws/networkmanager/model/RouteTableType.h>
#include <aws/networkmanager/model/RouteType.h>
#include <aws/networkmanager/model/SegmentActionServiceInsertion.h>
#include <aws/networkmanager/model/SendViaMode.h>
#include <aws/networkmanager/model/ServiceInsertionAction.h>
#include <aws/networkmanager/model/ServiceInsertionSegments.h>
#include <aws/networkmanager/model/ServiceQuotaExceededException.h>
#include <aws/networkmanager/model/Site.h>
#include <aws/networkmanager/model/SiteState.h>
#include <aws/networkmanager/model/SiteToSiteVpnAttachment.h>
#include <aws/networkmanager/model/StartOrganizationServiceAccessUpdateRequest.h>
#include <aws/networkmanager/model/StartOrganizationServiceAccessUpdateResult.h>
#include <aws/networkmanager/model/StartRouteAnalysisRequest.h>
#include <aws/networkmanager/model/StartRouteAnalysisResult.h>
#include <aws/networkmanager/model/Tag.h>
#include <aws/networkmanager/model/TagResourceRequest.h>
#include <aws/networkmanager/model/TagResourceResult.h>
#include <aws/networkmanager/model/ThrottlingException.h>
#include <aws/networkmanager/model/TransitGatewayConnectPeerAssociation.h>
#include <aws/networkmanager/model/TransitGatewayConnectPeerAssociationState.h>
#include <aws/networkmanager/model/TransitGatewayPeering.h>
#include <aws/networkmanager/model/TransitGatewayRegistration.h>
#include <aws/networkmanager/model/TransitGatewayRegistrationState.h>
#include <aws/networkmanager/model/TransitGatewayRegistrationStateReason.h>
#include <aws/networkmanager/model/TransitGatewayRouteTableAttachment.h>
#include <aws/networkmanager/model/TunnelProtocol.h>
#include <aws/networkmanager/model/UntagResourceRequest.h>
#include <aws/networkmanager/model/UntagResourceResult.h>
#include <aws/networkmanager/model/UpdateConnectionRequest.h>
#include <aws/networkmanager/model/UpdateConnectionResult.h>
#include <aws/networkmanager/model/UpdateCoreNetworkRequest.h>
#include <aws/networkmanager/model/UpdateCoreNetworkResult.h>
#include <aws/networkmanager/model/UpdateDeviceRequest.h>
#include <aws/networkmanager/model/UpdateDeviceResult.h>
#include <aws/networkmanager/model/UpdateDirectConnectGatewayAttachmentRequest.h>
#include <aws/networkmanager/model/UpdateDirectConnectGatewayAttachmentResult.h>
#include <aws/networkmanager/model/UpdateGlobalNetworkRequest.h>
#include <aws/networkmanager/model/UpdateGlobalNetworkResult.h>
#include <aws/networkmanager/model/UpdateLinkRequest.h>
#include <aws/networkmanager/model/UpdateLinkResult.h>
#include <aws/networkmanager/model/UpdateNetworkResourceMetadataRequest.h>
#include <aws/networkmanager/model/UpdateNetworkResourceMetadataResult.h>
#include <aws/networkmanager/model/UpdateSiteRequest.h>
#include <aws/networkmanager/model/UpdateSiteResult.h>
#include <aws/networkmanager/model/UpdateVpcAttachmentRequest.h>
#include <aws/networkmanager/model/UpdateVpcAttachmentResult.h>
#include <aws/networkmanager/model/ValidationException.h>
#include <aws/networkmanager/model/ValidationExceptionField.h>
#include <aws/networkmanager/model/ValidationExceptionReason.h>
#include <aws/networkmanager/model/Via.h>
#include <aws/networkmanager/model/VpcAttachment.h>
#include <aws/networkmanager/model/VpcOptions.h>
#include <aws/networkmanager/model/WhenSentTo.h>

using NetworkManagerIncludeTest = ::testing::Test;

TEST_F(NetworkManagerIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::NetworkManager::NetworkManagerClient>("NetworkManagerIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
