/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/omics/OmicsClient.h>
#include <aws/omics/OmicsEndpointProvider.h>
#include <aws/omics/OmicsEndpointRules.h>
#include <aws/omics/OmicsErrorMarshaller.h>
#include <aws/omics/OmicsErrors.h>
#include <aws/omics/OmicsRequest.h>
#include <aws/omics/OmicsServiceClientModel.h>
#include <aws/omics/Omics_EXPORTS.h>
#include <aws/omics/model/AbortMultipartReadSetUploadRequest.h>
#include <aws/omics/model/AbortMultipartReadSetUploadResult.h>
#include <aws/omics/model/Accelerators.h>
#include <aws/omics/model/AcceptShareRequest.h>
#include <aws/omics/model/AcceptShareResult.h>
#include <aws/omics/model/ActivateReadSetFilter.h>
#include <aws/omics/model/ActivateReadSetJobItem.h>
#include <aws/omics/model/ActivateReadSetSourceItem.h>
#include <aws/omics/model/AnnotationImportItemDetail.h>
#include <aws/omics/model/AnnotationImportItemSource.h>
#include <aws/omics/model/AnnotationImportJobItem.h>
#include <aws/omics/model/AnnotationStoreItem.h>
#include <aws/omics/model/AnnotationStoreVersionItem.h>
#include <aws/omics/model/AnnotationType.h>
#include <aws/omics/model/BatchDeleteReadSetRequest.h>
#include <aws/omics/model/BatchDeleteReadSetResult.h>
#include <aws/omics/model/CacheBehavior.h>
#include <aws/omics/model/CancelAnnotationImportJobRequest.h>
#include <aws/omics/model/CancelAnnotationImportJobResult.h>
#include <aws/omics/model/CancelRunRequest.h>
#include <aws/omics/model/CancelVariantImportJobRequest.h>
#include <aws/omics/model/CancelVariantImportJobResult.h>
#include <aws/omics/model/CompleteMultipartReadSetUploadRequest.h>
#include <aws/omics/model/CompleteMultipartReadSetUploadResult.h>
#include <aws/omics/model/CompleteReadSetUploadPartListItem.h>
#include <aws/omics/model/CreateAnnotationStoreRequest.h>
#include <aws/omics/model/CreateAnnotationStoreResult.h>
#include <aws/omics/model/CreateAnnotationStoreVersionRequest.h>
#include <aws/omics/model/CreateAnnotationStoreVersionResult.h>
#include <aws/omics/model/CreateMultipartReadSetUploadRequest.h>
#include <aws/omics/model/CreateMultipartReadSetUploadResult.h>
#include <aws/omics/model/CreateReferenceStoreRequest.h>
#include <aws/omics/model/CreateReferenceStoreResult.h>
#include <aws/omics/model/CreateRunCacheRequest.h>
#include <aws/omics/model/CreateRunCacheResult.h>
#include <aws/omics/model/CreateRunGroupRequest.h>
#include <aws/omics/model/CreateRunGroupResult.h>
#include <aws/omics/model/CreateSequenceStoreRequest.h>
#include <aws/omics/model/CreateSequenceStoreResult.h>
#include <aws/omics/model/CreateShareRequest.h>
#include <aws/omics/model/CreateShareResult.h>
#include <aws/omics/model/CreateVariantStoreRequest.h>
#include <aws/omics/model/CreateVariantStoreResult.h>
#include <aws/omics/model/CreateWorkflowRequest.h>
#include <aws/omics/model/CreateWorkflowResult.h>
#include <aws/omics/model/CreateWorkflowVersionRequest.h>
#include <aws/omics/model/CreateWorkflowVersionResult.h>
#include <aws/omics/model/CreationType.h>
#include <aws/omics/model/DeleteAnnotationStoreRequest.h>
#include <aws/omics/model/DeleteAnnotationStoreResult.h>
#include <aws/omics/model/DeleteAnnotationStoreVersionsRequest.h>
#include <aws/omics/model/DeleteAnnotationStoreVersionsResult.h>
#include <aws/omics/model/DeleteReferenceRequest.h>
#include <aws/omics/model/DeleteReferenceResult.h>
#include <aws/omics/model/DeleteReferenceStoreRequest.h>
#include <aws/omics/model/DeleteReferenceStoreResult.h>
#include <aws/omics/model/DeleteRunCacheRequest.h>
#include <aws/omics/model/DeleteRunGroupRequest.h>
#include <aws/omics/model/DeleteRunRequest.h>
#include <aws/omics/model/DeleteS3AccessPolicyRequest.h>
#include <aws/omics/model/DeleteS3AccessPolicyResult.h>
#include <aws/omics/model/DeleteSequenceStoreRequest.h>
#include <aws/omics/model/DeleteSequenceStoreResult.h>
#include <aws/omics/model/DeleteShareRequest.h>
#include <aws/omics/model/DeleteShareResult.h>
#include <aws/omics/model/DeleteVariantStoreRequest.h>
#include <aws/omics/model/DeleteVariantStoreResult.h>
#include <aws/omics/model/DeleteWorkflowRequest.h>
#include <aws/omics/model/DeleteWorkflowVersionRequest.h>
#include <aws/omics/model/ETag.h>
#include <aws/omics/model/ETagAlgorithm.h>
#include <aws/omics/model/ETagAlgorithmFamily.h>
#include <aws/omics/model/EncryptionType.h>
#include <aws/omics/model/ExportReadSet.h>
#include <aws/omics/model/ExportReadSetDetail.h>
#include <aws/omics/model/ExportReadSetFilter.h>
#include <aws/omics/model/ExportReadSetJobDetail.h>
#include <aws/omics/model/FileInformation.h>
#include <aws/omics/model/FileType.h>
#include <aws/omics/model/Filter.h>
#include <aws/omics/model/FormatOptions.h>
#include <aws/omics/model/FormatToHeaderKey.h>
#include <aws/omics/model/GetAnnotationImportJobRequest.h>
#include <aws/omics/model/GetAnnotationImportJobResult.h>
#include <aws/omics/model/GetAnnotationStoreRequest.h>
#include <aws/omics/model/GetAnnotationStoreResult.h>
#include <aws/omics/model/GetAnnotationStoreVersionRequest.h>
#include <aws/omics/model/GetAnnotationStoreVersionResult.h>
#include <aws/omics/model/GetReadSetActivationJobRequest.h>
#include <aws/omics/model/GetReadSetActivationJobResult.h>
#include <aws/omics/model/GetReadSetExportJobRequest.h>
#include <aws/omics/model/GetReadSetExportJobResult.h>
#include <aws/omics/model/GetReadSetImportJobRequest.h>
#include <aws/omics/model/GetReadSetImportJobResult.h>
#include <aws/omics/model/GetReadSetMetadataRequest.h>
#include <aws/omics/model/GetReadSetMetadataResult.h>
#include <aws/omics/model/GetReadSetRequest.h>
#include <aws/omics/model/GetReadSetResult.h>
#include <aws/omics/model/GetReferenceImportJobRequest.h>
#include <aws/omics/model/GetReferenceImportJobResult.h>
#include <aws/omics/model/GetReferenceMetadataRequest.h>
#include <aws/omics/model/GetReferenceMetadataResult.h>
#include <aws/omics/model/GetReferenceRequest.h>
#include <aws/omics/model/GetReferenceResult.h>
#include <aws/omics/model/GetReferenceStoreRequest.h>
#include <aws/omics/model/GetReferenceStoreResult.h>
#include <aws/omics/model/GetRunCacheRequest.h>
#include <aws/omics/model/GetRunCacheResult.h>
#include <aws/omics/model/GetRunGroupRequest.h>
#include <aws/omics/model/GetRunGroupResult.h>
#include <aws/omics/model/GetRunRequest.h>
#include <aws/omics/model/GetRunResult.h>
#include <aws/omics/model/GetRunTaskRequest.h>
#include <aws/omics/model/GetRunTaskResult.h>
#include <aws/omics/model/GetS3AccessPolicyRequest.h>
#include <aws/omics/model/GetS3AccessPolicyResult.h>
#include <aws/omics/model/GetSequenceStoreRequest.h>
#include <aws/omics/model/GetSequenceStoreResult.h>
#include <aws/omics/model/GetShareRequest.h>
#include <aws/omics/model/GetShareResult.h>
#include <aws/omics/model/GetVariantImportJobRequest.h>
#include <aws/omics/model/GetVariantImportJobResult.h>
#include <aws/omics/model/GetVariantStoreRequest.h>
#include <aws/omics/model/GetVariantStoreResult.h>
#include <aws/omics/model/GetWorkflowRequest.h>
#include <aws/omics/model/GetWorkflowResult.h>
#include <aws/omics/model/GetWorkflowVersionRequest.h>
#include <aws/omics/model/GetWorkflowVersionResult.h>
#include <aws/omics/model/ImportReadSetFilter.h>
#include <aws/omics/model/ImportReadSetJobItem.h>
#include <aws/omics/model/ImportReadSetSourceItem.h>
#include <aws/omics/model/ImportReferenceFilter.h>
#include <aws/omics/model/ImportReferenceJobItem.h>
#include <aws/omics/model/ImportReferenceSourceItem.h>
#include <aws/omics/model/JobStatus.h>
#include <aws/omics/model/ListAnnotationImportJobsFilter.h>
#include <aws/omics/model/ListAnnotationImportJobsRequest.h>
#include <aws/omics/model/ListAnnotationImportJobsResult.h>
#include <aws/omics/model/ListAnnotationStoreVersionsFilter.h>
#include <aws/omics/model/ListAnnotationStoreVersionsRequest.h>
#include <aws/omics/model/ListAnnotationStoreVersionsResult.h>
#include <aws/omics/model/ListAnnotationStoresFilter.h>
#include <aws/omics/model/ListAnnotationStoresRequest.h>
#include <aws/omics/model/ListAnnotationStoresResult.h>
#include <aws/omics/model/ListMultipartReadSetUploadsRequest.h>
#include <aws/omics/model/ListMultipartReadSetUploadsResult.h>
#include <aws/omics/model/ListReadSetActivationJobsRequest.h>
#include <aws/omics/model/ListReadSetActivationJobsResult.h>
#include <aws/omics/model/ListReadSetExportJobsRequest.h>
#include <aws/omics/model/ListReadSetExportJobsResult.h>
#include <aws/omics/model/ListReadSetImportJobsRequest.h>
#include <aws/omics/model/ListReadSetImportJobsResult.h>
#include <aws/omics/model/ListReadSetUploadPartsRequest.h>
#include <aws/omics/model/ListReadSetUploadPartsResult.h>
#include <aws/omics/model/ListReadSetsRequest.h>
#include <aws/omics/model/ListReadSetsResult.h>
#include <aws/omics/model/ListReferenceImportJobsRequest.h>
#include <aws/omics/model/ListReferenceImportJobsResult.h>
#include <aws/omics/model/ListReferenceStoresRequest.h>
#include <aws/omics/model/ListReferenceStoresResult.h>
#include <aws/omics/model/ListReferencesRequest.h>
#include <aws/omics/model/ListReferencesResult.h>
#include <aws/omics/model/ListRunCachesRequest.h>
#include <aws/omics/model/ListRunCachesResult.h>
#include <aws/omics/model/ListRunGroupsRequest.h>
#include <aws/omics/model/ListRunGroupsResult.h>
#include <aws/omics/model/ListRunTasksRequest.h>
#include <aws/omics/model/ListRunTasksResult.h>
#include <aws/omics/model/ListRunsRequest.h>
#include <aws/omics/model/ListRunsResult.h>
#include <aws/omics/model/ListSequenceStoresRequest.h>
#include <aws/omics/model/ListSequenceStoresResult.h>
#include <aws/omics/model/ListSharesRequest.h>
#include <aws/omics/model/ListSharesResult.h>
#include <aws/omics/model/ListTagsForResourceRequest.h>
#include <aws/omics/model/ListTagsForResourceResult.h>
#include <aws/omics/model/ListVariantImportJobsFilter.h>
#include <aws/omics/model/ListVariantImportJobsRequest.h>
#include <aws/omics/model/ListVariantImportJobsResult.h>
#include <aws/omics/model/ListVariantStoresFilter.h>
#include <aws/omics/model/ListVariantStoresRequest.h>
#include <aws/omics/model/ListVariantStoresResult.h>
#include <aws/omics/model/ListWorkflowVersionsRequest.h>
#include <aws/omics/model/ListWorkflowVersionsResult.h>
#include <aws/omics/model/ListWorkflowsRequest.h>
#include <aws/omics/model/ListWorkflowsResult.h>
#include <aws/omics/model/MultipartReadSetUploadListItem.h>
#include <aws/omics/model/PutS3AccessPolicyRequest.h>
#include <aws/omics/model/PutS3AccessPolicyResult.h>
#include <aws/omics/model/ReadOptions.h>
#include <aws/omics/model/ReadSetActivationJobItemStatus.h>
#include <aws/omics/model/ReadSetActivationJobStatus.h>
#include <aws/omics/model/ReadSetBatchError.h>
#include <aws/omics/model/ReadSetExportJobItemStatus.h>
#include <aws/omics/model/ReadSetExportJobStatus.h>
#include <aws/omics/model/ReadSetFile.h>
#include <aws/omics/model/ReadSetFiles.h>
#include <aws/omics/model/ReadSetFilter.h>
#include <aws/omics/model/ReadSetImportJobItemStatus.h>
#include <aws/omics/model/ReadSetImportJobStatus.h>
#include <aws/omics/model/ReadSetListItem.h>
#include <aws/omics/model/ReadSetPartSource.h>
#include <aws/omics/model/ReadSetS3Access.h>
#include <aws/omics/model/ReadSetStatus.h>
#include <aws/omics/model/ReadSetUploadPartListFilter.h>
#include <aws/omics/model/ReadSetUploadPartListItem.h>
#include <aws/omics/model/ReferenceCreationType.h>
#include <aws/omics/model/ReferenceFile.h>
#include <aws/omics/model/ReferenceFiles.h>
#include <aws/omics/model/ReferenceFilter.h>
#include <aws/omics/model/ReferenceImportJobItemStatus.h>
#include <aws/omics/model/ReferenceImportJobStatus.h>
#include <aws/omics/model/ReferenceItem.h>
#include <aws/omics/model/ReferenceListItem.h>
#include <aws/omics/model/ReferenceStatus.h>
#include <aws/omics/model/ReferenceStoreDetail.h>
#include <aws/omics/model/ReferenceStoreFilter.h>
#include <aws/omics/model/ResourceOwner.h>
#include <aws/omics/model/RunCacheListItem.h>
#include <aws/omics/model/RunCacheStatus.h>
#include <aws/omics/model/RunExport.h>
#include <aws/omics/model/RunGroupListItem.h>
#include <aws/omics/model/RunListItem.h>
#include <aws/omics/model/RunLogLevel.h>
#include <aws/omics/model/RunLogLocation.h>
#include <aws/omics/model/RunRetentionMode.h>
#include <aws/omics/model/RunStatus.h>
#include <aws/omics/model/S3AccessConfig.h>
#include <aws/omics/model/SchemaValueType.h>
#include <aws/omics/model/SequenceInformation.h>
#include <aws/omics/model/SequenceStoreDetail.h>
#include <aws/omics/model/SequenceStoreFilter.h>
#include <aws/omics/model/SequenceStoreS3Access.h>
#include <aws/omics/model/SequenceStoreStatus.h>
#include <aws/omics/model/ShareDetails.h>
#include <aws/omics/model/ShareResourceType.h>
#include <aws/omics/model/ShareStatus.h>
#include <aws/omics/model/SourceFiles.h>
#include <aws/omics/model/SseConfig.h>
#include <aws/omics/model/StartAnnotationImportJobRequest.h>
#include <aws/omics/model/StartAnnotationImportJobResult.h>
#include <aws/omics/model/StartReadSetActivationJobRequest.h>
#include <aws/omics/model/StartReadSetActivationJobResult.h>
#include <aws/omics/model/StartReadSetActivationJobSourceItem.h>
#include <aws/omics/model/StartReadSetExportJobRequest.h>
#include <aws/omics/model/StartReadSetExportJobResult.h>
#include <aws/omics/model/StartReadSetImportJobRequest.h>
#include <aws/omics/model/StartReadSetImportJobResult.h>
#include <aws/omics/model/StartReadSetImportJobSourceItem.h>
#include <aws/omics/model/StartReferenceImportJobRequest.h>
#include <aws/omics/model/StartReferenceImportJobResult.h>
#include <aws/omics/model/StartReferenceImportJobSourceItem.h>
#include <aws/omics/model/StartRunRequest.h>
#include <aws/omics/model/StartRunResult.h>
#include <aws/omics/model/StartVariantImportJobRequest.h>
#include <aws/omics/model/StartVariantImportJobResult.h>
#include <aws/omics/model/StorageType.h>
#include <aws/omics/model/StoreFormat.h>
#include <aws/omics/model/StoreOptions.h>
#include <aws/omics/model/StoreStatus.h>
#include <aws/omics/model/StoreType.h>
#include <aws/omics/model/TagResourceRequest.h>
#include <aws/omics/model/TagResourceResult.h>
#include <aws/omics/model/TaskListItem.h>
#include <aws/omics/model/TaskStatus.h>
#include <aws/omics/model/TsvOptions.h>
#include <aws/omics/model/TsvStoreOptions.h>
#include <aws/omics/model/TsvVersionOptions.h>
#include <aws/omics/model/UntagResourceRequest.h>
#include <aws/omics/model/UntagResourceResult.h>
#include <aws/omics/model/UpdateAnnotationStoreRequest.h>
#include <aws/omics/model/UpdateAnnotationStoreResult.h>
#include <aws/omics/model/UpdateAnnotationStoreVersionRequest.h>
#include <aws/omics/model/UpdateAnnotationStoreVersionResult.h>
#include <aws/omics/model/UpdateRunCacheRequest.h>
#include <aws/omics/model/UpdateRunGroupRequest.h>
#include <aws/omics/model/UpdateSequenceStoreRequest.h>
#include <aws/omics/model/UpdateSequenceStoreResult.h>
#include <aws/omics/model/UpdateVariantStoreRequest.h>
#include <aws/omics/model/UpdateVariantStoreResult.h>
#include <aws/omics/model/UpdateWorkflowRequest.h>
#include <aws/omics/model/UpdateWorkflowVersionRequest.h>
#include <aws/omics/model/UploadReadSetPartRequest.h>
#include <aws/omics/model/UploadReadSetPartResult.h>
#include <aws/omics/model/VariantImportItemDetail.h>
#include <aws/omics/model/VariantImportItemSource.h>
#include <aws/omics/model/VariantImportJobItem.h>
#include <aws/omics/model/VariantStoreItem.h>
#include <aws/omics/model/VcfOptions.h>
#include <aws/omics/model/VersionDeleteError.h>
#include <aws/omics/model/VersionOptions.h>
#include <aws/omics/model/VersionStatus.h>
#include <aws/omics/model/WorkflowEngine.h>
#include <aws/omics/model/WorkflowExport.h>
#include <aws/omics/model/WorkflowListItem.h>
#include <aws/omics/model/WorkflowParameter.h>
#include <aws/omics/model/WorkflowStatus.h>
#include <aws/omics/model/WorkflowType.h>
#include <aws/omics/model/WorkflowVersionListItem.h>

using OmicsIncludeTest = ::testing::Test;

TEST_F(OmicsIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::Omics::OmicsClient>("OmicsIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
