/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/opsworks/OpsWorksClient.h>
#include <aws/opsworks/OpsWorksEndpointProvider.h>
#include <aws/opsworks/OpsWorksEndpointRules.h>
#include <aws/opsworks/OpsWorksErrorMarshaller.h>
#include <aws/opsworks/OpsWorksErrors.h>
#include <aws/opsworks/OpsWorksRequest.h>
#include <aws/opsworks/OpsWorksServiceClientModel.h>
#include <aws/opsworks/OpsWorks_EXPORTS.h>
#include <aws/opsworks/model/AgentVersion.h>
#include <aws/opsworks/model/App.h>
#include <aws/opsworks/model/AppAttributesKeys.h>
#include <aws/opsworks/model/AppType.h>
#include <aws/opsworks/model/Architecture.h>
#include <aws/opsworks/model/AssignInstanceRequest.h>
#include <aws/opsworks/model/AssignVolumeRequest.h>
#include <aws/opsworks/model/AssociateElasticIpRequest.h>
#include <aws/opsworks/model/AttachElasticLoadBalancerRequest.h>
#include <aws/opsworks/model/AutoScalingThresholds.h>
#include <aws/opsworks/model/AutoScalingType.h>
#include <aws/opsworks/model/BlockDeviceMapping.h>
#include <aws/opsworks/model/ChefConfiguration.h>
#include <aws/opsworks/model/CloneStackRequest.h>
#include <aws/opsworks/model/CloneStackResult.h>
#include <aws/opsworks/model/CloudWatchLogsConfiguration.h>
#include <aws/opsworks/model/CloudWatchLogsEncoding.h>
#include <aws/opsworks/model/CloudWatchLogsInitialPosition.h>
#include <aws/opsworks/model/CloudWatchLogsLogStream.h>
#include <aws/opsworks/model/CloudWatchLogsTimeZone.h>
#include <aws/opsworks/model/Command.h>
#include <aws/opsworks/model/CreateAppRequest.h>
#include <aws/opsworks/model/CreateAppResult.h>
#include <aws/opsworks/model/CreateDeploymentRequest.h>
#include <aws/opsworks/model/CreateDeploymentResult.h>
#include <aws/opsworks/model/CreateInstanceRequest.h>
#include <aws/opsworks/model/CreateInstanceResult.h>
#include <aws/opsworks/model/CreateLayerRequest.h>
#include <aws/opsworks/model/CreateLayerResult.h>
#include <aws/opsworks/model/CreateStackRequest.h>
#include <aws/opsworks/model/CreateStackResult.h>
#include <aws/opsworks/model/CreateUserProfileRequest.h>
#include <aws/opsworks/model/CreateUserProfileResult.h>
#include <aws/opsworks/model/DataSource.h>
#include <aws/opsworks/model/DeleteAppRequest.h>
#include <aws/opsworks/model/DeleteInstanceRequest.h>
#include <aws/opsworks/model/DeleteLayerRequest.h>
#include <aws/opsworks/model/DeleteStackRequest.h>
#include <aws/opsworks/model/DeleteUserProfileRequest.h>
#include <aws/opsworks/model/Deployment.h>
#include <aws/opsworks/model/DeploymentCommand.h>
#include <aws/opsworks/model/DeploymentCommandName.h>
#include <aws/opsworks/model/DeregisterEcsClusterRequest.h>
#include <aws/opsworks/model/DeregisterElasticIpRequest.h>
#include <aws/opsworks/model/DeregisterInstanceRequest.h>
#include <aws/opsworks/model/DeregisterRdsDbInstanceRequest.h>
#include <aws/opsworks/model/DeregisterVolumeRequest.h>
#include <aws/opsworks/model/DescribeAgentVersionsRequest.h>
#include <aws/opsworks/model/DescribeAgentVersionsResult.h>
#include <aws/opsworks/model/DescribeAppsRequest.h>
#include <aws/opsworks/model/DescribeAppsResult.h>
#include <aws/opsworks/model/DescribeCommandsRequest.h>
#include <aws/opsworks/model/DescribeCommandsResult.h>
#include <aws/opsworks/model/DescribeDeploymentsRequest.h>
#include <aws/opsworks/model/DescribeDeploymentsResult.h>
#include <aws/opsworks/model/DescribeEcsClustersRequest.h>
#include <aws/opsworks/model/DescribeEcsClustersResult.h>
#include <aws/opsworks/model/DescribeElasticIpsRequest.h>
#include <aws/opsworks/model/DescribeElasticIpsResult.h>
#include <aws/opsworks/model/DescribeElasticLoadBalancersRequest.h>
#include <aws/opsworks/model/DescribeElasticLoadBalancersResult.h>
#include <aws/opsworks/model/DescribeInstancesRequest.h>
#include <aws/opsworks/model/DescribeInstancesResult.h>
#include <aws/opsworks/model/DescribeLayersRequest.h>
#include <aws/opsworks/model/DescribeLayersResult.h>
#include <aws/opsworks/model/DescribeLoadBasedAutoScalingRequest.h>
#include <aws/opsworks/model/DescribeLoadBasedAutoScalingResult.h>
#include <aws/opsworks/model/DescribeMyUserProfileRequest.h>
#include <aws/opsworks/model/DescribeMyUserProfileResult.h>
#include <aws/opsworks/model/DescribeOperatingSystemsRequest.h>
#include <aws/opsworks/model/DescribeOperatingSystemsResult.h>
#include <aws/opsworks/model/DescribePermissionsRequest.h>
#include <aws/opsworks/model/DescribePermissionsResult.h>
#include <aws/opsworks/model/DescribeRaidArraysRequest.h>
#include <aws/opsworks/model/DescribeRaidArraysResult.h>
#include <aws/opsworks/model/DescribeRdsDbInstancesRequest.h>
#include <aws/opsworks/model/DescribeRdsDbInstancesResult.h>
#include <aws/opsworks/model/DescribeServiceErrorsRequest.h>
#include <aws/opsworks/model/DescribeServiceErrorsResult.h>
#include <aws/opsworks/model/DescribeStackProvisioningParametersRequest.h>
#include <aws/opsworks/model/DescribeStackProvisioningParametersResult.h>
#include <aws/opsworks/model/DescribeStackSummaryRequest.h>
#include <aws/opsworks/model/DescribeStackSummaryResult.h>
#include <aws/opsworks/model/DescribeStacksRequest.h>
#include <aws/opsworks/model/DescribeStacksResult.h>
#include <aws/opsworks/model/DescribeTimeBasedAutoScalingRequest.h>
#include <aws/opsworks/model/DescribeTimeBasedAutoScalingResult.h>
#include <aws/opsworks/model/DescribeUserProfilesRequest.h>
#include <aws/opsworks/model/DescribeUserProfilesResult.h>
#include <aws/opsworks/model/DescribeVolumesRequest.h>
#include <aws/opsworks/model/DescribeVolumesResult.h>
#include <aws/opsworks/model/DetachElasticLoadBalancerRequest.h>
#include <aws/opsworks/model/DisassociateElasticIpRequest.h>
#include <aws/opsworks/model/EbsBlockDevice.h>
#include <aws/opsworks/model/EcsCluster.h>
#include <aws/opsworks/model/ElasticIp.h>
#include <aws/opsworks/model/ElasticLoadBalancer.h>
#include <aws/opsworks/model/EnvironmentVariable.h>
#include <aws/opsworks/model/GetHostnameSuggestionRequest.h>
#include <aws/opsworks/model/GetHostnameSuggestionResult.h>
#include <aws/opsworks/model/GrantAccessRequest.h>
#include <aws/opsworks/model/GrantAccessResult.h>
#include <aws/opsworks/model/Instance.h>
#include <aws/opsworks/model/InstanceIdentity.h>
#include <aws/opsworks/model/InstancesCount.h>
#include <aws/opsworks/model/Layer.h>
#include <aws/opsworks/model/LayerAttributesKeys.h>
#include <aws/opsworks/model/LayerType.h>
#include <aws/opsworks/model/LifecycleEventConfiguration.h>
#include <aws/opsworks/model/ListTagsRequest.h>
#include <aws/opsworks/model/ListTagsResult.h>
#include <aws/opsworks/model/LoadBasedAutoScalingConfiguration.h>
#include <aws/opsworks/model/OperatingSystem.h>
#include <aws/opsworks/model/OperatingSystemConfigurationManager.h>
#include <aws/opsworks/model/Permission.h>
#include <aws/opsworks/model/RaidArray.h>
#include <aws/opsworks/model/RdsDbInstance.h>
#include <aws/opsworks/model/RebootInstanceRequest.h>
#include <aws/opsworks/model/Recipes.h>
#include <aws/opsworks/model/RegisterEcsClusterRequest.h>
#include <aws/opsworks/model/RegisterEcsClusterResult.h>
#include <aws/opsworks/model/RegisterElasticIpRequest.h>
#include <aws/opsworks/model/RegisterElasticIpResult.h>
#include <aws/opsworks/model/RegisterInstanceRequest.h>
#include <aws/opsworks/model/RegisterInstanceResult.h>
#include <aws/opsworks/model/RegisterRdsDbInstanceRequest.h>
#include <aws/opsworks/model/RegisterVolumeRequest.h>
#include <aws/opsworks/model/RegisterVolumeResult.h>
#include <aws/opsworks/model/ReportedOs.h>
#include <aws/opsworks/model/RootDeviceType.h>
#include <aws/opsworks/model/SelfUserProfile.h>
#include <aws/opsworks/model/ServiceError.h>
#include <aws/opsworks/model/SetLoadBasedAutoScalingRequest.h>
#include <aws/opsworks/model/SetPermissionRequest.h>
#include <aws/opsworks/model/SetTimeBasedAutoScalingRequest.h>
#include <aws/opsworks/model/ShutdownEventConfiguration.h>
#include <aws/opsworks/model/Source.h>
#include <aws/opsworks/model/SourceType.h>
#include <aws/opsworks/model/SslConfiguration.h>
#include <aws/opsworks/model/Stack.h>
#include <aws/opsworks/model/StackAttributesKeys.h>
#include <aws/opsworks/model/StackConfigurationManager.h>
#include <aws/opsworks/model/StackSummary.h>
#include <aws/opsworks/model/StartInstanceRequest.h>
#include <aws/opsworks/model/StartStackRequest.h>
#include <aws/opsworks/model/StopInstanceRequest.h>
#include <aws/opsworks/model/StopStackRequest.h>
#include <aws/opsworks/model/TagResourceRequest.h>
#include <aws/opsworks/model/TemporaryCredential.h>
#include <aws/opsworks/model/TimeBasedAutoScalingConfiguration.h>
#include <aws/opsworks/model/UnassignInstanceRequest.h>
#include <aws/opsworks/model/UnassignVolumeRequest.h>
#include <aws/opsworks/model/UntagResourceRequest.h>
#include <aws/opsworks/model/UpdateAppRequest.h>
#include <aws/opsworks/model/UpdateElasticIpRequest.h>
#include <aws/opsworks/model/UpdateInstanceRequest.h>
#include <aws/opsworks/model/UpdateLayerRequest.h>
#include <aws/opsworks/model/UpdateMyUserProfileRequest.h>
#include <aws/opsworks/model/UpdateRdsDbInstanceRequest.h>
#include <aws/opsworks/model/UpdateStackRequest.h>
#include <aws/opsworks/model/UpdateUserProfileRequest.h>
#include <aws/opsworks/model/UpdateVolumeRequest.h>
#include <aws/opsworks/model/UserProfile.h>
#include <aws/opsworks/model/VirtualizationType.h>
#include <aws/opsworks/model/Volume.h>
#include <aws/opsworks/model/VolumeConfiguration.h>
#include <aws/opsworks/model/VolumeType.h>
#include <aws/opsworks/model/WeeklyAutoScalingSchedule.h>

using OpsWorksIncludeTest = ::testing::Test;

TEST_F(OpsWorksIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::OpsWorks::OpsWorksClient>("OpsWorksIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
