/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/organizations/OrganizationsClient.h>
#include <aws/organizations/OrganizationsEndpointProvider.h>
#include <aws/organizations/OrganizationsEndpointRules.h>
#include <aws/organizations/OrganizationsErrorMarshaller.h>
#include <aws/organizations/OrganizationsErrors.h>
#include <aws/organizations/OrganizationsRequest.h>
#include <aws/organizations/OrganizationsServiceClientModel.h>
#include <aws/organizations/Organizations_EXPORTS.h>
#include <aws/organizations/model/AcceptHandshakeRequest.h>
#include <aws/organizations/model/AcceptHandshakeResult.h>
#include <aws/organizations/model/AccessDeniedForDependencyException.h>
#include <aws/organizations/model/AccessDeniedForDependencyExceptionReason.h>
#include <aws/organizations/model/Account.h>
#include <aws/organizations/model/AccountJoinedMethod.h>
#include <aws/organizations/model/AccountStatus.h>
#include <aws/organizations/model/ActionType.h>
#include <aws/organizations/model/AttachPolicyRequest.h>
#include <aws/organizations/model/CancelHandshakeRequest.h>
#include <aws/organizations/model/CancelHandshakeResult.h>
#include <aws/organizations/model/Child.h>
#include <aws/organizations/model/ChildType.h>
#include <aws/organizations/model/CloseAccountRequest.h>
#include <aws/organizations/model/ConstraintViolationException.h>
#include <aws/organizations/model/ConstraintViolationExceptionReason.h>
#include <aws/organizations/model/CreateAccountFailureReason.h>
#include <aws/organizations/model/CreateAccountRequest.h>
#include <aws/organizations/model/CreateAccountResult.h>
#include <aws/organizations/model/CreateAccountState.h>
#include <aws/organizations/model/CreateAccountStatus.h>
#include <aws/organizations/model/CreateGovCloudAccountRequest.h>
#include <aws/organizations/model/CreateGovCloudAccountResult.h>
#include <aws/organizations/model/CreateOrganizationRequest.h>
#include <aws/organizations/model/CreateOrganizationResult.h>
#include <aws/organizations/model/CreateOrganizationalUnitRequest.h>
#include <aws/organizations/model/CreateOrganizationalUnitResult.h>
#include <aws/organizations/model/CreatePolicyRequest.h>
#include <aws/organizations/model/CreatePolicyResult.h>
#include <aws/organizations/model/DeclineHandshakeRequest.h>
#include <aws/organizations/model/DeclineHandshakeResult.h>
#include <aws/organizations/model/DelegatedAdministrator.h>
#include <aws/organizations/model/DelegatedService.h>
#include <aws/organizations/model/DeleteOrganizationRequest.h>
#include <aws/organizations/model/DeleteOrganizationalUnitRequest.h>
#include <aws/organizations/model/DeletePolicyRequest.h>
#include <aws/organizations/model/DeleteResourcePolicyRequest.h>
#include <aws/organizations/model/DeregisterDelegatedAdministratorRequest.h>
#include <aws/organizations/model/DescribeAccountRequest.h>
#include <aws/organizations/model/DescribeAccountResult.h>
#include <aws/organizations/model/DescribeCreateAccountStatusRequest.h>
#include <aws/organizations/model/DescribeCreateAccountStatusResult.h>
#include <aws/organizations/model/DescribeEffectivePolicyRequest.h>
#include <aws/organizations/model/DescribeEffectivePolicyResult.h>
#include <aws/organizations/model/DescribeHandshakeRequest.h>
#include <aws/organizations/model/DescribeHandshakeResult.h>
#include <aws/organizations/model/DescribeOrganizationRequest.h>
#include <aws/organizations/model/DescribeOrganizationResult.h>
#include <aws/organizations/model/DescribeOrganizationalUnitRequest.h>
#include <aws/organizations/model/DescribeOrganizationalUnitResult.h>
#include <aws/organizations/model/DescribePolicyRequest.h>
#include <aws/organizations/model/DescribePolicyResult.h>
#include <aws/organizations/model/DescribeResourcePolicyRequest.h>
#include <aws/organizations/model/DescribeResourcePolicyResult.h>
#include <aws/organizations/model/DetachPolicyRequest.h>
#include <aws/organizations/model/DisableAWSServiceAccessRequest.h>
#include <aws/organizations/model/DisablePolicyTypeRequest.h>
#include <aws/organizations/model/DisablePolicyTypeResult.h>
#include <aws/organizations/model/EffectivePolicy.h>
#include <aws/organizations/model/EffectivePolicyType.h>
#include <aws/organizations/model/EnableAWSServiceAccessRequest.h>
#include <aws/organizations/model/EnableAllFeaturesRequest.h>
#include <aws/organizations/model/EnableAllFeaturesResult.h>
#include <aws/organizations/model/EnablePolicyTypeRequest.h>
#include <aws/organizations/model/EnablePolicyTypeResult.h>
#include <aws/organizations/model/EnabledServicePrincipal.h>
#include <aws/organizations/model/Handshake.h>
#include <aws/organizations/model/HandshakeConstraintViolationException.h>
#include <aws/organizations/model/HandshakeConstraintViolationExceptionReason.h>
#include <aws/organizations/model/HandshakeFilter.h>
#include <aws/organizations/model/HandshakeParty.h>
#include <aws/organizations/model/HandshakePartyType.h>
#include <aws/organizations/model/HandshakeResource.h>
#include <aws/organizations/model/HandshakeResourceType.h>
#include <aws/organizations/model/HandshakeState.h>
#include <aws/organizations/model/IAMUserAccessToBilling.h>
#include <aws/organizations/model/InvalidInputException.h>
#include <aws/organizations/model/InvalidInputExceptionReason.h>
#include <aws/organizations/model/InviteAccountToOrganizationRequest.h>
#include <aws/organizations/model/InviteAccountToOrganizationResult.h>
#include <aws/organizations/model/LeaveOrganizationRequest.h>
#include <aws/organizations/model/ListAWSServiceAccessForOrganizationRequest.h>
#include <aws/organizations/model/ListAWSServiceAccessForOrganizationResult.h>
#include <aws/organizations/model/ListAccountsForParentRequest.h>
#include <aws/organizations/model/ListAccountsForParentResult.h>
#include <aws/organizations/model/ListAccountsRequest.h>
#include <aws/organizations/model/ListAccountsResult.h>
#include <aws/organizations/model/ListChildrenRequest.h>
#include <aws/organizations/model/ListChildrenResult.h>
#include <aws/organizations/model/ListCreateAccountStatusRequest.h>
#include <aws/organizations/model/ListCreateAccountStatusResult.h>
#include <aws/organizations/model/ListDelegatedAdministratorsRequest.h>
#include <aws/organizations/model/ListDelegatedAdministratorsResult.h>
#include <aws/organizations/model/ListDelegatedServicesForAccountRequest.h>
#include <aws/organizations/model/ListDelegatedServicesForAccountResult.h>
#include <aws/organizations/model/ListHandshakesForAccountRequest.h>
#include <aws/organizations/model/ListHandshakesForAccountResult.h>
#include <aws/organizations/model/ListHandshakesForOrganizationRequest.h>
#include <aws/organizations/model/ListHandshakesForOrganizationResult.h>
#include <aws/organizations/model/ListOrganizationalUnitsForParentRequest.h>
#include <aws/organizations/model/ListOrganizationalUnitsForParentResult.h>
#include <aws/organizations/model/ListParentsRequest.h>
#include <aws/organizations/model/ListParentsResult.h>
#include <aws/organizations/model/ListPoliciesForTargetRequest.h>
#include <aws/organizations/model/ListPoliciesForTargetResult.h>
#include <aws/organizations/model/ListPoliciesRequest.h>
#include <aws/organizations/model/ListPoliciesResult.h>
#include <aws/organizations/model/ListRootsRequest.h>
#include <aws/organizations/model/ListRootsResult.h>
#include <aws/organizations/model/ListTagsForResourceRequest.h>
#include <aws/organizations/model/ListTagsForResourceResult.h>
#include <aws/organizations/model/ListTargetsForPolicyRequest.h>
#include <aws/organizations/model/ListTargetsForPolicyResult.h>
#include <aws/organizations/model/MoveAccountRequest.h>
#include <aws/organizations/model/Organization.h>
#include <aws/organizations/model/OrganizationFeatureSet.h>
#include <aws/organizations/model/OrganizationalUnit.h>
#include <aws/organizations/model/Parent.h>
#include <aws/organizations/model/ParentType.h>
#include <aws/organizations/model/Policy.h>
#include <aws/organizations/model/PolicySummary.h>
#include <aws/organizations/model/PolicyTargetSummary.h>
#include <aws/organizations/model/PolicyType.h>
#include <aws/organizations/model/PolicyTypeStatus.h>
#include <aws/organizations/model/PolicyTypeSummary.h>
#include <aws/organizations/model/PutResourcePolicyRequest.h>
#include <aws/organizations/model/PutResourcePolicyResult.h>
#include <aws/organizations/model/RegisterDelegatedAdministratorRequest.h>
#include <aws/organizations/model/RemoveAccountFromOrganizationRequest.h>
#include <aws/organizations/model/ResourcePolicy.h>
#include <aws/organizations/model/ResourcePolicySummary.h>
#include <aws/organizations/model/Root.h>
#include <aws/organizations/model/Tag.h>
#include <aws/organizations/model/TagResourceRequest.h>
#include <aws/organizations/model/TargetType.h>
#include <aws/organizations/model/TooManyRequestsException.h>
#include <aws/organizations/model/UntagResourceRequest.h>
#include <aws/organizations/model/UpdateOrganizationalUnitRequest.h>
#include <aws/organizations/model/UpdateOrganizationalUnitResult.h>
#include <aws/organizations/model/UpdatePolicyRequest.h>
#include <aws/organizations/model/UpdatePolicyResult.h>

using OrganizationsIncludeTest = ::testing::Test;

TEST_F(OrganizationsIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::Organizations::OrganizationsClient>("OrganizationsIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
