/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/panorama/PanoramaClient.h>
#include <aws/panorama/PanoramaEndpointProvider.h>
#include <aws/panorama/PanoramaEndpointRules.h>
#include <aws/panorama/PanoramaErrorMarshaller.h>
#include <aws/panorama/PanoramaErrors.h>
#include <aws/panorama/PanoramaRequest.h>
#include <aws/panorama/PanoramaServiceClientModel.h>
#include <aws/panorama/Panorama_EXPORTS.h>
#include <aws/panorama/model/AlternateSoftwareMetadata.h>
#include <aws/panorama/model/ApplicationInstance.h>
#include <aws/panorama/model/ApplicationInstanceHealthStatus.h>
#include <aws/panorama/model/ApplicationInstanceStatus.h>
#include <aws/panorama/model/ConflictException.h>
#include <aws/panorama/model/ConflictExceptionErrorArgument.h>
#include <aws/panorama/model/ConnectionType.h>
#include <aws/panorama/model/CreateApplicationInstanceRequest.h>
#include <aws/panorama/model/CreateApplicationInstanceResult.h>
#include <aws/panorama/model/CreateJobForDevicesRequest.h>
#include <aws/panorama/model/CreateJobForDevicesResult.h>
#include <aws/panorama/model/CreateNodeFromTemplateJobRequest.h>
#include <aws/panorama/model/CreateNodeFromTemplateJobResult.h>
#include <aws/panorama/model/CreatePackageImportJobRequest.h>
#include <aws/panorama/model/CreatePackageImportJobResult.h>
#include <aws/panorama/model/CreatePackageRequest.h>
#include <aws/panorama/model/CreatePackageResult.h>
#include <aws/panorama/model/DeleteDeviceRequest.h>
#include <aws/panorama/model/DeleteDeviceResult.h>
#include <aws/panorama/model/DeletePackageRequest.h>
#include <aws/panorama/model/DeletePackageResult.h>
#include <aws/panorama/model/DeregisterPackageVersionRequest.h>
#include <aws/panorama/model/DeregisterPackageVersionResult.h>
#include <aws/panorama/model/DescribeApplicationInstanceDetailsRequest.h>
#include <aws/panorama/model/DescribeApplicationInstanceDetailsResult.h>
#include <aws/panorama/model/DescribeApplicationInstanceRequest.h>
#include <aws/panorama/model/DescribeApplicationInstanceResult.h>
#include <aws/panorama/model/DescribeDeviceJobRequest.h>
#include <aws/panorama/model/DescribeDeviceJobResult.h>
#include <aws/panorama/model/DescribeDeviceRequest.h>
#include <aws/panorama/model/DescribeDeviceResult.h>
#include <aws/panorama/model/DescribeNodeFromTemplateJobRequest.h>
#include <aws/panorama/model/DescribeNodeFromTemplateJobResult.h>
#include <aws/panorama/model/DescribeNodeRequest.h>
#include <aws/panorama/model/DescribeNodeResult.h>
#include <aws/panorama/model/DescribePackageImportJobRequest.h>
#include <aws/panorama/model/DescribePackageImportJobResult.h>
#include <aws/panorama/model/DescribePackageRequest.h>
#include <aws/panorama/model/DescribePackageResult.h>
#include <aws/panorama/model/DescribePackageVersionRequest.h>
#include <aws/panorama/model/DescribePackageVersionResult.h>
#include <aws/panorama/model/DesiredState.h>
#include <aws/panorama/model/Device.h>
#include <aws/panorama/model/DeviceAggregatedStatus.h>
#include <aws/panorama/model/DeviceBrand.h>
#include <aws/panorama/model/DeviceConnectionStatus.h>
#include <aws/panorama/model/DeviceJob.h>
#include <aws/panorama/model/DeviceJobConfig.h>
#include <aws/panorama/model/DeviceReportedStatus.h>
#include <aws/panorama/model/DeviceStatus.h>
#include <aws/panorama/model/DeviceType.h>
#include <aws/panorama/model/EthernetPayload.h>
#include <aws/panorama/model/EthernetStatus.h>
#include <aws/panorama/model/InternalServerException.h>
#include <aws/panorama/model/Job.h>
#include <aws/panorama/model/JobResourceTags.h>
#include <aws/panorama/model/JobResourceType.h>
#include <aws/panorama/model/JobType.h>
#include <aws/panorama/model/LatestDeviceJob.h>
#include <aws/panorama/model/ListApplicationInstanceDependenciesRequest.h>
#include <aws/panorama/model/ListApplicationInstanceDependenciesResult.h>
#include <aws/panorama/model/ListApplicationInstanceNodeInstancesRequest.h>
#include <aws/panorama/model/ListApplicationInstanceNodeInstancesResult.h>
#include <aws/panorama/model/ListApplicationInstancesRequest.h>
#include <aws/panorama/model/ListApplicationInstancesResult.h>
#include <aws/panorama/model/ListDevicesJobsRequest.h>
#include <aws/panorama/model/ListDevicesJobsResult.h>
#include <aws/panorama/model/ListDevicesRequest.h>
#include <aws/panorama/model/ListDevicesResult.h>
#include <aws/panorama/model/ListDevicesSortBy.h>
#include <aws/panorama/model/ListNodeFromTemplateJobsRequest.h>
#include <aws/panorama/model/ListNodeFromTemplateJobsResult.h>
#include <aws/panorama/model/ListNodesRequest.h>
#include <aws/panorama/model/ListNodesResult.h>
#include <aws/panorama/model/ListPackageImportJobsRequest.h>
#include <aws/panorama/model/ListPackageImportJobsResult.h>
#include <aws/panorama/model/ListPackagesRequest.h>
#include <aws/panorama/model/ListPackagesResult.h>
#include <aws/panorama/model/ListTagsForResourceRequest.h>
#include <aws/panorama/model/ListTagsForResourceResult.h>
#include <aws/panorama/model/ManifestOverridesPayload.h>
#include <aws/panorama/model/ManifestPayload.h>
#include <aws/panorama/model/NetworkConnectionStatus.h>
#include <aws/panorama/model/NetworkPayload.h>
#include <aws/panorama/model/NetworkStatus.h>
#include <aws/panorama/model/Node.h>
#include <aws/panorama/model/NodeCategory.h>
#include <aws/panorama/model/NodeFromTemplateJob.h>
#include <aws/panorama/model/NodeFromTemplateJobStatus.h>
#include <aws/panorama/model/NodeInputPort.h>
#include <aws/panorama/model/NodeInstance.h>
#include <aws/panorama/model/NodeInstanceStatus.h>
#include <aws/panorama/model/NodeInterface.h>
#include <aws/panorama/model/NodeOutputPort.h>
#include <aws/panorama/model/NodeSignal.h>
#include <aws/panorama/model/NodeSignalValue.h>
#include <aws/panorama/model/NtpPayload.h>
#include <aws/panorama/model/NtpStatus.h>
#include <aws/panorama/model/OTAJobConfig.h>
#include <aws/panorama/model/OutPutS3Location.h>
#include <aws/panorama/model/PackageImportJob.h>
#include <aws/panorama/model/PackageImportJobInputConfig.h>
#include <aws/panorama/model/PackageImportJobOutput.h>
#include <aws/panorama/model/PackageImportJobOutputConfig.h>
#include <aws/panorama/model/PackageImportJobStatus.h>
#include <aws/panorama/model/PackageImportJobType.h>
#include <aws/panorama/model/PackageListItem.h>
#include <aws/panorama/model/PackageObject.h>
#include <aws/panorama/model/PackageVersionInputConfig.h>
#include <aws/panorama/model/PackageVersionOutputConfig.h>
#include <aws/panorama/model/PackageVersionStatus.h>
#include <aws/panorama/model/PortType.h>
#include <aws/panorama/model/ProvisionDeviceRequest.h>
#include <aws/panorama/model/ProvisionDeviceResult.h>
#include <aws/panorama/model/RegisterPackageVersionRequest.h>
#include <aws/panorama/model/RegisterPackageVersionResult.h>
#include <aws/panorama/model/RemoveApplicationInstanceRequest.h>
#include <aws/panorama/model/RemoveApplicationInstanceResult.h>
#include <aws/panorama/model/ReportedRuntimeContextState.h>
#include <aws/panorama/model/ResourceNotFoundException.h>
#include <aws/panorama/model/S3Location.h>
#include <aws/panorama/model/ServiceQuotaExceededException.h>
#include <aws/panorama/model/SignalApplicationInstanceNodeInstancesRequest.h>
#include <aws/panorama/model/SignalApplicationInstanceNodeInstancesResult.h>
#include <aws/panorama/model/SortOrder.h>
#include <aws/panorama/model/StaticIpConnectionInfo.h>
#include <aws/panorama/model/StatusFilter.h>
#include <aws/panorama/model/StorageLocation.h>
#include <aws/panorama/model/TagResourceRequest.h>
#include <aws/panorama/model/TagResourceResult.h>
#include <aws/panorama/model/TemplateType.h>
#include <aws/panorama/model/UntagResourceRequest.h>
#include <aws/panorama/model/UntagResourceResult.h>
#include <aws/panorama/model/UpdateDeviceMetadataRequest.h>
#include <aws/panorama/model/UpdateDeviceMetadataResult.h>
#include <aws/panorama/model/UpdateProgress.h>
#include <aws/panorama/model/ValidationException.h>
#include <aws/panorama/model/ValidationExceptionErrorArgument.h>
#include <aws/panorama/model/ValidationExceptionField.h>
#include <aws/panorama/model/ValidationExceptionReason.h>

using PanoramaIncludeTest = ::testing::Test;

TEST_F(PanoramaIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::Panorama::PanoramaClient>("PanoramaIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
