/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/partnercentral-selling/PartnerCentralSellingClient.h>
#include <aws/partnercentral-selling/PartnerCentralSellingEndpointProvider.h>
#include <aws/partnercentral-selling/PartnerCentralSellingEndpointRules.h>
#include <aws/partnercentral-selling/PartnerCentralSellingErrorMarshaller.h>
#include <aws/partnercentral-selling/PartnerCentralSellingErrors.h>
#include <aws/partnercentral-selling/PartnerCentralSellingRequest.h>
#include <aws/partnercentral-selling/PartnerCentralSellingServiceClientModel.h>
#include <aws/partnercentral-selling/PartnerCentralSelling_EXPORTS.h>
#include <aws/partnercentral-selling/model/AcceptEngagementInvitationRequest.h>
#include <aws/partnercentral-selling/model/Account.h>
#include <aws/partnercentral-selling/model/AccountReceiver.h>
#include <aws/partnercentral-selling/model/AccountSummary.h>
#include <aws/partnercentral-selling/model/Address.h>
#include <aws/partnercentral-selling/model/AddressSummary.h>
#include <aws/partnercentral-selling/model/AssignOpportunityRequest.h>
#include <aws/partnercentral-selling/model/AssigneeContact.h>
#include <aws/partnercentral-selling/model/AssociateOpportunityRequest.h>
#include <aws/partnercentral-selling/model/AwsClosedLostReason.h>
#include <aws/partnercentral-selling/model/AwsFundingUsed.h>
#include <aws/partnercentral-selling/model/AwsMemberBusinessTitle.h>
#include <aws/partnercentral-selling/model/AwsOpportunityCustomer.h>
#include <aws/partnercentral-selling/model/AwsOpportunityInsights.h>
#include <aws/partnercentral-selling/model/AwsOpportunityLifeCycle.h>
#include <aws/partnercentral-selling/model/AwsOpportunityProject.h>
#include <aws/partnercentral-selling/model/AwsOpportunityRelatedEntities.h>
#include <aws/partnercentral-selling/model/AwsOpportunityStage.h>
#include <aws/partnercentral-selling/model/AwsSubmission.h>
#include <aws/partnercentral-selling/model/AwsTeamMember.h>
#include <aws/partnercentral-selling/model/Channel.h>
#include <aws/partnercentral-selling/model/ClosedLostReason.h>
#include <aws/partnercentral-selling/model/CompetitorName.h>
#include <aws/partnercentral-selling/model/Contact.h>
#include <aws/partnercentral-selling/model/CountryCode.h>
#include <aws/partnercentral-selling/model/CreateEngagementInvitationRequest.h>
#include <aws/partnercentral-selling/model/CreateEngagementInvitationResult.h>
#include <aws/partnercentral-selling/model/CreateEngagementRequest.h>
#include <aws/partnercentral-selling/model/CreateEngagementResult.h>
#include <aws/partnercentral-selling/model/CreateOpportunityRequest.h>
#include <aws/partnercentral-selling/model/CreateOpportunityResult.h>
#include <aws/partnercentral-selling/model/CreateResourceSnapshotJobRequest.h>
#include <aws/partnercentral-selling/model/CreateResourceSnapshotJobResult.h>
#include <aws/partnercentral-selling/model/CreateResourceSnapshotRequest.h>
#include <aws/partnercentral-selling/model/CreateResourceSnapshotResult.h>
#include <aws/partnercentral-selling/model/CurrencyCode.h>
#include <aws/partnercentral-selling/model/Customer.h>
#include <aws/partnercentral-selling/model/CustomerProjectsContext.h>
#include <aws/partnercentral-selling/model/CustomerSummary.h>
#include <aws/partnercentral-selling/model/DeleteResourceSnapshotJobRequest.h>
#include <aws/partnercentral-selling/model/DeliveryModel.h>
#include <aws/partnercentral-selling/model/DisassociateOpportunityRequest.h>
#include <aws/partnercentral-selling/model/EngagementContextDetails.h>
#include <aws/partnercentral-selling/model/EngagementContextPayload.h>
#include <aws/partnercentral-selling/model/EngagementContextType.h>
#include <aws/partnercentral-selling/model/EngagementCustomer.h>
#include <aws/partnercentral-selling/model/EngagementCustomerProjectDetails.h>
#include <aws/partnercentral-selling/model/EngagementInvitationPayloadType.h>
#include <aws/partnercentral-selling/model/EngagementInvitationSummary.h>
#include <aws/partnercentral-selling/model/EngagementMember.h>
#include <aws/partnercentral-selling/model/EngagementMemberSummary.h>
#include <aws/partnercentral-selling/model/EngagementResourceAssociationSummary.h>
#include <aws/partnercentral-selling/model/EngagementScore.h>
#include <aws/partnercentral-selling/model/EngagementSort.h>
#include <aws/partnercentral-selling/model/EngagementSortName.h>
#include <aws/partnercentral-selling/model/EngagementSummary.h>
#include <aws/partnercentral-selling/model/ExpectedCustomerSpend.h>
#include <aws/partnercentral-selling/model/ExpectedCustomerSpendCurrencyCodeEnum.h>
#include <aws/partnercentral-selling/model/GetAwsOpportunitySummaryRequest.h>
#include <aws/partnercentral-selling/model/GetAwsOpportunitySummaryResult.h>
#include <aws/partnercentral-selling/model/GetEngagementInvitationRequest.h>
#include <aws/partnercentral-selling/model/GetEngagementInvitationResult.h>
#include <aws/partnercentral-selling/model/GetEngagementRequest.h>
#include <aws/partnercentral-selling/model/GetEngagementResult.h>
#include <aws/partnercentral-selling/model/GetOpportunityRequest.h>
#include <aws/partnercentral-selling/model/GetOpportunityResult.h>
#include <aws/partnercentral-selling/model/GetResourceSnapshotJobRequest.h>
#include <aws/partnercentral-selling/model/GetResourceSnapshotJobResult.h>
#include <aws/partnercentral-selling/model/GetResourceSnapshotRequest.h>
#include <aws/partnercentral-selling/model/GetResourceSnapshotResult.h>
#include <aws/partnercentral-selling/model/GetSellingSystemSettingsRequest.h>
#include <aws/partnercentral-selling/model/GetSellingSystemSettingsResult.h>
#include <aws/partnercentral-selling/model/Industry.h>
#include <aws/partnercentral-selling/model/Invitation.h>
#include <aws/partnercentral-selling/model/InvitationStatus.h>
#include <aws/partnercentral-selling/model/InvolvementTypeChangeReason.h>
#include <aws/partnercentral-selling/model/LastModifiedDate.h>
#include <aws/partnercentral-selling/model/LifeCycle.h>
#include <aws/partnercentral-selling/model/LifeCycleForView.h>
#include <aws/partnercentral-selling/model/LifeCycleSummary.h>
#include <aws/partnercentral-selling/model/ListEngagementByAcceptingInvitationTaskSummary.h>
#include <aws/partnercentral-selling/model/ListEngagementByAcceptingInvitationTasksRequest.h>
#include <aws/partnercentral-selling/model/ListEngagementByAcceptingInvitationTasksResult.h>
#include <aws/partnercentral-selling/model/ListEngagementFromOpportunityTaskSummary.h>
#include <aws/partnercentral-selling/model/ListEngagementFromOpportunityTasksRequest.h>
#include <aws/partnercentral-selling/model/ListEngagementFromOpportunityTasksResult.h>
#include <aws/partnercentral-selling/model/ListEngagementInvitationsRequest.h>
#include <aws/partnercentral-selling/model/ListEngagementInvitationsResult.h>
#include <aws/partnercentral-selling/model/ListEngagementMembersRequest.h>
#include <aws/partnercentral-selling/model/ListEngagementMembersResult.h>
#include <aws/partnercentral-selling/model/ListEngagementResourceAssociationsRequest.h>
#include <aws/partnercentral-selling/model/ListEngagementResourceAssociationsResult.h>
#include <aws/partnercentral-selling/model/ListEngagementsRequest.h>
#include <aws/partnercentral-selling/model/ListEngagementsResult.h>
#include <aws/partnercentral-selling/model/ListOpportunitiesRequest.h>
#include <aws/partnercentral-selling/model/ListOpportunitiesResult.h>
#include <aws/partnercentral-selling/model/ListResourceSnapshotJobsRequest.h>
#include <aws/partnercentral-selling/model/ListResourceSnapshotJobsResult.h>
#include <aws/partnercentral-selling/model/ListResourceSnapshotsRequest.h>
#include <aws/partnercentral-selling/model/ListResourceSnapshotsResult.h>
#include <aws/partnercentral-selling/model/ListSolutionsRequest.h>
#include <aws/partnercentral-selling/model/ListSolutionsResult.h>
#include <aws/partnercentral-selling/model/ListTagsForResourceRequest.h>
#include <aws/partnercentral-selling/model/ListTagsForResourceResult.h>
#include <aws/partnercentral-selling/model/ListTasksSortBase.h>
#include <aws/partnercentral-selling/model/ListTasksSortName.h>
#include <aws/partnercentral-selling/model/Marketing.h>
#include <aws/partnercentral-selling/model/MarketingSource.h>
#include <aws/partnercentral-selling/model/MonetaryValue.h>
#include <aws/partnercentral-selling/model/NationalSecurity.h>
#include <aws/partnercentral-selling/model/NextStepsHistory.h>
#include <aws/partnercentral-selling/model/OpportunityEngagementInvitationSort.h>
#include <aws/partnercentral-selling/model/OpportunityEngagementInvitationSortName.h>
#include <aws/partnercentral-selling/model/OpportunityInvitationPayload.h>
#include <aws/partnercentral-selling/model/OpportunityOrigin.h>
#include <aws/partnercentral-selling/model/OpportunitySort.h>
#include <aws/partnercentral-selling/model/OpportunitySortName.h>
#include <aws/partnercentral-selling/model/OpportunitySummary.h>
#include <aws/partnercentral-selling/model/OpportunitySummaryView.h>
#include <aws/partnercentral-selling/model/OpportunityType.h>
#include <aws/partnercentral-selling/model/ParticipantType.h>
#include <aws/partnercentral-selling/model/Payload.h>
#include <aws/partnercentral-selling/model/PaymentFrequency.h>
#include <aws/partnercentral-selling/model/PrimaryNeedFromAws.h>
#include <aws/partnercentral-selling/model/ProfileNextStepsHistory.h>
#include <aws/partnercentral-selling/model/Project.h>
#include <aws/partnercentral-selling/model/ProjectDetails.h>
#include <aws/partnercentral-selling/model/ProjectSummary.h>
#include <aws/partnercentral-selling/model/ProjectView.h>
#include <aws/partnercentral-selling/model/PutSellingSystemSettingsRequest.h>
#include <aws/partnercentral-selling/model/PutSellingSystemSettingsResult.h>
#include <aws/partnercentral-selling/model/ReasonCode.h>
#include <aws/partnercentral-selling/model/Receiver.h>
#include <aws/partnercentral-selling/model/ReceiverResponsibility.h>
#include <aws/partnercentral-selling/model/RejectEngagementInvitationRequest.h>
#include <aws/partnercentral-selling/model/RelatedEntityIdentifiers.h>
#include <aws/partnercentral-selling/model/RelatedEntityType.h>
#include <aws/partnercentral-selling/model/ResourceSnapshotJobStatus.h>
#include <aws/partnercentral-selling/model/ResourceSnapshotJobSummary.h>
#include <aws/partnercentral-selling/model/ResourceSnapshotPayload.h>
#include <aws/partnercentral-selling/model/ResourceSnapshotSummary.h>
#include <aws/partnercentral-selling/model/ResourceType.h>
#include <aws/partnercentral-selling/model/RevenueModel.h>
#include <aws/partnercentral-selling/model/ReviewStatus.h>
#include <aws/partnercentral-selling/model/SalesActivity.h>
#include <aws/partnercentral-selling/model/SalesInvolvementType.h>
#include <aws/partnercentral-selling/model/SenderContact.h>
#include <aws/partnercentral-selling/model/SoftwareRevenue.h>
#include <aws/partnercentral-selling/model/SolutionBase.h>
#include <aws/partnercentral-selling/model/SolutionSort.h>
#include <aws/partnercentral-selling/model/SolutionSortName.h>
#include <aws/partnercentral-selling/model/SolutionStatus.h>
#include <aws/partnercentral-selling/model/SortBy.h>
#include <aws/partnercentral-selling/model/SortObject.h>
#include <aws/partnercentral-selling/model/SortOrder.h>
#include <aws/partnercentral-selling/model/Stage.h>
#include <aws/partnercentral-selling/model/StartEngagementByAcceptingInvitationTaskRequest.h>
#include <aws/partnercentral-selling/model/StartEngagementByAcceptingInvitationTaskResult.h>
#include <aws/partnercentral-selling/model/StartEngagementFromOpportunityTaskRequest.h>
#include <aws/partnercentral-selling/model/StartEngagementFromOpportunityTaskResult.h>
#include <aws/partnercentral-selling/model/StartResourceSnapshotJobRequest.h>
#include <aws/partnercentral-selling/model/StopResourceSnapshotJobRequest.h>
#include <aws/partnercentral-selling/model/SubmitOpportunityRequest.h>
#include <aws/partnercentral-selling/model/Tag.h>
#include <aws/partnercentral-selling/model/TagResourceRequest.h>
#include <aws/partnercentral-selling/model/TagResourceResult.h>
#include <aws/partnercentral-selling/model/TaskStatus.h>
#include <aws/partnercentral-selling/model/UntagResourceRequest.h>
#include <aws/partnercentral-selling/model/UntagResourceResult.h>
#include <aws/partnercentral-selling/model/UpdateOpportunityRequest.h>
#include <aws/partnercentral-selling/model/UpdateOpportunityResult.h>
#include <aws/partnercentral-selling/model/ValidationException.h>
#include <aws/partnercentral-selling/model/ValidationExceptionError.h>
#include <aws/partnercentral-selling/model/ValidationExceptionErrorCode.h>
#include <aws/partnercentral-selling/model/ValidationExceptionReason.h>
#include <aws/partnercentral-selling/model/Visibility.h>

using PartnerCentralSellingIncludeTest = ::testing::Test;

TEST_F(PartnerCentralSellingIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::PartnerCentralSelling::PartnerCentralSellingClient>("PartnerCentralSellingIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
