/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/personalize/PersonalizeClient.h>
#include <aws/personalize/PersonalizeEndpointProvider.h>
#include <aws/personalize/PersonalizeEndpointRules.h>
#include <aws/personalize/PersonalizeErrorMarshaller.h>
#include <aws/personalize/PersonalizeErrors.h>
#include <aws/personalize/PersonalizeRequest.h>
#include <aws/personalize/PersonalizeServiceClientModel.h>
#include <aws/personalize/Personalize_EXPORTS.h>
#include <aws/personalize/model/Algorithm.h>
#include <aws/personalize/model/AlgorithmImage.h>
#include <aws/personalize/model/AutoMLConfig.h>
#include <aws/personalize/model/AutoMLResult.h>
#include <aws/personalize/model/AutoTrainingConfig.h>
#include <aws/personalize/model/BatchInferenceJob.h>
#include <aws/personalize/model/BatchInferenceJobConfig.h>
#include <aws/personalize/model/BatchInferenceJobInput.h>
#include <aws/personalize/model/BatchInferenceJobMode.h>
#include <aws/personalize/model/BatchInferenceJobOutput.h>
#include <aws/personalize/model/BatchInferenceJobSummary.h>
#include <aws/personalize/model/BatchSegmentJob.h>
#include <aws/personalize/model/BatchSegmentJobInput.h>
#include <aws/personalize/model/BatchSegmentJobOutput.h>
#include <aws/personalize/model/BatchSegmentJobSummary.h>
#include <aws/personalize/model/Campaign.h>
#include <aws/personalize/model/CampaignConfig.h>
#include <aws/personalize/model/CampaignSummary.h>
#include <aws/personalize/model/CampaignUpdateSummary.h>
#include <aws/personalize/model/CategoricalHyperParameterRange.h>
#include <aws/personalize/model/ContinuousHyperParameterRange.h>
#include <aws/personalize/model/CreateBatchInferenceJobRequest.h>
#include <aws/personalize/model/CreateBatchInferenceJobResult.h>
#include <aws/personalize/model/CreateBatchSegmentJobRequest.h>
#include <aws/personalize/model/CreateBatchSegmentJobResult.h>
#include <aws/personalize/model/CreateCampaignRequest.h>
#include <aws/personalize/model/CreateCampaignResult.h>
#include <aws/personalize/model/CreateDataDeletionJobRequest.h>
#include <aws/personalize/model/CreateDataDeletionJobResult.h>
#include <aws/personalize/model/CreateDatasetExportJobRequest.h>
#include <aws/personalize/model/CreateDatasetExportJobResult.h>
#include <aws/personalize/model/CreateDatasetGroupRequest.h>
#include <aws/personalize/model/CreateDatasetGroupResult.h>
#include <aws/personalize/model/CreateDatasetImportJobRequest.h>
#include <aws/personalize/model/CreateDatasetImportJobResult.h>
#include <aws/personalize/model/CreateDatasetRequest.h>
#include <aws/personalize/model/CreateDatasetResult.h>
#include <aws/personalize/model/CreateEventTrackerRequest.h>
#include <aws/personalize/model/CreateEventTrackerResult.h>
#include <aws/personalize/model/CreateFilterRequest.h>
#include <aws/personalize/model/CreateFilterResult.h>
#include <aws/personalize/model/CreateMetricAttributionRequest.h>
#include <aws/personalize/model/CreateMetricAttributionResult.h>
#include <aws/personalize/model/CreateRecommenderRequest.h>
#include <aws/personalize/model/CreateRecommenderResult.h>
#include <aws/personalize/model/CreateSchemaRequest.h>
#include <aws/personalize/model/CreateSchemaResult.h>
#include <aws/personalize/model/CreateSolutionRequest.h>
#include <aws/personalize/model/CreateSolutionResult.h>
#include <aws/personalize/model/CreateSolutionVersionRequest.h>
#include <aws/personalize/model/CreateSolutionVersionResult.h>
#include <aws/personalize/model/DataDeletionJob.h>
#include <aws/personalize/model/DataDeletionJobSummary.h>
#include <aws/personalize/model/DataSource.h>
#include <aws/personalize/model/Dataset.h>
#include <aws/personalize/model/DatasetExportJob.h>
#include <aws/personalize/model/DatasetExportJobOutput.h>
#include <aws/personalize/model/DatasetExportJobSummary.h>
#include <aws/personalize/model/DatasetGroup.h>
#include <aws/personalize/model/DatasetGroupSummary.h>
#include <aws/personalize/model/DatasetImportJob.h>
#include <aws/personalize/model/DatasetImportJobSummary.h>
#include <aws/personalize/model/DatasetSchema.h>
#include <aws/personalize/model/DatasetSchemaSummary.h>
#include <aws/personalize/model/DatasetSummary.h>
#include <aws/personalize/model/DatasetUpdateSummary.h>
#include <aws/personalize/model/DefaultCategoricalHyperParameterRange.h>
#include <aws/personalize/model/DefaultContinuousHyperParameterRange.h>
#include <aws/personalize/model/DefaultHyperParameterRanges.h>
#include <aws/personalize/model/DefaultIntegerHyperParameterRange.h>
#include <aws/personalize/model/DeleteCampaignRequest.h>
#include <aws/personalize/model/DeleteDatasetGroupRequest.h>
#include <aws/personalize/model/DeleteDatasetRequest.h>
#include <aws/personalize/model/DeleteEventTrackerRequest.h>
#include <aws/personalize/model/DeleteFilterRequest.h>
#include <aws/personalize/model/DeleteMetricAttributionRequest.h>
#include <aws/personalize/model/DeleteRecommenderRequest.h>
#include <aws/personalize/model/DeleteSchemaRequest.h>
#include <aws/personalize/model/DeleteSolutionRequest.h>
#include <aws/personalize/model/DescribeAlgorithmRequest.h>
#include <aws/personalize/model/DescribeAlgorithmResult.h>
#include <aws/personalize/model/DescribeBatchInferenceJobRequest.h>
#include <aws/personalize/model/DescribeBatchInferenceJobResult.h>
#include <aws/personalize/model/DescribeBatchSegmentJobRequest.h>
#include <aws/personalize/model/DescribeBatchSegmentJobResult.h>
#include <aws/personalize/model/DescribeCampaignRequest.h>
#include <aws/personalize/model/DescribeCampaignResult.h>
#include <aws/personalize/model/DescribeDataDeletionJobRequest.h>
#include <aws/personalize/model/DescribeDataDeletionJobResult.h>
#include <aws/personalize/model/DescribeDatasetExportJobRequest.h>
#include <aws/personalize/model/DescribeDatasetExportJobResult.h>
#include <aws/personalize/model/DescribeDatasetGroupRequest.h>
#include <aws/personalize/model/DescribeDatasetGroupResult.h>
#include <aws/personalize/model/DescribeDatasetImportJobRequest.h>
#include <aws/personalize/model/DescribeDatasetImportJobResult.h>
#include <aws/personalize/model/DescribeDatasetRequest.h>
#include <aws/personalize/model/DescribeDatasetResult.h>
#include <aws/personalize/model/DescribeEventTrackerRequest.h>
#include <aws/personalize/model/DescribeEventTrackerResult.h>
#include <aws/personalize/model/DescribeFeatureTransformationRequest.h>
#include <aws/personalize/model/DescribeFeatureTransformationResult.h>
#include <aws/personalize/model/DescribeFilterRequest.h>
#include <aws/personalize/model/DescribeFilterResult.h>
#include <aws/personalize/model/DescribeMetricAttributionRequest.h>
#include <aws/personalize/model/DescribeMetricAttributionResult.h>
#include <aws/personalize/model/DescribeRecipeRequest.h>
#include <aws/personalize/model/DescribeRecipeResult.h>
#include <aws/personalize/model/DescribeRecommenderRequest.h>
#include <aws/personalize/model/DescribeRecommenderResult.h>
#include <aws/personalize/model/DescribeSchemaRequest.h>
#include <aws/personalize/model/DescribeSchemaResult.h>
#include <aws/personalize/model/DescribeSolutionRequest.h>
#include <aws/personalize/model/DescribeSolutionResult.h>
#include <aws/personalize/model/DescribeSolutionVersionRequest.h>
#include <aws/personalize/model/DescribeSolutionVersionResult.h>
#include <aws/personalize/model/Domain.h>
#include <aws/personalize/model/EventParameters.h>
#include <aws/personalize/model/EventTracker.h>
#include <aws/personalize/model/EventTrackerSummary.h>
#include <aws/personalize/model/EventsConfig.h>
#include <aws/personalize/model/FeatureTransformation.h>
#include <aws/personalize/model/FieldsForThemeGeneration.h>
#include <aws/personalize/model/Filter.h>
#include <aws/personalize/model/FilterSummary.h>
#include <aws/personalize/model/GetSolutionMetricsRequest.h>
#include <aws/personalize/model/GetSolutionMetricsResult.h>
#include <aws/personalize/model/HPOConfig.h>
#include <aws/personalize/model/HPOObjective.h>
#include <aws/personalize/model/HPOResourceConfig.h>
#include <aws/personalize/model/HyperParameterRanges.h>
#include <aws/personalize/model/ImportMode.h>
#include <aws/personalize/model/IngestionMode.h>
#include <aws/personalize/model/IntegerHyperParameterRange.h>
#include <aws/personalize/model/ListBatchInferenceJobsRequest.h>
#include <aws/personalize/model/ListBatchInferenceJobsResult.h>
#include <aws/personalize/model/ListBatchSegmentJobsRequest.h>
#include <aws/personalize/model/ListBatchSegmentJobsResult.h>
#include <aws/personalize/model/ListCampaignsRequest.h>
#include <aws/personalize/model/ListCampaignsResult.h>
#include <aws/personalize/model/ListDataDeletionJobsRequest.h>
#include <aws/personalize/model/ListDataDeletionJobsResult.h>
#include <aws/personalize/model/ListDatasetExportJobsRequest.h>
#include <aws/personalize/model/ListDatasetExportJobsResult.h>
#include <aws/personalize/model/ListDatasetGroupsRequest.h>
#include <aws/personalize/model/ListDatasetGroupsResult.h>
#include <aws/personalize/model/ListDatasetImportJobsRequest.h>
#include <aws/personalize/model/ListDatasetImportJobsResult.h>
#include <aws/personalize/model/ListDatasetsRequest.h>
#include <aws/personalize/model/ListDatasetsResult.h>
#include <aws/personalize/model/ListEventTrackersRequest.h>
#include <aws/personalize/model/ListEventTrackersResult.h>
#include <aws/personalize/model/ListFiltersRequest.h>
#include <aws/personalize/model/ListFiltersResult.h>
#include <aws/personalize/model/ListMetricAttributionMetricsRequest.h>
#include <aws/personalize/model/ListMetricAttributionMetricsResult.h>
#include <aws/personalize/model/ListMetricAttributionsRequest.h>
#include <aws/personalize/model/ListMetricAttributionsResult.h>
#include <aws/personalize/model/ListRecipesRequest.h>
#include <aws/personalize/model/ListRecipesResult.h>
#include <aws/personalize/model/ListRecommendersRequest.h>
#include <aws/personalize/model/ListRecommendersResult.h>
#include <aws/personalize/model/ListSchemasRequest.h>
#include <aws/personalize/model/ListSchemasResult.h>
#include <aws/personalize/model/ListSolutionVersionsRequest.h>
#include <aws/personalize/model/ListSolutionVersionsResult.h>
#include <aws/personalize/model/ListSolutionsRequest.h>
#include <aws/personalize/model/ListSolutionsResult.h>
#include <aws/personalize/model/ListTagsForResourceRequest.h>
#include <aws/personalize/model/ListTagsForResourceResult.h>
#include <aws/personalize/model/MetricAttribute.h>
#include <aws/personalize/model/MetricAttribution.h>
#include <aws/personalize/model/MetricAttributionOutput.h>
#include <aws/personalize/model/MetricAttributionSummary.h>
#include <aws/personalize/model/ObjectiveSensitivity.h>
#include <aws/personalize/model/OptimizationObjective.h>
#include <aws/personalize/model/Recipe.h>
#include <aws/personalize/model/RecipeProvider.h>
#include <aws/personalize/model/RecipeSummary.h>
#include <aws/personalize/model/Recommender.h>
#include <aws/personalize/model/RecommenderConfig.h>
#include <aws/personalize/model/RecommenderSummary.h>
#include <aws/personalize/model/RecommenderUpdateSummary.h>
#include <aws/personalize/model/S3DataConfig.h>
#include <aws/personalize/model/Solution.h>
#include <aws/personalize/model/SolutionConfig.h>
#include <aws/personalize/model/SolutionSummary.h>
#include <aws/personalize/model/SolutionUpdateConfig.h>
#include <aws/personalize/model/SolutionUpdateSummary.h>
#include <aws/personalize/model/SolutionVersion.h>
#include <aws/personalize/model/SolutionVersionSummary.h>
#include <aws/personalize/model/StartRecommenderRequest.h>
#include <aws/personalize/model/StartRecommenderResult.h>
#include <aws/personalize/model/StopRecommenderRequest.h>
#include <aws/personalize/model/StopRecommenderResult.h>
#include <aws/personalize/model/StopSolutionVersionCreationRequest.h>
#include <aws/personalize/model/Tag.h>
#include <aws/personalize/model/TagResourceRequest.h>
#include <aws/personalize/model/TagResourceResult.h>
#include <aws/personalize/model/ThemeGenerationConfig.h>
#include <aws/personalize/model/TrainingDataConfig.h>
#include <aws/personalize/model/TrainingMode.h>
#include <aws/personalize/model/TrainingType.h>
#include <aws/personalize/model/TunedHPOParams.h>
#include <aws/personalize/model/UntagResourceRequest.h>
#include <aws/personalize/model/UntagResourceResult.h>
#include <aws/personalize/model/UpdateCampaignRequest.h>
#include <aws/personalize/model/UpdateCampaignResult.h>
#include <aws/personalize/model/UpdateDatasetRequest.h>
#include <aws/personalize/model/UpdateDatasetResult.h>
#include <aws/personalize/model/UpdateMetricAttributionRequest.h>
#include <aws/personalize/model/UpdateMetricAttributionResult.h>
#include <aws/personalize/model/UpdateRecommenderRequest.h>
#include <aws/personalize/model/UpdateRecommenderResult.h>
#include <aws/personalize/model/UpdateSolutionRequest.h>
#include <aws/personalize/model/UpdateSolutionResult.h>

using PersonalizeIncludeTest = ::testing::Test;

TEST_F(PersonalizeIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::Personalize::PersonalizeClient>("PersonalizeIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
