/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/pinpoint/PinpointClient.h>
#include <aws/pinpoint/PinpointEndpointProvider.h>
#include <aws/pinpoint/PinpointEndpointRules.h>
#include <aws/pinpoint/PinpointErrorMarshaller.h>
#include <aws/pinpoint/PinpointErrors.h>
#include <aws/pinpoint/PinpointRequest.h>
#include <aws/pinpoint/PinpointServiceClientModel.h>
#include <aws/pinpoint/Pinpoint_EXPORTS.h>
#include <aws/pinpoint/model/ADMChannelRequest.h>
#include <aws/pinpoint/model/ADMChannelResponse.h>
#include <aws/pinpoint/model/ADMMessage.h>
#include <aws/pinpoint/model/APNSChannelRequest.h>
#include <aws/pinpoint/model/APNSChannelResponse.h>
#include <aws/pinpoint/model/APNSMessage.h>
#include <aws/pinpoint/model/APNSPushNotificationTemplate.h>
#include <aws/pinpoint/model/APNSSandboxChannelRequest.h>
#include <aws/pinpoint/model/APNSSandboxChannelResponse.h>
#include <aws/pinpoint/model/APNSVoipChannelRequest.h>
#include <aws/pinpoint/model/APNSVoipChannelResponse.h>
#include <aws/pinpoint/model/APNSVoipSandboxChannelRequest.h>
#include <aws/pinpoint/model/APNSVoipSandboxChannelResponse.h>
#include <aws/pinpoint/model/Action.h>
#include <aws/pinpoint/model/ActivitiesResponse.h>
#include <aws/pinpoint/model/Activity.h>
#include <aws/pinpoint/model/ActivityResponse.h>
#include <aws/pinpoint/model/AddressConfiguration.h>
#include <aws/pinpoint/model/Alignment.h>
#include <aws/pinpoint/model/AndroidPushNotificationTemplate.h>
#include <aws/pinpoint/model/ApplicationDateRangeKpiResponse.h>
#include <aws/pinpoint/model/ApplicationResponse.h>
#include <aws/pinpoint/model/ApplicationSettingsJourneyLimits.h>
#include <aws/pinpoint/model/ApplicationSettingsResource.h>
#include <aws/pinpoint/model/ApplicationsResponse.h>
#include <aws/pinpoint/model/AttributeDimension.h>
#include <aws/pinpoint/model/AttributeType.h>
#include <aws/pinpoint/model/AttributesResource.h>
#include <aws/pinpoint/model/BadRequestException.h>
#include <aws/pinpoint/model/BaiduChannelRequest.h>
#include <aws/pinpoint/model/BaiduChannelResponse.h>
#include <aws/pinpoint/model/BaiduMessage.h>
#include <aws/pinpoint/model/BaseKpiResult.h>
#include <aws/pinpoint/model/ButtonAction.h>
#include <aws/pinpoint/model/CampaignCustomMessage.h>
#include <aws/pinpoint/model/CampaignDateRangeKpiResponse.h>
#include <aws/pinpoint/model/CampaignEmailMessage.h>
#include <aws/pinpoint/model/CampaignEventFilter.h>
#include <aws/pinpoint/model/CampaignHook.h>
#include <aws/pinpoint/model/CampaignInAppMessage.h>
#include <aws/pinpoint/model/CampaignLimits.h>
#include <aws/pinpoint/model/CampaignResponse.h>
#include <aws/pinpoint/model/CampaignSmsMessage.h>
#include <aws/pinpoint/model/CampaignState.h>
#include <aws/pinpoint/model/CampaignStatus.h>
#include <aws/pinpoint/model/CampaignsResponse.h>
#include <aws/pinpoint/model/ChannelResponse.h>
#include <aws/pinpoint/model/ChannelType.h>
#include <aws/pinpoint/model/ChannelsResponse.h>
#include <aws/pinpoint/model/ClosedDays.h>
#include <aws/pinpoint/model/ClosedDaysRule.h>
#include <aws/pinpoint/model/Condition.h>
#include <aws/pinpoint/model/ConditionalSplitActivity.h>
#include <aws/pinpoint/model/ConflictException.h>
#include <aws/pinpoint/model/ContactCenterActivity.h>
#include <aws/pinpoint/model/CreateAppRequest.h>
#include <aws/pinpoint/model/CreateAppResult.h>
#include <aws/pinpoint/model/CreateApplicationRequest.h>
#include <aws/pinpoint/model/CreateCampaignRequest.h>
#include <aws/pinpoint/model/CreateCampaignResult.h>
#include <aws/pinpoint/model/CreateEmailTemplateRequest.h>
#include <aws/pinpoint/model/CreateEmailTemplateResult.h>
#include <aws/pinpoint/model/CreateExportJobRequest.h>
#include <aws/pinpoint/model/CreateExportJobResult.h>
#include <aws/pinpoint/model/CreateImportJobRequest.h>
#include <aws/pinpoint/model/CreateImportJobResult.h>
#include <aws/pinpoint/model/CreateInAppTemplateRequest.h>
#include <aws/pinpoint/model/CreateInAppTemplateResult.h>
#include <aws/pinpoint/model/CreateJourneyRequest.h>
#include <aws/pinpoint/model/CreateJourneyResult.h>
#include <aws/pinpoint/model/CreatePushTemplateRequest.h>
#include <aws/pinpoint/model/CreatePushTemplateResult.h>
#include <aws/pinpoint/model/CreateRecommenderConfiguration.h>
#include <aws/pinpoint/model/CreateRecommenderConfigurationRequest.h>
#include <aws/pinpoint/model/CreateRecommenderConfigurationResult.h>
#include <aws/pinpoint/model/CreateSegmentRequest.h>
#include <aws/pinpoint/model/CreateSegmentResult.h>
#include <aws/pinpoint/model/CreateSmsTemplateRequest.h>
#include <aws/pinpoint/model/CreateSmsTemplateResult.h>
#include <aws/pinpoint/model/CreateTemplateMessageBody.h>
#include <aws/pinpoint/model/CreateVoiceTemplateRequest.h>
#include <aws/pinpoint/model/CreateVoiceTemplateResult.h>
#include <aws/pinpoint/model/CustomDeliveryConfiguration.h>
#include <aws/pinpoint/model/CustomMessageActivity.h>
#include <aws/pinpoint/model/DayOfWeek.h>
#include <aws/pinpoint/model/DefaultButtonConfiguration.h>
#include <aws/pinpoint/model/DefaultMessage.h>
#include <aws/pinpoint/model/DefaultPushNotificationMessage.h>
#include <aws/pinpoint/model/DefaultPushNotificationTemplate.h>
#include <aws/pinpoint/model/DeleteAdmChannelRequest.h>
#include <aws/pinpoint/model/DeleteAdmChannelResult.h>
#include <aws/pinpoint/model/DeleteApnsChannelRequest.h>
#include <aws/pinpoint/model/DeleteApnsChannelResult.h>
#include <aws/pinpoint/model/DeleteApnsSandboxChannelRequest.h>
#include <aws/pinpoint/model/DeleteApnsSandboxChannelResult.h>
#include <aws/pinpoint/model/DeleteApnsVoipChannelRequest.h>
#include <aws/pinpoint/model/DeleteApnsVoipChannelResult.h>
#include <aws/pinpoint/model/DeleteApnsVoipSandboxChannelRequest.h>
#include <aws/pinpoint/model/DeleteApnsVoipSandboxChannelResult.h>
#include <aws/pinpoint/model/DeleteAppRequest.h>
#include <aws/pinpoint/model/DeleteAppResult.h>
#include <aws/pinpoint/model/DeleteBaiduChannelRequest.h>
#include <aws/pinpoint/model/DeleteBaiduChannelResult.h>
#include <aws/pinpoint/model/DeleteCampaignRequest.h>
#include <aws/pinpoint/model/DeleteCampaignResult.h>
#include <aws/pinpoint/model/DeleteEmailChannelRequest.h>
#include <aws/pinpoint/model/DeleteEmailChannelResult.h>
#include <aws/pinpoint/model/DeleteEmailTemplateRequest.h>
#include <aws/pinpoint/model/DeleteEmailTemplateResult.h>
#include <aws/pinpoint/model/DeleteEndpointRequest.h>
#include <aws/pinpoint/model/DeleteEndpointResult.h>
#include <aws/pinpoint/model/DeleteEventStreamRequest.h>
#include <aws/pinpoint/model/DeleteEventStreamResult.h>
#include <aws/pinpoint/model/DeleteGcmChannelRequest.h>
#include <aws/pinpoint/model/DeleteGcmChannelResult.h>
#include <aws/pinpoint/model/DeleteInAppTemplateRequest.h>
#include <aws/pinpoint/model/DeleteInAppTemplateResult.h>
#include <aws/pinpoint/model/DeleteJourneyRequest.h>
#include <aws/pinpoint/model/DeleteJourneyResult.h>
#include <aws/pinpoint/model/DeletePushTemplateRequest.h>
#include <aws/pinpoint/model/DeletePushTemplateResult.h>
#include <aws/pinpoint/model/DeleteRecommenderConfigurationRequest.h>
#include <aws/pinpoint/model/DeleteRecommenderConfigurationResult.h>
#include <aws/pinpoint/model/DeleteSegmentRequest.h>
#include <aws/pinpoint/model/DeleteSegmentResult.h>
#include <aws/pinpoint/model/DeleteSmsChannelRequest.h>
#include <aws/pinpoint/model/DeleteSmsChannelResult.h>
#include <aws/pinpoint/model/DeleteSmsTemplateRequest.h>
#include <aws/pinpoint/model/DeleteSmsTemplateResult.h>
#include <aws/pinpoint/model/DeleteUserEndpointsRequest.h>
#include <aws/pinpoint/model/DeleteUserEndpointsResult.h>
#include <aws/pinpoint/model/DeleteVoiceChannelRequest.h>
#include <aws/pinpoint/model/DeleteVoiceChannelResult.h>
#include <aws/pinpoint/model/DeleteVoiceTemplateRequest.h>
#include <aws/pinpoint/model/DeleteVoiceTemplateResult.h>
#include <aws/pinpoint/model/DeliveryStatus.h>
#include <aws/pinpoint/model/DimensionType.h>
#include <aws/pinpoint/model/DirectMessageConfiguration.h>
#include <aws/pinpoint/model/Duration.h>
#include <aws/pinpoint/model/EmailChannelRequest.h>
#include <aws/pinpoint/model/EmailChannelResponse.h>
#include <aws/pinpoint/model/EmailMessage.h>
#include <aws/pinpoint/model/EmailMessageActivity.h>
#include <aws/pinpoint/model/EmailTemplateRequest.h>
#include <aws/pinpoint/model/EmailTemplateResponse.h>
#include <aws/pinpoint/model/EndpointBatchItem.h>
#include <aws/pinpoint/model/EndpointBatchRequest.h>
#include <aws/pinpoint/model/EndpointDemographic.h>
#include <aws/pinpoint/model/EndpointItemResponse.h>
#include <aws/pinpoint/model/EndpointLocation.h>
#include <aws/pinpoint/model/EndpointMessageResult.h>
#include <aws/pinpoint/model/EndpointRequest.h>
#include <aws/pinpoint/model/EndpointResponse.h>
#include <aws/pinpoint/model/EndpointSendConfiguration.h>
#include <aws/pinpoint/model/EndpointUser.h>
#include <aws/pinpoint/model/EndpointsResponse.h>
#include <aws/pinpoint/model/Event.h>
#include <aws/pinpoint/model/EventCondition.h>
#include <aws/pinpoint/model/EventDimensions.h>
#include <aws/pinpoint/model/EventFilter.h>
#include <aws/pinpoint/model/EventItemResponse.h>
#include <aws/pinpoint/model/EventStartCondition.h>
#include <aws/pinpoint/model/EventStream.h>
#include <aws/pinpoint/model/EventsBatch.h>
#include <aws/pinpoint/model/EventsRequest.h>
#include <aws/pinpoint/model/EventsResponse.h>
#include <aws/pinpoint/model/ExportJobRequest.h>
#include <aws/pinpoint/model/ExportJobResource.h>
#include <aws/pinpoint/model/ExportJobResponse.h>
#include <aws/pinpoint/model/ExportJobsResponse.h>
#include <aws/pinpoint/model/FilterType.h>
#include <aws/pinpoint/model/ForbiddenException.h>
#include <aws/pinpoint/model/Format.h>
#include <aws/pinpoint/model/Frequency.h>
#include <aws/pinpoint/model/GCMChannelRequest.h>
#include <aws/pinpoint/model/GCMChannelResponse.h>
#include <aws/pinpoint/model/GCMMessage.h>
#include <aws/pinpoint/model/GPSCoordinates.h>
#include <aws/pinpoint/model/GPSPointDimension.h>
#include <aws/pinpoint/model/GetAdmChannelRequest.h>
#include <aws/pinpoint/model/GetAdmChannelResult.h>
#include <aws/pinpoint/model/GetApnsChannelRequest.h>
#include <aws/pinpoint/model/GetApnsChannelResult.h>
#include <aws/pinpoint/model/GetApnsSandboxChannelRequest.h>
#include <aws/pinpoint/model/GetApnsSandboxChannelResult.h>
#include <aws/pinpoint/model/GetApnsVoipChannelRequest.h>
#include <aws/pinpoint/model/GetApnsVoipChannelResult.h>
#include <aws/pinpoint/model/GetApnsVoipSandboxChannelRequest.h>
#include <aws/pinpoint/model/GetApnsVoipSandboxChannelResult.h>
#include <aws/pinpoint/model/GetAppRequest.h>
#include <aws/pinpoint/model/GetAppResult.h>
#include <aws/pinpoint/model/GetApplicationDateRangeKpiRequest.h>
#include <aws/pinpoint/model/GetApplicationDateRangeKpiResult.h>
#include <aws/pinpoint/model/GetApplicationSettingsRequest.h>
#include <aws/pinpoint/model/GetApplicationSettingsResult.h>
#include <aws/pinpoint/model/GetAppsRequest.h>
#include <aws/pinpoint/model/GetAppsResult.h>
#include <aws/pinpoint/model/GetBaiduChannelRequest.h>
#include <aws/pinpoint/model/GetBaiduChannelResult.h>
#include <aws/pinpoint/model/GetCampaignActivitiesRequest.h>
#include <aws/pinpoint/model/GetCampaignActivitiesResult.h>
#include <aws/pinpoint/model/GetCampaignDateRangeKpiRequest.h>
#include <aws/pinpoint/model/GetCampaignDateRangeKpiResult.h>
#include <aws/pinpoint/model/GetCampaignRequest.h>
#include <aws/pinpoint/model/GetCampaignResult.h>
#include <aws/pinpoint/model/GetCampaignVersionRequest.h>
#include <aws/pinpoint/model/GetCampaignVersionResult.h>
#include <aws/pinpoint/model/GetCampaignVersionsRequest.h>
#include <aws/pinpoint/model/GetCampaignVersionsResult.h>
#include <aws/pinpoint/model/GetCampaignsRequest.h>
#include <aws/pinpoint/model/GetCampaignsResult.h>
#include <aws/pinpoint/model/GetChannelsRequest.h>
#include <aws/pinpoint/model/GetChannelsResult.h>
#include <aws/pinpoint/model/GetEmailChannelRequest.h>
#include <aws/pinpoint/model/GetEmailChannelResult.h>
#include <aws/pinpoint/model/GetEmailTemplateRequest.h>
#include <aws/pinpoint/model/GetEmailTemplateResult.h>
#include <aws/pinpoint/model/GetEndpointRequest.h>
#include <aws/pinpoint/model/GetEndpointResult.h>
#include <aws/pinpoint/model/GetEventStreamRequest.h>
#include <aws/pinpoint/model/GetEventStreamResult.h>
#include <aws/pinpoint/model/GetExportJobRequest.h>
#include <aws/pinpoint/model/GetExportJobResult.h>
#include <aws/pinpoint/model/GetExportJobsRequest.h>
#include <aws/pinpoint/model/GetExportJobsResult.h>
#include <aws/pinpoint/model/GetGcmChannelRequest.h>
#include <aws/pinpoint/model/GetGcmChannelResult.h>
#include <aws/pinpoint/model/GetImportJobRequest.h>
#include <aws/pinpoint/model/GetImportJobResult.h>
#include <aws/pinpoint/model/GetImportJobsRequest.h>
#include <aws/pinpoint/model/GetImportJobsResult.h>
#include <aws/pinpoint/model/GetInAppMessagesRequest.h>
#include <aws/pinpoint/model/GetInAppMessagesResult.h>
#include <aws/pinpoint/model/GetInAppTemplateRequest.h>
#include <aws/pinpoint/model/GetInAppTemplateResult.h>
#include <aws/pinpoint/model/GetJourneyDateRangeKpiRequest.h>
#include <aws/pinpoint/model/GetJourneyDateRangeKpiResult.h>
#include <aws/pinpoint/model/GetJourneyExecutionActivityMetricsRequest.h>
#include <aws/pinpoint/model/GetJourneyExecutionActivityMetricsResult.h>
#include <aws/pinpoint/model/GetJourneyExecutionMetricsRequest.h>
#include <aws/pinpoint/model/GetJourneyExecutionMetricsResult.h>
#include <aws/pinpoint/model/GetJourneyRequest.h>
#include <aws/pinpoint/model/GetJourneyResult.h>
#include <aws/pinpoint/model/GetJourneyRunExecutionActivityMetricsRequest.h>
#include <aws/pinpoint/model/GetJourneyRunExecutionActivityMetricsResult.h>
#include <aws/pinpoint/model/GetJourneyRunExecutionMetricsRequest.h>
#include <aws/pinpoint/model/GetJourneyRunExecutionMetricsResult.h>
#include <aws/pinpoint/model/GetJourneyRunsRequest.h>
#include <aws/pinpoint/model/GetJourneyRunsResult.h>
#include <aws/pinpoint/model/GetPushTemplateRequest.h>
#include <aws/pinpoint/model/GetPushTemplateResult.h>
#include <aws/pinpoint/model/GetRecommenderConfigurationRequest.h>
#include <aws/pinpoint/model/GetRecommenderConfigurationResult.h>
#include <aws/pinpoint/model/GetRecommenderConfigurationsRequest.h>
#include <aws/pinpoint/model/GetRecommenderConfigurationsResult.h>
#include <aws/pinpoint/model/GetSegmentExportJobsRequest.h>
#include <aws/pinpoint/model/GetSegmentExportJobsResult.h>
#include <aws/pinpoint/model/GetSegmentImportJobsRequest.h>
#include <aws/pinpoint/model/GetSegmentImportJobsResult.h>
#include <aws/pinpoint/model/GetSegmentRequest.h>
#include <aws/pinpoint/model/GetSegmentResult.h>
#include <aws/pinpoint/model/GetSegmentVersionRequest.h>
#include <aws/pinpoint/model/GetSegmentVersionResult.h>
#include <aws/pinpoint/model/GetSegmentVersionsRequest.h>
#include <aws/pinpoint/model/GetSegmentVersionsResult.h>
#include <aws/pinpoint/model/GetSegmentsRequest.h>
#include <aws/pinpoint/model/GetSegmentsResult.h>
#include <aws/pinpoint/model/GetSmsChannelRequest.h>
#include <aws/pinpoint/model/GetSmsChannelResult.h>
#include <aws/pinpoint/model/GetSmsTemplateRequest.h>
#include <aws/pinpoint/model/GetSmsTemplateResult.h>
#include <aws/pinpoint/model/GetUserEndpointsRequest.h>
#include <aws/pinpoint/model/GetUserEndpointsResult.h>
#include <aws/pinpoint/model/GetVoiceChannelRequest.h>
#include <aws/pinpoint/model/GetVoiceChannelResult.h>
#include <aws/pinpoint/model/GetVoiceTemplateRequest.h>
#include <aws/pinpoint/model/GetVoiceTemplateResult.h>
#include <aws/pinpoint/model/HoldoutActivity.h>
#include <aws/pinpoint/model/ImportJobRequest.h>
#include <aws/pinpoint/model/ImportJobResource.h>
#include <aws/pinpoint/model/ImportJobResponse.h>
#include <aws/pinpoint/model/ImportJobsResponse.h>
#include <aws/pinpoint/model/InAppCampaignSchedule.h>
#include <aws/pinpoint/model/InAppMessage.h>
#include <aws/pinpoint/model/InAppMessageBodyConfig.h>
#include <aws/pinpoint/model/InAppMessageButton.h>
#include <aws/pinpoint/model/InAppMessageCampaign.h>
#include <aws/pinpoint/model/InAppMessageContent.h>
#include <aws/pinpoint/model/InAppMessageHeaderConfig.h>
#include <aws/pinpoint/model/InAppMessagesResponse.h>
#include <aws/pinpoint/model/InAppTemplateRequest.h>
#include <aws/pinpoint/model/InAppTemplateResponse.h>
#include <aws/pinpoint/model/Include.h>
#include <aws/pinpoint/model/InternalServerErrorException.h>
#include <aws/pinpoint/model/ItemResponse.h>
#include <aws/pinpoint/model/JobStatus.h>
#include <aws/pinpoint/model/JourneyChannelSettings.h>
#include <aws/pinpoint/model/JourneyCustomMessage.h>
#include <aws/pinpoint/model/JourneyDateRangeKpiResponse.h>
#include <aws/pinpoint/model/JourneyEmailMessage.h>
#include <aws/pinpoint/model/JourneyExecutionActivityMetricsResponse.h>
#include <aws/pinpoint/model/JourneyExecutionMetricsResponse.h>
#include <aws/pinpoint/model/JourneyLimits.h>
#include <aws/pinpoint/model/JourneyPushMessage.h>
#include <aws/pinpoint/model/JourneyResponse.h>
#include <aws/pinpoint/model/JourneyRunExecutionActivityMetricsResponse.h>
#include <aws/pinpoint/model/JourneyRunExecutionMetricsResponse.h>
#include <aws/pinpoint/model/JourneyRunResponse.h>
#include <aws/pinpoint/model/JourneyRunStatus.h>
#include <aws/pinpoint/model/JourneyRunsResponse.h>
#include <aws/pinpoint/model/JourneySMSMessage.h>
#include <aws/pinpoint/model/JourneySchedule.h>
#include <aws/pinpoint/model/JourneyStateRequest.h>
#include <aws/pinpoint/model/JourneyTimeframeCap.h>
#include <aws/pinpoint/model/JourneysResponse.h>
#include <aws/pinpoint/model/Layout.h>
#include <aws/pinpoint/model/ListJourneysRequest.h>
#include <aws/pinpoint/model/ListJourneysResult.h>
#include <aws/pinpoint/model/ListRecommenderConfigurationsResponse.h>
#include <aws/pinpoint/model/ListTagsForResourceRequest.h>
#include <aws/pinpoint/model/ListTagsForResourceResult.h>
#include <aws/pinpoint/model/ListTemplateVersionsRequest.h>
#include <aws/pinpoint/model/ListTemplateVersionsResult.h>
#include <aws/pinpoint/model/ListTemplatesRequest.h>
#include <aws/pinpoint/model/ListTemplatesResult.h>
#include <aws/pinpoint/model/Message.h>
#include <aws/pinpoint/model/MessageBody.h>
#include <aws/pinpoint/model/MessageConfiguration.h>
#include <aws/pinpoint/model/MessageHeader.h>
#include <aws/pinpoint/model/MessageRequest.h>
#include <aws/pinpoint/model/MessageResponse.h>
#include <aws/pinpoint/model/MessageResult.h>
#include <aws/pinpoint/model/MessageType.h>
#include <aws/pinpoint/model/MethodNotAllowedException.h>
#include <aws/pinpoint/model/MetricDimension.h>
#include <aws/pinpoint/model/Mode.h>
#include <aws/pinpoint/model/MultiConditionalBranch.h>
#include <aws/pinpoint/model/MultiConditionalSplitActivity.h>
#include <aws/pinpoint/model/NotFoundException.h>
#include <aws/pinpoint/model/NumberValidateRequest.h>
#include <aws/pinpoint/model/NumberValidateResponse.h>
#include <aws/pinpoint/model/OpenHours.h>
#include <aws/pinpoint/model/OpenHoursRule.h>
#include <aws/pinpoint/model/Operator.h>
#include <aws/pinpoint/model/OverrideButtonConfiguration.h>
#include <aws/pinpoint/model/PayloadTooLargeException.h>
#include <aws/pinpoint/model/PhoneNumberValidateRequest.h>
#include <aws/pinpoint/model/PhoneNumberValidateResult.h>
#include <aws/pinpoint/model/PublicEndpoint.h>
#include <aws/pinpoint/model/PushMessageActivity.h>
#include <aws/pinpoint/model/PushNotificationTemplateRequest.h>
#include <aws/pinpoint/model/PushNotificationTemplateResponse.h>
#include <aws/pinpoint/model/PutEventStreamRequest.h>
#include <aws/pinpoint/model/PutEventStreamResult.h>
#include <aws/pinpoint/model/PutEventsRequest.h>
#include <aws/pinpoint/model/PutEventsResult.h>
#include <aws/pinpoint/model/QuietTime.h>
#include <aws/pinpoint/model/RandomSplitActivity.h>
#include <aws/pinpoint/model/RandomSplitEntry.h>
#include <aws/pinpoint/model/RawEmail.h>
#include <aws/pinpoint/model/RecencyDimension.h>
#include <aws/pinpoint/model/RecencyType.h>
#include <aws/pinpoint/model/RecommenderConfigurationResponse.h>
#include <aws/pinpoint/model/RemoveAttributesRequest.h>
#include <aws/pinpoint/model/RemoveAttributesResult.h>
#include <aws/pinpoint/model/ResultRow.h>
#include <aws/pinpoint/model/ResultRowValue.h>
#include <aws/pinpoint/model/SMSChannelRequest.h>
#include <aws/pinpoint/model/SMSChannelResponse.h>
#include <aws/pinpoint/model/SMSMessage.h>
#include <aws/pinpoint/model/SMSMessageActivity.h>
#include <aws/pinpoint/model/SMSTemplateRequest.h>
#include <aws/pinpoint/model/SMSTemplateResponse.h>
#include <aws/pinpoint/model/Schedule.h>
#include <aws/pinpoint/model/SegmentBehaviors.h>
#include <aws/pinpoint/model/SegmentCondition.h>
#include <aws/pinpoint/model/SegmentDemographics.h>
#include <aws/pinpoint/model/SegmentDimensions.h>
#include <aws/pinpoint/model/SegmentGroup.h>
#include <aws/pinpoint/model/SegmentGroupList.h>
#include <aws/pinpoint/model/SegmentImportResource.h>
#include <aws/pinpoint/model/SegmentLocation.h>
#include <aws/pinpoint/model/SegmentReference.h>
#include <aws/pinpoint/model/SegmentResponse.h>
#include <aws/pinpoint/model/SegmentType.h>
#include <aws/pinpoint/model/SegmentsResponse.h>
#include <aws/pinpoint/model/SendMessagesRequest.h>
#include <aws/pinpoint/model/SendMessagesResult.h>
#include <aws/pinpoint/model/SendOTPMessageRequest.h>
#include <aws/pinpoint/model/SendOTPMessageRequestParameters.h>
#include <aws/pinpoint/model/SendOTPMessageResult.h>
#include <aws/pinpoint/model/SendUsersMessageRequest.h>
#include <aws/pinpoint/model/SendUsersMessageResponse.h>
#include <aws/pinpoint/model/SendUsersMessagesRequest.h>
#include <aws/pinpoint/model/SendUsersMessagesResult.h>
#include <aws/pinpoint/model/Session.h>
#include <aws/pinpoint/model/SetDimension.h>
#include <aws/pinpoint/model/SimpleCondition.h>
#include <aws/pinpoint/model/SimpleEmail.h>
#include <aws/pinpoint/model/SimpleEmailPart.h>
#include <aws/pinpoint/model/SourceType.h>
#include <aws/pinpoint/model/StartCondition.h>
#include <aws/pinpoint/model/State.h>
#include <aws/pinpoint/model/TagResourceRequest.h>
#include <aws/pinpoint/model/TagsModel.h>
#include <aws/pinpoint/model/Template.h>
#include <aws/pinpoint/model/TemplateActiveVersionRequest.h>
#include <aws/pinpoint/model/TemplateConfiguration.h>
#include <aws/pinpoint/model/TemplateCreateMessageBody.h>
#include <aws/pinpoint/model/TemplateResponse.h>
#include <aws/pinpoint/model/TemplateType.h>
#include <aws/pinpoint/model/TemplateVersionResponse.h>
#include <aws/pinpoint/model/TemplateVersionsResponse.h>
#include <aws/pinpoint/model/TemplatesResponse.h>
#include <aws/pinpoint/model/TooManyRequestsException.h>
#include <aws/pinpoint/model/TreatmentResource.h>
#include <aws/pinpoint/model/Type.h>
#include <aws/pinpoint/model/UntagResourceRequest.h>
#include <aws/pinpoint/model/UpdateAdmChannelRequest.h>
#include <aws/pinpoint/model/UpdateAdmChannelResult.h>
#include <aws/pinpoint/model/UpdateApnsChannelRequest.h>
#include <aws/pinpoint/model/UpdateApnsChannelResult.h>
#include <aws/pinpoint/model/UpdateApnsSandboxChannelRequest.h>
#include <aws/pinpoint/model/UpdateApnsSandboxChannelResult.h>
#include <aws/pinpoint/model/UpdateApnsVoipChannelRequest.h>
#include <aws/pinpoint/model/UpdateApnsVoipChannelResult.h>
#include <aws/pinpoint/model/UpdateApnsVoipSandboxChannelRequest.h>
#include <aws/pinpoint/model/UpdateApnsVoipSandboxChannelResult.h>
#include <aws/pinpoint/model/UpdateApplicationSettingsRequest.h>
#include <aws/pinpoint/model/UpdateApplicationSettingsResult.h>
#include <aws/pinpoint/model/UpdateAttributesRequest.h>
#include <aws/pinpoint/model/UpdateBaiduChannelRequest.h>
#include <aws/pinpoint/model/UpdateBaiduChannelResult.h>
#include <aws/pinpoint/model/UpdateCampaignRequest.h>
#include <aws/pinpoint/model/UpdateCampaignResult.h>
#include <aws/pinpoint/model/UpdateEmailChannelRequest.h>
#include <aws/pinpoint/model/UpdateEmailChannelResult.h>
#include <aws/pinpoint/model/UpdateEmailTemplateRequest.h>
#include <aws/pinpoint/model/UpdateEmailTemplateResult.h>
#include <aws/pinpoint/model/UpdateEndpointRequest.h>
#include <aws/pinpoint/model/UpdateEndpointResult.h>
#include <aws/pinpoint/model/UpdateEndpointsBatchRequest.h>
#include <aws/pinpoint/model/UpdateEndpointsBatchResult.h>
#include <aws/pinpoint/model/UpdateGcmChannelRequest.h>
#include <aws/pinpoint/model/UpdateGcmChannelResult.h>
#include <aws/pinpoint/model/UpdateInAppTemplateRequest.h>
#include <aws/pinpoint/model/UpdateInAppTemplateResult.h>
#include <aws/pinpoint/model/UpdateJourneyRequest.h>
#include <aws/pinpoint/model/UpdateJourneyResult.h>
#include <aws/pinpoint/model/UpdateJourneyStateRequest.h>
#include <aws/pinpoint/model/UpdateJourneyStateResult.h>
#include <aws/pinpoint/model/UpdatePushTemplateRequest.h>
#include <aws/pinpoint/model/UpdatePushTemplateResult.h>
#include <aws/pinpoint/model/UpdateRecommenderConfiguration.h>
#include <aws/pinpoint/model/UpdateRecommenderConfigurationRequest.h>
#include <aws/pinpoint/model/UpdateRecommenderConfigurationResult.h>
#include <aws/pinpoint/model/UpdateSegmentRequest.h>
#include <aws/pinpoint/model/UpdateSegmentResult.h>
#include <aws/pinpoint/model/UpdateSmsChannelRequest.h>
#include <aws/pinpoint/model/UpdateSmsChannelResult.h>
#include <aws/pinpoint/model/UpdateSmsTemplateRequest.h>
#include <aws/pinpoint/model/UpdateSmsTemplateResult.h>
#include <aws/pinpoint/model/UpdateTemplateActiveVersionRequest.h>
#include <aws/pinpoint/model/UpdateTemplateActiveVersionResult.h>
#include <aws/pinpoint/model/UpdateVoiceChannelRequest.h>
#include <aws/pinpoint/model/UpdateVoiceChannelResult.h>
#include <aws/pinpoint/model/UpdateVoiceTemplateRequest.h>
#include <aws/pinpoint/model/UpdateVoiceTemplateResult.h>
#include <aws/pinpoint/model/VerificationResponse.h>
#include <aws/pinpoint/model/VerifyOTPMessageRequest.h>
#include <aws/pinpoint/model/VerifyOTPMessageRequestParameters.h>
#include <aws/pinpoint/model/VerifyOTPMessageResult.h>
#include <aws/pinpoint/model/VoiceChannelRequest.h>
#include <aws/pinpoint/model/VoiceChannelResponse.h>
#include <aws/pinpoint/model/VoiceMessage.h>
#include <aws/pinpoint/model/VoiceTemplateRequest.h>
#include <aws/pinpoint/model/VoiceTemplateResponse.h>
#include <aws/pinpoint/model/WaitActivity.h>
#include <aws/pinpoint/model/WaitTime.h>
#include <aws/pinpoint/model/WriteApplicationSettingsRequest.h>
#include <aws/pinpoint/model/WriteCampaignRequest.h>
#include <aws/pinpoint/model/WriteEventStream.h>
#include <aws/pinpoint/model/WriteJourneyRequest.h>
#include <aws/pinpoint/model/WriteSegmentRequest.h>
#include <aws/pinpoint/model/WriteTreatmentResource.h>
#include <aws/pinpoint/model/__EndpointTypesElement.h>
#include <aws/pinpoint/model/__TimezoneEstimationMethodsElement.h>

using PinpointIncludeTest = ::testing::Test;

TEST_F(PinpointIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::Pinpoint::PinpointClient>("PinpointIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
