/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/pinpoint-sms-voice-v2/PinpointSMSVoiceV2Client.h>
#include <aws/pinpoint-sms-voice-v2/PinpointSMSVoiceV2EndpointProvider.h>
#include <aws/pinpoint-sms-voice-v2/PinpointSMSVoiceV2EndpointRules.h>
#include <aws/pinpoint-sms-voice-v2/PinpointSMSVoiceV2ErrorMarshaller.h>
#include <aws/pinpoint-sms-voice-v2/PinpointSMSVoiceV2Errors.h>
#include <aws/pinpoint-sms-voice-v2/PinpointSMSVoiceV2Request.h>
#include <aws/pinpoint-sms-voice-v2/PinpointSMSVoiceV2ServiceClientModel.h>
#include <aws/pinpoint-sms-voice-v2/PinpointSMSVoiceV2_EXPORTS.h>
#include <aws/pinpoint-sms-voice-v2/model/AccessDeniedException.h>
#include <aws/pinpoint-sms-voice-v2/model/AccessDeniedExceptionReason.h>
#include <aws/pinpoint-sms-voice-v2/model/AccountAttribute.h>
#include <aws/pinpoint-sms-voice-v2/model/AccountAttributeName.h>
#include <aws/pinpoint-sms-voice-v2/model/AccountLimit.h>
#include <aws/pinpoint-sms-voice-v2/model/AccountLimitName.h>
#include <aws/pinpoint-sms-voice-v2/model/AssociateOriginationIdentityRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/AssociateOriginationIdentityResult.h>
#include <aws/pinpoint-sms-voice-v2/model/AssociateProtectConfigurationRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/AssociateProtectConfigurationResult.h>
#include <aws/pinpoint-sms-voice-v2/model/AttachmentStatus.h>
#include <aws/pinpoint-sms-voice-v2/model/AttachmentUploadErrorReason.h>
#include <aws/pinpoint-sms-voice-v2/model/CloudWatchLogsDestination.h>
#include <aws/pinpoint-sms-voice-v2/model/ConfigurationSetFilter.h>
#include <aws/pinpoint-sms-voice-v2/model/ConfigurationSetFilterName.h>
#include <aws/pinpoint-sms-voice-v2/model/ConfigurationSetInformation.h>
#include <aws/pinpoint-sms-voice-v2/model/ConflictException.h>
#include <aws/pinpoint-sms-voice-v2/model/ConflictExceptionReason.h>
#include <aws/pinpoint-sms-voice-v2/model/CreateConfigurationSetRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/CreateConfigurationSetResult.h>
#include <aws/pinpoint-sms-voice-v2/model/CreateEventDestinationRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/CreateEventDestinationResult.h>
#include <aws/pinpoint-sms-voice-v2/model/CreateOptOutListRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/CreateOptOutListResult.h>
#include <aws/pinpoint-sms-voice-v2/model/CreatePoolRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/CreatePoolResult.h>
#include <aws/pinpoint-sms-voice-v2/model/CreateProtectConfigurationRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/CreateProtectConfigurationResult.h>
#include <aws/pinpoint-sms-voice-v2/model/CreateRegistrationAssociationRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/CreateRegistrationAssociationResult.h>
#include <aws/pinpoint-sms-voice-v2/model/CreateRegistrationAttachmentRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/CreateRegistrationAttachmentResult.h>
#include <aws/pinpoint-sms-voice-v2/model/CreateRegistrationRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/CreateRegistrationResult.h>
#include <aws/pinpoint-sms-voice-v2/model/CreateRegistrationVersionRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/CreateRegistrationVersionResult.h>
#include <aws/pinpoint-sms-voice-v2/model/CreateVerifiedDestinationNumberRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/CreateVerifiedDestinationNumberResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DeleteAccountDefaultProtectConfigurationRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DeleteAccountDefaultProtectConfigurationResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DeleteConfigurationSetRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DeleteConfigurationSetResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DeleteDefaultMessageTypeRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DeleteDefaultMessageTypeResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DeleteDefaultSenderIdRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DeleteDefaultSenderIdResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DeleteEventDestinationRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DeleteEventDestinationResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DeleteKeywordRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DeleteKeywordResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DeleteMediaMessageSpendLimitOverrideRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DeleteMediaMessageSpendLimitOverrideResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DeleteOptOutListRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DeleteOptOutListResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DeleteOptedOutNumberRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DeleteOptedOutNumberResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DeletePoolRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DeletePoolResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DeleteProtectConfigurationRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DeleteProtectConfigurationResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DeleteProtectConfigurationRuleSetNumberOverrideRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DeleteProtectConfigurationRuleSetNumberOverrideResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DeleteRegistrationAttachmentRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DeleteRegistrationAttachmentResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DeleteRegistrationFieldValueRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DeleteRegistrationFieldValueResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DeleteRegistrationRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DeleteRegistrationResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DeleteResourcePolicyRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DeleteResourcePolicyResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DeleteTextMessageSpendLimitOverrideRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DeleteTextMessageSpendLimitOverrideResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DeleteVerifiedDestinationNumberRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DeleteVerifiedDestinationNumberResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DeleteVoiceMessageSpendLimitOverrideRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DeleteVoiceMessageSpendLimitOverrideResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribeAccountAttributesRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribeAccountAttributesResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribeAccountLimitsRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribeAccountLimitsResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribeConfigurationSetsRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribeConfigurationSetsResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribeKeywordsRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribeKeywordsResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribeOptOutListsRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribeOptOutListsResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribeOptedOutNumbersRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribeOptedOutNumbersResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribePhoneNumbersRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribePhoneNumbersResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribePoolsRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribePoolsResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribeProtectConfigurationsRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribeProtectConfigurationsResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribeRegistrationAttachmentsRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribeRegistrationAttachmentsResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribeRegistrationFieldDefinitionsRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribeRegistrationFieldDefinitionsResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribeRegistrationFieldValuesRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribeRegistrationFieldValuesResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribeRegistrationSectionDefinitionsRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribeRegistrationSectionDefinitionsResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribeRegistrationTypeDefinitionsRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribeRegistrationTypeDefinitionsResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribeRegistrationVersionsRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribeRegistrationVersionsResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribeRegistrationsRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribeRegistrationsResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribeSenderIdsRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribeSenderIdsResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribeSpendLimitsRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribeSpendLimitsResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribeVerifiedDestinationNumbersRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DescribeVerifiedDestinationNumbersResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DestinationCountryParameterKey.h>
#include <aws/pinpoint-sms-voice-v2/model/DisassociateOriginationIdentityRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DisassociateOriginationIdentityResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DisassociateProtectConfigurationRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DisassociateProtectConfigurationResult.h>
#include <aws/pinpoint-sms-voice-v2/model/DiscardRegistrationVersionRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/DiscardRegistrationVersionResult.h>
#include <aws/pinpoint-sms-voice-v2/model/EventDestination.h>
#include <aws/pinpoint-sms-voice-v2/model/EventType.h>
#include <aws/pinpoint-sms-voice-v2/model/FieldRequirement.h>
#include <aws/pinpoint-sms-voice-v2/model/FieldType.h>
#include <aws/pinpoint-sms-voice-v2/model/GetProtectConfigurationCountryRuleSetRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/GetProtectConfigurationCountryRuleSetResult.h>
#include <aws/pinpoint-sms-voice-v2/model/GetResourcePolicyRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/GetResourcePolicyResult.h>
#include <aws/pinpoint-sms-voice-v2/model/InternalServerException.h>
#include <aws/pinpoint-sms-voice-v2/model/KeywordAction.h>
#include <aws/pinpoint-sms-voice-v2/model/KeywordFilter.h>
#include <aws/pinpoint-sms-voice-v2/model/KeywordFilterName.h>
#include <aws/pinpoint-sms-voice-v2/model/KeywordInformation.h>
#include <aws/pinpoint-sms-voice-v2/model/KinesisFirehoseDestination.h>
#include <aws/pinpoint-sms-voice-v2/model/LanguageCode.h>
#include <aws/pinpoint-sms-voice-v2/model/ListPoolOriginationIdentitiesRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/ListPoolOriginationIdentitiesResult.h>
#include <aws/pinpoint-sms-voice-v2/model/ListProtectConfigurationRuleSetNumberOverridesRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/ListProtectConfigurationRuleSetNumberOverridesResult.h>
#include <aws/pinpoint-sms-voice-v2/model/ListRegistrationAssociationsRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/ListRegistrationAssociationsResult.h>
#include <aws/pinpoint-sms-voice-v2/model/ListTagsForResourceRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/ListTagsForResourceResult.h>
#include <aws/pinpoint-sms-voice-v2/model/MessageFeedbackStatus.h>
#include <aws/pinpoint-sms-voice-v2/model/MessageType.h>
#include <aws/pinpoint-sms-voice-v2/model/NumberCapability.h>
#include <aws/pinpoint-sms-voice-v2/model/NumberStatus.h>
#include <aws/pinpoint-sms-voice-v2/model/NumberType.h>
#include <aws/pinpoint-sms-voice-v2/model/OptOutListInformation.h>
#include <aws/pinpoint-sms-voice-v2/model/OptedOutFilter.h>
#include <aws/pinpoint-sms-voice-v2/model/OptedOutFilterName.h>
#include <aws/pinpoint-sms-voice-v2/model/OptedOutNumberInformation.h>
#include <aws/pinpoint-sms-voice-v2/model/OriginationIdentityMetadata.h>
#include <aws/pinpoint-sms-voice-v2/model/Owner.h>
#include <aws/pinpoint-sms-voice-v2/model/PhoneNumberFilter.h>
#include <aws/pinpoint-sms-voice-v2/model/PhoneNumberFilterName.h>
#include <aws/pinpoint-sms-voice-v2/model/PhoneNumberInformation.h>
#include <aws/pinpoint-sms-voice-v2/model/PoolFilter.h>
#include <aws/pinpoint-sms-voice-v2/model/PoolFilterName.h>
#include <aws/pinpoint-sms-voice-v2/model/PoolInformation.h>
#include <aws/pinpoint-sms-voice-v2/model/PoolOriginationIdentitiesFilter.h>
#include <aws/pinpoint-sms-voice-v2/model/PoolOriginationIdentitiesFilterName.h>
#include <aws/pinpoint-sms-voice-v2/model/PoolStatus.h>
#include <aws/pinpoint-sms-voice-v2/model/ProtectConfigurationCountryRuleSetInformation.h>
#include <aws/pinpoint-sms-voice-v2/model/ProtectConfigurationFilter.h>
#include <aws/pinpoint-sms-voice-v2/model/ProtectConfigurationFilterName.h>
#include <aws/pinpoint-sms-voice-v2/model/ProtectConfigurationInformation.h>
#include <aws/pinpoint-sms-voice-v2/model/ProtectConfigurationRuleOverrideAction.h>
#include <aws/pinpoint-sms-voice-v2/model/ProtectConfigurationRuleSetNumberOverride.h>
#include <aws/pinpoint-sms-voice-v2/model/ProtectConfigurationRuleSetNumberOverrideFilterItem.h>
#include <aws/pinpoint-sms-voice-v2/model/ProtectConfigurationRuleSetNumberOverrideFilterName.h>
#include <aws/pinpoint-sms-voice-v2/model/ProtectStatus.h>
#include <aws/pinpoint-sms-voice-v2/model/PutKeywordRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/PutKeywordResult.h>
#include <aws/pinpoint-sms-voice-v2/model/PutMessageFeedbackRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/PutMessageFeedbackResult.h>
#include <aws/pinpoint-sms-voice-v2/model/PutOptedOutNumberRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/PutOptedOutNumberResult.h>
#include <aws/pinpoint-sms-voice-v2/model/PutProtectConfigurationRuleSetNumberOverrideRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/PutProtectConfigurationRuleSetNumberOverrideResult.h>
#include <aws/pinpoint-sms-voice-v2/model/PutRegistrationFieldValueRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/PutRegistrationFieldValueResult.h>
#include <aws/pinpoint-sms-voice-v2/model/PutResourcePolicyRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/PutResourcePolicyResult.h>
#include <aws/pinpoint-sms-voice-v2/model/RegistrationAssociationBehavior.h>
#include <aws/pinpoint-sms-voice-v2/model/RegistrationAssociationFilter.h>
#include <aws/pinpoint-sms-voice-v2/model/RegistrationAssociationFilterName.h>
#include <aws/pinpoint-sms-voice-v2/model/RegistrationAssociationMetadata.h>
#include <aws/pinpoint-sms-voice-v2/model/RegistrationAttachmentFilter.h>
#include <aws/pinpoint-sms-voice-v2/model/RegistrationAttachmentFilterName.h>
#include <aws/pinpoint-sms-voice-v2/model/RegistrationAttachmentsInformation.h>
#include <aws/pinpoint-sms-voice-v2/model/RegistrationDeniedReasonInformation.h>
#include <aws/pinpoint-sms-voice-v2/model/RegistrationDisassociationBehavior.h>
#include <aws/pinpoint-sms-voice-v2/model/RegistrationFieldDefinition.h>
#include <aws/pinpoint-sms-voice-v2/model/RegistrationFieldDisplayHints.h>
#include <aws/pinpoint-sms-voice-v2/model/RegistrationFieldValueInformation.h>
#include <aws/pinpoint-sms-voice-v2/model/RegistrationFilter.h>
#include <aws/pinpoint-sms-voice-v2/model/RegistrationFilterName.h>
#include <aws/pinpoint-sms-voice-v2/model/RegistrationInformation.h>
#include <aws/pinpoint-sms-voice-v2/model/RegistrationSectionDefinition.h>
#include <aws/pinpoint-sms-voice-v2/model/RegistrationSectionDisplayHints.h>
#include <aws/pinpoint-sms-voice-v2/model/RegistrationStatus.h>
#include <aws/pinpoint-sms-voice-v2/model/RegistrationTypeDefinition.h>
#include <aws/pinpoint-sms-voice-v2/model/RegistrationTypeDisplayHints.h>
#include <aws/pinpoint-sms-voice-v2/model/RegistrationTypeFilter.h>
#include <aws/pinpoint-sms-voice-v2/model/RegistrationTypeFilterName.h>
#include <aws/pinpoint-sms-voice-v2/model/RegistrationVersionFilter.h>
#include <aws/pinpoint-sms-voice-v2/model/RegistrationVersionFilterName.h>
#include <aws/pinpoint-sms-voice-v2/model/RegistrationVersionInformation.h>
#include <aws/pinpoint-sms-voice-v2/model/RegistrationVersionStatus.h>
#include <aws/pinpoint-sms-voice-v2/model/RegistrationVersionStatusHistory.h>
#include <aws/pinpoint-sms-voice-v2/model/ReleasePhoneNumberRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/ReleasePhoneNumberResult.h>
#include <aws/pinpoint-sms-voice-v2/model/ReleaseSenderIdRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/ReleaseSenderIdResult.h>
#include <aws/pinpoint-sms-voice-v2/model/RequestPhoneNumberRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/RequestPhoneNumberResult.h>
#include <aws/pinpoint-sms-voice-v2/model/RequestSenderIdRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/RequestSenderIdResult.h>
#include <aws/pinpoint-sms-voice-v2/model/RequestableNumberType.h>
#include <aws/pinpoint-sms-voice-v2/model/ResourceNotFoundException.h>
#include <aws/pinpoint-sms-voice-v2/model/ResourceType.h>
#include <aws/pinpoint-sms-voice-v2/model/SelectOptionDescription.h>
#include <aws/pinpoint-sms-voice-v2/model/SelectValidation.h>
#include <aws/pinpoint-sms-voice-v2/model/SendDestinationNumberVerificationCodeRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/SendDestinationNumberVerificationCodeResult.h>
#include <aws/pinpoint-sms-voice-v2/model/SendMediaMessageRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/SendMediaMessageResult.h>
#include <aws/pinpoint-sms-voice-v2/model/SendTextMessageRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/SendTextMessageResult.h>
#include <aws/pinpoint-sms-voice-v2/model/SendVoiceMessageRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/SendVoiceMessageResult.h>
#include <aws/pinpoint-sms-voice-v2/model/SenderIdAndCountry.h>
#include <aws/pinpoint-sms-voice-v2/model/SenderIdFilter.h>
#include <aws/pinpoint-sms-voice-v2/model/SenderIdFilterName.h>
#include <aws/pinpoint-sms-voice-v2/model/SenderIdInformation.h>
#include <aws/pinpoint-sms-voice-v2/model/ServiceQuotaExceededException.h>
#include <aws/pinpoint-sms-voice-v2/model/ServiceQuotaExceededExceptionReason.h>
#include <aws/pinpoint-sms-voice-v2/model/SetAccountDefaultProtectConfigurationRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/SetAccountDefaultProtectConfigurationResult.h>
#include <aws/pinpoint-sms-voice-v2/model/SetDefaultMessageFeedbackEnabledRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/SetDefaultMessageFeedbackEnabledResult.h>
#include <aws/pinpoint-sms-voice-v2/model/SetDefaultMessageTypeRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/SetDefaultMessageTypeResult.h>
#include <aws/pinpoint-sms-voice-v2/model/SetDefaultSenderIdRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/SetDefaultSenderIdResult.h>
#include <aws/pinpoint-sms-voice-v2/model/SetMediaMessageSpendLimitOverrideRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/SetMediaMessageSpendLimitOverrideResult.h>
#include <aws/pinpoint-sms-voice-v2/model/SetTextMessageSpendLimitOverrideRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/SetTextMessageSpendLimitOverrideResult.h>
#include <aws/pinpoint-sms-voice-v2/model/SetVoiceMessageSpendLimitOverrideRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/SetVoiceMessageSpendLimitOverrideResult.h>
#include <aws/pinpoint-sms-voice-v2/model/SnsDestination.h>
#include <aws/pinpoint-sms-voice-v2/model/SpendLimit.h>
#include <aws/pinpoint-sms-voice-v2/model/SpendLimitName.h>
#include <aws/pinpoint-sms-voice-v2/model/SubmitRegistrationVersionRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/SubmitRegistrationVersionResult.h>
#include <aws/pinpoint-sms-voice-v2/model/SupportedAssociation.h>
#include <aws/pinpoint-sms-voice-v2/model/Tag.h>
#include <aws/pinpoint-sms-voice-v2/model/TagResourceRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/TagResourceResult.h>
#include <aws/pinpoint-sms-voice-v2/model/TextValidation.h>
#include <aws/pinpoint-sms-voice-v2/model/UntagResourceRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/UntagResourceResult.h>
#include <aws/pinpoint-sms-voice-v2/model/UpdateEventDestinationRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/UpdateEventDestinationResult.h>
#include <aws/pinpoint-sms-voice-v2/model/UpdatePhoneNumberRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/UpdatePhoneNumberResult.h>
#include <aws/pinpoint-sms-voice-v2/model/UpdatePoolRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/UpdatePoolResult.h>
#include <aws/pinpoint-sms-voice-v2/model/UpdateProtectConfigurationCountryRuleSetRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/UpdateProtectConfigurationCountryRuleSetResult.h>
#include <aws/pinpoint-sms-voice-v2/model/UpdateProtectConfigurationRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/UpdateProtectConfigurationResult.h>
#include <aws/pinpoint-sms-voice-v2/model/UpdateSenderIdRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/UpdateSenderIdResult.h>
#include <aws/pinpoint-sms-voice-v2/model/ValidationException.h>
#include <aws/pinpoint-sms-voice-v2/model/ValidationExceptionField.h>
#include <aws/pinpoint-sms-voice-v2/model/ValidationExceptionReason.h>
#include <aws/pinpoint-sms-voice-v2/model/VerificationChannel.h>
#include <aws/pinpoint-sms-voice-v2/model/VerificationStatus.h>
#include <aws/pinpoint-sms-voice-v2/model/VerifiedDestinationNumberFilter.h>
#include <aws/pinpoint-sms-voice-v2/model/VerifiedDestinationNumberFilterName.h>
#include <aws/pinpoint-sms-voice-v2/model/VerifiedDestinationNumberInformation.h>
#include <aws/pinpoint-sms-voice-v2/model/VerifyDestinationNumberRequest.h>
#include <aws/pinpoint-sms-voice-v2/model/VerifyDestinationNumberResult.h>
#include <aws/pinpoint-sms-voice-v2/model/VoiceId.h>
#include <aws/pinpoint-sms-voice-v2/model/VoiceMessageBodyTextType.h>

using PinpointSMSVoiceV2IncludeTest = ::testing::Test;

TEST_F(PinpointSMSVoiceV2IncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::PinpointSMSVoiceV2::PinpointSMSVoiceV2Client>("PinpointSMSVoiceV2IncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
