/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/proton/ProtonClient.h>
#include <aws/proton/ProtonEndpointProvider.h>
#include <aws/proton/ProtonEndpointRules.h>
#include <aws/proton/ProtonErrorMarshaller.h>
#include <aws/proton/ProtonErrors.h>
#include <aws/proton/ProtonRequest.h>
#include <aws/proton/ProtonServiceClientModel.h>
#include <aws/proton/Proton_EXPORTS.h>
#include <aws/proton/model/AcceptEnvironmentAccountConnectionRequest.h>
#include <aws/proton/model/AcceptEnvironmentAccountConnectionResult.h>
#include <aws/proton/model/AccountSettings.h>
#include <aws/proton/model/BlockerStatus.h>
#include <aws/proton/model/BlockerType.h>
#include <aws/proton/model/CancelComponentDeploymentRequest.h>
#include <aws/proton/model/CancelComponentDeploymentResult.h>
#include <aws/proton/model/CancelEnvironmentDeploymentRequest.h>
#include <aws/proton/model/CancelEnvironmentDeploymentResult.h>
#include <aws/proton/model/CancelServiceInstanceDeploymentRequest.h>
#include <aws/proton/model/CancelServiceInstanceDeploymentResult.h>
#include <aws/proton/model/CancelServicePipelineDeploymentRequest.h>
#include <aws/proton/model/CancelServicePipelineDeploymentResult.h>
#include <aws/proton/model/CompatibleEnvironmentTemplate.h>
#include <aws/proton/model/CompatibleEnvironmentTemplateInput.h>
#include <aws/proton/model/Component.h>
#include <aws/proton/model/ComponentDeploymentUpdateType.h>
#include <aws/proton/model/ComponentState.h>
#include <aws/proton/model/ComponentSummary.h>
#include <aws/proton/model/CountsSummary.h>
#include <aws/proton/model/CreateComponentRequest.h>
#include <aws/proton/model/CreateComponentResult.h>
#include <aws/proton/model/CreateEnvironmentAccountConnectionRequest.h>
#include <aws/proton/model/CreateEnvironmentAccountConnectionResult.h>
#include <aws/proton/model/CreateEnvironmentRequest.h>
#include <aws/proton/model/CreateEnvironmentResult.h>
#include <aws/proton/model/CreateEnvironmentTemplateRequest.h>
#include <aws/proton/model/CreateEnvironmentTemplateResult.h>
#include <aws/proton/model/CreateEnvironmentTemplateVersionRequest.h>
#include <aws/proton/model/CreateEnvironmentTemplateVersionResult.h>
#include <aws/proton/model/CreateRepositoryRequest.h>
#include <aws/proton/model/CreateRepositoryResult.h>
#include <aws/proton/model/CreateServiceInstanceRequest.h>
#include <aws/proton/model/CreateServiceInstanceResult.h>
#include <aws/proton/model/CreateServiceRequest.h>
#include <aws/proton/model/CreateServiceResult.h>
#include <aws/proton/model/CreateServiceSyncConfigRequest.h>
#include <aws/proton/model/CreateServiceSyncConfigResult.h>
#include <aws/proton/model/CreateServiceTemplateRequest.h>
#include <aws/proton/model/CreateServiceTemplateResult.h>
#include <aws/proton/model/CreateServiceTemplateVersionRequest.h>
#include <aws/proton/model/CreateServiceTemplateVersionResult.h>
#include <aws/proton/model/CreateTemplateSyncConfigRequest.h>
#include <aws/proton/model/CreateTemplateSyncConfigResult.h>
#include <aws/proton/model/DeleteComponentRequest.h>
#include <aws/proton/model/DeleteComponentResult.h>
#include <aws/proton/model/DeleteDeploymentRequest.h>
#include <aws/proton/model/DeleteDeploymentResult.h>
#include <aws/proton/model/DeleteEnvironmentAccountConnectionRequest.h>
#include <aws/proton/model/DeleteEnvironmentAccountConnectionResult.h>
#include <aws/proton/model/DeleteEnvironmentRequest.h>
#include <aws/proton/model/DeleteEnvironmentResult.h>
#include <aws/proton/model/DeleteEnvironmentTemplateRequest.h>
#include <aws/proton/model/DeleteEnvironmentTemplateResult.h>
#include <aws/proton/model/DeleteEnvironmentTemplateVersionRequest.h>
#include <aws/proton/model/DeleteEnvironmentTemplateVersionResult.h>
#include <aws/proton/model/DeleteRepositoryRequest.h>
#include <aws/proton/model/DeleteRepositoryResult.h>
#include <aws/proton/model/DeleteServiceRequest.h>
#include <aws/proton/model/DeleteServiceResult.h>
#include <aws/proton/model/DeleteServiceSyncConfigRequest.h>
#include <aws/proton/model/DeleteServiceSyncConfigResult.h>
#include <aws/proton/model/DeleteServiceTemplateRequest.h>
#include <aws/proton/model/DeleteServiceTemplateResult.h>
#include <aws/proton/model/DeleteServiceTemplateVersionRequest.h>
#include <aws/proton/model/DeleteServiceTemplateVersionResult.h>
#include <aws/proton/model/DeleteTemplateSyncConfigRequest.h>
#include <aws/proton/model/DeleteTemplateSyncConfigResult.h>
#include <aws/proton/model/Deployment.h>
#include <aws/proton/model/DeploymentState.h>
#include <aws/proton/model/DeploymentStatus.h>
#include <aws/proton/model/DeploymentSummary.h>
#include <aws/proton/model/DeploymentTargetResourceType.h>
#include <aws/proton/model/DeploymentUpdateType.h>
#include <aws/proton/model/Environment.h>
#include <aws/proton/model/EnvironmentAccountConnection.h>
#include <aws/proton/model/EnvironmentAccountConnectionRequesterAccountType.h>
#include <aws/proton/model/EnvironmentAccountConnectionStatus.h>
#include <aws/proton/model/EnvironmentAccountConnectionSummary.h>
#include <aws/proton/model/EnvironmentState.h>
#include <aws/proton/model/EnvironmentSummary.h>
#include <aws/proton/model/EnvironmentTemplate.h>
#include <aws/proton/model/EnvironmentTemplateFilter.h>
#include <aws/proton/model/EnvironmentTemplateSummary.h>
#include <aws/proton/model/EnvironmentTemplateVersion.h>
#include <aws/proton/model/EnvironmentTemplateVersionSummary.h>
#include <aws/proton/model/GetAccountSettingsRequest.h>
#include <aws/proton/model/GetAccountSettingsResult.h>
#include <aws/proton/model/GetComponentRequest.h>
#include <aws/proton/model/GetComponentResult.h>
#include <aws/proton/model/GetDeploymentRequest.h>
#include <aws/proton/model/GetDeploymentResult.h>
#include <aws/proton/model/GetEnvironmentAccountConnectionRequest.h>
#include <aws/proton/model/GetEnvironmentAccountConnectionResult.h>
#include <aws/proton/model/GetEnvironmentRequest.h>
#include <aws/proton/model/GetEnvironmentResult.h>
#include <aws/proton/model/GetEnvironmentTemplateRequest.h>
#include <aws/proton/model/GetEnvironmentTemplateResult.h>
#include <aws/proton/model/GetEnvironmentTemplateVersionRequest.h>
#include <aws/proton/model/GetEnvironmentTemplateVersionResult.h>
#include <aws/proton/model/GetRepositoryRequest.h>
#include <aws/proton/model/GetRepositoryResult.h>
#include <aws/proton/model/GetRepositorySyncStatusRequest.h>
#include <aws/proton/model/GetRepositorySyncStatusResult.h>
#include <aws/proton/model/GetResourcesSummaryRequest.h>
#include <aws/proton/model/GetResourcesSummaryResult.h>
#include <aws/proton/model/GetServiceInstanceRequest.h>
#include <aws/proton/model/GetServiceInstanceResult.h>
#include <aws/proton/model/GetServiceInstanceSyncStatusRequest.h>
#include <aws/proton/model/GetServiceInstanceSyncStatusResult.h>
#include <aws/proton/model/GetServiceRequest.h>
#include <aws/proton/model/GetServiceResult.h>
#include <aws/proton/model/GetServiceSyncBlockerSummaryRequest.h>
#include <aws/proton/model/GetServiceSyncBlockerSummaryResult.h>
#include <aws/proton/model/GetServiceSyncConfigRequest.h>
#include <aws/proton/model/GetServiceSyncConfigResult.h>
#include <aws/proton/model/GetServiceTemplateRequest.h>
#include <aws/proton/model/GetServiceTemplateResult.h>
#include <aws/proton/model/GetServiceTemplateVersionRequest.h>
#include <aws/proton/model/GetServiceTemplateVersionResult.h>
#include <aws/proton/model/GetTemplateSyncConfigRequest.h>
#include <aws/proton/model/GetTemplateSyncConfigResult.h>
#include <aws/proton/model/GetTemplateSyncStatusRequest.h>
#include <aws/proton/model/GetTemplateSyncStatusResult.h>
#include <aws/proton/model/ListComponentOutputsRequest.h>
#include <aws/proton/model/ListComponentOutputsResult.h>
#include <aws/proton/model/ListComponentProvisionedResourcesRequest.h>
#include <aws/proton/model/ListComponentProvisionedResourcesResult.h>
#include <aws/proton/model/ListComponentsRequest.h>
#include <aws/proton/model/ListComponentsResult.h>
#include <aws/proton/model/ListDeploymentsRequest.h>
#include <aws/proton/model/ListDeploymentsResult.h>
#include <aws/proton/model/ListEnvironmentAccountConnectionsRequest.h>
#include <aws/proton/model/ListEnvironmentAccountConnectionsResult.h>
#include <aws/proton/model/ListEnvironmentOutputsRequest.h>
#include <aws/proton/model/ListEnvironmentOutputsResult.h>
#include <aws/proton/model/ListEnvironmentProvisionedResourcesRequest.h>
#include <aws/proton/model/ListEnvironmentProvisionedResourcesResult.h>
#include <aws/proton/model/ListEnvironmentTemplateVersionsRequest.h>
#include <aws/proton/model/ListEnvironmentTemplateVersionsResult.h>
#include <aws/proton/model/ListEnvironmentTemplatesRequest.h>
#include <aws/proton/model/ListEnvironmentTemplatesResult.h>
#include <aws/proton/model/ListEnvironmentsRequest.h>
#include <aws/proton/model/ListEnvironmentsResult.h>
#include <aws/proton/model/ListRepositoriesRequest.h>
#include <aws/proton/model/ListRepositoriesResult.h>
#include <aws/proton/model/ListRepositorySyncDefinitionsRequest.h>
#include <aws/proton/model/ListRepositorySyncDefinitionsResult.h>
#include <aws/proton/model/ListServiceInstanceOutputsRequest.h>
#include <aws/proton/model/ListServiceInstanceOutputsResult.h>
#include <aws/proton/model/ListServiceInstanceProvisionedResourcesRequest.h>
#include <aws/proton/model/ListServiceInstanceProvisionedResourcesResult.h>
#include <aws/proton/model/ListServiceInstancesFilter.h>
#include <aws/proton/model/ListServiceInstancesFilterBy.h>
#include <aws/proton/model/ListServiceInstancesRequest.h>
#include <aws/proton/model/ListServiceInstancesResult.h>
#include <aws/proton/model/ListServiceInstancesSortBy.h>
#include <aws/proton/model/ListServicePipelineOutputsRequest.h>
#include <aws/proton/model/ListServicePipelineOutputsResult.h>
#include <aws/proton/model/ListServicePipelineProvisionedResourcesRequest.h>
#include <aws/proton/model/ListServicePipelineProvisionedResourcesResult.h>
#include <aws/proton/model/ListServiceTemplateVersionsRequest.h>
#include <aws/proton/model/ListServiceTemplateVersionsResult.h>
#include <aws/proton/model/ListServiceTemplatesRequest.h>
#include <aws/proton/model/ListServiceTemplatesResult.h>
#include <aws/proton/model/ListServicesRequest.h>
#include <aws/proton/model/ListServicesResult.h>
#include <aws/proton/model/ListTagsForResourceRequest.h>
#include <aws/proton/model/ListTagsForResourceResult.h>
#include <aws/proton/model/NotifyResourceDeploymentStatusChangeRequest.h>
#include <aws/proton/model/NotifyResourceDeploymentStatusChangeResult.h>
#include <aws/proton/model/Output.h>
#include <aws/proton/model/ProvisionedResource.h>
#include <aws/proton/model/ProvisionedResourceEngine.h>
#include <aws/proton/model/Provisioning.h>
#include <aws/proton/model/RejectEnvironmentAccountConnectionRequest.h>
#include <aws/proton/model/RejectEnvironmentAccountConnectionResult.h>
#include <aws/proton/model/Repository.h>
#include <aws/proton/model/RepositoryBranch.h>
#include <aws/proton/model/RepositoryBranchInput.h>
#include <aws/proton/model/RepositoryProvider.h>
#include <aws/proton/model/RepositorySummary.h>
#include <aws/proton/model/RepositorySyncAttempt.h>
#include <aws/proton/model/RepositorySyncDefinition.h>
#include <aws/proton/model/RepositorySyncEvent.h>
#include <aws/proton/model/RepositorySyncStatus.h>
#include <aws/proton/model/ResourceCountsSummary.h>
#include <aws/proton/model/ResourceDeploymentStatus.h>
#include <aws/proton/model/ResourceSyncAttempt.h>
#include <aws/proton/model/ResourceSyncEvent.h>
#include <aws/proton/model/ResourceSyncStatus.h>
#include <aws/proton/model/Revision.h>
#include <aws/proton/model/S3ObjectSource.h>
#include <aws/proton/model/Service.h>
#include <aws/proton/model/ServiceInstance.h>
#include <aws/proton/model/ServiceInstanceState.h>
#include <aws/proton/model/ServiceInstanceSummary.h>
#include <aws/proton/model/ServicePipeline.h>
#include <aws/proton/model/ServicePipelineState.h>
#include <aws/proton/model/ServiceStatus.h>
#include <aws/proton/model/ServiceSummary.h>
#include <aws/proton/model/ServiceSyncBlockerSummary.h>
#include <aws/proton/model/ServiceSyncConfig.h>
#include <aws/proton/model/ServiceTemplate.h>
#include <aws/proton/model/ServiceTemplateSummary.h>
#include <aws/proton/model/ServiceTemplateSupportedComponentSourceType.h>
#include <aws/proton/model/ServiceTemplateVersion.h>
#include <aws/proton/model/ServiceTemplateVersionSummary.h>
#include <aws/proton/model/SortOrder.h>
#include <aws/proton/model/SyncBlocker.h>
#include <aws/proton/model/SyncBlockerContext.h>
#include <aws/proton/model/SyncType.h>
#include <aws/proton/model/Tag.h>
#include <aws/proton/model/TagResourceRequest.h>
#include <aws/proton/model/TagResourceResult.h>
#include <aws/proton/model/TemplateSyncConfig.h>
#include <aws/proton/model/TemplateType.h>
#include <aws/proton/model/TemplateVersionSourceInput.h>
#include <aws/proton/model/TemplateVersionStatus.h>
#include <aws/proton/model/UntagResourceRequest.h>
#include <aws/proton/model/UntagResourceResult.h>
#include <aws/proton/model/UpdateAccountSettingsRequest.h>
#include <aws/proton/model/UpdateAccountSettingsResult.h>
#include <aws/proton/model/UpdateComponentRequest.h>
#include <aws/proton/model/UpdateComponentResult.h>
#include <aws/proton/model/UpdateEnvironmentAccountConnectionRequest.h>
#include <aws/proton/model/UpdateEnvironmentAccountConnectionResult.h>
#include <aws/proton/model/UpdateEnvironmentRequest.h>
#include <aws/proton/model/UpdateEnvironmentResult.h>
#include <aws/proton/model/UpdateEnvironmentTemplateRequest.h>
#include <aws/proton/model/UpdateEnvironmentTemplateResult.h>
#include <aws/proton/model/UpdateEnvironmentTemplateVersionRequest.h>
#include <aws/proton/model/UpdateEnvironmentTemplateVersionResult.h>
#include <aws/proton/model/UpdateServiceInstanceRequest.h>
#include <aws/proton/model/UpdateServiceInstanceResult.h>
#include <aws/proton/model/UpdateServicePipelineRequest.h>
#include <aws/proton/model/UpdateServicePipelineResult.h>
#include <aws/proton/model/UpdateServiceRequest.h>
#include <aws/proton/model/UpdateServiceResult.h>
#include <aws/proton/model/UpdateServiceSyncBlockerRequest.h>
#include <aws/proton/model/UpdateServiceSyncBlockerResult.h>
#include <aws/proton/model/UpdateServiceSyncConfigRequest.h>
#include <aws/proton/model/UpdateServiceSyncConfigResult.h>
#include <aws/proton/model/UpdateServiceTemplateRequest.h>
#include <aws/proton/model/UpdateServiceTemplateResult.h>
#include <aws/proton/model/UpdateServiceTemplateVersionRequest.h>
#include <aws/proton/model/UpdateServiceTemplateVersionResult.h>
#include <aws/proton/model/UpdateTemplateSyncConfigRequest.h>
#include <aws/proton/model/UpdateTemplateSyncConfigResult.h>

using ProtonIncludeTest = ::testing::Test;

TEST_F(ProtonIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::Proton::ProtonClient>("ProtonIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
