/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/qbusiness/QBusinessClient.h>
#include <aws/qbusiness/QBusinessEndpointProvider.h>
#include <aws/qbusiness/QBusinessEndpointRules.h>
#include <aws/qbusiness/QBusinessErrorMarshaller.h>
#include <aws/qbusiness/QBusinessErrors.h>
#include <aws/qbusiness/QBusinessRequest.h>
#include <aws/qbusiness/QBusinessServiceClientModel.h>
#include <aws/qbusiness/QBusiness_EXPORTS.h>
#include <aws/qbusiness/model/APISchema.h>
#include <aws/qbusiness/model/APISchemaType.h>
#include <aws/qbusiness/model/AccessConfiguration.h>
#include <aws/qbusiness/model/AccessControl.h>
#include <aws/qbusiness/model/ActionConfiguration.h>
#include <aws/qbusiness/model/ActionExecution.h>
#include <aws/qbusiness/model/ActionExecutionEvent.h>
#include <aws/qbusiness/model/ActionExecutionPayloadField.h>
#include <aws/qbusiness/model/ActionFilterConfiguration.h>
#include <aws/qbusiness/model/ActionPayloadFieldType.h>
#include <aws/qbusiness/model/ActionReview.h>
#include <aws/qbusiness/model/ActionReviewEvent.h>
#include <aws/qbusiness/model/ActionReviewPayloadField.h>
#include <aws/qbusiness/model/ActionReviewPayloadFieldAllowedValue.h>
#include <aws/qbusiness/model/ActionSummary.h>
#include <aws/qbusiness/model/Application.h>
#include <aws/qbusiness/model/ApplicationStatus.h>
#include <aws/qbusiness/model/AppliedAttachmentsConfiguration.h>
#include <aws/qbusiness/model/AppliedCreatorModeConfiguration.h>
#include <aws/qbusiness/model/AppliedOrchestrationConfiguration.h>
#include <aws/qbusiness/model/AssociatePermissionRequest.h>
#include <aws/qbusiness/model/AssociatePermissionResult.h>
#include <aws/qbusiness/model/AssociatedGroup.h>
#include <aws/qbusiness/model/AssociatedUser.h>
#include <aws/qbusiness/model/Attachment.h>
#include <aws/qbusiness/model/AttachmentInput.h>
#include <aws/qbusiness/model/AttachmentInputEvent.h>
#include <aws/qbusiness/model/AttachmentOutput.h>
#include <aws/qbusiness/model/AttachmentStatus.h>
#include <aws/qbusiness/model/AttachmentsConfiguration.h>
#include <aws/qbusiness/model/AttachmentsControlMode.h>
#include <aws/qbusiness/model/AttributeFilter.h>
#include <aws/qbusiness/model/AttributeType.h>
#include <aws/qbusiness/model/AttributeValueOperator.h>
#include <aws/qbusiness/model/AudioExtractionConfiguration.h>
#include <aws/qbusiness/model/AudioExtractionStatus.h>
#include <aws/qbusiness/model/AudioExtractionType.h>
#include <aws/qbusiness/model/AudioSourceDetails.h>
#include <aws/qbusiness/model/AuthChallengeRequest.h>
#include <aws/qbusiness/model/AuthChallengeRequestEvent.h>
#include <aws/qbusiness/model/AuthChallengeResponse.h>
#include <aws/qbusiness/model/AuthChallengeResponseEvent.h>
#include <aws/qbusiness/model/AutoSubscriptionConfiguration.h>
#include <aws/qbusiness/model/AutoSubscriptionStatus.h>
#include <aws/qbusiness/model/BasicAuthConfiguration.h>
#include <aws/qbusiness/model/BatchDeleteDocumentRequest.h>
#include <aws/qbusiness/model/BatchDeleteDocumentResult.h>
#include <aws/qbusiness/model/BatchPutDocumentRequest.h>
#include <aws/qbusiness/model/BatchPutDocumentResult.h>
#include <aws/qbusiness/model/BlockedPhrasesConfiguration.h>
#include <aws/qbusiness/model/BlockedPhrasesConfigurationUpdate.h>
#include <aws/qbusiness/model/BrowserExtension.h>
#include <aws/qbusiness/model/BrowserExtensionConfiguration.h>
#include <aws/qbusiness/model/CancelSubscriptionRequest.h>
#include <aws/qbusiness/model/CancelSubscriptionResult.h>
#include <aws/qbusiness/model/ChatHandler.h>
#include <aws/qbusiness/model/ChatInitialResponse.h>
#include <aws/qbusiness/model/ChatInputStream.h>
#include <aws/qbusiness/model/ChatMode.h>
#include <aws/qbusiness/model/ChatModeConfiguration.h>
#include <aws/qbusiness/model/ChatOutputStream.h>
#include <aws/qbusiness/model/ChatRequest.h>
#include <aws/qbusiness/model/ChatSyncRequest.h>
#include <aws/qbusiness/model/ChatSyncResult.h>
#include <aws/qbusiness/model/CheckDocumentAccessRequest.h>
#include <aws/qbusiness/model/CheckDocumentAccessResult.h>
#include <aws/qbusiness/model/ConfigurationEvent.h>
#include <aws/qbusiness/model/ConflictException.h>
#include <aws/qbusiness/model/ContentBlockerRule.h>
#include <aws/qbusiness/model/ContentRetrievalRule.h>
#include <aws/qbusiness/model/ContentSource.h>
#include <aws/qbusiness/model/ContentType.h>
#include <aws/qbusiness/model/Conversation.h>
#include <aws/qbusiness/model/ConversationSource.h>
#include <aws/qbusiness/model/CopyFromSource.h>
#include <aws/qbusiness/model/CreateAnonymousWebExperienceUrlRequest.h>
#include <aws/qbusiness/model/CreateAnonymousWebExperienceUrlResult.h>
#include <aws/qbusiness/model/CreateApplicationRequest.h>
#include <aws/qbusiness/model/CreateApplicationResult.h>
#include <aws/qbusiness/model/CreateDataAccessorRequest.h>
#include <aws/qbusiness/model/CreateDataAccessorResult.h>
#include <aws/qbusiness/model/CreateDataSourceRequest.h>
#include <aws/qbusiness/model/CreateDataSourceResult.h>
#include <aws/qbusiness/model/CreateIndexRequest.h>
#include <aws/qbusiness/model/CreateIndexResult.h>
#include <aws/qbusiness/model/CreatePluginRequest.h>
#include <aws/qbusiness/model/CreatePluginResult.h>
#include <aws/qbusiness/model/CreateRetrieverRequest.h>
#include <aws/qbusiness/model/CreateRetrieverResult.h>
#include <aws/qbusiness/model/CreateSubscriptionRequest.h>
#include <aws/qbusiness/model/CreateSubscriptionResult.h>
#include <aws/qbusiness/model/CreateUserRequest.h>
#include <aws/qbusiness/model/CreateUserResult.h>
#include <aws/qbusiness/model/CreateWebExperienceRequest.h>
#include <aws/qbusiness/model/CreateWebExperienceResult.h>
#include <aws/qbusiness/model/CreatorModeConfiguration.h>
#include <aws/qbusiness/model/CreatorModeControl.h>
#include <aws/qbusiness/model/CustomPluginConfiguration.h>
#include <aws/qbusiness/model/CustomizationConfiguration.h>
#include <aws/qbusiness/model/DataAccessor.h>
#include <aws/qbusiness/model/DataAccessorAuthenticationConfiguration.h>
#include <aws/qbusiness/model/DataAccessorAuthenticationDetail.h>
#include <aws/qbusiness/model/DataAccessorAuthenticationType.h>
#include <aws/qbusiness/model/DataAccessorIdcTrustedTokenIssuerConfiguration.h>
#include <aws/qbusiness/model/DataSource.h>
#include <aws/qbusiness/model/DataSourceStatus.h>
#include <aws/qbusiness/model/DataSourceSyncJob.h>
#include <aws/qbusiness/model/DataSourceSyncJobMetrics.h>
#include <aws/qbusiness/model/DataSourceSyncJobStatus.h>
#include <aws/qbusiness/model/DataSourceVpcConfiguration.h>
#include <aws/qbusiness/model/DateAttributeBoostingConfiguration.h>
#include <aws/qbusiness/model/DeleteApplicationRequest.h>
#include <aws/qbusiness/model/DeleteApplicationResult.h>
#include <aws/qbusiness/model/DeleteAttachmentRequest.h>
#include <aws/qbusiness/model/DeleteAttachmentResult.h>
#include <aws/qbusiness/model/DeleteChatControlsConfigurationRequest.h>
#include <aws/qbusiness/model/DeleteChatControlsConfigurationResult.h>
#include <aws/qbusiness/model/DeleteConversationRequest.h>
#include <aws/qbusiness/model/DeleteConversationResult.h>
#include <aws/qbusiness/model/DeleteDataAccessorRequest.h>
#include <aws/qbusiness/model/DeleteDataAccessorResult.h>
#include <aws/qbusiness/model/DeleteDataSourceRequest.h>
#include <aws/qbusiness/model/DeleteDataSourceResult.h>
#include <aws/qbusiness/model/DeleteDocument.h>
#include <aws/qbusiness/model/DeleteGroupRequest.h>
#include <aws/qbusiness/model/DeleteGroupResult.h>
#include <aws/qbusiness/model/DeleteIndexRequest.h>
#include <aws/qbusiness/model/DeleteIndexResult.h>
#include <aws/qbusiness/model/DeletePluginRequest.h>
#include <aws/qbusiness/model/DeletePluginResult.h>
#include <aws/qbusiness/model/DeleteRetrieverRequest.h>
#include <aws/qbusiness/model/DeleteRetrieverResult.h>
#include <aws/qbusiness/model/DeleteUserRequest.h>
#include <aws/qbusiness/model/DeleteUserResult.h>
#include <aws/qbusiness/model/DeleteWebExperienceRequest.h>
#include <aws/qbusiness/model/DeleteWebExperienceResult.h>
#include <aws/qbusiness/model/DisassociatePermissionRequest.h>
#include <aws/qbusiness/model/DisassociatePermissionResult.h>
#include <aws/qbusiness/model/Document.h>
#include <aws/qbusiness/model/DocumentAcl.h>
#include <aws/qbusiness/model/DocumentAclCondition.h>
#include <aws/qbusiness/model/DocumentAclGroup.h>
#include <aws/qbusiness/model/DocumentAclMembership.h>
#include <aws/qbusiness/model/DocumentAclUser.h>
#include <aws/qbusiness/model/DocumentAttribute.h>
#include <aws/qbusiness/model/DocumentAttributeBoostingConfiguration.h>
#include <aws/qbusiness/model/DocumentAttributeBoostingLevel.h>
#include <aws/qbusiness/model/DocumentAttributeCondition.h>
#include <aws/qbusiness/model/DocumentAttributeConfiguration.h>
#include <aws/qbusiness/model/DocumentAttributeTarget.h>
#include <aws/qbusiness/model/DocumentAttributeValue.h>
#include <aws/qbusiness/model/DocumentContent.h>
#include <aws/qbusiness/model/DocumentContentOperator.h>
#include <aws/qbusiness/model/DocumentDetails.h>
#include <aws/qbusiness/model/DocumentEnrichmentConditionOperator.h>
#include <aws/qbusiness/model/DocumentEnrichmentConfiguration.h>
#include <aws/qbusiness/model/DocumentStatus.h>
#include <aws/qbusiness/model/EligibleDataSource.h>
#include <aws/qbusiness/model/EncryptionConfiguration.h>
#include <aws/qbusiness/model/EndOfInputEvent.h>
#include <aws/qbusiness/model/ErrorCode.h>
#include <aws/qbusiness/model/ErrorDetail.h>
#include <aws/qbusiness/model/FailedAttachmentEvent.h>
#include <aws/qbusiness/model/FailedDocument.h>
#include <aws/qbusiness/model/GetApplicationRequest.h>
#include <aws/qbusiness/model/GetApplicationResult.h>
#include <aws/qbusiness/model/GetChatControlsConfigurationRequest.h>
#include <aws/qbusiness/model/GetChatControlsConfigurationResult.h>
#include <aws/qbusiness/model/GetDataAccessorRequest.h>
#include <aws/qbusiness/model/GetDataAccessorResult.h>
#include <aws/qbusiness/model/GetDataSourceRequest.h>
#include <aws/qbusiness/model/GetDataSourceResult.h>
#include <aws/qbusiness/model/GetGroupRequest.h>
#include <aws/qbusiness/model/GetGroupResult.h>
#include <aws/qbusiness/model/GetIndexRequest.h>
#include <aws/qbusiness/model/GetIndexResult.h>
#include <aws/qbusiness/model/GetMediaRequest.h>
#include <aws/qbusiness/model/GetMediaResult.h>
#include <aws/qbusiness/model/GetPluginRequest.h>
#include <aws/qbusiness/model/GetPluginResult.h>
#include <aws/qbusiness/model/GetPolicyRequest.h>
#include <aws/qbusiness/model/GetPolicyResult.h>
#include <aws/qbusiness/model/GetRetrieverRequest.h>
#include <aws/qbusiness/model/GetRetrieverResult.h>
#include <aws/qbusiness/model/GetUserRequest.h>
#include <aws/qbusiness/model/GetUserResult.h>
#include <aws/qbusiness/model/GetWebExperienceRequest.h>
#include <aws/qbusiness/model/GetWebExperienceResult.h>
#include <aws/qbusiness/model/GroupMembers.h>
#include <aws/qbusiness/model/GroupStatus.h>
#include <aws/qbusiness/model/GroupStatusDetail.h>
#include <aws/qbusiness/model/GroupSummary.h>
#include <aws/qbusiness/model/HallucinationReductionConfiguration.h>
#include <aws/qbusiness/model/HallucinationReductionControl.h>
#include <aws/qbusiness/model/HookConfiguration.h>
#include <aws/qbusiness/model/IdcAuthConfiguration.h>
#include <aws/qbusiness/model/IdentityProviderConfiguration.h>
#include <aws/qbusiness/model/IdentityType.h>
#include <aws/qbusiness/model/ImageExtractionConfiguration.h>
#include <aws/qbusiness/model/ImageExtractionStatus.h>
#include <aws/qbusiness/model/ImageSourceDetails.h>
#include <aws/qbusiness/model/Index.h>
#include <aws/qbusiness/model/IndexCapacityConfiguration.h>
#include <aws/qbusiness/model/IndexStatistics.h>
#include <aws/qbusiness/model/IndexStatus.h>
#include <aws/qbusiness/model/IndexType.h>
#include <aws/qbusiness/model/InlineDocumentEnrichmentConfiguration.h>
#include <aws/qbusiness/model/KendraIndexConfiguration.h>
#include <aws/qbusiness/model/ListApplicationsRequest.h>
#include <aws/qbusiness/model/ListApplicationsResult.h>
#include <aws/qbusiness/model/ListAttachmentsRequest.h>
#include <aws/qbusiness/model/ListAttachmentsResult.h>
#include <aws/qbusiness/model/ListConversationsRequest.h>
#include <aws/qbusiness/model/ListConversationsResult.h>
#include <aws/qbusiness/model/ListDataAccessorsRequest.h>
#include <aws/qbusiness/model/ListDataAccessorsResult.h>
#include <aws/qbusiness/model/ListDataSourceSyncJobsRequest.h>
#include <aws/qbusiness/model/ListDataSourceSyncJobsResult.h>
#include <aws/qbusiness/model/ListDataSourcesRequest.h>
#include <aws/qbusiness/model/ListDataSourcesResult.h>
#include <aws/qbusiness/model/ListDocumentsRequest.h>
#include <aws/qbusiness/model/ListDocumentsResult.h>
#include <aws/qbusiness/model/ListGroupsRequest.h>
#include <aws/qbusiness/model/ListGroupsResult.h>
#include <aws/qbusiness/model/ListIndicesRequest.h>
#include <aws/qbusiness/model/ListIndicesResult.h>
#include <aws/qbusiness/model/ListMessagesRequest.h>
#include <aws/qbusiness/model/ListMessagesResult.h>
#include <aws/qbusiness/model/ListPluginActionsRequest.h>
#include <aws/qbusiness/model/ListPluginActionsResult.h>
#include <aws/qbusiness/model/ListPluginTypeActionsRequest.h>
#include <aws/qbusiness/model/ListPluginTypeActionsResult.h>
#include <aws/qbusiness/model/ListPluginTypeMetadataRequest.h>
#include <aws/qbusiness/model/ListPluginTypeMetadataResult.h>
#include <aws/qbusiness/model/ListPluginsRequest.h>
#include <aws/qbusiness/model/ListPluginsResult.h>
#include <aws/qbusiness/model/ListRetrieversRequest.h>
#include <aws/qbusiness/model/ListRetrieversResult.h>
#include <aws/qbusiness/model/ListSubscriptionsRequest.h>
#include <aws/qbusiness/model/ListSubscriptionsResult.h>
#include <aws/qbusiness/model/ListTagsForResourceRequest.h>
#include <aws/qbusiness/model/ListTagsForResourceResult.h>
#include <aws/qbusiness/model/ListWebExperiencesRequest.h>
#include <aws/qbusiness/model/ListWebExperiencesResult.h>
#include <aws/qbusiness/model/MediaExtractionConfiguration.h>
#include <aws/qbusiness/model/MemberGroup.h>
#include <aws/qbusiness/model/MemberRelation.h>
#include <aws/qbusiness/model/MemberUser.h>
#include <aws/qbusiness/model/MembershipType.h>
#include <aws/qbusiness/model/Message.h>
#include <aws/qbusiness/model/MessageType.h>
#include <aws/qbusiness/model/MessageUsefulness.h>
#include <aws/qbusiness/model/MessageUsefulnessFeedback.h>
#include <aws/qbusiness/model/MessageUsefulnessReason.h>
#include <aws/qbusiness/model/MetadataEvent.h>
#include <aws/qbusiness/model/NativeIndexConfiguration.h>
#include <aws/qbusiness/model/NoAuthConfiguration.h>
#include <aws/qbusiness/model/NumberAttributeBoostingConfiguration.h>
#include <aws/qbusiness/model/NumberAttributeBoostingType.h>
#include <aws/qbusiness/model/OAuth2ClientCredentialConfiguration.h>
#include <aws/qbusiness/model/OpenIDConnectProviderConfiguration.h>
#include <aws/qbusiness/model/OrchestrationConfiguration.h>
#include <aws/qbusiness/model/OrchestrationControl.h>
#include <aws/qbusiness/model/PermissionCondition.h>
#include <aws/qbusiness/model/PermissionConditionOperator.h>
#include <aws/qbusiness/model/PersonalizationConfiguration.h>
#include <aws/qbusiness/model/PersonalizationControlMode.h>
#include <aws/qbusiness/model/Plugin.h>
#include <aws/qbusiness/model/PluginAuthConfiguration.h>
#include <aws/qbusiness/model/PluginBuildStatus.h>
#include <aws/qbusiness/model/PluginConfiguration.h>
#include <aws/qbusiness/model/PluginState.h>
#include <aws/qbusiness/model/PluginType.h>
#include <aws/qbusiness/model/PluginTypeCategory.h>
#include <aws/qbusiness/model/PluginTypeMetadataSummary.h>
#include <aws/qbusiness/model/Principal.h>
#include <aws/qbusiness/model/PrincipalGroup.h>
#include <aws/qbusiness/model/PrincipalUser.h>
#include <aws/qbusiness/model/PutFeedbackRequest.h>
#include <aws/qbusiness/model/PutGroupRequest.h>
#include <aws/qbusiness/model/PutGroupResult.h>
#include <aws/qbusiness/model/QAppsConfiguration.h>
#include <aws/qbusiness/model/QAppsControlMode.h>
#include <aws/qbusiness/model/QuickSightConfiguration.h>
#include <aws/qbusiness/model/ReadAccessType.h>
#include <aws/qbusiness/model/RelevantContent.h>
#include <aws/qbusiness/model/ResourceNotFoundException.h>
#include <aws/qbusiness/model/ResponseScope.h>
#include <aws/qbusiness/model/Retriever.h>
#include <aws/qbusiness/model/RetrieverConfiguration.h>
#include <aws/qbusiness/model/RetrieverContentSource.h>
#include <aws/qbusiness/model/RetrieverStatus.h>
#include <aws/qbusiness/model/RetrieverType.h>
#include <aws/qbusiness/model/Rule.h>
#include <aws/qbusiness/model/RuleConfiguration.h>
#include <aws/qbusiness/model/RuleType.h>
#include <aws/qbusiness/model/S3.h>
#include <aws/qbusiness/model/SamlConfiguration.h>
#include <aws/qbusiness/model/SamlProviderConfiguration.h>
#include <aws/qbusiness/model/ScoreAttributes.h>
#include <aws/qbusiness/model/ScoreConfidence.h>
#include <aws/qbusiness/model/SearchRelevantContentRequest.h>
#include <aws/qbusiness/model/SearchRelevantContentResult.h>
#include <aws/qbusiness/model/ServiceQuotaExceededException.h>
#include <aws/qbusiness/model/SnippetExcerpt.h>
#include <aws/qbusiness/model/SourceAttribution.h>
#include <aws/qbusiness/model/SourceDetails.h>
#include <aws/qbusiness/model/StartDataSourceSyncJobRequest.h>
#include <aws/qbusiness/model/StartDataSourceSyncJobResult.h>
#include <aws/qbusiness/model/Status.h>
#include <aws/qbusiness/model/StopDataSourceSyncJobRequest.h>
#include <aws/qbusiness/model/StopDataSourceSyncJobResult.h>
#include <aws/qbusiness/model/StringAttributeBoostingConfiguration.h>
#include <aws/qbusiness/model/StringAttributeValueBoostingLevel.h>
#include <aws/qbusiness/model/StringListAttributeBoostingConfiguration.h>
#include <aws/qbusiness/model/Subscription.h>
#include <aws/qbusiness/model/SubscriptionDetails.h>
#include <aws/qbusiness/model/SubscriptionPrincipal.h>
#include <aws/qbusiness/model/SubscriptionType.h>
#include <aws/qbusiness/model/SystemMessageType.h>
#include <aws/qbusiness/model/Tag.h>
#include <aws/qbusiness/model/TagResourceRequest.h>
#include <aws/qbusiness/model/TagResourceResult.h>
#include <aws/qbusiness/model/TextDocumentStatistics.h>
#include <aws/qbusiness/model/TextInputEvent.h>
#include <aws/qbusiness/model/TextOutputEvent.h>
#include <aws/qbusiness/model/TextSegment.h>
#include <aws/qbusiness/model/TopicConfiguration.h>
#include <aws/qbusiness/model/UntagResourceRequest.h>
#include <aws/qbusiness/model/UntagResourceResult.h>
#include <aws/qbusiness/model/UpdateApplicationRequest.h>
#include <aws/qbusiness/model/UpdateApplicationResult.h>
#include <aws/qbusiness/model/UpdateChatControlsConfigurationRequest.h>
#include <aws/qbusiness/model/UpdateChatControlsConfigurationResult.h>
#include <aws/qbusiness/model/UpdateDataAccessorRequest.h>
#include <aws/qbusiness/model/UpdateDataAccessorResult.h>
#include <aws/qbusiness/model/UpdateDataSourceRequest.h>
#include <aws/qbusiness/model/UpdateDataSourceResult.h>
#include <aws/qbusiness/model/UpdateIndexRequest.h>
#include <aws/qbusiness/model/UpdateIndexResult.h>
#include <aws/qbusiness/model/UpdatePluginRequest.h>
#include <aws/qbusiness/model/UpdatePluginResult.h>
#include <aws/qbusiness/model/UpdateRetrieverRequest.h>
#include <aws/qbusiness/model/UpdateRetrieverResult.h>
#include <aws/qbusiness/model/UpdateSubscriptionRequest.h>
#include <aws/qbusiness/model/UpdateSubscriptionResult.h>
#include <aws/qbusiness/model/UpdateUserRequest.h>
#include <aws/qbusiness/model/UpdateUserResult.h>
#include <aws/qbusiness/model/UpdateWebExperienceRequest.h>
#include <aws/qbusiness/model/UpdateWebExperienceResult.h>
#include <aws/qbusiness/model/UserAlias.h>
#include <aws/qbusiness/model/UsersAndGroups.h>
#include <aws/qbusiness/model/ValidationException.h>
#include <aws/qbusiness/model/ValidationExceptionField.h>
#include <aws/qbusiness/model/ValidationExceptionReason.h>
#include <aws/qbusiness/model/VideoExtractionConfiguration.h>
#include <aws/qbusiness/model/VideoExtractionStatus.h>
#include <aws/qbusiness/model/VideoExtractionType.h>
#include <aws/qbusiness/model/VideoSourceDetails.h>
#include <aws/qbusiness/model/WebExperience.h>
#include <aws/qbusiness/model/WebExperienceSamplePromptsControlMode.h>
#include <aws/qbusiness/model/WebExperienceStatus.h>

using QBusinessIncludeTest = ::testing::Test;

TEST_F(QBusinessIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::QBusiness::QBusinessClient>("QBusinessIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
